!     ############################
      MODULE MODD_DIAG_CUMUL_TEB_n
!     ############################
!
!!****  *MODD_DIAG_CUMUL_TEB - declaration of cumulated surface parameters for TEB scheme
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      C de Munck   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       19/02/2013
!
!       M. Goret       19/07/2017 : add energy consumption of heating by source
!       M. Goret       19/10/2017 : add hot water
!
!
!*       0.   DECLARATIONS
!             ------------
!
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE

!TYPE DIAG_CUMUL_TEB_OPTIONS_t
!------------------------------------------------------------------------------
!
!  LOGICAL :: LTEB_CUM   ! flag for cumulated terms of teb scheme
!
!------------------------------------------------------------------------------
!END TYPE DIAG_CUMUL_TEB_OPTIONS_t
!
TYPE DIAG_CUMUL_TEB_1P_t
!------------------------------------------------------------------------------
!* miscellaneous variables
!
  REAL, POINTER, DIMENSION(:)   :: XRUNOFFC_TOWN      ! cumulateda ggregated water runoff for town      (kg/m2 town/s)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFFC_GARDEN    ! cumulated water runoff for green areas          (kg/m2 garden/s)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFFC_ROAD      ! cumulated water runoff for roads                (kg/m2 road/s)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFFC_ROOF      ! cumulated aggregated water runoff for roofs     (kg/m2 roof/s)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFFC_STRLROOF  ! cumulated water runoff for structural roofs     (kg/m2 structural roof/s)
  REAL, POINTER, DIMENSION(:)   :: XRUNOFFC_GREENROOF ! cumulated water runoff for greenroof            (kg/m2 greenroof/s)
!*** KC ***
  REAL, POINTER, DIMENSION(:)   :: XRUNOFFC_SEWER     ! cumulated groundwater runoff into the sewers (kg/m2)
!***
  REAL, POINTER, DIMENSION(:)   :: XDRAINC_GREENROOF  ! cumulated water vertical drainage for greenroof (kg/m2 greenroof/s)
  REAL, POINTER, DIMENSION(:)   :: XDRAINC_GARDEN     ! cumulated water vertical drainage for gardens   (kg/m2 garden/s)
  REAL, POINTER, DIMENSION(:)   :: XIRRIGC_GREENROOF  ! cumulated water supply from summer irrigation   (kg/m2 greenroof/s)
  REAL, POINTER, DIMENSION(:)   :: XIRRIGC_GARDEN     ! cumulated water supply from summer irrigation   (kg/m2 garden/s)
  REAL, POINTER, DIMENSION(:)   :: XIRRIGC_ROAD       ! cumulated water supply from summer irrigation   (kg/m2 road/s)
  !
  REAL, POINTER, DIMENSION(:)   :: XHVACC_COOL        ! cumulated en. consump. of the cooling system [J m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XHVACC_HEAT        ! cumulated en. consump. of the heating system [J m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XHVACC_HEAT_ELEC   ! elec. part of XHVACC_HEAT [J m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XHVACC_HEAT_GAS    ! gas   part of XHVACC_HEAT [J m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XHVACC_HEAT_FUEL   ! fuel  part of XHVACC_HEAT [J m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XHVACC_HEAT_OTHER  ! other part of XHVACC_HEAT [J m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XQINOUTCUM         ! cumulated actual internal energy release [J m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XTHER_PROD_BLDC    ! cumulated en. product. of thermal      solar panels [W m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XPHOT_PROD_BLDC    ! cumulated en. product. of photovoltaic solar panels [W m-2(bld)]
!
  REAL, POINTER, DIMENSION(:)   :: XHOTWATC           ! cumulated en. consumption for hot water [W m-2(urb)]
  REAL, POINTER, DIMENSION(:)   :: XHOTWATC_GAS       ! cumulated gas consumption for hot water [W m-2(urb)]
  REAL, POINTER, DIMENSION(:)   :: XHOTWATC_ELEC      ! cumulated elec consumption for hot water [W m-2(urb)]
!
!------------------------------------------------------------------------------
END TYPE DIAG_CUMUL_TEB_1P_t

TYPE DIAG_CUMUL_TEB_t
  !
  TYPE(DIAG_CUMUL_TEB_1P_t), POINTER :: ALP(:) => NULL()
  TYPE(DIAG_CUMUL_TEB_1P_t), POINTER :: CUR => NULL()
  !
END TYPE DIAG_CUMUL_TEB_t




CONTAINS
!
!------------------------------------------------------------------------------
!
!------------------------------------------------------------------------------
!
!



!
SUBROUTINE DIAG_CUMUL_TEB_GOTO_PATCH(YDIAG_CUMUL_TEB,KTO_PATCH)
TYPE(DIAG_CUMUL_TEB_t), INTENT(INOUT) :: YDIAG_CUMUL_TEB
INTEGER, INTENT(IN) :: KTO_PATCH
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
! Current patch is set to patch KTO_PATCH
IF (LHOOK) CALL DR_HOOK('MODD_DIAG_CUMUL_TEB_N:DIAG_CUMUL_TEB_GOTO_PATCH',0,ZHOOK_HANDLE)

YDIAG_CUMUL_TEB%CUR => YDIAG_CUMUL_TEB%ALP(KTO_PATCH)

IF (LHOOK) CALL DR_HOOK('MODD_DIAG_CUMUL_TEB_N:DIAG_CUMUL_TEB_GOTO_PATCH',1,ZHOOK_HANDLE)

END SUBROUTINE DIAG_CUMUL_TEB_GOTO_PATCH
!
!------------------------------------------------------------------------------
!
SUBROUTINE DIAG_CUMUL_TEB_INIT(YDIAG_CUMUL_TEB,KPATCH)
TYPE(DIAG_CUMUL_TEB_t), INTENT(INOUT) :: YDIAG_CUMUL_TEB
INTEGER, INTENT(IN) :: KPATCH
INTEGER :: JP
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_DIAG_CUMUL_TEB_N:DIAG_CUMUL_TEB_INIT",0,ZHOOK_HANDLE)
  ALLOCATE(YDIAG_CUMUL_TEB%ALP(KPATCH))
  YDIAG_CUMUL_TEB%CUR => YDIAG_CUMUL_TEB%ALP(1)
DO JP=1,KPATCH
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XRUNOFFC_TOWN)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XRUNOFFC_GARDEN)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XRUNOFFC_ROAD)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XRUNOFFC_ROOF)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XRUNOFFC_STRLROOF)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XRUNOFFC_GREENROOF)
!*** KC ***
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XRUNOFFC_SEWER)
!***
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XDRAINC_GREENROOF)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XDRAINC_GARDEN)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XIRRIGC_GREENROOF)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XIRRIGC_GARDEN)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XIRRIGC_ROAD)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XHVACC_COOL)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XHVACC_HEAT)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XQINOUTCUM)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XTHER_PROD_BLDC)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XPHOT_PROD_BLDC)
!
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XHVACC_HEAT_ELEC)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XHVACC_HEAT_GAS)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XHVACC_HEAT_FUEL)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XHVACC_HEAT_OTHER)
!
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XHOTWATC)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XHOTWATC_ELEC)
  NULLIFY(YDIAG_CUMUL_TEB%ALP(JP)%XHOTWATC_GAS)
ENDDO 
IF (LHOOK) CALL DR_HOOK("MODD_DIAG_CUMUL_TEB_N:DIAG_CUMUL_TEB_INIT",1,ZHOOK_HANDLE)
END SUBROUTINE DIAG_CUMUL_TEB_INIT
!
!------------------------------------------------------------------------------
!
!
!------------------------------------------------------------------------------

END MODULE MODD_DIAG_CUMUL_TEB_n
