!     ################
      MODULE MODD_DATA_BEM_n
!     ################
!
!!****  *MODD_DATA_BEM_n - declaration of surface parameters for BEM
!!
!!    PURPOSE
!!    -------
!     Declaration of surface parameters
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      G. Pigeon   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       08/2011
!!      M. Goret       02/2017 add heat source fractions
!!      M. Goret       10/2017 add hot water
!
!*       0.   DECLARATIONS
!             ------------
!
USE MODD_SURF_PAR,   ONLY : XUNDEF
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
TYPE DATA_BEM_t
  !
  !  Logical for presence of variables in the namelist
  !
  LOGICAL :: LDATA_RESIDENTIAL   
  LOGICAL :: LDATA_FRACOMP
  LOGICAL :: LDATA_F_WASTE_CAN   
  LOGICAL :: LDATA_HC_FLOOR     
  LOGICAL :: LDATA_TC_FLOOR     
  LOGICAL :: LDATA_D_FLOOR 
  LOGICAL :: LDATA_HC_MASS     
  LOGICAL :: LDATA_TC_MASS     
  LOGICAL :: LDATA_D_MASS 
  LOGICAL :: LDATA_QIN          
  LOGICAL :: LDATA_QIN_FRAD     
  LOGICAL :: LDATA_THEAT_OCCD
  LOGICAL :: LDATA_THEAT_OCCN
  LOGICAL :: LDATA_THEAT_VCDD
  LOGICAL :: LDATA_THEAT_VCDN
  LOGICAL :: LDATA_THEAT_VCLD
  LOGICAL :: LDATA_TCOOL_OCCD
  LOGICAL :: LDATA_TCOOL_OCCN
  LOGICAL :: LDATA_TCOOL_VCDD
  LOGICAL :: LDATA_TCOOL_VCDN
  LOGICAL :: LDATA_TCOOL_VCLD
  LOGICAL :: LDATA_SHGC         
  LOGICAL :: LDATA_U_WIN        
  LOGICAL :: LDATA_GR           
  LOGICAL :: LDATA_SHGC_SH
  LOGICAL :: LDATA_FLOOR_HEIGHT 
  LOGICAL :: LDATA_ISMASS
  LOGICAL :: LDATA_N50  
  LOGICAL :: LDATA_F_WATER_COND  
  LOGICAL :: LDATA_ISMECH
  LOGICAL :: LDATA_MECHRATE
  LOGICAL :: LDATA_SHADEARCHI
  LOGICAL :: LDATA_NATVENT
  LOGICAL :: LDATA_QIN_FLAT 
  LOGICAL :: LDATA_HR_TARGET
  LOGICAL :: LDATA_CAP_SYS_HEAT 
  LOGICAL :: LDATA_CAP_SYS_RAT  
  LOGICAL :: LDATA_T_ADP        
  LOGICAL :: LDATA_M_SYS_RAT    
  LOGICAL :: LDATA_COP_RAT      
  LOGICAL :: LDATA_T_SIZE_MAX    
  LOGICAL :: LDATA_T_SIZE_MIN  
  LOGICAL :: LDATA_FSNIG
  LOGICAL :: LDATA_FVNIG
  LOGICAL :: LDATA_MODQIN_VCD
  LOGICAL :: LDATA_MODQIN_VLD
  LOGICAL :: LDATA_MODQIN_NIG
  LOGICAL :: LDATA_TDESV
  LOGICAL :: LDATA_WIN_SW_MAX
  LOGICAL :: LDATA_FOPEN
  LOGICAL :: LDATA_FVSUM
  LOGICAL :: LDATA_FVVAC
  LOGICAL :: LDATA_FSSUM
  LOGICAL :: LDATA_FSVAC
  LOGICAL :: LDATA_BEG_HOLIDAY
  LOGICAL :: LDATA_END_HOLIDAY
  LOGICAL :: LDATA_MOD_HOLIDAY
  LOGICAL :: LDATA_DAYWBEG_SCHED
  LOGICAL :: LDATA_HOURBEG_SCHED
  LOGICAL :: LDATA_PROBOCC
  LOGICAL :: LDATA_FRAC_HEAT_ELEC   ! Fraction of electric heating
  LOGICAL :: LDATA_FRAC_HEAT_GAS    ! Fraction of gas heating
  LOGICAL :: LDATA_FRAC_HEAT_FUEL   ! Fraction of fuel heating
  LOGICAL :: LDATA_FRAC_HEAT_OTHER  ! Fraction of other heating
  LOGICAL :: LDATA_FRAC_HEAT        ! True if heating fraction are provided
  LOGICAL :: LDATA_HOTWAT           ! Energy needed for hot water [W m-2(floor)]
  LOGICAL :: LDATA_F_HW_GAS         ! fraction of water heat by gas
!
! Number of layers in the specification of thermal characteristics
!
  INTEGER :: NPAR_FLOOR_LAYER   ! number of layers in roofs
  INTEGER :: NPAR_MASS_LAYER    ! number of layers in roofs
  INTEGER :: NPAR_DAY_SCHED     ! Number of schedule days
  INTEGER :: NPAR_CRE_SCHED     ! Number of schedules per day
  INTEGER :: NPAR_HOLIDAY       ! Number of holidays
!
!
! Parameters:
!
  REAL, POINTER, DIMENSION(:) :: XPAR_RESIDENTIAL  ! Residential fraction (for solar panels) 
  REAL, POINTER, DIMENSION(:,:) :: XPAR_FRACOMP      ! Fraction of compartments in bem
  REAL, POINTER, DIMENSION(:)   :: XPAR_F_WASTE_CAN  ! fraction of waste heat into the canyon
  REAL, POINTER, DIMENSION(:,:) :: XPAR_HC_FLOOR     ! heat capacity of floor layers [J m-3 K-1]
  REAL, POINTER, DIMENSION(:,:) :: XPAR_TC_FLOOR     ! thermal conductivity of floor layers [W m-1 K-1]
  REAL, POINTER, DIMENSION(:,:) :: XPAR_D_FLOOR      ! thickness of floor layers [m]
  REAL, POINTER, DIMENSION(:,:) :: XPAR_HC_MASS      ! heat capacity of floor layers [J m-3 K-1]
  REAL, POINTER, DIMENSION(:,:) :: XPAR_TC_MASS      ! thermal conductivity of floor layers [W m-1 K-1]
  REAL, POINTER, DIMENSION(:,:) :: XPAR_D_MASS       ! thickness of floor layers [m]
  REAL, POINTER, DIMENSION(:,:) :: XPAR_QIN          ! internal heat gains [W m-2(floor)]
  REAL, POINTER, DIMENSION(:)   :: XPAR_QIN_FRAD     ! radiant fraction of internal heat gains
  REAL, POINTER, DIMENSION(:)   :: XPAR_SHGC         ! solar transmitance of windows
  REAL, POINTER, DIMENSION(:)   :: XPAR_U_WIN        ! glazing thermal resistance [K m W-2]
  REAL, POINTER, DIMENSION(:)   :: XPAR_GR           ! glazing ratio
  REAL, POINTER, DIMENSION(:)   :: XPAR_SHGC_SH      ! solar transmitance of windows + shading
  REAL, POINTER, DIMENSION(:)   :: XPAR_FLOOR_HEIGHT ! building floor height [m]
  REAL, POINTER, DIMENSION(:)   :: XPAR_ISMASS       ! Presence of internal mass
  REAL, POINTER, DIMENSION(:)   :: XPAR_N50          ! infiltration/ventilation flow rate [AC/H]
!
  REAL, POINTER, DIMENSION(:)   :: XPAR_F_WATER_COND ! fraction of evaporation for condensers
  REAL, POINTER, DIMENSION(:)   :: XPAR_ISMECH       ! Presence of mechanical ventilation (architectural characteristic)
  REAL, POINTER, DIMENSION(:)   :: XPAR_MECHRATE     ! Exchange rate due to mechanical ventilation [1/h] (architectural characteristic)
  REAL, POINTER, DIMENSION(:)   :: XPAR_SHADEARCHI   ! Are shading devices present (architectural characteristic)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_NATVENT      ! Flag to describe bld surventilation solution 0-> NONE ; 1 -> MANU ; 2-> AUTO
  REAL, POINTER, DIMENSION(:)   :: XPAR_QIN_FLAT     ! Latent franction of internal heat gains
  REAL, POINTER, DIMENSION(:)   :: XPAR_HR_TARGET    ! Relative humidity setpoint
  REAL, POINTER, DIMENSION(:)   :: XPAR_CAP_SYS_HEAT ! Capacity of the heating system 
                                                     ! [W m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XPAR_CAP_SYS_RAT  ! Rated capacity of the cooling system
                                                     ! [W m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XPAR_T_ADP        ! Apparatus dewpoint temperature of the
                                                     ! cooling coil [K]
  REAL, POINTER, DIMENSION(:)   :: XPAR_M_SYS_RAT    ! Rated HVAC mass flow rate 
                                                     ! [kg s-1 m-2(bld)]
  REAL, POINTER, DIMENSION(:)   :: XPAR_COP_RAT      ! Rated COP of the cooling system
  REAL, POINTER, DIMENSION(:)   :: XPAR_T_SIZE_MAX   ! 
  REAL, POINTER, DIMENSION(:)   :: XPAR_T_SIZE_MIN   ! 
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_FSNIG
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_FVNIG
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_MODQIN_VCD
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_MODQIN_VLD
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_MODQIN_NIG
  REAL, POINTER, DIMENSION(:)   :: XPAR_TDESV
  REAL, POINTER, DIMENSION(:)   :: XPAR_WIN_SW_MAX
  REAL, POINTER, DIMENSION(:)   :: XPAR_FOPEN
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_FVSUM
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_FVVAC
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_FSSUM
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_FSVAC
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_TCOOL_OCCD
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_TCOOL_OCCN
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_TCOOL_VCDD
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_TCOOL_VCDN
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_TCOOL_VCLD
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_THEAT_OCCD
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_THEAT_OCCN
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_THEAT_VCDD
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_THEAT_VCDN
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_THEAT_VCLD
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_BEG_HOLIDAY
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_END_HOLIDAY
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_MOD_HOLIDAY
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_DAYWBEG_SCHED
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_HOURBEG_SCHED
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_PROBOCC

  !heating fractions and convertion factors for CO2 flux
  REAL, POINTER, DIMENSION(:) :: XPAR_FRAC_HEAT_ELEC   !Fraction of electric heating
  REAL, POINTER, DIMENSION(:) :: XPAR_FRAC_HEAT_GAS    !Fraction of gas heating
  REAL, POINTER, DIMENSION(:) :: XPAR_FRAC_HEAT_FUEL   !Fraction of fuel heating
  REAL, POINTER, DIMENSION(:) :: XPAR_FRAC_HEAT_OTHER  !Fraction of other heating
  REAL, POINTER, DIMENSION(:,:) :: XPAR_HOTWAT           ! Energy needed for hot water [W m-2(floor)]
  REAL, POINTER, DIMENSION(:) :: XPAR_F_HW_GAS         ! fraction of water heat by gas
!
END TYPE DATA_BEM_t



CONTAINS

!
!
!
!
SUBROUTINE DATA_BEM_INIT(YDATA_BEM)
TYPE(DATA_BEM_t), INTENT(INOUT) :: YDATA_BEM
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_DATA_BEM_N:DATA_BEM_INIT",0,ZHOOK_HANDLE)
  NULLIFY(YDATA_BEM%XPAR_RESIDENTIAL)  
  NULLIFY(YDATA_BEM%XPAR_FRACOMP)  
  NULLIFY(YDATA_BEM%XPAR_F_WASTE_CAN)  
  NULLIFY(YDATA_BEM%XPAR_HC_FLOOR)
  NULLIFY(YDATA_BEM%XPAR_TC_FLOOR)
  NULLIFY(YDATA_BEM%XPAR_D_FLOOR)
  NULLIFY(YDATA_BEM%XPAR_HC_MASS)
  NULLIFY(YDATA_BEM%XPAR_TC_MASS)
  NULLIFY(YDATA_BEM%XPAR_D_MASS)
  NULLIFY(YDATA_BEM%XPAR_TCOOL_OCCD)
  NULLIFY(YDATA_BEM%XPAR_TCOOL_OCCN)
  NULLIFY(YDATA_BEM%XPAR_TCOOL_VCDD)
  NULLIFY(YDATA_BEM%XPAR_TCOOL_VCDN)
  NULLIFY(YDATA_BEM%XPAR_TCOOL_VCLD)
  NULLIFY(YDATA_BEM%XPAR_THEAT_OCCD)
  NULLIFY(YDATA_BEM%XPAR_THEAT_OCCN)
  NULLIFY(YDATA_BEM%XPAR_THEAT_VCDD)
  NULLIFY(YDATA_BEM%XPAR_THEAT_VCDN)
  NULLIFY(YDATA_BEM%XPAR_THEAT_VCLD)
  NULLIFY(YDATA_BEM%XPAR_QIN)
  NULLIFY(YDATA_BEM%XPAR_QIN_FRAD)
  NULLIFY(YDATA_BEM%XPAR_SHGC) 
  NULLIFY(YDATA_BEM%XPAR_U_WIN)
  NULLIFY(YDATA_BEM%XPAR_GR)
  NULLIFY(YDATA_BEM%XPAR_SHGC_SH)
  NULLIFY(YDATA_BEM%XPAR_FLOOR_HEIGHT)
  NULLIFY(YDATA_BEM%XPAR_ISMASS)
  NULLIFY(YDATA_BEM%XPAR_N50)
  NULLIFY(YDATA_BEM%XPAR_F_WATER_COND)
  NULLIFY(YDATA_BEM%XPAR_QIN_FLAT)
  NULLIFY(YDATA_BEM%XPAR_HR_TARGET)
  NULLIFY(YDATA_BEM%XPAR_CAP_SYS_HEAT)
  NULLIFY(YDATA_BEM%XPAR_CAP_SYS_RAT)
  NULLIFY(YDATA_BEM%XPAR_T_ADP)
  NULLIFY(YDATA_BEM%XPAR_M_SYS_RAT)
  NULLIFY(YDATA_BEM%XPAR_COP_RAT)
  NULLIFY(YDATA_BEM%XPAR_T_SIZE_MAX)
  NULLIFY(YDATA_BEM%XPAR_T_SIZE_MIN)
  NULLIFY(YDATA_BEM%XPAR_ISMECH)
  NULLIFY(YDATA_BEM%XPAR_MECHRATE)
  NULLIFY(YDATA_BEM%XPAR_SHADEARCHI)
  NULLIFY(YDATA_BEM%XPAR_NATVENT)
  NULLIFY(YDATA_BEM%XPAR_FSNIG)
  NULLIFY(YDATA_BEM%XPAR_FVNIG)
  NULLIFY(YDATA_BEM%XPAR_MODQIN_VCD)
  NULLIFY(YDATA_BEM%XPAR_MODQIN_VLD)
  NULLIFY(YDATA_BEM%XPAR_MODQIN_NIG)
  NULLIFY(YDATA_BEM%XPAR_TDESV)
  NULLIFY(YDATA_BEM%XPAR_WIN_SW_MAX)
  NULLIFY(YDATA_BEM%XPAR_FOPEN)
  NULLIFY(YDATA_BEM%XPAR_FVSUM)
  NULLIFY(YDATA_BEM%XPAR_FVVAC)
  NULLIFY(YDATA_BEM%XPAR_FSSUM)
  NULLIFY(YDATA_BEM%XPAR_FSVAC)
  NULLIFY(YDATA_BEM%XPAR_BEG_HOLIDAY)
  NULLIFY(YDATA_BEM%XPAR_END_HOLIDAY)
  NULLIFY(YDATA_BEM%XPAR_MOD_HOLIDAY)
  NULLIFY(YDATA_BEM%XPAR_DAYWBEG_SCHED)
  NULLIFY(YDATA_BEM%XPAR_HOURBEG_SCHED)
  NULLIFY(YDATA_BEM%XPAR_PROBOCC)
  NULLIFY(YDATA_BEM%XPAR_FRAC_HEAT_ELEC)
  NULLIFY(YDATA_BEM%XPAR_FRAC_HEAT_GAS)
  NULLIFY(YDATA_BEM%XPAR_FRAC_HEAT_FUEL)
  NULLIFY(YDATA_BEM%XPAR_FRAC_HEAT_OTHER)
  NULLIFY(YDATA_BEM%XPAR_HOTWAT)
  NULLIFY(YDATA_BEM%XPAR_F_HW_GAS)
YDATA_BEM%LDATA_RESIDENTIAL  = .FALSE. 
YDATA_BEM%LDATA_FRACOMP      = .FALSE.   
YDATA_BEM%LDATA_F_WASTE_CAN  = .FALSE.   
YDATA_BEM%LDATA_HC_FLOOR     = .FALSE.     
YDATA_BEM%LDATA_TC_FLOOR     = .FALSE.     
YDATA_BEM%LDATA_D_FLOOR      = .FALSE. 
YDATA_BEM%LDATA_HC_MASS      = .FALSE.     
YDATA_BEM%LDATA_TC_MASS      = .FALSE.     
YDATA_BEM%LDATA_D_MASS       = .FALSE. 
YDATA_BEM%LDATA_TCOOL_OCCD = .FALSE. 
YDATA_BEM%LDATA_TCOOL_OCCN = .FALSE. 
YDATA_BEM%LDATA_TCOOL_VCDD = .FALSE. 
YDATA_BEM%LDATA_TCOOL_VCDN = .FALSE. 
YDATA_BEM%LDATA_TCOOL_VCLD = .FALSE. 
YDATA_BEM%LDATA_THEAT_OCCD   = .FALSE.
YDATA_BEM%LDATA_THEAT_OCCN   = .FALSE.
YDATA_BEM%LDATA_THEAT_VCDD   = .FALSE.
YDATA_BEM%LDATA_THEAT_VCDN   = .FALSE.
YDATA_BEM%LDATA_THEAT_VCLD   = .FALSE.
YDATA_BEM%LDATA_QIN          = .FALSE.          
YDATA_BEM%LDATA_QIN_FRAD     = .FALSE.     
YDATA_BEM%LDATA_SHGC         = .FALSE.         
YDATA_BEM%LDATA_U_WIN        = .FALSE.        
YDATA_BEM%LDATA_GR           = .FALSE.           
YDATA_BEM%LDATA_SHGC_SH      = .FALSE.
YDATA_BEM%LDATA_FLOOR_HEIGHT = .FALSE.
YDATA_BEM%LDATA_ISMASS       = .FALSE.
YDATA_BEM%LDATA_N50          = .FALSE.  
YDATA_BEM%LDATA_F_WATER_COND = .FALSE.  
YDATA_BEM%LDATA_ISMECH       = .FALSE.
YDATA_BEM%LDATA_MECHRATE     = .FALSE.
YDATA_BEM%LDATA_SHADEARCHI   = .FALSE.
YDATA_BEM%LDATA_NATVENT      = .FALSE.
YDATA_BEM%LDATA_QIN_FLAT     = .FALSE.     
YDATA_BEM%LDATA_CAP_SYS_HEAT = .FALSE. 
YDATA_BEM%LDATA_CAP_SYS_RAT  = .FALSE.  
YDATA_BEM%LDATA_T_ADP        = .FALSE.        
YDATA_BEM%LDATA_M_SYS_RAT    = .FALSE.    
YDATA_BEM%LDATA_COP_RAT      = .FALSE.      
YDATA_BEM%LDATA_T_SIZE_MAX   = .FALSE.    
YDATA_BEM%LDATA_T_SIZE_MIN   = .FALSE.
YDATA_BEM%NPAR_FLOOR_LAYER   = 0
YDATA_BEM%NPAR_MASS_LAYER    = 0
YDATA_BEM%NPAR_DAY_SCHED     = 0
YDATA_BEM%NPAR_CRE_SCHED     = 0
YDATA_BEM%NPAR_HOLIDAY       = 0
YDATA_BEM%LDATA_FSNIG           = .FALSE.
YDATA_BEM%LDATA_FVNIG           = .FALSE.
YDATA_BEM%LDATA_MODQIN_VCD      = .FALSE.
YDATA_BEM%LDATA_MODQIN_VLD      = .FALSE.
YDATA_BEM%LDATA_MODQIN_NIG      = .FALSE.
YDATA_BEM%LDATA_TDESV           = .FALSE.
YDATA_BEM%LDATA_WIN_SW_MAX      = .FALSE.
YDATA_BEM%LDATA_FOPEN           = .FALSE.
YDATA_BEM%LDATA_FVSUM           = .FALSE.
YDATA_BEM%LDATA_FVVAC           = .FALSE.
YDATA_BEM%LDATA_FSSUM           = .FALSE.
YDATA_BEM%LDATA_FSVAC           = .FALSE.
YDATA_BEM%LDATA_BEG_HOLIDAY     = .FALSE.
YDATA_BEM%LDATA_END_HOLIDAY     = .FALSE.
YDATA_BEM%LDATA_MOD_HOLIDAY     = .FALSE.
YDATA_BEM%LDATA_DAYWBEG_SCHED   = .FALSE.
YDATA_BEM%LDATA_HOURBEG_SCHED   = .FALSE.
YDATA_BEM%LDATA_PROBOCC         = .FALSE.
YDATA_BEM%LDATA_FRAC_HEAT_ELEC  = .FALSE.
YDATA_BEM%LDATA_FRAC_HEAT_GAS   = .FALSE.
YDATA_BEM%LDATA_FRAC_HEAT_FUEL  = .FALSE.
YDATA_BEM%LDATA_FRAC_HEAT_OTHER = .FALSE.
YDATA_BEM%LDATA_FRAC_HEAT       = .FALSE.
YDATA_BEM%LDATA_HOTWAT          = .FALSE.
YDATA_BEM%LDATA_F_HW_GAS        = .FALSE.
!
IF (LHOOK) CALL DR_HOOK("MODD_DATA_BEM_N:DATA_BEM_INIT",1,ZHOOK_HANDLE)
END SUBROUTINE DATA_BEM_INIT
!
!
END MODULE MODD_DATA_BEM_n
