!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE GET_VAR_TOWN_n (DGT, GDM, T , &
                                 HPROGRAM,KI,PQS,PZ0,PZ0H,PWALL_O_HOR,PBUILD_HEIGHT, &
                                 PLAI_HVEG,PH_URBTREE,PHTRUNK_HVEG,PFRAC_HVEG)
!     ###################################################
!
!!****  *GET_VAR_TOWN_n* - routine to get variables defined only over town
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      P. Le Moigne *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2006
!       M. Jidane   08/2008 Z0 and Z0H recovery from town tiles
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DIAG_TEB_n, ONLY : DIAG_TEB_t
USE MODD_SURFEX_n, ONLY   : TEB_GARDEN_MODEL_t
USE MODD_TEB_n, ONLY      : TEB_t
!
USE MODI_GET_LUOUT
USE MODD_SURF_PAR, ONLY   : XUNDEF
!
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_TEB_t), INTENT(INOUT) :: DGT
TYPE(TEB_GARDEN_MODEL_t),    INTENT(INOUT) :: GDM
TYPE(TEB_t), INTENT(INOUT) :: T
!
 CHARACTER(LEN=6),     INTENT(IN)     :: HPROGRAM
INTEGER,              INTENT(IN)     :: KI      ! Number of points
REAL, DIMENSION(KI),  INTENT(OUT)    :: PQS     ! surface humidity
REAL, DIMENSION(KI),  INTENT(OUT)    :: PZ0     ! surface roughness length
REAL, DIMENSION(KI),  INTENT(OUT)    :: PZ0H    ! surface roughness length for heat
REAL, DIMENSION(KI),  INTENT(OUT)    :: PWALL_O_HOR   ! Facade surface density [m^2(fac.)/m^2(town)]
REAL, DIMENSION(KI),  INTENT(OUT)    :: PBUILD_HEIGHT ! Building height [m]
REAL, DIMENSION(KI),  INTENT(OUT)    :: PLAI_HVEG
REAL, DIMENSION(KI),  INTENT(OUT)    :: PH_URBTREE
REAL, DIMENSION(KI),  INTENT(OUT)    :: PHTRUNK_HVEG
REAL, DIMENSION(KI),  INTENT(OUT)    :: PFRAC_HVEG
!
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER :: ILUOUT
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('GET_VAR_TOWN_N',0,ZHOOK_HANDLE)
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
!-------------------------------------------------------------------------------
!
IF (DGT%LSURF_VARS) THEN 
   PQS = DGT%XQS      
ELSE 
   PQS = XUNDEF      
ENDIF
!
IF (DGT%LCOEF) THEN 
   PZ0  = DGT%XZ0      
   PZ0H = DGT%XZ0H
ELSE 
   PZ0  = XUNDEF      
   PZ0H = XUNDEF
ENDIF 
!
PWALL_O_HOR   = T%CUR%XWALL_O_HOR
PBUILD_HEIGHT = T%CUR%XBLD_HEIGHT
!
PLAI_HVEG    = GDM%TGDP%XLAI_HVEG
PH_URBTREE   = GDM%TGDP%XH_TREE
PHTRUNK_HVEG = GDM%TGDP%XHTRUNK_HVEG
PFRAC_HVEG   = T%CUR%XFRAC_HVEG
!
IF (LHOOK) CALL DR_HOOK('GET_VAR_TOWN_N',1,ZHOOK_HANDLE)
!
!==============================================================================
!
END SUBROUTINE GET_VAR_TOWN_n
