!     #########
       SUBROUTINE DIAG_TEB_GARDEN_n (DGTGD,HPHOTO, PGPP,PRESP_ECO, PRHOA)
!***
!     ###############################################################################
!
!!****  *DIAG_TEB_GARDEN_n * - additional diagnostics for TEB_GARDEN
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     M. Goret 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    08/2017
!!
!!------------------------------------------------------------------
!
!
!
!
!
!
USE MODD_DIAG_TEB_GARDEN_n, ONLY : DIAG_TEB_GARDEN_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
TYPE(DIAG_TEB_GARDEN_t), INTENT(INOUT) :: DGTGD
!
 CHARACTER(LEN=*),  INTENT(IN) :: HPHOTO         ! type of photosynthesis
REAL, DIMENSION(:), INTENT(IN) :: PGPP           ! Gross Primary Production
REAL, DIMENSION(:), INTENT(IN) :: PRESP_ECO      ! Ecosystem respiration
REAL, DIMENSION(:), INTENT(IN) :: PRHOA          ! air density at the lowest level
!
!
!
!*      0.2    declarations of local variables
!
       REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('DIAG_TEB_GARDEN_N',0,ZHOOK_HANDLE)
!
  IF(HPHOTO/='NON') THEN
     ! Transform units from kgCO2/kgair m/s to kgCO2/m2/s
     DGTGD%XGPP      = PGPP      * PRHOA
     DGTGD%XRESP_ECO = PRESP_ECO * PRHOA
  ELSE
     DGTGD%XGPP      = 0.0
     DGTGD%XRESP_ECO = 0.0
  ENDIF
!
!
IF (LHOOK) CALL DR_HOOK('DIAG_TEB_GARDEN_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_TEB_GARDEN_n















