!     #########
      SUBROUTINE DIAG_TEB_GARDEN_INIT_n (DGMTO, DGTGD, TGD, TGDO, TGDP, TVG, &
                                         HPROGRAM,KLU,KSW)
!     #####################
!
!!****  *DIAG_TEB_GARDEN_INIT_n* - routine to initialize TEB-ISBA diagnostic variables
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2003 
!!      modified    11/2003 by P. LeMoigne: surface cumulated energy budget
!!      modified    10/2004 by P. LeMoigne: surface miscellaneous fields
!!      B. Decharme    2008    New diag for water budget and allow to reset
!               cumulatives variables at the beginning of a run
!!      M.Goret     08/2017 change DGGD to DGTGD
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DIAG_MISC_TEB_OPTION_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
USE MODD_DIAG_TEB_GARDEN_n, ONLY : DIAG_TEB_GARDEN_t
USE MODD_TEB_GARDEN_n, ONLY : TEB_GARDEN_t
USE MODD_TEB_GARDEN_OPTION_n, ONLY : TEB_GARDEN_OPTIONS_t
USE MODD_TEB_GARDEN_PGD_n, ONLY : TEB_GARDEN_PGD_t
USE MODD_TEB_VEG_n, ONLY : TEB_VEG_OPTIONS_t
!
USE MODD_SURF_PAR,          ONLY : XUNDEF
USE MODD_TYPE_DATE_SURF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DGMTO
TYPE(DIAG_TEB_GARDEN_t), INTENT(INOUT) :: DGTGD
TYPE(TEB_GARDEN_t), INTENT(INOUT) :: TGD
TYPE(TEB_GARDEN_OPTIONS_t), INTENT(INOUT) :: TGDO
TYPE(TEB_GARDEN_PGD_t), INTENT(INOUT) :: TGDP
TYPE(TEB_VEG_OPTIONS_t), INTENT(INOUT) :: TVG
!
INTEGER, INTENT(IN)         :: KLU       ! size of arrays
INTEGER, INTENT(IN)         :: KSW       ! spectral bands
 CHARACTER(LEN=6), INTENT(IN):: HPROGRAM  ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=LEN_HREC) :: YREC     ! Name of the article to be read
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('DIAG_TEB_GARDEN_INIT_N',0,ZHOOK_HANDLE)
!
DGTGD%LDIAG_GD    = .TRUE.
!
!
ALLOCATE(DGTGD%XRI     (KLU)) 
!
DGTGD%XRI         = XUNDEF
!
ALLOCATE(DGTGD%XCD     (KLU)) 
ALLOCATE(DGTGD%XCH     (KLU)) 
ALLOCATE(DGTGD%XRN     (KLU)) 
ALLOCATE(DGTGD%XH      (KLU)) 
ALLOCATE(DGTGD%XGFLUX  (KLU)) 
ALLOCATE(DGTGD%XQS     (KLU)) 
!
DGTGD%XCD         = XUNDEF
DGTGD%XCH         = XUNDEF
DGTGD%XRN         = XUNDEF
DGTGD%XH          = XUNDEF
DGTGD%XGFLUX      = XUNDEF
DGTGD%XQS         = XUNDEF
!
ALLOCATE(DGTGD%XLEI    (KLU)) 
ALLOCATE(DGTGD%XLEG    (KLU)) 
ALLOCATE(DGTGD%XLEGI   (KLU)) 
ALLOCATE(DGTGD%XLEV    (KLU)) 
ALLOCATE(DGTGD%XLES    (KLU)) 
ALLOCATE(DGTGD%XLER    (KLU)) 
ALLOCATE(DGTGD%XLETR   (KLU)) 
ALLOCATE(DGTGD%XEVAP   (KLU)) 
!ALLOCATE(DGTGD%XDRAIN  (KLU)) 
!ALLOCATE(DGTGD%XRUNOFF (KLU)) 
ALLOCATE(DGTGD%XHORT   (KLU)) 
ALLOCATE(DGTGD%XDRIP   (KLU)) 
ALLOCATE(DGTGD%XRRVEG  (KLU)) 
ALLOCATE(DGTGD%XMELT   (KLU)) 
ALLOCATE(DGTGD%XIRRIG_FLUX(KLU))
!
DGTGD%XLEI        = XUNDEF
DGTGD%XLEG        = XUNDEF
DGTGD%XLEGI       = XUNDEF
DGTGD%XLEV        = XUNDEF
DGTGD%XLES        = XUNDEF
DGTGD%XLER        = XUNDEF
DGTGD%XLETR       = XUNDEF
DGTGD%XEVAP       = XUNDEF
!DGTGD%XDRAIN      = XUNDEF
!DGTGD%XRUNOFF     = XUNDEF
DGTGD%XHORT       = XUNDEF
DGTGD%XDRIP       = XUNDEF
DGTGD%XRRVEG      = XUNDEF
DGTGD%XMELT       = XUNDEF
DGTGD%XIRRIG_FLUX = XUNDEF
!
ALLOCATE(DGTGD%XCG     (KLU)) 
ALLOCATE(DGTGD%XC1     (KLU)) 
ALLOCATE(DGTGD%XC2     (KLU)) 
ALLOCATE(DGTGD%XWGEQ   (KLU)) 
ALLOCATE(DGTGD%XCT     (KLU)) 
ALLOCATE(DGTGD%XRS     (KLU)) 
ALLOCATE(DGTGD%XCDN    (KLU)) 
ALLOCATE(DGTGD%XHU     (KLU)) 
ALLOCATE(DGTGD%XHUG    (KLU)) 
ALLOCATE(DGTGD%XRESTORE(KLU)) 
ALLOCATE(DGTGD%XUSTAR  (KLU)) 
IF (TVG%CPHOTO/='NON') THEN
  ALLOCATE(DGTGD%XIACAN  (KLU,SIZE(TGDP%XABC)          ))
ELSE
  ALLOCATE(DGTGD%XIACAN  (0,0))
END IF
!
DGTGD%XCG         = XUNDEF
DGTGD%XC1         = XUNDEF
DGTGD%XC2         = XUNDEF
DGTGD%XWGEQ       = XUNDEF
DGTGD%XCT         = XUNDEF
DGTGD%XRS         = XUNDEF
DGTGD%XCDN        = XUNDEF
DGTGD%XHU         = XUNDEF
DGTGD%XHUG        = XUNDEF
DGTGD%XRESTORE    = XUNDEF
DGTGD%XUSTAR      = XUNDEF
IF (TVG%CPHOTO/='NON') THEN
  DGTGD%XIACAN    = XUNDEF
END IF
!
ALLOCATE(DGTGD%XSNOWTEMP(KLU,TGD%CUR%TSNOW%NLAYER        )) 
ALLOCATE(DGTGD%XSNOWLIQ (KLU,TGD%CUR%TSNOW%NLAYER        )) 
ALLOCATE(DGTGD%XSNOWDZ  (KLU,TGD%CUR%TSNOW%NLAYER        )) 
ALLOCATE(DGTGD%XSNOWHMASS(KLU)) 
ALLOCATE(DGTGD%XMELTADV  (KLU)) 
!
DGTGD%XSNOWTEMP   = XUNDEF
DGTGD%XSNOWLIQ    = XUNDEF
DGTGD%XSNOWDZ     = XUNDEF
DGTGD%XSNOWHMASS  = XUNDEF
DGTGD%XMELTADV    = XUNDEF
!
ALLOCATE(DGTGD%XHV     (KLU))
ALLOCATE(DGTGD%XALBT   (KLU)) 
ALLOCATE(DGTGD%XEMIST  (KLU)) 
!
DGTGD%XHV               = XUNDEF
DGTGD%XALBT             = XUNDEF
DGTGD%XEMIST            = XUNDEF
!
ALLOCATE(DGTGD%XFAPAR    (KLU))
ALLOCATE(DGTGD%XFAPIR    (KLU))
ALLOCATE(DGTGD%XFAPAR_BS (KLU))
ALLOCATE(DGTGD%XFAPIR_BS (KLU))
ALLOCATE(DGTGD%XDFAPARC  (KLU))
ALLOCATE(DGTGD%XDFAPIRC  (KLU))
ALLOCATE(DGTGD%XDLAI_EFFC(KLU))
!
DGTGD%XFAPAR     = XUNDEF
DGTGD%XFAPIR     = XUNDEF
DGTGD%XFAPAR_BS  = XUNDEF
DGTGD%XFAPIR_BS  = XUNDEF
DGTGD%XDFAPARC   = XUNDEF
DGTGD%XDFAPIRC   = XUNDEF
DGTGD%XDLAI_EFFC = XUNDEF
!
!* surface energy budget
!
!IF (LSURF_BUDGET) THEN
  !
  ALLOCATE(DGTGD%XSWD      (KLU))
  ALLOCATE(DGTGD%XSWU      (KLU))
  ALLOCATE(DGTGD%XSWBD     (KLU,KSW))
  ALLOCATE(DGTGD%XSWBU     (KLU,KSW))
  ALLOCATE(DGTGD%XLWD      (KLU))
  ALLOCATE(DGTGD%XLWU      (KLU))
  ALLOCATE(DGTGD%XFMU      (KLU))
  ALLOCATE(DGTGD%XFMV      (KLU))
  !
  DGTGD%XSWD     = XUNDEF
  DGTGD%XSWU     = XUNDEF
  DGTGD%XSWBD    = XUNDEF
  DGTGD%XSWBU    = XUNDEF
  DGTGD%XLWD     = XUNDEF
  DGTGD%XLWU     = XUNDEF
  DGTGD%XFMU     = XUNDEF
  DGTGD%XFMV     = XUNDEF
  !
!END IF
!
!* surface temperature and parameters at 2m
!
ALLOCATE(DGTGD%XTS    (KLU))
DGTGD%XTS     = XUNDEF
ALLOCATE(DGTGD%XTSRAD (KLU))
DGTGD%XTSRAD  = XUNDEF
!
!* miscellaneous surface fields
!
IF (DGMTO%LSURF_MISC_BUDGET) THEN
  ALLOCATE(DGTGD%XSWI    (KLU,TGDO%NGROUND_LAYER))
  ALLOCATE(DGTGD%XTSWI   (KLU,TGDO%NGROUND_LAYER))
  ALLOCATE(DGTGD%XTWSNOW (KLU))
  ALLOCATE(DGTGD%XTDSNOW (KLU))
  DGTGD%XSWI     = XUNDEF
  DGTGD%XTSWI    = XUNDEF
  DGTGD%XTWSNOW  = XUNDEF
  DGTGD%XTDSNOW  = XUNDEF
ELSE
  ALLOCATE(DGTGD%XSWI    (0,0))
  ALLOCATE(DGTGD%XTSWI   (0,0))
  ALLOCATE(DGTGD%XTWSNOW (0))
  ALLOCATE(DGTGD%XTDSNOW (0))
ENDIF
!
ALLOCATE(DGTGD%XALBT   (KLU))
ALLOCATE(DGTGD%XGPP    (KLU))
ALLOCATE(DGTGD%XRESP_AUTO  (KLU))
ALLOCATE(DGTGD%XRESP_ECO   (KLU))
!
DGTGD%XALBT    = XUNDEF
DGTGD%XGPP     = XUNDEF
DGTGD%XRESP_AUTO   = XUNDEF
DGTGD%XRESP_ECO    = XUNDEF  
!
!END IF
!
!* transfer coefficients
!
!IF (LCOEF) THEN
  !
  ALLOCATE(DGTGD%XCE            (KLU))
  ALLOCATE(DGTGD%XZ0_WITH_SNOW  (KLU))
  ALLOCATE(DGTGD%XZ0H_WITH_SNOW (KLU))
  ALLOCATE(DGTGD%XZ0EFF         (KLU))
  !
  DGTGD%XCE            = XUNDEF
  DGTGD%XZ0_WITH_SNOW  = XUNDEF
  DGTGD%XZ0H_WITH_SNOW = XUNDEF
  DGTGD%XZ0EFF         = XUNDEF
!END IF
!
!
!* surface humidity
!
!IF (LSURF_VARS) THEN
  ALLOCATE(DGTGD%XQS            (KLU))
  !
  DGTGD%XQS            = XUNDEF
!END IF
!
!* Irrigation threshold
!
!IF (LAGRIP) THEN
  ALLOCATE(DGTGD%XSEUIL(KLU))
  !
  DGTGD%XSEUIL         = XUNDEF
!END IF
!
IF (LHOOK) CALL DR_HOOK('DIAG_TEB_GARDEN_INIT_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_TEB_GARDEN_INIT_n
