!     #########
      SUBROUTINE DIAG_ISBA_INIT_n (&
                                    CHI, DGEI, DGI, DGUI, DGMI, DGU, GB, I, &
                                   HPROGRAM,KLU,KSW)
!     #####################
!
!!****  *DIAG_ISBA_INIT_n* - routine to initialize ISBA-AGS diagnostic variables
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2003 
!!      modified    11/2003 by P. LeMoigne: surface cumulated energy budget
!!      modified    10/2004 by P. LeMoigne: surface miscellaneous fields
!!      B. Decharme    2008    New diag for water budget and allow to reset
!                               cumulatives variables at the beginning of a run
!!      B. Decharme 06/2009    add patch budget switch 
!!      B. Decharme 08/2009    add cummulative diag
!!      A.L. Gibelin 04/2009 : Add respiration diagnostics
!!      A.L. Gibelin 05/2009 : Add carbon spinup
!!      A.L. Gibelin 07/2009 : Suppress RDK and transform GPP as a diagnostic
!!      B. Decharme  05/12   : Carbon fluxes in diag_evap
!!      B. Decharme  10/12     Isba water budget diag
!!      B. Decharme  10/12     New diag for DIF:
!!                             F2 stress
!!                             Root zone swi, wg and wgi
!!                             swi, wg and wgi comparable to ISBA-FR-DG2 and DG3 layers
!!                             active layer thickness over permafrost
!!                             frozen layer thickness over non-permafrost
!!      B. Vincendon 02/2014 : condition added for RAD_BUDGET variables (needed for
!!                             restart mode)
!       B. decharme 04/2013 : Add new diag for coupling
!                             Delete XAVG_TSRAD (because same than XTSRAD_NAT)
!!      P. Samuelsson 10/2014: MEB
!       R. Schoetter 29/03/2017: Add UTCI
!-------------------------------------------------------------------------------
!
!*       0.0    DECLARATIONS
!              ------------
!
!
!
USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
USE MODD_DIAG_ISBA_n, ONLY : DIAG_ISBA_t
USE MODD_DIAG_UTCI_ISBA_n, ONLY : DIAG_UTCI_ISBA_t
USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_t
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_GR_BIOG_n, ONLY : GR_BIOG_t
USE MODD_ISBA_n, ONLY : ISBA_t
USE MODD_UTCI, ONLY : NUTCI_STRESS
!
!
!
#ifdef SFX_OL
USE MODN_IO_OFFLINE,     ONLY : LRESTART
#endif
USE MODD_SURF_PAR,       ONLY : XUNDEF
USE MODD_TYPE_DATE_SURF
USE MODD_AGRI,           ONLY : LAGRIP
!
! 
!
!
USE MODI_READ_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.01   Declarations of arguments
!              -------------------------
!
!
!
!
TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DGEI
TYPE(DIAG_ISBA_t), INTENT(INOUT) :: DGI
TYPE(DIAG_UTCI_ISBA_t), INTENT(INOUT) :: DGUI
TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DGMI
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(GR_BIOG_t), INTENT(INOUT) :: GB
TYPE(ISBA_t), INTENT(INOUT) :: I
!
INTEGER, INTENT(IN)         :: KLU       ! size of arrays
INTEGER, INTENT(IN)         :: KSW       ! spectral bands
 CHARACTER(LEN=6), INTENT(IN):: HPROGRAM  ! program calling
!
!*       0.02   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IVERSION, IBUG
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
INTEGER           :: ISIZE_LMEB_PATCH   ! Number of patches where multi-energy balance should be applied
 CHARACTER(LEN=LEN_HREC) :: YREC        ! Name of the article to be read
 CHARACTER(LEN=4) :: YREC2
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!* surface energy budget
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N',0,ZHOOK_HANDLE)
!
ISIZE_LMEB_PATCH=COUNT(I%LMEB_PATCH(:))
!
IF (DGI%LSURF_BUDGET) THEN
  ALLOCATE(DGI%XAVG_RN           (KLU))
  ALLOCATE(DGI%XAVG_H            (KLU))
  ALLOCATE(DGI%XAVG_LE           (KLU))
  ALLOCATE(DGI%XAVG_LEI          (KLU))
  ALLOCATE(DGI%XAVG_GFLUX        (KLU))
  ALLOCATE(DGI%XAVG_SWD          (KLU))
  ALLOCATE(DGI%XAVG_SWU          (KLU))
  ALLOCATE(DGI%XAVG_SWBD         (KLU,KSW))
  ALLOCATE(DGI%XAVG_SWBU         (KLU,KSW))
  ALLOCATE(DGI%XAVG_LWD          (KLU))
  ALLOCATE(DGI%XAVG_LWU          (KLU))
  ALLOCATE(DGI%XAVG_FMU          (KLU))
  ALLOCATE(DGI%XAVG_FMV          (KLU))
  !
  DGI%XAVG_RN      = XUNDEF
  DGI%XAVG_H       = XUNDEF
  DGI%XAVG_LE      = XUNDEF
  DGI%XAVG_LEI     = XUNDEF
  DGI%XAVG_GFLUX   = XUNDEF
  DGI%XAVG_SWD     = XUNDEF
  DGI%XAVG_SWU     = XUNDEF
  DGI%XAVG_SWBD    = XUNDEF
  DGI%XAVG_SWBU    = XUNDEF
  DGI%XAVG_LWD     = XUNDEF
  DGI%XAVG_LWU     = XUNDEF
  DGI%XAVG_FMU     = XUNDEF
  DGI%XAVG_FMV     = XUNDEF
  !
  ALLOCATE(DGI%XRN       (KLU,I%NPATCH))
  ALLOCATE(DGI%XH        (KLU,I%NPATCH))
  ALLOCATE(DGI%XGFLUX    (KLU,I%NPATCH))
  ALLOCATE(DGI%XLEI      (KLU,I%NPATCH))
  ALLOCATE(DGI%XSWD      (KLU,I%NPATCH))
  ALLOCATE(DGI%XSWU      (KLU,I%NPATCH))
  ALLOCATE(DGI%XSWBD     (KLU,KSW,I%NPATCH))
  ALLOCATE(DGI%XSWBU     (KLU,KSW,I%NPATCH))
  ALLOCATE(DGI%XLWD      (KLU,I%NPATCH))
  ALLOCATE(DGI%XLWU      (KLU,I%NPATCH))
  ALLOCATE(DGI%XFMU      (KLU,I%NPATCH))
  ALLOCATE(DGI%XFMV      (KLU,I%NPATCH))
  !
  DGI%XRN      = XUNDEF
  DGI%XH       = XUNDEF
  DGI%XGFLUX   = XUNDEF
  DGI%XLEI     = XUNDEF
  DGI%XSWD     = XUNDEF
  DGI%XSWU     = XUNDEF
  DGI%XSWBD    = XUNDEF
  DGI%XSWBU    = XUNDEF
  DGI%XLWD     = XUNDEF
  DGI%XLWU     = XUNDEF
  DGI%XFMU     = XUNDEF
  DGI%XFMV     = XUNDEF
  !
ELSE
  ALLOCATE(DGI%XAVG_RN           (0))
  ALLOCATE(DGI%XAVG_H            (0))
  ALLOCATE(DGI%XAVG_LE           (0))
  ALLOCATE(DGI%XAVG_LEI          (0))
  ALLOCATE(DGI%XAVG_GFLUX        (0))
  ALLOCATE(DGI%XAVG_SWD          (0))
  ALLOCATE(DGI%XAVG_SWU          (0))
  ALLOCATE(DGI%XAVG_SWBD         (0,0))
  ALLOCATE(DGI%XAVG_SWBU         (0,0))
  ALLOCATE(DGI%XAVG_LWD          (0))
  ALLOCATE(DGI%XAVG_LWU          (0))
  ALLOCATE(DGI%XAVG_FMU          (0))
  ALLOCATE(DGI%XAVG_FMV          (0))
!
  ALLOCATE(DGI%XRN       (0,0))
  ALLOCATE(DGI%XH        (0,0))
  ALLOCATE(DGI%XGFLUX    (0,0))
  ALLOCATE(DGI%XLEI      (0,0))
  ALLOCATE(DGI%XSWD      (0,0))
  ALLOCATE(DGI%XSWU      (0,0))
  ALLOCATE(DGI%XSWBD     (0,0,0))
  ALLOCATE(DGI%XSWBU     (0,0,0))
  ALLOCATE(DGI%XLWD      (0,0))
  ALLOCATE(DGI%XLWU      (0,0))
  ALLOCATE(DGI%XFMU      (0,0))
  ALLOCATE(DGI%XFMV      (0,0))
END IF
!
!* detailed surface energy budget
!
IF (DGEI%LSURF_EVAP_BUDGET) THEN
  ALLOCATE(DGEI%XAVG_LEG       (KLU))
  ALLOCATE(DGEI%XAVG_LEGI      (KLU))
  ALLOCATE(DGEI%XAVG_LEV       (KLU))
  ALLOCATE(DGEI%XAVG_LES       (KLU))
  ALLOCATE(DGEI%XAVG_LESL      (KLU))
  ALLOCATE(DGEI%XAVG_LER       (KLU))
  ALLOCATE(DGEI%XAVG_LETR      (KLU))
  ALLOCATE(DGEI%XAVG_EVAP      (KLU))
  ALLOCATE(DGEI%XAVG_SUBL      (KLU))
  ALLOCATE(DGEI%XAVG_SNDRIFT   (KLU))
  ALLOCATE(DGEI%XAVG_DRAIN     (KLU))
  ALLOCATE(DGEI%XAVG_QSB       (KLU))
  ALLOCATE(DGEI%XAVG_RUNOFF    (KLU))
  ALLOCATE(DGEI%XAVG_HORT      (KLU))
  ALLOCATE(DGEI%XAVG_DRIP      (KLU))
  ALLOCATE(DGEI%XAVG_RRVEG     (KLU))
  ALLOCATE(DGEI%XAVG_MELT      (KLU))
  ALLOCATE(DGEI%XAVG_IRRIG_FLUX(KLU))
  ALLOCATE(DGEI%XAVG_GPP       (KLU))
  ALLOCATE(DGEI%XAVG_RESP_AUTO (KLU))
  ALLOCATE(DGEI%XAVG_RESP_ECO  (KLU))   
  !
  DGEI%XAVG_LEG        = XUNDEF
  DGEI%XAVG_LEGI       = XUNDEF
  DGEI%XAVG_LEV        = XUNDEF
  DGEI%XAVG_LES        = XUNDEF
  DGEI%XAVG_LESL       = XUNDEF
  DGEI%XAVG_LER        = XUNDEF
  DGEI%XAVG_LETR       = XUNDEF
  DGEI%XAVG_EVAP       = XUNDEF
  DGEI%XAVG_SUBL       = XUNDEF
  DGEI%XAVG_SNDRIFT    = XUNDEF
  DGEI%XAVG_DRAIN      = XUNDEF
  DGEI%XAVG_QSB        = XUNDEF
  DGEI%XAVG_RUNOFF     = XUNDEF
  DGEI%XAVG_HORT       = XUNDEF
  DGEI%XAVG_DRIP       = XUNDEF
  DGEI%XAVG_RRVEG      = XUNDEF
  DGEI%XAVG_MELT       = XUNDEF
  DGEI%XAVG_IRRIG_FLUX = XUNDEF
  DGEI%XAVG_GPP        = XUNDEF
  DGEI%XAVG_RESP_AUTO  = XUNDEF
  DGEI%XAVG_RESP_ECO   = XUNDEF  
  !
  ALLOCATE(DGEI%XAVG_IFLOOD   (KLU))
  ALLOCATE(DGEI%XAVG_PFLOOD   (KLU))
  ALLOCATE(DGEI%XAVG_LE_FLOOD (KLU))
  ALLOCATE(DGEI%XAVG_LEI_FLOOD(KLU))
  DGEI%XAVG_IFLOOD    = XUNDEF
  DGEI%XAVG_PFLOOD    = XUNDEF
  DGEI%XAVG_LE_FLOOD  = XUNDEF
  DGEI%XAVG_LEI_FLOOD = XUNDEF
  !
  ALLOCATE(DGEI%XLEG       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLEGI      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLEV       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLES       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLESL      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLER       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLETR      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XEVAP      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XSUBL      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XSNDRIFT   (KLU,I%NPATCH))
  ALLOCATE(DGEI%XDRAIN     (KLU,I%NPATCH))
  ALLOCATE(DGEI%XQSB       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XRUNOFF    (KLU,I%NPATCH))
  ALLOCATE(DGEI%XHORT      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XDRIP      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XRRVEG     (KLU,I%NPATCH))
  ALLOCATE(DGEI%XMELT      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XIRRIG_FLUX(KLU,I%NPATCH))
  ALLOCATE(DGEI%XGPP       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XRESP_AUTO (KLU,I%NPATCH))
  ALLOCATE(DGEI%XRESP_ECO  (KLU,I%NPATCH))
  !
  DGEI%XLEG           = XUNDEF 
  DGEI%XLEGI          = XUNDEF
  DGEI%XLEV           = XUNDEF
  DGEI%XLES           = XUNDEF
  DGEI%XLESL          = XUNDEF
  DGEI%XLER           = XUNDEF
  DGEI%XLETR          = XUNDEF
  DGEI%XEVAP          = XUNDEF
  DGEI%XSUBL          = XUNDEF
  DGEI%XSNDRIFT       = XUNDEF
  DGEI%XDRAIN         = XUNDEF
  DGEI%XQSB           = XUNDEF
  DGEI%XRUNOFF        = XUNDEF
  DGEI%XHORT          = XUNDEF
  DGEI%XDRIP          = XUNDEF
  DGEI%XRRVEG         = XUNDEF
  DGEI%XMELT          = XUNDEF
  DGEI%XIRRIG_FLUX    = XUNDEF
  DGEI%XGPP           = XUNDEF
  DGEI%XRESP_AUTO     = XUNDEF
  DGEI%XRESP_ECO      = XUNDEF  
  !
  ALLOCATE(DGEI%XIFLOOD (KLU,I%NPATCH))
  ALLOCATE(DGEI%XPFLOOD (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLE_FLOOD(KLU,I%NPATCH))
  ALLOCATE(DGEI%XLEI_FLOOD(KLU,I%NPATCH))
  DGEI%XIFLOOD        = XUNDEF
  DGEI%XPFLOOD        = XUNDEF
  DGEI%XLE_FLOOD      = XUNDEF
  DGEI%XLEI_FLOOD     = XUNDEF
  !
  IF (ISIZE_LMEB_PATCH>0) THEN
    ALLOCATE(DGEI%XAVG_LEVCV  (KLU))
    ALLOCATE(DGEI%XAVG_LESC   (KLU))
    ALLOCATE(DGEI%XAVG_LETRGV (KLU))
    ALLOCATE(DGEI%XAVG_LETRCV (KLU))
    ALLOCATE(DGEI%XAVG_LERGV  (KLU))
    ALLOCATE(DGEI%XAVG_LELITTER (KLU))
    ALLOCATE(DGEI%XAVG_LELITTERI(KLU))
    ALLOCATE(DGEI%XAVG_DRIPLIT  (KLU))
    ALLOCATE(DGEI%XAVG_RRLIT  (KLU))
    ALLOCATE(DGEI%XAVG_LERCV  (KLU))
    ALLOCATE(DGEI%XAVG_LE_C_A (KLU))
    ALLOCATE(DGEI%XAVG_LE_V_C (KLU))
    ALLOCATE(DGEI%XAVG_LE_G_C (KLU))
    ALLOCATE(DGEI%XAVG_LE_N_C (KLU))
    !
    ALLOCATE(DGEI%XAVG_SWNET_V    (KLU))
    ALLOCATE(DGEI%XAVG_SWNET_G    (KLU))
    ALLOCATE(DGEI%XAVG_SWNET_N    (KLU))
    ALLOCATE(DGEI%XAVG_SWNET_NS   (KLU))
    ALLOCATE(DGEI%XAVG_LWNET_V    (KLU))
    ALLOCATE(DGEI%XAVG_LWNET_G    (KLU))
    ALLOCATE(DGEI%XAVG_LWNET_N    (KLU))
    ALLOCATE(DGEI%XAVG_SWDOWN_GN  (KLU))
    ALLOCATE(DGEI%XAVG_LWDOWN_GN  (KLU))
    ALLOCATE(DGEI%XAVG_H_V_C      (KLU))
    ALLOCATE(DGEI%XAVG_H_G_C      (KLU))
    ALLOCATE(DGEI%XAVG_H_C_A      (KLU))
    ALLOCATE(DGEI%XAVG_H_N_C      (KLU))
    ALLOCATE(DGEI%XAVG_SR_GN      (KLU))
    ALLOCATE(DGEI%XAVG_MELTCV     (KLU))
    ALLOCATE(DGEI%XAVG_FRZCV      (KLU))
!
    DGEI%XAVG_LEVCV         = XUNDEF
    DGEI%XAVG_LESC          = XUNDEF
    DGEI%XAVG_LETRGV        = XUNDEF
    DGEI%XAVG_LETRCV        = XUNDEF
    DGEI%XAVG_LERGV         = XUNDEF
    DGEI%XAVG_LELITTER      = XUNDEF
    DGEI%XAVG_LELITTERI     = XUNDEF
    DGEI%XAVG_DRIPLIT       = XUNDEF
    DGEI%XAVG_RRLIT         = XUNDEF
    DGEI%XAVG_LERCV         = XUNDEF
    DGEI%XAVG_LE_C_A        = XUNDEF
    DGEI%XAVG_LE_V_C        = XUNDEF
    DGEI%XAVG_LE_G_C        = XUNDEF
    DGEI%XAVG_LE_N_C        = XUNDEF
    !
    DGEI%XAVG_SWNET_V       = XUNDEF
    DGEI%XAVG_SWNET_G       = XUNDEF
    DGEI%XAVG_SWNET_N       = XUNDEF
    DGEI%XAVG_SWNET_NS      = XUNDEF
    DGEI%XAVG_LWNET_V       = XUNDEF
    DGEI%XAVG_LWNET_G       = XUNDEF
    DGEI%XAVG_LWNET_N       = XUNDEF
    DGEI%XAVG_SWDOWN_GN     = XUNDEF
    DGEI%XAVG_LWDOWN_GN     = XUNDEF
    DGEI%XAVG_H_V_C         = XUNDEF
    DGEI%XAVG_H_G_C         = XUNDEF
    DGEI%XAVG_H_C_A         = XUNDEF
    DGEI%XAVG_H_N_C         = XUNDEF
    DGEI%XAVG_SR_GN         = XUNDEF
    DGEI%XAVG_MELTCV        = XUNDEF
    DGEI%XAVG_FRZCV         = XUNDEF
    !
    ALLOCATE(DGEI%XLEVCV  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLESC   (KLU,I%NPATCH))
!    ALLOCATE(XLETRGV (KLU,NPATCH))
    ALLOCATE(DGEI%XLETRCV (KLU,I%NPATCH))
!    ALLOCATE(XLERGV  (KLU,NPATCH))
    ALLOCATE(DGEI%XLELITTER (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLELITTERI(KLU,I%NPATCH))
    ALLOCATE(DGEI%XDRIPLIT  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XRRLIT    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLERCV  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLE_C_A (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLE_V_C (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLE_G_C (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLE_N_C (KLU,I%NPATCH))
    !
    ALLOCATE(DGEI%XSWNET_V    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XSWNET_G    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XSWNET_N    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XSWNET_NS   (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLWNET_V    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLWNET_G    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLWNET_N    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XSWDOWN_GN  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLWDOWN_GN  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XH_V_C      (KLU,I%NPATCH))
    ALLOCATE(DGEI%XH_G_C      (KLU,I%NPATCH))
    ALLOCATE(DGEI%XH_C_A      (KLU,I%NPATCH))
    ALLOCATE(DGEI%XH_N_C      (KLU,I%NPATCH))
    ALLOCATE(DGEI%XSR_GN      (KLU,I%NPATCH))
    ALLOCATE(DGEI%XMELTCV     (KLU,I%NPATCH))
    ALLOCATE(DGEI%XFRZCV      (KLU,I%NPATCH))
!
    DGEI%XLEVCV         = XUNDEF
    DGEI%XLESC          = XUNDEF
!    XLETRGV        = XUNDEF
    DGEI%XLETRCV        = XUNDEF
!    XLERGV         = XUNDEF
    DGEI%XLELITTER      = XUNDEF
    DGEI%XLELITTERI     = XUNDEF
    DGEI%XDRIPLIT       = XUNDEF
    DGEI%XRRLIT         = XUNDEF
    DGEI%XLERCV         = XUNDEF
    DGEI%XLE_C_A        = XUNDEF
    DGEI%XLE_V_C        = XUNDEF
    DGEI%XLE_G_C        = XUNDEF
    DGEI%XLE_N_C        = XUNDEF
    !
    DGEI%XSWNET_V       = XUNDEF
    DGEI%XSWNET_G       = XUNDEF
    DGEI%XSWNET_N       = XUNDEF
    DGEI%XSWNET_NS      = XUNDEF
    DGEI%XLWNET_V       = XUNDEF
    DGEI%XLWNET_G       = XUNDEF
    DGEI%XLWNET_N       = XUNDEF
    DGEI%XSWDOWN_GN     = XUNDEF
    DGEI%XLWDOWN_GN     = XUNDEF
    DGEI%XH_V_C         = XUNDEF
    DGEI%XH_G_C         = XUNDEF
    DGEI%XH_C_A         = XUNDEF
    DGEI%XH_N_C         = XUNDEF
    DGEI%XSR_GN         = XUNDEF
    DGEI%XMELTCV        = XUNDEF
    DGEI%XFRZCV         = XUNDEF
  ELSE
    ALLOCATE(DGEI%XAVG_LEVCV  (0))
    ALLOCATE(DGEI%XAVG_LESC   (0))
    ALLOCATE(DGEI%XAVG_LETRGV (0))
    ALLOCATE(DGEI%XAVG_LELITTER (0))
    ALLOCATE(DGEI%XAVG_LELITTERI(0))
    ALLOCATE(DGEI%XAVG_DRIPLIT  (0))
    ALLOCATE(DGEI%XAVG_RRLIT  (0))
    ALLOCATE(DGEI%XAVG_LETRCV (0))
    ALLOCATE(DGEI%XAVG_LERGV  (0))
    ALLOCATE(DGEI%XAVG_LERCV  (0))
    ALLOCATE(DGEI%XAVG_LE_C_A (0))
    ALLOCATE(DGEI%XAVG_LE_V_C (0))
    ALLOCATE(DGEI%XAVG_LE_G_C (0))
    ALLOCATE(DGEI%XAVG_LE_N_C (0))
    !
    ALLOCATE(DGEI%XAVG_SWNET_V    (0))
    ALLOCATE(DGEI%XAVG_SWNET_G    (0))
    ALLOCATE(DGEI%XAVG_SWNET_N    (0))
    ALLOCATE(DGEI%XAVG_SWNET_NS   (0))
    ALLOCATE(DGEI%XAVG_LWNET_V    (0))
    ALLOCATE(DGEI%XAVG_LWNET_G    (0))
    ALLOCATE(DGEI%XAVG_LWNET_N    (0))
    ALLOCATE(DGEI%XAVG_SWDOWN_GN  (0))
    ALLOCATE(DGEI%XAVG_LWDOWN_GN  (0))
    ALLOCATE(DGEI%XAVG_H_V_C      (0))
    ALLOCATE(DGEI%XAVG_H_G_C      (0))
    ALLOCATE(DGEI%XAVG_H_C_A      (0))
    ALLOCATE(DGEI%XAVG_H_N_C      (0))
    ALLOCATE(DGEI%XAVG_SR_GN      (0))
    ALLOCATE(DGEI%XAVG_MELTCV     (0))
    ALLOCATE(DGEI%XAVG_FRZCV      (0))
!
    ALLOCATE(DGEI%XLEVCV  (0,0))
    ALLOCATE(DGEI%XLESC   (0,0))
!    ALLOCATE(XLETRGV (0,0))
    ALLOCATE(DGEI%XLETRCV (0,0))
!    ALLOCATE(XLERGV  (0,0))
    ALLOCATE(DGEI%XLELITTER (0,0))
    ALLOCATE(DGEI%XLELITTERI(0,0))
    ALLOCATE(DGEI%XDRIPLIT  (0,0))
    ALLOCATE(DGEI%XRRLIT  (0,0))
    ALLOCATE(DGEI%XLERCV  (0,0))
    ALLOCATE(DGEI%XLE_C_A (0,0))
    ALLOCATE(DGEI%XLE_V_C (0,0))
    ALLOCATE(DGEI%XLE_G_C (0,0))
    ALLOCATE(DGEI%XLE_N_C (0,0))
    !
    ALLOCATE(DGEI%XSWNET_V    (0,0))
    ALLOCATE(DGEI%XSWNET_G    (0,0))
    ALLOCATE(DGEI%XSWNET_N    (0,0))
    ALLOCATE(DGEI%XSWNET_NS   (0,0))
    ALLOCATE(DGEI%XLWNET_V    (0,0))
    ALLOCATE(DGEI%XLWNET_G    (0,0))
    ALLOCATE(DGEI%XLWNET_N    (0,0))
    ALLOCATE(DGEI%XSWDOWN_GN  (0,0))
    ALLOCATE(DGEI%XLWDOWN_GN  (0,0))
    ALLOCATE(DGEI%XH_V_C      (0,0))
    ALLOCATE(DGEI%XH_G_C      (0,0))
    ALLOCATE(DGEI%XH_C_A      (0,0))
    ALLOCATE(DGEI%XH_N_C      (0,0))
    ALLOCATE(DGEI%XSR_GN      (0,0))
    ALLOCATE(DGEI%XMELTCV     (0,0))
    ALLOCATE(DGEI%XFRZCV      (0,0))

  ENDIF
  !
  IF(DGEI%LWATER_BUDGET)THEN
    !      
    ALLOCATE(DGEI%XRAINFALL  (KLU))
    ALLOCATE(DGEI%XSNOWFALL  (KLU))
    ALLOCATE(DGEI%XAVG_DWG   (KLU))
    ALLOCATE(DGEI%XAVG_DWGI  (KLU))
    ALLOCATE(DGEI%XAVG_DWR   (KLU))
    ALLOCATE(DGEI%XAVG_DSWE  (KLU))
    ALLOCATE(DGEI%XAVG_WATBUD(KLU))
    DGEI%XRAINFALL   = XUNDEF
    DGEI%XSNOWFALL   = XUNDEF
    DGEI%XAVG_DWG    = XUNDEF
    DGEI%XAVG_DWGI   = XUNDEF
    DGEI%XAVG_DWR    = XUNDEF
    DGEI%XAVG_DSWE   = XUNDEF
    DGEI%XAVG_WATBUD = XUNDEF
    !
    ALLOCATE(DGEI%XDWG   (KLU,I%NPATCH))
    ALLOCATE(DGEI%XDWGI  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XDWR   (KLU,I%NPATCH))
    ALLOCATE(DGEI%XDSWE  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XWATBUD(KLU,I%NPATCH))
    DGEI%XDWG    = XUNDEF
    DGEI%XDWGI   = XUNDEF
    DGEI%XDWR    = XUNDEF
    DGEI%XDSWE   = XUNDEF
    DGEI%XWATBUD = XUNDEF
    ! 
  ELSE
    !
    ALLOCATE(DGEI%XRAINFALL  (0))
    ALLOCATE(DGEI%XSNOWFALL  (0))
    ALLOCATE(DGEI%XAVG_DWG   (0))
    ALLOCATE(DGEI%XAVG_DWGI  (0))
    ALLOCATE(DGEI%XAVG_DWR   (0))
    ALLOCATE(DGEI%XAVG_DSWE  (0))
    ALLOCATE(DGEI%XAVG_WATBUD(0))
    !
    ALLOCATE(DGEI%XDWG   (0,0))
    ALLOCATE(DGEI%XDWGI  (0,0))
    ALLOCATE(DGEI%XDWR   (0,0))
    ALLOCATE(DGEI%XDSWE  (0,0))
    ALLOCATE(DGEI%XWATBUD(0,0))
    !
  ENDIF
  !
ELSE
  ALLOCATE(DGEI%XAVG_LEG       (0))
  ALLOCATE(DGEI%XAVG_LEGI      (0))
  ALLOCATE(DGEI%XAVG_LEV       (0))
  ALLOCATE(DGEI%XAVG_LES       (0))
  ALLOCATE(DGEI%XAVG_LESL      (0))
  ALLOCATE(DGEI%XAVG_LER       (0))
  ALLOCATE(DGEI%XAVG_LETR      (0))
  ALLOCATE(DGEI%XAVG_EVAP      (0))
  ALLOCATE(DGEI%XAVG_SUBL      (0))
  ALLOCATE(DGEI%XAVG_SNDRIFT   (0))
  ALLOCATE(DGEI%XAVG_DRAIN     (0))
  ALLOCATE(DGEI%XAVG_QSB       (0))
  ALLOCATE(DGEI%XAVG_RUNOFF    (0))
  ALLOCATE(DGEI%XAVG_HORT      (0))
  ALLOCATE(DGEI%XAVG_DRIP      (0))
  ALLOCATE(DGEI%XAVG_RRVEG     (0))
  ALLOCATE(DGEI%XAVG_MELT      (0))
  ALLOCATE(DGEI%XAVG_IRRIG_FLUX(0))
  ALLOCATE(DGEI%XAVG_GPP       (0))
  ALLOCATE(DGEI%XAVG_RESP_AUTO (0))
  ALLOCATE(DGEI%XAVG_RESP_ECO  (0))
  ALLOCATE(DGEI%XAVG_IFLOOD    (0))
  ALLOCATE(DGEI%XAVG_PFLOOD    (0))
  ALLOCATE(DGEI%XAVG_LE_FLOOD  (0))
  ALLOCATE(DGEI%XAVG_LEI_FLOOD (0))
!
  ALLOCATE(DGEI%XLEG       (0,0))
  ALLOCATE(DGEI%XLEGI      (0,0))
  ALLOCATE(DGEI%XLEV       (0,0))
  ALLOCATE(DGEI%XLES       (0,0))
  ALLOCATE(DGEI%XLESL      (0,0))
  ALLOCATE(DGEI%XLER       (0,0))
  ALLOCATE(DGEI%XLETR      (0,0))
  ALLOCATE(DGEI%XEVAP      (0,0))
  ALLOCATE(DGEI%XSUBL      (0,0))
  ALLOCATE(DGEI%XSNDRIFT   (0,0))
  ALLOCATE(DGEI%XDRAIN     (0,0))
  ALLOCATE(DGEI%XQSB       (0,0))
  ALLOCATE(DGEI%XRUNOFF    (0,0))
  ALLOCATE(DGEI%XHORT      (0,0))
  ALLOCATE(DGEI%XDRIP      (0,0))
  ALLOCATE(DGEI%XRRVEG     (0,0))
  ALLOCATE(DGEI%XMELT      (0,0))
  ALLOCATE(DGEI%XIRRIG_FLUX(0,0))
  ALLOCATE(DGEI%XGPP       (0,0))
  ALLOCATE(DGEI%XRESP_AUTO (0,0))
  ALLOCATE(DGEI%XRESP_ECO  (0,0))  
  ALLOCATE(DGEI%XIFLOOD    (0,0))
  ALLOCATE(DGEI%XPFLOOD    (0,0))
  ALLOCATE(DGEI%XLE_FLOOD  (0,0))
  ALLOCATE(DGEI%XLEI_FLOOD (0,0))
  !
  ALLOCATE(DGEI%XRAINFALL  (0))
  ALLOCATE(DGEI%XSNOWFALL  (0))
  ALLOCATE(DGEI%XAVG_DWG   (0))
  ALLOCATE(DGEI%XAVG_DWGI  (0))
  ALLOCATE(DGEI%XAVG_DWR   (0))
  ALLOCATE(DGEI%XAVG_DSWE  (0))
  ALLOCATE(DGEI%XAVG_WATBUD(0))
  !
  ALLOCATE(DGEI%XDWG   (0,0))
  ALLOCATE(DGEI%XDWGI  (0,0))
  ALLOCATE(DGEI%XDWR   (0,0))
  ALLOCATE(DGEI%XDSWE  (0,0))
  ALLOCATE(DGEI%XWATBUD(0,0))
  !
  ALLOCATE(DGEI%XAVG_LEVCV  (0))
  ALLOCATE(DGEI%XAVG_LESC   (0))
  ALLOCATE(DGEI%XAVG_LETRGV (0))
  ALLOCATE(DGEI%XAVG_LETRCV (0))
  ALLOCATE(DGEI%XAVG_LERGV  (0))
  ALLOCATE(DGEI%XAVG_LELITTER (0))
  ALLOCATE(DGEI%XAVG_LELITTERI(0))
  ALLOCATE(DGEI%XAVG_DRIPLIT  (0))
  ALLOCATE(DGEI%XAVG_RRLIT  (0))
  ALLOCATE(DGEI%XAVG_LERCV  (0))
  ALLOCATE(DGEI%XAVG_LE_C_A (0))
  ALLOCATE(DGEI%XAVG_LE_V_C (0))
  ALLOCATE(DGEI%XAVG_LE_G_C (0))
  ALLOCATE(DGEI%XAVG_LE_N_C (0))
  !
  ALLOCATE(DGEI%XAVG_SWNET_V    (0))
  ALLOCATE(DGEI%XAVG_SWNET_G    (0))
  ALLOCATE(DGEI%XAVG_SWNET_N    (0))
  ALLOCATE(DGEI%XAVG_SWNET_NS   (0))
  ALLOCATE(DGEI%XAVG_LWNET_V    (0))
  ALLOCATE(DGEI%XAVG_LWNET_G    (0))
  ALLOCATE(DGEI%XAVG_LWNET_N    (0))
  ALLOCATE(DGEI%XAVG_SWDOWN_GN  (0))
  ALLOCATE(DGEI%XAVG_LWDOWN_GN  (0))
  ALLOCATE(DGEI%XAVG_H_V_C      (0))
  ALLOCATE(DGEI%XAVG_H_G_C      (0))
  ALLOCATE(DGEI%XAVG_H_C_A      (0))
  ALLOCATE(DGEI%XAVG_H_N_C      (0))
  ALLOCATE(DGEI%XAVG_SR_GN      (0))
  ALLOCATE(DGEI%XAVG_MELTCV     (0))
  ALLOCATE(DGEI%XAVG_FRZCV      (0))
!
  ALLOCATE(DGEI%XLEVCV  (0,0))
  ALLOCATE(DGEI%XLESC   (0,0))
!  ALLOCATE(XLETRGV (0,0))
  ALLOCATE(DGEI%XLETRCV (0,0))
!  ALLOCATE(XLERGV  (0,0))
  ALLOCATE(DGEI%XLELITTER (0,0))
  ALLOCATE(DGEI%XLELITTERI(0,0))
  ALLOCATE(DGEI%XDRIPLIT  (0,0))
  ALLOCATE(DGEI%XRRLIT  (0,0))
  ALLOCATE(DGEI%XLERCV  (0,0))
  ALLOCATE(DGEI%XLE_C_A (0,0))
  ALLOCATE(DGEI%XLE_V_C (0,0))
  ALLOCATE(DGEI%XLE_G_C (0,0))
  ALLOCATE(DGEI%XLE_N_C (0,0))
  !
  ALLOCATE(DGEI%XSWNET_V    (0,0))
  ALLOCATE(DGEI%XSWNET_G    (0,0))
  ALLOCATE(DGEI%XSWNET_N    (0,0))
  ALLOCATE(DGEI%XSWNET_NS   (0,0))
  ALLOCATE(DGEI%XLWNET_V    (0,0))
  ALLOCATE(DGEI%XLWNET_G    (0,0))
  ALLOCATE(DGEI%XLWNET_N    (0,0))
  ALLOCATE(DGEI%XSWDOWN_GN  (0,0))
  ALLOCATE(DGEI%XLWDOWN_GN  (0,0))
  ALLOCATE(DGEI%XH_V_C      (0,0))
  ALLOCATE(DGEI%XH_G_C      (0,0))
  ALLOCATE(DGEI%XH_C_A      (0,0))
  ALLOCATE(DGEI%XH_N_C      (0,0))
  ALLOCATE(DGEI%XSR_GN      (0,0))
  ALLOCATE(DGEI%XMELTCV     (0,0))
  ALLOCATE(DGEI%XFRZCV      (0,0))
  ! 
END IF
!
!* surface cumulated energy budget
!
#ifdef SFX_OL
IF (DGEI%LSURF_BUDGETC .OR. (LRESTART .AND. .NOT.DGEI%LRESET_BUDGETC)) THEN
#else
IF (DGEI%LSURF_BUDGETC .OR. .NOT.DGEI%LRESET_BUDGETC) THEN
#endif
  ALLOCATE(DGEI%XAVG_RNC        (KLU))
  ALLOCATE(DGEI%XAVG_HC         (KLU))
  ALLOCATE(DGEI%XAVG_LEC        (KLU))
  ALLOCATE(DGEI%XAVG_LEIC       (KLU))
  ALLOCATE(DGEI%XAVG_GFLUXC     (KLU))
  ALLOCATE(DGEI%XAVG_LEGC       (KLU))
  ALLOCATE(DGEI%XAVG_LEGIC      (KLU))
  ALLOCATE(DGEI%XAVG_LEVC       (KLU))
  ALLOCATE(DGEI%XAVG_LESAC      (KLU))
  ALLOCATE(DGEI%XAVG_LESLC      (KLU))
  ALLOCATE(DGEI%XAVG_LERC       (KLU))
  ALLOCATE(DGEI%XAVG_LETRC      (KLU))
  ALLOCATE(DGEI%XAVG_EVAPC      (KLU))
  ALLOCATE(DGEI%XAVG_SUBLC      (KLU))
  ALLOCATE(DGEI%XAVG_SNDRIFTC   (KLU))
  ALLOCATE(DGEI%XAVG_DRAINC     (KLU))
  ALLOCATE(DGEI%XAVG_QSBC       (KLU))
  ALLOCATE(DGEI%XAVG_RUNOFFC    (KLU))
  ALLOCATE(DGEI%XAVG_HORTC      (KLU))
  ALLOCATE(DGEI%XAVG_DRIPC      (KLU))
  ALLOCATE(DGEI%XAVG_RRVEGC     (KLU))
  ALLOCATE(DGEI%XAVG_MELTC      (KLU))
  ALLOCATE(DGEI%XAVG_IRRIG_FLUXC(KLU))
  ALLOCATE(DGEI%XAVG_GPPC       (KLU))
  ALLOCATE(DGEI%XAVG_RESPC_AUTO (KLU))
  ALLOCATE(DGEI%XAVG_RESPC_ECO  (KLU))
  ALLOCATE(DGEI%XAVG_IFLOODC    (KLU))
  ALLOCATE(DGEI%XAVG_PFLOODC    (KLU))
  ALLOCATE(DGEI%XAVG_LE_FLOODC  (KLU))
  ALLOCATE(DGEI%XAVG_LEI_FLOODC (KLU))  
  !
  ALLOCATE(DGEI%XRNC        (KLU,I%NPATCH))
  ALLOCATE(DGEI%XHC         (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLEC        (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLEIC       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XGFLUXC     (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLEGC       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLEGIC      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLEVC       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLESAC      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLESLC      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLERC       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLETRC      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XEVAPC      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XSUBLC      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XSNDRIFTC   (KLU,I%NPATCH))
  ALLOCATE(DGEI%XDRAINC     (KLU,I%NPATCH))
  ALLOCATE(DGEI%XQSBC       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XRUNOFFC    (KLU,I%NPATCH))
  ALLOCATE(DGEI%XHORTC      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XDRIPC      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XRRVEGC     (KLU,I%NPATCH))
  ALLOCATE(DGEI%XMELTC      (KLU,I%NPATCH))
  ALLOCATE(DGEI%XIRRIG_FLUXC(KLU,I%NPATCH))
  ALLOCATE(DGEI%XGPPC       (KLU,I%NPATCH))
  ALLOCATE(DGEI%XRESPC_AUTO (KLU,I%NPATCH))
  ALLOCATE(DGEI%XRESPC_ECO  (KLU,I%NPATCH))
  ALLOCATE(DGEI%XIFLOODC    (KLU,I%NPATCH))
  ALLOCATE(DGEI%XPFLOODC    (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLE_FLOODC  (KLU,I%NPATCH))
  ALLOCATE(DGEI%XLEI_FLOODC (KLU,I%NPATCH))
  !
  IF (ISIZE_LMEB_PATCH>0) THEN
    ALLOCATE(DGEI%XAVG_LEVCVC  (KLU))
    ALLOCATE(DGEI%XAVG_LESCC   (KLU))
    ALLOCATE(DGEI%XAVG_LETRGVC  (KLU))
    ALLOCATE(DGEI%XAVG_LETRCVC  (KLU))
    ALLOCATE(DGEI%XAVG_LERGVC   (KLU))
    ALLOCATE(DGEI%XAVG_LERCVC   (KLU))
    ALLOCATE(DGEI%XAVG_LE_C_AC  (KLU))
    ALLOCATE(DGEI%XAVG_LE_V_CC  (KLU))
    ALLOCATE(DGEI%XAVG_LE_G_CC  (KLU))
    ALLOCATE(DGEI%XAVG_LE_N_CC  (KLU))
    !
    ALLOCATE(DGEI%XAVG_SWNET_VC    (KLU))
    ALLOCATE(DGEI%XAVG_SWNET_GC    (KLU))
    ALLOCATE(DGEI%XAVG_SWNET_NC    (KLU))
    ALLOCATE(DGEI%XAVG_SWNET_NSC   (KLU))
    ALLOCATE(DGEI%XAVG_LWNET_VC    (KLU))
    ALLOCATE(DGEI%XAVG_LWNET_GC    (KLU))
    ALLOCATE(DGEI%XAVG_LWNET_NC    (KLU))
    ALLOCATE(DGEI%XAVG_SWDOWN_GNC  (KLU))
    ALLOCATE(DGEI%XAVG_LWDOWN_GNC  (KLU))
    ALLOCATE(DGEI%XAVG_H_V_CC      (KLU))
    ALLOCATE(DGEI%XAVG_H_G_CC      (KLU))
    ALLOCATE(DGEI%XAVG_H_C_AC      (KLU))
    ALLOCATE(DGEI%XAVG_H_N_CC      (KLU))
    ALLOCATE(DGEI%XAVG_SR_GNC      (KLU))
    ALLOCATE(DGEI%XAVG_MELTCVC     (KLU))
    ALLOCATE(DGEI%XAVG_FRZCVC      (KLU))
    !
    ALLOCATE(DGEI%XLEVCVC  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLESCC   (KLU,I%NPATCH))
!    ALLOCATE(XLETRGVC  (KLU,NPATCH))
    ALLOCATE(DGEI%XLETRCVC  (KLU,I%NPATCH))
!    ALLOCATE(XLERGVC   (KLU,NPATCH))
    ALLOCATE(DGEI%XLERCVC   (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLE_C_AC  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLE_V_CC  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLE_G_CC  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLE_N_CC  (KLU,I%NPATCH))
    !
    ALLOCATE(DGEI%XSWNET_VC    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XSWNET_GC    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XSWNET_NC    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XSWNET_NSC   (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLWNET_VC    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLWNET_GC    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLWNET_NC    (KLU,I%NPATCH))
    ALLOCATE(DGEI%XSWDOWN_GNC  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XLWDOWN_GNC  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XH_V_CC      (KLU,I%NPATCH))
    ALLOCATE(DGEI%XH_G_CC      (KLU,I%NPATCH))
    ALLOCATE(DGEI%XH_C_AC      (KLU,I%NPATCH))
    ALLOCATE(DGEI%XH_N_CC      (KLU,I%NPATCH))
    ALLOCATE(DGEI%XSR_GNC      (KLU,I%NPATCH))
    ALLOCATE(DGEI%XMELTCVC     (KLU,I%NPATCH))
    ALLOCATE(DGEI%XFRZCVC      (KLU,I%NPATCH))
  ELSE
    ALLOCATE(DGEI%XAVG_LEVCVC  (0))
    ALLOCATE(DGEI%XAVG_LESCC   (0))
    ALLOCATE(DGEI%XAVG_LETRGVC  (0))
    ALLOCATE(DGEI%XAVG_LETRCVC  (0))
    ALLOCATE(DGEI%XAVG_LERGVC   (0))
    ALLOCATE(DGEI%XAVG_LERCVC   (0))
    ALLOCATE(DGEI%XAVG_LE_C_AC  (0))
    ALLOCATE(DGEI%XAVG_LE_V_CC  (0))
    ALLOCATE(DGEI%XAVG_LE_G_CC  (0))
    ALLOCATE(DGEI%XAVG_LE_N_CC  (0))
    !
    ALLOCATE(DGEI%XAVG_SWNET_VC    (0))
    ALLOCATE(DGEI%XAVG_SWNET_GC    (0))
    ALLOCATE(DGEI%XAVG_SWNET_NC    (0))
    ALLOCATE(DGEI%XAVG_SWNET_NSC   (0))
    ALLOCATE(DGEI%XAVG_LWNET_VC    (0))
    ALLOCATE(DGEI%XAVG_LWNET_GC    (0))
    ALLOCATE(DGEI%XAVG_LWNET_NC    (0))
    ALLOCATE(DGEI%XAVG_SWDOWN_GNC  (0))
    ALLOCATE(DGEI%XAVG_LWDOWN_GNC  (0))
    ALLOCATE(DGEI%XAVG_H_V_CC      (0))
    ALLOCATE(DGEI%XAVG_H_G_CC      (0))
    ALLOCATE(DGEI%XAVG_H_C_AC      (0))
    ALLOCATE(DGEI%XAVG_H_N_CC      (0))
    ALLOCATE(DGEI%XAVG_SR_GNC      (0))
    ALLOCATE(DGEI%XAVG_MELTCVC     (0))
    ALLOCATE(DGEI%XAVG_FRZCVC      (0))
    !
    ALLOCATE(DGEI%XLEVCVC  (0,0))
    ALLOCATE(DGEI%XLESCC   (0,0))
!    ALLOCATE(XLETRGVC  (0,0))
    ALLOCATE(DGEI%XLETRCVC  (0,0))
!    ALLOCATE(XLERGVC   (0,0))
    ALLOCATE(DGEI%XLERCVC   (0,0))
    ALLOCATE(DGEI%XLE_C_AC  (0,0))
    ALLOCATE(DGEI%XLE_V_CC  (0,0))
    ALLOCATE(DGEI%XLE_G_CC  (0,0))
    ALLOCATE(DGEI%XLE_N_CC  (0,0))
    !
    ALLOCATE(DGEI%XSWNET_VC    (0,0))
    ALLOCATE(DGEI%XSWNET_GC    (0,0))
    ALLOCATE(DGEI%XSWNET_NC    (0,0))
    ALLOCATE(DGEI%XSWNET_NSC   (0,0))
    ALLOCATE(DGEI%XLWNET_VC    (0,0))
    ALLOCATE(DGEI%XLWNET_GC    (0,0))
    ALLOCATE(DGEI%XLWNET_NC    (0,0))
    ALLOCATE(DGEI%XSWDOWN_GNC  (0,0))
    ALLOCATE(DGEI%XLWDOWN_GNC  (0,0))
    ALLOCATE(DGEI%XH_V_CC      (0,0))
    ALLOCATE(DGEI%XH_G_CC      (0,0))
    ALLOCATE(DGEI%XH_C_AC      (0,0))
    ALLOCATE(DGEI%XH_N_CC      (0,0))
    ALLOCATE(DGEI%XSR_GNC      (0,0))
    ALLOCATE(DGEI%XMELTCVC     (0,0))
    ALLOCATE(DGEI%XFRZCVC      (0,0))
  ENDIF
  !
  ALLOCATE(DGI%XAVG_SWDC        (KLU))
  ALLOCATE(DGI%XAVG_SWUC        (KLU))
  ALLOCATE(DGI%XAVG_LWDC        (KLU))
  ALLOCATE(DGI%XAVG_LWUC        (KLU))
  ALLOCATE(DGI%XAVG_FMUC        (KLU))
  ALLOCATE(DGI%XAVG_FMVC        (KLU))
  ALLOCATE(DGI%XSWDC     (KLU,I%NPATCH))
  ALLOCATE(DGI%XSWUC     (KLU,I%NPATCH))
  ALLOCATE(DGI%XLWDC     (KLU,I%NPATCH))
  ALLOCATE(DGI%XLWUC     (KLU,I%NPATCH))
  ALLOCATE(DGI%XFMUC     (KLU,I%NPATCH))
  ALLOCATE(DGI%XFMVC     (KLU,I%NPATCH))
  !
  IF(I%LGLACIER)THEN
    ALLOCATE(DGEI%XAVG_ICEFLUXC(KLU))
    ALLOCATE(DGEI%XICEFLUXC(KLU,I%NPATCH))
  ENDIF
  !
#ifdef SFX_OL
  IF(DGEI%LWATER_BUDGET .OR. (LRESTART .AND. .NOT.DGEI%LRESET_BUDGETC))THEN
#else
  IF(DGEI%LWATER_BUDGET .OR. .NOT.DGEI%LRESET_BUDGETC)THEN
#endif          
    !      
    ALLOCATE(DGEI%XRAINFALLC  (KLU))
    ALLOCATE(DGEI%XSNOWFALLC  (KLU))
    ALLOCATE(DGEI%XAVG_DWGC   (KLU))
    ALLOCATE(DGEI%XAVG_DWGIC  (KLU))
    ALLOCATE(DGEI%XAVG_DWRC   (KLU))
    ALLOCATE(DGEI%XAVG_DSWEC  (KLU))
    ALLOCATE(DGEI%XAVG_WATBUDC(KLU))
    !
    ALLOCATE(DGEI%XDWGC   (KLU,I%NPATCH))
    ALLOCATE(DGEI%XDWGIC  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XDWRC   (KLU,I%NPATCH))
    ALLOCATE(DGEI%XDSWEC  (KLU,I%NPATCH))
    ALLOCATE(DGEI%XWATBUDC(KLU,I%NPATCH))
    !
  ELSE
    !      
    ALLOCATE(DGEI%XRAINFALLC  (0))
    ALLOCATE(DGEI%XSNOWFALLC  (0))
    ALLOCATE(DGEI%XAVG_DWGC   (0))
    ALLOCATE(DGEI%XAVG_DWGIC  (0))
    ALLOCATE(DGEI%XAVG_DWRC   (0))
    ALLOCATE(DGEI%XAVG_DSWEC  (0))
    ALLOCATE(DGEI%XAVG_WATBUDC(0))
    !
    ALLOCATE(DGEI%XDWGC   (0,0))
    ALLOCATE(DGEI%XDWGIC  (0,0))
    ALLOCATE(DGEI%XDWRC   (0,0))
    ALLOCATE(DGEI%XDSWEC  (0,0))
    ALLOCATE(DGEI%XWATBUDC(0,0))
    !          
  ENDIF
  !
  IF (.NOT.DGU%LREAD_BUDGETC) THEN
      DGEI%XAVG_RNC         = 0.0
      DGEI%XAVG_HC          = 0.0
      DGEI%XAVG_LEC         = 0.0
      DGEI%XAVG_LEIC        = 0.0
      DGEI%XAVG_GFLUXC      = 0.0
      DGEI%XAVG_LEGC        = 0.0
      DGEI%XAVG_LEGIC       = 0.0
      DGEI%XAVG_LEVC        = 0.0
      DGEI%XAVG_LESAC       = 0.0
      DGEI%XAVG_LESLC       = 0.0
      DGEI%XAVG_LERC        = 0.0
      DGEI%XAVG_LETRC       = 0.0
      DGEI%XAVG_EVAPC       = 0.0
      DGEI%XAVG_SUBLC       = 0.0
      DGEI%XAVG_SNDRIFTC    = 0.0
      DGEI%XAVG_DRAINC      = 0.0
      DGEI%XAVG_QSBC        = 0.0
      DGEI%XAVG_RUNOFFC     = 0.0
      DGEI%XAVG_HORTC       = 0.0
      DGEI%XAVG_DRIPC       = 0.0
      DGEI%XAVG_RRVEGC      = 0.0
      DGEI%XAVG_MELTC       = 0.0
      DGEI%XAVG_IRRIG_FLUXC = 0.0
      DGEI%XAVG_GPPC        = 0.0
      DGEI%XAVG_RESPC_AUTO  = 0.0
      DGEI%XAVG_RESPC_ECO   = 0.0  
      DGEI%XAVG_IFLOODC     = 0.0
      DGEI%XAVG_PFLOODC     = 0.0
      DGEI%XAVG_LE_FLOODC   = 0.0
      DGEI%XAVG_LEI_FLOODC  = 0.0      
      !
      DGEI%XRNC         = 0.0
      DGEI%XHC          = 0.0
      DGEI%XLEC         = 0.0
      DGEI%XLEIC        = 0.0
      DGEI%XGFLUXC      = 0.0
      DGEI%XLEGC        = 0.0 
      DGEI%XLEGIC       = 0.0
      DGEI%XLEVC        = 0.0
      DGEI%XLESAC       = 0.0
      DGEI%XLESLC       = 0.0
      DGEI%XLERC        = 0.0
      DGEI%XLETRC       = 0.0
      DGEI%XEVAPC       = 0.0
      DGEI%XSUBLC       = 0.0
      DGEI%XSNDRIFTC    = 0.0
      DGEI%XDRAINC      = 0.0
      DGEI%XQSBC        = 0.0
      DGEI%XRUNOFFC     = 0.0
      DGEI%XHORTC       = 0.0
      DGEI%XDRIPC       = 0.0
      DGEI%XRRVEGC      = 0.0
      DGEI%XMELTC       = 0.0
      DGEI%XIRRIG_FLUXC = 0.0
      DGEI%XGPPC        = 0.0
      DGEI%XRESPC_AUTO  = 0.0
      DGEI%XRESPC_ECO   = 0.0    
      DGEI%XIFLOODC     = 0.0
      DGEI%XPFLOODC     = 0.0
      DGEI%XLE_FLOODC   = 0.0
      DGEI%XLEI_FLOODC  = 0.0
      !
      IF (ISIZE_LMEB_PATCH>0) THEN
        DGEI%XAVG_LEVCVC    = 0.0
        DGEI%XAVG_LESCC     = 0.0
        DGEI%XAVG_LETRGVC   = 0.0
        DGEI%XAVG_LETRCVC   = 0.0
        DGEI%XAVG_LERGVC    = 0.0
        DGEI%XAVG_LERCVC    = 0.0
        DGEI%XAVG_LE_C_AC   = 0.0
        DGEI%XAVG_LE_V_CC   = 0.0
        DGEI%XAVG_LE_G_CC   = 0.0
        DGEI%XAVG_LE_N_CC   = 0.0
        !
        DGEI%XAVG_SWNET_VC     = 0.0
        DGEI%XAVG_SWNET_GC     = 0.0
        DGEI%XAVG_SWNET_NC     = 0.0
        DGEI%XAVG_SWNET_NSC    = 0.0
        DGEI%XAVG_LWNET_VC     = 0.0
        DGEI%XAVG_LWNET_GC     = 0.0
        DGEI%XAVG_LWNET_NC     = 0.0
        DGEI%XAVG_SWDOWN_GNC   = 0.0
        DGEI%XAVG_LWDOWN_GNC   = 0.0
        DGEI%XAVG_H_V_CC       = 0.0
        DGEI%XAVG_H_G_CC       = 0.0
        DGEI%XAVG_H_C_AC       = 0.0
        DGEI%XAVG_H_N_CC       = 0.0
        DGEI%XAVG_SR_GNC       = 0.0
        DGEI%XAVG_MELTCVC      = 0.0
        DGEI%XAVG_FRZCVC       = 0.0
!
        DGEI%XLEVCVC    = 0.0
        DGEI%XLESCC     = 0.0
!        XLETRGVC   = 0.0
        DGEI%XLETRCVC   = 0.0
!        XLERGVC    = 0.0
        DGEI%XLERCVC    = 0.0
        DGEI%XLE_C_AC   = 0.0
        DGEI%XLE_V_CC   = 0.0
        DGEI%XLE_G_CC   = 0.0
        DGEI%XLE_N_CC   = 0.0
        !
        DGEI%XSWNET_VC     = 0.0
        DGEI%XSWNET_GC     = 0.0
        DGEI%XSWNET_NC     = 0.0
        DGEI%XSWNET_NSC    = 0.0
        DGEI%XLWNET_VC     = 0.0
        DGEI%XLWNET_GC     = 0.0
        DGEI%XLWNET_NC     = 0.0
        DGEI%XSWDOWN_GNC   = 0.0
        DGEI%XLWDOWN_GNC   = 0.0
        DGEI%XH_V_CC       = 0.0
        DGEI%XH_G_CC       = 0.0
        DGEI%XH_C_AC       = 0.0
        DGEI%XH_N_CC       = 0.0
        DGEI%XSR_GNC       = 0.0
        DGEI%XMELTCVC      = 0.0
        DGEI%XFRZCVC       = 0.0
      ENDIF
      !
      DGI%XAVG_SWDC = 0.0
      DGI%XAVG_SWUC = 0.0
      DGI%XAVG_LWDC = 0.0
      DGI%XAVG_LWUC = 0.0
      DGI%XAVG_FMUC = 0.0
      DGI%XAVG_FMVC = 0.0
      DGI%XSWDC     = 0.0
      DGI%XSWUC     = 0.0
      DGI%XLWDC     = 0.0
      DGI%XLWUC     = 0.0
      DGI%XFMUC     = 0.0
      DGI%XFMVC     = 0.0
      !
      IF(I%LGLACIER)THEN
         DGEI%XAVG_ICEFLUXC = 0.0
         DGEI%XICEFLUXC     = 0.0
      ENDIF
      !
      IF(DGEI%LWATER_BUDGET)THEN
        !      
        DGEI%XRAINFALLC   = 0.0
        DGEI%XSNOWFALLC   = 0.0
        DGEI%XAVG_DWGC    = 0.0
        DGEI%XAVG_DWGIC   = 0.0
        DGEI%XAVG_DWRC    = 0.0
        DGEI%XAVG_DSWEC   = 0.0
        DGEI%XAVG_WATBUDC = 0.0
        !
        DGEI%XDWGC    = 0.0
        DGEI%XDWGIC   = 0.0
        DGEI%XDWRC    = 0.0
        DGEI%XDSWEC   = 0.0
        DGEI%XWATBUDC = 0.0
        !
      ENDIF
      !     
  ELSEIF (DGU%LREAD_BUDGETC.AND.DGEI%LRESET_BUDGETC) THEN
      !
      DGEI%XAVG_RNC         = 0.0
      DGEI%XAVG_HC          = 0.0
      DGEI%XAVG_LEC         = 0.0
      DGEI%XAVG_LEIC        = 0.0
      DGEI%XAVG_GFLUXC      = 0.0
      DGEI%XAVG_LEGC        = 0.0
      DGEI%XAVG_LEGIC       = 0.0
      DGEI%XAVG_LEVC        = 0.0
      DGEI%XAVG_LESAC       = 0.0
      DGEI%XAVG_LESLC       = 0.0
      DGEI%XAVG_LERC        = 0.0
      DGEI%XAVG_LETRC       = 0.0
      DGEI%XAVG_EVAPC       = 0.0
      DGEI%XAVG_SUBLC       = 0.0
      DGEI%XAVG_SNDRIFTC    = 0.0
      DGEI%XAVG_DRAINC      = 0.0
      DGEI%XAVG_QSBC        = 0.0
      DGEI%XAVG_RUNOFFC     = 0.0
      DGEI%XAVG_HORTC       = 0.0
      DGEI%XAVG_DRIPC       = 0.0
      DGEI%XAVG_RRVEGC      = 0.0
      DGEI%XAVG_MELTC       = 0.0
      DGEI%XAVG_IRRIG_FLUXC = 0.0
      DGEI%XAVG_GPPC        = 0.0
      DGEI%XAVG_RESPC_AUTO  = 0.0
      DGEI%XAVG_RESPC_ECO   = 0.0    
      DGEI%XAVG_IFLOODC     = 0.0
      DGEI%XAVG_PFLOODC     = 0.0
      DGEI%XAVG_LE_FLOODC   = 0.0
      DGEI%XAVG_LEI_FLOODC  = 0.0      
      !
      IF (ISIZE_LMEB_PATCH>0) THEN
        DGEI%XAVG_LEVCVC    = 0.0
        DGEI%XAVG_LESCC     = 0.0
        DGEI%XAVG_LETRGVC   = 0.0
        DGEI%XAVG_LETRCVC   = 0.0
        DGEI%XAVG_LERGVC    = 0.0
        DGEI%XAVG_LERCVC    = 0.0
        DGEI%XAVG_LE_C_AC   = 0.0
        DGEI%XAVG_LE_V_CC   = 0.0
        DGEI%XAVG_LE_G_CC   = 0.0
        DGEI%XAVG_LE_N_CC   = 0.0
        !
        DGEI%XAVG_SWNET_VC     = 0.0
        DGEI%XAVG_SWNET_GC     = 0.0
        DGEI%XAVG_SWNET_NC     = 0.0
        DGEI%XAVG_SWNET_NSC    = 0.0
        DGEI%XAVG_LWNET_VC     = 0.0
        DGEI%XAVG_LWNET_GC     = 0.0
        DGEI%XAVG_LWNET_NC     = 0.0
        DGEI%XAVG_SWDOWN_GNC   = 0.0
        DGEI%XAVG_LWDOWN_GNC   = 0.0
        DGEI%XAVG_H_V_CC       = 0.0
        DGEI%XAVG_H_G_CC       = 0.0
        DGEI%XAVG_H_C_AC       = 0.0
        DGEI%XAVG_H_N_CC       = 0.0
        DGEI%XAVG_SR_GNC       = 0.0
        DGEI%XAVG_MELTCVC      = 0.0
        DGEI%XAVG_FRZCVC       = 0.0
        !
        DGEI%XLEVCVC    = 0.0
        DGEI%XLESCC     = 0.0
!        XLETRGVC   = 0.0
        DGEI%XLETRCVC   = 0.0
!        XLERGVC    = 0.0
        DGEI%XLERCVC    = 0.0
        DGEI%XLE_C_AC   = 0.0
        DGEI%XLE_V_CC   = 0.0
        DGEI%XLE_G_CC   = 0.0
        DGEI%XLE_N_CC   = 0.0
        !
        DGEI%XSWNET_VC     = 0.0
        DGEI%XSWNET_GC     = 0.0
        DGEI%XSWNET_NC     = 0.0
        DGEI%XSWNET_NSC    = 0.0
        DGEI%XLWNET_VC     = 0.0
        DGEI%XLWNET_GC     = 0.0
        DGEI%XLWNET_NC     = 0.0
        DGEI%XSWDOWN_GNC   = 0.0
        DGEI%XLWDOWN_GNC   = 0.0
        DGEI%XH_V_CC       = 0.0
        DGEI%XH_G_CC       = 0.0
        DGEI%XH_C_AC       = 0.0
        DGEI%XH_N_CC       = 0.0
        DGEI%XSR_GNC       = 0.0
        DGEI%XMELTCVC      = 0.0
        DGEI%XFRZCVC       = 0.0
      ENDIF
      !
      DGEI%XRNC         = 0.0
      DGEI%XHC          = 0.0
      DGEI%XLEC         = 0.0
      DGEI%XLEIC        = 0.0
      DGEI%XGFLUXC      = 0.0
      DGEI%XLEGC        = 0.0 
      DGEI%XLEGIC       = 0.0
      DGEI%XLEVC        = 0.0
      DGEI%XLESAC       = 0.0
      DGEI%XLESLC       = 0.0
      DGEI%XLERC        = 0.0
      DGEI%XLETRC       = 0.0
      DGEI%XEVAPC       = 0.0
      DGEI%XSUBLC       = 0.0
      DGEI%XSNDRIFTC    = 0.0
      DGEI%XDRAINC      = 0.0
      DGEI%XQSBC        = 0.0
      DGEI%XRUNOFFC     = 0.0
      DGEI%XHORTC       = 0.0
      DGEI%XDRIPC       = 0.0
      DGEI%XRRVEGC      = 0.0
      DGEI%XMELTC       = 0.0
      DGEI%XIRRIG_FLUXC = 0.0
      DGEI%XGPPC        = 0.0
      DGEI%XRESPC_AUTO  = 0.0
      DGEI%XRESPC_ECO   = 0.0   
      DGEI%XIFLOODC     = 0.0
      DGEI%XPFLOODC     = 0.0
      DGEI%XLE_FLOODC   = 0.0
      DGEI%XLEI_FLOODC  = 0.0
      !
      DGI%XAVG_SWDC = 0.0
      DGI%XAVG_SWUC = 0.0
      DGI%XAVG_LWDC = 0.0
      DGI%XAVG_LWUC = 0.0
      DGI%XAVG_FMUC = 0.0
      DGI%XAVG_FMVC = 0.0
      DGI%XSWDC     = 0.0
      DGI%XSWUC     = 0.0
      DGI%XLWDC     = 0.0
      DGI%XLWUC     = 0.0
      DGI%XFMUC     = 0.0
      DGI%XFMVC     = 0.0      
      !
      IF(I%LGLACIER)THEN
         DGEI%XAVG_ICEFLUXC = 0.0
         DGEI%XICEFLUXC     = 0.0
      ENDIF
      !
      IF(DGEI%LWATER_BUDGET)THEN
        !      
        DGEI%XRAINFALLC   = 0.0
        DGEI%XSNOWFALLC   = 0.0
        DGEI%XAVG_DWGC    = 0.0
        DGEI%XAVG_DWGIC   = 0.0
        DGEI%XAVG_DWRC    = 0.0
        DGEI%XAVG_DSWEC   = 0.0
        DGEI%XAVG_WATBUDC = 0.0
        !
        DGEI%XDWGC    = 0.0
        DGEI%XDWGIC   = 0.0
        DGEI%XDWRC    = 0.0
        DGEI%XDSWEC   = 0.0
        DGEI%XWATBUDC = 0.0
        !
      ENDIF
      !
  ELSE
    !      
    CALL READ_SURF(&
                   HPROGRAM,'VERSION',IVERSION,IRESP)
    CALL READ_SURF(&
                   HPROGRAM,'BUG ',IBUG,IRESP)
    !
    YREC='RNC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_RNC    ,IRESP)
    YREC='HC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_HC     ,IRESP)
    YREC='LEC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LEC    ,IRESP)
    YREC='LEIC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LEIC   ,IRESP)      
    YREC='GFLUXC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_GFLUXC ,IRESP)
    YREC='LEGC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LEGC   ,IRESP)
    YREC='LEGIC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LEGIC  ,IRESP)
    YREC='LEVC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LEVC   ,IRESP)
    YREC='LESC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LESAC  ,IRESP)
    IF(I%TSNOW%SCHEME=='3-L' .OR. I%TSNOW%SCHEME=='CRO')THEN
       IF(IVERSION>7 .OR. IVERSION==7 .AND. IBUG>=3)THEN
         YREC='LESLC_ISBA'
         CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LESLC,IRESP)  
       ELSE
         DGEI%XAVG_LESLC=0.0
       ENDIF
       IF(IVERSION>=8)THEN
         YREC='SNDRIFC_ISBA'
         CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_SNDRIFTC,IRESP)      
       ELSE
         DGEI%XAVG_SNDRIFTC = 0.0
       ENDIF
    ELSE
      DGEI%XAVG_LESLC = 0.0
      DGEI%XAVG_SNDRIFTC = 0.0
    ENDIF
    YREC='LERC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LERC   ,IRESP)
    YREC='LETRC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LETRC  ,IRESP)
    YREC='EVAPC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_EVAPC  ,IRESP)
    IF (IVERSION<8)THEN
       DGEI%XAVG_SUBLC = 0.0
    ELSE
       YREC='SUBLC_ISBA'
       CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_SUBLC  ,IRESP) 
    ENDIF    
    YREC='DRAINC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_DRAINC ,IRESP)
    YREC='RUNOFFC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_RUNOFFC,IRESP)
    YREC='DRIVEGC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_DRIPC  ,IRESP)
    YREC='RRVEGC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_RRVEGC ,IRESP)
    YREC='SNOMLTC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_MELTC,IRESP)
    !
    IF (ISIZE_LMEB_PATCH>0) THEN
      YREC='LEVCVC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LEVCVC ,IRESP)
      YREC='LESCC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LESCC ,IRESP)
      YREC='LETRGVC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LETRGVC ,IRESP)
      YREC='LETRCVC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LETRCVC ,IRESP)
      YREC='LERGVC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LERGVC ,IRESP)
      YREC='LERCVC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LERCVC ,IRESP)
      YREC='LE_C_AC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LE_C_AC ,IRESP)
      YREC='LE_V_CC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LE_V_CC ,IRESP)
      YREC='LE_G_CC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LE_G_CC ,IRESP)
      YREC='LE_N_CC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LE_N_CC ,IRESP)
      !
      YREC='SWNT_VC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_SWNET_VC ,IRESP)
      YREC='SWNT_GC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_SWNET_GC ,IRESP)
      YREC='SWNT_NC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_SWNET_NC ,IRESP)
      YREC='SWNT_NSC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_SWNET_NSC ,IRESP)
      YREC='LWNT_VC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LWNET_VC ,IRESP)
      YREC='LWNT_GC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LWNET_GC ,IRESP)
      YREC='LWNT_NC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LWNET_NC ,IRESP)
      YREC='SWDN_GNC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_SWDOWN_GNC ,IRESP)
      YREC='LWDN_GNC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LWDOWN_GNC ,IRESP)
      YREC='H_V_CC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_H_V_CC ,IRESP)
      YREC='H_G_CC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_H_G_CC ,IRESP)
      YREC='H_C_AC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_H_C_AC ,IRESP)
      YREC='H_N_CC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_H_N_CC ,IRESP)
      YREC='SR_GNC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_SR_GNC ,IRESP)
      YREC='MELTCVC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_MELTCVC ,IRESP)
      YREC='FRZCVC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_FRZCVC ,IRESP)
    ENDIF
    !
    IF (LAGRIP) THEN
      YREC='IRRIGC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_IRRIG_FLUXC,IRESP)    
    ELSE
      DGEI%XAVG_IRRIG_FLUXC = 0.0
    ENDIF
    !
    IF(I%CPHOTO/='NON' .AND. (IVERSION>7 .OR. IVERSION==7 .AND. IBUG>=3))THEN
      YREC='GPPC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_GPPC,IRESP)
      YREC='RC_AUTO_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_RESPC_AUTO,IRESP)
      YREC='RC_ECO_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_RESPC_ECO,IRESP)        
    ELSE
      DGEI%XAVG_GPPC = 0.0
      DGEI%XAVG_RESPC_AUTO = 0.0
      DGEI%XAVG_RESPC_ECO = 0.0
    ENDIF
    !
    IF((I%CRUNOFF=='SGH'.AND.I%CISBA=='DIF').AND.IVERSION>=8)THEN
      YREC='QSBC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_QSBC,IRESP)              
    ELSE
      DGEI%XAVG_QSBC = 0.0
    ENDIF
    !
    IF(I%CHORT=='SGH'.OR.I%CISBA=='DIF')THEN
      YREC='HORTONC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_HORTC,IRESP)
    ELSE
      DGEI%XAVG_HORTC = 0.0
    ENDIF
    !
    IF(I%LFLOOD)THEN
      YREC='IFLOODC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_IFLOODC,IRESP)
      YREC='PFLOODC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_PFLOODC,IRESP)
      YREC='LEFC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LE_FLOODC,IRESP)
      YREC='LEIFC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_LEI_FLOODC,IRESP)
    ELSE
      DGEI%XAVG_IFLOODC   = 0.0
      DGEI%XAVG_PFLOODC   = 0.0
      DGEI%XAVG_LE_FLOODC = 0.0
      DGEI%XAVG_LEI_FLOODC = 0.0
    ENDIF
!      
    IF (DGI%LRAD_BUDGET) THEN
      YREC='SWDC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGI%XAVG_SWDC,IRESP)
      YREC='SWUC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGI%XAVG_SWUC,IRESP)
      YREC='LWDC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGI%XAVG_LWDC,IRESP)
      YREC='LWUC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGI%XAVG_LWUC,IRESP)
    ENDIF
    YREC='FMUC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGI%XAVG_FMUC,IRESP)
    YREC='FMVC_ISBA'
    CALL READ_SURF(&
                   HPROGRAM,YREC,DGI%XAVG_FMVC,IRESP)      
    !
    IF(I%LGLACIER)THEN
      YREC='ICE_FC_ISBA'         
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_ICEFLUXC,IRESP)      
    ENDIF
    !  
    IF(DGEI%LWATER_BUDGET .AND. (IVERSION>7 .OR. IVERSION==7 .AND. IBUG>=3))THEN 
      YREC='RAINFC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XRAINFALLC,IRESP)
      YREC='SNOWFC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XSNOWFALLC,IRESP)
      YREC='DWGC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_DWGC,IRESP)
      YREC='DWGIC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_DWGIC,IRESP)
      YREC='DWRC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_DWRC,IRESP)
      YREC='DSWEC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_DSWEC,IRESP)
      YREC='WATBUDC_ISBA'
      CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XAVG_WATBUDC,IRESP)
    ELSE
      DGEI%XRAINFALLC = 0.0
      DGEI%XSNOWFALLC = 0.0
      DGEI%XAVG_DWGC = 0.0
      DGEI%XAVG_DWGIC = 0.0
      DGEI%XAVG_DWRC = 0.0
      DGEI%XAVG_DSWEC = 0.0
      DGEI%XAVG_WATBUDC = 0.0
    ENDIF
    !
    IF(DGI%LPATCH_BUDGET .AND. I%NPATCH>1)THEN
      !
      CALL READ_SURF(&
                   HPROGRAM,'VERSION',IVERSION,IRESP)
      CALL READ_SURF(&
                   HPROGRAM,'BUG ',IBUG,IRESP)
      YREC2=''
      IF (IVERSION<7 .OR. IVERSION==7 .AND. IBUG<3) YREC2='ATCH'
      YREC='RNC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XRNC    ,IRESP)
      YREC='HC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XHC     ,IRESP)
      YREC='LEC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLEC    ,IRESP)
      YREC='LEIC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLEIC   ,IRESP)        
      YREC='GFLUXC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XGFLUXC ,IRESP)
      YREC='LEGC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLEGC   ,IRESP)
      YREC='LEGIC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLEGIC  ,IRESP)
      YREC='LEVC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLEVC   ,IRESP)
      YREC='LESC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLESAC  ,IRESP)
      IF(I%TSNOW%SCHEME=='3-L' .OR. I%TSNOW%SCHEME=='CRO')THEN
         IF(IVERSION>7 .OR. IVERSION==7 .AND. IBUG>=3)THEN
           YREC='LESLC_P'
           CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLESLC,IRESP)  
         ELSE
           DGEI%XLESLC = 0.0
         ENDIF
         IF(IVERSION>=8)THEN
           YREC='SNDRIFC_P'
           CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XSNDRIFTC,IRESP)        
         ELSE
           DGEI%XSNDRIFTC = 0.0
         ENDIF        
      ELSE
        DGEI%XLESLC = 0.0
        DGEI%XSNDRIFTC = 0.0
      ENDIF
      YREC='LERC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLERC   ,IRESP)
      YREC='LETRC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLETRC  ,IRESP)
      YREC='EVAPC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XEVAPC  ,IRESP)
      IF (IVERSION<8)THEN
         DGEI%XSUBLC = 0.0
      ELSE
         YREC='SUBLC_P'
         CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XSUBLC,IRESP)
      ENDIF    
      YREC='DRAINC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XDRAINC ,IRESP)
      YREC='RUNOFFC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XRUNOFFC,IRESP)
      YREC='DRIVEGC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XDRIPC,IRESP)
      YREC='RRVEGC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XRRVEGC,IRESP)
      YREC='SNOMLTC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XMELTC,IRESP)
      !
      IF (ISIZE_LMEB_PATCH>0) THEN
        YREC='LEVCVC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLEVCVC ,IRESP)
        YREC='LESCC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLESCC ,IRESP)
!        YREC='LETRGVC_P'
!        CALL READ_SURF(HPROGRAM,YREC,XLETRGVC ,IRESP)
        YREC='LETRCVC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLETRCVC ,IRESP)
!        YREC='LERGVC_P'
!        CALL READ_SURF(HPROGRAM,YREC,XLERGVC ,IRESP)
        YREC='LERCVC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLERCVC ,IRESP)
        YREC='LE_C_AC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLE_C_AC ,IRESP)
        YREC='LE_V_CC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLE_V_CC ,IRESP)
        YREC='LE_G_CC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLE_G_CC ,IRESP)
        YREC='LE_N_CC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLE_N_CC ,IRESP)
        !
        YREC='SWNT_VC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XSWNET_VC ,IRESP)
        YREC='SWNT_GC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XSWNET_GC ,IRESP)
        YREC='SWNT_NC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XSWNET_NC ,IRESP)
        YREC='SWNT_NSC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XSWNET_NSC ,IRESP)
        YREC='LWNT_VC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLWNET_VC ,IRESP)
        YREC='LWNT_GC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLWNET_GC ,IRESP)
        YREC='LWNT_NC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLWNET_NC ,IRESP)
        YREC='SWDN_GNC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XSWDOWN_GNC ,IRESP)
        YREC='LWDN_GNC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XLWDOWN_GNC ,IRESP)
        YREC='H_V_CC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XH_V_CC ,IRESP)
        YREC='H_G_CC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XH_G_CC ,IRESP)
        YREC='H_C_AC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XH_C_AC ,IRESP)
        YREC='H_N_CC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XH_N_CC ,IRESP)
        YREC='SR_GNC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XSR_GNC ,IRESP)
        YREC='MELTCVC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XMELTCVC ,IRESP)
        YREC='FRZCVC_P'
        CALL READ_SURF(&
                   HPROGRAM,YREC,DGEI%XFRZCVC ,IRESP)
      ENDIF
      !
      IF((I%CRUNOFF=='SGH'.AND.I%CISBA=='DIF').AND.IVERSION>=8)THEN
        YREC='QSBC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XQSBC,IRESP)              
      ELSE
        DGEI%XQSBC = 0.0
      ENDIF
      !      
      IF (LAGRIP) THEN
        YREC='IRRIGC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XIRRIG_FLUXC,IRESP)
      ELSE
        DGEI%XIRRIG_FLUXC = 0.0
      ENDIF
      !
      IF(I%CPHOTO/='NON' .AND. (IVERSION>7 .OR. IVERSION==7 .AND. IBUG>=3))THEN
        YREC='GPPC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XGPPC,IRESP)
        YREC='RC_AUTO_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XRESPC_AUTO,IRESP)
        YREC='RC_ECO_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XRESPC_ECO,IRESP)  
      ELSE
        DGEI%XGPPC      =0.0
        DGEI%XRESPC_AUTO=0.0
        DGEI%XRESPC_ECO =0.0
      ENDIF
      !
      IF (DGI%LRAD_BUDGET) THEN
        YREC='SWDC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGI%XSWDC,IRESP)
        YREC='SWUC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGI%XSWUC,IRESP)
        YREC='LWDC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGI%XLWDC,IRESP)
        YREC='LWUC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGI%XLWUC,IRESP)
      ENDIF
      YREC='FMUC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGI%XFMUC,IRESP)
      YREC='FMVC_P'
      CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGI%XFMVC,IRESP)
      !
      IF(I%LGLACIER)THEN
        YREC='ICE_FC_P'         
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XICEFLUXC,IRESP)      
      ENDIF
      !
      IF(I%CHORT=='SGH'.OR.I%CISBA=='DIF')THEN
        YREC='HORTONC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XHORTC    ,IRESP)
      ELSE
        DGEI%XHORTC     = 0.0
      ENDIF
      !
      IF(I%LFLOOD)THEN
        YREC='IFLOODC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XIFLOODC,IRESP)
        YREC='PFLOODC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XPFLOODC,IRESP)
        YREC='LEFC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLE_FLOODC,IRESP)
        YREC='LEIFC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XLEI_FLOODC,IRESP)
      ELSE
        DGEI%XIFLOODC       = 0.0
        DGEI%XPFLOODC       = 0.0
        DGEI%XLE_FLOODC     = 0.0
        DGEI%XLEI_FLOODC    = 0.0
      ENDIF
      !  
      IF(DGEI%LWATER_BUDGET .AND. (IVERSION>7 .OR. IVERSION==7 .AND. IBUG>=3))THEN 
        YREC='DWGC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XDWGC,IRESP)
        YREC='DWGIC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XDWGIC,IRESP)
        YREC='DWRC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XDWRC,IRESP)
        YREC='DSWEC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XDSWEC,IRESP)
        YREC='WATBUDC_P'
        CALL READ_SURF(&
                   HPROGRAM,TRIM(YREC)//YREC2,DGEI%XWATBUDC,IRESP)
      ELSE
        DGEI%XDWGC = 0.0
        DGEI%XDWGIC = 0.0
        DGEI%XDWRC = 0.0
        DGEI%XDSWEC = 0.0
        DGEI%XWATBUDC = 0.0
      ENDIF
      !
    ELSE
      !
      DGEI%XRNC         = 0.0
      DGEI%XHC          = 0.0
      DGEI%XLEC         = 0.0
      DGEI%XLEIC        = 0.0
      DGEI%XGFLUXC      = 0.0
      DGEI%XLEGC        = 0.0 
      DGEI%XLEGIC       = 0.0
      DGEI%XLEVC        = 0.0
      DGEI%XLESAC       = 0.0
      DGEI%XLESLC       = 0.0
      DGEI%XLERC        = 0.0
      DGEI%XLETRC       = 0.0
      DGEI%XEVAPC       = 0.0
      DGEI%XSUBLC       = 0.0
      DGEI%XSNDRIFTC    = 0.0
      DGEI%XDRAINC      = 0.0
      DGEI%XQSBC        = 0.0
      DGEI%XRUNOFFC     = 0.0
      DGEI%XHORTC       = 0.0
      DGEI%XDRIPC       = 0.0
      DGEI%XRRVEGC      = 0.0
      DGEI%XMELTC       = 0.0
      DGEI%XIRRIG_FLUXC = 0.0
      DGEI%XGPPC        = 0.0
      DGEI%XRESPC_AUTO  = 0.0
      DGEI%XRESPC_ECO   = 0.0   
      DGEI%XIFLOODC     = 0.0
      DGEI%XPFLOODC     = 0.0
      DGEI%XLE_FLOODC   = 0.0
      DGEI%XLEI_FLOODC  = 0.0
      !
      IF (ISIZE_LMEB_PATCH>0) THEN
        DGEI%XLEVCVC    = 0.0
        DGEI%XLESCC     = 0.0
!        XLETRGVC   = 0.0
        DGEI%XLETRCVC   = 0.0
!        XLERGVC    = 0.0
        DGEI%XLERCVC    = 0.0
        DGEI%XLE_C_AC   = 0.0
        DGEI%XLE_V_CC   = 0.0
        DGEI%XLE_G_CC   = 0.0
        DGEI%XLE_N_CC   = 0.0
        !
        DGEI%XSWNET_VC     = 0.0
        DGEI%XSWNET_GC     = 0.0
        DGEI%XSWNET_NC     = 0.0
        DGEI%XSWNET_NSC    = 0.0
        DGEI%XLWNET_VC     = 0.0
        DGEI%XLWNET_GC     = 0.0
        DGEI%XLWNET_NC     = 0.0
        DGEI%XSWDOWN_GNC   = 0.0
        DGEI%XLWDOWN_GNC   = 0.0
        DGEI%XH_V_CC       = 0.0
        DGEI%XH_G_CC       = 0.0
        DGEI%XH_C_AC       = 0.0
        DGEI%XH_N_CC       = 0.0
        DGEI%XSR_GNC       = 0.0
        DGEI%XMELTCVC      = 0.0
        DGEI%XFRZCVC       = 0.0
      ENDIF
      !
      DGI%XSWDC     = 0.0
      DGI%XSWUC     = 0.0
      DGI%XLWDC     = 0.0
      DGI%XLWUC     = 0.0
      DGI%XFMUC     = 0.0
      DGI%XFMVC     = 0.0
      !
      IF(I%LGLACIER)THEN
        DGEI%XICEFLUXC=0.0      
      ENDIF
      !   
      IF(DGEI%LWATER_BUDGET)THEN
        DGEI%XDWGC    = 0.0
        DGEI%XDWGIC   = 0.0
        DGEI%XDWRC    = 0.0
        DGEI%XDSWEC   = 0.0
        DGEI%XWATBUDC = 0.0
      ENDIF
      !   
    ENDIF
    !
  ENDIF
ELSE
  ALLOCATE(DGEI%XAVG_RNC        (0))
  ALLOCATE(DGEI%XAVG_HC         (0))
  ALLOCATE(DGEI%XAVG_LEC        (0))
  ALLOCATE(DGEI%XAVG_LEIC       (0))
  ALLOCATE(DGEI%XAVG_GFLUXC     (0))
  ALLOCATE(DGEI%XAVG_LEGC       (0))
  ALLOCATE(DGEI%XAVG_LEGIC      (0))
  ALLOCATE(DGEI%XAVG_LEVC       (0))
  ALLOCATE(DGEI%XAVG_LESAC      (0))
  ALLOCATE(DGEI%XAVG_LESLC      (0))
  ALLOCATE(DGEI%XAVG_LERC       (0))
  ALLOCATE(DGEI%XAVG_LETRC      (0))
  ALLOCATE(DGEI%XAVG_EVAPC      (0))
  ALLOCATE(DGEI%XAVG_SUBLC      (0))
  ALLOCATE(DGEI%XAVG_SNDRIFTC   (0))
  ALLOCATE(DGEI%XAVG_DRAINC     (0))
  ALLOCATE(DGEI%XAVG_QSBC       (0))
  ALLOCATE(DGEI%XAVG_RUNOFFC    (0))
  ALLOCATE(DGEI%XAVG_HORTC      (0))
  ALLOCATE(DGEI%XAVG_DRIPC      (0))
  ALLOCATE(DGEI%XAVG_RRVEGC     (0))
  ALLOCATE(DGEI%XAVG_MELTC      (0))
  ALLOCATE(DGEI%XAVG_IRRIG_FLUXC(0))
  ALLOCATE(DGEI%XAVG_GPPC       (0))
  ALLOCATE(DGEI%XAVG_RESPC_AUTO (0))
  ALLOCATE(DGEI%XAVG_RESPC_ECO  (0)) 
  ALLOCATE(DGEI%XAVG_IFLOODC    (0))
  ALLOCATE(DGEI%XAVG_PFLOODC    (0))
  ALLOCATE(DGEI%XAVG_LE_FLOODC  (0))
  ALLOCATE(DGEI%XAVG_LEI_FLOODC (0))
  
!
  ALLOCATE(DGEI%XRNC        (0,0))
  ALLOCATE(DGEI%XHC         (0,0))
  ALLOCATE(DGEI%XLEC        (0,0))
  ALLOCATE(DGEI%XLEIC       (0,0))
  ALLOCATE(DGEI%XGFLUXC     (0,0))
  ALLOCATE(DGEI%XLEGC       (0,0))
  ALLOCATE(DGEI%XLEGIC      (0,0))
  ALLOCATE(DGEI%XLEVC       (0,0))
  ALLOCATE(DGEI%XLESAC      (0,0))
  ALLOCATE(DGEI%XLESLC      (0,0))
  ALLOCATE(DGEI%XLERC       (0,0))
  ALLOCATE(DGEI%XLETRC      (0,0))
  ALLOCATE(DGEI%XEVAPC      (0,0))
  ALLOCATE(DGEI%XSUBLC      (0,0))
  ALLOCATE(DGEI%XSNDRIFTC   (0,0))
  ALLOCATE(DGEI%XDRAINC     (0,0))
  ALLOCATE(DGEI%XQSBC       (0,0))
  ALLOCATE(DGEI%XRUNOFFC    (0,0))
  ALLOCATE(DGEI%XHORTC      (0,0))
  ALLOCATE(DGEI%XDRIPC      (0,0))
  ALLOCATE(DGEI%XRRVEGC     (0,0))
  ALLOCATE(DGEI%XMELTC      (0,0))
  ALLOCATE(DGEI%XIRRIG_FLUXC(0,0))
  ALLOCATE(DGEI%XGPPC       (0,0))
  ALLOCATE(DGEI%XRESPC_AUTO (0,0))
  ALLOCATE(DGEI%XRESPC_ECO  (0,0))  
  ALLOCATE(DGEI%XIFLOODC    (0,0))
  ALLOCATE(DGEI%XPFLOODC    (0,0))
  ALLOCATE(DGEI%XLE_FLOODC  (0,0))
  ALLOCATE(DGEI%XLEI_FLOODC (0,0))
!
  ALLOCATE(DGI%XAVG_SWDC   (0))
  ALLOCATE(DGI%XAVG_SWUC   (0))
  ALLOCATE(DGI%XAVG_LWDC   (0))
  ALLOCATE(DGI%XAVG_LWUC   (0))
  ALLOCATE(DGI%XAVG_FMUC   (0))
  ALLOCATE(DGI%XAVG_FMVC   (0))
  ALLOCATE(DGI%XSWDC     (0,0))
  ALLOCATE(DGI%XSWUC     (0,0))
  ALLOCATE(DGI%XLWDC     (0,0))
  ALLOCATE(DGI%XLWUC     (0,0))
  ALLOCATE(DGI%XFMUC     (0,0))
  ALLOCATE(DGI%XFMVC     (0,0))
  !      
  ALLOCATE(DGEI%XRAINFALLC  (0))
  ALLOCATE(DGEI%XSNOWFALLC  (0))
  ALLOCATE(DGEI%XAVG_DWGC   (0))
  ALLOCATE(DGEI%XAVG_DWGIC  (0))
  ALLOCATE(DGEI%XAVG_DWRC   (0))
  ALLOCATE(DGEI%XAVG_DSWEC  (0))
  ALLOCATE(DGEI%XAVG_WATBUDC(0))
  !
  ALLOCATE(DGEI%XDWGC   (0,0))
  ALLOCATE(DGEI%XDWGIC  (0,0))
  ALLOCATE(DGEI%XDWRC   (0,0))
  ALLOCATE(DGEI%XDSWEC  (0,0))
  ALLOCATE(DGEI%XWATBUDC(0,0))
  !
  ALLOCATE(DGEI%XAVG_LEVCVC  (0))
  ALLOCATE(DGEI%XAVG_LESCC   (0))
  ALLOCATE(DGEI%XAVG_LETRGVC  (0))
  ALLOCATE(DGEI%XAVG_LETRCVC  (0))
  ALLOCATE(DGEI%XAVG_LERGVC   (0))
  ALLOCATE(DGEI%XAVG_LERCVC   (0))
  ALLOCATE(DGEI%XAVG_LE_C_AC  (0))
  ALLOCATE(DGEI%XAVG_LE_V_CC  (0))
  ALLOCATE(DGEI%XAVG_LE_G_CC  (0))
  ALLOCATE(DGEI%XAVG_LE_N_CC  (0))
  !
  ALLOCATE(DGEI%XAVG_SWNET_VC    (0))
  ALLOCATE(DGEI%XAVG_SWNET_GC    (0))
  ALLOCATE(DGEI%XAVG_SWNET_NC    (0))
  ALLOCATE(DGEI%XAVG_SWNET_NSC   (0))
  ALLOCATE(DGEI%XAVG_LWNET_VC    (0))
  ALLOCATE(DGEI%XAVG_LWNET_GC    (0))
  ALLOCATE(DGEI%XAVG_LWNET_NC    (0))
  ALLOCATE(DGEI%XAVG_SWDOWN_GNC  (0))
  ALLOCATE(DGEI%XAVG_LWDOWN_GNC  (0))
  ALLOCATE(DGEI%XAVG_H_V_CC      (0))
  ALLOCATE(DGEI%XAVG_H_G_CC      (0))
  ALLOCATE(DGEI%XAVG_H_C_AC      (0))
  ALLOCATE(DGEI%XAVG_H_N_CC      (0))
  ALLOCATE(DGEI%XAVG_SR_GNC      (0))
  ALLOCATE(DGEI%XAVG_MELTCVC     (0))
  ALLOCATE(DGEI%XAVG_FRZCVC      (0))
  !
  ALLOCATE(DGEI%XLEVCVC  (0,0))
  ALLOCATE(DGEI%XLESCC   (0,0))
!  ALLOCATE(XLETRGVC  (0,0))
  ALLOCATE(DGEI%XLETRCVC  (0,0))
!  ALLOCATE(XLERGVC   (0,0))
  ALLOCATE(DGEI%XLERCVC   (0,0))
  ALLOCATE(DGEI%XLE_C_AC  (0,0))
  ALLOCATE(DGEI%XLE_V_CC  (0,0))
  ALLOCATE(DGEI%XLE_G_CC  (0,0))
  ALLOCATE(DGEI%XLE_N_CC  (0,0))
  !
  ALLOCATE(DGEI%XSWNET_VC    (0,0))
  ALLOCATE(DGEI%XSWNET_GC    (0,0))
  ALLOCATE(DGEI%XSWNET_NC    (0,0))
  ALLOCATE(DGEI%XSWNET_NSC   (0,0))
  ALLOCATE(DGEI%XLWNET_VC    (0,0))
  ALLOCATE(DGEI%XLWNET_GC    (0,0))
  ALLOCATE(DGEI%XLWNET_NC    (0,0))
  ALLOCATE(DGEI%XSWDOWN_GNC  (0,0))
  ALLOCATE(DGEI%XLWDOWN_GNC  (0,0))
  ALLOCATE(DGEI%XH_V_CC      (0,0))
  ALLOCATE(DGEI%XH_G_CC      (0,0))
  ALLOCATE(DGEI%XH_C_AC      (0,0))
  ALLOCATE(DGEI%XH_N_CC      (0,0))
  ALLOCATE(DGEI%XSR_GNC      (0,0))
  ALLOCATE(DGEI%XMELTCVC     (0,0))
  ALLOCATE(DGEI%XFRZCVC      (0,0))
  !
ENDIF
!
IF(.NOT.I%LGLACIER)THEN
  ALLOCATE(DGEI%XAVG_ICEFLUXC(0))
  ALLOCATE(DGEI%XICEFLUXC(0,0))
ENDIF
!
!
!* surface temperature and parameters at 2m
!
ALLOCATE(DGI%XTS    (KLU,I%NPATCH))
ALLOCATE(DGI%XAVG_TS(KLU))
DGI%XTS     = XUNDEF
DGI%XAVG_TS = XUNDEF
ALLOCATE(DGI%XTSRAD    (KLU,I%NPATCH))
DGI%XTSRAD     = XUNDEF
!
IF (DGI%N2M>=1) THEN
  ALLOCATE(DGI%XAVG_RI           (KLU))
  ALLOCATE(DGI%XAVG_T2M          (KLU))
  ALLOCATE(DGI%XAVG_T2M_MEAN     (KLU))
  ALLOCATE(DGI%XAVG_T2M_MIN      (KLU))
  ALLOCATE(DGI%XAVG_T2M_MAX      (KLU))
  ALLOCATE(DGI%XAVG_Q2M          (KLU))
  ALLOCATE(DGI%XAVG_Q2M_MEAN     (KLU))
  ALLOCATE(DGI%XAVG_HU2M         (KLU))
  ALLOCATE(DGI%XAVG_HU2M_MEAN    (KLU))
  ALLOCATE(DGI%XAVG_HU2M_MIN     (KLU))
  ALLOCATE(DGI%XAVG_HU2M_MAX     (KLU))
  ALLOCATE(DGI%XAVG_ZON10M       (KLU))
  ALLOCATE(DGI%XAVG_ZON10M_MEAN  (KLU))
  ALLOCATE(DGI%XAVG_MER10M       (KLU))
  ALLOCATE(DGI%XAVG_MER10M_MEAN  (KLU))
  ALLOCATE(DGI%XAVG_WIND10M      (KLU))
  ALLOCATE(DGI%XAVG_WIND10M_MEAN (KLU))
  ALLOCATE(DGI%XAVG_WIND10M_MAX  (KLU))
  ALLOCATE(DGI%XAVG_SFCO2        (KLU))
  DGI%XAVG_RI      = XUNDEF
  DGI%XAVG_T2M     = XUNDEF
  DGI%XAVG_T2M_MIN = XUNDEF
  DGI%XAVG_T2M_MEAN = 0.0
  DGI%XAVG_T2M_MAX = -XUNDEF
  DGI%XAVG_Q2M     = XUNDEF
  DGI%XAVG_Q2M_MEAN = 0.0
  DGI%XAVG_HU2M    = XUNDEF
  DGI%XAVG_HU2M_MEAN = 0.0
  DGI%XAVG_HU2M_MIN= XUNDEF
  DGI%XAVG_HU2M_MAX= -XUNDEF
  DGI%XAVG_ZON10M  = XUNDEF
  DGI%XAVG_ZON10M_MEAN  = 0.0
  DGI%XAVG_MER10M  = XUNDEF
  DGI%XAVG_MER10M_MEAN  = 0.0
  DGI%XAVG_WIND10M = XUNDEF
  DGI%XAVG_WIND10M_MEAN = 0.0
  DGI%XAVG_WIND10M_MAX = 0.0
  DGI%XAVG_SFCO2       = XUNDEF
  !
  ALLOCATE(DGI%XRI     (KLU,I%NPATCH))
  ALLOCATE(DGI%XT2M    (KLU,I%NPATCH))
  ALLOCATE(DGI%XT2M_MIN(KLU,I%NPATCH))
  ALLOCATE(DGI%XT2M_MAX(KLU,I%NPATCH))
  ALLOCATE(DGI%XT2M_MEAN(KLU,I%NPATCH))
  ALLOCATE(DGI%XQ2M    (KLU,I%NPATCH))
  ALLOCATE(DGI%XQ2M_MEAN    (KLU,I%NPATCH))
  ALLOCATE(DGI%XHU2M   (KLU,I%NPATCH))
  ALLOCATE(DGI%XHU2M_MEAN   (KLU,I%NPATCH))
  ALLOCATE(DGI%XZON10M (KLU,I%NPATCH))
  ALLOCATE(DGI%XZON10M_MEAN (KLU,I%NPATCH))
  ALLOCATE(DGI%XMER10M (KLU,I%NPATCH))
  ALLOCATE(DGI%XMER10M_MEAN (KLU,I%NPATCH))
  ALLOCATE(DGI%XWIND10M(KLU,I%NPATCH))
  ALLOCATE(DGI%XWIND10M_MEAN(KLU,I%NPATCH))
  !
  DGI%XRI      = XUNDEF
  DGI%XT2M     = XUNDEF
  DGI%XT2M_MIN = XUNDEF
  DGI%XT2M_MAX = -XUNDEF
  DGI%XT2M_MEAN = 0.0
  DGI%XQ2M     = XUNDEF
  DGI%XQ2M_MEAN     = 0.0
  DGI%XHU2M    = XUNDEF
  DGI%XHU2M_MEAN    = 0.0
  DGI%XZON10M  = XUNDEF
  DGI%XZON10M_MEAN  = 0.0
  DGI%XMER10M  = XUNDEF
  DGI%XMER10M_MEAN  = 0.0
  DGI%XWIND10M = XUNDEF
  DGI%XWIND10M_MEAN = 0.0
  !
ELSE
  ALLOCATE(DGI%XAVG_RI           (0))
  ALLOCATE(DGI%XAVG_T2M          (0))
  ALLOCATE(DGI%XAVG_T2M_MEAN     (0))
  ALLOCATE(DGI%XAVG_T2M_MIN      (0))
  ALLOCATE(DGI%XAVG_T2M_MAX      (0))
  ALLOCATE(DGI%XAVG_Q2M          (0))
  ALLOCATE(DGI%XAVG_Q2M_MEAN     (0))
  ALLOCATE(DGI%XAVG_HU2M         (0))
  ALLOCATE(DGI%XAVG_HU2M_MEAN    (0))
  ALLOCATE(DGI%XAVG_HU2M_MIN     (0))
  ALLOCATE(DGI%XAVG_HU2M_MAX     (0))
  ALLOCATE(DGI%XAVG_ZON10M       (0))
  ALLOCATE(DGI%XAVG_ZON10M_MEAN  (0))
  ALLOCATE(DGI%XAVG_MER10M       (0))
  ALLOCATE(DGI%XAVG_MER10M_MEAN  (0))
  ALLOCATE(DGI%XAVG_WIND10M      (0))
  ALLOCATE(DGI%XAVG_WIND10M_MEAN (0))
  ALLOCATE(DGI%XAVG_WIND10M_MAX  (0))
!
  ALLOCATE(DGI%XRI     (0,0))
  ALLOCATE(DGI%XT2M    (0,0))
  ALLOCATE(DGI%XT2M_MIN(0,0))
  ALLOCATE(DGI%XT2M_MAX(0,0))
  ALLOCATE(DGI%XT2M_MEAN(0,0))
  ALLOCATE(DGI%XQ2M    (0,0))
  ALLOCATE(DGI%XQ2M_MEAN    (0,0))
  ALLOCATE(DGI%XHU2M   (0,0))
  ALLOCATE(DGI%XHU2M_MEAN   (0,0))
  ALLOCATE(DGI%XZON10M (0,0))
  ALLOCATE(DGI%XZON10M_MEAN (0,0))
  ALLOCATE(DGI%XMER10M (0,0))
  ALLOCATE(DGI%XMER10M_MEAN (0,0))
  ALLOCATE(DGI%XWIND10M(0,0))
  ALLOCATE(DGI%XWIND10M_MEAN(0,0))
END IF
!
!* miscellaneous surface fields
!
IF (DGMI%LSURF_MISC_BUDGET) THEN
  ALLOCATE(DGMI%XAVG_HV           (KLU))
  ALLOCATE(DGMI%XAVG_PSNG         (KLU))
  ALLOCATE(DGMI%XAVG_PSNV         (KLU))
  ALLOCATE(DGMI%XAVG_PSN          (KLU))
  ALLOCATE(DGMI%XAVG_ALBT         (KLU))
  ALLOCATE(DGMI%XAVG_LAI          (KLU))
  !
  ALLOCATE(DGMI%XAVG_FSAT        (KLU))  
  ALLOCATE(DGMI%XAVG_FFG         (KLU))
  ALLOCATE(DGMI%XAVG_FFV         (KLU))
  ALLOCATE(DGMI%XAVG_FF          (KLU))
  !
  ALLOCATE(DGMI%XSOIL_TSWI        (KLU))
  ALLOCATE(DGMI%XSOIL_SWI         (KLU))
  ALLOCATE(DGMI%XSOIL_TWG         (KLU))
  ALLOCATE(DGMI%XSOIL_TWGI        (KLU))
  ALLOCATE(DGMI%XSOIL_WG          (KLU))
  ALLOCATE(DGMI%XSOIL_WGI         (KLU))  
  ALLOCATE(DGMI%XAVG_SWI          (KLU,I%NGROUND_LAYER))
  ALLOCATE(DGMI%XAVG_TSWI         (KLU,I%NGROUND_LAYER))
  !
  ALLOCATE(DGMI%XAVG_TWSNOW       (KLU))
  ALLOCATE(DGMI%XAVG_TDSNOW       (KLU))
  ALLOCATE(DGMI%XAVG_TTSNOW       (KLU))
  !
  DGMI%XAVG_HV      = XUNDEF
  DGMI%XAVG_SWI     = XUNDEF
  DGMI%XAVG_TSWI    = XUNDEF
  DGMI%XSOIL_TSWI   = XUNDEF
  DGMI%XSOIL_SWI    = XUNDEF
  DGMI%XSOIL_TWG    = XUNDEF
  DGMI%XSOIL_TWGI   = XUNDEF
  DGMI%XSOIL_WG     = XUNDEF
  DGMI%XSOIL_WGI    = XUNDEF  
  DGMI%XAVG_PSNG    = XUNDEF
  DGMI%XAVG_PSNV    = XUNDEF
  DGMI%XAVG_PSN     = XUNDEF
  DGMI%XAVG_ALBT    = XUNDEF
  DGMI%XAVG_LAI     = XUNDEF
  DGMI%XAVG_FSAT    = XUNDEF  
  DGMI%XAVG_FFG     = XUNDEF
  DGMI%XAVG_FFV     = XUNDEF
  DGMI%XAVG_FF      = XUNDEF
  DGMI%XAVG_TWSNOW  = XUNDEF
  DGMI%XAVG_TDSNOW  = XUNDEF
  DGMI%XAVG_TTSNOW  = XUNDEF
  !
  ALLOCATE(DGMI%XHV     (KLU,I%NPATCH))
  ALLOCATE(DGMI%XSWI    (KLU,I%NGROUND_LAYER,I%NPATCH))
  ALLOCATE(DGMI%XTSWI   (KLU,I%NGROUND_LAYER,I%NPATCH))
  ALLOCATE(DGMI%XTWSNOW (KLU,I%NPATCH))
  ALLOCATE(DGMI%XTDSNOW (KLU,I%NPATCH))
  ALLOCATE(DGMI%XTTSNOW (KLU,I%NPATCH))
  ALLOCATE(DGMI%XDPSNG  (KLU,I%NPATCH))
  ALLOCATE(DGMI%XDPSNV  (KLU,I%NPATCH))
  ALLOCATE(DGMI%XDPSN   (KLU,I%NPATCH))
  ALLOCATE(DGMI%XALBT   (KLU,I%NPATCH))
  !
  ALLOCATE(DGMI%XDFSAT  (KLU,I%NPATCH))
  ALLOCATE(DGMI%XDFFG   (KLU,I%NPATCH))
  ALLOCATE(DGMI%XDFFV   (KLU,I%NPATCH))
  ALLOCATE(DGMI%XDFF    (KLU,I%NPATCH))
  !
  ALLOCATE(DGMI%XSNOWLIQ  (KLU,I%TSNOW%NLAYER,I%NPATCH))
  ALLOCATE(DGMI%XSNOWTEMP (KLU,I%TSNOW%NLAYER,I%NPATCH))
  !
  DGMI%XHV      = XUNDEF
  DGMI%XSWI     = XUNDEF
  DGMI%XTSWI    = XUNDEF
  DGMI%XTWSNOW  = XUNDEF
  DGMI%XTDSNOW  = XUNDEF
  DGMI%XTTSNOW  = XUNDEF
  DGMI%XDPSNG   = XUNDEF
  DGMI%XDPSNV   = XUNDEF
  DGMI%XDPSN    = XUNDEF
  DGMI%XALBT    = XUNDEF
  DGMI%XDFSAT   = XUNDEF  
  DGMI%XDFFG    = XUNDEF
  DGMI%XDFFV    = XUNDEF
  DGMI%XDFF     = XUNDEF
  DGMI%XSNOWLIQ = XUNDEF
  DGMI%XSNOWTEMP= XUNDEF
  !
  IF(I%CISBA=='DIF'.AND.DGMI%LSURF_MISC_DIF)THEN
    ALLOCATE(DGMI%XFRD2_TSWI(KLU))
    ALLOCATE(DGMI%XFRD2_TWG (KLU))
    ALLOCATE(DGMI%XFRD2_TWGI(KLU))
    ALLOCATE(DGMI%XFRD3_TSWI(KLU))
    ALLOCATE(DGMI%XFRD3_TWG (KLU))
    ALLOCATE(DGMI%XFRD3_TWGI(KLU))    
    DGMI%XFRD2_TSWI = XUNDEF
    DGMI%XFRD2_TWG  = XUNDEF
    DGMI%XFRD2_TWGI = XUNDEF
    DGMI%XFRD3_TSWI = XUNDEF
    DGMI%XFRD3_TWG  = XUNDEF
    DGMI%XFRD3_TWGI = XUNDEF  
  ENDIF
  !
  IF(I%CISBA=='DIF')THEN
    ALLOCATE(DGMI%XALT(KLU,I%NPATCH))
    ALLOCATE(DGMI%XFLT(KLU,I%NPATCH))
    ALLOCATE(DGMI%XAVG_ALT(KLU))
    ALLOCATE(DGMI%XAVG_FLT(KLU))
    DGMI%XALT     = XUNDEF
    DGMI%XFLT     = XUNDEF
    DGMI%XAVG_ALT = XUNDEF
    DGMI%XAVG_FLT = XUNDEF          
  ENDIF  
  !
  IF (I%LTR_ML) THEN
    ALLOCATE (DGMI%XFAPAR      (KLU, I%NPATCH))
    ALLOCATE (DGMI%XFAPIR      (KLU, I%NPATCH))
    ALLOCATE (DGMI%XFAPAR_BS   (KLU, I%NPATCH))
    ALLOCATE (DGMI%XFAPIR_BS   (KLU, I%NPATCH))
    ALLOCATE (DGMI%XDFAPARC    (KLU, I%NPATCH))
    ALLOCATE (DGMI%XDFAPIRC    (KLU, I%NPATCH))
    ALLOCATE (DGMI%XDLAI_EFFC  (KLU, I%NPATCH))
    !
    DGMI%XFAPAR      = XUNDEF
    DGMI%XFAPIR      = XUNDEF
    DGMI%XFAPAR_BS   = XUNDEF
    DGMI%XFAPIR_BS   = XUNDEF
    DGMI%XDFAPARC    = 0.
    DGMI%XDFAPIRC    = 0.
    DGMI%XDLAI_EFFC  = 0.
  ENDIF
  !
ELSE
  ALLOCATE(DGMI%XAVG_HV           (0))
  ALLOCATE(DGMI%XAVG_PSNG         (0))
  ALLOCATE(DGMI%XAVG_PSNV         (0))
  ALLOCATE(DGMI%XAVG_PSN          (0))
  ALLOCATE(DGMI%XAVG_ALBT         (0))
  ALLOCATE(DGMI%XAVG_LAI          (0))
!
  ALLOCATE(DGMI%XAVG_FSAT        (0))  
  ALLOCATE(DGMI%XAVG_FFG         (0))
  ALLOCATE(DGMI%XAVG_FFV         (0))
  ALLOCATE(DGMI%XAVG_FF          (0))
!
  ALLOCATE(DGMI%XSOIL_TSWI        (0))
  ALLOCATE(DGMI%XSOIL_SWI         (0))
  ALLOCATE(DGMI%XSOIL_TWG         (0))
  ALLOCATE(DGMI%XSOIL_TWGI        (0))
  ALLOCATE(DGMI%XSOIL_WG          (0))
  ALLOCATE(DGMI%XSOIL_WGI         (0))
  ALLOCATE(DGMI%XAVG_SWI          (0,0))
  ALLOCATE(DGMI%XAVG_TSWI         (0,0))
!
  ALLOCATE(DGMI%XAVG_TWSNOW       (0))
  ALLOCATE(DGMI%XAVG_TDSNOW       (0))
  ALLOCATE(DGMI%XAVG_TTSNOW       (0))
!
  ALLOCATE(DGMI%XHV     (0,0))
  ALLOCATE(DGMI%XSWI    (0,0,0))
  ALLOCATE(DGMI%XTSWI   (0,0,0))
  ALLOCATE(DGMI%XTWSNOW (0,0))
  ALLOCATE(DGMI%XTDSNOW (0,0))
  ALLOCATE(DGMI%XTTSNOW (0,0))
  ALLOCATE(DGMI%XDPSNG  (0,0))
  ALLOCATE(DGMI%XDPSNV  (0,0))
  ALLOCATE(DGMI%XDPSN   (0,0))
  ALLOCATE(DGMI%XALBT   (0,0))
!
  ALLOCATE(DGMI%XDFSAT  (0,0))
  ALLOCATE(DGMI%XDFFG   (0,0))
  ALLOCATE(DGMI%XDFFV   (0,0))
  ALLOCATE(DGMI%XDFF    (0,0))
!
  ALLOCATE(DGMI%XSNOWLIQ  (0,0,0))
  ALLOCATE(DGMI%XSNOWTEMP (0,0,0))
END IF
!
! UTCI
!
IF ((DGI%N2M.GT.0).AND.(DGUI%LUTCI)) THEN
  !
  ALLOCATE(DGUI%XUTCI_OUTSUN   (KLU))
  ALLOCATE(DGUI%XUTCI_OUTSHADE (KLU))
  ALLOCATE(DGUI%XUTCI_OUTSUN_MEAN (KLU))
  ALLOCATE(DGUI%XUTCI_OUTSHADE_MEAN (KLU))
  ALLOCATE(DGUI%XTRAD_SUN        (KLU))
  ALLOCATE(DGUI%XTRAD_SHADE      (KLU))
  ALLOCATE(DGUI%XTRAD_SUN_MEAN   (KLU))
  ALLOCATE(DGUI%XTRAD_SHADE_MEAN (KLU))
  ALLOCATE(DGUI%XUTCIC_OUTSUN    (KLU,NUTCI_STRESS))
  ALLOCATE(DGUI%XUTCIC_OUTSHADE  (KLU,NUTCI_STRESS))
  !
  DGUI%XUTCI_OUTSUN    = XUNDEF
  DGUI%XUTCI_OUTSHADE  = XUNDEF
  DGUI%XUTCI_OUTSUN_MEAN  = 0.0
  DGUI%XUTCI_OUTSHADE_MEAN= 0.0
  DGUI%XTRAD_SUN       = XUNDEF
  DGUI%XTRAD_SHADE     = XUNDEF
  DGUI%XTRAD_SUN_MEAN  = 0.0
  DGUI%XTRAD_SHADE_MEAN= 0.0
  DGUI%XUTCIC_OUTSUN   = 0.
  DGUI%XUTCIC_OUTSHADE = 0.
  !  
ELSE
  ALLOCATE(DGUI%XUTCI_OUTSUN   (0))
  ALLOCATE(DGUI%XUTCI_OUTSHADE (0))
  ALLOCATE(DGUI%XUTCI_OUTSUN_MEAN   (0))
  ALLOCATE(DGUI%XUTCI_OUTSHADE_MEAN (0))
  ALLOCATE(DGUI%XTRAD_SUN      (0))
  ALLOCATE(DGUI%XTRAD_SHADE    (0))        
  ALLOCATE(DGUI%XTRAD_SUN_MEAN (0))
  ALLOCATE(DGUI%XTRAD_SHADE_MEAN(0))  
  ALLOCATE(DGUI%XUTCIC_OUTSUN  (0,0))
  ALLOCATE(DGUI%XUTCIC_OUTSHADE(0,0))
ENDIF
!
IF (I%CISBA/='DIF') THEN
  ALLOCATE(DGMI%XFRD2_TSWI(0))
  ALLOCATE(DGMI%XFRD2_TWG (0))
  ALLOCATE(DGMI%XFRD2_TWGI(0))
  ALLOCATE(DGMI%XFRD3_TSWI(0))
  ALLOCATE(DGMI%XFRD3_TWG (0))
  ALLOCATE(DGMI%XFRD3_TWGI(0))    
  ALLOCATE(DGMI%XALT(0,0))
  ALLOCATE(DGMI%XFLT(0,0))
  ALLOCATE(DGMI%XAVG_ALT(0))
  ALLOCATE(DGMI%XAVG_FLT(0))      
ENDIF
!
IF (.NOT.I%LTR_ML) THEN
  ALLOCATE (DGMI%XFAPAR      (0, 0))
  ALLOCATE (DGMI%XFAPIR      (0, 0))
  ALLOCATE (DGMI%XFAPAR_BS   (0, 0))
  ALLOCATE (DGMI%XFAPIR_BS   (0, 0))
  ALLOCATE (DGMI%XDFAPARC    (0, 0))
  ALLOCATE (DGMI%XDFAPIRC    (0, 0))
  ALLOCATE (DGMI%XDLAI_EFFC  (0, 0))
ENDIF
!
!* transfer coefficients
!
IF (DGI%LCOEF) THEN
  ALLOCATE(DGI%XAVG_CD   (KLU))
  ALLOCATE(DGI%XAVG_CH   (KLU))
  ALLOCATE(DGI%XAVG_CE   (KLU))
  ALLOCATE(DGI%XAVG_Z0   (KLU))
  ALLOCATE(DGI%XAVG_Z0H  (KLU))
  ALLOCATE(DGI%XAVG_Z0EFF(KLU))
  !
  DGI%XAVG_CD      = XUNDEF
  DGI%XAVG_CH      = XUNDEF
  DGI%XAVG_CE      = XUNDEF
  DGI%XAVG_Z0      = XUNDEF
  DGI%XAVG_Z0H     = XUNDEF
  DGI%XAVG_Z0EFF   = XUNDEF
  !
  ALLOCATE(DGI%XCD            (KLU,I%NPATCH))
  ALLOCATE(DGI%XCH            (KLU,I%NPATCH))
  ALLOCATE(DGI%XCE            (KLU,I%NPATCH))
  ALLOCATE(DGI%XZ0_WITH_SNOW  (KLU,I%NPATCH))
  ALLOCATE(DGI%XZ0H_WITH_SNOW (KLU,I%NPATCH))
  ALLOCATE(DGI%XZ0EFF         (KLU,I%NPATCH))
  !
  DGI%XCD            = XUNDEF
  DGI%XCH            = XUNDEF
  DGI%XCE            = XUNDEF
  DGI%XZ0_WITH_SNOW  = XUNDEF
  DGI%XZ0H_WITH_SNOW = XUNDEF
  DGI%XZ0EFF         = XUNDEF
ELSE
  ALLOCATE(DGI%XAVG_CD   (0))
  ALLOCATE(DGI%XAVG_CH   (0))
  ALLOCATE(DGI%XAVG_CE   (0))
  ALLOCATE(DGI%XAVG_Z0   (0))
  ALLOCATE(DGI%XAVG_Z0H  (0))
  ALLOCATE(DGI%XAVG_Z0EFF(0))
!
  ALLOCATE(DGI%XCD            (0,0))
  ALLOCATE(DGI%XCH            (0,0))
  ALLOCATE(DGI%XCE            (0,0))
  ALLOCATE(DGI%XZ0_WITH_SNOW  (0,0))
  ALLOCATE(DGI%XZ0H_WITH_SNOW (0,0))
  ALLOCATE(DGI%XZ0EFF         (0,0))
END IF
!
!
!* surface humidity
!
IF (DGI%LSURF_VARS) THEN
  ALLOCATE(DGI%XAVG_QS   (KLU))
  !
  DGI%XAVG_QS      = XUNDEF
  !
  ALLOCATE(DGI%XQS            (KLU,I%NPATCH))
  !
  DGI%XQS            = XUNDEF
ELSE
  ALLOCATE(DGI%XQS            (0,0))
END IF
!
!* Irrigation threshold
!
IF (LAGRIP) THEN
  ALLOCATE(DGMI%XSEUIL         (KLU,I%NPATCH))
  !
  DGMI%XSEUIL         = XUNDEF
ELSE
  ALLOCATE(DGMI%XSEUIL         (0,0))
END IF
!
!* Chemical fluxes
IF (CHI%SVI%NBEQ>0 .AND. CHI%LCH_BIO_FLUX) THEN
  ALLOCATE(GB%XFISO(KLU))
  ALLOCATE(GB%XFMONO(KLU))
  !
  GB%XFISO         = XUNDEF
  GB%XFMONO        = XUNDEF
ELSE
  ALLOCATE(GB%XFISO(0))
  ALLOCATE(GB%XFMONO(0))
ENDIF
!
IF (I%CPHOTO/='NON') THEN
  ALLOCATE(GB%XIACAN(KLU,SIZE(I%XABC),I%NPATCH))
  !
  GB%XIACAN        = XUNDEF
  !
ELSE
  ALLOCATE(GB%XIACAN(0,0,0))
ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_ISBA_INIT_N',1,ZHOOK_HANDLE)
!-------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_ISBA_INIT_n
