!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!
!     #########################
SUBROUTINE DEFAULT_DATA_COVER
!     #########################
!
!!**** *DEFAULT_DATA_COVER* gives default values for each patch
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!
!!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    ??      Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    ??
!!
!!    M.Goret       02/2017 Add fractions of heating
!!    M.Goret       02/2017 Add hot water
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
USE MODD_SURF_PAR
USE MODD_DATA_COVER_PAR
USE MODD_DATA_COVER
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
IMPLICIT NONE
!
!*    Declaration of local variables
!     ------------------------------ 
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('DEFAULT_DATA_COVER',0,ZHOOK_HANDLE) 
!
XDATA_TOWN(:) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   0.30,   0.10,   0.10, &
   0.20,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   1.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.01,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01, &
   0.00,   0.01,   0.02,   0.01,   0.01,   0.01,   0.00,   0.00,   0.00,   0.01, &
   0.00,   0.00,   0.00,   0.00,   0.01,   0.02,   0.01,   0.00,   0.00,   0.01, &
   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.02,   0.01,   0.00,   0.00,   0.01,   0.01,   0.00,   0.01, &
   0.02,   0.01,   0.02,   0.00,   0.01,   0.02,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.03,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.01,   0.01,   0.04,   0.00,   0.00,   0.00,   0.02,   0.01,   0.01, &
   0.01,   0.01,   0.01,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.01,   0.01, &
   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.03,   0.04,   0.01,   0.01,   0.02,   0.01,   0.02,   0.02, &
   0.04,   0.05,   0.09,   0.04,   0.02,   0.02,   0.03,   0.05,   0.03,   0.02, &
   0.00,   0.00,   0.00,   0.02,   0.01,   0.02,   0.04,   0.00,   0.02,   0.01, &
   0.02,   0.04,   0.08,   0.05,   0.03,   0.02,   0.02,   0.02,   0.00,   0.02, &
   0.02,   0.02,   0.01,   0.03,   0.03,   0.02,   0.02,   0.02,   0.02,   0.00, &
   0.02,   0.01,   0.02,   0.01,   0.00,   0.02,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01, &
   0.01,   0.02,   0.01,   0.01,   0.01,   0.01,   0.01,   0.01,   0.00,   0.02, &
   0.02,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.02, &
   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.02,   0.01, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   0.00,   0.01 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_NATURE(:) = (/          &
   0.00,   0.00,   0.00,   1.00,   1.00,   1.00,   0.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   0.80,   0.80,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.70,   0.90,   0.90, &
   0.80,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   0.80,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   0.80,   0.80,   0.80, &
   0.50,   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   0.99,   1.00,   0.99,   1.00,   1.00,   1.00,   1.00,   1.00,   0.99, &
   1.00,   0.99,   0.98,   0.99,   0.99,   0.99,   1.00,   1.00,   1.00,   0.99, &
   1.00,   1.00,   1.00,   1.00,   0.99,   0.98,   0.99,   1.00,   1.00,   0.99, &
   1.00,   0.99,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   0.98,   0.99,   1.00,   1.00,   0.99,   0.99,   1.00,   0.99, &
   0.98,   0.99,   0.98,   1.00,   0.99,   0.98,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   0.97,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   0.99,   0.99,   0.96,   1.00,   1.00,   1.00,   0.98,   0.99,   0.99, &
   0.99,   0.99,   0.99,   0.99,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   0.99,   0.99,   0.99, &
   0.99,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   0.97,   0.96,   0.99,   0.99,   0.98,   0.99,   0.98,   0.98, &
   0.96,   0.95,   0.91,   0.96,   0.98,   0.98,   0.97,   0.95,   0.97,   0.98, &
   1.00,   1.00,   1.00,   0.98,   0.99,   0.98,   0.96,   1.00,   0.98,   0.99, &
   0.98,   0.96,   0.92,   0.95,   0.97,   0.98,   0.98,   0.98,   1.00,   0.98, &
   0.98,   0.98,   0.99,   0.97,   0.97,   0.98,   0.98,   0.98,   0.98,   1.00, &
   0.98,   0.99,   0.98,   0.99,   1.00,   0.98,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   0.99, &
   0.99,   0.98,   0.99,   0.99,   0.99,   0.99,   0.99,   0.99,   1.00,   0.98, &
   0.98,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   0.98, &
   0.99,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   0.00,   0.45, &
   0.05,   1.00,   0.01,   0.02,   0.03,   0.25,   1.00,   0.99,   0.98,   0.99, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   1.00,   0.99 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_WATER(:) = (/          &
   0.00,   1.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.20,   0.20,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.20,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.20,   0.20,   0.20, &
   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_SEA(:) = (/          &
   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.50,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   1.00,   0.55, &
   0.95,   0.00,   0.99,   0.98,   0.97,   0.75,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_Z0_TOWN(:) = 1.000
XDATA_Z0_TOWN(151) = 3.000
XDATA_Z0_TOWN(155) = 2.000
XDATA_Z0_TOWN(156) = 0.500
XDATA_Z0_TOWN(157) = 2.000
XDATA_Z0_TOWN(158) = 0.010
XDATA_Z0_TOWN(159) = 0.100
XDATA_Z0_TOWN(160) = 0.500
XDATA_Z0_TOWN(254) = 2.000
XDATA_Z0_TOWN(255) = 2.000
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_BLD_HEIGHT(:) =   10.
XDATA_BLD_HEIGHT(151) =   30.
XDATA_BLD_HEIGHT(155) =   20.
XDATA_BLD_HEIGHT(156) =    5.
XDATA_BLD_HEIGHT(157) =   20.
XDATA_BLD_HEIGHT(159) =    5.
XDATA_BLD_HEIGHT(160) =    5.
XDATA_BLD_HEIGHT(254) =   20.
XDATA_BLD_HEIGHT(255) =   20.
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_WALL_O_HOR(:) =0.50
XDATA_WALL_O_HOR(  7) =0.30
XDATA_WALL_O_HOR(151) =0.90
XDATA_WALL_O_HOR(152) =0.30
XDATA_WALL_O_HOR(153) =0.30
XDATA_WALL_O_HOR(154) =0.30
XDATA_WALL_O_HOR(155) =0.45
XDATA_WALL_O_HOR(156) =0.09
XDATA_WALL_O_HOR(157) =0.90
XDATA_WALL_O_HOR(158) =0.10
XDATA_WALL_O_HOR(159) =0.10
XDATA_WALL_O_HOR(160) =0.10
XDATA_WALL_O_HOR(161) =1.00
XDATA_WALL_O_HOR(254) =1.50
XDATA_WALL_O_HOR(255) =1.50
XDATA_WALL_O_HOR(561) =0.28
XDATA_WALL_O_HOR(562) =0.27
XDATA_WALL_O_HOR(563) =0.25
XDATA_WALL_O_HOR(564) =0.16
XDATA_WALL_O_HOR(565) =0.31
XDATA_WALL_O_HOR(566) =0.28
XDATA_WALL_O_HOR(567) =0.31
XDATA_WALL_O_HOR(568) =0.25
XDATA_WALL_O_HOR(569) =0.24
XDATA_WALL_O_HOR(570) =0.25
XDATA_WALL_O_HOR(571) =0.28
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_BLD(:) =0.50
XDATA_BLD(  7) =0.30
XDATA_BLD(151) =0.45
XDATA_BLD(152) =0.30
XDATA_BLD(153) =0.30
XDATA_BLD(154) =0.30
XDATA_BLD(155) =0.45
XDATA_BLD(156) =0.09
XDATA_BLD(157) =0.45
XDATA_BLD(158) =0.10
XDATA_BLD(159) =0.10
XDATA_BLD(160) =0.10
XDATA_BLD(254) =0.60
XDATA_BLD(255) =0.60
XDATA_BLD(561) =0.28
XDATA_BLD(562) =0.27
XDATA_BLD(563) =0.25
XDATA_BLD(564) =0.16
XDATA_BLD(565) =0.31
XDATA_BLD(566) =0.28
XDATA_BLD(567) =0.31
XDATA_BLD(568) =0.25
XDATA_BLD(569) =0.24
XDATA_BLD(570) =0.25
XDATA_BLD(571) =0.28
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_GARDEN(:) =0.01 ! EUREQUA-TOUL modif cécile 2015
XDATA_GARDEN(  7) =0.40
XDATA_GARDEN(151) =0.10
XDATA_GARDEN(152) =0.40
XDATA_GARDEN(153) =0.40
XDATA_GARDEN(154) =0.40
XDATA_GARDEN(155) =0.10
XDATA_GARDEN(156) =0.10
XDATA_GARDEN(157) =0.10
XDATA_GARDEN(561) =0.44
XDATA_GARDEN(562) =0.45
XDATA_GARDEN(563) =0.51
XDATA_GARDEN(564) =0.48
XDATA_GARDEN(565) =0.37
XDATA_GARDEN(566) =0.44
XDATA_GARDEN(567) =0.38
XDATA_GARDEN(568) =0.49
XDATA_GARDEN(569) =0.52
XDATA_GARDEN(570) =0.51
XDATA_GARDEN(571) =0.44
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_ALB_ROOF(:) =0.15
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_ALB_ROAD(:) =0.08
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_ALB_WALL(:) =0.25
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_EMIS_ROOF(:) =0.90
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_EMIS_ROAD(:) =0.94
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_EMIS_WALL(:) =0.85
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_HC_ROOF(:,  1) =2.11 * 1.E6
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_HC_ROOF(:,  2) =0.28 * 1.E6
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_HC_ROOF(:,  3) =0.29 * 1.E6
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_TC_ROOF(:,  1) =1.5100
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_TC_ROOF(:,  2) =0.0800
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_TC_ROOF(:,  3) =0.0500
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_D_ROOF(:,  1) =0.050
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_D_ROOF(:,  2) =0.400
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_D_ROOF(:,  3) =0.100
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_HC_ROAD(:,  1) =1.94 * 1.E6
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_HC_ROAD(:,  2) =1.28 * 1.E6
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_HC_ROAD(:,  3) =1.28 * 1.E6
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_TC_ROAD(:,  1) =0.7454
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_TC_ROAD(:,  2) =0.2513
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_TC_ROAD(:,  3) =0.2513
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_D_ROAD(:,  1) =0.050
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_D_ROAD(:,  2) =0.100
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_D_ROAD(:,  3) =1.000
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_HC_WALL(:,  1) =1.55 * 1.E6
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_HC_WALL(:,  2) =1.55 * 1.E6
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_HC_WALL(:,  3) =0.29 * 1.E6
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_TC_WALL(:,  1) =0.9338
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_TC_WALL(:,  2) =0.9338
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_TC_WALL(:,  3) =0.0500
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_D_WALL(:,  1) =0.020
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_D_WALL(:,  2) =0.125
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_D_WALL(:,  3) =0.050
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_H_TRAFFIC(:) =   10.
XDATA_H_TRAFFIC(151) =   20.
XDATA_H_TRAFFIC(156) =   30.
XDATA_H_TRAFFIC(159) =    0.
XDATA_H_TRAFFIC(160) =    0.
XDATA_H_TRAFFIC(161) =    0.
XDATA_H_TRAFFIC(254) =    0.
XDATA_H_TRAFFIC(255) =    0.
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_LE_TRAFFIC(:) =    0.
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_H_INDUSTRY(:) =    5.
XDATA_H_INDUSTRY(151) =   10.
XDATA_H_INDUSTRY(155) =   20.
XDATA_H_INDUSTRY(156) =    0.
XDATA_H_INDUSTRY(157) =   20.
XDATA_H_INDUSTRY(158) =    0.
XDATA_H_INDUSTRY(159) =    0.
XDATA_H_INDUSTRY(160) =    0.
XDATA_H_INDUSTRY(161) =    0.
XDATA_H_INDUSTRY(254) =    0.
XDATA_H_INDUSTRY(255) =    0.
!-------------------------------------------------------------------                                                    
WHERE(XDATA_TOWN>0.) XDATA_LE_INDUSTRY(:) =    0.
!------------------------------------------------------------------- 
WHERE(XDATA_TOWN>0.) XDATA_FRAC_HEAT_ELEC(:) =    0.5
!------------------------------------------------------------------- 
WHERE(XDATA_TOWN>0.) XDATA_FRAC_HEAT_GAS(:) =    0.25
!------------------------------------------------------------------- 
WHERE(XDATA_TOWN>0.) XDATA_FRAC_HEAT_FUEL(:) =    0.25
!------------------------------------------------------------------- 
WHERE(XDATA_TOWN>0.) XDATA_FRAC_HEAT_OTHER(:) =    0.
!-------------------------------------------------------------------   
WHERE(XDATA_TOWN>0.) XDATA_NB_POP(:) =    0.  ! Number of people per square kilometer
!-------------------------------------------------------------------  
WHERE(XDATA_TOWN>0.) XDATA_SFCO2_RD(:) =    0. !(kg/m2 of town/s)
!-------------------------------------------------------------------
WHERE(XDATA_TOWN>0.) XDATA_F_HW_GAS (:) =    0. ! fraction of water heat by gas
!-------------------------------------------------------------------
!
WHERE(XDATA_TOWN(:)>0.) XDATA_FRACOMP(:) = 1.0 ! fraction of compartments in bem
!
WHERE(XDATA_TOWN(:)>0.) XDATA_RESIDENTIAL(:) = 1.0 ! Residential fraction
!
!-------------------------------------------------------------------
!
XDATA_VEGTYPE(:,  1) = (/          &
   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.90,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.10, &
   0.00,   0.00,   0.00,   0.10,   0.00,   0.00,   0.00,   0.30,   0.20,   0.00, &
   0.20,   0.00,   0.20,   0.00,   0.00,   0.20,   0.00,   0.30,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.10,   0.00,   0.10,   0.30,   0.20,   0.20,   0.30, &
   0.30,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.60, &
   0.50,   0.70,   0.20,   0.30,   0.40,   0.30,   0.70,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.90,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   1.00,   0.00,   1.00,   0.00,   1.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50,   0.50,   0.50,   0.00, &
   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.20, &
   0.00,   0.00,   0.50,   0.00,   0.30,   0.10,   0.10,   0.00,   0.00,   0.40, &
   0.50,   0.50,   0.20,   0.10,   0.00,   0.80,   1.00,   0.00,   0.00,   0.00, &
   0.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.06,   0.01,   0.00,   0.03,   0.03,   0.00,   0.00,   0.00,   0.00,   0.05, &
   0.03,   0.05,   0.00,   0.01,   0.02,   0.01,   0.02,   0.01,   0.01,   0.00, &
   0.00,   0.02,   0.08,   0.04,   0.07,   0.04,   0.30,   0.02,   0.05,   0.09, &
   0.06,   0.03,   0.04,   0.04,   0.11,   0.19,   0.12,   0.25,   0.20,   0.11, &
   0.05,   0.15,   0.13,   0.20,   0.10,   0.10,   0.10,   0.05,   0.04,   0.40, &
   0.08,   0.09,   0.08,   0.00,   0.10,   0.50,   0.55,   0.60,   0.70,   0.05, &
   0.06,   0.04,   0.09,   0.07,   0.14,   0.16,   0.30,   0.45,   0.55,   0.57, &
   0.70,   0.70,   0.65,   0.75,   0.85,   0.30,   0.39,   0.43,   0.30,   0.28, &
   0.15,   0.33,   0.54,   0.25,   0.35,   0.48,   0.44,   0.40,   0.35,   0.15, &
   0.15,   0.03,   0.04,   0.30,   0.20,   0.07,   0.15,   0.17,   0.35,   0.30, &
   0.30,   0.25,   0.15,   0.20,   0.15,   0.10,   0.30,   0.40,   0.60,   0.65, &
   0.60,   0.18,   0.45,   0.55,   0.63,   0.23,   0.45,   0.32,   0.50,   0.30, &
   0.22,   0.45,   0.57,   0.55,   0.30,   0.50,   0.55,   0.50,   0.27,   0.10, &
   0.22,   0.77,   0.63,   0.74,   0.52,   0.65,   0.88,   0.72,   0.80,   0.90, &
   0.89,   0.07,   0.07,   0.09,   0.18,   0.15,   0.15,   0.12,   0.15,   0.15, &
   0.20,   0.12,   0.15,   0.14,   0.08,   0.06,   0.12,   0.29,   0.15,   0.09, &
   0.09,   0.09,   0.09,   0.13,   0.06,   0.06,   0.13,   0.14,   0.09,   0.02, &
   0.25,   0.15,   0.35,   0.12,   0.17,   0.11,   0.43,   0.18,   0.13,   0.10, &
   0.08,   0.06,   0.22,   0.07,   0.06,   0.07,   0.04,   0.01,   0.06,   0.20, &
   0.03,   0.05,   0.06,   0.09,   0.42,   0.42,   0.27,   0.14,   0.08,   0.22, &
   0.07,   0.16,   0.25,   0.48,   0.45,   0.07,   0.21,   0.16,   0.37,   0.12, &
   0.10,   0.27,   0.25,   0.12,   0.33,   0.14,   0.14,   0.42,   0.15,   0.34, &
   0.06,   0.32,   0.03,   0.08,   0.09,   0.17,   0.32,   0.51,   0.15,   0.08, &
   0.72,   0.16,   0.00,   0.00,   1.00,   1.00,   1.00,   1.00,   1.00,   0.80, &
   0.76,   0.89,   0.90,   0.97,   0.81,   0.60,   0.85,   0.00,   0.00,   0.01, &
   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.02,   0.02,   0.02,   0.05,   0.14,   0.01,   0.13,   0.16,   0.00,   0.02, &
   0.04,   0.47,   0.46 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:,  2) = (/          &
   0.00,   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.06,   0.01,   0.00,   0.04,   0.04,   0.00,   0.01,   0.00,   0.01,   0.05, &
   0.03,   0.05,   0.00,   0.02,   0.03,   0.01,   0.02,   0.02,   0.02,   0.04, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.40,   0.30,   0.20,   0.15,   0.10,   0.08,   0.05, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.05,   0.05,   0.05,   0.10,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.01,   0.02,   0.05,   0.05,   0.05,   0.13, &
   0.05,   0.05,   0.05,   0.05,   0.05,   0.00,   0.01,   0.02,   0.00,   0.02, &
   0.01,   0.00,   0.01,   0.00,   0.00,   0.02,   0.06,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.02,   0.05,   0.05,   0.05,   0.05, &
   0.05,   0.02,   0.05,   0.05,   0.07,   0.02,   0.05,   0.23,   0.05,   0.05, &
   0.03,   0.05,   0.05,   0.05,   0.05,   0.05,   0.05,   0.05,   0.03,   0.02, &
   0.03,   0.08,   0.27,   0.16,   0.23,   0.10,   0.07,   0.21,   0.12,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.03, &
   0.00,   0.01,   0.03,   0.06,   0.05,   0.01,   0.02,   0.01,   0.03,   0.01, &
   0.01,   0.02,   0.02,   0.01,   0.02,   0.01,   0.01,   0.02,   0.01,   0.03, &
   0.01,   0.03,   0.00,   0.00,   0.00,   0.00,   0.00,   0.03,   0.01,   0.00, &
   0.00,   0.07,   1.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.19, &
   0.19,   0.09,   0.00,   0.02,   0.12,   0.25,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.02,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:,  3) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.10,   1.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:,  4) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   0.00,   0.50, &
   0.00,   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.40,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.20,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.30,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.50,   0.50,   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50, &
   0.20,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.10,   0.10,   0.10,   0.10, &
   0.10,   0.40,   0.40,   0.40,   0.40,   0.00,   0.00,   0.30,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.50,   0.50,   0.50,   0.50,   0.50,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.20, &
   0.50,   0.00,   0.60,   0.00,   0.60,   0.00,   0.00,   0.50,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.40,   0.00,   0.00,   0.10,   0.00,   0.14,   0.25, &
   0.51,   0.49,   0.11,   0.13,   0.07,   0.54,   0.00,   0.00,   0.31,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.15,   0.39,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.08, &
   0.22,   0.04,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.14,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.16,   0.00,   0.00,   0.00,   0.00,   0.35,   0.00,   0.00,   0.07, &
   0.00,   0.07,   0.00,   0.05,   0.04,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.07,   0.00,   0.00, &
   0.10,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.04,   0.00, &
   0.00,   0.16,   0.44,   0.00,   0.17,   0.23,   0.14,   0.28,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.06,   0.10,   0.13,   0.19,   0.00,   0.07,   0.00, &
   0.00,   0.00,   0.00,   0.09,   0.02,   0.03,   0.00,   0.25,   0.00,   0.04, &
   0.03,   0.01,   0.00,   0.10,   0.09,   0.14,   0.04,   0.02,   0.12,   0.00, &
   0.13,   0.35,   0.04,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.02,   0.02,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.22,   0.00,   0.00,   0.00,   0.20, &
   0.18,   0.21,   0.26,   0.15,   0.04,   0.00,   0.04,   0.19,   0.07,   0.07, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:,  5) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   1.00,   0.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.50,   0.00,   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.50,   0.50,   0.00,   0.00,   0.50,   0.50,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.30,   0.30, &
   0.00,   0.00,   0.00,   0.30,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.20,   0.20,   0.00,   0.20,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.20,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.40,   0.40,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   0.00,   0.50,   0.50,   0.50,   0.50,   0.50,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.20,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.27,   0.07,   0.14,   0.88,   0.84,   0.15,   0.85,   0.18,   0.82,   0.73, &
   0.73,   0.71,   0.18,   0.48,   0.86,   0.86,   0.80,   0.87,   0.78,   0.13, &
   0.07,   0.00,   0.24,   0.55,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00, &
   0.06,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.09, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.02,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01, &
   0.05,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.05,   0.13,   0.04,   0.06,   0.05,   0.05,   0.00,   0.00,   0.00,   0.08, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00, &
   0.02,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.40,   0.02,   0.04,   0.00, &
   0.00,   0.00,   0.34,   0.07,   0.00,   0.48,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:,  6) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.30, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.30,   0.00,   0.00,   0.00, &
   0.30,   0.30,   0.00,   0.00,   0.30,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:,  7) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.20,   0.00,   0.00, &
   0.00,   0.50,   0.50,   0.00,   0.00,   0.00,   0.40,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.70,   0.00,   0.00,   0.00,   0.00,   0.50, &
   0.50,   0.00,   0.40,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.50,   0.90,   0.50,   0.90,   1.00,   0.00, &
   0.50,   0.00,   1.00,   0.90,   0.70,   0.90,   0.80,   0.30,   0.80,   1.00, &
   1.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.90,   0.90,   0.90,   0.90,   1.00,   1.00,   0.90,   0.90,   0.90, &
   1.00,   0.80,   0.90,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.90,   0.90,   0.90,   0.90, &
   0.90,   0.60,   0.60,   0.60,   0.60,   0.60,   0.60,   0.40,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.50,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01, &
   0.03,   0.01,   0.00,   0.01,   0.02,   0.00,   0.03,   0.02,   0.03,   0.03, &
   0.00,   0.05,   0.08,   0.01,   0.04,   0.02,   0.00,   0.00,   0.01,   0.01, &
   0.01,   0.00,   0.01,   0.00,   0.00,   0.01,   0.01,   0.00,   0.01,   0.03, &
   0.01,   0.02,   0.02,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.10, &
   0.03,   0.00,   0.05,   0.04,   0.00,   0.01,   0.09,   0.01,   0.03,   0.02, &
   0.29,   0.10,   0.30,   0.05,   0.06,   0.01,   0.02,   0.00,   0.00,   0.00, &
   0.00,   0.03,   0.00,   0.01,   0.00,   0.09,   0.04,   0.04,   0.04,   0.02, &
   0.12,   0.04,   0.15,   0.05,   0.00,   0.00,   0.00,   0.00,   0.04,   0.09, &
   0.08,   0.05,   0.14,   0.26,   0.04,   0.09,   0.15,   0.19,   0.34,   0.19, &
   0.14,   0.14,   0.09,   0.06,   0.09,   0.30,   0.00,   0.00,   0.00,   0.00, &
   0.24,   0.35,   0.12,   0.09,   0.06,   0.04,   0.05,   0.01,   0.00,   0.04, &
   0.05,   0.01,   0.00,   0.01,   0.04,   0.12,   0.03,   0.09,   0.06,   0.12, &
   0.04,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.35,   0.05,   0.05,   0.02,   0.66,   0.67,   0.55,   0.57,   0.52, &
   0.39,   0.39,   0.20,   0.18,   0.10,   0.33,   0.27,   0.09,   0.42,   0.45, &
   0.65,   0.34,   0.53,   0.55,   0.58,   0.45,   0.17,   0.62,   0.55,   0.78, &
   0.58,   0.69,   0.57,   0.63,   0.62,   0.71,   0.37,   0.32,   0.64,   0.56, &
   0.80,   0.79,   0.72,   0.62,   0.61,   0.67,   0.80,   0.84,   0.54,   0.43, &
   0.72,   0.55,   0.76,   0.63,   0.52,   0.24,   0.61,   0.74,   0.49,   0.42, &
   0.49,   0.61,   0.44,   0.35,   0.36,   0.75,   0.66,   0.63,   0.34,   0.58, &
   0.46,   0.13,   0.53,   0.34,   0.14,   0.53,   0.24,   0.08,   0.32,   0.18, &
   0.32,   0.39,   0.00,   0.00,   0.00,   0.00,   0.07,   0.00,   0.15,   0.03, &
   0.00,   0.02,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.05,   0.00,   0.00,   0.00,   0.10, &
   0.20,   0.39,   0.19,   0.35,   0.14,   0.20,   0.15,   0.29,   0.69,   0.53, &
   0.19,   0.01,   0.01 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:,  8) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.30,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.10,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.70,   0.00,   0.00,   0.20, &
   0.20,   0.00,   0.30,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.50,   0.10,   0.50,   0.10,   0.00,   1.00, &
   0.50,   1.00,   0.00,   0.10,   0.30,   0.10,   0.20,   0.70,   0.20,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.10,   0.10,   0.10,   0.10,   0.00,   0.00,   0.10,   0.10,   0.10, &
   0.00,   0.20,   0.10,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.02, &
   0.02,   0.01,   0.01,   0.01,   0.00,   0.01,   0.00,   0.02,   0.01,   0.01, &
   0.01,   0.00,   0.00,   0.00,   0.00,   0.01,   0.01,   0.00,   0.01,   0.00, &
   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.01,   0.00,   0.00,   0.01, &
   0.01,   0.00,   0.05,   0.00,   0.02,   0.01,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.01,   0.01,   0.00,   0.01, &
   0.03,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.01, &
   0.02,   0.01,   0.01,   0.01,   0.00,   0.01,   0.00,   0.01,   0.01,   0.01, &
   0.01,   0.01,   0.01,   0.01,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.01,   0.01,   0.01,   0.01,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.01,   0.01,   0.00,   0.01,   0.01,   0.01, &
   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.45,   0.68,   0.73,   0.18,   0.01,   0.02,   0.01,   0.04,   0.01, &
   0.02,   0.02,   0.02,   0.02,   0.15,   0.01,   0.02,   0.01,   0.10,   0.08, &
   0.05,   0.01,   0.02,   0.05,   0.02,   0.08,   0.47,   0.03,   0.05,   0.00, &
   0.01,   0.01,   0.00,   0.01,   0.14,   0.09,   0.01,   0.03,   0.05,   0.04, &
   0.01,   0.01,   0.03,   0.01,   0.00,   0.05,   0.01,   0.00,   0.02,   0.01, &
   0.00,   0.03,   0.01,   0.01,   0.01,   0.01,   0.01,   0.01,   0.01,   0.00, &
   0.01,   0.00,   0.02,   0.01,   0.00,   0.02,   0.01,   0.01,   0.01,   0.01, &
   0.00,   0.01,   0.01,   0.01,   0.01,   0.02,   0.00,   0.01,   0.01,   0.01, &
   0.02,   0.00,   0.05,   0.09,   0.04,   0.03,   0.03,   0.02,   0.01,   0.03, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.01,   0.01,   0.05,   0.08,   0.00,   0.02,   0.01,   0.01,   0.07, &
   0.01,   0.01,   0.04 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:,  9) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   1.00,   1.00,   1.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.01,   0.00,   0.01,   0.00, &
   0.00,   0.01,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.02,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.10,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.02, &
   0.02,   0.00,   0.00,   0.01,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.01,   0.00,   0.02,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.18,   0.06,   0.48,   0.01,   0.01,   0.03,   0.07,   0.09, &
   0.06,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.02,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.04,   0.01,   0.00,   0.01, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.10,   0.04,   0.05,   0.00,   0.00, &
   0.00,   0.02,   0.00,   0.04,   0.00,   0.01,   0.04,   0.01,   0.01,   0.01, &
   0.01,   0.02,   0.02,   0.02,   0.03,   0.02,   0.02,   0.02,   0.02,   0.03, &
   0.00,   0.00,   0.85,   0.76,   0.77,   0.63,   0.40,   0.31,   0.63,   0.82, &
   0.26,   0.72,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.02,   0.00,   0.08,   0.07,   0.00,   0.00, &
   0.10,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:, 10) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.10,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.70,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.60,   0.00,   0.00,   0.30,   0.60,   0.40, &
   0.00,   0.00,   0.80,   0.70,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   1.00,   1.00,   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   0.00, &
   1.00,   1.00,   1.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   1.00,   0.00,   1.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50, &
   0.00,   1.00,   1.00,   1.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.30,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.80, &
   1.00,   1.00,   0.50,   1.00,   0.70,   0.40,   0.90,   1.00,   1.00,   0.40, &
   0.00,   0.00,   0.20,   0.30,   0.40,   0.20,   0.00,   0.00,   0.00,   0.00, &
   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.05,   0.00,   0.05,   0.00,   0.00,   0.02,   0.00,   0.01,   0.53, &
   0.40,   0.30,   0.48,   0.26,   0.33,   0.27,   0.01,   0.01,   0.32,   0.10, &
   0.03,   0.25,   0.55,   0.38,   0.23,   0.44,   0.33,   0.11,   0.00,   0.61, &
   0.71,   0.59,   0.36,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.35, &
   0.76,   0.77,   0.75,   0.82,   0.57,   0.31,   0.22,   0.24,   0.12,   0.75, &
   0.32,   0.75,   0.48,   0.84,   0.59,   0.73,   0.50,   0.40,   0.33,   0.25, &
   0.22,   0.18,   0.25,   0.17,   0.09,   0.41,   0.28,   0.24,   0.48,   0.49, &
   0.55,   0.42,   0.21,   0.52,   0.49,   0.39,   0.40,   0.45,   0.46,   0.55, &
   0.64,   0.75,   0.74,   0.33,   0.59,   0.64,   0.35,   0.48,   0.24,   0.35, &
   0.36,   0.49,   0.48,   0.32,   0.67,   0.43,   0.47,   0.43,   0.28,   0.30, &
   0.07,   0.37,   0.22,   0.23,   0.21,   0.60,   0.37,   0.40,   0.44,   0.51, &
   0.54,   0.40,   0.32,   0.32,   0.45,   0.25,   0.33,   0.23,   0.34,   0.56, &
   0.48,   0.14,   0.10,   0.10,   0.22,   0.22,   0.05,   0.07,   0.08,   0.10, &
   0.00,   0.13,   0.00,   0.01,   0.01,   0.14,   0.13,   0.18,   0.13,   0.16, &
   0.19,   0.27,   0.08,   0.18,   0.35,   0.30,   0.43,   0.04,   0.24,   0.19, &
   0.00,   0.30,   0.22,   0.15,   0.19,   0.08,   0.03,   0.20,   0.24,   0.10, &
   0.00,   0.15,   0.08,   0.11,   0.04,   0.06,   0.09,   0.10,   0.12,   0.25, &
   0.06,   0.12,   0.03,   0.13,   0.15,   0.07,   0.09,   0.10,   0.22,   0.28, &
   0.04,   0.02,   0.13,   0.12,   0.05,   0.10,   0.05,   0.04,   0.37,   0.30, &
   0.38,   0.17,   0.23,   0.03,   0.12,   0.10,   0.04,   0.12,   0.16,   0.13, &
   0.20,   0.26,   0.06,   0.19,   0.05,   0.22,   0.31,   0.12,   0.18,   0.20, &
   0.53,   0.12,   0.07,   0.07,   0.07,   0.05,   0.04,   0.03,   0.04,   0.02, &
   0.02,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01, &
   0.05,   0.01,   0.10,   0.01,   0.07,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.03,   0.05, &
   0.48,   0.26,   0.17,   0.31,   0.49,   0.10,   0.49,   0.19,   0.22,   0.30, &
   0.40,   0.04,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:, 11) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.50,   0.50,   0.50,   0.50,   0.00,   0.50,   0.50, &
   0.00,   0.00,   0.00,   0.50,   0.00,   0.00,   0.00,   0.50,   0.60,   0.70, &
   0.60,   0.70,   0.60,   0.00,   0.00,   0.60,   0.00,   0.50,   0.00,   0.00, &
   0.00,   0.70,   0.00,   0.00,   0.70,   0.60,   0.50,   0.60,   0.60,   0.50, &
   0.50,   0.60,   0.60,   0.00,   0.00,   0.60,   0.00,   0.30,   0.00,   0.00, &
   0.50,   0.30,   0.00,   0.00,   0.00,   0.00,   0.30,   1.00,   1.00,   1.00, &
   1.00,   0.00,   0.00,   1.00,   1.00,   1.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.01,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:, 12) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.50,   0.80,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.50,   0.50,   0.50,   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50, &
   0.80,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50,   0.80,   1.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.08,   0.03,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.06, &
   0.03,   0.07,   0.01,   0.02,   0.02,   0.00,   0.01,   0.01,   0.01,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.06, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01, &
   0.02,   0.09,   0.03,   0.03,   0.31,   0.01,   0.02,   0.00,   0.01,   0.00, &
   0.00,   0.04,   0.00,   0.01,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00, &
   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.01,   0.00,   0.00,   0.02,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.15,   0.01,   0.00,   0.00,   0.00, &
   0.02,   0.00,   0.00,   0.01,   0.01,   0.00,   0.01,   0.01,   0.05,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01,   0.01,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.01,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.02,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.01, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.99, &
   0.00,   1.00,   1.00,   1.00,   1.00,   0.18,   0.55,   0.94,   0.89,   0.10, &
   0.02,   0.01,   0.01,   0.02,   0.06,   0.04,   0.07,   0.02,   0.00,   0.00, &
   0.02,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:, 13) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.20,   0.20,   0.00, &
   0.20,   0.00,   0.00,   0.00,   0.00,   0.20,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:, 14) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   1.00,   0.50,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.40, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.30,   0.20,   0.30,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.60,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.06,   0.00,   0.07, &
   0.06,   0.56,   0.28,   0.27,   0.34,   0.10,   0.20,   0.08,   0.72,   0.14, &
   0.21,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.11,   0.00,   0.00, &
   0.10,   0.00,   0.07,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.11,   0.13, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.03,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.12,   0.00,   0.07,   0.00,   0.01,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.12, &
   0.17,   0.22,   0.07,   0.19,   0.20,   0.06,   0.20,   0.19,   0.24,   0.17, &
   0.06,   0.00,   0.00,   0.00,   0.03,   0.12,   0.10,   0.10,   0.01,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.17,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:, 15) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   1.00, &
   0.00,   1.00,   0.00,   1.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.50,   0.50, &
   0.00,   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.50,   0.00,   0.00,   0.00,   0.50,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.30,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.30,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.20,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.13,   0.00,   0.00,   0.48,   0.12,   0.68,   0.89,   0.30,   0.66, &
   0.83,   0.16,   0.12,   0.31,   0.31,   0.23,   0.32,   0.56,   0.05,   0.11, &
   0.02,   0.08,   0.08,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.04,   0.05,   0.07,   0.02,   0.00,   0.01,   0.00,   0.00,   0.00, &
   0.10,   0.03,   0.03,   0.02,   0.07,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.03,   0.10,   0.10,   0.00,   0.00, &
   0.00,   0.05,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.01,   0.00,   0.04,   0.08,   0.00,   0.17,   0.00,   0.04,   0.00,   0.06, &
   0.07,   0.04,   0.20,   0.35,   0.03,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.03,   0.03,   0.00,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00, &
   0.05,   0.00,   0.00,   0.00,   0.00,   0.01,   0.00,   0.05,   0.18,   0.06, &
   0.12,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.05,   0.00,   0.01,   0.06,   0.00,   0.04, &
   0.00,   0.04,   0.11,   0.12,   0.15,   0.07,   0.02,   0.25,   0.01,   0.04, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.03,   0.00,   0.00,   0.02,   0.10,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.07,   0.09,   0.00,   0.01,   0.02,   0.04,   0.00, &
   0.08,   0.00,   0.00,   0.02,   0.00,   0.05,   0.01,   0.01,   0.02,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.02,   0.00,   0.03,   0.04,   0.02, &
   0.05,   0.07,   0.02,   0.12,   0.22,   0.00,   0.08,   0.13,   0.07,   0.04, &
   0.00,   0.02,   0.00,   0.00,   0.00,   0.00,   0.04,   0.00,   0.00,   0.01, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.55,   0.00,   0.00,   0.00,   0.55, &
   0.10,   0.10,   0.00,   0.00,   0.03,   0.00,   0.02,   0.07,   0.01,   0.01, &
   0.05,   0.00,   0.01 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:, 16) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.50,   0.00,   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.50,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.09,   0.85,   0.85,   0.05,   0.08,   0.85,   0.14,   0.82,   0.17,   0.10, &
   0.15,   0.06,   0.81,   0.00,   0.05,   0.12,   0.00,   0.07,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.05,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.11,   0.13,   0.10,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.02, &
   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.02,   0.02,   0.04,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.17,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:, 17) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:, 18) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.50,   0.00,   0.00,   0.00,   0.50,   0.50,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.70,   0.00, &
   0.00,   0.00,   0.00,   0.60,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.60,   0.00,   0.00,   0.60,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.60,   0.70,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   1.00,   1.00,   1.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.10,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   1.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.44,   0.03,   0.01,   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.38,   0.55,   0.60,   0.68,   0.73,   0.86,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.11,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.05,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.13,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.15,   0.05,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.03,   0.02,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_VEGTYPE(:, 19) = (/          &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.20,   0.20,   0.20,   0.20, &
   0.20,   0.20,   0.20,   0.00,   0.00,   0.20,   0.00,   0.00,   0.20,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.02,   0.05,   0.10,   0.07,   0.10,   0.02,   0.09, &
   0.00,   0.01,   0.04,   0.04,   0.00,   0.10,   0.05,   0.10,   0.04,   0.00, &
   0.00,   0.00,   0.05,   0.01,   0.08,   0.05,   0.13,   0.10,   0.07,   0.05, &
   0.03,   0.04,   0.05,   0.02,   0.01,   0.00,   0.07,   0.16,   0.18,   0.17, &
   0.08,   0.15,   0.08,   0.18,   0.16,   0.10,   0.10,   0.14,   0.14,   0.20, &
   0.10,   0.00,   0.03,   0.01,   0.17,   0.02,   0.00,   0.00,   0.06,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.15,   0.18,   0.12,   0.07,   0.00, &
   0.02,   0.04,   0.09,   0.07,   0.03,   0.09,   0.08,   0.04,   0.00,   0.10, &
   0.11,   0.09,   0.06,   0.07,   0.15,   0.06,   0.04,   0.00,   0.00,   0.00, &
   0.00,   0.01,   0.00,   0.00,   0.03,   0.03,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.02,   0.06,   0.08,   0.03,   0.01,   0.05,   0.00,   0.03, &
   0.13,   0.00,   0.00,   0.33,   0.00,   0.00,   0.00,   0.00,   0.08,   0.15, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.08, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.03,   0.03, &
   0.05,   0.03,   0.03,   0.03,   0.02,   0.00,   0.00,   0.03,   0.04,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.12,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.02,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.01,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00,   0.00, &
   0.00,   0.47,   0.48 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_H_TREE(:,  4) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5., XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    15., XUNDEF, XUNDEF, XUNDEF,    15., &
 XUNDEF,    15., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5., XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5., XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
     5.,     5.,     5., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5., &
     5., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     1.,     1.,     5.,     5., &
     5., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10.,    10.,    10.,    10., &
    10.,    10.,    10.,    10.,    10., XUNDEF, XUNDEF,    10.,    10.,    10., &
    10.,    10.,    10.,    10.,    10.,    10.,    10., XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10.,    10.,    10.,    10.,    10., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     2., &
     2., XUNDEF,    10., XUNDEF,    10., XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,    12., XUNDEF, XUNDEF,    13., XUNDEF,    12.,    15., &
    14.,    11.,    12.,    12.,    11.,    11., XUNDEF, XUNDEF,    10., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,    10.,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10., &
     5.,     5., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5., XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF,     8., XUNDEF, XUNDEF,     5., &
 XUNDEF,     4., XUNDEF,     8.,     4., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5., XUNDEF, XUNDEF, &
     8., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5., XUNDEF, &
 XUNDEF,     5.,     5., XUNDEF,     8.,     8.,     5.,     5., XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,    10.,    10.,    10.,    10., XUNDEF,    10., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,    10.,     8.,     5., XUNDEF,     8., XUNDEF,     5., &
    10.,    10., XUNDEF,    10.,    10.,    10.,    10.,    10.,     8., XUNDEF, &
    10.,     8.,     8., XUNDEF, XUNDEF, XUNDEF,     3., XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     3.,     3., XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    11., XUNDEF, XUNDEF, XUNDEF,    10., &
     7.,     7.,     8.,     8.,     5., XUNDEF,     3.,     6.,     5.,     9., &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_H_TREE(:,  5) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
    15., XUNDEF,    15., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
    15., XUNDEF,    15., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
    10.,    15., XUNDEF, XUNDEF,    15.,    15., XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10.,    15., &
 XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,     2.,     2., XUNDEF,     2., XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10.,    10., XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10.,    10.,    10., &
    10.,    10.,    10., XUNDEF,    10.,    10.,    10.,    10.,    10., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,     2., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
    14.,    15.,    15.,    14.,    15.,    15.,    15.,    15.,    15.,    14., &
    13.,    14.,    13.,    12.,    13.,    13.,    13.,    13.,    12.,    15., &
    14., XUNDEF,    12.,    12., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    14., XUNDEF, XUNDEF, &
    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF,     1., XUNDEF, XUNDEF, XUNDEF,    10., &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     2., XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     2., &
     2., XUNDEF,     1., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
    10.,    10.,    10.,    10.,    10.,    10., XUNDEF, XUNDEF, XUNDEF,    11., &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     8., XUNDEF, &
    10.,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    12.,    13.,    11., XUNDEF, &
 XUNDEF, XUNDEF,     8.,     8., XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_H_TREE(:,  6) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    30.,    20.,    30.,    20.,    20., &
    30.,    30.,    20., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,    10.,    10.,    15.,    15.,    20.,    15., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    15., &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    30., XUNDEF, XUNDEF, XUNDEF, &
    15.,    15., XUNDEF, XUNDEF,    15., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_H_TREE(:, 13) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    15., XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    20., XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5.,    10., XUNDEF, &
    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_H_TREE(:, 14) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,    20., XUNDEF, XUNDEF,    20.,    15., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10., &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,    10.,     5.,    15., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF,     7., &
    10.,    10.,    10.,    10.,    10.,    10.,    10.,    10.,    10.,     8., &
     8., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5., XUNDEF, XUNDEF, &
    10., XUNDEF,     8., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     8.,     5., &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5., XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,     5., XUNDEF,     3., XUNDEF,     3., XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5., &
     5.,     5.,     5.,     5.,     8.,     5.,     7.,     8.,     7.,     5., &
     3., XUNDEF, XUNDEF, XUNDEF,     8.,     8.,     8.,     8.,     8., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
     6., XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_H_TREE(:, 15) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    15., &
 XUNDEF,    15., XUNDEF,    15.,    20., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    15.,    15., &
 XUNDEF,    15., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,    15., XUNDEF, XUNDEF, XUNDEF,    15., XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,    15., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     2., XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,    11., XUNDEF, XUNDEF,    11.,    11.,    10.,    10.,    10.,    10., &
    10.,    10.,    10.,    10.,    10.,    10.,    10.,    10.,    10.,    10., &
    10.,    10.,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,    10.,    10.,    10.,    10., XUNDEF,     1., XUNDEF, XUNDEF, XUNDEF, &
     5.,     5.,     2.,    10.,     3., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5.,     2.,     1., XUNDEF, XUNDEF, &
 XUNDEF,     2., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
     1., XUNDEF,     2.,     2., XUNDEF,     2., XUNDEF,     5., XUNDEF,     5., &
     5.,     3.,     8.,     8.,     4., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,     1.,     2., XUNDEF, XUNDEF,     2., XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
     1., XUNDEF, XUNDEF, XUNDEF, XUNDEF,     2., XUNDEF,     5.,     8.,     5., &
     8., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,     2., XUNDEF,     2.,     2., XUNDEF,     2., &
 XUNDEF,     5.,     5.,     7.,     8.,     8.,     5.,     5.,     2.,     2., &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF,     5.,     8., XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,    10.,    10., XUNDEF,    10.,    10.,     8., XUNDEF, &
    10., XUNDEF, XUNDEF,     5., XUNDEF,     3.,     3.,     3.,     2., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     3., XUNDEF,     2.,     2.,     5., &
     5.,     5.,     5.,     5.,     8., XUNDEF,     7.,     8.,     7.,     5., &
 XUNDEF,     2., XUNDEF, XUNDEF, XUNDEF, XUNDEF,     8., XUNDEF, XUNDEF,     5., &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    13., XUNDEF, XUNDEF, XUNDEF,    10., &
     7.,     7., XUNDEF, XUNDEF,     5., XUNDEF,     3.,     6.,     5.,     9., &
     6., XUNDEF,     1. &
         /)
!-------------------------------------------------------------------                                                    
XDATA_H_TREE(:, 16) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
    15., XUNDEF,    15., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,     5., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
     8.,    15.,    15.,     8.,    15.,    15.,    15.,    15.,    15.,    14., &
    13.,    14.,    13., XUNDEF,    13.,    13., XUNDEF,    13., XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
     7., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
    10.,    10.,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    11., &
    11., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     5.,    11.,    11., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,    10., XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:,17)>0.) XDATA_H_TREE(:, 17) =   15.                                 
!-------------------------------------------------------------------                                                    
XDATA_H_TREE(:, 19) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     2.,     2.,     2.,     2., &
     2.,     2.,     2., XUNDEF, XUNDEF,     2., XUNDEF, XUNDEF,     2., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,     1.,     1.,     1.,     1.,     2.,     2.,     1., &
 XUNDEF,     2.,     2.,     2., XUNDEF,     1.,     1.,     1.,     1., XUNDEF, &
 XUNDEF, XUNDEF,     2.,     2.,     2.,     2.,     1.,     1.,     1.,     1., &
     1.,     1.,     1.,     1.,     1., XUNDEF,     2.,     1.,     2.,     2., &
     2.,     2.,     1.,     2.,     1.,     1.,     1.,     2.,     2.,     2., &
     1., XUNDEF,     2.,     2.,     2.,     2., XUNDEF, XUNDEF,     2., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     2.,     2.,     2.,     2., XUNDEF, &
     2.,     1.,     2.,     1.,     1.,     2.,     2.,     1., XUNDEF,     1., &
     1.,     1.,     1.,     1.,     2.,     2.,     1., XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,     1., XUNDEF, XUNDEF,     1.,     1., XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,     2.,     2.,     2.,     2.,     2.,     2., XUNDEF,     2., &
     2., XUNDEF, XUNDEF,     1., XUNDEF, XUNDEF, XUNDEF, XUNDEF,     2.,     2., &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     1., &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,     2.,     2., &
     2.,     2.,     2.,     2.,     2., XUNDEF, XUNDEF,     2.,     2., XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,     2., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,     1., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,     1., XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,     1.,     1. &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 8)>0.) XDATA_WATSUP(:,  8) =   0.                                  
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 9)>0.) XDATA_WATSUP(:,  9) =  30.                                  
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 8)>0.) XDATA_IRRIG(:,  8) = 0.00                                   
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 9)>0.) XDATA_IRRIG(:,  9) = 1.00                                   
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:,  1) = (/          &
 XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, &
 XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF, XUNDEF, XUNDEF,   0.50,   0.50, XUNDEF, &
   0.50, XUNDEF,   0.50, XUNDEF, XUNDEF,   0.50, XUNDEF,   0.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF,   0.50, XUNDEF,   0.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00,   1.00, XUNDEF, &
   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, &
 XUNDEF, XUNDEF,   0.50, XUNDEF,   0.50,   0.50,   0.50, XUNDEF, XUNDEF,   0.50, &
   0.50,   0.50,   0.50,   0.50, XUNDEF,   0.50,   0.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.50,   0.50, XUNDEF,   0.50,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, &
   0.50,   0.50, XUNDEF,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, XUNDEF, &
 XUNDEF,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   1.00,   1.00,   1.00,   1.00,   1.00,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50, XUNDEF,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   1.00,   1.00,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   0.50,   0.50,   0.50,   0.50,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00, XUNDEF, XUNDEF,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, XUNDEF, XUNDEF,   0.50, &
   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, XUNDEF,   0.50, &
   0.50,   1.00,   1.00 &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 2)>0.) XDATA_ROOT_DEPTH(:,  2) = 0.20                              
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 3)>0.) XDATA_ROOT_DEPTH(:,  3) = 0.20                              
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:,  4) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   2.00,   2.00, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00, XUNDEF,   2.00, XUNDEF,   2.00, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF,   2.00, XUNDEF,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF,   1.50, &
 XUNDEF,   1.50, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, &
 XUNDEF,   2.00,   3.00, XUNDEF,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00, XUNDEF,   2.00, XUNDEF,   2.00, &
   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, &
   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:,  5) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00,   2.00, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50,   2.00, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00, XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, &
   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00, XUNDEF, &
 XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:,  6) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   8.00,   5.00,   8.00,   5.00,   5.00, &
   8.00,   5.00,   5.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00,   5.00,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   5.00, XUNDEF, XUNDEF, XUNDEF, &
   3.00,   3.00, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   5.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:,  7) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.50,   1.50,   1.50,   1.50, XUNDEF, &
   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.00,   1.00,   1.00,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00,   1.50,   1.50, &
   1.50,   1.00,   1.50,   1.50,   1.50,   1.00,   1.50,   1.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   1.50,   1.50, XUNDEF,   1.50,   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.50, &
 XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF,   1.50,   1.50, &
   1.50, XUNDEF,   1.00, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF,   1.00,   1.00, &
   1.00,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00, &
   1.00, XUNDEF,   1.50,   1.00, XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.00, XUNDEF,   1.00, XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, &
   1.00,   1.50,   1.50,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00, &
   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00,   1.00, &
 XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:,  8) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF,   1.50, &
   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.50,   1.50,   1.50, XUNDEF,   1.50, &
   1.50,   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.00,   1.00,   1.00,   1.50, XUNDEF, XUNDEF,   1.50,   1.50,   1.50, &
 XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50, XUNDEF,   1.50,   1.50,   1.50, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF,   1.00, XUNDEF, &
 XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF, XUNDEF,   1.00, &
   1.00, XUNDEF,   1.00, XUNDEF,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00,   1.00, XUNDEF,   1.00, &
   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00, XUNDEF,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00, &
   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, &
   1.50,   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.00,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50,   1.50, XUNDEF,   1.50,   1.50, &
 XUNDEF,   1.50,   1.50,   1.50,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF, &
   1.00, XUNDEF,   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00, &
 XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00, &
   1.00, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50 &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 9)>0.) XDATA_ROOT_DEPTH(:,  9) = 1.50                              
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:, 10) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF,   1.00,   1.50,   0.50, &
 XUNDEF, XUNDEF,   1.00,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, &
   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
 XUNDEF,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   1.50,   1.50,   1.50,   1.50,   0.50,   1.00,   1.00,   1.00,   1.00,   1.00, &
 XUNDEF, XUNDEF,   1.50,   1.50,   1.50,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.00, XUNDEF,   1.00, XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50, &
   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.00,   1.00,   0.50,   0.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.00,   1.00,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   1.50,   1.50,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   0.50,   0.50, &
   0.50,   1.50,   1.50,   1.00,   0.50,   1.00,   1.00,   0.50,   0.50,   1.00, &
   1.00,   0.50,   0.50,   0.50,   1.00,   0.50,   0.50,   1.50,   1.50,   1.50, &
   1.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
 XUNDEF,   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
 XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.50,   1.50, &
 XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.00,   1.00,   1.00,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:, 11) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50,   1.50, &
 XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00,   1.50, &
   1.50,   1.00,   1.00, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.00, XUNDEF, XUNDEF, &
 XUNDEF,   1.00, XUNDEF, XUNDEF,   1.50,   1.50,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00, XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00, XUNDEF, XUNDEF, &
   1.00,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50,   1.50,   1.00,   1.50, &
   1.50, XUNDEF, XUNDEF,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:, 12) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   1.50, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00, XUNDEF, &
 XUNDEF,   1.00, XUNDEF,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF,   1.50,   1.50,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
 XUNDEF,   1.50,   1.50,   1.50,   1.50,   2.00,   2.00,   2.00,   2.00,   2.00, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:, 13) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00, XUNDEF, &
   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:, 14) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF,   3.00,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00,   2.00,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   1.50, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF,   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:, 15) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF,   2.00, XUNDEF,   2.00,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   1.50, &
   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00,   2.00,   2.00,   2.00, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, &
   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF,   2.00,   2.00, XUNDEF,   2.00, XUNDEF,   2.00, XUNDEF,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF,   2.00,   2.00,   2.00, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF,   2.00,   2.00, XUNDEF,   2.00, &
 XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00, XUNDEF, &
   2.00, XUNDEF, XUNDEF,   2.00, XUNDEF,   1.50,   1.50,   1.50,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.50,   1.50,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00,   2.00, XUNDEF, XUNDEF,   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00, &
   2.00, XUNDEF,   2.00 &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:,16)>0.) XDATA_ROOT_DEPTH(:, 16) = 2.00                              
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:,17)>0.) XDATA_ROOT_DEPTH(:, 17) = 2.00                              
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:, 18) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.00,   1.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00,   1.00,   1.00, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.50,   0.50,   0.50,   1.00,   1.00,   1.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50,   0.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_ROOT_DEPTH(:, 19) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   4.00,   4.00,   4.00,   4.00, &
   4.00,   4.00,   4.00, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
 XUNDEF,   2.00,   2.00,   2.00, XUNDEF,   1.50,   1.50,   1.50,   1.50, XUNDEF, &
 XUNDEF, XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   1.50,   2.00,   2.00,   1.50,   1.50,   1.50,   1.50,   2.00, &
   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   1.50,   1.50, XUNDEF, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   2.00,   2.00,   3.00,   2.00,   2.00,   2.00, XUNDEF,   2.00, &
   2.00, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   3.00,   3.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:,  1) = (/          &
 XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, &
 XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF, &
   1.00, XUNDEF,   1.00, XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00, XUNDEF,   1.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   1.50, XUNDEF, &
   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, &
 XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00,   1.00,   1.00, XUNDEF, XUNDEF,   1.00, &
   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00,   1.00, XUNDEF,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, &
   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF, &
 XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.50,   1.50,   1.50,   1.50,   1.50,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.50,   1.50,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.00,   1.00,   1.00,   1.00,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50, XUNDEF, XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF, XUNDEF,   1.00, &
   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00, &
   1.00,   1.50,   1.50 &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 2)>0.) XDATA_GROUND_DEPTH(:,  2) = 0.20                            
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 3)>0.) XDATA_GROUND_DEPTH(:,  3) = 0.20                            
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:,  4) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF,   3.00, &
 XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   4.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   3.00,   3.00,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, &
   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00, &
   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00, &
   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, XUNDEF,   3.00,   3.00,   3.00, &
   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00, XUNDEF,   3.00, XUNDEF,   3.00, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF,   3.00, XUNDEF,   3.00,   3.00, &
   3.00,   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, XUNDEF,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, &
   3.00,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.50, XUNDEF, XUNDEF,   2.00, &
 XUNDEF,   2.00, XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.50, XUNDEF, XUNDEF, &
   2.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, &
 XUNDEF,   3.00,   3.00, XUNDEF,   3.00,   2.50,   2.50,   2.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00, XUNDEF,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00, XUNDEF,   3.00, XUNDEF,   3.00, &
   3.00,   3.00, XUNDEF,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, &
   3.00,   3.00,   3.00, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF,   3.00, &
   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF,   3.00,   3.00,   3.00,   3.00, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:,  5) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   3.00, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   3.00, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   3.00,   3.00, XUNDEF, XUNDEF,   3.00,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00, &
 XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00,   2.50, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00, &
   3.00,   3.00,   3.00, XUNDEF,   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00, &
   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00, &
   3.00, XUNDEF,   3.00,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, &
   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF,   3.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.50, &
   2.50, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   3.00,   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, XUNDEF, XUNDEF,   3.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, &
   3.00,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00, XUNDEF, &
 XUNDEF, XUNDEF,   3.00,   3.00, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:,  6) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   8.00,   5.00,   8.00,   5.00,   5.00, &
   8.00,   5.00,   5.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   4.00,   4.00,   4.00,   4.00,   5.00,   4.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   5.00, XUNDEF, XUNDEF, XUNDEF, &
   3.00,   4.00, XUNDEF, XUNDEF,   4.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   5.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:,  7) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
 XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   2.00,   2.00,   2.00,   2.00, XUNDEF, &
   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50,   1.50,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   2.00,   2.00, &
   2.00,   1.50,   2.00,   2.00,   2.00,   1.50,   2.00,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00,   2.00, XUNDEF,   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00, &
 XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF,   2.00,   2.00, &
   2.00, XUNDEF,   1.50, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF,   1.50,   1.50, &
   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.50, &
   1.50, XUNDEF,   2.00,   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50, XUNDEF,   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, &
   1.50,   2.00,   2.00,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50, &
   1.50,   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.50,   1.50, &
 XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:,  8) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF,   2.00, &
   2.00, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   2.00,   2.00,   2.00, XUNDEF,   2.00, &
   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50,   1.50,   2.00, XUNDEF, XUNDEF,   2.00,   2.00,   2.00, &
 XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.00, XUNDEF,   2.00,   2.00,   2.00, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF,   1.50, XUNDEF, &
 XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF,   1.50, &
   1.50, XUNDEF,   1.50, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   1.50, XUNDEF,   1.50, &
   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50, XUNDEF,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF,   1.50,   1.50,   1.50, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, &
   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00,   1.50,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.00,   2.00, XUNDEF,   2.00,   2.00, &
 XUNDEF,   2.00,   2.00,   2.00,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, &
   1.50, XUNDEF,   1.50,   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50, &
 XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50,   1.50,   1.50, &
   1.50, XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00 &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 9)>0.) XDATA_GROUND_DEPTH(:,  9) = 2.00                            
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:, 10) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF,   1.50,   2.00,   1.00, &
 XUNDEF, XUNDEF,   1.50,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, &
   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00,   2.00,   2.00,   2.00,   1.00,   1.50,   1.50,   1.50,   1.50,   1.50, &
 XUNDEF, XUNDEF,   2.00,   2.00,   2.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.50,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.00, &
   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   2.00,   2.00,   2.00,   2.00,   2.00,   1.50,   1.50,   1.00,   1.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   1.50,   1.50,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   2.00,   2.00,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   1.00,   1.00, &
   1.00,   2.00,   2.00,   1.50,   1.00,   1.50,   1.50,   1.00,   1.00,   1.50, &
   1.50,   1.00,   1.00,   1.00,   1.50,   1.00,   1.00,   2.00,   2.00,   2.00, &
   2.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
 XUNDEF,   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
 XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   2.00,   2.00, &
 XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   1.50,   1.50,   1.50,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:, 11) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.00,   2.00, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   2.00, &
   2.00,   1.50,   1.50, XUNDEF, XUNDEF,   2.00, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF,   1.50, XUNDEF, XUNDEF,   2.00,   2.00,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, &
   1.50,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   2.00,   1.50,   2.00, &
   2.00, XUNDEF, XUNDEF,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:, 12) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50,   1.50,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50, XUNDEF, &
 XUNDEF,   1.50, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:, 13) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   5.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00, XUNDEF, &
   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:, 14) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   5.00, XUNDEF, XUNDEF,   5.00,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   3.00,   3.00,   4.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF,   3.00, &
   3.00,   3.00,   2.50,   2.50,   2.50,   2.50,   2.50,   2.50,   2.50,   2.00, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.50, XUNDEF, XUNDEF, &
   2.00, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.50,   2.50, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF,   2.00, XUNDEF,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, &
   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00, &
   3.00, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   3.00, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:, 15) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, &
 XUNDEF,   3.00, XUNDEF,   3.00,   4.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00, &
 XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   3.00, XUNDEF, XUNDEF,   3.00,   3.00,   2.50,   3.00,   3.00,   3.00, &
   3.00,   3.00,   2.50,   2.50,   2.50,   2.50,   2.50,   2.50,   2.50,   2.00, &
   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   3.00,   3.00,   3.00,   3.00, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, &
   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.50,   2.50,   2.50, XUNDEF, XUNDEF, &
 XUNDEF,   2.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.50, XUNDEF,   2.50,   2.50, XUNDEF,   2.50, XUNDEF,   2.50, XUNDEF,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF,   2.50,   2.50,   2.50, &
   2.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF,   3.00,   3.00, XUNDEF,   3.00, &
 XUNDEF,   3.00,   3.00,   3.00,   3.00,   2.50,   2.50,   2.50,   2.50,   2.50, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF,   3.00,   3.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00, XUNDEF,   3.00,   3.00,   3.00, XUNDEF, &
   3.00, XUNDEF, XUNDEF,   3.00, XUNDEF,   2.00,   2.00,   2.00,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF,   2.00,   2.00,   3.00, &
   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF,   3.00,   3.00,   3.00,   3.00, &
 XUNDEF,   2.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF,   3.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF,   3.00, &
   3.00,   3.00, XUNDEF, XUNDEF,   3.00, XUNDEF,   3.00,   3.00,   3.00,   3.00, &
   3.00, XUNDEF,   3.00 &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:,16)>0.) XDATA_GROUND_DEPTH(:, 16) = 3.00                            
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:,17)>0.) XDATA_GROUND_DEPTH(:, 17) = 3.00                            
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:, 18) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF, XUNDEF,   2.00,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   1.50,   1.50, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50,   1.50,   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00,   1.00,   1.50,   1.50,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_GROUND_DEPTH(:, 19) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   4.00,   4.00,   4.00,   4.00, &
   4.00,   4.00,   4.00, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
 XUNDEF,   3.00,   3.00,   3.00, XUNDEF,   2.00,   2.00,   2.00,   2.00, XUNDEF, &
 XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00,   2.50,   2.50,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.50,   2.50,   2.50,   2.50, &
   2.50,   2.50,   2.00,   2.50,   2.50,   2.00,   2.00,   2.00,   2.00,   2.50, &
   2.50, XUNDEF,   2.50,   2.50,   2.50,   2.50, XUNDEF, XUNDEF,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00,   2.00, XUNDEF, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.50, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF,   3.00, &
   3.00, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.50,   2.50, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF, XUNDEF,   2.00,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   3.00,   3.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:,  1) = (/          &
 XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.30, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.40, &
 XUNDEF, XUNDEF, XUNDEF,   0.40, XUNDEF, XUNDEF, XUNDEF,   0.50,   0.50, XUNDEF, &
   0.50, XUNDEF,   0.50, XUNDEF, XUNDEF,   0.50, XUNDEF,   0.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.30, XUNDEF,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.30,   0.40,   0.40,   0.30,   0.30,   0.50,   0.50, &
   0.50,   0.50,   0.40,   0.40,   0.30,   0.30,   0.40, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   0.30, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF,   0.50, XUNDEF,   0.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   0.80,   1.00, XUNDEF, &
   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, &
 XUNDEF, XUNDEF,   0.50, XUNDEF,   0.30,   0.50,   0.50, XUNDEF, XUNDEF,   0.50, &
   0.50,   0.50,   0.50,   0.50, XUNDEF,   0.50,   0.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.25,   0.25, XUNDEF,   0.25,   0.25, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.25, &
   0.25,   0.30, XUNDEF,   0.30,   0.30,   0.30,   0.30,   0.30,   0.30, XUNDEF, &
 XUNDEF,   0.40,   0.40,   0.40,   0.40,   0.40,   0.50,   0.50,   0.50,   0.40, &
   0.40,   0.50,   0.50,   0.50,   1.00,   1.00,   1.00,   1.00,   1.00,   0.50, &
   0.50,   0.50,   0.50,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   0.40, &
   0.40,   0.40,   0.40, XUNDEF,   0.40,   0.50,   0.50,   0.50,   0.40,   0.40, &
   0.40,   0.40,   0.40,   0.40,   0.40,   0.40,   0.40,   0.40,   0.40,   0.40, &
   0.40,   0.40,   0.40,   0.40,   0.40,   0.50,   0.50,   0.50,   0.30,   0.40, &
   0.40,   0.50,   0.50,   0.50,   0.30,   0.40,   0.40,   0.40,   0.50,   0.50, &
   0.50,   0.40,   0.40,   1.00,   1.00,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.25, &
   0.40,   0.40,   0.40,   0.40,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   0.80,   0.80,   0.40,   0.40,   0.40,   0.40,   0.40,   0.50,   0.40,   0.40, &
   0.30,   0.30,   0.30,   0.40,   0.40,   0.40,   0.80,   0.80,   0.80,   0.80, &
   0.80,   0.80,   0.80,   0.80,   0.80,   0.80,   0.50,   0.40,   0.40,   0.40, &
   0.40,   0.40,   0.40,   0.40,   0.40,   0.40,   0.40,   0.40,   0.40,   0.50, &
   0.40,   0.40,   0.40,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   0.40,   0.50,   0.50,   0.50,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00, XUNDEF, XUNDEF,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50,   0.25,   0.25, XUNDEF, XUNDEF,   0.50, &
   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.40,   0.40,   0.40,   0.40,   0.40,   0.30,   0.50,   0.50, XUNDEF,   0.50, &
   0.50,   1.00,   1.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:,  2) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.25,   0.25, XUNDEF,   0.25,   0.25, XUNDEF,   0.25, XUNDEF,   0.25,   0.25, &
   0.25,   0.20, XUNDEF,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   0.20, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.20,   0.20,   0.20,   0.20, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20, &
   0.20,   0.20,   0.20,   0.20,   0.20, XUNDEF,   0.20,   0.20, XUNDEF,   0.20, &
   0.20, XUNDEF,   0.20, XUNDEF, XUNDEF,   0.20,   0.20, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.20,   0.20,   0.20,   0.20,   0.20, &
   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20, &
   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20, &
   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.20, XUNDEF, XUNDEF, XUNDEF,   0.20, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.20, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.20, &
 XUNDEF,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20, &
   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20,   0.20, &
   0.20,   0.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.20,   0.20, XUNDEF, &
 XUNDEF,   0.20,   0.20,   0.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.20, &
   0.20,   0.20, XUNDEF,   0.20,   0.20,   0.25, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.20, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:,  3) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.25,   0.25, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:,  4) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF,   1.00, &
 XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.40, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.60,   2.00,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, &
   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   2.40,   2.00,   1.60, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   1.60,   1.60, &
   1.60,   2.00,   1.60,   1.60,   1.60, XUNDEF, XUNDEF,   2.00,   2.00,   2.00, &
   2.00,   1.60,   1.60,   1.60,   1.60,   1.60,   1.60, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   1.60,   1.60,   1.60,   1.60, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00, XUNDEF,   2.00, XUNDEF,   1.60, XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00,   1.60, &
   1.60,   1.60,   1.60,   1.60,   1.60,   1.60, XUNDEF, XUNDEF,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, &
   1.60,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF,   1.50, &
 XUNDEF,   1.50, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, &
 XUNDEF,   1.60,   2.40, XUNDEF,   1.60,   1.60,   1.60,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.60,   1.60,   1.60,   1.60, XUNDEF,   1.60, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.60,   1.60,   1.60, XUNDEF,   1.60, XUNDEF,   1.60, &
   1.60,   1.60, XUNDEF,   1.60,   1.60,   1.60,   1.60,   1.60,   1.60, XUNDEF, &
   1.60,   1.60,   1.60, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF,   1.60, &
   1.60,   1.60,   1.60,   1.60,   1.60, XUNDEF,   2.00,   2.00,   1.60,   2.00, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:,  5) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.30, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.30, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.30,   1.00, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.30,   1.00, &
 XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.30,   1.60, XUNDEF,   0.30, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.30, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   1.60, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   1.60,   1.60, &
   1.60,   1.60,   1.60, XUNDEF,   2.00,   1.60,   1.60,   1.60,   1.60, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25, &
   0.25,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.60, &
   1.60, XUNDEF,   1.60,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.25, XUNDEF, XUNDEF, &
   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF,   1.60, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, &
   1.60, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00,   1.00,   1.00,   1.60,   1.60,   1.60, XUNDEF, XUNDEF, XUNDEF,   1.60, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, XUNDEF, &
   1.60,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.25,   1.00,   1.00, XUNDEF, &
 XUNDEF, XUNDEF,   1.60,   1.60, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:,  6) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   8.00,   5.00,   8.00,   4.00,   5.00, &
   8.00,   4.00,   5.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00,   4.00,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   5.00, XUNDEF, XUNDEF, XUNDEF, &
   2.40,   3.00, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   5.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:,  7) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, &
 XUNDEF,   0.80,   1.20, XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.80, &
   1.20, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.50,   1.50,   1.50,   1.50, XUNDEF, &
   1.20, XUNDEF,   1.20,   1.20,   1.20,   1.20,   1.20,   0.80,   1.20,   1.50, &
   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.00,   1.00,   1.00,   1.50,   1.20,   1.50,   1.20,   1.20,   1.20, &
   1.20,   1.20,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00,   1.20,   1.20, &
   1.20,   1.00,   1.20,   1.20,   1.20,   1.00,   1.20,   1.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.25, &
   0.25,   0.60, XUNDEF,   0.60,   0.60, XUNDEF,   0.60,   0.60,   0.60,   1.20, &
 XUNDEF,   1.20,   1.20,   1.20,   1.20,   1.20, XUNDEF, XUNDEF,   1.50,   1.20, &
   1.20, XUNDEF,   1.00, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF,   1.00,   1.00, &
   1.00,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.25, XUNDEF,   0.80, &
   0.80, XUNDEF,   1.20,   0.80, XUNDEF,   1.00,   1.00,   1.00,   0.80,   0.80, &
   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   0.80, XUNDEF,   0.80, XUNDEF,   1.00,   1.00,   1.00,   0.40,   0.80, &
   0.80,   1.00,   1.00,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, &
   1.00,   1.20,   1.20,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00, &
   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.20,   1.20,   1.20,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.50,   1.20,   1.20, &
   0.60,   0.60,   0.60,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20, &
   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.50,   1.20,   1.20,   1.20, &
   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.50, &
   1.20,   1.20,   0.80,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   0.80,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF,   1.00,   1.00, &
 XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.80, XUNDEF, XUNDEF, XUNDEF,   1.20, &
   1.20,   1.20,   1.20,   1.20,   1.20,   0.60,   1.50,   1.50,   1.20,   1.50, &
   1.50,   1.50,   1.50 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:,  8) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF,   0.80, &
   1.20, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.50,   1.50,   1.50, XUNDEF,   1.50, &
   1.20,   1.50, XUNDEF,   1.20,   1.20,   1.20,   1.20,   0.80,   1.20, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.00,   1.00,   1.00,   1.50, XUNDEF, XUNDEF,   1.20,   1.20,   1.20, &
 XUNDEF,   1.20,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, &
   1.20,   1.20,   1.20,   1.20, XUNDEF,   1.20, XUNDEF,   1.50,   1.50,   1.20, &
   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF,   1.00, XUNDEF, &
 XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF, XUNDEF,   0.80, &
   0.80, XUNDEF,   0.80, XUNDEF,   0.80,   0.80, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00,   1.00, XUNDEF,   0.80, &
   0.80,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, &
   1.00,   0.80,   0.80,   1.00, XUNDEF,   1.00, XUNDEF,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00, &
   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.20,   1.20,   1.20,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.50,   1.20,   1.20, &
   0.60,   0.60,   0.60,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20, XUNDEF, &
   1.20,   1.20, XUNDEF,   1.20,   1.20,   1.20,   1.00,   1.20,   1.20,   1.20, &
   1.20,   1.20,   1.20,   1.20, XUNDEF,   1.20,   1.20, XUNDEF,   1.20,   1.50, &
 XUNDEF,   1.20,   1.20,   1.50,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF, &
   1.00, XUNDEF,   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00, &
 XUNDEF,   1.00,   1.00,   1.00,   1.00,   1.00, XUNDEF,   1.00,   1.00,   1.00, &
   0.80, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.20,   1.20,   1.20,   1.20, XUNDEF,   1.50,   1.50,   1.20,   1.50, &
   1.50,   1.50,   1.50 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:,  9) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF,   1.50, XUNDEF, &
 XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   1.50, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   1.20,   1.20,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.20, XUNDEF,   1.20, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, &
 XUNDEF,   1.50, XUNDEF,   1.50, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
 XUNDEF, XUNDEF,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:, 10) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.30, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.80, XUNDEF, XUNDEF,   0.50,   1.50,   0.50, &
 XUNDEF, XUNDEF,   0.80,   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.20, XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF, &
   1.20,   1.20,   0.80,   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF,   0.80, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, &
 XUNDEF,   1.20,   1.20,   1.20,   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
   1.20,   1.20,   1.50,   1.20,   0.30,   1.00,   1.00,   0.80,   0.80,   1.00, &
 XUNDEF, XUNDEF,   1.50,   1.50,   1.20,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   0.40, XUNDEF,   0.40, XUNDEF, XUNDEF,   0.40, XUNDEF,   0.40,   1.20, &
   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.50,   1.50,   1.50,   1.20, &
   1.20,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50, &
   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.80, &
   1.20,   1.20,   1.20,   1.20,   1.20,   1.00,   1.00,   0.50,   0.40,   1.20, &
   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   0.80,   0.80,   0.40,   0.40, &
   0.40,   0.40,   0.40,   0.40,   0.40,   1.50,   1.50,   1.00,   0.40,   0.80, &
   0.80,   1.00,   1.00,   1.00,   0.40,   0.80,   0.80,   0.80,   1.00,   1.00, &
   1.00,   1.20,   1.20,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   0.50,   0.50, &
   0.50,   1.50,   1.50,   1.00,   0.50,   1.00,   1.00,   0.50,   0.50,   1.00, &
   1.00,   0.50,   0.50,   0.50,   1.00,   0.50,   0.50,   1.50,   1.50,   1.50, &
   1.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.25, &
 XUNDEF,   1.20, XUNDEF,   1.20,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.20,   1.20,   0.80,   0.80,   0.80,   0.80,   0.80,   1.00,   0.80,   0.80, &
 XUNDEF,   0.40,   0.40,   0.80,   0.80,   0.80,   0.80,   0.80,   1.20,   1.20, &
 XUNDEF,   1.20,   1.20,   1.20,   1.20,   1.20,   1.00,   0.80,   0.80,   1.20, &
   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.20,   1.50, &
   1.20,   1.20,   1.20,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   0.50,   0.50,   0.50,   0.50,   0.50,   0.50, &
   0.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, &
   1.20,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, &
   0.50,   0.50,   0.50,   0.50,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.60,   1.20, &
   1.20,   1.20,   1.20,   1.20,   1.20,   0.60,   1.50,   1.50,   1.20,   1.50, &
   1.50,   1.50, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:, 11) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50,   1.20, &
 XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF,   1.00,   1.00,   1.50, &
   1.50,   1.00,   1.00, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.00, XUNDEF, XUNDEF, &
 XUNDEF,   1.00, XUNDEF, XUNDEF,   1.50,   1.50,   1.00,   1.00,   1.00,   1.00, &
   1.00,   1.00,   1.00, XUNDEF, XUNDEF,   0.80, XUNDEF,   0.50, XUNDEF, XUNDEF, &
   1.00,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.40,   1.50,   1.00,   1.50, &
   1.50, XUNDEF, XUNDEF,   1.20,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.80, XUNDEF,   0.80, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:, 12) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.80, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   3.00,   0.30, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.20,   1.50,   1.20,   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, &
   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60,   1.60,   1.20, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.25,   0.25, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.25, &
   0.25,   0.40,   0.40,   0.40,   0.40, XUNDEF,   0.40,   0.40,   0.40, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.80, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.80, &
   0.80,   0.80,   0.80,   0.80,   0.80,   1.00,   1.00, XUNDEF,   0.80, XUNDEF, &
 XUNDEF,   0.80, XUNDEF,   0.80,   0.80, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.80, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.20, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20,   1.20, XUNDEF, XUNDEF, XUNDEF, &
   1.20, XUNDEF, XUNDEF,   1.20,   1.20, XUNDEF,   1.50,   1.20,   1.20, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20,   1.20, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, &
 XUNDEF,   0.25,   1.50,   1.20,   1.20,   1.60,   0.25,   1.00,   1.00,   1.60, &
   1.20,   1.20,   1.20,   1.20,   1.20,   0.60,   1.50,   1.50, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:, 13) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00, XUNDEF, &
   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:, 14) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF,   3.00,   2.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00,   2.00,   2.40, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF,   1.60, &
   1.60,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   1.50, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, &
   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF,   1.50, XUNDEF,   1.50, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00, &
   1.60, XUNDEF, XUNDEF, XUNDEF,   3.00,   3.00,   3.00,   3.00,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:, 15) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, &
 XUNDEF,   1.60, XUNDEF,   1.60,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   1.00, &
 XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.80, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.60, XUNDEF, XUNDEF,   1.60,   1.60,   2.00,   2.00,   2.00,   1.60, &
   1.60,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   2.00,   1.50, &
   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.60,   1.60,   1.60,   1.60, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, &
   1.60,   1.60,   1.60,   1.60,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00,   2.00,   2.00, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   2.00, XUNDEF,   1.60,   2.00, XUNDEF,   2.00, XUNDEF,   2.00, XUNDEF,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF,   2.00,   2.00,   2.00, &
   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, XUNDEF,   2.00,   2.00, XUNDEF,   2.00, &
 XUNDEF,   1.60,   1.60,   1.60,   1.60,   1.60,   1.60,   2.00,   1.60,   1.60, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF,   2.00,   1.60, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.60,   1.60, XUNDEF,   1.60,   1.60,   1.60, XUNDEF, &
   1.60, XUNDEF, XUNDEF,   2.00, XUNDEF,   1.50,   1.50,   1.50,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50, XUNDEF,   1.50,   1.50,   2.00, &
   2.00,   2.00,   2.00,   2.00,   2.00, XUNDEF,   2.00,   2.00,   2.00,   2.00, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   3.00, XUNDEF, XUNDEF,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF,   1.60, &
   1.60,   1.60, XUNDEF, XUNDEF,   1.60, XUNDEF,   2.00,   2.00,   1.60,   2.00, &
   2.00, XUNDEF,   2.00 &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:, 16) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.30, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25, &
   0.25,   1.00,   1.00, XUNDEF,   1.00,   1.00, XUNDEF,   1.00, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.00,   1.00,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60, &
   1.60, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.25,   1.00,   1.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:,17)>0.) XDATA_DICE(:, 17) = 0.30                                    
!-------------------------------------------------------------------                                                    
XDATA_DICE(:, 18) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.30, XUNDEF, XUNDEF, XUNDEF,   0.80,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.30, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.30, XUNDEF, XUNDEF,   0.30, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.30,   0.30, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.30,   0.80,   0.30, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   0.30, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.25,   0.25,   0.25, XUNDEF,   0.25, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.40, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   0.40, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
   1.20, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.25,   0.25, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   0.25,   0.60, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF &
         /)
!-------------------------------------------------------------------                                                    
XDATA_DICE(:, 19) = (/          &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   4.00,   4.00,   4.00,   4.00, &
   4.00,   4.00,   4.00, XUNDEF, XUNDEF,   2.40, XUNDEF, XUNDEF,   3.00, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF,   0.25,   0.25,   0.25,   0.25,   0.25,   0.25,   1.20, &
 XUNDEF,   1.60,   1.60,   1.60, XUNDEF,   1.50,   1.50,   1.50,   1.20, XUNDEF, &
 XUNDEF, XUNDEF,   1.60,   1.60,   1.60,   1.60,   1.60,   1.60,   1.20,   1.20, &
   1.20,   1.20,   1.20,   1.20,   1.20, XUNDEF,   2.00,   2.00,   1.00,   1.60, &
   1.60,   2.00,   1.50,   2.00,   1.00,   1.20,   1.20,   1.20,   1.50,   2.00, &
   2.00, XUNDEF,   1.60,   2.00,   2.00,   2.00, XUNDEF, XUNDEF,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50,   1.50,   1.50, XUNDEF, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF,   1.60,   1.60,   3.00,   2.00,   2.00,   2.00, XUNDEF,   2.00, &
   1.60, XUNDEF, XUNDEF,   2.40, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.60,   1.60, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   2.00, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF,   1.50,   1.50, &
   1.50,   1.50,   1.50,   1.50,   1.50, XUNDEF, XUNDEF,   1.50,   1.50, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   2.00, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, XUNDEF, &
 XUNDEF,   3.00,   3.00 &
         /)
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 9)>0.        ) TDATA_SEED(:,  9)%TDATE%DAY =10
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 9)>0.        ) TDATA_SEED(:,  9)%TDATE%MONTH =05
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 9)>0.        ) TDATA_REAP(:,  9)%TDATE%DAY =01
!-------------------------------------------------------------------                                                    
WHERE(XDATA_VEGTYPE(:, 9)>0.        ) TDATA_REAP(:,  9)%TDATE%MONTH =08
!-------------------------------------------------------------------                                                    
!
IF (LHOOK) CALL DR_HOOK('DEFAULT_DATA_COVER',1,ZHOOK_HANDLE) 
!
END SUBROUTINE DEFAULT_DATA_COVER
