!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
!SUBROUTINE DEALLOC_TOWN_n (B, CHT, DGT, DTB, DTT, U, TG, T, TOP, TPN)
SUBROUTINE DEALLOC_TOWN_n (GDM, GRM, HM, TM, U) 
!     ###############################################################################
!
!!****  *DEALLOC_TOWN_n * - Deallocate all arrays
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      
!!      M. Goret    02/2017  add DTB and DGT as DEALLOC_TEB_n arg.
!!      M. Goret    07/2017  add call to dealloc_misc_tebn for deallocation of arrays relative to one teb patch
!!------------------------------------------------------------------
!

!
!
!
!
!
USE MODD_SURFEX_n, ONLY : TEB_MODEL_t
USE MODD_SURFEX_n, ONLY : TEB_GARDEN_MODEL_t
USE MODD_SURFEX_n, ONLY : TEB_GREENROOF_MODEL_t
USE MODD_SURFEX_n, ONLY : TEB_HYDRO_MODEL_t
!USE MODD_BEM_n, ONLY : BEM_t
!USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!USE MODD_DIAG_TEB_n, ONLY : DIAG_TEB_t
!USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
!USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_TEB_GRID_n, ONLY : TEB_GRID_t
!USE MODD_TEB_n, ONLY : TEB_t
!USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!USE MODD_TEB_PANEL_n, ONLY : TEB_PANEL_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_DEALLOC_IDEAL_FLUX
!
USE MODI_DEALLOC_TEB_n
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
!*      0.2    declarations of local variables
!
!-------------------------------------------------------------------------------------
!
TYPE(TEB_GARDEN_MODEL_t),    INTENT(INOUT) :: GDM
TYPE(TEB_GREENROOF_MODEL_t), INTENT(INOUT) :: GRM
TYPE(TEB_HYDRO_MODEL_t),     INTENT(INOUT) :: HM
TYPE(TEB_MODEL_t),           INTENT(INOUT) :: TM
!
!TYPE(BEM_t), INTENT(INOUT) :: B
!TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
!TYPE(DIAG_TEB_t), INTENT(INOUT) :: DGT
!TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
!TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!TYPE(TEB_t), INTENT(INOUT) :: T
!TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!TYPE(TEB_PANEL_t), INTENT(INOUT) :: TPN
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
INTEGER         :: JPATCH

IF (LHOOK) CALL DR_HOOK('DEALLOC_TOWN_N',0,ZHOOK_HANDLE)
IF (U%CTOWN=='TEB   ') THEN
  CALL DEALLOC_TEB_n(TM%CHT,TM%DGT,TM%DTB, TM%DTT, TM%TG, TM%TOP, TM%TPN)
  DO JPATCH=1,TM%TOP%NTEB_PATCH
     CALL GOTO_WRAPPER_TEB_PATCH(TM%B, TM%DGCT, TM%DGMT, TM%T, &
                                 GDM%TGD, GDM%TGDPE,           &
                                 GRM%TGR, GRM%TGRPE,           &
                                 HM%TH, JPATCH                 )
      CALL DEALLOC_MISC_TEB_N(TM%B,TM%DGCT, TM%DGMT, TM%T)

      !CALL diag_misc_teb_init_n(tm%DGCT, tm%DGMT, tm%DGMTO, tm%TOP, &
      !                         hprogram,ilu,iswb)
  END DO ! end of loop on patches
ELSE IF (U%CTOWN=='FLUX  ') THEN
  CALL DEALLOC_IDEAL_FLUX
END IF
IF (LHOOK) CALL DR_HOOK('DEALLOC_TOWN_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DEALLOC_TOWN_n
