!     #################################################################################
SUBROUTINE DEALLOC_TEB_n (CHT,DGT, DTB, DTT, TG, TOP, TPN)
!     #################################################################################
!
!!****  *DEALLOC_TEB_n * - Deallocate all arrays
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      G. Pigeon   09/2012: deallocate ROUGH_WALL/ROUGH_ROOF
!!      G. Pigeon   10/2012: deallocate BEM variables
!!      M. Goret    02/2017: deallocate heat source fractions
!!      M. Goret    02/2017: deallocate DATA_BEM, DIAG_TEB and MODD_DATA_COVER variables
!!      M. Goret    07/2017: move deallocation of TEB_t,BEM_t to DEALLOCATE_MISC_TEBN
!!------------------------------------------------------------------
!!
!
USE MODD_CH_TEB_n, ONLY : CH_TEB_t
USE MODD_DIAG_TEB_n, ONLY : DIAG_TEB_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DATA_COVER
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_TEB_GRID_n, ONLY : TEB_GRID_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
USE MODD_TEB_PANEL_n, ONLY : TEB_PANEL_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
!*      0.2    declarations of local variables
!
!-------------------------------------------------------------------------------------
!
TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
TYPE(DIAG_TEB_t), INTENT(INOUT) :: DGT
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(TEB_GRID_t), INTENT(INOUT) :: TG
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
TYPE(TEB_PANEL_t), INTENT(INOUT) :: TPN
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('DEALLOC_TEB_N',0,ZHOOK_HANDLE)
!
IF (ASSOCIATED(TOP%LCOVER ))  DEALLOCATE(TOP%LCOVER )
IF (ASSOCIATED(TOP%XCOVER ))  DEALLOCATE(TOP%XCOVER )
IF (ASSOCIATED(TOP%XZS    ))  DEALLOCATE(TOP%XZS    )
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(TG%XGRID_PAR )) DEALLOCATE(TG%XGRID_PAR )
IF (ASSOCIATED(TG%XLAT      )) DEALLOCATE(TG%XLAT      )
IF (ASSOCIATED(TG%XLON      )) DEALLOCATE(TG%XLON      )
IF (ASSOCIATED(TG%XMESH_SIZE)) DEALLOCATE(TG%XMESH_SIZE)
!
!-------------------------------------------------------------------------------------
!
!
IF(ASSOCIATED(TPN%XEMIS_PANEL)) DEALLOCATE(TPN%XEMIS_PANEL)
IF(ASSOCIATED(TPN%XALB_PANEL )) DEALLOCATE(TPN%XALB_PANEL )
IF(ASSOCIATED(TPN%XEFF_PANEL )) DEALLOCATE(TPN%XEFF_PANEL )
IF(ASSOCIATED(TPN%XFRAC_PANEL)) DEALLOCATE(TPN%XFRAC_PANEL)
IF(ASSOCIATED(TPN%XTHER_PRODC_DAY)) DEALLOCATE(TPN%XTHER_PRODC_DAY)
!
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(CHT%XDEP))      DEALLOCATE(CHT%XDEP)
IF(ASSOCIATED(CHT%CCH_NAMES)) DEALLOCATE(CHT%CCH_NAMES)
IF(ASSOCIATED(CHT%SVT%CSV))       DEALLOCATE(CHT%SVT%CSV)
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(DTT%XPAR_Z0_TOWN    )) DEALLOCATE(DTT%XPAR_Z0_TOWN    )
IF(ASSOCIATED(DTT%XPAR_BLD        )) DEALLOCATE(DTT%XPAR_BLD        )
IF(ASSOCIATED(DTT%XPAR_ALB_ROOF   )) DEALLOCATE(DTT%XPAR_ALB_ROOF   )
IF(ASSOCIATED(DTT%XPAR_EMIS_ROOF  )) DEALLOCATE(DTT%XPAR_EMIS_ROOF  )
IF(ASSOCIATED(DTT%XPAR_HC_ROOF    )) DEALLOCATE(DTT%XPAR_HC_ROOF    )
IF(ASSOCIATED(DTT%XPAR_TC_ROOF    )) DEALLOCATE(DTT%XPAR_TC_ROOF    )
IF(ASSOCIATED(DTT%XPAR_D_ROOF     )) DEALLOCATE(DTT%XPAR_D_ROOF     )
IF(ASSOCIATED(DTT%XPAR_ALB_ROAD   )) DEALLOCATE(DTT%XPAR_ALB_ROAD   )
IF(ASSOCIATED(DTT%XPAR_EMIS_ROAD  )) DEALLOCATE(DTT%XPAR_EMIS_ROAD  )
IF(ASSOCIATED(DTT%XPAR_HC_ROAD    )) DEALLOCATE(DTT%XPAR_HC_ROAD    )
IF(ASSOCIATED(DTT%XPAR_TC_ROAD    )) DEALLOCATE(DTT%XPAR_TC_ROAD    )
IF(ASSOCIATED(DTT%XPAR_D_ROAD     )) DEALLOCATE(DTT%XPAR_D_ROAD     )
IF(ASSOCIATED(DTT%XPAR_ALB_WALL   )) DEALLOCATE(DTT%XPAR_ALB_WALL   )
IF(ASSOCIATED(DTT%XPAR_EMIS_WALL  )) DEALLOCATE(DTT%XPAR_EMIS_WALL  )
IF(ASSOCIATED(DTT%XPAR_HC_WALL    )) DEALLOCATE(DTT%XPAR_HC_WALL    )
IF(ASSOCIATED(DTT%XPAR_TC_WALL    )) DEALLOCATE(DTT%XPAR_TC_WALL    )
IF(ASSOCIATED(DTT%XPAR_D_WALL     )) DEALLOCATE(DTT%XPAR_D_WALL     )
IF(ASSOCIATED(DTT%XPAR_BLD_HEIGHT )) DEALLOCATE(DTT%XPAR_BLD_HEIGHT )
IF(ASSOCIATED(DTT%XPAR_WALL_O_HOR )) DEALLOCATE(DTT%XPAR_WALL_O_HOR )
IF(ASSOCIATED(DTT%XPAR_H_TRAFFIC  )) DEALLOCATE(DTT%XPAR_H_TRAFFIC  )
IF(ASSOCIATED(DTT%XPAR_LE_TRAFFIC )) DEALLOCATE(DTT%XPAR_LE_TRAFFIC )
IF(ASSOCIATED(DTT%XPAR_H_INDUSTRY )) DEALLOCATE(DTT%XPAR_H_INDUSTRY )
IF(ASSOCIATED(DTT%XPAR_LE_INDUSTRY)) DEALLOCATE(DTT%XPAR_LE_INDUSTRY)
IF(ASSOCIATED(DTT%XPAR_GARDEN     )) DEALLOCATE(DTT%XPAR_GARDEN     )
IF(ASSOCIATED(DTT%XPAR_ROAD_DIR   )) DEALLOCATE(DTT%XPAR_ROAD_DIR   )
IF(ASSOCIATED(DTT%NPAR_BLDTYPE    )) DEALLOCATE(DTT%NPAR_BLDTYPE    )
IF(ASSOCIATED(DTT%NPAR_IND_BLD_AGE)) DEALLOCATE(DTT%NPAR_IND_BLD_AGE)
IF(ASSOCIATED(DTT%NPAR_COL_BLD_AGE)) DEALLOCATE(DTT%NPAR_COL_BLD_AGE)
IF(ASSOCIATED(DTT%NPAR_BLDCODE    )) DEALLOCATE(DTT%NPAR_BLDCODE    )
IF(ASSOCIATED(DTT%NPAR_USETYPE    )) DEALLOCATE(DTT%NPAR_USETYPE    )
IF(ASSOCIATED(DTT%NPAR_P1TERRITORY)) DEALLOCATE(DTT%NPAR_P1TERRITORY)
IF(ASSOCIATED(DTT%NPAR_PXTERRITORY)) DEALLOCATE(DTT%NPAR_PXTERRITORY)
IF(ASSOCIATED(DTT%XPAR_FRACIHS    )) DEALLOCATE(DTT%XPAR_FRACIHS)
IF(ASSOCIATED(DTT%XPAR_FRACCHS    )) DEALLOCATE(DTT%XPAR_FRACCHS)
IF(ASSOCIATED(DTT%XPAR_FRACCOM    )) DEALLOCATE(DTT%XPAR_FRACCOM)
IF(ASSOCIATED(DTT%XPAR_FRACTER    )) DEALLOCATE(DTT%XPAR_FRACTER)
IF(ASSOCIATED(DTT%XPAR_FRACIND    )) DEALLOCATE(DTT%XPAR_FRACIND)
IF(ASSOCIATED(DTT%XPAR_FRACNHE    )) DEALLOCATE(DTT%XPAR_FRACNHE)
IF(ASSOCIATED(DTT%XPAR_FRACPAV    )) DEALLOCATE(DTT%XPAR_FRACPAV)
IF(ASSOCIATED(DTT%XPAR_FRACMRI    )) DEALLOCATE(DTT%XPAR_FRACMRI)
IF(ASSOCIATED(DTT%XPAR_FRACHRI    )) DEALLOCATE(DTT%XPAR_FRACHRI)
IF(ASSOCIATED(DTT%XPAR_FRACATB    )) DEALLOCATE(DTT%XPAR_FRACATB)
IF(ASSOCIATED(DTT%XPAR_FOEQI_MAIS )) DEALLOCATE(DTT%XPAR_FOEQI_MAIS)
IF(ASSOCIATED(DTT%XPAR_FOEQI_APPT )) DEALLOCATE(DTT%XPAR_FOEQI_APPT)
IF(ASSOCIATED(DTT%XPAR_FAEQI_MAIS )) DEALLOCATE(DTT%XPAR_FAEQI_MAIS)
IF(ASSOCIATED(DTT%XPAR_FAEQI_APPT )) DEALLOCATE(DTT%XPAR_FAEQI_APPT)
IF(ASSOCIATED(DTT%XPAR_CRE_MAIS   )) DEALLOCATE(DTT%XPAR_CRE_MAIS)
IF(ASSOCIATED(DTT%XPAR_CRE_APPT   )) DEALLOCATE(DTT%XPAR_CRE_APPT)
IF(ASSOCIATED(DTT%XPAR_NB_POP     )) DEALLOCATE(DTT%XPAR_NB_POP  )
IF(ASSOCIATED(DTT%XPAR_SFCO2_RD   )) DEALLOCATE(DTT%XPAR_SFCO2_RD)
IF(ASSOCIATED(DTT%XPAR_TIME_OF_CHANGE)) DEALLOCATE(DTT%XPAR_TIME_OF_CHANGE)
!
!-------------------------------------------------------------------------------------
!

!
IF(ASSOCIATED(DTT%XPAR_ROUGH_ROOF ))  DEALLOCATE(DTT%XPAR_ROUGH_ROOF)
IF(ASSOCIATED(DTT%XPAR_ROUGH_WALL ))  DEALLOCATE(DTT%XPAR_ROUGH_WALL)
!
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(DTB%XPAR_HC_FLOOR)) DEALLOCATE(DTB%XPAR_HC_FLOOR)
IF(ASSOCIATED(DTB%XPAR_TC_FLOOR)) DEALLOCATE(DTB%XPAR_TC_FLOOR)
IF(ASSOCIATED(DTB%XPAR_D_FLOOR)) DEALLOCATE(DTB%XPAR_D_FLOOR)
IF(ASSOCIATED(DTB%XPAR_HC_MASS)) DEALLOCATE(DTB%XPAR_HC_MASS)
IF(ASSOCIATED(DTB%XPAR_TC_MASS)) DEALLOCATE(DTB%XPAR_TC_MASS)
IF(ASSOCIATED(DTB%XPAR_D_MASS)) DEALLOCATE(DTB%XPAR_D_MASS)
IF(ASSOCIATED(DTB%XPAR_F_WASTE_CAN)) DEALLOCATE(DTB%XPAR_F_WASTE_CAN)
IF(ASSOCIATED(DTB%XPAR_QIN)) DEALLOCATE(DTB%XPAR_QIN)
IF(ASSOCIATED(DTB%XPAR_QIN_FRAD)) DEALLOCATE(DTB%XPAR_QIN_FRAD)
IF(ASSOCIATED(DTB%XPAR_MODQIN_VCD)) DEALLOCATE(DTB%XPAR_MODQIN_VCD)
IF(ASSOCIATED(DTB%XPAR_MODQIN_VLD)) DEALLOCATE(DTB%XPAR_MODQIN_VLD)
IF(ASSOCIATED(DTB%XPAR_MODQIN_NIG)) DEALLOCATE(DTB%XPAR_MODQIN_NIG)
IF(ASSOCIATED(DTB%XPAR_SHGC)) DEALLOCATE(DTB%XPAR_SHGC)
IF(ASSOCIATED(DTB%XPAR_U_WIN)) DEALLOCATE(DTB%XPAR_U_WIN)
IF(ASSOCIATED(DTB%XPAR_GR)) DEALLOCATE(DTB%XPAR_GR)
IF(ASSOCIATED(DTB%XPAR_SHGC_SH)) DEALLOCATE(DTB%XPAR_SHGC_SH)
IF(ASSOCIATED(DTB%XPAR_FLOOR_HEIGHT)) DEALLOCATE(DTB%XPAR_FLOOR_HEIGHT)
IF(ASSOCIATED(DTB%XPAR_N50)) DEALLOCATE(DTB%XPAR_N50)
IF(ASSOCIATED(DTB%XPAR_F_WATER_COND)) DEALLOCATE(DTB%XPAR_F_WATER_COND)
IF(ASSOCIATED(DTB%XPAR_QIN_FLAT)) DEALLOCATE(DTB%XPAR_QIN_FLAT)
IF(ASSOCIATED(DTB%XPAR_HR_TARGET)) DEALLOCATE(DTB%XPAR_HR_TARGET)
IF(ASSOCIATED(DTB%XPAR_CAP_SYS_HEAT)) DEALLOCATE(DTB%XPAR_CAP_SYS_HEAT)
IF(ASSOCIATED(DTB%XPAR_CAP_SYS_RAT)) DEALLOCATE(DTB%XPAR_CAP_SYS_RAT)
IF(ASSOCIATED(DTB%XPAR_T_ADP)) DEALLOCATE(DTB%XPAR_T_ADP)
IF(ASSOCIATED(DTB%XPAR_M_SYS_RAT)) DEALLOCATE(DTB%XPAR_M_SYS_RAT)
IF(ASSOCIATED(DTB%XPAR_COP_RAT)) DEALLOCATE(DTB%XPAR_COP_RAT)
IF(ASSOCIATED(DTB%XPAR_T_SIZE_MAX)) DEALLOCATE(DTB%XPAR_T_SIZE_MAX)
IF(ASSOCIATED(DTB%XPAR_T_SIZE_MIN)) DEALLOCATE(DTB%XPAR_T_SIZE_MIN)
IF(ASSOCIATED(DTB%XPAR_TCOOL_OCCD)) DEALLOCATE(DTB%XPAR_TCOOL_OCCD)
IF(ASSOCIATED(DTB%XPAR_TCOOL_OCCN)) DEALLOCATE(DTB%XPAR_TCOOL_OCCN)
IF(ASSOCIATED(DTB%XPAR_TCOOL_VCDD)) DEALLOCATE(DTB%XPAR_TCOOL_VCDD)
IF(ASSOCIATED(DTB%XPAR_TCOOL_VCDN)) DEALLOCATE(DTB%XPAR_TCOOL_VCDN)
IF(ASSOCIATED(DTB%XPAR_TCOOL_VCLD)) DEALLOCATE(DTB%XPAR_TCOOL_VCLD)
IF(ASSOCIATED(DTB%XPAR_THEAT_OCCD)) DEALLOCATE(DTB%XPAR_THEAT_OCCD)
IF(ASSOCIATED(DTB%XPAR_THEAT_OCCN)) DEALLOCATE(DTB%XPAR_THEAT_OCCN)
IF(ASSOCIATED(DTB%XPAR_THEAT_VCDD)) DEALLOCATE(DTB%XPAR_THEAT_VCDD)
IF(ASSOCIATED(DTB%XPAR_THEAT_VCDN)) DEALLOCATE(DTB%XPAR_THEAT_VCDN)
IF(ASSOCIATED(DTB%XPAR_THEAT_VCLD)) DEALLOCATE(DTB%XPAR_THEAT_VCLD)
IF(ASSOCIATED(DTB%XPAR_FRACOMP)) DEALLOCATE(DTB%XPAR_FRACOMP)
IF(ASSOCIATED(DTB%XPAR_RESIDENTIAL)) DEALLOCATE(DTB%XPAR_RESIDENTIAL)
IF(ASSOCIATED(DTB%XPAR_ISMECH)) DEALLOCATE(DTB%XPAR_ISMECH)
IF(ASSOCIATED(DTB%XPAR_MECHRATE)) DEALLOCATE(DTB%XPAR_MECHRATE)
IF(ASSOCIATED(DTB%XPAR_SHADEARCHI)) DEALLOCATE(DTB%XPAR_SHADEARCHI)
IF(ASSOCIATED(DTB%XPAR_NATVENT)) DEALLOCATE(DTB%XPAR_NATVENT)
IF(ASSOCIATED(DTB%XPAR_TDESV)) DEALLOCATE(DTB%XPAR_TDESV)
IF(ASSOCIATED(DTB%XPAR_WIN_SW_MAX)) DEALLOCATE(DTB%XPAR_WIN_SW_MAX)
IF(ASSOCIATED(DTB%XPAR_FOPEN)) DEALLOCATE(DTB%XPAR_FOPEN)
IF(ASSOCIATED(DTB%XPAR_FVSUM)) DEALLOCATE(DTB%XPAR_FVSUM)
IF(ASSOCIATED(DTB%XPAR_FVVAC)) DEALLOCATE(DTB%XPAR_FVVAC)
IF(ASSOCIATED(DTB%XPAR_FVNIG)) DEALLOCATE(DTB%XPAR_FVNIG)
IF(ASSOCIATED(DTB%XPAR_FSSUM)) DEALLOCATE(DTB%XPAR_FSSUM)
IF(ASSOCIATED(DTB%XPAR_FSVAC)) DEALLOCATE(DTB%XPAR_FSVAC)
IF(ASSOCIATED(DTB%XPAR_FSNIG)) DEALLOCATE(DTB%XPAR_FSNIG)
IF(ASSOCIATED(DTB%XPAR_DAYWBEG_SCHED)) DEALLOCATE(DTB%XPAR_DAYWBEG_SCHED)
IF(ASSOCIATED(DTB%XPAR_HOURBEG_SCHED)) DEALLOCATE(DTB%XPAR_HOURBEG_SCHED)
IF(ASSOCIATED(DTB%XPAR_PROBOCC)) DEALLOCATE(DTB%XPAR_PROBOCC)
IF(ASSOCIATED(DTB%XPAR_BEG_HOLIDAY)) DEALLOCATE(DTB%XPAR_BEG_HOLIDAY)
IF(ASSOCIATED(DTB%XPAR_END_HOLIDAY)) DEALLOCATE(DTB%XPAR_END_HOLIDAY)
IF(ASSOCIATED(DTB%XPAR_MOD_HOLIDAY)) DEALLOCATE(DTB%XPAR_MOD_HOLIDAY)
IF(ASSOCIATED(DTB%XPAR_FRAC_HEAT_ELEC)) DEALLOCATE(DTB%XPAR_FRAC_HEAT_ELEC)
IF(ASSOCIATED(DTB%XPAR_FRAC_HEAT_FUEL)) DEALLOCATE(DTB%XPAR_FRAC_HEAT_FUEL)
IF(ASSOCIATED(DTB%XPAR_FRAC_HEAT_GAS)) DEALLOCATE(DTB%XPAR_FRAC_HEAT_GAS)
IF(ASSOCIATED(DTB%XPAR_FRAC_HEAT_OTHER)) DEALLOCATE(DTB%XPAR_FRAC_HEAT_OTHER)
IF(ASSOCIATED(DTB%XPAR_HOTWAT)) DEALLOCATE(DTB%XPAR_HOTWAT)
IF(ASSOCIATED(DTB%XPAR_F_HW_GAS)) DEALLOCATE(DTB%XPAR_F_HW_GAS)
!
!
!-------------------------------------------------------------------------------------
!
IF(ALLOCATED(XDATA_TOWN)) DEALLOCATE(XDATA_TOWN)
IF(ALLOCATED(XDATA_GARDEN)) DEALLOCATE(XDATA_GARDEN)
IF(ALLOCATED(XDATA_NATURE)) DEALLOCATE(XDATA_NATURE)
IF(ALLOCATED(XDATA_WATER)) DEALLOCATE(XDATA_WATER)
IF(ALLOCATED(XDATA_SEA)) DEALLOCATE(XDATA_SEA)
IF(ALLOCATED(XDATA_LAI)) DEALLOCATE(XDATA_LAI)
IF(ALLOCATED(XDATA_LAI_ALL_YEARS)) DEALLOCATE(XDATA_LAI_ALL_YEARS)
IF(ALLOCATED(XDATA_VEGTYPE)) DEALLOCATE(XDATA_VEGTYPE)
IF(ALLOCATED(XDATA_H_TREE)) DEALLOCATE(XDATA_H_TREE)
IF(ALLOCATED(XDATA_GROUND_DEPTH)) DEALLOCATE(XDATA_GROUND_DEPTH)
IF(ALLOCATED(XDATA_ROOT_DEPTH)) DEALLOCATE(XDATA_ROOT_DEPTH)
IF(ALLOCATED(XDATA_ROOT_DEPTHGV)) DEALLOCATE(XDATA_ROOT_DEPTHGV)
IF(ALLOCATED(XDATA_DICE)) DEALLOCATE(XDATA_DICE)
IF(ALLOCATED(XDATA_ROOT_EXTINCTION)) DEALLOCATE(XDATA_ROOT_EXTINCTION)
IF(ALLOCATED(XDATA_ROOT_LIN)) DEALLOCATE(XDATA_ROOT_LIN)
IF(ALLOCATED(XDATA_ALBNIR_VEG)) DEALLOCATE(XDATA_ALBNIR_VEG)
IF(ALLOCATED(XDATA_ALBVIS_VEG)) DEALLOCATE(XDATA_ALBVIS_VEG)
IF(ALLOCATED(XDATA_ALBUV_VEG)) DEALLOCATE(XDATA_ALBUV_VEG)
IF(ALLOCATED(XDATA_ALB_VEG_VIS)) DEALLOCATE(XDATA_ALB_VEG_VIS)
IF(ALLOCATED(XDATA_ALB_VEG_NIR)) DEALLOCATE(XDATA_ALB_VEG_NIR)
IF(ALLOCATED(XDATA_ALB_SOIL_VIS)) DEALLOCATE(XDATA_ALB_SOIL_VIS)
IF(ALLOCATED(XDATA_ALB_SOIL_NIR)) DEALLOCATE(XDATA_ALB_SOIL_NIR)
IF(ALLOCATED(XDATA_RSMIN)) DEALLOCATE(XDATA_RSMIN)
IF(ALLOCATED(XDATA_GAMMA)) DEALLOCATE(XDATA_GAMMA)
IF(ALLOCATED(XDATA_WRMAX_CF)) DEALLOCATE(XDATA_WRMAX_CF)
IF(ALLOCATED(XDATA_RGL)) DEALLOCATE(XDATA_RGL)
IF(ALLOCATED(XDATA_CV)) DEALLOCATE(XDATA_CV)
IF(ALLOCATED(XDATA_GMES)) DEALLOCATE(XDATA_GMES)
IF(ALLOCATED(XDATA_GMES_ST)) DEALLOCATE(XDATA_GMES_ST)
IF(ALLOCATED(XDATA_RE25)) DEALLOCATE(XDATA_RE25)
IF(ALLOCATED(XDATA_GC)) DEALLOCATE(XDATA_GC)
IF(ALLOCATED(XDATA_GC_ST)) DEALLOCATE(XDATA_GC_ST)
IF(ALLOCATED(XDATA_F2I)) DEALLOCATE(XDATA_F2I)
IF(ALLOCATED(XDATA_BSLAI)) DEALLOCATE(XDATA_BSLAI)
IF(ALLOCATED(XDATA_BSLAI_ST)) DEALLOCATE(XDATA_BSLAI_ST)
IF(ALLOCATED(XDATA_DMAX)) DEALLOCATE(XDATA_DMAX)
IF(ALLOCATED(XDATA_DMAX_ST)) DEALLOCATE(XDATA_DMAX_ST)
IF(ALLOCATED(XDATA_STRESS)) DEALLOCATE(XDATA_STRESS)
IF(ALLOCATED(XDATA_SEFOLD)) DEALLOCATE(XDATA_SEFOLD)
IF(ALLOCATED(XDATA_SEFOLD_ST)) DEALLOCATE(XDATA_SEFOLD_ST)
IF(ALLOCATED(XDATA_LAIMIN)) DEALLOCATE(XDATA_LAIMIN)
IF(ALLOCATED(XDATA_VEG)) DEALLOCATE(XDATA_VEG)
IF(ALLOCATED(XDATA_GREEN)) DEALLOCATE(XDATA_GREEN)
IF(ALLOCATED(XDATA_Z0)) DEALLOCATE(XDATA_Z0)
IF(ALLOCATED(XDATA_Z0_O_Z0H)) DEALLOCATE(XDATA_Z0_O_Z0H)
IF(ALLOCATED(XDATA_EMIS_ECO)) DEALLOCATE(XDATA_EMIS_ECO)
IF(ALLOCATED(XDATA_SOILRC_SO2)) DEALLOCATE(XDATA_SOILRC_SO2)
IF(ALLOCATED(XDATA_SOILRC_O3)) DEALLOCATE(XDATA_SOILRC_O3)
IF(ALLOCATED(XDATA_CE_NITRO)) DEALLOCATE(XDATA_CE_NITRO)
IF(ALLOCATED(XDATA_CF_NITRO)) DEALLOCATE(XDATA_CF_NITRO)
IF(ALLOCATED(XDATA_CNA_NITRO)) DEALLOCATE(XDATA_CNA_NITRO)
IF(ALLOCATED(XDATA_IRRIG)) DEALLOCATE(XDATA_IRRIG)
IF(ALLOCATED(XDATA_WATSUP)) DEALLOCATE(XDATA_WATSUP)
IF(ALLOCATED(XDATA_RGLGV)) DEALLOCATE(XDATA_RGLGV)
IF(ALLOCATED(XDATA_GAMMAGV)) DEALLOCATE(XDATA_GAMMAGV)
IF(ALLOCATED(XDATA_RSMINGV)) DEALLOCATE(XDATA_RSMINGV)
IF(ALLOCATED(XDATA_ROOT_EXTINCTIONGV)) DEALLOCATE(XDATA_ROOT_EXTINCTIONGV)
IF(ALLOCATED(XDATA_WRMAX_CFGV)) DEALLOCATE(XDATA_WRMAX_CFGV)
IF(ALLOCATED(XDATA_LAIGV)) DEALLOCATE(XDATA_LAIGV)
IF(ALLOCATED(XDATA_GNDLITTER)) DEALLOCATE(XDATA_GNDLITTER)
IF(ALLOCATED(XDATA_Z0LITTER)) DEALLOCATE(XDATA_Z0LITTER)
IF(ALLOCATED(XDATA_H_VEG)) DEALLOCATE(XDATA_H_VEG)
IF(ALLOCATED(XDATA_Z0_TOWN)) DEALLOCATE(XDATA_Z0_TOWN)
IF(ALLOCATED(XDATA_ALB_ROOF)) DEALLOCATE(XDATA_ALB_ROOF)
IF(ALLOCATED(XDATA_ALB_ROAD)) DEALLOCATE(XDATA_ALB_ROAD)
IF(ALLOCATED(XDATA_ALB_WALL)) DEALLOCATE(XDATA_ALB_WALL)
IF(ALLOCATED(XDATA_EMIS_ROOF)) DEALLOCATE(XDATA_EMIS_ROOF)
IF(ALLOCATED(XDATA_EMIS_ROAD)) DEALLOCATE(XDATA_EMIS_ROAD)
IF(ALLOCATED(XDATA_EMIS_WALL)) DEALLOCATE(XDATA_EMIS_WALL)
IF(ALLOCATED(XDATA_HC_ROOF)) DEALLOCATE(XDATA_HC_ROOF)
IF(ALLOCATED(XDATA_HC_ROAD)) DEALLOCATE(XDATA_HC_ROAD)
IF(ALLOCATED(XDATA_HC_WALL)) DEALLOCATE(XDATA_HC_WALL)
IF(ALLOCATED(XDATA_HC_FLOOR)) DEALLOCATE(XDATA_HC_FLOOR)
IF(ALLOCATED(XDATA_HC_MASS)) DEALLOCATE(XDATA_HC_MASS)
IF(ALLOCATED(XDATA_TC_ROOF)) DEALLOCATE(XDATA_TC_ROOF)
IF(ALLOCATED(XDATA_TC_ROAD)) DEALLOCATE(XDATA_TC_ROAD)
IF(ALLOCATED(XDATA_TC_WALL)) DEALLOCATE(XDATA_TC_WALL)
IF(ALLOCATED(XDATA_TC_FLOOR)) DEALLOCATE(XDATA_TC_FLOOR)
IF(ALLOCATED(XDATA_TC_MASS)) DEALLOCATE(XDATA_TC_MASS)
IF(ALLOCATED(XDATA_D_ROOF)) DEALLOCATE(XDATA_D_ROOF)
IF(ALLOCATED(XDATA_D_ROAD)) DEALLOCATE(XDATA_D_ROAD)
IF(ALLOCATED(XDATA_D_WALL)) DEALLOCATE(XDATA_D_WALL)
IF(ALLOCATED(XDATA_D_FLOOR)) DEALLOCATE(XDATA_D_FLOOR)
IF(ALLOCATED(XDATA_D_MASS)) DEALLOCATE(XDATA_D_MASS)
IF(ALLOCATED(XDATA_BLD_HEIGHT)) DEALLOCATE(XDATA_BLD_HEIGHT)
IF(ALLOCATED(XDATA_WALL_O_HOR)) DEALLOCATE(XDATA_WALL_O_HOR)
IF(ALLOCATED(XDATA_BLD)) DEALLOCATE(XDATA_BLD)
IF(ALLOCATED(XDATA_CAN_HW_RATIO)) DEALLOCATE(XDATA_CAN_HW_RATIO)
IF(ALLOCATED(XDATA_H_TRAFFIC)) DEALLOCATE(XDATA_H_TRAFFIC)
IF(ALLOCATED(XDATA_LE_TRAFFIC)) DEALLOCATE(XDATA_LE_TRAFFIC)
IF(ALLOCATED(XDATA_H_INDUSTRY)) DEALLOCATE(XDATA_H_INDUSTRY)
IF(ALLOCATED(XDATA_LE_INDUSTRY)) DEALLOCATE(XDATA_LE_INDUSTRY)
IF(ALLOCATED(XDATA_F_WASTE_CAN)) DEALLOCATE(XDATA_F_WASTE_CAN)
IF(ALLOCATED(XDATA_QIN)) DEALLOCATE(XDATA_QIN)
IF(ALLOCATED(XDATA_QIN_FRAD)) DEALLOCATE(XDATA_QIN_FRAD)
IF(ALLOCATED(XDATA_SHGC)) DEALLOCATE(XDATA_SHGC)
IF(ALLOCATED(XDATA_U_WIN)) DEALLOCATE(XDATA_U_WIN)
IF(ALLOCATED(XDATA_GR)) DEALLOCATE(XDATA_GR)
IF(ALLOCATED(XDATA_SHGC_SH)) DEALLOCATE(XDATA_SHGC_SH)
IF(ALLOCATED(XDATA_FLOOR_HEIGHT)) DEALLOCATE(XDATA_FLOOR_HEIGHT)
IF(ALLOCATED(XDATA_ISMASS)) DEALLOCATE(XDATA_ISMASS)
IF(ALLOCATED(XDATA_N50)) DEALLOCATE(XDATA_N50)
IF(ALLOCATED(XDATA_F_WATER_COND)) DEALLOCATE(XDATA_F_WATER_COND)
IF(ALLOCATED(XDATA_QIN_FLAT)) DEALLOCATE(XDATA_QIN_FLAT)
IF(ALLOCATED(XDATA_HR_TARGET)) DEALLOCATE(XDATA_HR_TARGET)
IF(ALLOCATED(XDATA_CAP_SYS_HEAT)) DEALLOCATE(XDATA_CAP_SYS_HEAT)
IF(ALLOCATED(XDATA_CAP_SYS_RAT)) DEALLOCATE(XDATA_CAP_SYS_RAT)
IF(ALLOCATED(XDATA_T_ADP)) DEALLOCATE(XDATA_T_ADP)
IF(ALLOCATED(XDATA_M_SYS_RAT)) DEALLOCATE(XDATA_M_SYS_RAT)
IF(ALLOCATED(XDATA_COP_RAT)) DEALLOCATE(XDATA_COP_RAT)
IF(ALLOCATED(XDATA_T_SIZE_MAX)) DEALLOCATE(XDATA_T_SIZE_MAX)
IF(ALLOCATED(XDATA_T_SIZE_MIN)) DEALLOCATE(XDATA_T_SIZE_MIN)
IF(ALLOCATED(XDATA_ISMECH)) DEALLOCATE(XDATA_ISMECH)
IF(ALLOCATED(XDATA_MECHRATE)) DEALLOCATE(XDATA_MECHRATE)
IF(ALLOCATED(XDATA_SHADEARCHI)) DEALLOCATE(XDATA_SHADEARCHI)
IF(ALLOCATED(XDATA_NATVENT)) DEALLOCATE(XDATA_NATVENT)
IF(ALLOCATED(XDATA_ROUGH_ROOF)) DEALLOCATE(XDATA_ROUGH_ROOF)
IF(ALLOCATED(XDATA_ROUGH_WALL)) DEALLOCATE(XDATA_ROUGH_WALL)
IF(ALLOCATED(XDATA_FRAC_GR)) DEALLOCATE(XDATA_FRAC_GR)
IF(ALLOCATED(XDATA_FRAC_HVEG)) DEALLOCATE(XDATA_FRAC_HVEG)
IF(ALLOCATED(XDATA_EMIS_PANEL)) DEALLOCATE(XDATA_EMIS_PANEL)
IF(ALLOCATED(XDATA_ALB_PANEL)) DEALLOCATE(XDATA_ALB_PANEL)
IF(ALLOCATED(XDATA_EFF_PANEL)) DEALLOCATE(XDATA_EFF_PANEL)
IF(ALLOCATED(XDATA_FRAC_PANEL)) DEALLOCATE(XDATA_FRAC_PANEL)
IF(ALLOCATED(XDATA_THEAT_OCCD)) DEALLOCATE(XDATA_THEAT_OCCD)
IF(ALLOCATED(XDATA_THEAT_OCCN)) DEALLOCATE(XDATA_THEAT_OCCN)
IF(ALLOCATED(XDATA_THEAT_VCDD)) DEALLOCATE(XDATA_THEAT_VCDD)
IF(ALLOCATED(XDATA_THEAT_VCDN)) DEALLOCATE(XDATA_THEAT_VCDN)
IF(ALLOCATED(XDATA_THEAT_VCLD)) DEALLOCATE(XDATA_THEAT_VCLD)
IF(ALLOCATED(XDATA_TCOOL_OCCD)) DEALLOCATE(XDATA_TCOOL_OCCD)
IF(ALLOCATED(XDATA_TCOOL_OCCN)) DEALLOCATE(XDATA_TCOOL_OCCN)
IF(ALLOCATED(XDATA_TCOOL_VCDD)) DEALLOCATE(XDATA_TCOOL_VCDD)
IF(ALLOCATED(XDATA_TCOOL_VCDN)) DEALLOCATE(XDATA_TCOOL_VCDN)
IF(ALLOCATED(XDATA_TCOOL_VCLD)) DEALLOCATE(XDATA_TCOOL_VCLD)
IF(ALLOCATED(XDATA_FVSUM)) DEALLOCATE(XDATA_FVSUM)
IF(ALLOCATED(XDATA_FVVAC)) DEALLOCATE(XDATA_FVVAC)
IF(ALLOCATED(XDATA_FSSUM)) DEALLOCATE(XDATA_FSSUM)
IF(ALLOCATED(XDATA_FSVAC)) DEALLOCATE(XDATA_FSVAC)
IF(ALLOCATED(XDATA_FVNIG)) DEALLOCATE(XDATA_FVNIG)
IF(ALLOCATED(XDATA_FSNIG)) DEALLOCATE(XDATA_FSNIG)
IF(ALLOCATED(XDATA_PROBOCC)) DEALLOCATE(XDATA_PROBOCC)
IF(ALLOCATED(XDATA_FRAC_HEAT_ELEC)) DEALLOCATE(XDATA_FRAC_HEAT_ELEC)
IF(ALLOCATED(XDATA_FRAC_HEAT_GAS)) DEALLOCATE(XDATA_FRAC_HEAT_GAS)
IF(ALLOCATED(XDATA_FRAC_HEAT_FUEL)) DEALLOCATE(XDATA_FRAC_HEAT_FUEL)
IF(ALLOCATED(XDATA_FRAC_HEAT_OTHER)) DEALLOCATE(XDATA_FRAC_HEAT_OTHER)
IF(ALLOCATED(XDATA_FRACOMP)) DEALLOCATE(XDATA_FRACOMP)
IF(ALLOCATED(XDATA_NB_POP)) DEALLOCATE(XDATA_NB_POP)
IF(ALLOCATED(XDATA_SFCO2_RD)) DEALLOCATE(XDATA_SFCO2_RD)
IF(ALLOCATED(XDATA_HOTWAT)) DEALLOCATE(XDATA_HOTWAT)
IF(ALLOCATED(XDATA_F_HW_GAS)) DEALLOCATE(XDATA_F_HW_GAS)
!
!-------------------------------------------------------------------------------------
IF(ASSOCIATED(DGT%XRI)) DEALLOCATE(DGT%XRI)
IF(ASSOCIATED(DGT%XCD)) DEALLOCATE(DGT%XCD)
IF(ASSOCIATED(DGT%XCH)) DEALLOCATE(DGT%XCH)
IF(ASSOCIATED(DGT%XCE)) DEALLOCATE(DGT%XCE)
IF(ASSOCIATED(DGT%XZ0)) DEALLOCATE(DGT%XZ0)
IF(ASSOCIATED(DGT%XZ0H)) DEALLOCATE(DGT%XZ0H)
IF(ASSOCIATED(DGT%XRN)) DEALLOCATE(DGT%XRN)
IF(ASSOCIATED(DGT%XH)) DEALLOCATE(DGT%XH)
IF(ASSOCIATED(DGT%XLE)) DEALLOCATE(DGT%XLE)
IF(ASSOCIATED(DGT%XGFLUX)) DEALLOCATE(DGT%XGFLUX)
IF(ASSOCIATED(DGT%XQF)) DEALLOCATE(DGT%XQF)
IF(ASSOCIATED(DGT%XT2M)) DEALLOCATE(DGT%XT2M)
IF(ASSOCIATED(DGT%XT2M_MIN)) DEALLOCATE(DGT%XT2M_MIN)
IF(ASSOCIATED(DGT%XT2M_MAX)) DEALLOCATE(DGT%XT2M_MAX)
IF(ASSOCIATED(DGT%XQ2M)) DEALLOCATE(DGT%XQ2M)
IF(ASSOCIATED(DGT%XHU2M)) DEALLOCATE(DGT%XHU2M)
IF(ASSOCIATED(DGT%XHU2M_MIN)) DEALLOCATE(DGT%XHU2M_MIN)
IF(ASSOCIATED(DGT%XHU2M_MAX)) DEALLOCATE(DGT%XHU2M_MAX)
IF(ASSOCIATED(DGT%XQS)) DEALLOCATE(DGT%XQS)
IF(ASSOCIATED(DGT%XZON10M)) DEALLOCATE(DGT%XZON10M)
IF(ASSOCIATED(DGT%XMER10M)) DEALLOCATE(DGT%XMER10M)
IF(ASSOCIATED(DGT%XWIND10M)) DEALLOCATE(DGT%XWIND10M)
IF(ASSOCIATED(DGT%XWIND10M_MAX)) DEALLOCATE(DGT%XWIND10M_MAX)
IF(ASSOCIATED(DGT%XSFCO2)) DEALLOCATE(DGT%XSFCO2)
IF(ASSOCIATED(DGT%XLWD)) DEALLOCATE(DGT%XLWD)
IF(ASSOCIATED(DGT%XLWU)) DEALLOCATE(DGT%XLWU)
IF(ASSOCIATED(DGT%XSWD)) DEALLOCATE(DGT%XSWD)
IF(ASSOCIATED(DGT%XSWU)) DEALLOCATE(DGT%XSWU)
IF(ASSOCIATED(DGT%XSWBD)) DEALLOCATE(DGT%XSWBD)
IF(ASSOCIATED(DGT%XSWBU)) DEALLOCATE(DGT%XSWBU)
IF(ASSOCIATED(DGT%XFMU)) DEALLOCATE(DGT%XFMU)
IF(ASSOCIATED(DGT%XFMV)) DEALLOCATE(DGT%XFMV)
IF(ASSOCIATED(DGT%XDIAG_TS)) DEALLOCATE(DGT%XDIAG_TS)
!
IF (LHOOK) CALL DR_HOOK('DEALLOC_TEB_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DEALLOC_TEB_n


