!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #################################################################################
SUBROUTINE DEALLOC_SURF_ATM_n (YSC)
!     #################################################################################
!
!!****  *DEALLOC_SURF_ATM_n * - Deallocate all arrays
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!
!!      M. Goret    02/2017  add DTB and DGT as DEALLOC_TOWN_n arg.
!!------------------------------------------------------------------
!
USE MODD_SURFEX_n, ONLY : SURFEX_t
!
USE MODI_DEALLOC_SEA_n
USE MODI_DEALLOC_INLAND_WATER_n
USE MODI_DEALLOC_NATURE_n
USE MODI_DEALLOC_TOWN_n
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
!*      0.2    declarations of local variables
!
!-------------------------------------------------------------------------------------
!
TYPE(SURFEX_t), INTENT(INOUT) :: YSC
!
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('DEALLOC_SURF_ATM_N',0,ZHOOK_HANDLE)
IF (ASSOCIATED(YSC%U%XNATURE)) DEALLOCATE(YSC%U%XNATURE)
IF (ASSOCIATED(YSC%U%XTOWN  )) DEALLOCATE(YSC%U%XTOWN  )
IF (ASSOCIATED(YSC%U%XWATER )) DEALLOCATE(YSC%U%XWATER )
IF (ASSOCIATED(YSC%U%XSEA   )) DEALLOCATE(YSC%U%XSEA   )
!
IF (ASSOCIATED(YSC%U%LCOVER )) DEALLOCATE(YSC%U%LCOVER )
IF (ASSOCIATED(YSC%U%XCOVER )) DEALLOCATE(YSC%U%XCOVER )
IF (ASSOCIATED(YSC%U%XZS    )) DEALLOCATE(YSC%U%XZS    )
!
IF (ASSOCIATED(YSC%U%NR_NATURE)) DEALLOCATE(YSC%U%NR_NATURE)
IF (ASSOCIATED(YSC%U%NR_TOWN  )) DEALLOCATE(YSC%U%NR_TOWN  )
IF (ASSOCIATED(YSC%U%NR_WATER )) DEALLOCATE(YSC%U%NR_WATER )
IF (ASSOCIATED(YSC%U%NR_SEA   )) DEALLOCATE(YSC%U%NR_SEA   )
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(YSC%UG%XGRID_PAR )) DEALLOCATE(YSC%UG%XGRID_PAR )
IF (ASSOCIATED(YSC%UG%XLAT      )) DEALLOCATE(YSC%UG%XLAT      )
IF (ASSOCIATED(YSC%UG%XLON      )) DEALLOCATE(YSC%UG%XLON      )
IF (ASSOCIATED(YSC%UG%XMESH_SIZE)) DEALLOCATE(YSC%UG%XMESH_SIZE)
IF (ASSOCIATED(YSC%UG%XJPDIR    )) DEALLOCATE(YSC%UG%XJPDIR    )
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(YSC%USS%XAOSIP))     DEALLOCATE(YSC% USS%XAOSIP)
IF (ASSOCIATED(YSC%USS%XAOSIM))     DEALLOCATE(YSC% USS%XAOSIM)
IF (ASSOCIATED(YSC%USS%XAOSJP))     DEALLOCATE(YSC% USS%XAOSJP)
IF (ASSOCIATED(YSC%USS%XAOSJM))     DEALLOCATE(YSC% USS%XAOSJM)
IF (ASSOCIATED(YSC%USS%XHO2IP))     DEALLOCATE(YSC% USS%XHO2IP)
IF (ASSOCIATED(YSC%USS%XHO2IM))     DEALLOCATE(YSC% USS%XHO2IM)
IF (ASSOCIATED(YSC%USS%XHO2JP))     DEALLOCATE(YSC% USS%XHO2JP)
IF (ASSOCIATED(YSC%USS%XHO2JM))     DEALLOCATE(YSC% USS%XHO2JM)
IF (ASSOCIATED(YSC%USS%XZ0REL))     DEALLOCATE(YSC% USS%XZ0REL)
IF (ASSOCIATED(YSC%USS%XSSO_SLOPE)) DEALLOCATE(YSC% USS%XSSO_SLOPE)
IF (ASSOCIATED(YSC%USS%XSSO_ANIS))  DEALLOCATE(YSC% USS%XSSO_ANIS)
IF (ASSOCIATED(YSC%USS%XSSO_DIR))   DEALLOCATE(YSC% USS%XSSO_DIR)
IF (ASSOCIATED(YSC%USS%XSSO_STDEV)) DEALLOCATE(YSC% USS%XSSO_STDEV)
IF (ASSOCIATED(YSC%USS%XAVG_ZS))    DEALLOCATE(YSC% USS%XAVG_ZS)
IF (ASSOCIATED(YSC%USS%XSIL_ZS))    DEALLOCATE(YSC% USS%XSIL_ZS)
IF (ASSOCIATED(YSC%USS%XMAX_ZS))    DEALLOCATE(YSC% USS%XMAX_ZS)
IF (ASSOCIATED(YSC%USS%XMIN_ZS))    DEALLOCATE(YSC% USS%XMIN_ZS)
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(YSC%CHE%CEMIS_AREA))   DEALLOCATE(YSC%CHE%CEMIS_AREA)
IF (ASSOCIATED(YSC%CHE%CEMIS_COMMENT))DEALLOCATE(YSC%CHE%CEMIS_COMMENT)
IF (ASSOCIATED(YSC%CHE%CEMIS_NAME))   DEALLOCATE(YSC%CHE%CEMIS_NAME)
IF (ASSOCIATED(YSC%CHE%NEMIS_TIME))   DEALLOCATE(YSC%CHE%NEMIS_TIME)
IF (ASSOCIATED(YSC%CHE%XEMIS_FIELDS)) DEALLOCATE(YSC%CHE%XEMIS_FIELDS)
IF (ASSOCIATED(YSC%CHE%TSEMISS))      DEALLOCATE(YSC%CHE%TSEMISS)
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(YSC%DUU%XDUMMY_FIELDS)) DEALLOCATE(YSC% DUU%XDUMMY_FIELDS)
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(YSC%SV%CSV)) DEALLOCATE(YSC%SV%CSV)
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(YSC%CHU%CCH_NAMES))  DEALLOCATE(YSC%CHU%CCH_NAMES)
IF (ASSOCIATED(YSC%CHE%CEMIS_NAME)) DEALLOCATE(YSC%CHE%CEMIS_NAME)
IF (ASSOCIATED(YSC%CHE%CEMIS_AREA)) DEALLOCATE(YSC%CHE%CEMIS_AREA)
IF (ASSOCIATED(YSC%CHE%NEMIS_TIME)) DEALLOCATE(YSC%CHE%NEMIS_TIME )
IF (ASSOCIATED(YSC%CHE%TSEMISS))    DEALLOCATE(YSC%CHE%TSEMISS)
!
!-------------------------------------------------------------------------------------
!
IF (YSC%U%NDIM_SEA    >0) CALL DEALLOC_SEA_n(YSC%SM%CHS, YSC%SM%SG, YSC%SM%S, YSC%U)
IF (YSC%U%NDIM_WATER  >0) CALL DEALLOC_INLAND_WATER_n(YSC%FM%CHF, YSC%WM%CHW, YSC%FM%FG, YSC%FM%F, YSC%U, YSC%WM%WG, YSC%WM%W)
IF (YSC%U%NDIM_NATURE >0) CALL DEALLOC_NATURE_n(YSC%IM%CHI, YSC%IM%DTI, YSC%IM%GB, YSC%IM%IG, YSC%IM%I, YSC%U)
IF (YSC%U%NDIM_TOWN   >0) CALL DEALLOC_TOWN_n(YSC%GDM, YSC%GRM, YSC%HM, YSC%TM, YSC%U) 
!IF (YSC%U%NDIM_TOWN   >0) CALL DEALLOC_TOWN_n(YSC%TM%B, YSC%TM%CHT,YSC%TM%DGT, YSC%TM%DTB,YSC%TM%DTT, YSC%U, YSC%TM%TG, &
!                                              YSC%TM%T, YSC%TM%TOP, YSC%TM%TPN)
IF (LHOOK) CALL DR_HOOK('DEALLOC_SURF_ATM_N',1,ZHOOK_HANDLE)
!
!--------------------------------------------------------------------------------------
!
END SUBROUTINE DEALLOC_SURF_ATM_n
