!     #################################################################################
SUBROUTINE DEALLOC_MISC_TEB_n (B,DGCT,DGMT,T)
!     #################################################################################
!
!!****  *DEALLOC_MISC_TEB_n * - Deallocate all arrays for the current teb patch
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     M. Goret
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    07/2017
!!------------------------------------------------------------------
!
USE MODD_BEM_n, ONLY : BEM_t
USE MODD_DIAG_CUMUL_TEB_n, ONLY : DIAG_CUMUL_TEB_t
USE MODD_DIAG_MISC_TEB_n, ONLY : DIAG_MISC_TEB_t
USE MODD_TEB_n, ONLY : TEB_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
!*      0.2    declarations of local variables
!
!-------------------------------------------------------------------------------------
!

TYPE(BEM_t),            INTENT(INOUT) :: B
TYPE(DIAG_CUMUL_TEB_t), INTENT(INOUT) :: DGCT
TYPE(DIAG_MISC_TEB_t),  INTENT(INOUT) :: DGMT
TYPE(TEB_t),            INTENT(INOUT) :: T
!
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('DEALLOC_MISC_TEB_N',0,ZHOOK_HANDLE)
!
!################      B       #####################
!
!
IF(ASSOCIATED(B%CUR%XHC_FLOOR   ))  DEALLOCATE(B%CUR%XHC_FLOOR   )
IF(ASSOCIATED(B%CUR%XTC_FLOOR   ))  DEALLOCATE(B%CUR%XTC_FLOOR   )
IF(ASSOCIATED(B%CUR%XD_FLOOR    ))  DEALLOCATE(B%CUR%XD_FLOOR    )
!
IF(ASSOCIATED(B%CUR%XHC_MASS   ))  DEALLOCATE(B%CUR%XHC_MASS   )
IF(ASSOCIATED(B%CUR%XTC_MASS   ))  DEALLOCATE(B%CUR%XTC_MASS   )
IF(ASSOCIATED(B%CUR%XD_MASS    ))  DEALLOCATE(B%CUR%XD_MASS    )
!
IF(ASSOCIATED(B%CUR%XF_WASTE_CAN))  DEALLOCATE(B%CUR%XF_WASTE_CAN)
IF(ASSOCIATED(B%CUR%XQIN        ))  DEALLOCATE(B%CUR%XQIN        )
IF(ASSOCIATED(B%CUR%XQIN_FRAD   ))  DEALLOCATE(B%CUR%XQIN_FRAD   )
IF(ASSOCIATED(B%CUR%XSHGC       ))  DEALLOCATE(B%CUR%XSHGC       )
IF(ASSOCIATED(B%CUR%XU_WIN      ))  DEALLOCATE(B%CUR%XU_WIN      )
IF(ASSOCIATED(B%CUR%XTRAN_WIN   ))  DEALLOCATE(B%CUR%XTRAN_WIN   )
IF(ASSOCIATED(B%CUR%XGR         ))  DEALLOCATE(B%CUR%XGR         )
IF(ASSOCIATED(B%CUR%XFLOOR_HEIGHT)) DEALLOCATE(B%CUR%XFLOOR_HEIGHT)
IF(ASSOCIATED(B%CUR%XN50        ))  DEALLOCATE(B%CUR%XN50        )
!
IF(ASSOCIATED(B%CUR%XQIN_FLAT   ))  DEALLOCATE(B%CUR%XQIN_FLAT   )
IF(ASSOCIATED(B%CUR%XHR_TARGET  ))  DEALLOCATE(B%CUR%XHR_TARGET  )
IF(ASSOCIATED(B%CUR%XCAP_SYS_HEAT)) DEALLOCATE(B%CUR%XCAP_SYS_HEAT)
IF(ASSOCIATED(B%CUR%XCAP_SYS_RAT))  DEALLOCATE(B%CUR%XCAP_SYS_RAT)
IF(ASSOCIATED(B%CUR%XT_ADP      ))  DEALLOCATE(B%CUR%XT_ADP      )
IF(ASSOCIATED(B%CUR%XM_SYS_RAT  ))  DEALLOCATE(B%CUR%XM_SYS_RAT  )
IF(ASSOCIATED(B%CUR%XCOP_RAT    ))  DEALLOCATE(B%CUR%XCOP_RAT    )
IF(ASSOCIATED(B%CUR%XT_SIZE_MAX ))  DEALLOCATE(B%CUR%XT_SIZE_MAX )
IF(ASSOCIATED(B%CUR%XT_SIZE_MIN ))  DEALLOCATE(B%CUR%XT_SIZE_MIN )

IF(ASSOCIATED(B%CUR%XMODQIN_VCD))  DEALLOCATE(B%CUR%XMODQIN_VCD)
IF(ASSOCIATED(B%CUR%XMODQIN_VLD))  DEALLOCATE(B%CUR%XMODQIN_VLD)
IF(ASSOCIATED(B%CUR%XMODQIN_NIG))  DEALLOCATE(B%CUR%XMODQIN_NIG)
IF(ASSOCIATED(B%CUR%XFVSUM))  DEALLOCATE(B%CUR%XFVSUM)
IF(ASSOCIATED(B%CUR%XFVNIG))  DEALLOCATE(B%CUR%XFVNIG)
IF(ASSOCIATED(B%CUR%XTDESV))  DEALLOCATE(B%CUR%XTDESV)
IF(ASSOCIATED(B%CUR%XFVVAC))  DEALLOCATE(B%CUR%XFVVAC)
IF(ASSOCIATED(B%CUR%XFOPEN))  DEALLOCATE(B%CUR%XFOPEN)
IF(ASSOCIATED(B%CUR%XFSSUM))  DEALLOCATE(B%CUR%XFSSUM)
IF(ASSOCIATED(B%CUR%XFSNIG))  DEALLOCATE(B%CUR%XFSNIG)
IF(ASSOCIATED(B%CUR%XFSVAC))  DEALLOCATE(B%CUR%XFSVAC)
IF(ASSOCIATED(B%CUR%XWIN_SW_MAX))  DEALLOCATE(B%CUR%XWIN_SW_MAX)
IF(ASSOCIATED(B%CUR%XDAYWBEG_SCHED))  DEALLOCATE(B%CUR%XDAYWBEG_SCHED)
IF(ASSOCIATED(B%CUR%XHOURBEG_SCHED))  DEALLOCATE(B%CUR%XHOURBEG_SCHED)
IF(ASSOCIATED(B%CUR%XBEG_HOLIDAY))  DEALLOCATE(B%CUR%XBEG_HOLIDAY)
IF(ASSOCIATED(B%CUR%XEND_HOLIDAY))  DEALLOCATE(B%CUR%XEND_HOLIDAY)
IF(ASSOCIATED(B%CUR%XMOD_HOLIDAY))  DEALLOCATE(B%CUR%XMOD_HOLIDAY)
IF(ASSOCIATED(B%CUR%XPROBOCC))  DEALLOCATE(B%CUR%XPROBOCC)
IF(ASSOCIATED(B%CUR%XF_WASTE_CAN))  DEALLOCATE(B%CUR%XF_WASTE_CAN)
!
IF(ASSOCIATED(B%CUR%XABS_WIN    ))  DEALLOCATE(B%CUR%XABS_WIN    )
IF(ASSOCIATED(B%CUR%XALB_WIN    ))  DEALLOCATE(B%CUR%XALB_WIN    )
IF(ASSOCIATED(B%CUR%XUGG_WIN    ))  DEALLOCATE(B%CUR%XUGG_WIN    )
IF(ASSOCIATED(B%CUR%XSHADEARCHI ))  DEALLOCATE(B%CUR%XSHADEARCHI )
!
IF(ASSOCIATED(B%CUR%XISMECH ))      DEALLOCATE(B%CUR%XISMECH)
IF(ASSOCIATED(B%CUR%XMECHRATE ))    DEALLOCATE(B%CUR%XMECHRATE)
IF(ASSOCIATED(B%CUR%XF_WATER_COND)) DEALLOCATE(B%CUR%XF_WATER_COND)
IF(ASSOCIATED(B%CUR%XSHGC_SH    ))  DEALLOCATE(B%CUR%XSHGC_SH)

IF(ASSOCIATED(B%CUR%XN_FLOOR ))  DEALLOCATE(B%CUR%XN_FLOOR)
IF(ASSOCIATED(B%CUR%XGLAZ_O_BLD ))  DEALLOCATE(B%CUR%XGLAZ_O_BLD)
IF(ASSOCIATED(B%CUR%XMASS_O_BLD ))  DEALLOCATE(B%CUR%XMASS_O_BLD)
IF(ASSOCIATED(B%CUR%XFLOOR_HW_RATIO ))  DEALLOCATE(B%CUR%XFLOOR_HW_RATIO)
IF(ASSOCIATED(B%CUR%XF_FLOOR_MASS ))  DEALLOCATE(B%CUR%XF_FLOOR_MASS)
IF(ASSOCIATED(B%CUR%XF_FLOOR_WALL ))  DEALLOCATE(B%CUR%XF_FLOOR_WALL)
IF(ASSOCIATED(B%CUR%XF_FLOOR_WIN ))  DEALLOCATE(B%CUR%XF_FLOOR_WIN)
IF(ASSOCIATED(B%CUR%XF_FLOOR_ROOF ))  DEALLOCATE(B%CUR%XF_FLOOR_ROOF)
IF(ASSOCIATED(B%CUR%XF_WALL_FLOOR ))  DEALLOCATE(B%CUR%XF_WALL_FLOOR)
IF(ASSOCIATED(B%CUR%XF_WALL_MASS ))  DEALLOCATE(B%CUR%XF_WALL_MASS)
IF(ASSOCIATED(B%CUR%XF_WALL_WIN ))  DEALLOCATE(B%CUR%XF_WALL_WIN)
IF(ASSOCIATED(B%CUR%XF_WIN_FLOOR ))  DEALLOCATE(B%CUR%XF_WIN_FLOOR)
IF(ASSOCIATED(B%CUR%XF_WIN_MASS ))  DEALLOCATE(B%CUR%XF_WIN_MASS)
IF(ASSOCIATED(B%CUR%XF_WIN_WALL ))  DEALLOCATE(B%CUR%XF_WIN_WALL)
IF(ASSOCIATED(B%CUR%XF_MASS_FLOOR ))  DEALLOCATE(B%CUR%XF_MASS_FLOOR)
IF(ASSOCIATED(B%CUR%XF_MASS_WALL ))  DEALLOCATE(B%CUR%XF_MASS_WALL)
IF(ASSOCIATED(B%CUR%XF_MASS_WIN ))  DEALLOCATE(B%CUR%XF_MASS_WIN)
IF(ASSOCIATED(B%CUR%XTI_BLD ))  DEALLOCATE(B%CUR%XTI_BLD)
IF(ASSOCIATED(B%CUR%XQI_BLD ))  DEALLOCATE(B%CUR%XQI_BLD)
IF(ASSOCIATED(B%CUR%XT_FLOOR ))  DEALLOCATE(B%CUR%XT_FLOOR)
IF(ASSOCIATED(B%CUR%XT_MASS ))  DEALLOCATE(B%CUR%XT_MASS)
IF(ASSOCIATED(B%CUR%XAUX_MAX ))  DEALLOCATE(B%CUR%XAUX_MAX)
IF(ASSOCIATED(B%CUR%XPSOLD ))  DEALLOCATE(B%CUR%XPSOLD)
IF(ASSOCIATED(B%CUR%XSHADVACSW ))  DEALLOCATE(B%CUR%XSHADVACSW)
IF(ASSOCIATED(B%CUR%XVENTNIGSW ))  DEALLOCATE(B%CUR%XVENTNIGSW)
IF(ASSOCIATED(B%CUR%XT_WIN2 ))  DEALLOCATE(B%CUR%XT_WIN2)
IF(ASSOCIATED(B%CUR%XT_WIN1 ))  DEALLOCATE(B%CUR%XT_WIN1)
!
IF(ASSOCIATED(B%CUR%XTHEAT_OCCD)) DEALLOCATE(B%CUR%XTHEAT_OCCD)
IF(ASSOCIATED(B%CUR%XTHEAT_OCCN)) DEALLOCATE(B%CUR%XTHEAT_OCCN)
IF(ASSOCIATED(B%CUR%XTHEAT_VCDD)) DEALLOCATE(B%CUR%XTHEAT_VCDD)
IF(ASSOCIATED(B%CUR%XTHEAT_VCDN)) DEALLOCATE(B%CUR%XTHEAT_VCDN)
IF(ASSOCIATED(B%CUR%XTHEAT_VCLD)) DEALLOCATE(B%CUR%XTHEAT_VCLD)
IF(ASSOCIATED(B%CUR%XTCOOL_OCCD)) DEALLOCATE(B%CUR%XTCOOL_OCCD)
IF(ASSOCIATED(B%CUR%XTCOOL_OCCN)) DEALLOCATE(B%CUR%XTCOOL_OCCN)
IF(ASSOCIATED(B%CUR%XTCOOL_VCDD)) DEALLOCATE(B%CUR%XTCOOL_VCDD)
IF(ASSOCIATED(B%CUR%XTCOOL_VCDN)) DEALLOCATE(B%CUR%XTCOOL_VCDN)
IF(ASSOCIATED(B%CUR%XTCOOL_VCLD)) DEALLOCATE(B%CUR%XTCOOL_VCLD)
!
IF(ASSOCIATED(B%CUR%XFRAC_HEAT_ELEC))  DEALLOCATE(B%CUR%XFRAC_HEAT_ELEC)
IF(ASSOCIATED(B%CUR%XFRAC_HEAT_GAS))   DEALLOCATE(B%CUR%XFRAC_HEAT_GAS)
IF(ASSOCIATED(B%CUR%XFRAC_HEAT_FUEL))  DEALLOCATE(B%CUR%XFRAC_HEAT_FUEL)
IF(ASSOCIATED(B%CUR%XFRAC_HEAT_OTHER)) DEALLOCATE(B%CUR%XFRAC_HEAT_OTHER)
!
IF(ASSOCIATED(B%CUR%XHOTWAT   ))  DEALLOCATE(B%CUR%XHOTWAT   )
IF(ASSOCIATED(B%CUR%XF_HW_GAS   ))  DEALLOCATE(B%CUR%XF_HW_GAS   )
!
!
!
!
!################     DGCT      #####################
!
!
IF(ASSOCIATED(DGCT%CUR%XRUNOFFC_TOWN)) DEALLOCATE(DGCT%CUR%XRUNOFFC_TOWN)
IF(ASSOCIATED(DGCT%CUR%XRUNOFFC_GARDEN)) DEALLOCATE(DGCT%CUR%XRUNOFFC_GARDEN)
IF(ASSOCIATED(DGCT%CUR%XDRAINC_GARDEN)) DEALLOCATE(DGCT%CUR%XDRAINC_GARDEN)
IF(ASSOCIATED(DGCT%CUR%XIRRIGC_GARDEN)) DEALLOCATE(DGCT%CUR%XIRRIGC_GARDEN)
IF(ASSOCIATED(DGCT%CUR%XRUNOFFC_ROAD)) DEALLOCATE(DGCT%CUR%XRUNOFFC_ROAD)
IF(ASSOCIATED(DGCT%CUR%XIRRIGC_ROAD)) DEALLOCATE(DGCT%CUR%XIRRIGC_ROAD)
IF(ASSOCIATED(DGCT%CUR%XRUNOFFC_STRLROOF)) DEALLOCATE(DGCT%CUR%XRUNOFFC_STRLROOF)
IF(ASSOCIATED(DGCT%CUR%XRUNOFFC_ROOF)) DEALLOCATE(DGCT%CUR%XRUNOFFC_ROOF)
IF(ASSOCIATED(DGCT%CUR%XRUNOFFC_GREENROOF)) DEALLOCATE(DGCT%CUR%XRUNOFFC_GREENROOF)
IF(ASSOCIATED(DGCT%CUR%XDRAINC_GREENROOF)) DEALLOCATE(DGCT%CUR%XDRAINC_GREENROOF)
IF(ASSOCIATED(DGCT%CUR%XIRRIGC_GREENROOF)) DEALLOCATE(DGCT%CUR%XIRRIGC_GREENROOF)
IF(ASSOCIATED(DGCT%CUR%XRUNOFFC_SEWER)) DEALLOCATE(DGCT%CUR%XRUNOFFC_SEWER)
IF(ASSOCIATED(DGCT%CUR%XHVACC_COOL)) DEALLOCATE(DGCT%CUR%XHVACC_COOL)
IF(ASSOCIATED(DGCT%CUR%XHVACC_HEAT)) DEALLOCATE(DGCT%CUR%XHVACC_HEAT)
IF(ASSOCIATED(DGCT%CUR%XQINOUTCUM)) DEALLOCATE(DGCT%CUR%XQINOUTCUM)
IF(ASSOCIATED(DGCT%CUR%XHVACC_HEAT_ELEC)) DEALLOCATE(DGCT%CUR%XHVACC_HEAT_ELEC)
IF(ASSOCIATED(DGCT%CUR%XHVACC_HEAT_GAS)) DEALLOCATE(DGCT%CUR%XHVACC_HEAT_GAS)
IF(ASSOCIATED(DGCT%CUR%XHVACC_HEAT_FUEL)) DEALLOCATE(DGCT%CUR%XHVACC_HEAT_FUEL)
IF(ASSOCIATED(DGCT%CUR%XHVACC_HEAT_OTHER)) DEALLOCATE(DGCT%CUR%XHVACC_HEAT_OTHER)
IF(ASSOCIATED(DGCT%CUR%XTHER_PROD_BLDC)) DEALLOCATE(DGCT%CUR%XTHER_PROD_BLDC)
IF(ASSOCIATED(DGCT%CUR%XPHOT_PROD_BLDC)) DEALLOCATE(DGCT%CUR%XPHOT_PROD_BLDC)
IF(ASSOCIATED(DGCT%CUR%XHOTWATC)) DEALLOCATE(DGCT%CUR%XHOTWATC)
IF(ASSOCIATED(DGCT%CUR%XHOTWATC_GAS)) DEALLOCATE(DGCT%CUR%XHOTWATC_GAS)
IF(ASSOCIATED(DGCT%CUR%XHOTWATC_ELEC)) DEALLOCATE(DGCT%CUR%XHOTWATC_ELEC)
!
!
!
!################     DGMT      #####################
!
!

IF(ASSOCIATED(DGMT%CUR%XQF_BLD)) DEALLOCATE(DGMT%CUR%XQF_BLD)
IF(ASSOCIATED(DGMT%CUR%XFLX_BLD)) DEALLOCATE(DGMT%CUR%XFLX_BLD)
IF(ASSOCIATED(DGMT%CUR%XQF_TOWN)) DEALLOCATE(DGMT%CUR%XQF_TOWN)
IF(ASSOCIATED(DGMT%CUR%XDQS_TOWN)) DEALLOCATE(DGMT%CUR%XDQS_TOWN)
IF(ASSOCIATED(DGMT%CUR%XRN_ROAD)) DEALLOCATE(DGMT%CUR%XRN_ROAD)
IF(ASSOCIATED(DGMT%CUR%XH_ROAD)) DEALLOCATE(DGMT%CUR%XH_ROAD)
IF(ASSOCIATED(DGMT%CUR%XLE_ROAD)) DEALLOCATE(DGMT%CUR%XLE_ROAD)
IF(ASSOCIATED(DGMT%CUR%XGFLUX_ROAD)) DEALLOCATE(DGMT%CUR%XGFLUX_ROAD)
IF(ASSOCIATED(DGMT%CUR%XRN_WALL_A)) DEALLOCATE(DGMT%CUR%XRN_WALL_A)
IF(ASSOCIATED(DGMT%CUR%XH_WALL_A)) DEALLOCATE(DGMT%CUR%XH_WALL_A)
IF(ASSOCIATED(DGMT%CUR%XLE_WALL_A)) DEALLOCATE(DGMT%CUR%XLE_WALL_A)
IF(ASSOCIATED(DGMT%CUR%XGFLUX_WALL_A)) DEALLOCATE(DGMT%CUR%XGFLUX_WALL_A)
IF(ASSOCIATED(DGMT%CUR%XRN_WALL_B)) DEALLOCATE(DGMT%CUR%XRN_WALL_B)
IF(ASSOCIATED(DGMT%CUR%XH_WALL_B)) DEALLOCATE(DGMT%CUR%XH_WALL_B)
IF(ASSOCIATED(DGMT%CUR%XLE_WALL_B)) DEALLOCATE(DGMT%CUR%XLE_WALL_B)
IF(ASSOCIATED(DGMT%CUR%XGFLUX_WALL_B)) DEALLOCATE(DGMT%CUR%XGFLUX_WALL_B)
IF(ASSOCIATED(DGMT%CUR%XRN_ROOF)) DEALLOCATE(DGMT%CUR%XRN_ROOF)
IF(ASSOCIATED(DGMT%CUR%XH_ROOF)) DEALLOCATE(DGMT%CUR%XH_ROOF)
IF(ASSOCIATED(DGMT%CUR%XLE_ROOF)) DEALLOCATE(DGMT%CUR%XLE_ROOF)
IF(ASSOCIATED(DGMT%CUR%XGFLUX_ROOF)) DEALLOCATE(DGMT%CUR%XGFLUX_ROOF)
IF(ASSOCIATED(DGMT%CUR%XRN_GARDEN)) DEALLOCATE(DGMT%CUR%XRN_GARDEN)
IF(ASSOCIATED(DGMT%CUR%XH_GARDEN)) DEALLOCATE(DGMT%CUR%XH_GARDEN)
IF(ASSOCIATED(DGMT%CUR%XLE_GARDEN)) DEALLOCATE(DGMT%CUR%XLE_GARDEN)
IF(ASSOCIATED(DGMT%CUR%XGFLUX_GARDEN)) DEALLOCATE(DGMT%CUR%XGFLUX_GARDEN)
IF(ASSOCIATED(DGMT%CUR%XRN_BLT)) DEALLOCATE(DGMT%CUR%XRN_BLT)
IF(ASSOCIATED(DGMT%CUR%XH_BLT)) DEALLOCATE(DGMT%CUR%XH_BLT)
IF(ASSOCIATED(DGMT%CUR%XLE_BLT)) DEALLOCATE(DGMT%CUR%XLE_BLT)
IF(ASSOCIATED(DGMT%CUR%XH_TRAFFIC_OUT)) DEALLOCATE(DGMT%CUR%XH_TRAFFIC_OUT)
IF(ASSOCIATED(DGMT%CUR%XLE_TRAFFIC_OUT)) DEALLOCATE(DGMT%CUR%XLE_TRAFFIC_OUT)
IF(ASSOCIATED(DGMT%CUR%XH_INDUSTRY_OUT)) DEALLOCATE(DGMT%CUR%XH_INDUSTRY_OUT)
IF(ASSOCIATED(DGMT%CUR%XLE_INDUSTRY_OUT)) DEALLOCATE(DGMT%CUR%XLE_INDUSTRY_OUT)
IF(ASSOCIATED(DGMT%CUR%XGFLUX_BLT)) DEALLOCATE(DGMT%CUR%XGFLUX_BLT)
IF(ASSOCIATED(DGMT%CUR%XRN_STRLROOF)) DEALLOCATE(DGMT%CUR%XRN_STRLROOF)
IF(ASSOCIATED(DGMT%CUR%XH_STRLROOF)) DEALLOCATE(DGMT%CUR%XH_STRLROOF)
IF(ASSOCIATED(DGMT%CUR%XLE_STRLROOF)) DEALLOCATE(DGMT%CUR%XLE_STRLROOF)
IF(ASSOCIATED(DGMT%CUR%XGFLUX_STRLROOF)) DEALLOCATE(DGMT%CUR%XGFLUX_STRLROOF)
IF(ASSOCIATED(DGMT%CUR%XRN_GREENROOF)) DEALLOCATE(DGMT%CUR%XRN_GREENROOF)
IF(ASSOCIATED(DGMT%CUR%XH_GREENROOF)) DEALLOCATE(DGMT%CUR%XH_GREENROOF)
IF(ASSOCIATED(DGMT%CUR%XLE_GREENROOF)) DEALLOCATE(DGMT%CUR%XLE_GREENROOF)
IF(ASSOCIATED(DGMT%CUR%XGFLUX_GREENROOF)) DEALLOCATE(DGMT%CUR%XGFLUX_GREENROOF)
IF(ASSOCIATED(DGMT%CUR%XG_GREENROOF_ROOF)) DEALLOCATE(DGMT%CUR%XG_GREENROOF_ROOF)
IF(ASSOCIATED(DGMT%CUR%XQF_WALL_A)) DEALLOCATE(DGMT%CUR%XQF_WALL_A        )
IF(ASSOCIATED(DGMT%CUR%XQF_WALL_B)) DEALLOCATE(DGMT%CUR%XQF_WALL_B        )
IF(ASSOCIATED(DGMT%CUR%XQF_ROAD )) DEALLOCATE(DGMT%CUR%XQF_ROAD          )
IF(ASSOCIATED(DGMT%CUR%XQF_ROOF)) DEALLOCATE(DGMT%CUR%XQF_ROOF          )
IF(ASSOCIATED(DGMT%CUR%XQF_BLT)) DEALLOCATE(DGMT%CUR%XQF_BLT           )
IF(ASSOCIATED(DGMT%CUR%XSNOW_HEAT_ROOF)) DEALLOCATE(DGMT%CUR%XSNOW_HEAT_ROOF        )
IF(ASSOCIATED(DGMT%CUR%XSNOW_HEAT_ROAD)) DEALLOCATE(DGMT%CUR%XSNOW_HEAT_ROAD        )
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_TOWN)) DEALLOCATE(DGMT%CUR%XRUNOFF_TOWN)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_GARDEN)) DEALLOCATE(DGMT%CUR%XRUNOFF_GARDEN)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_ROAD)) DEALLOCATE(DGMT%CUR%XRUNOFF_ROAD)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_STRLROOF)) DEALLOCATE(DGMT%CUR%XRUNOFF_STRLROOF)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_ROOF)) DEALLOCATE(DGMT%CUR%XRUNOFF_ROOF)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_GREENROOF)) DEALLOCATE(DGMT%CUR%XRUNOFF_GREENROOF)
IF(ASSOCIATED(DGMT%CUR%XDRAIN_GREENROOF)) DEALLOCATE(DGMT%CUR%XDRAIN_GREENROOF)
IF(ASSOCIATED(DGMT%CUR%XDRAIN_GARDEN)) DEALLOCATE(DGMT%CUR%XDRAIN_GARDEN)
IF(ASSOCIATED(DGMT%CUR%XIRRIG_GREENROOF)) DEALLOCATE(DGMT%CUR%XIRRIG_GREENROOF)
IF(ASSOCIATED(DGMT%CUR%XIRRIG_GARDEN)) DEALLOCATE(DGMT%CUR%XIRRIG_GARDEN)
IF(ASSOCIATED(DGMT%CUR%XIRRIG_ROAD)) DEALLOCATE(DGMT%CUR%XIRRIG_ROAD)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_SEWER)) DEALLOCATE(DGMT%CUR%XRUNOFF_SEWER)
IF(ASSOCIATED(DGMT%CUR%XDRAIN_ROAD)) DEALLOCATE(DGMT%CUR%XDRAIN_ROAD)
IF(ASSOCIATED(DGMT%CUR%XDRAIN_BLD)) DEALLOCATE(DGMT%CUR%XDRAIN_BLD)
IF(ASSOCIATED(DGMT%CUR%XDIS_TOWN)) DEALLOCATE(DGMT%CUR%XDIS_TOWN)
IF(ASSOCIATED(DGMT%CUR%XDIS_ROOF)) DEALLOCATE(DGMT%CUR%XDIS_ROOF)
IF(ASSOCIATED(DGMT%CUR%XDIS_ROAD)) DEALLOCATE(DGMT%CUR%XDIS_ROAD)
IF(ASSOCIATED(DGMT%CUR%XDIS_GARDEN)) DEALLOCATE(DGMT%CUR%XDIS_GARDEN)
IF(ASSOCIATED(DGMT%CUR%XDIS_SEWER)) DEALLOCATE(DGMT%CUR%XDIS_SEWER)
IF(ASSOCIATED(DGMT%CUR%XWG_ROAD_INI)) DEALLOCATE(DGMT%CUR%XWG_ROAD_INI)
IF(ASSOCIATED(DGMT%CUR%XWG_BLD_INI)) DEALLOCATE(DGMT%CUR%XWG_BLD_INI)
IF(ASSOCIATED(DGMT%CUR%XWG_GARDEN_INI)) DEALLOCATE(DGMT%CUR%XWG_GARDEN_INI)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_ROOF)) DEALLOCATE(DGMT%CUR%XABS_SW_ROOF)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_SNOW_ROOF)) DEALLOCATE(DGMT%CUR%XABS_SW_SNOW_ROOF)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_ROOF)) DEALLOCATE(DGMT%CUR%XABS_LW_ROOF)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_SNOW_ROOF)) DEALLOCATE(DGMT%CUR%XABS_LW_SNOW_ROOF)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_ROAD)) DEALLOCATE(DGMT%CUR%XABS_SW_ROAD)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_SNOW_ROAD)) DEALLOCATE(DGMT%CUR%XABS_SW_SNOW_ROAD)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_ROAD)) DEALLOCATE(DGMT%CUR%XABS_LW_ROAD)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_SNOW_ROAD)) DEALLOCATE(DGMT%CUR%XABS_LW_SNOW_ROAD)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_WALL_A)) DEALLOCATE(DGMT%CUR%XABS_SW_WALL_A)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_WALL_B)) DEALLOCATE(DGMT%CUR%XABS_SW_WALL_B)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_WALL_A)) DEALLOCATE(DGMT%CUR%XABS_LW_WALL_A)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_WALL_B)) DEALLOCATE(DGMT%CUR%XABS_LW_WALL_B)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_GARDEN)) DEALLOCATE(DGMT%CUR%XABS_SW_GARDEN)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_GARDEN)) DEALLOCATE(DGMT%CUR%XABS_LW_GARDEN)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_HVEG)) DEALLOCATE(DGMT%CUR%XABS_SW_HVEG)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_HVEG)) DEALLOCATE(DGMT%CUR%XABS_LW_HVEG)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_GREENROOF)) DEALLOCATE(DGMT%CUR%XABS_SW_GREENROOF)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_GREENROOF)) DEALLOCATE(DGMT%CUR%XABS_LW_GREENROOF)
IF(ASSOCIATED(DGMT%CUR%XREF_SW_FAC)) DEALLOCATE(DGMT%CUR%XREF_SW_FAC)
IF(ASSOCIATED(DGMT%CUR%XREF_SW_GRND)) DEALLOCATE(DGMT%CUR%XREF_SW_GRND)
IF(ASSOCIATED(DGMT%CUR%XEMIT_LW_FAC)) DEALLOCATE(DGMT%CUR%XEMIT_LW_FAC)
IF(ASSOCIATED(DGMT%CUR%XEMIT_LW_GRND)) DEALLOCATE(DGMT%CUR%XEMIT_LW_GRND)
IF(ASSOCIATED(DGMT%CUR%XSENFABSTOR)) DEALLOCATE(DGMT%CUR%XSENFABSTOR)
IF(ASSOCIATED(DGMT%CUR%XLATFABSTOR)) DEALLOCATE(DGMT%CUR%XLATFABSTOR)
IF(ASSOCIATED(DGMT%CUR%XROOFTK)) DEALLOCATE(DGMT%CUR%XROOFTK)
IF(ASSOCIATED(DGMT%CUR%XWALLTK)) DEALLOCATE(DGMT%CUR%XWALLTK)
IF(ASSOCIATED(DGMT%CUR%XU_LOWCAN)) DEALLOCATE(DGMT%CUR%XU_LOWCAN)
IF(ASSOCIATED(DGMT%CUR%XH_BLD_COOL)) DEALLOCATE(DGMT%CUR%XH_BLD_COOL)
IF(ASSOCIATED(DGMT%CUR%XLE_BLD_COOL)) DEALLOCATE(DGMT%CUR%XLE_BLD_COOL)
IF(ASSOCIATED(DGMT%CUR%XH_WASTE_CANY)) DEALLOCATE(DGMT%CUR%XH_WASTE_CANY)
IF(ASSOCIATED(DGMT%CUR%XLE_WASTE_CANY)) DEALLOCATE(DGMT%CUR%XLE_WASTE_CANY)
IF(ASSOCIATED(DGMT%CUR%XH_WASTE_ROOF)) DEALLOCATE(DGMT%CUR%XH_WASTE_ROOF)
IF(ASSOCIATED(DGMT%CUR%XLE_WASTE_ROOF)) DEALLOCATE(DGMT%CUR%XLE_WASTE_ROOF)
IF(ASSOCIATED(DGMT%CUR%XHVAC_COOL)) DEALLOCATE(DGMT%CUR%XHVAC_COOL)
IF(ASSOCIATED(DGMT%CUR%XHVAC_HEAT)) DEALLOCATE(DGMT%CUR%XHVAC_HEAT)
IF(ASSOCIATED(DGMT%CUR%XQINOUT)) DEALLOCATE(DGMT%CUR%XQINOUT)
IF(ASSOCIATED(DGMT%CUR%XHVAC_HEAT_ELEC)) DEALLOCATE(DGMT%CUR%XHVAC_HEAT_ELEC)
IF(ASSOCIATED(DGMT%CUR%XHVAC_HEAT_GAS)) DEALLOCATE(DGMT%CUR%XHVAC_HEAT_GAS)
IF(ASSOCIATED(DGMT%CUR%XHVAC_HEAT_FUEL)) DEALLOCATE(DGMT%CUR%XHVAC_HEAT_FUEL)
IF(ASSOCIATED(DGMT%CUR%XHVAC_HEAT_OTHER)) DEALLOCATE(DGMT%CUR%XHVAC_HEAT_OTHER)
IF(ASSOCIATED(DGMT%CUR%XCOMP_HVAC_COOL)) DEALLOCATE(DGMT%CUR%XCOMP_HVAC_COOL)
IF(ASSOCIATED(DGMT%CUR%XCOMP_HVAC_HEAT)) DEALLOCATE(DGMT%CUR%XCOMP_HVAC_HEAT)
IF(ASSOCIATED(DGMT%CUR%XCOMP_QINOUT)) DEALLOCATE(DGMT%CUR%XCOMP_QINOUT)
IF(ASSOCIATED(DGMT%CUR%XMASSTK)) DEALLOCATE(DGMT%CUR%XMASSTK)
IF(ASSOCIATED(DGMT%CUR%XINFCALC)) DEALLOCATE(DGMT%CUR%XINFCALC)
IF(ASSOCIATED(DGMT%CUR%XDIAGSHAD)) DEALLOCATE(DGMT%CUR%XDIAGSHAD)
IF(ASSOCIATED(DGMT%CUR%XDIAGVENT)) DEALLOCATE(DGMT%CUR%XDIAGVENT)
IF(ASSOCIATED(DGMT%CUR%XDIAGVEFL)) DEALLOCATE(DGMT%CUR%XDIAGVEFL)
IF(ASSOCIATED(DGMT%CUR%XBLDOCC)) DEALLOCATE(DGMT%CUR%XBLDOCC)
IF(ASSOCIATED(DGMT%CUR%XQIN_KWH)) DEALLOCATE(DGMT%CUR%XQIN_KWH)
IF(ASSOCIATED(DGMT%CUR%XHVAC_HT_KWH)) DEALLOCATE(DGMT%CUR%XHVAC_HT_KWH)
IF(ASSOCIATED(DGMT%CUR%XHVAC_CL_KWH)) DEALLOCATE(DGMT%CUR%XHVAC_CL_KWH)
IF(ASSOCIATED(DGMT%CUR%XCAP_SYS)) DEALLOCATE(DGMT%CUR%XCAP_SYS)
IF(ASSOCIATED(DGMT%CUR%XM_SYS)) DEALLOCATE(DGMT%CUR%XM_SYS)
IF(ASSOCIATED(DGMT%CUR%XCOP)) DEALLOCATE(DGMT%CUR%XCOP)
IF(ASSOCIATED(DGMT%CUR%XQ_SYS)) DEALLOCATE(DGMT%CUR%XQ_SYS)
IF(ASSOCIATED(DGMT%CUR%XT_SYS)) DEALLOCATE(DGMT%CUR%XT_SYS)
IF(ASSOCIATED(DGMT%CUR%XTR_SW_WIN)) DEALLOCATE(DGMT%CUR%XTR_SW_WIN)
IF(ASSOCIATED(DGMT%CUR%XT_RAD_IND)) DEALLOCATE(DGMT%CUR%XT_RAD_IND)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_WIN)) DEALLOCATE(DGMT%CUR%XABS_SW_WIN)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_WIN)) DEALLOCATE(DGMT%CUR%XABS_LW_WIN)
IF(ASSOCIATED(DGMT%CUR%XABS_SW_PANEL)) DEALLOCATE(DGMT%CUR%XABS_SW_PANEL)
IF(ASSOCIATED(DGMT%CUR%XABS_LW_PANEL)) DEALLOCATE(DGMT%CUR%XABS_LW_PANEL)
IF(ASSOCIATED(DGMT%CUR%XRN_PANEL)) DEALLOCATE(DGMT%CUR%XRN_PANEL)
IF(ASSOCIATED(DGMT%CUR%XH_PANEL)) DEALLOCATE(DGMT%CUR%XH_PANEL)
IF(ASSOCIATED(DGMT%CUR%XTHER_PROD_PANEL)) DEALLOCATE(DGMT%CUR%XTHER_PROD_PANEL)
IF(ASSOCIATED(DGMT%CUR%XPHOT_PROD_PANEL)) DEALLOCATE(DGMT%CUR%XPHOT_PROD_PANEL)
IF(ASSOCIATED(DGMT%CUR%XPROD_PANEL)) DEALLOCATE(DGMT%CUR%XPROD_PANEL)
IF(ASSOCIATED(DGMT%CUR%XTHER_PROD_BLD)) DEALLOCATE(DGMT%CUR%XTHER_PROD_BLD)
IF(ASSOCIATED(DGMT%CUR%XPHOT_PROD_BLD)) DEALLOCATE(DGMT%CUR%XPHOT_PROD_BLD)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_TOWNB)) DEALLOCATE(DGMT%CUR%XRUNOFF_TOWNB)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_GARDENB)) DEALLOCATE(DGMT%CUR%XRUNOFF_GARDENB)
IF(ASSOCIATED(DGMT%CUR%XDRAIN_GARDENB)) DEALLOCATE(DGMT%CUR%XDRAIN_GARDENB)
IF(ASSOCIATED(DGMT%CUR%XDRAIN_ROADB)) DEALLOCATE(DGMT%CUR%XDRAIN_ROADB)
IF(ASSOCIATED(DGMT%CUR%XDRAIN_BLDB)) DEALLOCATE(DGMT%CUR%XDRAIN_BLDB)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_ROADB)) DEALLOCATE(DGMT%CUR%XRUNOFF_ROADB)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_STRLROOFB)) DEALLOCATE(DGMT%CUR%XRUNOFF_STRLROOFB)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_ROOFB)) DEALLOCATE(DGMT%CUR%XRUNOFF_ROOFB)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_GREENROOFB)) DEALLOCATE(DGMT%CUR%XRUNOFF_GREENROOFB)
IF(ASSOCIATED(DGMT%CUR%XRUNOFF_SEWERB)) DEALLOCATE(DGMT%CUR%XRUNOFF_SEWERB)
IF(ASSOCIATED(DGMT%CUR%XLE_STRLROOFB)) DEALLOCATE(DGMT%CUR%XLE_STRLROOFB)
IF(ASSOCIATED(DGMT%CUR%XLE_GREENROOFB)) DEALLOCATE(DGMT%CUR%XLE_GREENROOFB)
IF(ASSOCIATED(DGMT%CUR%XLE_ROADB)) DEALLOCATE(DGMT%CUR%XLE_ROADB)
IF(ASSOCIATED(DGMT%CUR%XLE_GARDENB)) DEALLOCATE(DGMT%CUR%XLE_GARDENB)
IF(ASSOCIATED(DGMT%CUR%XRAINB)) DEALLOCATE(DGMT%CUR%XRAINB)
IF(ASSOCIATED(DGMT%CUR%XSNOWB)) DEALLOCATE(DGMT%CUR%XSNOWB)
IF(ASSOCIATED(DGMT%CUR%XSFCO2_T)) DEALLOCATE(DGMT%CUR%XSFCO2_T)
IF(ASSOCIATED(DGMT%CUR%XSFCO2_T_VEG)) DEALLOCATE(DGMT%CUR%XSFCO2_T_VEG)
IF(ASSOCIATED(DGMT%CUR%XSFCO2_T_BLD)) DEALLOCATE(DGMT%CUR%XSFCO2_T_BLD)
IF(ASSOCIATED(DGMT%CUR%XSFCO2_T_RD)) DEALLOCATE(DGMT%CUR%XSFCO2_T_RD)
IF(ASSOCIATED(DGMT%CUR%XSFCO2_T_POP)) DEALLOCATE(DGMT%CUR%XSFCO2_T_POP)
IF(ASSOCIATED(DGMT%CUR%XHOTWAT)) DEALLOCATE(DGMT%CUR%XHOTWAT)
IF(ASSOCIATED(DGMT%CUR%XHOTWAT_GAS)) DEALLOCATE(DGMT%CUR%XHOTWAT_GAS)
IF(ASSOCIATED(DGMT%CUR%XHOTWAT_ELEC)) DEALLOCATE(DGMT%CUR%XHOTWAT_ELEC)
IF(ASSOCIATED(DGMT%CUR%XCOMP_HOTWAT)) DEALLOCATE(DGMT%CUR%XCOMP_HOTWAT)
!
!
!################      T       #####################
!
!
IF(ASSOCIATED(T%CUR%XZ0_TOWN     )) DEALLOCATE(T%CUR%XZ0_TOWN     )
IF(ASSOCIATED(T%CUR%XALB_ROOF    )) DEALLOCATE(T%CUR%XALB_ROOF    )
IF(ASSOCIATED(T%CUR%XEMIS_ROOF   )) DEALLOCATE(T%CUR%XEMIS_ROOF   )
IF(ASSOCIATED(T%CUR%XALB_ROAD    )) DEALLOCATE(T%CUR%XALB_ROAD    )
IF(ASSOCIATED(T%CUR%XEMIS_ROAD   )) DEALLOCATE(T%CUR%XEMIS_ROAD   )
IF(ASSOCIATED(T%CUR%XALB_WALL    )) DEALLOCATE(T%CUR%XALB_WALL    )
IF(ASSOCIATED(T%CUR%XEMIS_WALL   )) DEALLOCATE(T%CUR%XEMIS_WALL   )
IF(ASSOCIATED(T%CUR%XBLD         )) DEALLOCATE(T%CUR%XBLD         )
IF(ASSOCIATED(T%CUR%XGARDEN      )) DEALLOCATE(T%CUR%XGARDEN      )
IF(ASSOCIATED(T%CUR%XROAD        )) DEALLOCATE(T%CUR%XROAD        )
IF(ASSOCIATED(T%CUR%XGREENROOF   )) DEALLOCATE(T%CUR%XGREENROOF   )
IF(ASSOCIATED(T%CUR%XROAD_DIR    )) DEALLOCATE(T%CUR%XROAD_DIR    )
IF(ASSOCIATED(T%CUR%XBLD_HEIGHT  )) DEALLOCATE(T%CUR%XBLD_HEIGHT  )
IF(ASSOCIATED(T%CUR%XWALL_O_HOR  )) DEALLOCATE(T%CUR%XWALL_O_HOR  )
IF(ASSOCIATED(T%CUR%XCAN_HW_RATIO)) DEALLOCATE(T%CUR%XCAN_HW_RATIO)
IF(ASSOCIATED(T%CUR%XROAD_O_GRND )) DEALLOCATE(T%CUR%XROAD_O_GRND)
IF(ASSOCIATED(T%CUR%XGARDEN_O_GRND))DEALLOCATE(T%CUR%XGARDEN_O_GRND)
IF(ASSOCIATED(T%CUR%XWALL_O_GRND )) DEALLOCATE(T%CUR%XWALL_O_GRND)
IF(ASSOCIATED(T%CUR%XWALL_O_BLD  )) DEALLOCATE(T%CUR%XWALL_O_BLD)
!
IF(ASSOCIATED(T%CUR%XH_TRAFFIC   )) DEALLOCATE(T%CUR%XH_TRAFFIC   )
IF(ASSOCIATED(T%CUR%XLE_TRAFFIC  )) DEALLOCATE(T%CUR%XLE_TRAFFIC  )
IF(ASSOCIATED(T%CUR%XH_INDUSTRY  )) DEALLOCATE(T%CUR%XH_INDUSTRY  )
IF(ASSOCIATED(T%CUR%XLE_INDUSTRY )) DEALLOCATE(T%CUR%XLE_INDUSTRY )
!
IF(ASSOCIATED(T%CUR%XHC_ROOF     )) DEALLOCATE(T%CUR%XHC_ROOF )
IF(ASSOCIATED(T%CUR%XTC_ROOF     )) DEALLOCATE(T%CUR%XTC_ROOF )
IF(ASSOCIATED(T%CUR%XD_ROOF      )) DEALLOCATE(T%CUR%XD_ROOF  )
IF(ASSOCIATED(T%CUR%XHC_ROAD     )) DEALLOCATE(T%CUR%XHC_ROAD )
IF(ASSOCIATED(T%CUR%XTC_ROAD     )) DEALLOCATE(T%CUR%XTC_ROAD )
IF(ASSOCIATED(T%CUR%XD_ROAD      )) DEALLOCATE(T%CUR%XD_ROAD  )
IF(ASSOCIATED(T%CUR%XHC_WALL     )) DEALLOCATE(T%CUR%XHC_WALL )
IF(ASSOCIATED(T%CUR%XTC_WALL     )) DEALLOCATE(T%CUR%XTC_WALL )
IF(ASSOCIATED(T%CUR%XD_WALL      )) DEALLOCATE(T%CUR%XD_WALL  )
IF(ASSOCIATED(T%CUR%XHC_BLD      )) DEALLOCATE(T%CUR%XHC_BLD )
IF(ASSOCIATED(T%CUR%XTC_BLD      )) DEALLOCATE(T%CUR%XTC_BLD )
IF(ASSOCIATED(T%CUR%XD_BLD       )) DEALLOCATE(T%CUR%XD_BLD  )
IF(ASSOCIATED(T%CUR%XHC_ALLBLD   )) DEALLOCATE(T%CUR%XHC_ALLBLD )
IF(ASSOCIATED(T%CUR%XTC_ALLBLD   )) DEALLOCATE(T%CUR%XTC_ALLBLD )
IF(ASSOCIATED(T%CUR%XD_ALLBLD    )) DEALLOCATE(T%CUR%XD_ALLBLD  )
!
IF (ASSOCIATED(T%CUR%XT_ROOF)) DEALLOCATE(T%CUR%XT_ROOF)
IF (ASSOCIATED(T%CUR%XT_ROAD)) DEALLOCATE(T%CUR%XT_ROAD)
IF (ASSOCIATED(T%CUR%XT_WALL_A)) DEALLOCATE(T%CUR%XT_WALL_A)
IF (ASSOCIATED(T%CUR%XT_WALL_B)) DEALLOCATE(T%CUR%XT_WALL_B)
IF (ASSOCIATED(T%CUR%XT_BLD  ))  DEALLOCATE(T%CUR%XT_BLD)
IF (ASSOCIATED(T%CUR%XT_ALLBLD))  DEALLOCATE(T%CUR%XT_ALLBLD)
IF (ASSOCIATED(T%CUR%XAC_ROOF)) DEALLOCATE(T%CUR%XAC_ROOF)
IF (ASSOCIATED(T%CUR%XAC_ROAD)) DEALLOCATE(T%CUR%XAC_ROAD)
IF (ASSOCIATED(T%CUR%XAC_WALL)) DEALLOCATE(T%CUR%XAC_WALL)
IF (ASSOCIATED(T%CUR%XAC_TOP)) DEALLOCATE(T%CUR%XAC_TOP)
IF (ASSOCIATED(T%CUR%XAC_ROOF_WAT)) DEALLOCATE(T%CUR%XAC_ROOF_WAT)
IF (ASSOCIATED(T%CUR%XAC_ROAD_WAT)) DEALLOCATE(T%CUR%XAC_ROAD_WAT)
IF (ASSOCIATED(T%CUR%XQSAT_ROOF)) DEALLOCATE(T%CUR%XQSAT_ROOF)
IF (ASSOCIATED(T%CUR%XQSAT_ROAD)) DEALLOCATE(T%CUR%XQSAT_ROAD)
IF (ASSOCIATED(T%CUR%XDELT_ROOF)) DEALLOCATE(T%CUR%XDELT_ROOF)
IF (ASSOCIATED(T%CUR%XDELT_ROAD)) DEALLOCATE(T%CUR%XDELT_ROAD)
!
IF (ASSOCIATED(T%CUR%XTHEWALL   )) DEALLOCATE(T%CUR%XTHEWALL   )
IF (ASSOCIATED(T%CUR%XTHEROOF   )) DEALLOCATE(T%CUR%XTHEROOF   )
IF (ASSOCIATED(T%CUR%XTHEFLOOR  )) DEALLOCATE(T%CUR%XTHEFLOOR  )
IF (ASSOCIATED(T%CUR%XTHEMASS   )) DEALLOCATE(T%CUR%XTHEMASS   )
IF (ASSOCIATED(T%CUR%XTHEROAD   )) DEALLOCATE(T%CUR%XTHEROAD   )
IF (ASSOCIATED(T%CUR%XTHEAIRIN  )) DEALLOCATE(T%CUR%XTHEAIRIN  )
IF (ASSOCIATED(T%CUR%XTHETOTAL  )) DEALLOCATE(T%CUR%XTHETOTAL  )
IF (ASSOCIATED(T%CUR%XLATWATROOF)) DEALLOCATE(T%CUR%XLATWATROOF)
IF (ASSOCIATED(T%CUR%XLATWATROAD)) DEALLOCATE(T%CUR%XLATWATROAD)
IF (ASSOCIATED(T%CUR%XLATICEROOF)) DEALLOCATE(T%CUR%XLATICEROOF)
IF (ASSOCIATED(T%CUR%XLATICEROAD)) DEALLOCATE(T%CUR%XLATICEROAD)
IF (ASSOCIATED(T%CUR%XLATAIRIN  )) DEALLOCATE(T%CUR%XLATAIRIN  )
IF (ASSOCIATED(T%CUR%XLATTOTAL  )) DEALLOCATE(T%CUR%XLATTOTAL  )
IF (ASSOCIATED(T%CUR%XENETOTAL  )) DEALLOCATE(T%CUR%XENETOTAL  )
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(T%CUR%XAC_ROOF    ))  DEALLOCATE(T%CUR%XAC_ROOF    )
IF(ASSOCIATED(T%CUR%XAC_ROAD    ))  DEALLOCATE(T%CUR%XAC_ROAD    )
IF(ASSOCIATED(T%CUR%XAC_WALL    ))  DEALLOCATE(T%CUR%XAC_WALL    )
IF(ASSOCIATED(T%CUR%XAC_TOP     ))  DEALLOCATE(T%CUR%XAC_TOP     )
IF(ASSOCIATED(T%CUR%XAC_ROOF_WAT))  DEALLOCATE(T%CUR%XAC_ROOF_WAT)
IF(ASSOCIATED(T%CUR%XAC_ROAD_WAT))  DEALLOCATE(T%CUR%XAC_ROAD_WAT)
IF(ASSOCIATED(T%CUR%XQSAT_ROOF  ))  DEALLOCATE(T%CUR%XQSAT_ROOF  )
IF(ASSOCIATED(T%CUR%XQSAT_ROAD  ))  DEALLOCATE(T%CUR%XQSAT_ROAD  )
IF(ASSOCIATED(T%CUR%XDELT_ROOF  ))  DEALLOCATE(T%CUR%XDELT_ROOF  )
IF(ASSOCIATED(T%CUR%XDELT_ROAD  ))  DEALLOCATE(T%CUR%XDELT_ROAD  )
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(T%CUR%XNB_POP          ))  DEALLOCATE(T%CUR%XNB_POP          )
IF(ASSOCIATED(T%CUR%XSFCO2_RD        ))  DEALLOCATE(T%CUR%XSFCO2_RD        )
IF(ASSOCIATED(T%CUR%XDELTA_LEGAL_TIME))  DEALLOCATE(T%CUR%XDELTA_LEGAL_TIME)
IF(ASSOCIATED(T%CUR%XTIME_OF_CHANGE  ))  DEALLOCATE(T%CUR%XTIME_OF_CHANGE  )
!
IF(ASSOCIATED(T%CUR%XROUGH_ROOF ))  DEALLOCATE(T%CUR%XROUGH_ROOF)
IF(ASSOCIATED(T%CUR%XROUGH_WALL ))  DEALLOCATE(T%CUR%XROUGH_WALL)
!
IF (LHOOK) CALL DR_HOOK('DEALLOC_MISC_TEB_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DEALLOC_MISC_TEB_n
