!##################################
SUBROUTINE CUMUL_DIAG_TEB_n (DGCT, DGMT, TOP, &
                             PTSTEP, PRAIN, PSNOW)
!##################################
!
!
!!****  *CUMUL_DIAG_TEB_n*  
!!
!!    PURPOSE
!!    -------
!      Cumulates some diagnostics for TEB
!     
!!**  METHOD
!!    ------
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------ 
!!
!!      
!!    REFERENCE
!!    ---------
!!      
!!    AUTHOR
!!    ------
!!      C. de Munck       * Meteo-France *
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2013
!!                  08/2013 (V. Masson) adds solar panels
!!                  07/2017 (M. Goret)  add energy consumption of heating by source
!!                  07/2017 (M. Goret)  add energy consumption for hot water
!-------------------------------------------------------------------------------
!
!*       0.     DECLARATIONS
!               ------------
!
USE MODD_DIAG_CUMUL_TEB_n, ONLY : DIAG_CUMUL_TEB_t
USE MODD_DIAG_MISC_TEB_n, ONLY : DIAG_MISC_TEB_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODD_SURF_PAR,        ONLY :  XUNDEF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
TYPE(DIAG_CUMUL_TEB_t), INTENT(INOUT) :: DGCT
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DGMT
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
      REAL,                 INTENT(IN) :: PTSTEP      ! time step
      REAL, DIMENSION(:)  , INTENT(IN) :: PRAIN       ! liquid precipitation                  (kg/m2/s)
      REAL, DIMENSION(:)  , INTENT(IN) :: PSNOW       ! liquid precipitation                  (kg/m2/s)
!
!*      0.2    declarations of local variables
!
INTEGER :: JI 

REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
!       0.     Initialization
!              --------------
IF (LHOOK) CALL DR_HOOK('CUMUL_DIAG_TEB_N',0,ZHOOK_HANDLE)
!
!       1.     Time-cumulated diagnostics for TEB
!              ----------------------------------
!
DO JI=1,SIZE(DGMT%CUR%XRUNOFF_ROOF,1)
!
 IF (TOP%LSOLAR_PANEL) THEN
    IF (DGMT%CUR%XTHER_PROD_BLD(JI) .NE. XUNDEF) THEN
     DGCT%CUR%XTHER_PROD_BLDC(JI)     =  DGCT%CUR%XTHER_PROD_BLDC(JI)     + DGMT%CUR%XTHER_PROD_BLD(JI)  * PTSTEP
    ENDIF
    !
    IF (DGMT%CUR%XPHOT_PROD_BLD(JI) .NE. XUNDEF) THEN
     DGCT%CUR%XPHOT_PROD_BLDC(JI)     =  DGCT%CUR%XPHOT_PROD_BLDC(JI)     + DGMT%CUR%XPHOT_PROD_BLD(JI)  * PTSTEP
    ENDIF
 END IF

 IF (TOP%CBEM == 'BEM') THEN
    IF (DGMT%CUR%XHVAC_COOL(JI) .NE. XUNDEF) THEN
     DGCT%CUR%XHVACC_COOL(JI)     =  DGCT%CUR%XHVACC_COOL(JI)       + DGMT%CUR%XHVAC_COOL(JI)        * PTSTEP
    ENDIF
    !
    IF (DGMT%CUR%XHVAC_HEAT(JI) .NE. XUNDEF) THEN
     DGCT%CUR%XHVACC_HEAT(JI)     =  DGCT%CUR%XHVACC_HEAT(JI)       + DGMT%CUR%XHVAC_HEAT(JI)        * PTSTEP
    ENDIF
    !
    IF (DGMT%CUR%XQINOUT(JI) .NE. XUNDEF) THEN
     DGCT%CUR%XQINOUTCUM(JI)      =  DGCT%CUR%XQINOUTCUM(JI)        + DGMT%CUR%XQINOUT(JI)        * PTSTEP
    ENDIF
    !
 ENDIF
 !
 IF (DGMT%CUR%XRUNOFF_TOWN(JI) .NE. XUNDEF) THEN
  DGCT%CUR%XRUNOFFC_TOWN(JI)      =  DGCT%CUR%XRUNOFFC_TOWN(JI)     + DGMT%CUR%XRUNOFF_TOWN(JI)      * PTSTEP
 ENDIF
 !
 IF (DGMT%CUR%XRUNOFF_GARDEN(JI) .NE. XUNDEF) THEN
  DGCT%CUR%XRUNOFFC_GARDEN(JI)    =  DGCT%CUR%XRUNOFFC_GARDEN(JI)   + DGMT%CUR%XRUNOFF_GARDEN(JI)    * PTSTEP
 ENDIF
 !
 IF (DGMT%CUR%XRUNOFF_ROAD(JI) .NE. XUNDEF) THEN
  DGCT%CUR%XRUNOFFC_ROAD(JI)      =  DGCT%CUR%XRUNOFFC_ROAD(JI)     + DGMT%CUR%XRUNOFF_ROAD(JI)      * PTSTEP
 ENDIF
 !
 IF (DGMT%CUR%XRUNOFF_ROOF(JI) .NE. XUNDEF) THEN 
  DGCT%CUR%XRUNOFFC_ROOF(JI)      =  DGCT%CUR%XRUNOFFC_ROOF(JI)     + DGMT%CUR%XRUNOFF_ROOF(JI)      * PTSTEP
 ENDIF
 !
 IF (DGMT%CUR%XRUNOFF_STRLROOF(JI) .NE. XUNDEF) THEN
  DGCT%CUR%XRUNOFFC_STRLROOF(JI)  =  DGCT%CUR%XRUNOFFC_STRLROOF(JI) + DGMT%CUR%XRUNOFF_STRLROOF(JI)  * PTSTEP
 ENDIF
 !
 IF (DGMT%CUR%XDRAIN_GARDEN(JI) .NE. XUNDEF) THEN
   DGCT%CUR%XDRAINC_GARDEN(JI)    =  DGCT%CUR%XDRAINC_GARDEN(JI)    + DGMT%CUR%XDRAIN_GARDEN(JI)     * PTSTEP
 ENDIF
 !
 IF (DGMT%CUR%XIRRIG_GARDEN(JI) .NE. XUNDEF) THEN
   DGCT%CUR%XIRRIGC_GARDEN(JI)    =  DGCT%CUR%XIRRIGC_GARDEN(JI)    + DGMT%CUR%XIRRIG_GARDEN(JI)     * PTSTEP
 ENDIF
 !
 IF (DGMT%CUR%XIRRIG_ROAD(JI) .NE. XUNDEF) THEN
   DGCT%CUR%XIRRIGC_ROAD(JI)      =  DGCT%CUR%XIRRIGC_ROAD(JI)      + DGMT%CUR%XIRRIG_ROAD(JI)       * PTSTEP
 ENDIF
 !
 IF (TOP%LGREENROOF) THEN 
    IF (DGMT%CUR%XRUNOFF_GREENROOF(JI) .NE. XUNDEF) THEN
     DGCT%CUR%XRUNOFFC_GREENROOF(JI) =  DGCT%CUR%XRUNOFFC_GREENROOF(JI)+ DGMT%CUR%XRUNOFF_GREENROOF(JI) * PTSTEP
    ENDIF
    !
    IF (DGMT%CUR%XDRAIN_GREENROOF(JI) .NE. XUNDEF) THEN
     DGCT%CUR%XDRAINC_GREENROOF(JI)  =  DGCT%CUR%XDRAINC_GREENROOF(JI) + DGMT%CUR%XDRAIN_GREENROOF(JI)  * PTSTEP
    ENDIF
    !
    IF (DGMT%CUR%XIRRIG_GREENROOF(JI) .NE. XUNDEF) THEN
     DGCT%CUR%XIRRIGC_GREENROOF(JI)  =  DGCT%CUR%XIRRIGC_GREENROOF(JI) + DGMT%CUR%XIRRIG_GREENROOF(JI)  * PTSTEP
    ENDIF
 ENDIF
 IF (TOP%LURBHYDRO) THEN
    IF (DGMT%CUR%XRUNOFF_SEWER(JI) .NE. XUNDEF) THEN
     DGCT%CUR%XRUNOFFC_SEWER(JI)      =  DGCT%CUR%XRUNOFFC_SEWER(JI)      + DGMT%CUR%XRUNOFF_SEWER(JI)       * PTSTEP
    ENDIF
! for water budget *** KC ***
    IF (DGMT%CUR%XRUNOFF_TOWN(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XRUNOFF_TOWNB(JI)      =  DGMT%CUR%XRUNOFF_TOWNB(JI)     + DGMT%CUR%XRUNOFF_TOWN(JI)      * PTSTEP
    ENDIF
 !
    IF (DGMT%CUR%XRUNOFF_GARDEN(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XRUNOFF_GARDENB(JI)    =  DGMT%CUR%XRUNOFF_GARDENB(JI)   + DGMT%CUR%XRUNOFF_GARDEN(JI)    * PTSTEP
    ENDIF
 !
    IF (DGMT%CUR%XDRAIN_GARDEN(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XDRAIN_GARDENB(JI)    =  DGMT%CUR%XDRAIN_GARDENB(JI)   + DGMT%CUR%XDRAIN_GARDEN(JI)    * PTSTEP
    ENDIF
 !
    IF (DGMT%CUR%XRUNOFF_ROAD(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XRUNOFF_ROADB(JI)      =  DGMT%CUR%XRUNOFF_ROADB(JI)     + DGMT%CUR%XRUNOFF_ROAD(JI)      * PTSTEP
    ENDIF
    !
    IF (DGMT%CUR%XDRAIN_ROAD(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XDRAIN_ROADB(JI)      =  DGMT%CUR%XDRAIN_ROADB(JI)     + DGMT%CUR%XDRAIN_ROAD(JI)      * PTSTEP
    ENDIF
   !
    IF (DGMT%CUR%XDRAIN_BLD(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XDRAIN_BLDB(JI)      =  DGMT%CUR%XDRAIN_BLDB(JI)     + DGMT%CUR%XDRAIN_BLD(JI)      * PTSTEP
    ENDIF
   !
    IF (DGMT%CUR%XRUNOFF_ROOF(JI) .NE. XUNDEF) THEN 
     DGMT%CUR%XRUNOFF_ROOFB(JI)      =  DGMT%CUR%XRUNOFF_ROOFB(JI)     + DGMT%CUR%XRUNOFF_ROOF(JI)      * PTSTEP
    ENDIF
    !
    IF (DGMT%CUR%XRUNOFF_STRLROOF(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XRUNOFF_STRLROOFB(JI)  =  DGMT%CUR%XRUNOFF_STRLROOFB(JI) + DGMT%CUR%XRUNOFF_STRLROOF(JI)  * PTSTEP
    ENDIF
    !
    IF (DGMT%CUR%XRUNOFF_GREENROOF(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XRUNOFF_GREENROOFB(JI)  =  DGMT%CUR%XRUNOFF_GREENROOFB(JI) + DGMT%CUR%XRUNOFF_GREENROOF(JI)  * PTSTEP
    ENDIF
    !
    IF (DGMT%CUR%XRUNOFF_SEWER(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XRUNOFF_SEWERB(JI)      =  DGMT%CUR%XRUNOFF_SEWERB(JI)      + DGMT%CUR%XRUNOFF_SEWER(JI)       * PTSTEP
    ENDIF
    IF (DGMT%CUR%XLE_STRLROOF(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XLE_STRLROOFB(JI)      =  DGMT%CUR%XLE_STRLROOFB(JI)      + DGMT%CUR%XLE_STRLROOF(JI)       * PTSTEP
    ENDIF
    IF (DGMT%CUR%XLE_GREENROOF(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XLE_GREENROOFB(JI)      =  DGMT%CUR%XLE_GREENROOFB(JI)      + DGMT%CUR%XLE_GREENROOF(JI)       * PTSTEP
    ENDIF
    IF (DGMT%CUR%XLE_ROAD(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XLE_ROADB(JI)      =  DGMT%CUR%XLE_ROADB(JI)      + DGMT%CUR%XLE_ROAD(JI)       * PTSTEP
    ENDIF
    IF (DGMT%CUR%XLE_GARDEN(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XLE_GARDENB(JI)      =  DGMT%CUR%XLE_GARDENB(JI)      + DGMT%CUR%XLE_GARDEN(JI)       * PTSTEP
    ENDIF
    IF (PRAIN(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XRAINB(JI)      =  DGMT%CUR%XRAINB(JI)      + PRAIN(JI)  * PTSTEP
    ENDIF
    IF (PSNOW(JI) .NE. XUNDEF) THEN
     DGMT%CUR%XSNOWB(JI)      =  DGMT%CUR%XSNOWB(JI)      + PSNOW(JI)       * PTSTEP
    ENDIF
 ENDIF
 !***
ENDDO

 IF (TOP%CBEM == 'BEM') THEN
    CALL CALC_CUMUL_DIAG(DGCT%CUR%XHVACC_HEAT_ELEC, DGMT%CUR%XHVAC_HEAT_ELEC, PTSTEP)
    CALL CALC_CUMUL_DIAG(DGCT%CUR%XHVACC_HEAT_GAS,  DGMT%CUR%XHVAC_HEAT_GAS,  PTSTEP)
    CALL CALC_CUMUL_DIAG(DGCT%CUR%XHVACC_HEAT_FUEL, DGMT%CUR%XHVAC_HEAT_FUEL, PTSTEP)
    CALL CALC_CUMUL_DIAG(DGCT%CUR%XHVACC_HEAT_OTHER,DGMT%CUR%XHVAC_HEAT_OTHER,PTSTEP)
    !
    CALL CALC_CUMUL_DIAG(DGCT%CUR%XHOTWATC,DGMT%CUR%XHOTWAT,PTSTEP)
    CALL CALC_CUMUL_DIAG(DGCT%CUR%XHOTWATC_GAS,DGMT%CUR%XHOTWAT_GAS,PTSTEP)
    CALL CALC_CUMUL_DIAG(DGCT%CUR%XHOTWATC_ELEC,DGMT%CUR%XHOTWAT_ELEC,PTSTEP)
 ENDIF

IF (LHOOK) CALL DR_HOOK('CUMUL_DIAG_TEB_N',1,ZHOOK_HANDLE)

CONTAINS

SUBROUTINE CALC_CUMUL_DIAG(PDIAGC, PDIAG, PTSTEP)
IMPLICIT NONE
 REAL, DIMENSION (:), INTENT(INOUT) :: PDIAGC !cumulated diagnostic
 REAL, DIMENSION (:), INTENT(IN) :: PDIAG  !diagnostic
 REAL            , INTENT(IN) :: PTSTEP !time step

   WHERE(PDIAG .NE. XUNDEF)
      PDIAGC=PDIAGC+PDIAG*PTSTEP
   END WHERE
END SUBROUTINE
!
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE CUMUL_DIAG_TEB_n
