!     #########
      SUBROUTINE CONVERT_PATCH_TEB_FOR_ROAD (HPROGRAM, BDD, DTCO, DTT, TOP,      &
                                             PCOVER,OCOVER, PDEPTH_ROAD)
!     ##############################################################
!
!!**** *CONVERT_PATCH_TEB_FOR_ROAD* compilation of conver_cover_isba, pgd_isba_par and
!!      init_from_data_isba_parn
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    S. Faroux        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    16/11/10
!!    G. Pigeon           09/12: add ROUGH_ROOF and ROUGH_WALL coef for outdoor conv. coef
!!    V. Masson           08/13: adds solar panels
!!    E. Redon/A. Lemonsu 01/16: add street trees
!!    K.Chancibault/A.Lemonsu 01/16: add urban hydrology
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_DATA_COVER_n,      ONLY : DATA_COVER_t
USE MODD_DATA_TEB_n,        ONLY : DATA_TEB_t
USE MODD_TEB_OPTION_n,      ONLY : TEB_OPTIONS_t
!
USE MODD_SURF_PAR,          ONLY : XUNDEF
!
USE MODD_DATA_COVER_PAR, ONLY : NDATA_ROAD_LAYER
USE MODD_DATA_COVER,     ONLY : XDATA_D_ROAD
!
USE MODI_INI_DATA_PARAM_TEB
USE MODI_AV_PGD
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_ABOR1_SFX
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(BLD_DESC_t),    INTENT(INOUT) :: BDD
TYPE(DATA_COVER_t),  INTENT(INOUT) :: DTCO
TYPE(DATA_TEB_t),    INTENT(INOUT) :: DTT
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
CHARACTER(LEN=6), INTENT(IN)       :: HPROGRAM  ! program calling surf. schemes
REAL, DIMENSION(:,:),  INTENT(IN)  :: PCOVER
LOGICAL, DIMENSION(:), INTENT(IN)  :: OCOVER
!
REAL, DIMENSION(:),    INTENT(OUT) :: PDEPTH_ROAD
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
REAL, DIMENSION(:,:), ALLOCATABLE :: ZD
INTEGER               :: JLAYER    ! loop counter on layers
INTEGER               :: IL        ! number of points
!
 CHARACTER(LEN=3)      :: YAVG      ! Type of averaging for buildings
 CHARACTER(LEN=4)      :: YAREA     ! Area where parameter is averaged
!
!*    0.3    Declaration of namelists
!            ------------------------
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*    1.      Initializations
!             ---------------
!
IF (LHOOK) CALL DR_HOOK('CONVERT_PATCH_TEB_FOR_ROAD',0,ZHOOK_HANDLE)
!
IF (TOP%CBLD_ATYPE=='ARI') THEN
  YAVG=TOP%CBLD_ATYPE
  YAREA='BLD'
ELSE
  YAVG=TOP%CBLD_ATYPE
  YAREA='BLV'
END IF
!
IL = SIZE(PCOVER,1)
!-------------------------------------------------------------------------------
!
!      HC_ROAD, TC_ROAD, D_ROAD
!      ------------------------
!
IF (DTT%LDATA_HC_ROAD) THEN
  ALLOCATE(ZD(IL,DTT%NPAR_ROAD_LAYER))
  ZD =DTT%XPAR_D_ROAD
ELSEIF (DTT%LDATA_BLDTYPE) THEN
  ALLOCATE(ZD(IL,BDD%NDESC_ROAD_LAYER))
  CALL INI_DATA_PARAM_TEB(HPROGRAM,BDD,DTT,DTT%NPAR_BLDCODE,PD_ROAD=ZD)
ELSE
  ALLOCATE(ZD(IL,NDATA_ROAD_LAYER))
  DO JLAYER=1,NDATA_ROAD_LAYER
    CALL AV_PGD(DTCO,ZD(:,JLAYER),PCOVER ,XDATA_D_ROAD(:,JLAYER),YAREA,YAVG,OCOVER)
  ENDDO
ENDIF  
PDEPTH_ROAD(:) = SUM(ZD(:,:),DIM=2)
!
!
IF (LHOOK) CALL DR_HOOK('CONVERT_PATCH_TEB_FOR_ROAD',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE CONVERT_PATCH_TEB_FOR_ROAD
