!     #########
      SUBROUTINE AVERAGED_ALBEDO_TEB(HBEM, HROAD_DIR, HWALL_OPT,     &
                       PZENITH, PAZIM,                               &
                       PBLD, PGARDEN, PROAD_DIR, PROAD, PFRAC_GR,    &
                       PFRAC_HVEG,                                   &
                       PTRANS_HVCR, PTRANS_HVEG,                     &
                       PFRAC_PANEL, PALB_PANEL,                      &
                       PWALL_O_HOR, PCAN_HW_RATIO, PBLD_HEIGHT,      &
                       PALB_ROOF,                                    &
                       PALB_ROAD, PSVF_RS, PSVF_RW, PSVF_RT,         &
                       PALB_WALL, PSVF_WS, PSVF_WR, PSVF_WW, PSVF_WT,&
                       PALB_GARDEN, PALB_HVEG,                       &
                       PSVF_TS, PSVF_TR, PSVF_TW,                    &
                       PH_TREE,                                      &
                       PTAU_SR, PTAU_SW, PTAU_WW, PTAU_WR,           &
                       PSVF_SR, PSVF_SW, PSVF_ST,                    &
                       PALB_GREENROOF,                               &
                       TSNOW_ROOF, TSNOW_ROAD,                       &
                       PGR, PSHGC, PSHGC_SH, PABS_WIN, PALB_WIN,     &
                       PDIR_ALB_TOWN, PSCA_ALB_TOWN, PTRAN_WIN,      &
                       PWIN_SW_MAX, PSHADEARCHI                      )
!     ###################################################
!
!!**** *AVERAGED_ALBEDO_TEB* computes averaged albedo for TEB scheme
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    V. Masson        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    01/2004
!!    C. de Munck & A. Lemonsu   09/2011 Greenroofs
!!    G. Pigeon                  09/2012 PTRAN_WIN as arguments
!!    E.Redon/A.Lemonsu          01/2014 New arguments for urban trees
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
USE MODD_SURF_PAR, ONLY : XUNDEF
USE MODD_TYPE_SNOW
!
USE MODI_URBAN_SOLAR_ABS
USE MODE_SURF_SNOW_FRAC
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
 CHARACTER(LEN=3),   INTENT(IN) :: HBEM          ! Building Energy model 'DEF' or 'BEM'
 CHARACTER(LEN=4),   INTENT(IN) :: HROAD_DIR     ! road direction options
              ! 'UNIF' : classical TEB version, all roads uniformely present
              ! 'ORIE' : specified road ORIEntation 
              !          (in fact many roads  direction
              !          possible because there can be many TEB patches)
 CHARACTER(LEN=4),   INTENT(IN) :: HWALL_OPT     ! wall options
              ! 'UNIF' : classical TEB version, all walls are uniform
              ! 'TWO ' : the two opposite walls receive different solar energy
REAL, DIMENSION(:), INTENT(IN) :: PZENITH       ! zenithal solar angle
REAL, DIMENSION(:), INTENT(IN) :: PAZIM         ! solar azimuthal angle
!                                               ! (radian from N, clockwise)
!
REAL, DIMENSION(:), INTENT(IN) :: PBLD          ! building fraction
REAL, DIMENSION(:), INTENT(IN) :: PGARDEN       ! green area fraction
REAL, DIMENSION(:), INTENT(IN) :: PROAD_DIR     ! Road direction
                                                ! (deg from N, clockwise)
REAL, DIMENSION(:), INTENT(IN) :: PROAD         ! road fraction
REAL, DIMENSION(:), INTENT(IN) :: PFRAC_GR      ! fraction of greenroof
REAL, DIMENSION(:), INTENT(IN) :: PFRAC_HVEG    ! fraction of high vegetation
REAL, DIMENSION(:), INTENT(IN) :: PTRANS_HVCR   ! transmissivity for all crown of high veg
REAL, DIMENSION(:,:),INTENT(IN):: PTRANS_HVEG   ! transmissivity profile
REAL, DIMENSION(:), INTENT(IN) :: PFRAC_PANEL   ! fraction of solar panels
REAL, DIMENSION(:), INTENT(IN) :: PALB_PANEL    ! albedo   of solar panels
REAL, DIMENSION(:), INTENT(IN) :: PWALL_O_HOR   ! vertical surf. / horizontal surf.
REAL, DIMENSION(:), INTENT(IN) :: PSVF_RS       ! sky-view-factor from roads
REAL, DIMENSION(:), INTENT(IN) :: PSVF_WS       ! sky-view-factor from walls
REAL, DIMENSION(:), INTENT(IN) :: PSVF_TS       ! sky-view-factor of high veg
REAL, DIMENSION(:), INTENT(IN) :: PCAN_HW_RATIO ! canyon height/width ratio
REAL, DIMENSION(:), INTENT(IN)  :: PBLD_HEIGHT   ! building height (m)
!
REAL, DIMENSION(:), INTENT(IN) :: PALB_ROOF     ! roof albedo
REAL, DIMENSION(:), INTENT(IN) :: PALB_ROAD     ! road albedo
REAL, DIMENSION(:), INTENT(IN) :: PALB_WALL     ! wall albedo
REAL, DIMENSION(:), INTENT(IN) :: PALB_GARDEN   ! green areas albedo
REAL, DIMENSION(:), INTENT(IN) :: PALB_GREENROOF! green roof albedo
TYPE(SURF_SNOW),    INTENT(IN) :: TSNOW_ROOF    ! snow on roofs
TYPE(SURF_SNOW),    INTENT(IN) :: TSNOW_ROAD    ! snow on roads
!
REAL, DIMENSION(:), INTENT(IN) :: PSVF_RW       ! view-factor of walls from road
REAL, DIMENSION(:), INTENT(IN) :: PSVF_RT       ! view factor of high veg from road
REAL, DIMENSION(:), INTENT(IN) :: PSVF_WR       ! view factor of road from walls
REAL, DIMENSION(:), INTENT(IN) :: PSVF_WW       ! view factor of wall from wall
REAL, DIMENSION(:), INTENT(IN) :: PSVF_WT       ! view factor of high veg from walls
REAL, DIMENSION(:), INTENT(IN) :: PSVF_TR       ! view-factor of road from high veg
REAL, DIMENSION(:), INTENT(IN) :: PSVF_TW       ! view factor of walls from high veg
REAL, DIMENSION(:), INTENT(IN) :: PALB_HVEG     ! high vegetation albedo
REAL, DIMENSION(:), INTENT(IN) :: PH_TREE       ! height of trees (m)
REAL, DIMENSION(:), INTENT(IN) :: PTAU_SR       ! transmissivity term of radiation S=>R or G by high veg 
REAL, DIMENSION(:), INTENT(IN) :: PTAU_SW       ! transmissivity term of radiation S=>W by high veg 
REAL, DIMENSION(:), INTENT(IN) :: PTAU_WW       ! transmissivity term of radiation W=>W by high veg 
REAL, DIMENSION(:), INTENT(IN) :: PTAU_WR       ! transmissivity term of radiation W=>Rb y high veg 
REAL, DIMENSION(:), INTENT(IN) :: PSVF_SR       ! view-factor of roads from sky
REAL, DIMENSION(:), INTENT(IN) :: PSVF_SW       ! view-factor of walls from sky
REAL, DIMENSION(:), INTENT(IN) :: PSVF_ST       ! view-factor of high veg from sky
!
REAL, DIMENSION(:), INTENT(IN) :: PGR           ! Glazing ratio
REAL, DIMENSION(:), INTENT(IN) :: PSHGC         ! Window solar transmittance
REAL, DIMENSION(:), INTENT(IN) :: PSHGC_SH      ! Window + shading solar heat gain coef.
!
REAL, DIMENSION(:), INTENT(IN) :: PABS_WIN      ! Window solar absortance
REAL, DIMENSION(:), INTENT(OUT):: PALB_WIN      ! Window solar reflectance
REAL, DIMENSION(:), INTENT(IN) :: PWIN_SW_MAX   !
REAL, DIMENSION(:), INTENT(IN) :: PSHADEARCHI   !
!
REAL, DIMENSION(:), INTENT(OUT):: PDIR_ALB_TOWN ! direct albedo
REAL, DIMENSION(:), INTENT(OUT):: PSCA_ALB_TOWN ! diffuse albedo
REAL, DIMENSION(:), INTENT(IN) :: PTRAN_WIN     ! window transmittance
!
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
REAL, DIMENSION(SIZE(PBLD)) :: ZDN_ROOF       ! snow fraction 
REAL, DIMENSION(SIZE(PBLD)) :: ZDN_ROAD       ! on the surface
REAL, DIMENSION(SIZE(PBLD)) :: ZDF_ROOF       ! free-snow fraction 
REAL, DIMENSION(SIZE(PBLD)) :: ZDF_ROAD       ! on the surface
LOGICAL, DIMENSION(SIZE(PBLD)) :: GMASK       ! .false. (= no snow precip.)
!
!
REAL, DIMENSION(SIZE(PBLD)) :: ZDIR_SW        ! direct and diffuse shortwave radiation
REAL, DIMENSION(SIZE(PBLD)) :: ZSCA_SW        ! to mimic radiation behaviour of town
!
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_WALL_A     ! shortwave absorbed by walls
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_WALL_B     ! shortwave absorbed by walls
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_ROAD       ! shortwave absorbed by roads
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_SKY        ! shortwave absorbed by sky
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_ROOF       ! shortwave absorbed by roofs
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_GARDEN     ! shortwave absorbed by green areas
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_HVEG       ! shortwave absorbed by high veg
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_GREENROOF  ! shortwave absorbed by green roofs
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_SNOW_ROAD  ! shortwave absorbed by snow
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_SNOW_ROOF  ! on roads, roofs,
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_PANEL      ! shortwave absorbed by solar panels
!
REAL, DIMENSION(SIZE(PBLD)) :: ZREC_SW_ROAD       ! shortwave received by roads
REAL, DIMENSION(SIZE(PBLD)) :: ZREC_SW_WALL_A     ! shortwave received by walls
REAL, DIMENSION(SIZE(PBLD)) :: ZREC_SW_WALL_B     ! shortwave received by walls
REAL, DIMENSION(SIZE(PBLD)) :: ZREC_SW_GARDEN     ! shortwave received by green areas
REAL, DIMENSION(SIZE(PBLD)) :: ZREC_SW_HVEG       ! shortwave received by high veg
REAL, DIMENSION(SIZE(PBLD)) :: ZREC_SW_SNOW_ROAD  ! shortwave received by snow on roads
REAL, DIMENSION(SIZE(PBLD)) :: ZREC_SW_ROOF       ! shortwave received by roofs
!
REAL, DIMENSION(SIZE(PBLD)) :: ZSW_RAD_GARDEN ! total solar radiation reaching green areas
REAL, DIMENSION(SIZE(PBLD)) :: ZABS_SW_WIN       ! shortwave absorbed by walls
REAL, DIMENSION(SIZE(PBLD)) :: ZREC_SW_WIN       ! shortwave received by walls
REAL, DIMENSION(SIZE(PBLD)) :: ZREF_SW_GRND      !
REAL, DIMENSION(SIZE(PBLD)) :: ZREF_SW_FAC       !
REAL, DIMENSION(SIZE(PBLD)) :: ZREF_SW_HVEG      !
!
REAL, DIMENSION(SIZE(PBLD),1) :: ZTR_SW_WIN        !
REAL, DIMENSION(SIZE(PBLD))   :: ZE_SHADING        !
REAL, DIMENSION(SIZE(PBLD),1) :: ZAUXSHAD_BEHAV_ANYWAY
REAL, DIMENSION(SIZE(PBLD),1) :: ZAUXSHAD_BEHAV_ADAPTI
REAL, DIMENSION(SIZE(PBLD),1) :: ZAUXTI_BLD
REAL, DIMENSION(SIZE(PBLD))   :: ZAUXTDESV
REAL, DIMENSION(SIZE(PBLD))   :: ZAUX_ROAD_SHADE
REAL, DIMENSION(SIZE(PBLD),1) :: ZAUXEFF_SHAD
REAL, DIMENSION(SIZE(PBLD),1) :: ZFRABEMCOMP
!
!new local variables for diagnostics (received direct / scattered SR)
REAL, DIMENSION(SIZE(PBLD)) :: ZDIR_SW_ROAD
REAL, DIMENSION(SIZE(PBLD)) :: ZSCA_SW_ROAD  
REAL, DIMENSION(SIZE(PBLD)) :: ZDIR_SW_WALL
REAL, DIMENSION(SIZE(PBLD)) :: ZDIR_SW_WALL_A
REAL, DIMENSION(SIZE(PBLD)) :: ZDIR_SW_WALL_B
REAL, DIMENSION(SIZE(PBLD)) :: ZSCA_SW_WALL
REAL, DIMENSION(SIZE(PBLD)) :: ZDIR_SW_GARDEN
REAL, DIMENSION(SIZE(PBLD)) :: ZSCA_SW_GARDEN
REAL, DIMENSION(SIZE(PBLD)) :: ZDIR_SW_HVEG
REAL, DIMENSION(SIZE(PBLD)) :: ZNTR_DIR_SW_HVEG
REAL, DIMENSION(SIZE(PBLD)) :: ZSCA_SW_HVEG
REAL, DIMENSION(SIZE(PBLD)) :: ZSW_UP_ROOF
REAL, DIMENSION(SIZE(PBLD)) :: ZSW_UP_CAN
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
!* snow fractions
!  --------------
!
IF (LHOOK) CALL DR_HOOK('AVERAGED_ALBEDO_TEB',0,ZHOOK_HANDLE)
GMASK(:) = .FALSE.
 CALL SNOW_FRAC_ROAD(TSNOW_ROAD%WSNOW(:,1,1),GMASK,ZDN_ROAD,ZDF_ROAD)
 CALL SNOW_FRAC_ROOF(TSNOW_ROOF%WSNOW(:,1,1),GMASK,ZDN_ROOF,ZDF_ROOF)
!
!
!* town  direct and diffuse albedo
!  -------------------------------
!
ZDIR_SW=1.
ZSCA_SW=1.
!
ZAUXSHAD_BEHAV_ANYWAY(:,:) = 0.0
ZAUXSHAD_BEHAV_ADAPTI(:,:) = 0.0
ZAUXTI_BLD(:,:)     = 19.0 + 273.16
ZAUXTDESV(:)        = 23.0 + 273.16
ZFRABEMCOMP(:,:)    = 0.0
!
 CALL URBAN_SOLAR_ABS(HBEM, HROAD_DIR, HWALL_OPT,                   &
                     ZDIR_SW, ZSCA_SW, PZENITH, PAZIM,             &
                     PBLD, PGARDEN, PROAD_DIR, PROAD, PFRAC_GR,    &
                     PFRAC_HVEG, PTRANS_HVCR,                      &
                     PWALL_O_HOR, PCAN_HW_RATIO, PBLD_HEIGHT,      &
                     PALB_ROOF,                                    &
                     PALB_ROAD, PSVF_RS, PSVF_RW, PSVF_RT,         &
                     PALB_WALL, PSVF_WS, PSVF_WR, PSVF_WW, PSVF_WT,&
                     PFRAC_PANEL, PALB_PANEL,                      &
                     PALB_GARDEN, PALB_HVEG,                       &
                     PSVF_TS, PSVF_TR, PSVF_TW,                    &
                     PH_TREE,                                      &
                     PTAU_SR, PTAU_SW, PTAU_WW, PTAU_WR,           &
                     PSVF_SR, PSVF_SW, PSVF_ST,                    &
                     PALB_GREENROOF,                               &
                     TSNOW_ROOF%ALB(:,1), TSNOW_ROAD%ALB(:,1),     &
                     ZDN_ROOF, ZDF_ROOF, ZDN_ROAD, ZDF_ROAD,       &
                     PGR, PABS_WIN, PSHGC_SH, PALB_WIN,            &
                     ZABS_SW_SKY, ZABS_SW_ROOF, ZABS_SW_ROAD,      &
                     ZABS_SW_WALL_A, ZABS_SW_WALL_B,               &
                     ZABS_SW_GARDEN, ZABS_SW_HVEG,                 &
                     ZABS_SW_GREENROOF,                            &
                     ZABS_SW_SNOW_ROOF, ZABS_SW_SNOW_ROAD,         &
                     ZABS_SW_PANEL,                                &
                     ZREC_SW_ROAD,  ZREC_SW_SNOW_ROAD,             &
                     ZREC_SW_WALL_A, ZREC_SW_WALL_B,               &
                     ZREC_SW_GARDEN, ZREC_SW_HVEG,                 &
                     ZREC_SW_ROOF,                                 &
                     PDIR_ALB_TOWN, PSCA_ALB_TOWN,                 &
                     ZSW_RAD_GARDEN, ZABS_SW_WIN, ZREC_SW_WIN,     &
                     PTRAN_WIN,                                    &
                     ZREF_SW_GRND, ZREF_SW_FAC, ZTR_SW_WIN,        &
                     ZREF_SW_HVEG,                                 &
                     ZDIR_SW_ROAD,                                 &
                     ZDIR_SW_WALL, ZDIR_SW_WALL_A, ZDIR_SW_WALL_B, &
                     ZDIR_SW_GARDEN, ZDIR_SW_HVEG,ZNTR_DIR_SW_HVEG,&
                     ZSCA_SW_ROAD,                                 &
                     ZSCA_SW_WALL,                                 &
                     ZSCA_SW_GARDEN, ZSCA_SW_HVEG,                 &
                     ZSW_UP_ROOF, ZSW_UP_CAN,                      &
                     ZE_SHADING, PWIN_SW_MAX,ZFRABEMCOMP,          &
                     PSHADEARCHI, ZAUXSHAD_BEHAV_ANYWAY,           &
                     ZAUXSHAD_BEHAV_ADAPTI, ZAUXTI_BLD, ZAUXTDESV, &
                     ZAUXEFF_SHAD, ZAUX_ROAD_SHADE                 )
!
IF (LHOOK) CALL DR_HOOK('AVERAGED_ALBEDO_TEB',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE AVERAGED_ALBEDO_TEB
