!     #########
    SUBROUTINE ALLOCATE_TEB_GARDEN_PGD (TGDPE, TGDP, THP,                         &
                                        OALLOC,KLU,KVEGTYPE,KGROUND_LAYER, KDIMTAB)  
!   ##########################################################################
!
!
!
!
USE MODD_TEB_GARDEN_PGD_EVOL_n, ONLY : TEB_GARDEN_PGD_EVOL_t
USE MODD_TEB_GARDEN_PGD_n, ONLY : TEB_GARDEN_PGD_t
USE MODD_TEB_HYDRO_PGD_n, ONLY : TEB_HYDRO_PGD_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!
TYPE(TEB_GARDEN_PGD_EVOL_t), INTENT(INOUT) :: TGDPE
TYPE(TEB_GARDEN_PGD_t), INTENT(INOUT) :: TGDP
TYPE(TEB_HYDRO_PGD_t), INTENT(INOUT) :: THP
!
LOGICAL, INTENT(IN) :: OALLOC ! True if constant PGD fields must be allocated
INTEGER, INTENT(IN) :: KLU
INTEGER, INTENT(IN) :: KVEGTYPE
INTEGER, INTENT(IN) :: KGROUND_LAYER
INTEGER, INTENT(IN) :: KDIMTAB
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!
IF (LHOOK) CALL DR_HOOK('ALLOCATE_TEB_GARDEN_PGD',0,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
! - Physiographic field that can evolve prognostically
!
ALLOCATE(TGDPE%CUR%XLAI                    (KLU                     ))
ALLOCATE(TGDPE%CUR%XVEG                    (KLU                     )) 
ALLOCATE(TGDPE%CUR%XEMIS                   (KLU                     )) 
ALLOCATE(TGDPE%CUR%XZ0                     (KLU                     )) 
!
! - vegetation:
!
ALLOCATE(TGDP%XALBNIR_VEG             (KLU                     )) 
ALLOCATE(TGDP%XALBVIS_VEG             (KLU                     )) 
ALLOCATE(TGDP%XALBUV_VEG              (KLU                     )) 
!
IF (.NOT. OALLOC) THEN
  IF (LHOOK) CALL DR_HOOK('ALLOCATE_TEB_GARDEN_PGD',1,ZHOOK_HANDLE)
  RETURN
END IF
!-------------------------------------------------------------------------------
!
! Mask and number of grid elements containing tiles:
ALLOCATE(TGDP%XVEGTYPE                (KLU,KVEGTYPE            ))
!
!-------------------------------------------------------------------------------
!
! Input Parameters:
!
! - vegetation + bare soil:
!
ALLOCATE(TGDP%XZ0_O_Z0H               (KLU                     )) 

!
! - vegetation: default option (Jarvis) and general parameters:
!
ALLOCATE(TGDP%XWRMAX_CF               (KLU                     )) 
ALLOCATE(TGDP%XGAMMA                  (KLU                     )) 
ALLOCATE(TGDP%XCV                     (KLU                     )) 
ALLOCATE(TGDP%XRGL                    (KLU                     )) 
ALLOCATE(TGDP%XRSMIN                  (KLU                     )) 
ALLOCATE(TGDP%XROOTFRAC               (KLU,KGROUND_LAYER       ))
ALLOCATE(TGDP%NWG_LAYER               (KLU                     ))
ALLOCATE(TGDP%XDROOT                  (KLU                     ))
ALLOCATE(TGDP%XDG2                    (KLU                     ))
!
!-------------------------------------------------------------------------------
!
! - vegetation: Ags parameters ('AGS', 'LAI', 'AST', 'LST', 'NIT' options)
!
ALLOCATE(TGDP%XBSLAI                  (KLU                     )) 
ALLOCATE(TGDP%XLAIMIN                 (KLU                     )) 
ALLOCATE(TGDP%XSEFOLD                 (KLU                     )) 
ALLOCATE(TGDP%XH_TREE                 (KLU                     )) 
ALLOCATE(TGDP%XANF                    (KLU                     )) 
ALLOCATE(TGDP%XGMES                   (KLU                     ))
ALLOCATE(TGDP%XRE25                   (KLU                     ))
!
!-------------------------------------------------------------------------------
!
! - vegetation: Ags Stress parameters ('AST', 'LST', 'NIT' options)
!
ALLOCATE(TGDP%LSTRESS                 (KLU                     )) 
ALLOCATE(TGDP%XF2I                    (KLU                     )) 
ALLOCATE(TGDP%XGC                     (KLU                     )) 
ALLOCATE(TGDP%XAH                     (KLU                     )) 
ALLOCATE(TGDP%XBH                     (KLU                     )) 
ALLOCATE(TGDP%XDMAX                   (KLU                     )) 
!
!-------------------------------------------------------------------------------
!
! - vegetation: Ags Nitrogen-model parameters ('NIT' option)
!
ALLOCATE(TGDP%XCE_NITRO               (KLU                     )) 
ALLOCATE(TGDP%XCF_NITRO               (KLU                     )) 
ALLOCATE(TGDP%XCNA_NITRO              (KLU                     )) 
!
!-------------------------------------------------------------------------------
!
! - soil: primary parameters
!
!ALLOCATE(TGDP%XSAND                   (KLU,KGROUND_LAYER       )) 
!ALLOCATE(TGDP%XCLAY                   (KLU,KGROUND_LAYER       )) 
ALLOCATE(TGDP%XRUNOFFB                (KLU                     )) 
ALLOCATE(TGDP%XWDRAIN                 (KLU                     )) 
ALLOCATE(TGDP%XGAMMAT                 (KLU                     )) 
ALLOCATE(TGDP%XDG                     (KLU,KGROUND_LAYER       )) 
ALLOCATE(TGDP%XRUNOFFD                (KLU                     )) 
!
!-------------------------------------------------------------------------------
!
! - SGH scheme
!                                   
ALLOCATE(TGDP%XD_ICE                  (KLU                     )) 
!
!-------------------------------------------------------------------------------
!
! - Street trees
!                                   
ALLOCATE(TGDP%XHTRUNK_HVEG            (KLU                     )) 
ALLOCATE(TGDP%XWCROWN_HVEG            (KLU                     )) 
ALLOCATE(TGDP%XH_LAI_MAX              (KLU                     )) 
ALLOCATE(TGDP%XLAI_HVEG               (KLU                     )) 
ALLOCATE(TGDP%XLAI_LVEG               (KLU                     )) 
ALLOCATE(TGDP%XALB_HVEG               (KLU                     )) 
ALLOCATE(TGDP%XALB_LVEG               (KLU                     )) 
!
!-------------------------------------------------------------------------------
!
! - Urban hydrology
!                                   
ALLOCATE(THP%XLSEWER                  (KLU                     )) 
ALLOCATE(THP%XLSTORM                  (KLU                     )) 
ALLOCATE(THP%XDSEWER                  (KLU                     )) 
!                                   
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('ALLOCATE_TEB_GARDEN_PGD',1,ZHOOK_HANDLE)
!
END SUBROUTINE ALLOCATE_TEB_GARDEN_PGD
