!MNH_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!MNH_LIC This is part of the Meso-NH software governed by the CeCILL-C licence
!MNH_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!MNH_LIC for details. version 1.
!-----------------------------------------------------------------
!--------------- special set of characters for RCS information
!-----------------------------------------------------------------
! $Source: /home/cvsroot/MNH-VX-Y-Z/src/MNH/set_mask.f90,v $ $Revision: 1.2.2.1.2.1.18.2 $
! MASDEV4_7 budget 2006/09/08 10:35:15
!-----------------------------------------------------------------
!     ###################
      SUBROUTINE SET_MASK
!     ###################
!
!!****SET_MASK** -routine to define the mask 
!!                           
!!
!!    PURPOSE
!!    -------
!       The purpose of this routine is to test the occurence or not of the
!     different criteria, used to compute the budgets. It also updates the 
!     number of occurence of the different criteria.
!
!!**  METHOD
!!    ------
!!      According to each criterion associated to one zone, the mask is
!!    set to TRUE at each point where the criterion is confirmed, at each 
!!    time step of the model. Finally, The number of occurence of this criteria is 
!!    increased by 1 and stored in the array XBUSURF. 
!!    Caution : The mask is defined on the inner domain.
!!      
!!
!!    EXTERNAL
!!    --------
!!       NONE
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!       Module MODD_BUDGET
!!         LBU_MASK   : logical array mask defining the zones
!!         NBUTIME    : number of the budget step
!!         XBUSURF    : mask tracer array (surface array) 
!!
!!    REFERENCE
!!    ---------
!!      Book2 of MESO-NH documentation (routine BUDGET)
!!
!!
!!    AUTHOR
!!    ------
!!	J. Nicolau       * Meteo France *
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    27/02/95
!!      Modification 10/11/97  (P.Jabouille) : computation made only in the inner domain
!!      Modification 18/06/99  (N.Asencio) : //  , computation are performed on the extended
!!                                           domain but logical array mask is initialized
!!                                           to FALSE outside the physical domain
!!                   02/02/2017 (J.Escobar & JPP ) bug for 1 model only <-> remove unneeded FIELD_MODEL%
!---------------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_BUDGET
USE MODE_ll
USE MODD_CST     , ONLY : XPI, XRADIUS
USE MODD_FIELD_n , ONLY : XWT, XRT
USE MODD_GRID_n  , ONLY : XLAT, XLON
!
IMPLICIT NONE
!  
!  
!*       0.2   Declarations of local variables :
!
INTEGER :: IIB,IJB ! Lower bounds of the physical sub-domain in x and y directions
INTEGER :: IIE,IJE ! Upper bounds of the physical sub-domain in x and y directions
INTEGER :: JJ      ! Loop index
!
REAL, DIMENSION(1:4)                       :: ZLAT_STAT ! Latitude of stations [°]
REAL, DIMENSION(1:4)                       :: ZLON_STAT ! Longitude of stations [°]
REAL                                       :: ZDISTSTAT ! Limit of distance to station [m]
REAL, DIMENSION(SIZE(XLAT,1),SIZE(XLON,2)) :: ZDIST     ! Distance of MNH grid point to station [m]
!
!-------------------------------------------------------------------------------
!
!*       1.    COMPUTES THE PHYSICAL SUBDOMAIN BOUNDS
!              ---------------------------------------
!
CALL GET_INDICE_ll(IIB,IJB,IIE,IJE)
!
!*	 2.     DEFINITION OF THE MASK
!               ----------------------
!  initialization to FALSE on the extended subdomain
!
LBU_MASK(:,:,:) = .FALSE.
!
! Initialisation of the station coordinates [°]
!
ZLAT_STAT(1) = 022.3350 ! KLT
ZLON_STAT(1) = 114.1847 ! KLT
!
ZLAT_STAT(2) = 022.3119 ! KP
ZLON_STAT(2) = 114.1728 ! KP
!
ZLAT_STAT(3) = 022.3019 ! HKO
ZLON_STAT(3) = 114.1742 ! HKO
!
ZLAT_STAT(4) = 022.2783 ! HKP
ZLON_STAT(4) = 114.1622 ! HKP
!
! The distance to the station to calculate the budgets [m]
!
ZDISTSTAT = 500.0
!
!  computing on the physical subdomain 
!==============================================================================
! Change the following lines to set the criterion for each of the NBUMASK masks
!
! The surroundings of the stations
!
DO JJ=1,SIZE(ZLAT_STAT)
   !
   ZDIST(:,:) = SQRT(((XLAT(:,:)-ZLAT_STAT(JJ))*XRADIUS*2*XPI/360)**2 + ((XLON(:,:)-ZLON_STAT(JJ))*COS(ZLAT_STAT(JJ))*XRADIUS*2*XPI/360)**2)
   LBU_MASK(IIB:IIE,IJB:IJE,JJ)=ZDIST(IIB:IIE,IJB:IJE).LE.ZDISTSTAT
   !
ENDDO
!
! Kowloon Peninsula
!
LBU_MASK(IIB:IIE,IJB:IJE,SIZE(ZLAT_STAT)+1) = &
   ( (XLAT(IIB:IIE,IJB:IJE).GE.022.3029) .AND. (XLAT(IIB:IIE,IJB:IJE).LE.022.3405) .AND. &
     (XLON(IIB:IIE,IJB:IJE).GE.114.1625) .AND. (XLON(IIB:IIE,IJB:IJE).LE.114.1859) )
!
! Hong Kong Island (west)
!
LBU_MASK(IIB:IIE,IJB:IJE,SIZE(ZLAT_STAT)+2) = &
  ( (XLAT(IIB:IIE,IJB:IJE).GE.022.2819) .AND. (XLAT(IIB:IIE,IJB:IJE).LE.022.2867) .AND. &
    (XLON(IIB:IIE,IJB:IJE).GE.114.1417) .AND. (XLON(IIB:IIE,IJB:IJE).LE.114.1526) )
!
! Hong Kong Island (east)
!
LBU_MASK(IIB:IIE,IJB:IJE,SIZE(ZLAT_STAT)+3) = &
  ( (XLAT(IIB:IIE,IJB:IJE).GE.022.2747) .AND. (XLAT(IIB:IIE,IJB:IJE).LE.022.2814) .AND. &
    (XLON(IIB:IIE,IJB:IJE).GE.114.1684) .AND. (XLON(IIB:IIE,IJB:IJE).LE.114.1842) )
!
!==============================================================================
!
!*	 3.     INCREASE IN SURFACE ARRAY
!               -------------------------
!
WHERE (LBU_MASK(:,:,:))
  XBUSURF(:,:,:,NBUTIME)=XBUSURF(:,:,:,NBUTIME)+1.
END WHERE
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE SET_MASK
