!MNH_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!MNH_LIC This is part of the Meso-NH software governed by the CeCILL-C licence
!MNH_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!MNH_LIC for details. version 1.
!-----------------------------------------------------------------
!--------------- special set of characters for RCS information
!-----------------------------------------------------------------
! $Source: /home/cvsroot/MNH-VX-Y-Z/src/MNH/ini_stationn.f90,v $ $Revision: 1.2.4.1.2.1.10.3.2.1 $
! MASDEV4_7 profiler 2006/05/18 13:07:25
!-----------------------------------------------------------------
!     #######################
      SUBROUTINE INI_STATION_n
!     #######################
!
!
!!****  *INI_STATION_n* - user initializes the station location
!!
!!    PURPOSE
!!    -------
!
!
!!**  METHOD
!!    ------
!!    
!!   Must be defined (for each aircraft):
!!   ---------------
!!
!!  No default exist for these variables.
!!  ************************************
!!
!!  1) Number of stations
!!  2) the model in which these stations are
!!     if NOT initialized, the stations are NOT used.
!!
!!  3) the (LAT, LON, ALT) latitude,longitude and altitude of the station location.
!!  4) the station name
!!
!!
!!
!!   Can be defined  (for each aircraft):
!!   --------------
!!
!!
!!  9) the time step for data storage.
!!    default is 60s
!!
!! 10) the name or title describing the balloon (8 characters)
!!     default is the balloon type (6 characters) + the balloon numbers (2 characters)
!!
!!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      Pierre Tulet             * Meteo-France *
!!
!!    MODIFICATIONS
!!    -------------
!!     Original 15/01/2002
!!     Modified 06/05/2015    C. de Munck for EUREQUA-TOULOUSE :  
!!                            stations fixes + CNRM + points parcours idealise
!!
!! --------------------------------------------------------------------------
!       
!*      0. DECLARATIONS
!          ------------
!
USE MODD_STATION_n
USE MODD_PARAMETERS
!
!
IMPLICIT NONE
!
!
!*      0.1  declarations of arguments
!
!
!-------------------------------------------------------------------------------
!
!       0.2  declaration of local variables
!
!
!----------------------------------------------------------------------------
!
!*      1.   Namelist 
!            ---------
!NUMBSTAT             = 175
NUMBSTAT             = 49 ! YT - HKO AWS
!
IF (NUMBSTAT > 0) THEN
ALLOCATE  (TSTATION%LAT(NUMBSTAT))
ALLOCATE  (TSTATION%LON(NUMBSTAT))
ALLOCATE  (TSTATION%I(NUMBSTAT))
ALLOCATE  (TSTATION%J(NUMBSTAT))
ALLOCATE  (TSTATION%Z(NUMBSTAT))
ALLOCATE  (TSTATION%K(NUMBSTAT))
ALLOCATE  (TSTATION%NAME(NUMBSTAT))
ALLOCATE  (TSTATION%TYPE(NUMBSTAT))
!
TSTATION%LON  = XUNDEF
TSTATION%LAT  = XUNDEF
TSTATION%Z    = XUNDEF
TSTATION%K    = XUNDEF
TSTATION%I    = XUNDEF
TSTATION%J    = XUNDEF
TSTATION%NAME = "        "
TSTATION%TYPE = "        "
!
TSTATION%STEP = 60.
!
!* location (latitude, longitude, altitude)
!
!***************************************************************
! * Horizontal location
! You have to choose between (TSTATION%LAT,TSTATION%LON) 
! or  (TSTATION%I,TSTATION%J) for all the stations 
! if both are defined it will choose (TSTATION%LAT,TSTATION%LON)
!***************************************************************
!
TSTATION%LAT = (/ 22.19750, 22.49330, 22.20111, 22.28889, 22.34806, &
                  22.54667, 22.28500, 22.30944, 22.30194, 22.27833, &
                  22.24778, 22.27056, 22.31583, 22.53639, 22.43278, &
                  22.33500, 22.31194, 22.37028, 22.31861, 22.22611, &
                  22.46889, 22.25861, 22.26333, 22.29111, 22.47528, &
                  22.30972, 22.43611, 22.40250, 22.37556, 22.28167, &
                  22.29111, 22.50194, 22.33583, 22.21417, 22.47139, &
                  22.35778, 22.52861, 22.41056, 22.44611, 22.38583, &
                  22.37556, 22.38361, 22.34417, 22.40278, 22.26417, &
                  22.18222, 22.46667, 22.33944, 22.44083 /)
!
TSTATION%LON = (/ 114.2119, 114.1050, 114.0267, 114.1558, 114.1092,  &
                  114.4283, 114.1128, 113.9219, 114.1742, 114.1622,  &
                  114.1736, 114.1836, 114.2556, 114.3019, 114.1208,  &
                  114.1847, 114.1728, 114.3125, 114.2247, 114.1086,  &
                  113.9836, 113.9128, 113.9111, 114.0433, 114.2375,  &
                  114.2078, 114.0847, 114.2100, 114.2744, 114.2361,  &
                  113.9069, 114.1111, 114.1369, 114.2186, 114.3606,  &
                  114.2178, 114.1567, 114.1217, 114.1789, 113.9642,  &
                  114.1267, 114.1078, 114.1100, 114.3231, 114.1550,  &
                  114.3033, 114.0089, 114.2053, 114.0183 /) 
!
!TSTATION%I                = (/ 25  /) 
!TSTATION%J                = (/ 20 /)
!
!***************************************************************
! * Vertical location
! You have to choose between TSTATION%K and TSTATION%Z
! for all the stations
! if both are defined it will choose TSTATION%K 
!***************************************************************
!
TSTATION%Z                  = (/ 94., 11., 72., 16., 122., &
                                 29., 88., 6., 32., 26., &
                                 5., 5., 38., 10., 307., &
                                 92., 65., 39., 90., 11., &
                                 31., 593., 747., 34., 51., &
                                 10., 16., 6., 4., 53., &
                                 61., 10., 11., 31., 15., &
                                 575., 15., 955., 15., 28., &
                                 35., 142., 8., 5., 406., &
                                 56., 4., 21., 8. /) 
!
!TSTATION%K   = (/ 10 /)              
!
!***************************************************************
!* station name
!***************************************************************
TSTATION%NAME = (/ 'BHD', 'BR1', 'CCH', 'CP1', 'CPH',                         &
                   'EPC', 'GI ', 'HKA', 'HKO', 'HKP',                         &
                   'HKS', 'HPV', 'JKB', 'KAT', 'KFB',                         &
                   'KLT', 'KP ', 'KSC', 'KTG', 'LAM',                         &
                   'LFS', 'NGP', 'NLS', 'PEN', 'PLC',                         &
                   'SE ', 'SEK', 'SHA', 'SKG', 'SKW',                         &
                   'SLW', 'SSH', 'SSP', 'STY', 'TAP',                         &
                   'TC ', 'TKL', 'TMS', 'TP ', 'TU1',                         &
                   'TW ', 'TWN', 'TY1', 'TYW', 'VP1',                         &
                   'WGL', 'WLP', 'WTS', 'YLP' /)
!
!***************************************************************
!* station type !YT - dummy types, did not change
!***************************************************************
TSTATION%TYPE        = (/ 'HKO', 'HKO', 'HKO', 'HKO', 'HKO', &
                          'HKO', 'HKO', 'HKO', 'HKO', 'HKO', &
                          'HKO', 'HKO', 'HKO', 'HKO', 'HKO', &
                          'HKO', 'HKO', 'HKO', 'HKO', 'HKO', &
                          'HKO', 'HKO', 'HKO', 'HKO', 'HKO', &
                          'HKO', 'HKO', 'HKO', 'HKO', 'HKO', &
                          'HKO', 'HKO', 'HKO', 'HKO', 'HKO', &
                          'HKO', 'HKO', 'HKO', 'HKO', 'HKO', &
                          'HKO', 'HKO', 'HKO', 'HKO', 'HKO', &
                          'HKO', 'HKO', 'HKO', 'HKO' /) 
!
!----------------------------------------------------------------------------
ENDIF
!
END SUBROUTINE INI_STATION_n
