#!/usr/bin/env python
#
import os
import time
import datetime
#
# Script to initialise MesoNH simulation
#
# #########################################################
# User input variables
# #########################################################
#
# The number of nests
#
lnest=5
#
# The optimisation level
#
optlevel="O3"
#
# The Model version
#
version="MODIFIED_HK_CECILE1"
cversion="MODIFIED_HK_CECILE1-"
#
# The year month and day of initialisation
#
yearini=2018
montini=5
dayyini=16
#
# The year month and day of the simulation end
#
yearend=2018
montend=6
dayyend=1
#
nodes=12
cpupertask=40
#
cputime="12:00:00"
#
# ##########################################################
# Define paths not depending of the scenario
# ##########################################################
#
path_ecmwf="../../../EXTRACT_ECMWF/"
pathtemp="../TEMPLATES/"
#
# #########################################################
# Define start and end date of the simulation
# #########################################################
#
sta_date = datetime.date(yearini,montini,dayyini)
end_date = datetime.date(yearend,montend,dayyend)
#
delta = datetime.timedelta(days=1)
end_datep1 = end_date + delta
#
# ########################################################################
# Creation of run directories and launch simulation
# ########################################################################
#
# Loop over days to simulate
#
d = sta_date
#
while d <= end_date:
  #
  year=d.year
  mont=d.month
  dayy=d.day
  #
  rundayprev = d - delta
  rundaynext = d + delta
  #
  yearprev=rundayprev.year
  montprev=rundayprev.month
  dayyprev=rundayprev.day
  #
  yearnext=rundaynext.year
  montnext=rundaynext.month
  dayynext=rundaynext.day
  #
  # Flag for first and last day
  #
  if d == sta_date:
    flagfirsday=1
    flaglastday=0
  elif d == end_date:
    flagfirsday=0
    flaglastday=1
  else:
    flagfirsday=0
    flaglastday=0
  #
  # Create run directory
  #
  prun= "../RUNDAY_" + str(year).zfill(4) + str(mont).zfill(2) + str(dayy).zfill(2)
  #
  print "Creating run directory for " + str(year).zfill(4) + str(mont).zfill(2) + str(dayy).zfill(2)
  #
  cmd = "rm -Rf " + prun
  os.system(cmd)
  cmd = "mkdir " + prun
  os.system(cmd)
  #
  os.chdir(prun)
  #
  # Create link to PGD Files
  #
  os.system("ln -s ../001_PGD_NEST/HK_PGD_8km.neste1.des ./HK_PGD_8km.neste1.des")
  os.system("ln -s ../001_PGD_NEST/HK_PGD_8km.neste1.nc4 ./HK_PGD_8km.neste1.nc4")
  #
  os.system("ln -s ../001_PGD_NEST/HK_PGD_2km.neste1.des ./HK_PGD_2km.neste1.des")
  os.system("ln -s ../001_PGD_NEST/HK_PGD_2km.neste1.nc4 ./HK_PGD_2km.neste1.nc4")
  #
  os.system("ln -s ../001_PGD_NEST/HK_PGD_1km.neste1.des ./HK_PGD_1km.neste1.des")
  os.system("ln -s ../001_PGD_NEST/HK_PGD_1km.neste1.nc4 ./HK_PGD_1km.neste1.nc4")
  #
  os.system("ln -s ../001_PGD_NEST/HK_PGD_250m.neste1.des ./HK_PGD_250m.neste1.des")
  os.system("ln -s ../001_PGD_NEST/HK_PGD_250m.neste1.nc4 ./HK_PGD_250m.neste1.nc4")
  #
  os.system("ln -s ../001_PGD_NEST/HK_PGD_125m.neste1.des ./HK_PGD_125m.neste1.des")
  os.system("ln -s ../001_PGD_NEST/HK_PGD_125m.neste1.nc4 ./HK_PGD_125m.neste1.nc4")
  #
  # Create EXSEG files
  #
  a=0
  while a < lnest:
    #
    cmd = "cp ../TEMPLATES/EXSEG" + str(a+1) + ".nam.template ./EXSEG" + str(a+1) + ".nam"
    os.system(cmd)
    #
    if flagfirsday==1:
      #
      # - Initialisation files for the first day
      #
      cmd = "ln -s ../011_RUN5MOD_START/MNHOU." + str(a+1) + ".SEGM0.012.des ./INIATMFILE_Nest_" + str(a+1) + ".des"
      os.system(cmd)
      #
      cmd = "ln -s ../011_RUN5MOD_START/MNHOU." + str(a+1) + ".SEGM0.012.nc4 ./INIATMFILE_Nest_" + str(a+1) + ".nc4"
      os.system(cmd)
      #
    else:
      #
      # - Restart files for the rest of the days
      #
      cmd = "ln -s ../RUNDAY_" + str(yearprev).zfill(4) + str(montprev).zfill(2) + str(dayyprev).zfill(2) + "/MNHOU." + str(a+1) + ".SEGM0.024.des ./INIATMFILE_Nest_" + str(a+1) + ".des"
      os.system(cmd)
      #
      cmd = "ln -s ../RUNDAY_" + str(yearprev).zfill(4) + str(montprev).zfill(2) + str(dayyprev).zfill(2) + "/MNHOU." + str(a+1) + ".SEGM0.024.nc4 ./INIATMFILE_Nest_" + str(a+1) + ".nc4"
      os.system(cmd)
      #
    a=a+1
  #
  # Create link to executable
  #
  cmd = "ln -s ~/MNH-V5-3-1/src/dir_obj-LXifortI4-MNH-V5-3-1-MPIINTEL-" + optlevel + "/" + version + "/MESONH ./MESONH"
  os.system(cmd)
  #
  # Prepare the MesoNH job
  #
  cmd = "cp " + pathtemp + "job_slurm_MesoNH_template ./job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%nodes%%%/'" + str(nodes) + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%cpupertask%%%/'" + str(cpupertask) + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%time%%%/'" + cputime + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%np%%%/'" + str(nodes*cpupertask) + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%version%%%/'" + cversion + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%OPTLEVEL%%%/'" + optlevel + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%flaglast%%%/'" + str(flaglastday) + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%flagfirs%%%/'" + str(flagfirsday) + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%nextday%%%/'" + str(yearnext).zfill(4) + str(montnext).zfill(2) + str(dayynext).zfill(2) + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%prevday%%%/'" + str(year).zfill(4) + str(mont).zfill(2) + str(dayy).zfill(2) + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%scenario%%%/REFER/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  cmd = "sed -i -- 's/%%%nestnum%%%/'" + str(lnest) + "'/g' job_slurm_MesoNH"
  os.system(cmd)
  #
  os.system("sed -i -- 's/%%%sleepseconds%%%/1/g' job_slurm_MesoNH")
  #
  # Create links to coupling files
  #
  sta_year = year
  sta_mont = mont
  sta_dayy = dayy
  #
  nex_year = yearnext
  nex_mont = montnext
  nex_dayy = dayynext
  #
  # 4 files per day (3-hourly forcing)
  # CAUTION: the last forcing time steps belongs to the next day
  #
  hour3steps=["06","12","18","00"]
  #
  a=1
  for VAR in hour3steps:
    #
    if a < 4:
      #
      cmd = "ln -s ../002_COUPLING/HK_PREP_8km_" + str(sta_year).zfill(4) + str(sta_mont).zfill(2) + str(sta_dayy).zfill(2) + '_' + VAR + ".des " + "CPL_" + str(a) + ".des"
      os.system(cmd)
      #
      cmd = "ln -s ../002_COUPLING/HK_PREP_8km_" + str(sta_year).zfill(4) + str(sta_mont).zfill(2) + str(sta_dayy).zfill(2) + '_' + VAR + ".nc4 " + "CPL_" + str(a) + ".nc4"
      os.system(cmd)
      #
    else:
      #
      cmd = "ln -s ../002_COUPLING/HK_PREP_8km_" + str(nex_year).zfill(4) + str(nex_mont).zfill(2) + str(nex_dayy).zfill(2) + '_' + VAR + ".des " + "CPL_" + str(a) + ".des"
      os.system(cmd)
      #
      cmd = "ln -s ../002_COUPLING/HK_PREP_8km_" + str(nex_year).zfill(4) + str(nex_mont).zfill(2) + str(nex_dayy).zfill(2) + '_' + VAR + ".nc4 " + "CPL_" + str(a) + ".nc4"
      os.system(cmd)
    #
    a=a+1
  #
  # Launch MesoNH at first day
  #
  if flagfirsday==1:
    os.system("sbatch job_slurm_MesoNH >> OUTBIN")
    #
  d += delta
  #
#
# End of script
#
quit()
#
