#!/bin/sh
#SBATCH --export=NONE
#SBATCH -J preal34_HK
#SBATCH -N 1              # nodes number (=NBP)
#SBATCH -n 1              # CPUs number (on all nodes) (=NBP*TPN)
#SBATCH -o preal34_HK.eo%j   #
#SBATCH -e preal34_HK.eo%j   #
#SBATCH -t 00:30:00    # time limit
#SBATCH -p pptparty
# Echo des commandes
ulimit -c 0
ulimit -s unlimited
#
./run_clean.sh
#
export OPTLEVEL="O3"
#
# profile to be executed :
. ~/MNH-V5-3-1/conf/profile_mesonh-LXifortI4-MNH-V5-3-1-MODIFIED_HK_CECILE1-MPIINTEL-${OPTLEVEL}

export MPIRUN="Mpirun -np 1 idrmem" # the number must be = to the number of processors set line 5

set -x

# recuperation des fichiers necessaires
ln -sf ../007_SPA_MOD3_MOD4/HK_PREP_1km_20180515_12.spa.* .
ln -sf ../001_PGD_NEST/HK_PGD_250m.neste1.* .

# ATTENTION : tant que l'on ne peut pas coupler avec notre surface 
# (pbme de variables cf comportements multiples), coupler avec les champs du CEP :
ln -sf ../../../EXTRACT_ECMWF/ecmwf.OD.20180515.12 SURFFILE

# run du programme
cp PRE_REAL1.nam_mod3_mod4 PRE_REAL1.nam
time ${MPIRUN} PREP_REAL_CASE_${OPTLEVEL}

#wait to allow for completion of writing tasks
sleep 15

mv OUTPUT_LISTING0  OUTPUT_LISTING0_preal34_HK
mv OUTPUT_LISTING1  OUTPUT_LISTING1_preal34_HK

# Submit next job if current job finished correctly :
lc_listing=0
lc_listing="$(grep -i -s "COMPUTING TIME ANALYSIS in PREP_REAL_CASE" ./OUTPUT_LISTING0_preal34_HK | wc -l)"
#
if [ $lc_listing -gt 0 ];then
  #
  # menage
  #
  rm PRE_REAL1.nam file_for_xtransfer pipe_name
  rm HK_PGD_*neste*
  rm SURFFILE
  #
  # statistiques du job
  #
  ja
  #
  # lancement du job suivant
  #
  cd ../009_SPA_MOD4_MOD5/
  sbatch run_spawn45.sh
  #
fi
