#!/bin/sh
#SBATCH --export=NONE
#SBATCH -J preal12_HK
#SBATCH -N 1               # nodes number (=NBP)
#SBATCH -n 1               # CPUs number (on all nodes) (=NBP*TPN)
#SBATCH -o preal12_HK.eo%j   #
#SBATCH -e preal12_HK.eo%j   #
#SBATCH -t 00:30:00    # time limit
#SBATCH -p pptparty
# Echo des commandes
ulimit -c 0
ulimit -s unlimited
#
./run_clean.sh
#
export OPTLEVEL="O3"
#
# profile to be executed :
. ~/MNH-V5-3-1/conf/profile_mesonh-LXifortI4-MNH-V5-3-1-MODIFIED_HK_CECILE1-MPIINTEL-${OPTLEVEL}

export MPIRUN="Mpirun -np 1 idrmem" # the number must be = to the number of processors set line 5

set -x

# recuperation des fichiers necessaires
ln -sf ../001_PGD_NEST/HK_PGD_8km.neste1.* .
ln -sf ../001_PGD_NEST/HK_PGD_2km.neste1.* .
ln -sf ../002_COUPLING/HK_PREP_8km_20180515_12.* .
ln -sf ../003_SPA_MOD1_MOD2/HK_PREP_8km_20180515_12.spa.* .

# ATTENTION : tant que l'on ne peut pas coupler avec notre surface 
# (pbme de variables cf comportements multiples), coupler avec les champs du CEP :
ln -sf ../../../EXTRACT_ECMWF/ecmwf.OD.20180515.12 SURFFILE

# run du programme
cp PRE_REAL1.nam_mod1_mod2 PRE_REAL1.nam
time ${MPIRUN} PREP_REAL_CASE_${OPTLEVEL}

#wait to allow for completion of writing tasks
sleep 15

mv OUTPUT_LISTING0  OUTPUT_LISTING0_preal12_HK
mv OUTPUT_LISTING1  OUTPUT_LISTING1_preal12_HK

# Submit next job if current job finished correctly :
lc_listing=0
lc_listing="$(grep -i -s "COMPUTING TIME ANALYSIS in PREP_REAL_CASE" ./OUTPUT_LISTING0_preal12_HK | wc -l)"

if [ $lc_listing -gt 0 ];then

        # menage
	rm PRE_REAL1.nam
	rm file_for_xtransfer pipe_name
	rm HK_PGD_*neste*
	rm HK_PREP_8km_20180515_12.*

	# statistiques du job
	ja

	# lancement du job suivant
	cd ../005_SPA_MOD2_MOD3/
	sbatch run_spawn23.sh
fi


