#!/bin/sh
#SBATCH --export=NONE
#SBATCH -J pgd_HK1        # jobname that will appear in squeue
#SBATCH -N 1              # nodes number (nbre_noeuds = NBP dans tosupcrc)
#SBATCH -n 1              # CPUs number (nbre_noeuds*nbre_processeurs/noeud = NBP*TPN dans tosupcrc) / TPN = 4
#SBATCH -o pgd_HK1.eo%j   #
#SBATCH -e pgd_HK1.eo%j   #
#SBATCH -t 00:30:00       # time limit (ELAPSE)
#SBATCH -p pptparty
# Echo des commandes
ulimit -c 0
ulimit -s unlimited
#
./run_clean.sh
#
export OPTLEVEL="DEBUG"
#
# profile to be executed :
. ~/MNH-V5-3-1/conf/profile_mesonh-LXifortI4-MNH-V5-3-1-MODIFIED_HK_CECILE1-MPIINTEL-${OPTLEVEL}
#
export MPIRUN="Mpirun -np 1 idrmem"  # the number must be = to the number of processors set line 5
#
set -x
#
rm -f HK_PGD_*neste1* # to make sure that the 002_COUPLING does not start from old PGD nested if the PGD runs fail
#
###### run PGD 1 : SOUTH EAST CHINA @ 8 km resolution
#
# lien sur les fichiers de surface necessaires
ln -sf /home/cnrm_other/ge/mrmh/payart/PREP_PGD_FILES_WWW/ECOCLIMAP_v2.0.* .
ln -sf /home/cnrm_other/ge/mrmh/payart/PREP_PGD_FILES_WWW/srtm_ne_250.* .
ln -sf /home/cnrm_other/ge/mrmh/payart/PREP_PGD_FILES_WWW/CLAY_HWSD_MOY.* .
ln -sf /home/cnrm_other/ge/mrmh/payart/PREP_PGD_FILES_WWW/SAND_HWSD_MOY.* .
#
ln -sf ../../../SST_FILES/* .
#
rm -f HK_PGD_8km.???
cp PRE_PGD1.nam_8km PRE_PGD1.nam
time ${MPIRUN} PREP_PGD_${OPTLEVEL}

# Wait to allow for completion of all written tasks
sleep 15

mv OUTPUT_LISTING0  OUTPUT_LISTING0_HK_8km

# Submit next job if current job finished correctly :
lc_listing=0
lc_listing="$(grep -i -s "PREP_PGD ends correctly" ./OUTPUT_LISTING0_HK_8km | wc -l)"

if [ $lc_listing -gt 0 ];then
  #
  touch HK_PGD_8km.des # need to create empty .des file
  # menage du repertoire
  rm -f *.dir *.hdr *.txt *.csv
  rm -f PRE_PGD1.nam file_for_xtransfer pipe_name
  #
  # Copy name of PGD file for extract script
  #
  cp -f HK_PGD_8km.des PGD_Nest_1.des
  cp -f HK_PGD_8km.nc4 PGD_Nest_1.nc4
  #
  # Extract diagnostics
  #
  rm -Rf ./RUNDIR_DIAG
  mkdir ./RUNDIR_DIAG
  cd ./RUNDIR_DIAG
  #
  cp ../../TEMPLATES/Extract_diag_PGD_template.sh_REFER ./Extract_diag_PGD_template.sh
  sed -i -- 's/%%%nnest%%%/1/g' ./Extract_diag_PGD_template.sh
  sed -i -- 's/%%%folderout%%%/DIAG_Nest_1/g' ./Extract_diag_PGD_template.sh
  ./Extract_diag_PGD_template.sh
  #
  cd ..
  #
  mkdir ../PREP_PGD_NEST_1
  mkdir ../PREP_PGD_NEST_1/DIAG/
  cp DIAG_Nest_1/* ../PREP_PGD_NEST_1/DIAG/
  #
  # statistiques du job
  ja
  #
  #lancement du job suivant
  #
  sbatch run_pgd2.sh
  #
fi
