#define restrict __restrict
#include <Eigen/Dense>
#include <math.h>

template <typename Derived>
 static inline void subkernel0_interior_facet_to_00_exterior_facet_integral_otherwise (const Eigen::MatrixBase<Derived> &  A_ , const double *restrict coords , const int *restrict cell_orientations , const unsigned int  facet[1] )
{
  {
    Eigen::MatrixBase<Derived> &  A  = const_cast<Eigen::MatrixBase<Derived> &>(A_);
    ;
    static const double  t0[3][3][9]  = {{{0.687298334620742, -0.0872983346207417, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 
    {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 
    {-0.0872983346207417, 0.687298334620742, 0.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}}, 
    {{0.0, 0.0, 0.0, 0.687298334620742, -0.0872983346207417, 0.4, 0.0, 0.0, 0.0}, 
    {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, 
    {0.0, 0.0, 0.0, -0.0872983346207417, 0.687298334620742, 0.4, 0.0, 0.0, 0.0}}, 
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.687298334620742, -0.0872983346207417, 0.4}, 
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}, 
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0872983346207417, 0.687298334620742, 0.4}}};
    static const double  t1[3][3][12]  = {{{-0.187298334620742, 0.461895003862225, -0.161895003862225, -0.0127016653792584, -0.0618950038622252, 0.361895003862225, -0.787298334620742, 2.26189500386223, -1.96189500386223, 3.6, -1.2, 1.2}, 
    {-0.25, 0.5, 0.25, -0.25, 0.5, 0.25, -0.25, 0.5, 0.250000000000001, 9.0, -3.0, 3.0}, 
    {0.587298334620741, -1.86189500386222, 2.16189500386222, -0.787298334620741, 2.26189500386222, -1.96189500386223, -0.0127016653792579, -0.0618950038622257, 0.361895003862225, 3.6, -1.2, 1.2}}, 
    {{0.0127016653792584, 0.0618950038622248, -0.361895003862225, 0.187298334620742, -0.461895003862225, 0.161895003862225, -1.96189500386223, 2.26189500386223, -0.787298334620742, -1.2, 3.6, -1.2}, 
    {0.25, -0.5, -0.249999999999999, 0.25, -0.5, -0.25, 0.25, 0.5, -0.25, -3.0, 9.0, -3.0}, 
    {0.787298334620742, -2.26189500386222, 1.96189500386223, -0.587298334620741, 1.86189500386222, -2.16189500386222, 0.361895003862225, -0.0618950038622252, -0.0127016653792586, -1.2, 3.6, -1.2}}, 
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.97459666924148, 1.4, -0.425403330758517, 0.0, 0.0, 0.0}, 
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0}, 
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.425403330758517, 1.4, -1.97459666924148, 0.0, 0.0, 0.0}}};
    static const double  t2[3][3][12]  = {{{2.16189500386223, -1.86189500386222, 0.587298334620742, 0.0127016653792587, 0.0618950038622249, -0.361895003862225, 0.787298334620742, -2.26189500386222, 1.96189500386222, -3.6, 1.2, -1.2}, 
    {0.25, 0.5, -0.25, 0.25, -0.5, -0.25, 0.25, -0.5, -0.250000000000001, -9.0, 3.0, -3.0}, 
    {-0.161895003862225, 0.461895003862225, -0.187298334620741, 0.787298334620741, -2.26189500386223, 1.96189500386223, 0.0127016653792578, 0.0618950038622261, -0.361895003862225, -3.6, 1.2, -1.2}}, 
    {{0.0, 0.0, 0.0, 1.97459666924148, -1.4, 0.425403330758516, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 
    {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, 
    {0.0, 0.0, 0.0, 0.425403330758516, -1.4, 1.97459666924148, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}}, 
    {{-0.361895003862225, 0.061895003862225, 0.0127016653792585, 1.96189500386222, -2.26189500386222, 0.787298334620741, -0.187298334620742, 0.461895003862225, -0.161895003862225, 1.2, -1.2, 3.6}, 
    {-0.250000000000001, -0.5, 0.25, -0.250000000000001, -0.5, 0.249999999999999, -0.25, 0.5, 0.25, 3.0, -3.0, 9.0}, 
    {1.96189500386222, -2.26189500386223, 0.787298334620741, -0.361895003862225, 0.061895003862225, 0.0127016653792582, 0.587298334620742, -1.86189500386222, 2.16189500386223, 1.2, -1.2, 3.6}}};
    static const double  t3[3][2]  = {{1.0, 1.0}, 
    {-1.0, 0.0}, 
    {0.0, -1.0}};
    double  t4  = ((-1) * (coords[0]));
    double  t5  = ((t4) + (coords[3]));
    double  t6  = ((-1) * (coords[1]));
    double  t7  = ((t6) + (coords[4]));
    double  t8  = ((-1) * (coords[2]));
    double  t9  = ((t8) + (coords[5]));
    double  t10  = ((((((t5) * (t5))) + (((t7) * (t7))))) + (((t9) * (t9))));
    double  t11  = ((t4) + (coords[6]));
    double  t12  = ((t6) + (coords[7]));
    double  t13  = ((t8) + (coords[8]));
    double  t14  = ((((((t11) * (t11))) + (((t12) * (t12))))) + (((t13) * (t13))));
    double  t15  = ((((((t5) * (t11))) + (((t7) * (t12))))) + (((t9) * (t13))));
    double  t16  = ((((((t11) * (t5))) + (((t12) * (t7))))) + (((t13) * (t9))));
    double  t17  = ((1) / (((((t10) * (t14))) + (((-1) * (((t15) * (t16))))))));
    double  t18  = ((t14) * (t17));
    double  t19  = ((((-1) * (t15))) * (t17));
    double  t20  = ((((-1) * (t16))) * (t17));
    double  t21  = ((t10) * (t17));
    double  t22  = ((((t3[facet[0]][0]) * (((((t18) * (t5))) + (((t19) * (t11))))))) + (((t3[facet[0]][1]) * (((((t20) * (t5))) + (((t21) * (t11))))))));
    double  t23  = ((((t3[facet[0]][0]) * (((((t18) * (t7))) + (((t19) * (t12))))))) + (((t3[facet[0]][1]) * (((((t20) * (t7))) + (((t21) * (t12))))))));
    double  t24  = ((((t3[facet[0]][0]) * (((((t18) * (t9))) + (((t19) * (t13))))))) + (((t3[facet[0]][1]) * (((((t20) * (t9))) + (((t21) * (t13))))))));
    double  t25  = ((1) / (sqrt((((((t22) * (t22))) + (((t23) * (t23))))) + (((t24) * (t24))))));
    double  t26  = ((t22) * (t25));
    double  t27  = ((((t7) * (t13))) + (((-1) * (((t12) * (t9))))));
    double  t28  = ((((t11) * (t9))) + (((-1) * (((t5) * (t13))))));
    double  t29  = ((((t5) * (t12))) + (((-1) * (((t11) * (t7))))));
    double  t30  = ((1) / (((((cell_orientations[0]) == (1) ? -1 : ((cell_orientations[0]) == (0) ? 1 : NAN))) * (sqrt((((((t27) * (t27))) + (((t28) * (t28))))) + (((t29) * (t29))))))));
    double  t31  = ((t23) * (t25));
    double  t32  = ((t24) * (t25));
    double  t33  = ((((((t26) * (((t5) * (t30))))) + (((t31) * (((t7) * (t30))))))) + (((t32) * (((t9) * (t30))))));
    double  t34  = ((((((t26) * (((t11) * (t30))))) + (((t31) * (((t12) * (t30))))))) + (((t32) * (((t13) * (t30))))));
    static const double  t35[3][2][1]  = {{{-1.0}, 
    {1.0}}, 
    {{0.0}, 
    {1.0}}, 
    {{1.0}, 
    {0.0}}};
    double  t36  = ((((t35[facet[0]][0][0]) * (t5))) + (((t35[facet[0]][1][0]) * (t11))));
    double  t37  = ((((t35[facet[0]][0][0]) * (t7))) + (((t35[facet[0]][1][0]) * (t12))));
    double  t38  = ((((t35[facet[0]][0][0]) * (t9))) + (((t35[facet[0]][1][0]) * (t13))));
    double  t39  = sqrt((((((t36) * (t36))) + (((t37) * (t37))))) + (((t38) * (t38))));
    static const double  t40[3]  = {0.277777777777778, 0.444444444444444, 0.277777777777778};
    
    for (int  ip  = 0; (ip) < (3); ip += 1)
    {
      double  t44[12] ;
      double  t41  = ((t40[ip]) * (t39));
      double  t42  = ((t41) * (t34));
      double  t43  = ((t41) * (t33));
      
      for (int  k  = 0; (k) < (12); k += 1)
      {
        t44[k] = (((t2[facet[0]][ip][k]) * (t43))) + (((t1[facet[0]][ip][k]) * (t42)));
        
      }
      
      for (int  j  = 0; (j) < (9); j += 1)
      {
        
        for (int  k  = 0; (k) < (12); k += 1)
        {
          A(j, k) += (t44[k]) * (t0[facet[0]][ip][j]);
          
        }
        
      }
      
    }
    
  }
  
}

template <typename Derived>
 static inline void subkernel1_cell_to_00_cell_integral_otherwise (const Eigen::MatrixBase<Derived> &  A_ , const double *restrict coords , const int *restrict cell_orientations , const double *restrict w_0 , const double *restrict w_1 , const double *restrict w_2 , const double *restrict w_3 , const double *restrict w_4 )
{
  {
    Eigen::MatrixBase<Derived> &  A  = const_cast<Eigen::MatrixBase<Derived> &>(A_);
    ;
    static const double  t0[7][12]  = {{-0.111111111111111, 0.333333333333333, -0.333333333333333, 0.111111111111111, -0.333333333333333, 0.333333333333333, 0.444444444444445, -0.666666666666667, 0.444444444444445, 2.66666666666667, 2.66666666666667, 0.0}, 
    {-0.15127823181799, 0.383325057827867, -0.171796144949559, 0.0102589565657845, -0.101286507323456, 0.312815420201764, -0.302556463635979, 1.03973276792875, -1.27177959393862, 2.78456191211852, -0.5999006939344, 0.846115651513231}, 
    {0.474352608585538, -1.42305782575661, 1.42305782575661, -0.474352608585538, 1.42305782575661, -1.42305782575661, 0.323074376767549, -0.202573014646913, 0.323074376767549, 1.93844626060529, 1.9384462606053, 0.0}, 
    {-0.0102589565657844, 0.101286507323456, -0.312815420201764, 0.15127823181799, -0.383325057827866, 0.171796144949559, -1.27177959393863, 1.03973276792875, -0.30255646363598, -0.599900693934403, 2.78456191211852, -0.846115651513231}, 
    {0.164883673994861, -0.301692404766643, -0.277183446887175, 0.221033560441018, -0.470142064105115, -0.108733787548703, 0.329767347989721, 0.143940701459007, -0.00713197068722488, -1.64170476926138, 7.62030885719971, -2.31550340661527}, 
    {-0.0525839011025453, 0.157751703307636, -0.157751703307636, 0.0525839011025453, -0.157751703307636, 0.157751703307636, 0.112299772892315, -0.94028412821023, 0.112299772892315, 0.673798637353891, 0.673798637353891, 0.0}, 
    {-0.221033560441018, 0.470142064105115, 0.108733787548703, -0.164883673994861, 0.301692404766642, 0.277183446887175, -0.00713197068722371, 0.143940701459005, 0.329767347989722, 7.62030885719971, -1.64170476926138, 2.31550340661527}};
    static const double  t1[7][12]  = {{-0.333333333333334, 0.333333333333334, -0.111111111111111, -0.444444444444444, 0.666666666666667, -0.444444444444444, -0.111111111111111, 0.333333333333333, -0.333333333333334, -2.66666666666667, 0.0, 2.66666666666667}, 
    {1.42305782575661, -1.42305782575661, 0.474352608585538, -0.323074376767549, 0.202573014646913, -0.323074376767549, 0.474352608585538, -1.42305782575661, 1.42305782575661, -1.93844626060529, 0.0, 1.93844626060529}, 
    {-0.171796144949559, 0.383325057827867, -0.15127823181799, 0.302556463635979, -1.03973276792875, 1.27177959393862, -0.0102589565657849, 0.101286507323457, -0.312815420201764, -2.78456191211852, 0.84611565151323, -0.599900693934399}, 
    {-0.312815420201764, 0.101286507323456, -0.0102589565657845, 1.27177959393863, -1.03973276792875, 0.302556463635979, -0.15127823181799, 0.383325057827867, -0.171796144949559, 0.5999006939344, -0.846115651513229, 2.78456191211852}, 
    {-0.157751703307636, 0.157751703307636, -0.0525839011025455, -0.112299772892315, 0.94028412821023, -0.112299772892315, -0.0525839011025451, 0.157751703307636, -0.157751703307636, -0.67379863735389, 0.0, 0.673798637353891}, 
    {-0.277183446887176, -0.301692404766642, 0.16488367399486, -0.329767347989721, -0.143940701459006, 0.00713197068722426, -0.221033560441018, 0.470142064105115, 0.108733787548703, 1.64170476926138, -2.31550340661527, 7.6203088571997}, 
    {0.108733787548703, 0.470142064105115, -0.221033560441018, 0.00713197068722426, -0.143940701459005, -0.329767347989721, 0.16488367399486, -0.301692404766641, -0.277183446887176, -7.62030885719971, 2.31550340661527, -1.64170476926138}};
    double  t2  = ((cell_orientations[0]) == (1) ? -1 : ((cell_orientations[0]) == (0) ? 1 : NAN));
    double  t3  = ((-1) * (coords[1]));
    double  t4  = ((t3) + (coords[4]));
    double  t5  = ((-1) * (coords[2]));
    double  t6  = ((t5) + (coords[8]));
    double  t7  = ((t3) + (coords[7]));
    double  t8  = ((t5) + (coords[5]));
    double  t9  = ((((t4) * (t6))) + (((-1) * (((t7) * (t8))))));
    double  t10  = ((-1) * (coords[0]));
    double  t11  = ((t10) + (coords[6]));
    double  t12  = ((t10) + (coords[3]));
    double  t13  = ((((t11) * (t8))) + (((-1) * (((t12) * (t6))))));
    double  t14  = ((((t12) * (t7))) + (((-1) * (((t11) * (t4))))));
    double  t15  = sqrt((((((t9) * (t9))) + (((t13) * (t13))))) + (((t14) * (t14))));
    double  t16  = ((1) / (t15));
    double  t17  = ((((t2) * (t9))) * (t16));
    double  t18  = ((1) / (((t2) * (t15))));
    double  t19  = ((t4) * (t18));
    double  t20  = ((((t2) * (t13))) * (t16));
    double  t21  = ((-1) * (t20));
    double  t22  = ((t12) * (t18));
    double  t23  = ((((t17) * (t19))) + (((t21) * (t22))));
    double  t24  = ((((t2) * (t14))) * (t16));
    double  t25  = ((-1) * (t17));
    double  t26  = ((t8) * (t18));
    double  t27  = ((((t24) * (t22))) + (((t25) * (t26))));
    double  t28  = ((-1) * (t24));
    double  t29  = ((((t20) * (t26))) + (((t28) * (t19))));
    double  t30  = ((t7) * (t18));
    double  t31  = ((t11) * (t18));
    double  t32  = ((((t17) * (t30))) + (((t21) * (t31))));
    double  t33  = ((t6) * (t18));
    double  t34  = ((((t24) * (t31))) + (((t25) * (t33))));
    double  t35  = ((((t20) * (t33))) + (((t28) * (t30))));
    double  t36  = ((0.5) * (w_0[0]));
    double  t37  = ((1) / (w_3[0]));
    double  t38  = ((2) * (w_4[0]));
    static const double  t39[7][3]  = {{0.333333333333333, 0.333333333333333, 0.333333333333333}, 
    {0.101286507323456, 0.797426985353087, 0.101286507323456}, 
    {0.101286507323457, 0.101286507323456, 0.797426985353087}, 
    {0.797426985353087, 0.101286507323456, 0.101286507323456}, 
    {0.470142064105115, 0.0597158717897698, 0.470142064105115}, 
    {0.470142064105115, 0.470142064105115, 0.0597158717897697}, 
    {0.0597158717897699, 0.470142064105115, 0.470142064105115}};
    static const double  t40[7]  = {0.1125, 0.0629695902724136, 0.0629695902724136, 0.0629695902724136, 0.0661970763942531, 0.0661970763942531, 0.0661970763942531};
    
    for (int  ip  = 0; (ip) < (7); ip += 1)
    {
      double  t53[12] ;
      double  t54[12] ;
      double  t41  = ((t40[ip]) * (t15));
      double  t42  = ((t36) * (((((((((((t39[ip][0]) * (coords[2]))) + (((t39[ip][1]) * (coords[5]))))) + (((t39[ip][2]) * (coords[8]))))) * (t38))) * (t37))));
      double  t43  = ((t31) + (((t42) * (t35))));
      double  t44  = ((t30) + (((t42) * (t34))));
      double  t45  = ((t33) + (((t42) * (t32))));
      double  t46  = ((t41) * (((((((t43) * (t22))) + (((t44) * (t19))))) + (((t45) * (t26))))));
      double  t47  = ((t22) + (((t42) * (t29))));
      double  t48  = ((t19) + (((t42) * (t27))));
      double  t49  = ((t26) + (((t42) * (t23))));
      double  t50  = ((t41) * (((((((t47) * (t22))) + (((t48) * (t19))))) + (((t49) * (t26))))));
      double  t51  = ((t41) * (((((((t43) * (t31))) + (((t44) * (t30))))) + (((t45) * (t33))))));
      double  t52  = ((t41) * (((((((t47) * (t31))) + (((t48) * (t30))))) + (((t49) * (t33))))));
      
      for (int  k  = 0; (k) < (12); k += 1)
      {
        t53[k] = (((t1[ip][k]) * (t52))) + (((t0[ip][k]) * (t51)));
        t54[k] = (((t1[ip][k]) * (t50))) + (((t0[ip][k]) * (t46)));
        
      }
      
      for (int  j  = 0; (j) < (12); j += 1)
      {
        
        for (int  k  = 0; (k) < (12); k += 1)
        {
          A(j, k) += (((t54[k]) * (t1[ip][j]))) + (((t53[k]) * (t0[ip][j])));
          
        }
        
      }
      
    }
    
  }
  
}

template <typename Derived>
 static inline void subkernel1_cell_to_01_cell_integral_otherwise (const Eigen::MatrixBase<Derived> &  A_ , const double *restrict coords , const int *restrict cell_orientations , const double *restrict w_0 , const double *restrict w_1 , const double *restrict w_2 , const double *restrict w_3 , const double *restrict w_4 )
{
  {
    Eigen::MatrixBase<Derived> &  A  = const_cast<Eigen::MatrixBase<Derived> &>(A_);
    ;
    static const double  t0[6][12]  = {{-1.45054271894137, 3.53478058384365, -1.08423786490229, -0.183152427019539, -0.267390291921839, 2.7179330108632, -2.7179330108632, 6.80217087576552, 0.183152427019515, 29.4065126272964, -9.80217087576538, 9.80217087576543}, 
    {1.45054271894138, -5.16847572980461, 7.61901844874597, -3.08423786490229, 8.43586602172642, -5.98532330278506, -2.7179330108632, 1.0, 0.183152427019514, 11.9999999999999, -27.2086835030619, 9.80217087576544}, 
    {0.0, 0.633695145960904, -2.53478058384367, 1.26739029192184, -3.16847572980459, 1.26739029192183, 7.43586602172643, -4.8021708757655, 1.6336951459609, -5.40651262729661, 25.0108543788276, -7.60434175153105}, 
    {0.675690945495796, -2.13517585465546, 2.45948490915965, -0.891896981831926, 2.56758792732771, -2.24327887282352, 2.24327887282352, -1.70276378198316, 0.891896981831909, 3.89170865405039, -1.29723621801673, 1.29723621801678}, 
    {-0.675690945495784, 1.91896981831929, -1.59466076381509, 0.459484909159654, -1.48655774564703, 1.81086680015122, 2.24327887282352, 1.0, 0.891896981831908, 11.9999999999999, 6.81105512793277, 1.29723621801677}, 
    {0.0, -0.783793963663877, 3.13517585465544, -1.56758792732772, 3.91896981831929, -1.56758792732773, -2.486557745647, 3.70276378198316, 0.216206036336116, 20.1082913459493, -17.5138189099157, 9.40552756396624}};
    static const double  t1[6][12]  = {{-0.183152427019542, 0.366304854039083, 0.183152427019541, -0.183152427019542, 0.366304854039082, 0.183152427019541, -4.35162815682415, 11.604341751531, -7.25271359470689, 4.395658248469, -4.39565824846899, 2.1978291242345}, 
    {-1.63369514596092, 3.26739029192183, 1.63369514596091, -1.63369514596092, 3.26739029192183, 1.63369514596092, -2.90108543788275, 0.0, 2.90108543788275, 39.208683503062, -39.208683503062, 19.604341751531}, 
    {-0.183152427019541, 0.366304854039083, 0.183152427019541, -0.183152427019541, 0.366304854039082, 0.183152427019541, 7.25271359470688, -11.604341751531, 4.35162815682413, 4.39565824846899, -4.39565824846899, 2.19782912423449}, 
    {-0.89189698183193, 1.78379396366386, 0.891896981831928, -0.89189698183193, 1.78379396366386, 0.891896981831929, 2.02707283648737, -5.40552756396633, 3.37845472747895, 21.4055275639663, -21.4055275639663, 10.7027637819831}, 
    {-0.21620603633614, 0.432412072672279, 0.216206036336139, -0.216206036336139, 0.432412072672278, 0.216206036336139, 1.35138189099158, 0.0, -1.35138189099158, 5.18894487206735, -5.18894487206734, 2.59447243603367}, 
    {-0.89189698183193, 1.78379396366386, 0.891896981831927, -0.891896981831929, 1.78379396366386, 0.891896981831929, -3.37845472747895, 5.40552756396632, -2.02707283648737, 21.4055275639663, -21.4055275639663, 10.7027637819831}};
    static const double  t2[6][12]  = {{1.63369514596094, 3.2673902919218, -1.6336951459609, 2.90108543788275, 1.86517468137026e-14, -2.90108543788274, 1.63369514596092, -3.26739029192185, -1.63369514596089, -39.2086835030619, 19.604341751531, -39.208683503062}, 
    {0.183152427019565, 0.366304854039048, -0.183152427019528, 4.35162815682412, -11.604341751531, 7.25271359470689, 0.183152427019544, -0.366304854039097, -0.183152427019513, -4.39565824846886, 2.19782912423446, -4.39565824846895}, 
    {0.183152427019553, 0.366304854039065, -0.183152427019535, -7.25271359470689, 11.604341751531, -4.35162815682412, 0.183152427019546, -0.366304854039096, -0.183152427019523, -4.3956582484689, 2.19782912423446, -4.39565824846896}, 
    {0.216206036336158, 0.432412072672253, -0.21620603633613, -1.3513818909916, 2.44249065417534e-14, 1.35138189099158, 0.216206036336144, -0.432412072672294, -0.216206036336116, -5.18894487206725, 2.59447243603364, -5.18894487206732}, 
    {0.89189698183195, 1.78379396366383, -0.89189698183192, -2.02707283648738, 5.40552756396635, -3.37845472747895, 0.891896981831934, -1.78379396366387, -0.891896981831907, -21.4055275639662, 10.7027637819831, -21.4055275639663}, 
    {0.891896981831953, 1.78379396366383, -0.891896981831917, 3.37845472747893, -5.40552756396629, 2.02707283648737, 0.891896981831933, -1.78379396366387, -0.891896981831903, -21.4055275639662, 10.7027637819831, -21.4055275639663}};
    static const double  t3[6][12]  = {{7.61901844874597, -5.16847572980459, 1.45054271894138, 2.71793301086323, -1.00000000000001, -0.183152427019537, 3.0842378649023, -8.43586602172643, 5.98532330278505, -12, 9.80217087576552, -27.2086835030621}, 
    {-1.08423786490229, 3.53478058384367, -1.45054271894137, 2.71793301086321, -6.8021708757655, -0.183152427019539, 0.183152427019539, 0.267390291921838, -2.71793301086321, -29.4065126272965, 9.8021708757655, -9.80217087576551}, 
    {-2.53478058384368, 0.633695145960925, 0.0, -7.43586602172642, 4.8021708757655, -1.63369514596092, -1.26739029192183, 3.16847572980459, -1.26739029192184, 5.40651262729651, -7.60434175153101, 25.0108543788275}, 
    {-1.59466076381509, 1.9189698183193, -0.67569094549579, -2.24327887282351, -1.0, -0.891896981831929, -0.459484909159652, 1.48655774564702, -1.81086680015123, -12, 1.29723621801683, 6.81105512793265}, 
    {2.45948490915965, -2.13517585465544, 0.675690945495789, -2.24327887282351, 1.70276378198316, -0.891896981831928, 0.891896981831928, -2.56758792732771, 2.24327887282351, -3.8917086540505, 1.29723621801683, -1.29723621801683}, 
    {3.13517585465544, -0.783793963663863, 0.0, 2.48655774564702, -3.70276378198316, -0.216206036336138, 1.56758792732772, -3.9189698183193, 1.56758792732772, -20.1082913459495, 9.40552756396631, -17.5138189099158}};
    static const double  t4[6][3]  = {{0.09157621350977, 0.816847572980459, 0.091576213509771}, 
    {0.0915762135097701, 0.0915762135097711, 0.816847572980459}, 
    {0.816847572980458, 0.091576213509771, 0.091576213509771}, 
    {0.445948490915965, 0.10810301816807, 0.445948490915965}, 
    {0.445948490915965, 0.445948490915965, 0.10810301816807}, 
    {0.10810301816807, 0.445948490915965, 0.445948490915965}};
    double  t5  = ((((-1) * (((0.5) * (w_0[0]))))) * (w_2[0]));
    double  t6  = ((-1) * (coords[1]));
    double  t7  = ((t6) + (coords[4]));
    double  t8  = ((-1) * (coords[2]));
    double  t9  = ((t8) + (coords[8]));
    double  t10  = ((t6) + (coords[7]));
    double  t11  = ((t8) + (coords[5]));
    double  t12  = ((((t7) * (t9))) + (((-1) * (((t10) * (t11))))));
    double  t13  = ((-1) * (coords[0]));
    double  t14  = ((t13) + (coords[6]));
    double  t15  = ((t13) + (coords[3]));
    double  t16  = ((((t14) * (t11))) + (((-1) * (((t15) * (t9))))));
    double  t17  = ((((t15) * (t10))) + (((-1) * (((t14) * (t7))))));
    double  t18  = sqrt((((((t12) * (t12))) + (((t16) * (t16))))) + (((t17) * (t17))));
    double  t19  = ((1) / (((((cell_orientations[0]) == (1) ? -1 : ((cell_orientations[0]) == (0) ? 1 : NAN))) * (t18))));
    double  t20  = ((t15) * (t19));
    double  t21  = ((((((t15) * (t15))) + (((t7) * (t7))))) + (((t11) * (t11))));
    double  t22  = ((((((t14) * (t14))) + (((t10) * (t10))))) + (((t9) * (t9))));
    double  t23  = ((((((t15) * (t14))) + (((t7) * (t10))))) + (((t11) * (t9))));
    double  t24  = ((((((t14) * (t15))) + (((t10) * (t7))))) + (((t9) * (t11))));
    double  t25  = ((1) / (((((t21) * (t22))) + (((-1) * (((t23) * (t24))))))));
    double  t26  = ((t22) * (t25));
    double  t27  = ((((-1) * (t23))) * (t25));
    double  t28  = ((((t26) * (t15))) + (((t27) * (t14))));
    double  t29  = ((t7) * (t19));
    double  t30  = ((((t26) * (t7))) + (((t27) * (t10))));
    double  t31  = ((t11) * (t19));
    double  t32  = ((((t26) * (t11))) + (((t27) * (t9))));
    double  t33  = ((t5) * (((((((t20) * (t28))) + (((t29) * (t30))))) + (((t31) * (t32))))));
    double  t34  = ((((-1) * (t24))) * (t25));
    double  t35  = ((t21) * (t25));
    double  t36  = ((((t34) * (t15))) + (((t35) * (t14))));
    double  t37  = ((((t34) * (t7))) + (((t35) * (t10))));
    double  t38  = ((((t34) * (t11))) + (((t35) * (t9))));
    double  t39  = ((t5) * (((((((t20) * (t36))) + (((t29) * (t37))))) + (((t31) * (t38))))));
    double  t40  = ((t14) * (t19));
    double  t41  = ((t10) * (t19));
    double  t42  = ((t9) * (t19));
    double  t43  = ((t5) * (((((((t40) * (t28))) + (((t41) * (t30))))) + (((t42) * (t32))))));
    double  t44  = ((t5) * (((((((t40) * (t36))) + (((t41) * (t37))))) + (((t42) * (t38))))));
    static const double  t45[6]  = {0.054975871827661, 0.054975871827661, 0.054975871827661, 0.111690794839005, 0.111690794839005, 0.111690794839005};
    
    for (int  ip  = 0; (ip) < (6); ip += 1)
    {
      double  t46  = ((t45[ip]) * (t18));
      double  t47  = ((t44) * (t46));
      double  t48  = ((t43) * (t46));
      double  t49  = ((t39) * (t46));
      double  t50  = ((t33) * (t46));
      
      for (int  j  = 0; (j) < (12); j += 1)
      {
        double  t51  = ((((((((t3[ip][j]) * (t50))) + (((t2[ip][j]) * (t49))))) + (((t1[ip][j]) * (t48))))) + (((t0[ip][j]) * (t47))));
        
        for (int  k  = 0; (k) < (3); k += 1)
        {
          A(j, k) += (t51) * (t4[ip][k]);
          
        }
        
      }
      
    }
    
  }
  
}

template <typename Derived>
 static inline void subkernel1_cell_to_10_cell_integral_otherwise (const Eigen::MatrixBase<Derived> &  A_ , const double *restrict coords , const int *restrict cell_orientations , const double *restrict w_0 , const double *restrict w_1 , const double *restrict w_2 , const double *restrict w_3 , const double *restrict w_4 )
{
  {
    Eigen::MatrixBase<Derived> &  A  = const_cast<Eigen::MatrixBase<Derived> &>(A_);
    ;
    static const double  t0[6][3]  = {{0.09157621350977, 0.816847572980459, 0.091576213509771}, 
    {0.0915762135097701, 0.0915762135097711, 0.816847572980459}, 
    {0.816847572980458, 0.091576213509771, 0.091576213509771}, 
    {0.445948490915965, 0.10810301816807, 0.445948490915965}, 
    {0.445948490915965, 0.445948490915965, 0.10810301816807}, 
    {0.10810301816807, 0.445948490915965, 0.445948490915965}};
    static const double  t1[6][12]  = {{-1.45054271894137, 3.53478058384365, -1.08423786490229, -0.183152427019539, -0.267390291921839, 2.7179330108632, -2.7179330108632, 6.80217087576552, 0.183152427019515, 29.4065126272964, -9.80217087576538, 9.80217087576543}, 
    {1.45054271894138, -5.16847572980461, 7.61901844874597, -3.08423786490229, 8.43586602172642, -5.98532330278506, -2.7179330108632, 1.0, 0.183152427019514, 11.9999999999999, -27.2086835030619, 9.80217087576544}, 
    {0.0, 0.633695145960904, -2.53478058384367, 1.26739029192184, -3.16847572980459, 1.26739029192183, 7.43586602172643, -4.8021708757655, 1.6336951459609, -5.40651262729661, 25.0108543788276, -7.60434175153105}, 
    {0.675690945495796, -2.13517585465546, 2.45948490915965, -0.891896981831926, 2.56758792732771, -2.24327887282352, 2.24327887282352, -1.70276378198316, 0.891896981831909, 3.89170865405039, -1.29723621801673, 1.29723621801678}, 
    {-0.675690945495784, 1.91896981831929, -1.59466076381509, 0.459484909159654, -1.48655774564703, 1.81086680015122, 2.24327887282352, 1.0, 0.891896981831908, 11.9999999999999, 6.81105512793277, 1.29723621801677}, 
    {0.0, -0.783793963663877, 3.13517585465544, -1.56758792732772, 3.91896981831929, -1.56758792732773, -2.486557745647, 3.70276378198316, 0.216206036336116, 20.1082913459493, -17.5138189099157, 9.40552756396624}};
    static const double  t2[6][12]  = {{-0.183152427019542, 0.366304854039083, 0.183152427019541, -0.183152427019542, 0.366304854039082, 0.183152427019541, -4.35162815682415, 11.604341751531, -7.25271359470689, 4.395658248469, -4.39565824846899, 2.1978291242345}, 
    {-1.63369514596092, 3.26739029192183, 1.63369514596091, -1.63369514596092, 3.26739029192183, 1.63369514596092, -2.90108543788275, 0.0, 2.90108543788275, 39.208683503062, -39.208683503062, 19.604341751531}, 
    {-0.183152427019541, 0.366304854039083, 0.183152427019541, -0.183152427019541, 0.366304854039082, 0.183152427019541, 7.25271359470688, -11.604341751531, 4.35162815682413, 4.39565824846899, -4.39565824846899, 2.19782912423449}, 
    {-0.89189698183193, 1.78379396366386, 0.891896981831928, -0.89189698183193, 1.78379396366386, 0.891896981831929, 2.02707283648737, -5.40552756396633, 3.37845472747895, 21.4055275639663, -21.4055275639663, 10.7027637819831}, 
    {-0.21620603633614, 0.432412072672279, 0.216206036336139, -0.216206036336139, 0.432412072672278, 0.216206036336139, 1.35138189099158, 0.0, -1.35138189099158, 5.18894487206735, -5.18894487206734, 2.59447243603367}, 
    {-0.89189698183193, 1.78379396366386, 0.891896981831927, -0.891896981831929, 1.78379396366386, 0.891896981831929, -3.37845472747895, 5.40552756396632, -2.02707283648737, 21.4055275639663, -21.4055275639663, 10.7027637819831}};
    static const double  t3[6][12]  = {{1.63369514596094, 3.2673902919218, -1.6336951459609, 2.90108543788275, 1.86517468137026e-14, -2.90108543788274, 1.63369514596092, -3.26739029192185, -1.63369514596089, -39.2086835030619, 19.604341751531, -39.208683503062}, 
    {0.183152427019565, 0.366304854039048, -0.183152427019528, 4.35162815682412, -11.604341751531, 7.25271359470689, 0.183152427019544, -0.366304854039097, -0.183152427019513, -4.39565824846886, 2.19782912423446, -4.39565824846895}, 
    {0.183152427019553, 0.366304854039065, -0.183152427019535, -7.25271359470689, 11.604341751531, -4.35162815682412, 0.183152427019546, -0.366304854039096, -0.183152427019523, -4.3956582484689, 2.19782912423446, -4.39565824846896}, 
    {0.216206036336158, 0.432412072672253, -0.21620603633613, -1.3513818909916, 2.44249065417534e-14, 1.35138189099158, 0.216206036336144, -0.432412072672294, -0.216206036336116, -5.18894487206725, 2.59447243603364, -5.18894487206732}, 
    {0.89189698183195, 1.78379396366383, -0.89189698183192, -2.02707283648738, 5.40552756396635, -3.37845472747895, 0.891896981831934, -1.78379396366387, -0.891896981831907, -21.4055275639662, 10.7027637819831, -21.4055275639663}, 
    {0.891896981831953, 1.78379396366383, -0.891896981831917, 3.37845472747893, -5.40552756396629, 2.02707283648737, 0.891896981831933, -1.78379396366387, -0.891896981831903, -21.4055275639662, 10.7027637819831, -21.4055275639663}};
    static const double  t4[6][12]  = {{7.61901844874597, -5.16847572980459, 1.45054271894138, 2.71793301086323, -1.00000000000001, -0.183152427019537, 3.0842378649023, -8.43586602172643, 5.98532330278505, -12, 9.80217087576552, -27.2086835030621}, 
    {-1.08423786490229, 3.53478058384367, -1.45054271894137, 2.71793301086321, -6.8021708757655, -0.183152427019539, 0.183152427019539, 0.267390291921838, -2.71793301086321, -29.4065126272965, 9.8021708757655, -9.80217087576551}, 
    {-2.53478058384368, 0.633695145960925, 0.0, -7.43586602172642, 4.8021708757655, -1.63369514596092, -1.26739029192183, 3.16847572980459, -1.26739029192184, 5.40651262729651, -7.60434175153101, 25.0108543788275}, 
    {-1.59466076381509, 1.9189698183193, -0.67569094549579, -2.24327887282351, -1.0, -0.891896981831929, -0.459484909159652, 1.48655774564702, -1.81086680015123, -12, 1.29723621801683, 6.81105512793265}, 
    {2.45948490915965, -2.13517585465544, 0.675690945495789, -2.24327887282351, 1.70276378198316, -0.891896981831928, 0.891896981831928, -2.56758792732771, 2.24327887282351, -3.8917086540505, 1.29723621801683, -1.29723621801683}, 
    {3.13517585465544, -0.783793963663863, 0.0, 2.48655774564702, -3.70276378198316, -0.216206036336138, 1.56758792732772, -3.9189698183193, 1.56758792732772, -20.1082913459495, 9.40552756396631, -17.5138189099158}};
    double  t5  = ((((0.5) * (w_0[0]))) * (w_1[0]));
    double  t6  = ((-1) * (coords[1]));
    double  t7  = ((t6) + (coords[4]));
    double  t8  = ((-1) * (coords[2]));
    double  t9  = ((t8) + (coords[8]));
    double  t10  = ((t6) + (coords[7]));
    double  t11  = ((t8) + (coords[5]));
    double  t12  = ((((t7) * (t9))) + (((-1) * (((t10) * (t11))))));
    double  t13  = ((-1) * (coords[0]));
    double  t14  = ((t13) + (coords[6]));
    double  t15  = ((t13) + (coords[3]));
    double  t16  = ((((t14) * (t11))) + (((-1) * (((t15) * (t9))))));
    double  t17  = ((((t15) * (t10))) + (((-1) * (((t14) * (t7))))));
    double  t18  = sqrt((((((t12) * (t12))) + (((t16) * (t16))))) + (((t17) * (t17))));
    double  t19  = ((1) / (((((cell_orientations[0]) == (1) ? -1 : ((cell_orientations[0]) == (0) ? 1 : NAN))) * (t18))));
    double  t20  = ((t15) * (t19));
    double  t21  = ((((((t15) * (t15))) + (((t7) * (t7))))) + (((t11) * (t11))));
    double  t22  = ((((((t14) * (t14))) + (((t10) * (t10))))) + (((t9) * (t9))));
    double  t23  = ((((((t15) * (t14))) + (((t7) * (t10))))) + (((t11) * (t9))));
    double  t24  = ((((((t14) * (t15))) + (((t10) * (t7))))) + (((t9) * (t11))));
    double  t25  = ((1) / (((((t21) * (t22))) + (((-1) * (((t23) * (t24))))))));
    double  t26  = ((t22) * (t25));
    double  t27  = ((((-1) * (t23))) * (t25));
    double  t28  = ((((t26) * (t15))) + (((t27) * (t14))));
    double  t29  = ((t7) * (t19));
    double  t30  = ((((t26) * (t7))) + (((t27) * (t10))));
    double  t31  = ((t11) * (t19));
    double  t32  = ((((t26) * (t11))) + (((t27) * (t9))));
    double  t33  = ((t5) * (((((((t20) * (t28))) + (((t29) * (t30))))) + (((t31) * (t32))))));
    double  t34  = ((((-1) * (t24))) * (t25));
    double  t35  = ((t21) * (t25));
    double  t36  = ((((t34) * (t15))) + (((t35) * (t14))));
    double  t37  = ((((t34) * (t7))) + (((t35) * (t10))));
    double  t38  = ((((t34) * (t11))) + (((t35) * (t9))));
    double  t39  = ((t5) * (((((((t20) * (t36))) + (((t29) * (t37))))) + (((t31) * (t38))))));
    double  t40  = ((t14) * (t19));
    double  t41  = ((t10) * (t19));
    double  t42  = ((t9) * (t19));
    double  t43  = ((t5) * (((((((t40) * (t28))) + (((t41) * (t30))))) + (((t42) * (t32))))));
    double  t44  = ((t5) * (((((((t40) * (t36))) + (((t41) * (t37))))) + (((t42) * (t38))))));
    static const double  t45[6]  = {0.054975871827661, 0.054975871827661, 0.054975871827661, 0.111690794839005, 0.111690794839005, 0.111690794839005};
    
    for (int  ip  = 0; (ip) < (6); ip += 1)
    {
      double  t51[12] ;
      double  t46  = ((t45[ip]) * (t18));
      double  t47  = ((t44) * (t46));
      double  t48  = ((t43) * (t46));
      double  t49  = ((t39) * (t46));
      double  t50  = ((t33) * (t46));
      
      for (int  k  = 0; (k) < (12); k += 1)
      {
        t51[k] = (((((((t4[ip][k]) * (t50))) + (((t3[ip][k]) * (t49))))) + (((t2[ip][k]) * (t48))))) + (((t1[ip][k]) * (t47)));
        
      }
      
      for (int  j  = 0; (j) < (3); j += 1)
      {
        
        for (int  k  = 0; (k) < (12); k += 1)
        {
          A(j, k) += (t51[k]) * (t0[ip][j]);
          
        }
        
      }
      
    }
    
  }
  
}

template <typename Derived>
 static inline void subkernel1_cell_to_11_cell_integral_otherwise (const Eigen::MatrixBase<Derived> &  A_ , const double *restrict coords , const double *restrict w_0 , const double *restrict w_1 , const double *restrict w_2 , const double *restrict w_3 , const double *restrict w_4 )
{
  {
    Eigen::MatrixBase<Derived> &  A  = const_cast<Eigen::MatrixBase<Derived> &>(A_);
    ;
    static const double  t0[6][3]  = {{0.109039009072877, 0.659027622374092, 0.231933368553031}, 
    {0.231933368553031, 0.659027622374092, 0.109039009072877}, 
    {0.109039009072877, 0.231933368553031, 0.659027622374092}, 
    {0.659027622374092, 0.231933368553031, 0.109039009072877}, 
    {0.231933368553031, 0.109039009072877, 0.659027622374092}, 
    {0.659027622374092, 0.109039009072877, 0.231933368553031}};
    double  t1  = ((-1) * (coords[1]));
    double  t2  = ((t1) + (coords[4]));
    double  t3  = ((-1) * (coords[2]));
    double  t4  = ((t3) + (coords[8]));
    double  t5  = ((t1) + (coords[7]));
    double  t6  = ((t3) + (coords[5]));
    double  t7  = ((((t2) * (t4))) + (((-1) * (((t5) * (t6))))));
    double  t8  = ((-1) * (coords[0]));
    double  t9  = ((t8) + (coords[6]));
    double  t10  = ((t8) + (coords[3]));
    double  t11  = ((((t9) * (t6))) + (((-1) * (((t10) * (t4))))));
    double  t12  = ((((t10) * (t5))) + (((-1) * (((t9) * (t2))))));
    double  t13  = sqrt((((((t7) * (t7))) + (((t11) * (t11))))) + (((t12) * (t12))));
    static const double  t14[6]  = {0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333, 0.0833333333333333};
    
    for (int  ip  = 0; (ip) < (6); ip += 1)
    {
      double  t15  = ((t14[ip]) * (t13));
      
      for (int  j  = 0; (j) < (3); j += 1)
      {
        double  t16  = ((t0[ip][j]) * (t15));
        
        for (int  k  = 0; (k) < (3); k += 1)
        {
          A(j, k) += (t0[ip][k]) * (t16);
          
        }
        
      }
      
    }
    
  }
  
}

 static inline void pyop2_kernel_compile_slate (double *restrict A3 , const double *restrict coords , const int *restrict cell_orientations , const double *restrict w_0 , const double *restrict w_1 , const double *restrict w_2 , const double *restrict w_3 , const double *restrict w_4 , const int8_t *restrict arg_cell_facets )
{
  int8_t (*cell_facets)[2] = (int8_t (*)[2])arg_cell_facets;
  /* Declare and initialize */
  Eigen::Matrix<double, 9, 15, Eigen::RowMajor>  T0 ;
  T0.setZero();
  Eigen::Matrix<double, 15, 15, Eigen::RowMajor>  T1 ;
  T1.setZero();
  /* Assemble local tensors */
  subkernel1_cell_to_00_cell_integral_otherwise(T1.block<12, 12>(0, 0), coords, cell_orientations, w_0, w_1, w_2, w_3, w_4);
  subkernel1_cell_to_01_cell_integral_otherwise(T1.block<12, 3>(0, 12), coords, cell_orientations, w_0, w_1, w_2, w_3, w_4);
  subkernel1_cell_to_10_cell_integral_otherwise(T1.block<3, 12>(12, 0), coords, cell_orientations, w_0, w_1, w_2, w_3, w_4);
  subkernel1_cell_to_11_cell_integral_otherwise(T1.block<3, 3>(12, 12), coords, w_0, w_1, w_2, w_3, w_4);
  /* Loop over cell facets */
  
  for (unsigned int  i0  = 0; (i0) < (3); i0 += 1)
  {
    if ((cell_facets[i0][0]) == (1)) {
      subkernel0_interior_facet_to_00_exterior_facet_integral_otherwise(T0.block<9, 12>(0, 0), coords, cell_orientations, &i0);
      
    }
     
  }
  Eigen::PartialPivLU<Eigen::Matrix<double, 15, 15, Eigen::RowMajor> > dec2(T1);
  /* Map eigen tensor into C struct */
  Eigen::Map<Eigen::Matrix<double, 9, 9, Eigen::RowMajor> > T3((double *)A3);
  /* Linear algebra expression */
  T3 += T0 * (dec2).inverse() * (T0).transpose();
  
}
#include <petsc.h>

extern "C" {
void wrap_pyop2_kernel_compile_slate(int const start, int const end, Mat const mat0, double const *__restrict__ dat1, int const *__restrict__ dat0, double const *__restrict__ glob0, double const *__restrict__ glob1, double const *__restrict__ glob2, double const *__restrict__ glob3, double const *__restrict__ glob4, signed char const *__restrict__ dat2, int const *__restrict__ map2, int const *__restrict__ map1, int const *__restrict__ map0)
{
  int t0[1];
  double t1[3 * 3];
  double t2[9 * 9];

  for (int n = start; n <= -1 + end; ++n)
  {
    t0[0] = dat0[map0[n]];
    for (int i2 = 0; i2 <= 8; ++i2)
      for (int i3 = 0; i3 <= 8; ++i3)
        t2[9 * i2 + i3] = 0.0;
    for (int i0 = 0; i0 <= 2; ++i0)
      for (int i1 = 0; i1 <= 2; ++i1)
        t1[3 * i0 + i1] = dat1[3 * map1[3 * n + i0] + i1];
    pyop2_kernel_compile_slate(&(t2[0]), &(t1[0]), &(t0[0]), &(glob0[0]), &(glob1[0]), &(glob2[0]), &(glob3[0]), &(glob4[0]), &(dat2[6 * n]));
    MatSetValuesBlockedLocal(mat0, 9, &(map2[9 * n]), 9, &(map2[9 * n]), &(t2[0]), ADD_VALUES);
  }
}
}
