!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE ZOOM_PGD_OROGRAPHY (DTCO, UG, U, USS, GCP, &
                                     HPROGRAM,PSEA,PWATER,HINIFILE,HINIFILETYPE)
!     ###########################################################

!!
!!    PURPOSE
!!    -------
!!   This program prepares the physiographic data fields.
!!
!!    METHOD
!!    ------
!!   
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    V. Masson                   Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original     13/10/03
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
!
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_SSO_n, ONLY : SSO_t
USE MODD_GRID_CONF_PROJ_n, ONLY : GRID_CONF_PROJ_t
!
USE MODD_PREP,             ONLY : CINGRID_TYPE, CINTERP_TYPE, LINTERP
USE MODD_SURF_PAR,         ONLY : XUNDEF
!
USE MODI_OPEN_AUX_IO_SURF
USE MODI_READ_SURF
USE MODI_CLOSE_AUX_IO_SURF
USE MODI_PREP_GRID_EXTERN
USE MODI_HOR_INTERPOL
USE MODI_PREP_OUTPUT_GRID
USE MODI_GOTO_MODEL_MNH
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_CLEAN_PREP_OUTPUT_GRID
!
USE MODI_GET_LUOUT
IMPLICIT NONE
!
!*    0.1    Declaration of dummy arguments
!            ------------------------------
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
!
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(SSO_t), INTENT(INOUT) :: USS
TYPE(GRID_CONF_PROJ_t),INTENT(INOUT) :: GCP
!
 CHARACTER(LEN=6),     INTENT(IN)  :: HPROGRAM    ! program calling
REAL, DIMENSION(:),   INTENT(IN)  :: PSEA        ! sea fraction
REAL, DIMENSION(:),   INTENT(IN)  :: PWATER      ! inland water fraction
 CHARACTER(LEN=28),    INTENT(IN)  :: HINIFILE    ! input atmospheric file name
 CHARACTER(LEN=6),     INTENT(IN)  :: HINIFILETYPE! input atmospheric file type
!
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
INTEGER :: IINFO_ll
INTEGER :: IRESP
INTEGER :: ILUOUT
INTEGER :: INI     ! total 1D dimension (input field)
INTEGER :: IL      ! total 1D dimension (output field)
REAL, DIMENSION(:), POINTER :: ZZS
REAL, DIMENSION(:), POINTER :: ZAVG_ZS
REAL, DIMENSION(:), POINTER :: ZSIL_ZS
REAL, DIMENSION(:), POINTER :: ZSSO_STDEV
REAL, DIMENSION(:), POINTER :: ZMIN_ZS
REAL, DIMENSION(:), POINTER :: ZMAX_ZS
REAL, DIMENSION(:), POINTER :: ZSSO_ANIS
REAL, DIMENSION(:), POINTER :: ZSSO_DIR
REAL, DIMENSION(:), POINTER :: ZSSO_SLOPE
REAL, DIMENSION(:), POINTER :: ZAOSIP
REAL, DIMENSION(:), POINTER :: ZAOSIM
REAL, DIMENSION(:), POINTER :: ZAOSJP
REAL, DIMENSION(:), POINTER :: ZAOSJM
REAL, DIMENSION(:), POINTER :: ZHO2IP
REAL, DIMENSION(:), POINTER :: ZHO2IM
REAL, DIMENSION(:), POINTER :: ZHO2JP
REAL, DIMENSION(:), POINTER :: ZHO2JM
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('ZOOM_PGD_OROGRAPHY',0,ZHOOK_HANDLE)
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
!*      1.     Preparation of IO for reading in the file
!              -----------------------------------------
!
!* Note that all points are read, even those without physical meaning.
!  These points will not be used during the horizontal interpolation step.
!  Their value must be defined as XUNDEF.
!
! get the local sizes of model 1
 CALL GOTO_MODEL_MNH(U,HPROGRAM, 1, IINFO_ll)
 CALL OPEN_AUX_IO_SURF(HINIFILE,HINIFILETYPE,'FULL  ')
!
!------------------------------------------------------------------------------
!
!*      2.     Reading of grid
!              ---------------
!
 CALL PREP_OUTPUT_GRID(UG%G, UG%G, U%NSIZE_FULL, ILUOUT)
!
 CALL PREP_GRID_EXTERN(GCP,HINIFILETYPE,ILUOUT,CINGRID_TYPE,CINTERP_TYPE,INI)
!
!------------------------------------------------------------------------------
!
!*      3.     Reading of orographic parameters
!              --------------------------------
!
ALLOCATE(ZZS        (INI))
!
ALLOCATE(ZAVG_ZS    (INI))
ALLOCATE(ZSIL_ZS    (INI))
ALLOCATE(ZSSO_STDEV (INI))
ALLOCATE(ZMIN_ZS    (INI))
ALLOCATE(ZMAX_ZS    (INI))
!
ALLOCATE(ZSSO_ANIS  (INI))
ALLOCATE(ZSSO_DIR   (INI))
ALLOCATE(ZSSO_SLOPE (INI))
!
ALLOCATE(ZAOSIP     (INI))
ALLOCATE(ZAOSIM     (INI))
ALLOCATE(ZAOSJP     (INI))
ALLOCATE(ZAOSJM     (INI))
ALLOCATE(ZHO2IP     (INI))
ALLOCATE(ZHO2IM     (INI))
ALLOCATE(ZHO2JP     (INI))
ALLOCATE(ZHO2JM     (INI))
!
YRECFM='ZS'
 CALL READ_SURF(HPROGRAM,YRECFM,ZZS,IRESP,HDIR='A')
!
YRECFM='AVG_ZS'
 CALL READ_SURF(HPROGRAM,YRECFM,ZAVG_ZS,IRESP,HDIR='A')
YRECFM='SIL_ZS'
 CALL READ_SURF(HPROGRAM,YRECFM,ZSIL_ZS,IRESP,HDIR='A')
YRECFM='SSO_STDEV'
 CALL READ_SURF(HPROGRAM,YRECFM,ZSSO_STDEV,IRESP,HDIR='A')
YRECFM='MIN_ZS'
 CALL READ_SURF(HPROGRAM,YRECFM,ZMIN_ZS,IRESP,HDIR='A')
YRECFM='MAX_ZS'
 CALL READ_SURF(HPROGRAM,YRECFM,ZMAX_ZS,IRESP,HDIR='A')
!
YRECFM='SSO_ANIS'
 CALL READ_SURF(HPROGRAM,YRECFM,ZSSO_ANIS,IRESP,HDIR='A')
YRECFM='SSO_DIR'
 CALL READ_SURF(HPROGRAM,YRECFM,ZSSO_DIR,IRESP,HDIR='A')
YRECFM='SSO_SLOPE'
 CALL READ_SURF(HPROGRAM,YRECFM,ZSSO_SLOPE,IRESP,HDIR='A')
!
YRECFM='AOSIP'
 CALL READ_SURF(HPROGRAM,YRECFM,ZAOSIP,IRESP,HDIR='A')
YRECFM='AOSIM'
 CALL READ_SURF(HPROGRAM,YRECFM,ZAOSIM,IRESP,HDIR='A')
YRECFM='AOSJP'
 CALL READ_SURF(HPROGRAM,YRECFM,ZAOSJP,IRESP,HDIR='A')
YRECFM='AOSJM'
 CALL READ_SURF(HPROGRAM,YRECFM,ZAOSJM,IRESP,HDIR='A')
YRECFM='HO2IP'
 CALL READ_SURF(HPROGRAM,YRECFM,ZHO2IP,IRESP,HDIR='A')
YRECFM='HO2IM'
 CALL READ_SURF(HPROGRAM,YRECFM,ZHO2IM,IRESP,HDIR='A')
YRECFM='HO2JP'
 CALL READ_SURF(HPROGRAM,YRECFM,ZHO2JP,IRESP,HDIR='A')
YRECFM='HO2JM'
 CALL READ_SURF(HPROGRAM,YRECFM,ZHO2JM,IRESP,HDIR='A')
!
 CALL CLOSE_AUX_IO_SURF(HINIFILE,HINIFILETYPE)
!------------------------------------------------------------------------------
!
!*      4.     Interpolations
!              --------------
!
IL = SIZE(UG%G%XLAT)
!
ALLOCATE(U%XZS        (IL))
!
ALLOCATE(USS%XAVG_ZS    (IL))
ALLOCATE(USS%XSIL_ZS    (IL))
ALLOCATE(USS%XSSO_STDEV (IL))
ALLOCATE(USS%XMIN_ZS    (IL))
ALLOCATE(USS%XMAX_ZS    (IL))
!
ALLOCATE(USS%XSSO_ANIS  (IL))
ALLOCATE(USS%XSSO_DIR   (IL))
ALLOCATE(USS%XSSO_SLOPE (IL))
!
ALLOCATE(USS%XAOSIP     (IL))
ALLOCATE(USS%XAOSIM     (IL))
ALLOCATE(USS%XAOSJP     (IL))
ALLOCATE(USS%XAOSJM     (IL))
ALLOCATE(USS%XHO2IP     (IL))
ALLOCATE(USS%XHO2IM     (IL))
ALLOCATE(USS%XHO2JP     (IL))
ALLOCATE(USS%XHO2JM     (IL))
!
 CALL ZOOM(ILUOUT,ZZS,U%XZS)
 CALL ZOOM(ILUOUT,ZAVG_ZS,USS%XAVG_ZS)
 CALL ZOOM(ILUOUT,ZSIL_ZS,USS%XSIL_ZS)
 CALL ZOOM(ILUOUT,ZMIN_ZS,USS%XMIN_ZS)
 CALL ZOOM(ILUOUT,ZMAX_ZS,USS%XMAX_ZS)
!
LINTERP(:)=(PSEA(:)<1.)
 CALL ZOOM(ILUOUT,ZSSO_STDEV,USS%XSSO_STDEV)
 CALL ZOOM(ILUOUT,ZSSO_ANIS,USS%XSSO_ANIS)
 CALL ZOOM(ILUOUT,ZSSO_DIR,USS%XSSO_DIR)
 CALL ZOOM(ILUOUT,ZSSO_SLOPE,USS%XSSO_SLOPE)
 CALL ZOOM(ILUOUT,ZAOSIP,USS%XAOSIP)
 CALL ZOOM(ILUOUT,ZAOSIM,USS%XAOSIM)
 CALL ZOOM(ILUOUT,ZAOSJP,USS%XAOSJP)
 CALL ZOOM(ILUOUT,ZAOSJM,USS%XAOSJM)
 CALL ZOOM(ILUOUT,ZHO2IP,USS%XHO2IP)
 CALL ZOOM(ILUOUT,ZHO2IM,USS%XHO2IM)
 CALL ZOOM(ILUOUT,ZHO2JP,USS%XHO2JP)
 CALL ZOOM(ILUOUT,ZHO2JM,USS%XHO2JM)
!
!* coherence with land sea mask
!
WHERE(PSEA==1.) U%XZS=0.
WHERE(PSEA(:)==1.) USS%XSSO_STDEV(:) = XUNDEF
WHERE(PWATER(:)==1.) USS%XSSO_STDEV(:) = 0.
WHERE(PSEA(:)>0.) USS%XMIN_ZS(:) = 0.
WHERE(PSEA(:)==1.) USS%XMAX_ZS(:) = 0.
!
WHERE (PSEA(:)==1.)
  USS%XSSO_ANIS (:) = XUNDEF
  USS%XSSO_DIR  (:) = XUNDEF
  USS%XSSO_SLOPE(:) = XUNDEF
END WHERE
!
WHERE (PWATER(:)==1.)
  USS%XSSO_ANIS (:) = 1.
  USS%XSSO_DIR  (:) = 0.
  USS%XSSO_SLOPE(:) = 0.
END WHERE
!
WHERE (PSEA(:)==1.)
  USS%XHO2IP(:) = XUNDEF
  USS%XHO2IM(:) = XUNDEF
  USS%XHO2JP(:) = XUNDEF
  USS%XHO2JM(:) = XUNDEF
  USS%XAOSIP(:) = XUNDEF
  USS%XAOSIM(:) = XUNDEF
  USS%XAOSJP(:) = XUNDEF
  USS%XAOSJM(:) = XUNDEF
END WHERE
!
WHERE (PWATER(:)==1.)
  USS%XHO2IP(:) = 0.
  USS%XHO2IM(:) = 0.
  USS%XHO2JP(:) = 0.
  USS%XHO2JM(:) = 0.
  USS%XAOSIP(:) = 0.
  USS%XAOSIM(:) = 0.
  USS%XAOSJP(:) = 0.
  USS%XAOSJM(:) = 0.
END WHERE
!
! go back to child model
 CALL GOTO_MODEL_MNH(U,HPROGRAM, 2, IINFO_ll)
!_______________________________________________________________________________
DEALLOCATE(ZZS        )
!
DEALLOCATE(ZAVG_ZS    )
DEALLOCATE(ZSIL_ZS    )
DEALLOCATE(ZSSO_STDEV )
DEALLOCATE(ZMIN_ZS    )
DEALLOCATE(ZMAX_ZS    )
!
DEALLOCATE(ZSSO_ANIS  )
DEALLOCATE(ZSSO_DIR   )
DEALLOCATE(ZSSO_SLOPE )
!
DEALLOCATE(ZAOSIP     )
DEALLOCATE(ZAOSIM     )
DEALLOCATE(ZAOSJP     )
DEALLOCATE(ZAOSJM     )
DEALLOCATE(ZHO2IP     )
DEALLOCATE(ZHO2IM     )
DEALLOCATE(ZHO2JP     )
DEALLOCATE(ZHO2JM     )
!_______________________________________________________________________________
 CALL CLEAN_PREP_OUTPUT_GRID
!_______________________________________________________________________________
IF (LHOOK) CALL DR_HOOK('ZOOM_PGD_OROGRAPHY',1,ZHOOK_HANDLE)
CONTAINS
!
SUBROUTINE ZOOM(KLUOUT,PFIELDIN,PFIELDOUT)
INTEGER, INTENT(IN)             :: KLUOUT
REAL, DIMENSION(:), POINTER     :: PFIELDIN
REAL, DIMENSION(:), INTENT(OUT) :: PFIELDOUT
REAL, DIMENSION(:,:), POINTER   :: ZFIELDIN
REAL, DIMENSION(:,:), POINTER   :: ZFIELDOUT
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('ZOOM',0,ZHOOK_HANDLE)
ALLOCATE(ZFIELDIN (SIZE(PFIELDIN, 1),1))
ALLOCATE(ZFIELDOUT(SIZE(PFIELDOUT,1),1))
ZFIELDIN(:,1) = PFIELDIN(:)
 CALL HOR_INTERPOL(DTCO, U, GCP, KLUOUT,ZFIELDIN,ZFIELDOUT)
PFIELDOUT(:) = ZFIELDOUT(:,1)
DEALLOCATE(ZFIELDIN )
DEALLOCATE(ZFIELDOUT)
IF (LHOOK) CALL DR_HOOK('ZOOM',1,ZHOOK_HANDLE)

END SUBROUTINE ZOOM
!
END SUBROUTINE ZOOM_PGD_OROGRAPHY
