!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITESURF_OCEAN_n (HSELECT, O, OR, HPROGRAM)
!     ########################################
!
!!****  *WRITE_OCEAN_n* - writes OCEAN fields
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      C. Lebeaupin Brossier   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    03/2007
!!      Modified    07/2012, P. Le Moigne : CMO1D phasing
!!      11/2014 (David BARBARY) : Write oceanic level
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_OCEAN_n, ONLY : OCEAN_t
USE MODD_OCEAN_REL_n, ONLY : OCEAN_REL_t
!
USE MODD_OCEAN_GRID
!
USE MODI_WRITE_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
 CHARACTER(LEN=*), DIMENSION(:), INTENT(IN) :: HSELECT
!
TYPE(OCEAN_t), INTENT(INOUT) :: O
TYPE(OCEAN_REL_t), INTENT(INOUT) :: OR
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling

!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=4 ) :: YLVL
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
 CHARACTER(LEN=14) :: YFORM          ! Writing format
!
INTEGER :: JLEVEL ! loop counter on oceanic levels
!
REAL, DIMENSION(SIZE(O%XSEAT,1)) :: ZWORK ! 1D array to write data in file
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('WRITESURF_OCEAN_N',0,ZHOOK_HANDLE)
!
!* flag to define if OCEAN is used
!
YRECFM='SEA_OCEAN'
YCOMMENT='flag to use OCEAN model'
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,O%LMERCATOR,IRESP,HCOMMENT=YCOMMENT)
!
IF (.NOT. O%LMERCATOR .AND. LHOOK) CALL DR_HOOK('WRITESURF_OCEAN_N',1,ZHOOK_HANDLE)
IF (.NOT. O%LMERCATOR) RETURN
!
! Write Oceanic Level
YRECFM='SEA_NBLEVEL'
YCOMMENT='Number of OCEAN levels'
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,NOCKMAX,IRESP,HCOMMENT=YCOMMENT)

DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='LEVL_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A21,I1.1,A4)'
  IF (JLEVEL >= 10)  YFORM='(A21,I2.2,A4)'
  WRITE(YCOMMENT,FMT=YFORM) 'Depth of OCEAN level ',JLEVEL,' (m)'
  CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,XZHOC(JLEVEL),IRESP,HCOMMENT=YCOMMENT)
END DO
!
! Relaxation time  
YRECFM='TAU_REL_OC'
YCOMMENT='Relaxation time of ocean model (s)'
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,OR%XTAU_REL,IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LREL_CUR_OC'
YCOMMENT='FLAG FOR RELAXATION ON CURRENT'
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,OR%LREL_CUR,IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LREL_TS_OC'
YCOMMENT='FLAG FOR RELAXATION ON T,S'
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,OR%LREL_TS,IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LFLX_NULL_OC'
YCOMMENT='FLAG FOR ZERO FLUX '
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,OR%LFLUX_NULL,IRESP,HCOMMENT=YCOMMENT)

YRECFM='LFLX_CORR_OC'
YCOMMENT='FLAG FOR FLUX CORRECTION '
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,OR%LFLX_CORR,IRESP,HCOMMENT=YCOMMENT)

YRECFM='CORR_FLX_OC'
YCOMMENT='FLUX CORRECTION COEFF (W/M2/K)'
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,OR%XQCORR,IRESP,HCOMMENT=YCOMMENT)
!
YRECFM='LDIAPYC_OC'
YCOMMENT='FLAG FOR DIAPYCNAL MIXING '
 CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,OR%LDIAPYCNAL,IRESP,HCOMMENT=YCOMMENT)
!
!-------------------------------------------------------------------------------
!
!*       3.     Prognostic fields:
!               -----------------
!
! tendance surface liee au flux non solaire
!
  JLEVEL=1
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='DTFNSOL'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
!RJ: extended ascii should be avoided in I/O
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_DTFNSOL',JLEVEL,' (°C)'
  ZWORK=O%XDTFNSOL(:)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)
!
!* oceanic temperature
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='TEMP_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
!RJ: extended ascii should be avoided in I/O
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_TEMP_OC',JLEVEL,' (°C)'
  ZWORK=O%XSEAT(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)
END DO
!
! Budget terms lie au flux solaire
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='DTFSOL'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
!RJ: extended ascii should be avoided in I/O
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_DTFSOL',JLEVEL,' (°C/s)'
  ZWORK=O%XDTFSOL(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)
END DO

!
!* relaxation profile for oceanic temperature
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='T_OC_REL'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
!RJ: extended ascii should be avoided in I/O
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_T_OC_REL',JLEVEL,' (°C)'
  ZWORK=OR%XSEAT_REL(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)  
END DO
!
!* oceanic salinity
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='SALT_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_SALT_OC',JLEVEL,'(psu)'
  ZWORK=O%XSEAS(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)
END DO
!
!* oceanic salinity profile of relxation
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='S_OC_REL'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_S_OC_REL',JLEVEL,'(psu)'
  ZWORK=OR%XSEAS_REL(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)  
END DO
!
!* oceanic zonal current
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='U_OC_REL'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_U_OC_REL',JLEVEL,' M/S'
  ZWORK=OR%XSEAU_REL(:,JLEVEL)
  CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)
END DO
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='UCUR_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_UCUR_OC',JLEVEL,' (m/s)'
  ZWORK=O%XSEAU(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)  
END DO
!
!* oceanic meridian current
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='V_OC_REL'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_V_OC_REL',JLEVEL,' M/S'
  ZWORK=OR%XSEAV_REL(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)
END DO
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL  
  YRECFM='VCUR_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_VCUR_OC',JLEVEL,'(m/s)'
  ZWORK=O%XSEAV(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)
END DO
!
!* oceanic turbulent kinetic energy
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='TKE_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_TKE_OC',JLEVEL,' (J)'
  ZWORK=O%XSEAE(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)  
END DO
!
!* oceanic mixing coefficient
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='KMEL_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_KMEL_OC',JLEVEL,' (m2/s2)'
  ZWORK=O%XKMEL(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)  
END DO

!
!-------------------------------------------------------------------------------
!
!*       4.     Semi-prognostic fields:
!               ----------------------
!* bathymetry indice
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='SEAINDBATH'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  YFORM='(A11,I1.1,A5)'
  IF (JLEVEL >= 10)  YFORM='(A11,I2.2,A5)'
  WRITE(YCOMMENT,FMT=YFORM) 'X_Y_SEAINDBATH',JLEVEL,' (J)'
  ZWORK=O%XSEABATH(:,JLEVEL)
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)  
END DO
!
!-------------------------------------------------------------------------------
!Sea Surface Salinity
!
YRECFM='SSS_OC'
YCOMMENT='SSS_OC'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,O%XSEAS(:,NOCKMIN),IRESP,HCOMMENT=YCOMMENT)
!-------------------------------------------------------------------------------
!Sea Surface Salinity
!
YRECFM='SEA_HMO'
YCOMMENT='X_Y_'
 CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,O%XSEAHMO(:),IRESP,HCOMMENT=YCOMMENT)
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('WRITESURF_OCEAN_N',1,ZHOOK_HANDLE)
!
END SUBROUTINE WRITESURF_OCEAN_n
