!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITE_DIAG_MISC_TEB_n (DTCO, HSELECT, U, DMTC, DMT, DMTO, &
                                        GDD, GDDE, GDDEC, GRD, GRDE, GRDEC, &
                                        T, TOP, HPROGRAM,KTEB_PATCH)
!     #################################
!
!!****  *WRITE_DIAG_MISC_TEB* - writes the TEB diagnostic fields
!!
!!    PURPOSE
!!    -------
!!
!!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      P. Le Moigne   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    10/2004
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_DIAG_MISC_TEB_n, ONLY : DIAG_MISC_TEB_t
USE MODD_DIAG_MISC_TEB_OPTIONS_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
USE MODD_TEB_n, ONLY : TEB_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODD_DIAG_n, ONLY : DIAG_t
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
!
USE MODI_INIT_IO_SURF_n
USE MODI_WRITE_SURF
USE MODD_SURF_PAR,       ONLY : XUNDEF
USE MODI_END_IO_SURF_n
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
 CHARACTER(LEN=*), DIMENSION(:), INTENT(IN) :: HSELECT
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DMTC
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DMT
TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DMTO
TYPE(TEB_t), INTENT(INOUT) :: T
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
TYPE(DIAG_t), INTENT(INOUT) :: GDD
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: GDDE
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: GDDEC
TYPE(DIAG_t), INTENT(INOUT) :: GRD
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: GRDE
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: GRDEC
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM   ! program calling
INTEGER,           INTENT(IN)  :: KTEB_PATCH ! patch number being written
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=3)  :: YPATCH         ! Prefix for current patch
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!           Initialisation for IO
!           ---------------------
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_MISC_TEB_N',0,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
IF (DMTO%LSURF_MISC_BUDGET) THEN
  !
  YPATCH = '   '
  IF (TOP%NTEB_PATCH>1) WRITE(YPATCH,FMT='(A,I1,A)') 'T',KTEB_PATCH,'_'
  !
  CALL INIT_IO_SURF_n(DTCO, U,    HPROGRAM,'TOWN  ','TEB   ','WRITE','TEB_DIAGNOSTICS.OUT.nc')
  !
  !*       Miscellaneous fields :
  !        ----------------------
  !
  YRECFM='D_RD'
  YCOMMENT='Road fraction'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='Z0_TOWN'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='town roughness length'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XZ0_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='XQF_BLD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='domestic heating'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQF_BLD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='XQF_TOWN'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='total anthropogenic heat'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQF_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='XDQS_TOWN'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='heat storage inside building'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDQS_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFF_TW'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='aggregated runoff for town'//' (kg/m2/s)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRUNOFF_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RN_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT=' net radiation at road'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='road sensible heat flux'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='road latent heat flux'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net road conduction flux'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFF_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='road surface runoff'//' (kg/m2/s)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRUNOFF_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (TOP%CWALL_OPT=='UNIF') THEN
    !
    YRECFM='RN_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for wall '//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall sensible heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net wall conduction flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ELSE
    !
    YRECFM='RN_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for wall A'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall A sensible heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net wall A conduction flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RN_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for wall B'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall B sensible heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net wall B conduction flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  YRECFM='RN_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net radiation for roof'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='roof sensible heat flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='roof latent heat flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net roof conduction flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFF_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='aggregated roof runoff'//' (kg/m2/s)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRUNOFF_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  !
  IF (TOP%LGARDEN) THEN
    !
    YRECFM='RN_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for GARDEN areas'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDD%XRN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GARDEN area sensible heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDD%XH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GARDEN area latent heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDD%XLE(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net GARDEN area conduction flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDD%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RUNOFF_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='garden surface runoff'//' (kg/m2/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDDE%XRUNOFF(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  YRECFM='RN_BLT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net radiation for built surfaces'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_BLT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_BLT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='built surface sensible heat flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_BLT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_BLT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='built surface latent heat flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_BLT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_BLT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='built surface conduction flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_BLT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWA_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by roofs'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWA_SN_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by snow on roofs'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_SNOW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by roofs'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_SN_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by snow on roofs'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_SNOW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWA_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by roads'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWA_SN_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by snow on roads'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_SNOW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by roads'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_SN_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by snow on roads'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_SNOW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (TOP%CWALL_OPT=='UNIF') THEN
    !
    YRECFM='SWA_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by wall'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by wall '//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ELSE
    !
    YRECFM='SWA_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by wall A'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by wall A'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWA_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by wall B'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by wall B'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  IF (TOP%LGARDEN) THEN
    !
    YRECFM='SWA_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by GARDEN areas'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by GARDEN areas'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  YRECFM='REF_SW_GO'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Total solar rad reflected by ground '//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XREF_SW_GRND(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWE_GO'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='LW emitted by ground'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XEMIT_LW_GRND(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='REF_SW_FA'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Total solar rad reflected by facade '//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XREF_SW_FAC(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWE_FA'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='LW emitted by facade'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XEMIT_LW_FAC(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (TOP%CBEM=='BEM') THEN
    !
    YRECFM='CL_CURT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Current Cooling system temperature set point'//' (K)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XTCOOL_TARGET(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HT_CURT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Current Heating system temperature set point'//' (K)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XTHEAT_TARGET(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='QIN_CUR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Current Building internal heat loads'//' (W m-2(floor))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQIN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='XFLX_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heat flux from bld'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XFLX_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_BLD_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible cooling demand'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_BLD_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='T_BLD_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Total cooling demand'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XT_BLD_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !  
    YRECFM='H_BLD_HT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible heating demand'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_BLD_HEAT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_BLD_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent cooling demand'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_BLD_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_BLD_HT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent heating demand'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_BLD_HEAT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_WASTE'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible waste heat from HVAC'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_WASTE(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_WASTE'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent waste heat from HVAC'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_WASTE(:),IRESP,HCOMMENT=YCOMMENT)  
    !
    YRECFM='HVAC_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cooling energy consumption'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHVAC_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVAC_HT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heating energy consumption'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHVAC_HEAT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='CAP_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual capacity of the cooling system'//' (W m-2(bld))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XCAP_SYS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='M_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual HVAC mass flow rate'//' (kg s-1 m-2(bld))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XM_SYS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='COP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual COP of the cooling system'//' ()'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XCOP(:),IRESP,HCOMMENT=YCOMMENT)  
    !
    YRECFM='Q_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Supply air specific humidity'//' (kg kg-1)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQ_SYS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='T_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Supply air temperature'//' (K)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XT_SYS(:),IRESP,HCOMMENT=YCOMMENT)  
    !
    YRECFM='TR_SW_WIN'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Solar radiation transmitted through windows'//' (W m-2(bld))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XTR_SW_WIN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='FAN_POWER'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='HVAC fan power'//' (W m-2(bld))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XFAN_POWER(:),IRESP,HCOMMENT=YCOMMENT)  
    !
    YRECFM='T_RAD_IND'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Indoor mean radiant temperature'//' (K)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XT_RAD_IND(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HU_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Indoor relative humidity'//' (-)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHU_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWA_WIN'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by windows'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_WIN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_WIN'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by windows'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_WIN(:),IRESP,HCOMMENT=YCOMMENT)    
    !
  ENDIF
  !
  IF (TOP%LGREENROOF) THEN
  !
    WHERE (T%XGREENROOF(:) == 0.)
      GRD%XRN    (:) = XUNDEF   
      GRD%XH     (:) = XUNDEF 
      GRD%XLE    (:) = XUNDEF 
      GRD%XGFLUX (:) = XUNDEF 
      !
      DMT%XABS_SW_GREENROOF(:) = XUNDEF 
      DMT%XABS_LW_GREENROOF(:) = XUNDEF 
      DMT%XG_GREENROOF_ROOF(:) = XUNDEF 
      !
      GRDE%XRUNOFF(:) = XUNDEF 
      GRDE%XDRAIN (:) = XUNDEF 
    END WHERE
    !
    YRECFM='RN_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRD%XRN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible heat flux for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRD%XH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent heat flux for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRD%XLE(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net conduction flux for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRD%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWA_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='G_GR_ROOF'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heat flux between GREENROOF and ROOF'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XG_GREENROOF_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RUNOFF_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF soil surface runoff'//' (kg/m2/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRDE%XRUNOFF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DRAIN_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF total vertical drainage'//' (kg/m2/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRDE%XDRAIN(:),IRESP,HCOMMENT=YCOMMENT)
  !
    WHERE (T%XGREENROOF(:) == 1.)
      DMT%XRN_STRLROOF(:)     = XUNDEF   
      DMT%XH_STRLROOF(:)      = XUNDEF   
      DMT%XLE_STRLROOF(:)     = XUNDEF   
      DMT%XGFLUX_STRLROOF(:)  = XUNDEF   
      DMT%XRUNOFF_STRLROOF(:) = XUNDEF   
    END WHERE
    !
    YRECFM='RN_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof net radiation'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof sensible heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof latent heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof conduction flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RUNOFF_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof surface runoff'//' (kg/m2/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRUNOFF_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  !* solar panels
  IF (TOP%LSOLAR_PANEL) THEN
    YRECFM='SWA_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Shortwave absorbed by solar panels on roofs'//' (W/m2 panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Longwave  absorbed by solar panels on roofs'//' (W/m2 panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RN_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Net radiation of solar panels on roofs'//' (W/m2 panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sensible Heat flux  from solar panels on roofs'//' (W/m2 panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='PHOT_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Photovolatic production '//' (W/m2 photovoltaic panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XPHOT_PROD_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='THER_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Hot Water production '//' (W/m2 thermal panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XTHER_PROD_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='PROD_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Production by solar panels on roofs'//' (W/m2 panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XPROD_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
        !
    YRECFM='PHOT_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Photovolatic production '//' (W/m2 bld)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XPHOT_PROD_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='THER_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Hot Water production '//' (W/m2 bld)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XTHER_PROD_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
  !
  !*
  !*       3. Cumulated fields
  !           ----------------
  !
  CALL END_IO_SURF_n(HPROGRAM)
  CALL INIT_IO_SURF_n(DTCO, U,HPROGRAM,'TOWN  ','TEB   ','WRITE','TEB_DIAG_CUMUL.OUT.nc')
  !  
  IF  (TOP%CBEM=='BEM') THEN
    !
    YRECFM='HVACC_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated cooling energy consumption'//' (J/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHVAC_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVACC_HT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated heating energy consumption'//' (J/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHVAC_HEAT(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
  !
  YRECFM='RUNOFFC_TW'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated aggregated runoff for town'//' (kg/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XRUNOFF_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFFC_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated road surface runoff'//' (kg/m2 road)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XRUNOFF_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFFC_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated aggregated roof runoff'//' (kg/m2 roof)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XRUNOFF_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='IRRIGC_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated road irrigation'//' (kg/m2 road)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XIRRIG_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (TOP%LGARDEN) THEN
    !
    YRECFM='RUNOFFC_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated garden surface runoff'//' (kg/m2 garden)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDDEC%XRUNOFF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DRAINC_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated garden surface drainage'//' (kg/m2 garden)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDDEC%XDRAIN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='IRRIGC_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated garden irrigation'//' (kg/m2 garden)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XIRRIG_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
  !
  IF (TOP%LGREENROOF) THEN
    !
    WHERE (T%XGREENROOF(:) == 0.)
      GRDEC%XRUNOFF (:) = XUNDEF   
      GRDEC%XDRAIN  (:) = XUNDEF 
      DMTC%XIRRIG_GREENROOF  (:) = XUNDEF 
    END WHERE
    !  
    YRECFM='RUNOFFC_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF cumulated soil surface runoff'//' (kg/m2 greenroof)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRDEC%XRUNOFF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DRAINC_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF cumulated total vertical drainage'//' (kg/m2 greenroof)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRDEC%XDRAIN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    !
    YRECFM='IRRIGC_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF cumulated irrigation'//' (kg/m2 greenroof)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XIRRIG_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    WHERE (T%XGREENROOF(:) == 1.)
      DMTC%XRUNOFF_STRLROOF  (:) = XUNDEF   
    END WHERE 
    !
    YRECFM='RUNOFFC_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated structural roof surface runoff'//' (kg/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XRUNOFF_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
  !  
  !* solar panels
  IF (TOP%LSOLAR_PANEL) THEN
    !
    YRECFM='PHOTC_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Cumulated Photovolatic production '//' (J/m2 bld)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XPHOT_PROD_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='THERC_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Cumulated Hot water production '//' (J/m2 bld)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XTHER_PROD_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
  !
  !-------------------------------------------------------------------------------
  !
  !         End of IO
  !
  CALL END_IO_SURF_n(HPROGRAM)
  !
END IF
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_MISC_TEB_N',1,ZHOOK_HANDLE)
!
END SUBROUTINE WRITE_DIAG_MISC_TEB_n
