!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
    FUNCTION VEGTYPE_TO_PATCH(IVEGTYPE,INPATCH ) RESULT(IPATCH_NB) 
!   ####################################################
!!
!!    PURPOSE
!!    -------
!
!  Calculation of patch indices coresponding to different  vegtype
!          according to the  number of patch  (NPATCH).
!             
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!    none
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!      
!!    none
!!
!!    REFERENCE
!!    ---------
!!
!!      
!!    AUTHOR
!!    ------
!    F.Solmon/V.Masson 06/00 
!
!!    MODIFICATIONS
!!    -------------
!    R. Alkama       05/2012 : new vegtypes (19 rather than 12)
!-------------------------------------------------------------------------------
!
!*       0.     DECLARATIONS
!               ------------
!
USE MODD_DATA_COVER_PAR, ONLY : NVT_NO, NVT_ROCK, NVT_SNOW, NVT_TEBD,    & 
                                 NVT_BONE, NVT_TRBE, NVT_C3, NVT_C4,     &
                                 NVT_IRR, NVT_GRAS, NVT_TROG,NVT_PARK,   &
                                 NVT_TRBD, NVT_TEBE, NVT_TENE, NVT_BOBD, &
                                 NVT_BOND, NVT_BOGR, NVT_SHRB, NVT_C3W,  &
                                 NVT_C3S, NVT_FLTR, NVT_FLGR, NVEGTYPE
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_ABOR1_SFX
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
INTEGER,        INTENT(IN) :: IVEGTYPE !indices of vegetation type           
INTEGER,        INTENT(IN) :: INPATCH  !total number of PATCHES used 
!
INTEGER                    :: IPATCH_NB! PATCH index corresponding to the vegtype IVEGTYPE  
!
 CHARACTER(LEN=2) :: YVEGTYPE
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!*      0.2    declarations of local variables
!
!-----------------------------------------------------------------

IF (LHOOK) CALL DR_HOOK('VEGTYPE_TO_PATCH',0,ZHOOK_HANDLE)
IF (INPATCH==1) THEN
  IPATCH_NB = 1 ! default case
END IF

!forest 
IF (INPATCH==2) THEN
   IF (IVEGTYPE== NVT_TEBD  .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD  .OR. IVEGTYPE== NVT_SHRB .OR. IVEGTYPE== NVT_BONE .OR. &
       IVEGTYPE== NVT_TENE  .OR. IVEGTYPE== NVT_BOND .OR. IVEGTYPE== NVT_TRBE) THEN
       IPATCH_NB = 2
   ELSE
       IPATCH_NB = 1
   END IF
END IF

!forest + low vegeation differenciation
IF (INPATCH==3) THEN
   IF (IVEGTYPE== NVT_NO   .OR. IVEGTYPE== NVT_ROCK .OR. IVEGTYPE== NVT_SNOW ) IPATCH_NB = 1
   IF (IVEGTYPE== NVT_TEBD .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD .OR. IVEGTYPE== NVT_SHRB .OR. IVEGTYPE== NVT_BONE .OR. &
       IVEGTYPE== NVT_TENE .OR. IVEGTYPE== NVT_BOND .OR. IVEGTYPE== NVT_TRBE .OR. &
       IVEGTYPE== NVT_FLTR ) IPATCH_NB = 2
   IF (IVEGTYPE== NVT_GRAS .OR. IVEGTYPE== NVT_BOGR .OR. IVEGTYPE== NVT_TROG .OR. &
       IVEGTYPE== NVT_PARK .OR. IVEGTYPE== NVT_C3   .OR. IVEGTYPE== NVT_C3W  .OR. &
       IVEGTYPE== NVT_C3S  .OR. IVEGTYPE== NVT_C4   .OR. IVEGTYPE== NVT_IRR  .OR. &
       IVEGTYPE== NVT_FLGR ) IPATCH_NB = 3
END IF
!
!differenciation between irrigated crops and grassland and other low vegetation
IF (INPATCH==4) THEN
   IF (IVEGTYPE== NVT_NO   .OR. IVEGTYPE== NVT_ROCK .OR. IVEGTYPE== NVT_SNOW ) IPATCH_NB = 1
   IF (IVEGTYPE== NVT_TEBD .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD .OR. IVEGTYPE== NVT_SHRB .OR. IVEGTYPE== NVT_BONE .OR. &
       IVEGTYPE== NVT_TENE .OR. IVEGTYPE== NVT_BOND .OR. IVEGTYPE== NVT_TRBE .OR. &
       IVEGTYPE== NVT_FLTR ) IPATCH_NB = 2
   IF (IVEGTYPE== NVT_GRAS .OR. IVEGTYPE== NVT_BOGR .OR. IVEGTYPE== NVT_TROG .OR. &
       IVEGTYPE== NVT_C3   .OR. IVEGTYPE== NVT_C3W  .OR. IVEGTYPE== NVT_C3S  .OR. &
       IVEGTYPE== NVT_C4 )   IPATCH_NB = 3
   IF (IVEGTYPE== NVT_IRR  .OR. IVEGTYPE== NVT_PARK .OR. IVEGTYPE== NVT_FLGR) IPATCH_NB = 4
END IF
!
!differenciation between crops and other low vegetation
IF (INPATCH==5) THEN
   IF (IVEGTYPE== NVT_NO   .OR. IVEGTYPE== NVT_ROCK .OR. IVEGTYPE== NVT_SNOW ) IPATCH_NB = 1
   IF (IVEGTYPE== NVT_TEBD .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD .OR. IVEGTYPE== NVT_SHRB .OR. IVEGTYPE== NVT_BONE .OR. &
       IVEGTYPE== NVT_TENE .OR. IVEGTYPE== NVT_BOND .OR. IVEGTYPE== NVT_TRBE .OR. &
       IVEGTYPE== NVT_FLTR ) IPATCH_NB = 2   
   IF (IVEGTYPE==  NVT_C3  .OR. IVEGTYPE== NVT_C3W  .OR. IVEGTYPE== NVT_C3S .OR. &
       IVEGTYPE== NVT_C4 )   IPATCH_NB = 3
   IF (IVEGTYPE== NVT_IRR  .OR. IVEGTYPE== NVT_PARK .OR. IVEGTYPE== NVT_FLGR ) IPATCH_NB = 4
   IF (IVEGTYPE== NVT_GRAS .OR. IVEGTYPE== NVT_BOGR .OR. IVEGTYPE== NVT_TROG ) IPATCH_NB = 5
END IF
!
!differenciation between irrigated crops / flooded trees and gardens / flooded grassland
IF (INPATCH==6) THEN
   IF (IVEGTYPE== NVT_NO   .OR. IVEGTYPE== NVT_ROCK .OR. IVEGTYPE== NVT_SNOW ) IPATCH_NB = 1
   IF (IVEGTYPE== NVT_TEBD .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD .OR. IVEGTYPE== NVT_SHRB .OR. IVEGTYPE== NVT_BONE .OR. &
       IVEGTYPE== NVT_TENE .OR. IVEGTYPE== NVT_BOND .OR. IVEGTYPE== NVT_TRBE ) IPATCH_NB = 2      
   IF (IVEGTYPE== NVT_C3   .OR. IVEGTYPE== NVT_C3W  .OR. IVEGTYPE== NVT_C3S  .OR. &
       IVEGTYPE== NVT_C4 ) IPATCH_NB = 3
   IF (IVEGTYPE== NVT_IRR  .OR. IVEGTYPE== NVT_FLTR) IPATCH_NB = 4
   IF (IVEGTYPE== NVT_GRAS .OR. IVEGTYPE== NVT_BOGR .OR. IVEGTYPE== NVT_TROG ) IPATCH_NB = 5
   IF (IVEGTYPE== NVT_PARK .OR. IVEGTYPE== NVT_FLGR) IPATCH_NB = 6
END IF
!
!differenciation between snow and other bare soils
IF (INPATCH==7) THEN
   IF (IVEGTYPE== NVT_NO   .OR. IVEGTYPE== NVT_ROCK ) IPATCH_NB = 1
   IF (IVEGTYPE== NVT_SNOW) IPATCH_NB = 2
   IF (IVEGTYPE== NVT_TEBD .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD .OR. IVEGTYPE== NVT_SHRB .OR. IVEGTYPE== NVT_BONE .OR. &
       IVEGTYPE== NVT_TENE .OR. IVEGTYPE== NVT_BOND .OR. IVEGTYPE== NVT_TRBE) IPATCH_NB = 3      
   IF (IVEGTYPE==  NVT_C3  .OR. IVEGTYPE== NVT_C3W  .OR. IVEGTYPE== NVT_C3S  .OR. &
       IVEGTYPE== NVT_C4 )  IPATCH_NB = 4
   IF (IVEGTYPE== NVT_IRR  .OR. IVEGTYPE== NVT_FLTR)  IPATCH_NB = 5
   IF (IVEGTYPE== NVT_GRAS .OR. IVEGTYPE== NVT_BOGR .OR. IVEGTYPE== NVT_TROG) IPATCH_NB = 6
   IF (IVEGTYPE== NVT_PARK .OR. IVEGTYPE== NVT_FLGR)  IPATCH_NB = 7
END IF
!
!differenciation between C3 and C4 crops
IF (INPATCH==8) THEN
   IF (IVEGTYPE== NVT_NO   .OR. IVEGTYPE== NVT_ROCK ) IPATCH_NB = 1
   IF (IVEGTYPE== NVT_SNOW)  IPATCH_NB = 2
   IF (IVEGTYPE== NVT_TEBD .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD .OR. IVEGTYPE== NVT_SHRB .OR. IVEGTYPE== NVT_BONE .OR. &
       IVEGTYPE== NVT_TENE .OR. IVEGTYPE== NVT_BOND .OR. IVEGTYPE== NVT_TRBE) IPATCH_NB = 3      
   IF (IVEGTYPE==  NVT_C3  .OR. IVEGTYPE== NVT_C3W  .OR. IVEGTYPE== NVT_C3S)  IPATCH_NB = 4
   IF (IVEGTYPE==  NVT_C4  )  IPATCH_NB = 5
   IF (IVEGTYPE==  NVT_IRR  .OR. IVEGTYPE== NVT_FLTR)  IPATCH_NB = 6
   IF (IVEGTYPE==  NVT_GRAS .OR. IVEGTYPE== NVT_BOGR .OR. IVEGTYPE== NVT_TROG) IPATCH_NB = 7
   IF (IVEGTYPE==  NVT_PARK .OR. IVEGTYPE== NVT_FLGR)  IPATCH_NB = 8
END IF

!
!differenciation between coniferous and broadleaf forests
IF (INPATCH==9) THEN
   IF (IVEGTYPE== NVT_NO   .OR. IVEGTYPE== NVT_ROCK ) IPATCH_NB = 1
   IF (IVEGTYPE== NVT_SNOW)  IPATCH_NB = 2
   IF (IVEGTYPE== NVT_TEBD .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD .OR. IVEGTYPE== NVT_SHRB .OR. IVEGTYPE== NVT_TRBE )IPATCH_NB = 3
   IF (IVEGTYPE== NVT_BONE .OR. IVEGTYPE== NVT_TENE .OR. IVEGTYPE== NVT_BOND) IPATCH_NB = 4    
   IF (IVEGTYPE== NVT_C3   .OR. IVEGTYPE== NVT_C3W  .OR. IVEGTYPE== NVT_C3S)  IPATCH_NB = 5
   IF (IVEGTYPE== NVT_C4  )  IPATCH_NB = 6
   IF (IVEGTYPE== NVT_IRR  .OR. IVEGTYPE== NVT_FLTR)  IPATCH_NB = 7
   IF (IVEGTYPE== NVT_GRAS .OR. IVEGTYPE== NVT_BOGR .OR. IVEGTYPE== NVT_TROG) IPATCH_NB = 8
   IF (IVEGTYPE== NVT_PARK .OR. IVEGTYPE== NVT_FLGR)  IPATCH_NB = 9
END IF

!
!differenciation between evergreen and deciduous broadleaf forests
IF (INPATCH==10) THEN
   IF (IVEGTYPE== NVT_NO   .OR. IVEGTYPE== NVT_ROCK ) IPATCH_NB = 1
   IF (IVEGTYPE== NVT_SNOW)  IPATCH_NB = 2
   IF (IVEGTYPE== NVT_TEBD .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD .OR. IVEGTYPE== NVT_SHRB) IPATCH_NB = 3
   IF (IVEGTYPE== NVT_BONE .OR. IVEGTYPE== NVT_TENE .OR. IVEGTYPE== NVT_BOND) IPATCH_NB = 4
   IF (IVEGTYPE== NVT_TRBE  ) IPATCH_NB = 5   
   IF (IVEGTYPE== NVT_C3   .OR. IVEGTYPE== NVT_C3W  .OR. IVEGTYPE== NVT_C3S)  IPATCH_NB = 6
   IF (IVEGTYPE== NVT_C4  )   IPATCH_NB = 7
   IF (IVEGTYPE== NVT_IRR  .OR. IVEGTYPE== NVT_FLTR)  IPATCH_NB = 8
   IF (IVEGTYPE== NVT_GRAS .OR. IVEGTYPE== NVT_BOGR .OR. IVEGTYPE== NVT_TROG) IPATCH_NB = 9
   IF (IVEGTYPE== NVT_PARK .OR. IVEGTYPE== NVT_FLGR)  IPATCH_NB = 10
END IF

!
!differenciation between rocks and flat bare soil
IF (INPATCH==11) THEN
   IF (IVEGTYPE==  NVT_NO   ) IPATCH_NB = 1
   IF (IVEGTYPE==  NVT_ROCK ) IPATCH_NB = 2
   IF (IVEGTYPE==  NVT_SNOW ) IPATCH_NB = 3
   IF (IVEGTYPE== NVT_TEBD .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD .OR. IVEGTYPE== NVT_SHRB) IPATCH_NB = 4
   IF (IVEGTYPE== NVT_BONE .OR. IVEGTYPE== NVT_TENE .OR. IVEGTYPE== NVT_BOND) IPATCH_NB = 5
   IF (IVEGTYPE== NVT_TRBE  )  IPATCH_NB = 6  
   IF (IVEGTYPE== NVT_C3   .OR. IVEGTYPE== NVT_C3W  .OR. IVEGTYPE== NVT_C3S ) IPATCH_NB = 7
   IF (IVEGTYPE== NVT_C4  )  IPATCH_NB = 8
   IF (IVEGTYPE== NVT_IRR  .OR. IVEGTYPE== NVT_FLTR)  IPATCH_NB = 9
   IF (IVEGTYPE== NVT_GRAS .OR. IVEGTYPE== NVT_BOGR .OR. IVEGTYPE== NVT_TROG) IPATCH_NB = 10
   IF (IVEGTYPE== NVT_PARK .OR. IVEGTYPE== NVT_FLGR)  IPATCH_NB = 11
END IF
!
!differenciation between tropical and temperate grasslands
IF (INPATCH==12) THEN
   IF (IVEGTYPE==  NVT_NO   ) IPATCH_NB = 1
   IF (IVEGTYPE==  NVT_ROCK ) IPATCH_NB = 2
   IF (IVEGTYPE==  NVT_SNOW ) IPATCH_NB = 3
   IF (IVEGTYPE== NVT_TEBD .OR. IVEGTYPE== NVT_TRBD .OR. IVEGTYPE== NVT_TEBE .OR. &
       IVEGTYPE== NVT_BOBD .OR. IVEGTYPE== NVT_SHRB) IPATCH_NB = 4
   IF (IVEGTYPE== NVT_BONE .OR. IVEGTYPE== NVT_TENE .OR. IVEGTYPE== NVT_BOND) IPATCH_NB = 5
   IF (IVEGTYPE== NVT_TRBE ) IPATCH_NB = 6  
   IF (IVEGTYPE== NVT_C3   .OR. IVEGTYPE== NVT_C3W  .OR. IVEGTYPE== NVT_C3S ) IPATCH_NB = 7
   IF (IVEGTYPE== NVT_C4   ) IPATCH_NB = 8
   IF (IVEGTYPE== NVT_IRR  .OR. IVEGTYPE== NVT_FLTR) IPATCH_NB = 9
   IF (IVEGTYPE== NVT_GRAS .OR. IVEGTYPE== NVT_BOGR) IPATCH_NB = 10
   IF (IVEGTYPE== NVT_TROG ) IPATCH_NB = 11
   IF (IVEGTYPE== NVT_PARK .OR. IVEGTYPE== NVT_FLGR) IPATCH_NB = 12
END IF
!
IF (INPATCH==19 .OR. INPATCH==20) THEN
  IPATCH_NB = IVEGTYPE
END IF
!
WRITE(YVEGTYPE,"(I2.2)") NVEGTYPE
IF (INPATCH>12.AND.INPATCH<NVEGTYPE) THEN
  CALL ABOR1_SFX('VEGTYPE_TO_PATCH: NPATCH MUST BE INFERIOR OR EQUAL TO 12 OR EQUAL TO '//YVEGTYPE)
END IF
IF (INPATCH>NVEGTYPE) THEN
  CALL ABOR1_SFX('VEGTYPE_TO_PATCH: NPATCH BIGGER THAN '//YVEGTYPE//' IS TOO LARGE')
END IF
IF (LHOOK) CALL DR_HOOK('VEGTYPE_TO_PATCH',1,ZHOOK_HANDLE)

!
END FUNCTION VEGTYPE_TO_PATCH
