!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE READ_PGD_TEB_IRRIG_n (G, TIR, HPROGRAM)
!     ################################################
!
!!****  *READ_PGD_TEB_IRRIG_n* - reads ISBA physiographic fields
!!                        
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    05/2005
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
!
!
!
USE MODD_SFX_GRID_n, ONLY : GRID_t
USE MODD_TEB_IRRIG_n, ONLY : TEB_IRRIG_t
!
USE MODI_READ_SURF
USE MODI_GET_LUOUT
USE MODI_ABOR1_SFX
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
!
!
TYPE(GRID_t), INTENT(INOUT) :: G
TYPE(TEB_IRRIG_t), INTENT(INOUT) :: TIR
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: ILUOUT         ! output listing logical unit
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=80) :: YCOMMENT       ! Comment of the article to be read
INTEGER           :: JLAYER         ! loop index
!
INTEGER           :: IVERSION       ! surface version
INTEGER           :: IBUGFIX        ! surface bugfix version
REAL, DIMENSION(G%NDIM) :: ZWORK      ! work array
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_IRRIG_N',0,ZHOOK_HANDLE)
!
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
YRECFM='VERSION'
 CALL READ_SURF(HPROGRAM,YRECFM,IVERSION,IRESP)
YRECFM='BUG'
 CALL READ_SURF(HPROGRAM,YRECFM,IBUGFIX,IRESP)
!
IF (IVERSION<7 .OR. (IVERSION==7 .AND. IBUGFIX<=3)) THEN
  !
  TIR%LPAR_GD_IRRIG = .FALSE.
  TIR%LPAR_GR_IRRIG = .FALSE.
  TIR%LPAR_RD_IRRIG = .FALSE.
  !
ELSE
  !
  YRECFM='L_PAR_GD_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%LPAR_GD_IRRIG,IRESP)
  YRECFM='L_PAR_GR_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%LPAR_GR_IRRIG,IRESP)
  YRECFM='L_PAR_RD_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%LPAR_RD_IRRIG,IRESP)
  !
ENDIF
!
!* read garden irrigation
!
IF (TIR%LPAR_GD_IRRIG) THEN
  ALLOCATE(TIR%XGD_START_MONTH(G%NDIM))
  YRECFM='D_GD_SM_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XGD_START_MONTH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XGD_END_MONTH  (G%NDIM))
  YRECFM='D_GD_EM_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XGD_END_MONTH  (:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XGD_START_HOUR (G%NDIM))
  YRECFM='D_GD_SH_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XGD_START_HOUR (:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XGD_END_HOUR   (G%NDIM))
  YRECFM='D_GD_EH_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XGD_END_HOUR   (:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XGD_24H_IRRIG  (G%NDIM))
  YRECFM='D_GD_IRRIG'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XGD_24H_IRRIG  (:),IRESP,HCOMMENT=YCOMMENT)
ELSE
  ALLOCATE(TIR%XGD_START_MONTH(0))
  ALLOCATE(TIR%XGD_END_MONTH  (0))
  ALLOCATE(TIR%XGD_START_HOUR (0))
  ALLOCATE(TIR%XGD_END_HOUR   (0))
  ALLOCATE(TIR%XGD_24H_IRRIG  (0))
END IF
!
!* read greenroof irrigation
!
IF (TIR%LPAR_GR_IRRIG) THEN
  ALLOCATE(TIR%XGR_START_MONTH(G%NDIM))
  YRECFM='D_GR_SM_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XGR_START_MONTH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XGR_END_MONTH  (G%NDIM))
  YRECFM='D_GR_EM_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XGR_END_MONTH  (:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XGR_START_HOUR (G%NDIM))
  YRECFM='D_GR_SH_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XGR_START_HOUR (:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XGR_END_HOUR   (G%NDIM))
  YRECFM='D_GR_EH_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XGR_END_HOUR   (:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XGR_24H_IRRIG  (G%NDIM))
  YRECFM='D_GR_IRRIG'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XGR_24H_IRRIG  (:),IRESP,HCOMMENT=YCOMMENT)
ELSE
  ALLOCATE(TIR%XGR_START_MONTH(0))
  ALLOCATE(TIR%XGR_END_MONTH  (0))
  ALLOCATE(TIR%XGR_START_HOUR (0))
  ALLOCATE(TIR%XGR_END_HOUR   (0))
  ALLOCATE(TIR%XGR_24H_IRRIG  (0))
END IF
!
!* read road watering
!
IF (TIR%LPAR_RD_IRRIG) THEN
  ALLOCATE(TIR%XRD_START_MONTH(G%NDIM))
  YRECFM='D_RD_SM_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XRD_START_MONTH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XRD_END_MONTH  (G%NDIM))
  YRECFM='D_RD_EM_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XRD_END_MONTH  (:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XRD_START_HOUR (G%NDIM))
  YRECFM='D_RD_SH_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XRD_START_HOUR (:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XRD_END_HOUR   (G%NDIM))
  YRECFM='D_RD_EH_IRR'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XRD_END_HOUR   (:),IRESP,HCOMMENT=YCOMMENT)
  !
  ALLOCATE(TIR%XRD_24H_IRRIG  (G%NDIM))
  YRECFM='D_RD_IRRIG'
  CALL READ_SURF(HPROGRAM,YRECFM,TIR%XRD_24H_IRRIG  (:),IRESP,HCOMMENT=YCOMMENT)
ELSE
  ALLOCATE(TIR%XRD_START_MONTH(0))
  ALLOCATE(TIR%XRD_END_MONTH  (0))
  ALLOCATE(TIR%XRD_START_HOUR (0))
  ALLOCATE(TIR%XRD_END_HOUR   (0))
  ALLOCATE(TIR%XRD_24H_IRRIG  (0))
END IF

!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_IRRIG_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE READ_PGD_TEB_IRRIG_n
