!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE READ_PGD_ISBA_PAR_n (DTCO, U, GCP, DTI, KDIM, IO, HPROGRAM,KSIZE,OLAND_USE, TPDATE_BEG, TPDATE_END, HDIR)
!     ################################################
!
!!****  *READ_PGD_ISBA_PAR_n* - reads ISBA physiographic fields                     
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003 
!!      P. Le Moigne 12/2004 : add type of photosynthesis 
!!      P. Samuelsson 02/2012 : MEB
!!      B. Decharme    01/16 : Bug when vegetation veg, z0 and emis are imposed whith interactive vegetation
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_GRID_CONF_PROJ_n, ONLY : GRID_CONF_PROJ_t
!
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
USE MODD_SURF_PAR, ONLY : XUNDEF
USE MODD_TYPE_DATE_SURF, ONLY : DATE
!
USE MODD_ASSIM, ONLY : LREAD_ALL, LASSIM
!
USE MODD_DATA_COVER_PAR, ONLY : NVEGTYPE, NVEGTYPE_OLD, NVEGTYPE_ECOSG
USE MODD_PREP,           ONLY : LINTERP
!
USE MODI_GET_LUOUT
USE MODI_READ_SURF
USE MODI_MAKE_CHOICE_ARRAY
USE MODI_HOR_INTERPOL
USE MODI_READ_SURF_ISBA_PAR_n
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(GRID_CONF_PROJ_t),INTENT(INOUT) :: GCP
!
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTI
INTEGER, INTENT(IN) :: KDIM
TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
!
CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
INTEGER,           INTENT(IN)  :: KSIZE
LOGICAL,           INTENT(IN)  :: OLAND_USE ! 
TYPE(DATE), INTENT(IN) :: TPDATE_BEG
TYPE(DATE), INTENT(IN) :: TPDATE_END
CHARACTER(LEN=1),OPTIONAL,INTENT(IN)  :: HDIR       ! type of field :
!                                                   ! 'H' : field with
!                                                   !       horizontal spatial dim.
!                                                   ! '-' : no horizontal dim.
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
REAL, DIMENSION(KSIZE,NVEGTYPE) :: ZFIELD
REAL,    DIMENSION(:,:), ALLOCATABLE :: ZWORK
LOGICAL, DIMENSION(36) :: GTIME
INTEGER           :: ILUOUT
INTEGER           :: ITIME
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
CHARACTER(LEN=16) :: YRECFM2
CHARACTER(LEN=100):: YCOMMENT
CHARACTER(LEN=1)  :: YDIR
INTEGER           :: JT          ! loop index
INTEGER           :: JL         ! loop index
INTEGER           :: IVERSION       ! surface version
INTEGER           :: IBUGFIX
INTEGER           :: ISIZE_LMEB_PATCH
INTEGER           :: IENDT, IEND, ID1, ID2, JT_BEG, JT_END
!
LOGICAL :: GREAD_ALL, GDIM, GDIM2
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_ISBA_PAR_N',0,ZHOOK_HANDLE)
!
CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
YDIR = 'H'
IF (PRESENT(HDIR)) YDIR = HDIR
!
IF (LASSIM) THEN
  GREAD_ALL = LREAD_ALL
  LREAD_ALL = .TRUE.
ENDIF
!
YRECFM='VERSION'
CALL READ_SURF(HPROGRAM,YRECFM,IVERSION,IRESP)
WRITE(ILUOUT,*) 'read version ',IVERSION
!
YRECFM='BUG'
CALL READ_SURF(HPROGRAM,YRECFM,IBUGFIX,IRESP)
!
! 
GDIM = (IVERSION>8 .OR. (IVERSION==8 .AND. IBUGFIX>=1))
GDIM2 = GDIM
IF (GDIM) CALL READ_SURF(HPROGRAM,'SPLIT_PATCH',GDIM2,IRESP)
!
ISIZE_LMEB_PATCH=COUNT(IO%LMEB_PATCH(:))
!
DTI%LDATA_MIXPAR = .FALSE. 
!
IF (GDIM) THEN
  YRECFM='NDATA_TIME'
  CALL READ_SURF(HPROGRAM,YRECFM,DTI%NTIME,IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
DTI%NVEGTYPE = NVEGTYPE
!
ALLOCATE(DTI%LDATA_VEG        (36*NVEGTYPE))
ALLOCATE(DTI%LDATA_LAI        (36*NVEGTYPE))
ALLOCATE(DTI%LDATA_Z0         (36*NVEGTYPE))
ALLOCATE(DTI%LDATA_EMIS       (36*NVEGTYPE))
ALLOCATE(DTI%LDATA_ALBNIR_VEG (36*NVEGTYPE))
ALLOCATE(DTI%LDATA_ALBVIS_VEG (36*NVEGTYPE))
ALLOCATE(DTI%LDATA_ALBUV_VEG  (36*NVEGTYPE))
ALLOCATE(DTI%LDATA_ALBNIR_SOIL(36*NVEGTYPE))
ALLOCATE(DTI%LDATA_ALBVIS_SOIL(36*NVEGTYPE))
ALLOCATE(DTI%LDATA_ALBUV_SOIL (36*NVEGTYPE))
ALLOCATE(DTI%LDATA_IRRIG      (36*NVEGTYPE))
ALLOCATE(DTI%LDATA_WATSUP     (36*NVEGTYPE))
DTI%LDATA_VEG        (:) = .FALSE.
DTI%LDATA_LAI        (:) = .FALSE.
DTI%LDATA_Z0         (:) = .FALSE.
DTI%LDATA_EMIS       (:) = .FALSE.
DTI%LDATA_ALBNIR_VEG (:) = .FALSE.
DTI%LDATA_ALBVIS_VEG (:) = .FALSE.
DTI%LDATA_ALBUV_VEG  (:) = .FALSE.
DTI%LDATA_ALBNIR_SOIL(:) = .FALSE.
DTI%LDATA_ALBVIS_SOIL(:) = .FALSE.
DTI%LDATA_ALBUV_SOIL (:) = .FALSE.
DTI%LDATA_IRRIG      (:) = .FALSE.
DTI%LDATA_WATSUP     (:) = .FALSE.
!
IF (IVERSION<7 .AND. .NOT.IO%LECOCLIMAP) THEN
  !
  DTI%LDATA_VEGTYPE =.TRUE.
  !
  DTI%LDATA_VEG     =.TRUE.
  DTI%LDATA_LAI     =.TRUE.
  DTI%LDATA_Z0      =.TRUE.
  DTI%LDATA_EMIS    =.TRUE.
  DTI%LDATA_ALBNIR_VEG =.TRUE.
  DTI%LDATA_ALBVIS_VEG =.TRUE.
  DTI%LDATA_ALBUV_VEG  =.TRUE.
  DTI%LDATA_ALBNIR_SOIL=.TRUE.
  DTI%LDATA_ALBVIS_SOIL=.TRUE.
  DTI%LDATA_ALBUV_SOIL =.TRUE. 
  DTI%LDATA_IRRIG =.FALSE.
  DTI%LDATA_WATSUP=.FALSE.  
  !
  DTI%LDATA_RSMIN   =.TRUE.
  DTI%LDATA_GAMMA   =.TRUE.
  DTI%LDATA_WRMAX_CF=.TRUE.
  DTI%LDATA_RGL     =.TRUE.
  DTI%LDATA_CV      =.TRUE.
  DTI%LDATA_Z0_O_Z0H=.TRUE.
  DTI%LDATA_DG      =.TRUE.
  DTI%LDATA_ROOTFRAC=.TRUE.
  !
  DTI%LDATA_DICE           =.FALSE.
  DTI%LDATA_GROUND_DEPTH   =.FALSE.
  DTI%LDATA_ROOT_DEPTH     =.FALSE.
  DTI%LDATA_ROOT_LIN       =.FALSE.
  DTI%LDATA_ROOT_EXTINCTION=.FALSE.  
  !
  DTI%LDATA_GMES       =.TRUE.
  DTI%LDATA_BSLAI      =.TRUE.
  DTI%LDATA_LAIMIN     =.TRUE.
  DTI%LDATA_SEFOLD     =.TRUE.
  DTI%LDATA_GC         =.TRUE.
  DTI%LDATA_DMAX       =.TRUE.
  DTI%LDATA_F2I        =.TRUE.
  DTI%LDATA_STRESS     =.TRUE.
  DTI%LDATA_H_TREE     =.TRUE.
  DTI%LDATA_RE25       =.TRUE.
  DTI%LDATA_CE_NITRO   =.TRUE.
  DTI%LDATA_CF_NITRO   =.TRUE.
  DTI%LDATA_CNA_NITRO  =.TRUE.
  !
  DTI%LDATA_SEED_M=.FALSE.
  DTI%LDATA_SEED_D=.FALSE.
  DTI%LDATA_REAP_M=.FALSE.
  DTI%LDATA_REAP_D=.FALSE.
  !
ENDIF
!
ALLOCATE(DTI%LDATA_GNDLITTER(36*NVEGTYPE))
ALLOCATE(DTI%LDATA_Z0LITTER (36*NVEGTYPE))
ALLOCATE(DTI%LDATA_H_VEG    (36*NVEGTYPE))
DTI%LDATA_GNDLITTER(:) = .FALSE.
DTI%LDATA_Z0LITTER (:) = .FALSE.
DTI%LDATA_H_VEG    (:) = .FALSE.
!
DTI%LIMP_VEG =.FALSE.
DTI%LIMP_Z0  =.FALSE.
DTI%LIMP_EMIS=.FALSE.
!
IF (GDIM) THEN
  IENDT = NVEGTYPE * DTI%NTIME
  IEND  = MAX(NVEGTYPE_OLD,NVEGTYPE_ECOSG)
ELSE
  IENDT = 1
  IEND  = 1
ENDIF
!
!
IF (.NOT.OLAND_USE) THEN
  !
  IF (IVERSION>=7) THEN
    !
    YRECFM='L_VEGTYPE'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_VEGTYPE,IRESP,HCOMMENT=YCOMMENT)
    IF (DTI%LDATA_VEGTYPE) DTI%LDATA_MIXPAR = .TRUE.
    !
    YRECFM='L_VEG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_VEG(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_VEG)) THEN
      DTI%LDATA_MIXPAR = .TRUE.
      DTI%LIMP_VEG     = .TRUE.
    ENDIF
    !
    YRECFM='L_LAI'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_LAI(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_LAI)) DTI%LDATA_MIXPAR = .TRUE.
    !
    YRECFM='L_Z0'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_Z0(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_Z0)) THEN
      DTI%LDATA_MIXPAR = .TRUE.
      DTI%LIMP_Z0      = .TRUE.
    ENDIF
    !    
    YRECFM='L_EMIS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_EMIS(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_EMIS)) THEN
      DTI%LDATA_MIXPAR = .TRUE.
      DTI%LIMP_EMIS    = .TRUE.
    ENDIF    
    !
    YRECFM='L_RSMIN'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_RSMIN(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_RSMIN)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_GAMMA'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_GAMMA(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_GAMMA)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_WRMAX_CF'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_WRMAX_CF(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_WRMAX_CF)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_RGL'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_RGL(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_RGL)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_CV'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_CV(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_CV)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_Z0_O_Z0H'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_Z0_O_Z0H(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_Z0_O_Z0H)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_DG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_DG(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_DG)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ROOTFRAC'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_ROOTFRAC(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_ROOTFRAC)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_DICE'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_DICE(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_DICE)) DTI%LDATA_MIXPAR = .TRUE.
    !
    IF ( (IVERSION==7 .AND. IBUGFIX>=2) .OR. IVERSION>7 ) THEN
      YRECFM2='L_GROUND_DPT'
      CALL READ_SURF(HPROGRAM,YRECFM2,DTI%LDATA_GROUND_DEPTH(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
      IF (ANY(DTI%LDATA_GROUND_DEPTH)) DTI%LDATA_MIXPAR = .TRUE.
      YRECFM='L_ROOT_DEPTH'
      CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_ROOT_DEPTH(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
      IF (ANY(DTI%LDATA_ROOT_DEPTH)) DTI%LDATA_MIXPAR = .TRUE.
      YRECFM='L_ROOT_EXT'
      CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_ROOT_EXTINCTION(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
      IF (ANY(DTI%LDATA_ROOT_EXTINCTION)) DTI%LDATA_MIXPAR = .TRUE.
      YRECFM='L_ROOT_LIN'
      CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_ROOT_LIN(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
      IF (ANY(DTI%LDATA_ROOT_LIN)) DTI%LDATA_MIXPAR = .TRUE.
    ELSE
      DTI%LDATA_GROUND_DEPTH = .FALSE.
      DTI%LDATA_ROOT_DEPTH   = .FALSE.
      DTI%LDATA_ROOT_EXTINCTION = .FALSE.
      DTI%LDATA_ROOT_LIN = .FALSE.
    ENDIF
    !
    YRECFM='L_ALBNIR_VEG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_ALBNIR_VEG(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_ALBNIR_VEG)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ALBVIS_VEG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_ALBVIS_VEG(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_ALBVIS_VEG)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ALBUV_VEG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_ALBUV_VEG(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_ALBUV_VEG)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ALBNIR_SOI'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_ALBNIR_SOIL(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_ALBNIR_SOIL)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ALBVIS_SOI'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_ALBVIS_SOIL(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_ALBVIS_SOIL)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_ALBUV_SOI'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_ALBUV_SOIL(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_ALBUV_SOIL)) DTI%LDATA_MIXPAR = .TRUE.
    !
    YRECFM='L_GMES'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_GMES(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_GMES)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_BSLAI'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_BSLAI(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_BSLAI)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_LAIMIN'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_LAIMIN(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_LAIMIN)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_SEFOLD'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_SEFOLD(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_SEFOLD)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_GC'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_GC(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_GC)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_DMAX'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_DMAX(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_DMAX)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_F2I'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_F2I(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_F2I)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_STRESS'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_STRESS(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_STRESS)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_H_TREE'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_H_TREE(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_H_TREE)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_RE25'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_RE25(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_RE25)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_CE_NITRO'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_CE_NITRO(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_CE_NITRO)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_CF_NITRO'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_CF_NITRO(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_CF_NITRO)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_CNA_NITRO'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_CNA_NITRO(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_CNA_NITRO)) DTI%LDATA_MIXPAR = .TRUE.
    !
    YRECFM='L_IRRIG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_IRRIG(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_IRRIG)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_WATSUP'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_WATSUP(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_WATSUP)) DTI%LDATA_MIXPAR = .TRUE.
    !
  ENDIF
  !
  IF (IVERSION>=8.AND.ISIZE_LMEB_PATCH>0) THEN
    !
    YRECFM='L_H_VEG'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_H_VEG(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_H_VEG)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_Z0LITTER'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_Z0LITTER(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_Z0LITTER)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_GNDLITTER'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_GNDLITTER(1:IENDT),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_GNDLITTER)) DTI%LDATA_MIXPAR = .TRUE.
    !
  ENDIF 
  !
  IF (GDIM) THEN
    !
    YRECFM='L_SEED_M'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_SEED_M(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_SEED_M)) DTI%LDATA_MIXPAR = .TRUE.  
    YRECFM='L_SEED_D'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_SEED_D(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_SEED_D)) DTI%LDATA_MIXPAR = .TRUE. 
    YRECFM='L_REAP_M'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_REAP_M(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_REAP_M)) DTI%LDATA_MIXPAR = .TRUE.
    YRECFM='L_REAP_D'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_REAP_D(1:IEND),IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    IF (ANY(DTI%LDATA_REAP_D)) DTI%LDATA_MIXPAR = .TRUE.
    !
    YRECFM='L_CONDSAT'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_CONDSAT,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    YRECFM='L_MPOTSAT'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_MPOTSAT,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    YRECFM='L_BCOEF'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_BCOEF,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    YRECFM='L_WWILT'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_WWILT,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    YRECFM='L_WFC'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_WFC,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    YRECFM='L_WSAT'
    CALL READ_SURF(HPROGRAM,YRECFM,DTI%LDATA_WSAT,IRESP,HCOMMENT=YCOMMENT,HDIR='-')
    !
  ELSE
    !
    DTI%LDATA_SEED_M=.FALSE.
    DTI%LDATA_SEED_D=.FALSE.
    DTI%LDATA_REAP_M=.FALSE.
    DTI%LDATA_REAP_D=.FALSE.
    !
    DTI%LDATA_CONDSAT=.FALSE.
    DTI%LDATA_MPOTSAT=.FALSE.
    DTI%LDATA_BCOEF=.FALSE.
    DTI%LDATA_WWILT=.FALSE.
    DTI%LDATA_WFC=.FALSE.
    DTI%LDATA_WSAT=.FALSE.
    !
  ENDIF     
  !
  IF (ALLOCATED(LINTERP)) LINTERP(:) = .TRUE.
  !
  IF (GDIM .OR. ( ANY(DTI%LDATA_LAI) .OR. ANY(DTI%LDATA_VEG) .OR. &
                         ANY(DTI%LDATA_Z0)  .OR. ANY(DTI%LDATA_EMIS)) ) THEN
    IF (.NOT.GDIM) THEN
      YRECFM='NDATA_TIME'
      CALL READ_SURF(HPROGRAM,YRECFM,DTI%NTIME,IRESP,HCOMMENT=YCOMMENT) 
    ENDIF      
    ITIME = DTI%NTIME
  ELSE
    ITIME = 1
  ENDIF
  !
  IF (ITIME==1) THEN
    JT_BEG = 1
    JT_END = 1
  ELSE
    ! get JT corresponding to DATE_BEG and DATE_END
    ! for ITIME = 36
    JT_BEG = (TPDATE_BEG%MONTH-1) * 3 + CEILING(MIN(TPDATE_BEG%DAY,30)/10.)
    JT_END = (TPDATE_END%MONTH-1) * 3 + CEILING(MIN(TPDATE_END%DAY,30)/10.)
    IF ( TPDATE_END%YEAR > TPDATE_BEG%YEAR+1 ) THEN
      JT_BEG = 1
      JT_END = 36
    ENDIF
    ! for ITIME = DTI%NTIME
    IF (ITIME==2) THEN ! particular case of summer / winter
      IF (JT_BEG<=8.OR.JT_BEG>=27) THEN
        JT_BEG = 1
      ELSE
        JT_BEG = 2
      ENDIF
      IF (JT_END<=8.OR.JT_END>=27) THEN
        JT_END = 1
      ELSE
        JT_END = 2
      ENDIF      
    ELSE 
      JT_BEG = CEILING(JT_BEG/(36./ITIME))
      JT_END = CEILING(JT_END/(36./ITIME))
    ENDIF
  ENDIF
  GTIME(:) = .FALSE.
  IF (TPDATE_END%YEAR>=TPDATE_BEG%YEAR+2) THEN ! if the run contains one whole year
    GTIME(:) = .TRUE. ! all periods must be read
  ELSEIF (TPDATE_END%YEAR==TPDATE_BEG%YEAR+1) THEN ! if the run passes one year
    DO JT = 1,SIZE(GTIME)
      IF (JT>=JT_BEG .OR. JT<=JT_END) GTIME(JT) = .TRUE. ! all periods after JT_BEG and before JT_END are read
    ENDDO
  ELSE ! if the run stays in one only year
    DO JT = 1,SIZE(GTIME)
      IF (JT>=JT_BEG .AND. JT<=JT_END) GTIME(JT) = .TRUE.  ! all periods between JT_BEG and JT_END are read
    ENDDO 
  ENDIF
  !
  !
  IF (DTI%LDATA_VEGTYPE) THEN
    IF (GDIM2) THEN
      YRECFM='D_VEGTY_'
    ELSE
      YRECFM='D_VEGTYPE'
    ENDIF
    CALL MAKE_CHOICE_ARRAY(HPROGRAM, NVEGTYPE, GDIM2, YRECFM, ZFIELD(:,:),HDIR=YDIR)
    ALLOCATE(DTI%XPAR_VEGTYPE(KDIM,NVEGTYPE))
    IF (KDIM/=KSIZE) THEN
      CALL HOR_INTERPOL(DTCO, U, GCP, ILUOUT,ZFIELD,DTI%XPAR_VEGTYPE)
    ELSE
      DTI%XPAR_VEGTYPE(:,:) = ZFIELD(:,:)
    ENDIF
  ENDIF
  !
  IF (ANY(DTI%LDATA_VEG)) THEN
    ALLOCATE(DTI%XPAR_VEG(KDIM,DTI%NTIME,NVEGTYPE)) 
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE
      IF (GTIME(JT)) THEN
        WRITE(YRECFM,FMT='(A7,I2.2)') 'D_VEG_T',JT
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                  IVERSION, IBUGFIX, DTI%LDATA_VEG(ID1:ID2), DTI%XPAR_VEG(:,JT,:),IRESP,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
      ELSE
        DTI%XPAR_VEG(:,JT,:) = XUNDEF
      ENDIF
    END DO
  ENDIF
!
  IF (ANY(DTI%LDATA_LAI)) THEN
    ALLOCATE(DTI%XPAR_LAI(KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE    
      IF (GTIME(JT)) THEN
      WRITE(YRECFM,FMT='(A7,I2.2)') 'D_LAI_T',JT
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                  IVERSION, IBUGFIX, DTI%LDATA_LAI(ID1:ID2),DTI%XPAR_LAI(:,JT,:),IRESP,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
      ELSE
        DTI%XPAR_LAI(:,JT,:) = XUNDEF
      ENDIF
    END DO
  ENDIF
!
  IF (ANY(DTI%LDATA_Z0)) THEN
    ALLOCATE(DTI%XPAR_Z0        (KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE        
      IF (GTIME(JT)) THEN
      WRITE(YRECFM,FMT='(A6,I2.2)') 'D_Z0_T',JT
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                  IVERSION, IBUGFIX, DTI%LDATA_Z0(ID1:ID2),DTI%XPAR_Z0(:,JT,:),IRESP,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
      ELSE
        DTI%XPAR_Z0(:,JT,:) = XUNDEF
      ENDIF
    END DO
  ENDIF
!
  IF (ANY(DTI%LDATA_EMIS)) THEN
    ALLOCATE(DTI%XPAR_EMIS      (KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE    
      IF (GDIM) THEN
        WRITE(YRECFM,FMT='(A8,I2.2)') 'D_EMI_T',JT 
      ELSE
        WRITE(YRECFM,FMT='(A8,I2.2)') 'D_EMIS_T',JT             
      ENDIF
      IF (GTIME(JT)) THEN
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                  IVERSION, IBUGFIX, DTI%LDATA_EMIS(ID1:ID2),DTI%XPAR_EMIS(:,JT,:),IRESP,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
      ELSE
        DTI%XPAR_EMIS(:,JT,:) = XUNDEF
      ENDIF
    END DO
  ENDIF
!
  IF (ANY(DTI%LDATA_H_VEG)) THEN
    ALLOCATE(DTI%XPAR_H_VEG(KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE
      IF (GDIM) THEN
        WRITE(YRECFM,FMT='(A7,I2.2)') 'D_HVG_T',JT
      ELSE
        WRITE(YRECFM,FMT='(A9,I2.2)') 'D_H_VEG_T',JT
      ENDIF
      IF (GTIME(JT)) THEN
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                  IVERSION, IBUGFIX, DTI%LDATA_H_VEG(ID1:ID2),DTI%XPAR_H_VEG(:,JT,:),IRESP,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
      ELSE
        DTI%XPAR_H_VEG(:,JT,:) = XUNDEF
      ENDIF
    END DO
  ENDIF
!
  IF (ANY(DTI%LDATA_GNDLITTER)) THEN
    ALLOCATE(DTI%XPAR_GNDLITTER(KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE   
      IF (GDIM) THEN
        WRITE(YRECFM,FMT='(A7,I2.2)') 'D_GLI_T',JT
      ELSE    
        WRITE(YRECFM,FMT='(A7,I2.2)') 'D_GNDLITTER',JT
      ENDIF
      IF (GTIME(JT)) THEN
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                  IVERSION, IBUGFIX, DTI%LDATA_GNDLITTER(ID1:ID2),DTI%XPAR_GNDLITTER(:,JT,:),IRESP,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
      ELSE
        DTI%XPAR_GNDLITTER(:,JT,:) = XUNDEF
      ENDIF
    END DO
  ENDIF
!
  IF (ANY(DTI%LDATA_Z0LITTER)) THEN
    ALLOCATE(DTI%XPAR_Z0LITTER        (KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE    
      IF (GDIM) THEN
        WRITE(YRECFM,FMT='(A7,I2.2)') 'D_Z0L_T',JT
      ELSE        
        WRITE(YRECFM,FMT='(A8,I2.2)') 'D_Z0LITTER_T',JT
      ENDIF
      IF (GTIME(JT)) THEN
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                  IVERSION, IBUGFIX, DTI%LDATA_Z0LITTER(ID1:ID2),DTI%XPAR_Z0LITTER(:,JT,:),IRESP,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
      ELSE
        DTI%XPAR_Z0LITTER(:,JT,:) = XUNDEF
      ENDIF
    END DO
  ENDIF
!
  IF (ANY(DTI%LDATA_ALBNIR_VEG)) THEN
    ALLOCATE(DTI%XPAR_ALBNIR_VEG(KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE    
      IF (GDIM) THEN
        IF (GTIME(JT)) THEN
          WRITE(YRECFM,FMT='(A7,I2.2)') 'D_ANV_T',JT
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                            IVERSION, IBUGFIX, DTI%LDATA_ALBNIR_VEG(ID1:ID2),DTI%XPAR_ALBNIR_VEG(:,JT,:),IRESP,&
                            HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBNIR_VEG(:,JT,:) = XUNDEF
        ENDIF                    
      ELSE
        IF (JT==1) THEN           
          YRECFM='D_ALBNIR_VEG'
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_ALBNIR_VEG,DTI%XPAR_ALBNIR_VEG(:,1,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBNIR_VEG(:,JT,:) = DTI%XPAR_ALBNIR_VEG(:,1,:)
        ENDIF
      ENDIF
    ENDDO
  ENDIF
!
  IF (ANY(DTI%LDATA_ALBVIS_VEG)) THEN
    ALLOCATE(DTI%XPAR_ALBVIS_VEG(KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE    
      IF (GDIM) THEN
        IF (GTIME(JT)) THEN
          WRITE(YRECFM,FMT='(A7,I2.2)') 'D_AVV_T',JT
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                            IVERSION, IBUGFIX, DTI%LDATA_ALBVIS_VEG(ID1:ID2),DTI%XPAR_ALBVIS_VEG(:,JT,:),IRESP,&
                            HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBVIS_VEG(:,JT,:) = XUNDEF
        ENDIF                    
      ELSE
        IF (JT==1) THEN           
          YRECFM='D_ALBVIS_VEG'
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_ALBVIS_VEG,DTI%XPAR_ALBVIS_VEG(:,1,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBVIS_VEG(:,JT,:) = DTI%XPAR_ALBVIS_VEG(:,1,:)
        ENDIF
      ENDIF
    ENDDO
  ENDIF
!
  IF (ANY(DTI%LDATA_ALBUV_VEG)) THEN
    ALLOCATE(DTI%XPAR_ALBUV_VEG(KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE    
      IF (GDIM) THEN
        IF (GTIME(JT)) THEN
          WRITE(YRECFM,FMT='(A7,I2.2)') 'D_AUV_T',JT
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                            IVERSION, IBUGFIX, DTI%LDATA_ALBUV_VEG(ID1:ID2),DTI%XPAR_ALBUV_VEG(:,JT,:),IRESP,&
                            HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBUV_VEG(:,JT,:) = XUNDEF
        ENDIF                    
      ELSE
        IF (JT==1) THEN           
          YRECFM='D_ALBUV_VEG'
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_ALBUV_VEG,DTI%XPAR_ALBUV_VEG(:,1,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBUV_VEG(:,JT,:) = DTI%XPAR_ALBUV_VEG(:,1,:)
        ENDIF
      ENDIF
    ENDDO
  ENDIF
!
  IF (ANY(DTI%LDATA_ALBNIR_SOIL)) THEN
    ALLOCATE(DTI%XPAR_ALBNIR_SOIL(KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE    
      IF (GDIM) THEN
        IF (GTIME(JT)) THEN
          WRITE(YRECFM,FMT='(A7,I2.2)') 'D_ANS_T',JT
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                            IVERSION, IBUGFIX, DTI%LDATA_ALBNIR_SOIL(ID1:ID2),DTI%XPAR_ALBNIR_SOIL(:,JT,:),IRESP,&
                            HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBNIR_SOIL(:,JT,:) = XUNDEF
        ENDIF                    
      ELSE
        IF (JT==1) THEN           
          YRECFM='D_ALBNIR_SOI'
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_ALBNIR_SOIL,DTI%XPAR_ALBNIR_SOIL(:,1,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBNIR_SOIL(:,JT,:) = DTI%XPAR_ALBNIR_SOIL(:,1,:)
        ENDIF
      ENDIF
    ENDDO
  ENDIF  
!
  IF (ANY(DTI%LDATA_ALBVIS_SOIL)) THEN
    ALLOCATE(DTI%XPAR_ALBVIS_SOIL(KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE    
      IF (GDIM) THEN
        IF (GTIME(JT)) THEN
          WRITE(YRECFM,FMT='(A7,I2.2)') 'D_AVS_T',JT
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                            IVERSION, IBUGFIX, DTI%LDATA_ALBVIS_SOIL(ID1:ID2),DTI%XPAR_ALBVIS_SOIL(:,JT,:),IRESP,&
                            HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBVIS_SOIL(:,JT,:) = XUNDEF
        ENDIF                    
      ELSE
        IF (JT==1) THEN           
          YRECFM='D_ALBVIS_SOI'
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_ALBVIS_SOIL,DTI%XPAR_ALBVIS_SOIL(:,1,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBVIS_SOIL(:,JT,:) = DTI%XPAR_ALBVIS_SOIL(:,1,:)
        ENDIF
      ENDIF
    ENDDO
  ENDIF   
!
  IF (ANY(DTI%LDATA_ALBUV_SOIL)) THEN
    ALLOCATE(DTI%XPAR_ALBUV_SOIL(KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE    
      IF (GDIM) THEN       
        IF (GTIME(JT)) THEN
          WRITE(YRECFM,FMT='(A7,I2.2)') 'D_AUS_T',JT
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                            IVERSION, IBUGFIX, DTI%LDATA_ALBUV_SOIL(ID1:ID2),DTI%XPAR_ALBUV_SOIL(:,JT,:),IRESP,&
                            HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBUV_SOIL(:,JT,:) = XUNDEF
        ENDIF                     
      ELSE
        IF (JT==1) THEN           
          YRECFM='D_ALBUV_SOI'
          CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_ALBUV_SOIL,DTI%XPAR_ALBUV_SOIL(:,1,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
        ELSE
          DTI%XPAR_ALBUV_SOIL(:,JT,:) = DTI%XPAR_ALBUV_SOIL(:,1,:)
        ENDIF
      ENDIF
    ENDDO
  ENDIF    
!
  IF (ANY(DTI%LDATA_RSMIN)) THEN
    ALLOCATE(DTI%XPAR_RSMIN     (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_RSMIN_'
    ELSE
      YRECFM='D_RSMIN'
    ENDIF
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_RSMIN,DTI%XPAR_RSMIN(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_GAMMA)) THEN
    ALLOCATE(DTI%XPAR_GAMMA     (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_GAMMA_'
    ELSE
      YRECFM='D_GAMMA'
    ENDIF    
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_GAMMA,DTI%XPAR_GAMMA(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_WRMAX_CF)) THEN
    ALLOCATE(DTI%XPAR_WRMAX_CF  (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_WRMAX_'
    ELSE
      YRECFM='D_WRMAX_CF'
    ENDIF               
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_WRMAX_CF,DTI%XPAR_WRMAX_CF(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_RGL)) THEN
    ALLOCATE(DTI%XPAR_RGL       (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_RGL_'
    ELSE
      YRECFM='D_RGL'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_RGL,DTI%XPAR_RGL(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_CV)) THEN
    ALLOCATE(DTI%XPAR_CV        (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_CV_'
    ELSE
      YRECFM='D_CV'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_CV,DTI%XPAR_CV(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_Z0_O_Z0H)) THEN
    ALLOCATE(DTI%XPAR_Z0_O_Z0H  (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_Z0H_'
    ELSE
      YRECFM='D_Z0_O_Z0H'
    ENDIF        
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_Z0_O_Z0H,DTI%XPAR_Z0_O_Z0H(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_DG)) THEN
    ALLOCATE(DTI%XPAR_DG        (KDIM,IO%NGROUND_LAYER,NVEGTYPE))
    DO JL=1,SIZE(DTI%XPAR_DG,2)
      IF (GDIM) THEN
        WRITE(YRECFM,FMT='(A6,I2.2)') 'D_DG_L',JL
      ELSE
        IF (JL<10)  WRITE(YRECFM,FMT='(A4,I1.1)') 'D_DG',JL
        IF (JL>=10) WRITE(YRECFM,FMT='(A4,I2.2)') 'D_DG',JL
      ENDIF
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_DG,DTI%XPAR_DG(:,JL,:),IRESP,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
  IF (ANY(DTI%LDATA_ROOTFRAC)) THEN
    ALLOCATE(DTI%XPAR_ROOTFRAC  (KDIM,IO%NGROUND_LAYER,NVEGTYPE))
    DO JL=1,SIZE(DTI%XPAR_ROOTFRAC,2)
      IF (GDIM) THEN
        WRITE(YRECFM,FMT='(A6,I2.2)') 'D_RTF_L',JL
      ELSE
        IF (JL<10)  WRITE(YRECFM,FMT='(A10,I1.1)') 'D_ROOTFRAC',JL
        IF (JL>=10) WRITE(YRECFM,FMT='(A10,I2.2)') 'D_ROOTFRAC',JL
      ENDIF
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_ROOTFRAC,DTI%XPAR_ROOTFRAC(:,JL,:),IRESP,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    END DO
  ENDIF
!
  IF (ANY(DTI%LDATA_GROUND_DEPTH)) THEN
    ALLOCATE(DTI%XPAR_GROUND_DEPTH(KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM2='D_GRDPT_'
    ELSE
      YRECFM2='D_GROUND_DEPTH'  
       IF (IVERSION>7 .OR. IVERSION==7 .AND. IBUGFIX>=3) YRECFM2='D_GROUND_DPT'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM2, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_GROUND_DEPTH,DTI%XPAR_GROUND_DEPTH(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_ROOT_DEPTH)) THEN
    ALLOCATE(DTI%XPAR_ROOT_DEPTH(KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_RTDPT_'
    ELSE
      YRECFM='D_ROOT_DEPTH'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                              IVERSION, IBUGFIX, DTI%LDATA_ROOT_DEPTH,DTI%XPAR_ROOT_DEPTH(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_ROOT_EXTINCTION)) THEN
    ALLOCATE(DTI%XPAR_ROOT_EXTINCTION(KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_RTEXT_'
    ELSE
      YRECFM='D_ROOT_EXT'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_ROOT_EXTINCTION,DTI%XPAR_ROOT_EXTINCTION(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF

  IF (ANY(DTI%LDATA_ROOT_LIN)) THEN
    ALLOCATE(DTI%XPAR_ROOT_LIN(KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_RTLIN_'
    ELSE
      YRECFM='D_ROOT_LIN'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_ROOT_LIN,DTI%XPAR_ROOT_LIN(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF  
!
  IF (ANY(DTI%LDATA_DICE)) THEN
    ALLOCATE(DTI%XPAR_DICE      (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_DICE_'
    ELSE
      YRECFM='D_DICE'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_DICE,DTI%XPAR_DICE(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_GMES)) THEN
    ALLOCATE(DTI%XPAR_GMES      (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_GMES_'
    ELSE
      YRECFM='D_GMES'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_GMES,DTI%XPAR_GMES(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_BSLAI)) THEN
    ALLOCATE(DTI%XPAR_BSLAI     (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_BSLAI_'
    ELSE
      YRECFM='D_BSLAI'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_BSLAI,DTI%XPAR_BSLAI(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_LAIMIN)) THEN
    ALLOCATE(DTI%XPAR_LAIMIN    (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_LAIMIN_'
    ELSE
      YRECFM='D_LAIMIN'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_LAIMIN,DTI%XPAR_LAIMIN(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_SEFOLD)) THEN
    ALLOCATE(DTI%XPAR_SEFOLD    (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_SEFOLD_'
    ELSE
      YRECFM='D_SEFOLD'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_SEFOLD,DTI%XPAR_SEFOLD(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_GC)) THEN
    ALLOCATE(DTI%XPAR_GC        (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_GC_'
    ELSE
      YRECFM='D_GC'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_GC,DTI%XPAR_GC(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_DMAX)) THEN
    ALLOCATE(DTI%XPAR_DMAX      (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_DMAX_'
    ELSE
      YRECFM='D_DMAX'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_DMAX,DTI%XPAR_DMAX(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_F2I)) THEN
    ALLOCATE(DTI%XPAR_F2I       (KDIM,NVEGTYPE))
    YRECFM='D_F2I'
    IF (GDIM) THEN
      YRECFM='D_F2I_'
    ELSE
      YRECFM='D_F2I'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_F2I,DTI%XPAR_F2I(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_STRESS)) THEN
    ALLOCATE(DTI%LPAR_STRESS   (KDIM,NVEGTYPE))
    ALLOCATE(ZWORK(SIZE(DTI%LPAR_STRESS,1),SIZE(DTI%LPAR_STRESS,2)))
    YRECFM='D_STRESS'
    IF (GDIM) THEN
      YRECFM='D_STRESS_'
    ELSE
      YRECFM='D_STRESS'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_STRESS,ZWORK(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
    DTI%LPAR_STRESS = .FALSE.
    WHERE(ZWORK==1.) DTI%LPAR_STRESS = .TRUE.
    DEALLOCATE(ZWORK)
  ENDIF
!
  IF (ANY(DTI%LDATA_H_TREE)) THEN
    ALLOCATE(DTI%XPAR_H_TREE    (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_H_TREE_'
    ELSE
      YRECFM='D_H_TREE'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_H_TREE,DTI%XPAR_H_TREE(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_RE25)) THEN
    ALLOCATE(DTI%XPAR_RE25      (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_RE25_'
    ELSE
      YRECFM='D_RE25'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_RE25,DTI%XPAR_RE25(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_CE_NITRO)) THEN
    ALLOCATE(DTI%XPAR_CE_NITRO  (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_CENITR_'
    ELSE
      YRECFM='D_CE_NITRO'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_CE_NITRO,DTI%XPAR_CE_NITRO(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_CF_NITRO)) THEN
    ALLOCATE(DTI%XPAR_CF_NITRO  (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_CFNITR_'
    ELSE
      YRECFM='D_CF_NITRO'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_CF_NITRO,DTI%XPAR_CF_NITRO(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_CNA_NITRO)) THEN
    ALLOCATE(DTI%XPAR_CNA_NITRO (KDIM,NVEGTYPE))
    IF (GDIM) THEN
      YRECFM='D_CNANIT_'
    ELSE
      YRECFM='D_CNA_NITRO'
    ENDIF       
    CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_CNA_NITRO,DTI%XPAR_CNA_NITRO(:,:),IRESP,&
                              HCOMMENT=YCOMMENT,HDIR=YDIR)
  ENDIF
!
  IF (ANY(DTI%LDATA_IRRIG)) THEN
    ALLOCATE(DTI%XPAR_IRRIG     (KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE   
      IF (GDIM) THEN
        WRITE(YRECFM,FMT='(A9,I2.2)') 'D_IRR_T',JT        
      ELSE
        WRITE(YRECFM,FMT='(A9,I2.2)') 'D_IRRIG_T',JT            
      ENDIF
      IF (GTIME(JT)) THEN   
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                  IVERSION, IBUGFIX, DTI%LDATA_IRRIG(ID1:ID2),DTI%XPAR_IRRIG(:,JT,:),IRESP,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
      ELSE
        DTI%XPAR_IRRIG(:,JT,:) = XUNDEF
      ENDIF
    END DO
  ENDIF
!
  IF (ANY(DTI%LDATA_WATSUP)) THEN
    ALLOCATE(DTI%XPAR_WATSUP     (KDIM,DTI%NTIME,NVEGTYPE))
    DO JT=1,ITIME
      ID1 = (JT-1)*NVEGTYPE + 1
      ID2 = JT*NVEGTYPE    
      IF (GDIM) THEN
        WRITE(YRECFM,FMT='(A10,I2.2)') 'D_WAT_T',JT 
      ELSE
        WRITE(YRECFM,FMT='(A10,I2.2)') 'D_WATSUP_T',JT            
      ENDIF   
      IF (GTIME(JT)) THEN    
        CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                  IVERSION, IBUGFIX, DTI%LDATA_WATSUP(ID1:ID2),DTI%XPAR_WATSUP(:,JT,:),IRESP,&
                                  HCOMMENT=YCOMMENT,HDIR=YDIR)
      ELSE
        DTI%XPAR_WATSUP(:,JT,:) = XUNDEF
      ENDIF                        
    END DO
  ENDIF
!
  IF (GDIM) THEN

    IF (ANY(DTI%LDATA_SEED_M)) THEN
      ALLOCATE(DTI%XPAR_SEED_M (KDIM,NVEGTYPE))
      YRECFM='D_SEED_M_'      
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_SEED_M,DTI%XPAR_SEED_M(:,:),IRESP,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    ENDIF

!
    IF (ANY(DTI%LDATA_SEED_D)) THEN
      ALLOCATE(DTI%XPAR_SEED_D (KDIM,NVEGTYPE))
      YRECFM='D_SEED_D_'
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_SEED_D,DTI%XPAR_SEED_D(:,:),IRESP,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    ENDIF
!
    IF (ANY(DTI%LDATA_REAP_M)) THEN
      ALLOCATE(DTI%XPAR_REAP_M (KDIM,NVEGTYPE))
      YRECFM='D_REAP_M_'
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_REAP_M,DTI%XPAR_REAP_M(:,:),IRESP,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    ENDIF
!
    IF (ANY(DTI%LDATA_REAP_D)) THEN
      ALLOCATE(DTI%XPAR_REAP_D (KDIM,NVEGTYPE))
      YRECFM='D_REAP_D_'
      CALL READ_SURF_ISBA_PAR_n(DTCO, U, GCP, IO%NPATCH, HPROGRAM, YRECFM, ILUOUT, KSIZE, &
                                IVERSION, IBUGFIX, DTI%LDATA_REAP_D,DTI%XPAR_REAP_D(:,:),IRESP,&
                                HCOMMENT=YCOMMENT,HDIR=YDIR)
    ENDIF
    !
    ALLOCATE(ZWORK(KSIZE,IO%NGROUND_LAYER))
    !
    IF (DTI%LDATA_CONDSAT) THEN
      ALLOCATE(DTI%XPAR_CONDSAT(KDIM,IO%NGROUND_LAYER))
      DO JL=1,SIZE(DTI%XPAR_CONDSAT,2)
        WRITE(YRECFM,FMT='(A10,I2.2)') 'D_CNDSAT_L',JL
        CALL READ_SURF(HPROGRAM,YRECFM,ZWORK(:,JL),IRESP,HCOMMENT=YCOMMENT,HDIR=YDIR)
      ENDDO
      IF (KDIM/=KSIZE) THEN
        CALL HOR_INTERPOL(DTCO, U, GCP, ILUOUT,ZWORK,DTI%XPAR_CONDSAT)
      ELSE
        DTI%XPAR_CONDSAT(:,:) = ZWORK(:,:)
      ENDIF
    ENDIF
    !
    IF (DTI%LDATA_MPOTSAT) THEN
      ALLOCATE(DTI%XPAR_MPOTSAT(KDIM,IO%NGROUND_LAYER))
      DO JL=1,SIZE(DTI%XPAR_MPOTSAT,2)
        WRITE(YRECFM,FMT='(A10,I2.2)') 'D_MPTSAT_L',JL
        CALL READ_SURF(HPROGRAM,YRECFM,ZWORK(:,JL),IRESP,HCOMMENT=YCOMMENT,HDIR=YDIR)
      ENDDO
      IF (KDIM/=KSIZE) THEN
        CALL HOR_INTERPOL(DTCO, U, GCP, ILUOUT,ZWORK,DTI%XPAR_MPOTSAT)
      ELSE
        DTI%XPAR_MPOTSAT(:,:) = ZWORK(:,:)
      ENDIF
    ENDIF
    !
    IF (DTI%LDATA_BCOEF) THEN
      ALLOCATE(DTI%XPAR_BCOEF(KDIM,IO%NGROUND_LAYER))
      DO JL=1,SIZE(DTI%XPAR_BCOEF,2)
        WRITE(YRECFM,FMT='(A9,I2.2)') 'D_BCOEF_L',JL
        CALL READ_SURF(HPROGRAM,YRECFM,ZWORK(:,JL),IRESP,HCOMMENT=YCOMMENT,HDIR=YDIR)
      ENDDO
      IF (KDIM/=KSIZE) THEN
        CALL HOR_INTERPOL(DTCO, U, GCP, ILUOUT,ZWORK,DTI%XPAR_BCOEF)
      ELSE
        DTI%XPAR_BCOEF(:,:) = ZWORK(:,:)
      ENDIF
    ENDIF
    !
    IF (DTI%LDATA_WWILT) THEN
      ALLOCATE(DTI%XPAR_WWILT(KDIM,IO%NGROUND_LAYER))
      DO JL=1,SIZE(DTI%XPAR_WWILT,2)
        WRITE(YRECFM,FMT='(A9,I2.2)') 'D_WWILT_L',JL
        CALL READ_SURF(HPROGRAM,YRECFM,ZWORK(:,JL),IRESP,HCOMMENT=YCOMMENT,HDIR=YDIR)
      ENDDO
      IF (KDIM/=KSIZE) THEN
        CALL HOR_INTERPOL(DTCO, U, GCP, ILUOUT,ZWORK,DTI%XPAR_WWILT)
      ELSE
        DTI%XPAR_WWILT(:,:) = ZWORK(:,:)
      ENDIF
    ENDIF
    !
    IF (DTI%LDATA_WFC) THEN
      ALLOCATE(DTI%XPAR_WFC(KDIM,IO%NGROUND_LAYER))
      DO JL=1,SIZE(DTI%XPAR_WFC,2)
        WRITE(YRECFM,FMT='(A7,I2.2)') 'D_WFC_L',JL
        CALL READ_SURF(HPROGRAM,YRECFM,ZWORK(:,JL),IRESP,HCOMMENT=YCOMMENT,HDIR=YDIR)
      ENDDO
      IF (KDIM/=KSIZE) THEN
        CALL HOR_INTERPOL(DTCO, U, GCP, ILUOUT,ZWORK,DTI%XPAR_WFC)
      ELSE
        DTI%XPAR_WFC(:,:) = ZWORK(:,:)
      ENDIF
    ENDIF
    !
    IF (DTI%LDATA_WSAT) THEN
      ALLOCATE(DTI%XPAR_WSAT(KDIM,IO%NGROUND_LAYER))
      DO JL=1,SIZE(DTI%XPAR_WSAT,2)
        WRITE(YRECFM,FMT='(A8,I2.2)') 'D_WSAT_L',JL
        CALL READ_SURF(HPROGRAM,YRECFM,ZWORK(:,JL),IRESP,HCOMMENT=YCOMMENT,HDIR=YDIR)
      ENDDO
      IF (KDIM/=KSIZE) THEN
        CALL HOR_INTERPOL(DTCO, U, GCP, ILUOUT,ZWORK,DTI%XPAR_WSAT)
      ELSE
        DTI%XPAR_WSAT(:,:) = ZWORK(:,:)
      ENDIF
    ENDIF
    !
    DEALLOCATE(ZWORK)
    !
  ENDIF
  ! 
ENDIF
!
IF (LASSIM) LREAD_ALL = GREAD_ALL
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_ISBA_PAR_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE READ_PGD_ISBA_PAR_n
