!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
MODULE MODI_READ_AND_SEND_MPI
!
INTERFACE READ_AND_SEND_MPI
!
SUBROUTINE READ_AND_SEND_MPI_N1D(KWORK,KWORK2,KMASK,KPIO,KDX)
!
INTEGER, DIMENSION(:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
INTEGER, INTENT(IN), OPTIONAL :: KPIO
INTEGER, INTENT(IN), OPTIONAL :: KDX
!
END SUBROUTINE READ_AND_SEND_MPI_N1D
!
SUBROUTINE READ_AND_SEND_MPI_N2D(KWORK,KWORK2,KMASK)
!
INTEGER, DIMENSION(:,:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:,:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE READ_AND_SEND_MPI_N2D
!
SUBROUTINE READ_AND_SEND_MPI_N3D(KWORK,KWORK2,KMASK,KPIO,KDX)
!
INTEGER, DIMENSION(:,:,:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:,:,:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
INTEGER, INTENT(IN), OPTIONAL :: KPIO
INTEGER, INTENT(IN), OPTIONAL :: KDX
!
END SUBROUTINE READ_AND_SEND_MPI_N3D
!
SUBROUTINE READ_AND_SEND_MPI_X1D(PWORK,PWORK2,KMASK,KPIO,KDX)
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL, DIMENSION(:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
INTEGER, INTENT(IN), OPTIONAL :: KPIO
INTEGER, INTENT(IN), OPTIONAL :: KDX
!
END SUBROUTINE READ_AND_SEND_MPI_X1D
!
SUBROUTINE READ_AND_SEND_MPI_X2D(PWORK,PWORK2,KMASK,KPIO,KDX)
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
INTEGER, INTENT(IN), OPTIONAL :: KPIO
INTEGER, INTENT(IN), OPTIONAL :: KDX
!
END SUBROUTINE READ_AND_SEND_MPI_X2D
!
SUBROUTINE READ_AND_SEND_MPI_X3D(PWORK,PWORK2,KMASK,KPIO,KDX)
!
REAL, DIMENSION(:,:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
INTEGER, INTENT(IN), OPTIONAL :: KPIO
INTEGER, INTENT(IN), OPTIONAL :: KDX
!
END SUBROUTINE READ_AND_SEND_MPI_X3D
!
END INTERFACE
!
END MODULE MODI_READ_AND_SEND_MPI
!
SUBROUTINE READ_AND_SEND_MPI_N1D(KWORK,KWORK2,KMASK,KPIO,KDX)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, NREQ, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, IDX_R, WLOG_MPI
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
INTEGER, DIMENSION(:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
INTEGER, INTENT(IN), OPTIONAL :: KPIO
INTEGER, INTENT(IN), OPTIONAL :: KDX
!
INTEGER, DIMENSION(NSIZE,NPROC) :: IWORKS
INTEGER, DIMENSION(NSIZE) :: IWORKR
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
INTEGER, DIMENSION(MPI_STATUS_SIZE,NPROC-1) :: ISTATUS2
#endif
INTEGER :: ICPT, IPIO, IDX, IREQ
INTEGER :: I,J
INTEGER :: INFOMPI
DOUBLE PRECISION :: XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE, ZHOOK_HANDLE_OMP
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_1',0,ZHOOK_HANDLE)
!
IF (PRESENT(KPIO)) THEN
  IPIO = KPIO
ELSE
  IPIO = NPIO
ENDIF
!
IF (PRESENT(KDX)) THEN
  IDX = KDX
ELSE
  IDX = IDX_R
ENDIF
!
IF (NRANK==IPIO) THEN
  !
  IDX = IDX + 1
  !
  IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_1',1,ZHOOK_HANDLE)
!$OMP PARALLEL DO SCHEDULE(DYNAMIC,1) PRIVATE(I,ICPT,J,IREQ,INFOMPI,ZHOOK_HANDLE_OMP)
  DO I=0,NPROC-1
    !
    IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_20',0,ZHOOK_HANDLE_OMP)  
    !
#ifdef SFX_MPI    
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !
    IWORKS(:,I+1) = 0
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==I ) THEN
        ICPT = ICPT + 1
        IWORKS(ICPT,I+1) = KWORK(J)
      ENDIF
      !
    ENDDO
    !
    IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_20',1,ZHOOK_HANDLE_OMP)
    IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_30',0,ZHOOK_HANDLE_OMP)
    !  
#ifdef SFX_MPI    
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
#endif    
    !  
    IF (I/=IPIO) THEN

#ifdef SFX_MPI
      XTIME0 = MPI_WTIME()

      IF (PRESENT(KPIO) .AND.PRESENT(KDX)) THEN
        IF (I<IPIO) THEN
          IREQ = I+1
        ELSE
          IREQ = I
        ENDIF   
     
        CALL MPI_ISEND(IWORKS(:,I+1),SIZE(IWORKS,1)*KIND(IWORKS)/4,&
                           MPI_INTEGER,I,IDX,NCOMM,NREQ(IREQ),INFOMPI)
      ELSE                
        CALL MPI_SEND(IWORKS(:,I+1),SIZE(IWORKS,1)*KIND(IWORKS)/4,MPI_INTEGER,I,IDX,NCOMM,INFOMPI)
      ENDIF
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif

    ELSE
      IWORKR(:) = IWORKS(:,I+1)
    ENDIF
    IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_30',1,ZHOOK_HANDLE_OMP)
    !
  ENDDO
!$OMP END PARALLEL DO
  ! 
ELSE
  ! 
  IDX = IDX + 1
  !  
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_1',1,ZHOOK_HANDLE)
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_2',0,ZHOOK_HANDLE)  
#ifdef SFX_MPI
  !  
  XTIME0 = MPI_WTIME()
  CALL MPI_RECV(IWORKR,SIZE(IWORKR)*KIND(IWORKR)/4,MPI_INTEGER,IPIO,IDX,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
  IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_2',1,ZHOOK_HANDLE)
  !  
ENDIF
!
  IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_3',0,ZHOOK_HANDLE)
IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,IWORKR(:),KWORK2)
ELSE
  KWORK2(:) = IWORKR(1:SIZE(KWORK2))
ENDIF
!
IF (.NOT.PRESENT(KDX)) IDX_R = IDX_R + 1
!
  IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D_3',1,ZHOOK_HANDLE)
!
END SUBROUTINE READ_AND_SEND_MPI_N1D
!
!**************************************************************************
!
SUBROUTINE READ_AND_SEND_MPI_N2D(KWORK,KWORK2,KMASK)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, IDX_R, WLOG_MPI
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
INTEGER, DIMENSION(:,:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:,:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
INTEGER, DIMENSION(NSIZE,SIZE(KWORK2,2)) :: IWORKS
INTEGER, DIMENSION(NSIZE,SIZE(KWORK2,2)) :: IWORKR
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: IS2, IP2
INTEGER :: ICPT
INTEGER :: I,J, K
INTEGER :: INFOMPI
DOUBLE PRECISION :: XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N2D',0,ZHOOK_HANDLE)
!
IF (NRANK==NPIO) THEN
  !
  IDX_R = IDX_R + 1
  !
  DO I=0,NPROC-1
    !
#ifdef SFX_MPI    
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !
    IWORKS(:,:) = 0
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==MOD(I,NPROC) ) THEN
        ICPT = ICPT + 1
        IWORKS(ICPT,:) = KWORK(J,:)
      ENDIF
      !
    ENDDO
    !
#ifdef SFX_MPI    
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
    !  
    IF (I/=NPIO) THEN
      XTIME0 = MPI_WTIME()
      CALL MPI_SEND(IWORKS(:,:),SIZE(IWORKS)*KIND(IWORKS)/4,MPI_INTEGER,I,IDX_R,NCOMM,INFOMPI)
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
    ELSE
      IWORKR(:,:) = IWORKS(:,:)
    ENDIF
#endif
    !
  ENDDO
  !
ELSE
  !
  IDX_R = IDX_R + 1
  !  
#ifdef SFX_MPI
  IWORKS(:,:) = 0
  !  
  XTIME0 = MPI_WTIME()
  CALL MPI_RECV(IWORKR(:,:),SIZE(IWORKR)*KIND(IWORKR)/4,MPI_INTEGER,NPIO,IDX_R,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
ENDIF
!
IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,IWORKR(:,:),KWORK2)
ELSE
  KWORK2(:,:) = IWORKR(1:SIZE(KWORK2,1),:)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N2D',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE READ_AND_SEND_MPI_N2D
!
!**************************************************************************
!
SUBROUTINE READ_AND_SEND_MPI_N3D(KWORK,KWORK2,KMASK,KPIO,KDX)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, IDX_R, WLOG_MPI, &
                            NREQ
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
INTEGER, DIMENSION(:,:,:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:,:,:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
INTEGER, INTENT(IN), OPTIONAL :: KPIO
INTEGER, INTENT(IN), OPTIONAL :: KDX
!
INTEGER, DIMENSION(NSIZE,SIZE(KWORK2,2),SIZE(KWORK2,3),NPROC) :: IWORK3S
INTEGER, DIMENSION(NSIZE,SIZE(KWORK2,2),SIZE(KWORK2,3)) :: IWORK3
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: IP2, IS2, IP3, IS3
INTEGER :: ICPT, IPIO, IDX 
INTEGER :: I,J
INTEGER :: INFOMPI, IREQ
DOUBLE PRECISION   :: XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE, ZHOOK_HANDLE_OMP
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_1',0,ZHOOK_HANDLE)
!
IF (PRESENT(KPIO)) THEN
  IPIO = KPIO
ELSE
  IPIO = NPIO
ENDIF
!
IF (PRESENT(KDX)) THEN
  IDX = KDX
ELSE
  IDX = IDX_R
ENDIF
!
IF (NRANK==IPIO) THEN
  !  
  IDX = IDX + 1
  !  
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_1',1,ZHOOK_HANDLE)
!$OMP PARALLEL DO PRIVATE(I,ICPT,J,INFOMPI,IREQ,ZHOOK_HANDLE_OMP)  
  DO I=0,NPROC-1
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_2',0,ZHOOK_HANDLE_OMP)
    !
#ifdef SFX_MPI    
    XTIME0 = MPI_WTIME()
#endif    
    ! 
    ICPT = 0
    !
    IWORK3S(:,:,:,I+1) = 0.
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==I ) THEN
        ICPT = ICPT + 1
        IWORK3S(ICPT,:,:,I+1) = KWORK(J,:,:)
      ENDIF
      !
    ENDDO
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_2',1,ZHOOK_HANDLE_OMP)
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_3',0,ZHOOK_HANDLE_OMP)
    !
#ifdef SFX_MPI    
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
#endif    
    !    
    IF (I/=IPIO) THEN
#ifdef SFX_MPI              
      IF (PRESENT(KPIO).AND.PRESENT(KDX)) THEN
        IF (I<IPIO) THEN
          IREQ = I+1
        ELSE
          IREQ = I
        ENDIF            
        XTIME0 = MPI_WTIME()
        CALL MPI_ISEND(IWORK3S(:,:,:,I+1),SIZE(IWORK3)*KIND(IWORK3)/4,&
                        MPI_INTEGER,I,IDX,NCOMM,NREQ(IREQ),INFOMPI)
      ELSE            
        CALL MPI_SEND(IWORK3S(:,:,:,I+1),SIZE(IWORK3)*KIND(IWORK3)/4,&
                       MPI_INTEGER,I,IDX,NCOMM,INFOMPI)
      ENDIF
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif      
    ELSE
      IWORK3(:,:,:) = IWORK3S(:,:,:,I+1)
    ENDIF
    !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_3',1,ZHOOK_HANDLE_OMP)
  ENDDO
!$OMP END PARALLEL DO
  !  
ELSE
  !  
  IDX = IDX + 1
  !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_1',1,ZHOOK_HANDLE)
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_2',0,ZHOOK_HANDLE)  
#ifdef SFX_MPI 
  !
  XTIME0 = MPI_WTIME()  
  CALL MPI_RECV(IWORK3,SIZE(IWORK3)*KIND(IWORK3)/4,MPI_INTEGER,IPIO,IDX,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_2',1,ZHOOK_HANDLE)
  !  
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_4',0,ZHOOK_HANDLE)
IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,IWORK3(:,:,:),KWORK2)
ELSE
  KWORK2(:,:,:) = IWORK3(1:SIZE(KWORK2,1),:,:)
ENDIF
!
IF (.NOT.PRESENT(KDX)) IDX_R = IDX_R + 1
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N3D_4',1,ZHOOK_HANDLE)
!
END SUBROUTINE READ_AND_SEND_MPI_N3D
!**************************************************************************
!
SUBROUTINE READ_AND_SEND_MPI_X1D(PWORK,PWORK2,KMASK,KPIO,KDX)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, NREQ, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, WLOG_MPI, IDX_R,&
                            NSIZE, XWORKS
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL, DIMENSION(:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
INTEGER, INTENT(IN), OPTIONAL :: KPIO
INTEGER, INTENT(IN), OPTIONAL :: KDX
!
REAL, DIMENSION(NSIZE,NPROC) :: ZWORKS
REAL, DIMENSION(NSIZE) :: ZWORKR
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: ICPT, IPIO, IDX
INTEGER :: I,J, IREQ
INTEGER :: INFOMPI
DOUBLE PRECISION   :: XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE, ZHOOK_HANDLE_OMP
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_1',0,ZHOOK_HANDLE)
!
!
IF (PRESENT(KPIO)) THEN
  IPIO = KPIO
ELSE
  IPIO = NPIO
ENDIF
!
IF (NRANK==IPIO.AND..NOT.ALLOCATED(XWORKS)) ALLOCATE(XWORKS(NSIZE,NPROC))
!
IF (PRESENT(KDX)) THEN
  IDX = KDX
ELSE
  IDX = IDX_R
ENDIF
!
IF (NRANK==IPIO) THEN
  !
  IDX = IDX + 1
  !
  IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_1',1,ZHOOK_HANDLE)
!$OMP PARALLEL DO SCHEDULE(DYNAMIC,1) PRIVATE(I,ICPT,J,IREQ,INFOMPI,ZHOOK_HANDLE_OMP)
  DO I=0,NPROC-1
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_2',0,ZHOOK_HANDLE_OMP)
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !
    XWORKS(:,I+1) = 0.
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==I) THEN
        ICPT = ICPT + 1
        XWORKS(ICPT,I+1) = PWORK(J)
      ENDIF
      !
    ENDDO
     !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_2',1,ZHOOK_HANDLE_OMP)
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_30',0,ZHOOK_HANDLE_OMP)
    !
#ifdef SFX_MPI    
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
#endif    
    !
    IF (I/=IPIO) THEN
#ifdef SFX_MPI              
      XTIME0 = MPI_WTIME()
      IF (PRESENT(KPIO).AND.PRESENT(KDX)) THEN
        IF (I<IPIO) THEN
          IREQ = I+1
        ELSE
          IREQ = I
        ENDIF
        CALL MPI_ISEND(XWORKS(:,I+1),SIZE(XWORKS(:,I+1))*KIND(XWORKS)/4,MPI_REAL,I,IDX,NCOMM,NREQ(IREQ),INFOMPI)
      ELSE
        CALL MPI_SEND(XWORKS(:,I+1),SIZE(XWORKS(:,I+1))*KIND(XWORKS)/4,MPI_REAL,I,IDX,NCOMM,INFOMPI)
      ENDIF
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif      
    ELSE
      ZWORKR(:) = XWORKS(:,I+1)
  ENDIF
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_30',1,ZHOOK_HANDLE_OMP)
    !
  ENDDO
!$OMP END PARALLEL DO
  !
ELSE
  !
  IDX = IDX + 1
  !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_1',1,ZHOOK_HANDLE)
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_2',0,ZHOOK_HANDLE)
#ifdef SFX_MPI
  ZWORKR(:) = 0.
  !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_2',1,ZHOOK_HANDLE)
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_3',0,ZHOOK_HANDLE)
  XTIME0 = MPI_WTIME()
  CALL MPI_RECV(ZWORKR(:),SIZE(ZWORKR(:))*KIND(ZWORKR)/4,MPI_REAL,IPIO,IDX,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_3',1,ZHOOK_HANDLE)
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_4',0,ZHOOK_HANDLE)

IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,ZWORKR(:),PWORK2(:))
ELSE
  PWORK2(:) = ZWORKR(1:SIZE(PWORK2))
ENDIF

IF (.NOT.PRESENT(KDX)) IDX_R = IDX_R + 1
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D_4',1,ZHOOK_HANDLE)
!
END SUBROUTINE READ_AND_SEND_MPI_X1D
!
!**************************************************************************
!
SUBROUTINE READ_AND_SEND_MPI_X2D(PWORK,PWORK2,KMASK,KPIO,KDX)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, WLOG_MPI, IDX_R, &
                            NREQ, XWORK2S
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
INTEGER, INTENT(IN), OPTIONAL :: KPIO
INTEGER, INTENT(IN), OPTIONAL :: KDX
!
REAL, DIMENSION(NSIZE,SIZE(PWORK2,2),NPROC) :: ZWORK2S
REAL, DIMENSION(NSIZE,SIZE(PWORK2,2)) :: ZWORK2
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: IS2, IP2
INTEGER :: ICPT, IPIO, IDX
INTEGER :: I,J, K, IREQ
INTEGER :: INFOMPI
DOUBLE PRECISION   :: XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE, ZHOOK_HANDLE_OMP
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_1',0,ZHOOK_HANDLE)
!
IF (PRESENT(KPIO)) THEN
  IPIO = KPIO
ELSE
  IPIO = NPIO
ENDIF
!
IF (NRANK==IPIO) THEN
  IF (ALLOCATED(XWORK2S)) THEN
    IF (SIZE(XWORK2S,2)/=SIZE(PWORK2,2)) DEALLOCATE(XWORK2S)
  ENDIF
  IF (.NOT.ALLOCATED(XWORK2S)) ALLOCATE(XWORK2S(NSIZE,SIZE(PWORK2,2),NPROC))
ENDIF
!
IF (PRESENT(KDX)) THEN
  IDX = KDX
ELSE
  IDX = IDX_R
ENDIF
!
IF (NRANK==IPIO) THEN
  !
  IDX = IDX + 1
  !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_1',1,ZHOOK_HANDLE)
!$OMP PARALLEL DO SCHEDULE(DYNAMIC,1) PRIVATE(I,ICPT,J,IREQ,INFOMPI,ZHOOK_HANDLE_OMP)
  DO I=0,NPROC-1
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_2',0,ZHOOK_HANDLE_OMP)
    !
#ifdef SFX_MPI    
    XTIME0 = MPI_WTIME()
#endif    
    !
    ICPT = 0
    !    
    XWORK2S(:,:,I+1) = 0.
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==I ) THEN
        ICPT = ICPT + 1
        XWORK2S(ICPT,:,I+1) = PWORK(J,:)
      ENDIF
      !
    ENDDO
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_2',1,ZHOOK_HANDLE_OMP)
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_3',0,ZHOOK_HANDLE_OMP)
    !
#ifdef SFX_MPI    
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
#endif    
    !
    IF (I/=IPIO) THEN
#ifdef SFX_MPI              
      IF (PRESENT(KPIO).AND.PRESENT(KDX)) THEN
        IF (I<IPIO) THEN
          IREQ = I+1
        ELSE
          IREQ = I
        ENDIF     
        CALL MPI_ISEND(XWORK2S(:,:,I+1),SIZE(XWORK2S(:,:,I+1))*KIND(XWORK2S)/4,&
                        MPI_REAL,I,IDX,NCOMM,NREQ(IREQ),INFOMPI)
      ELSE
        CALL MPI_SEND(XWORK2S(:,:,I+1),SIZE(XWORK2S(:,:,I+1))*KIND(XWORK2S)/4,&
                        MPI_REAL,I,IDX,NCOMM,INFOMPI)
      ENDIF
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif      
    ELSE
      ZWORK2(:,:) = XWORK2S(:,:,I+1)
    ENDIF
    !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_3',1,ZHOOK_HANDLE_OMP)
  ENDDO
!$OMP END PARALLEL DO
  !
ELSE
  !
  IDX = IDX + 1
  !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_1',1,ZHOOK_HANDLE)
#ifdef SFX_MPI
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_3',0,ZHOOK_HANDLE)
  !
  XTIME0 = MPI_WTIME()
  CALL MPI_RECV(ZWORK2(:,:),SIZE(ZWORK2)*KIND(ZWORK2)/4,MPI_REAL,IPIO,IDX,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_3',1,ZHOOK_HANDLE)
  !  
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_4',0,ZHOOK_HANDLE)
!
IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,ZWORK2(:,:),PWORK2(:,:))
ELSE
  PWORK2(:,:) = ZWORK2(1:SIZE(PWORK2,1),:)
ENDIF
!
IF (.NOT.PRESENT(KDX)) IDX_R = IDX_R + 1
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D_4',1,ZHOOK_HANDLE)
!
END SUBROUTINE READ_AND_SEND_MPI_X2D
!**************************************************************************
!
SUBROUTINE READ_AND_SEND_MPI_X3D(PWORK,PWORK2,KMASK,KPIO,KDX)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, IDX_R, WLOG_MPI, &
                            NREQ
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:,:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
INTEGER, INTENT(IN), OPTIONAL :: KPIO
INTEGER, INTENT(IN), OPTIONAL :: KDX
!
REAL, DIMENSION(NSIZE,SIZE(PWORK2,2),SIZE(PWORK2,3),NPROC) :: ZWORK3S
REAL, DIMENSION(NSIZE,SIZE(PWORK2,2),SIZE(PWORK2,3)) :: ZWORK3
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: IP2, IS2, IP3, IS3
INTEGER :: ICPT, IPIO, IDX 
INTEGER :: I,J
INTEGER :: INFOMPI, IREQ
DOUBLE PRECISION   :: XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE, ZHOOK_HANDLE_OMP
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_1',0,ZHOOK_HANDLE)
!
IF (PRESENT(KPIO)) THEN
  IPIO = KPIO
ELSE
  IPIO = NPIO
ENDIF
!
IF (PRESENT(KDX)) THEN
  IDX = KDX
ELSE
  IDX = IDX_R
ENDIF
!
IF (NRANK==IPIO) THEN
  !  
  IDX = IDX + 1
  !  
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_1',1,ZHOOK_HANDLE)
!$OMP PARALLEL DO PRIVATE(I,ICPT,J,IREQ,INFOMPI,ZHOOK_HANDLE_OMP)  
  DO I=0,NPROC-1
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_2',0,ZHOOK_HANDLE_OMP)
    !
#ifdef SFX_MPI    
    XTIME0 = MPI_WTIME()
#endif    
    ! 
    ICPT = 0
    !
    ZWORK3S(:,:,:,I+1) = 0.
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==I ) THEN
        ICPT = ICPT + 1
        ZWORK3S(ICPT,:,:,I+1) = PWORK(J,:,:)
      ENDIF
      !
    ENDDO
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_2',1,ZHOOK_HANDLE_OMP)
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_3',0,ZHOOK_HANDLE_OMP)
    !
#ifdef SFX_MPI    
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
#endif    
    !    
    IF (I/=IPIO) THEN
#ifdef SFX_MPI               
      IF (PRESENT(KPIO).AND.PRESENT(KDX)) THEN
        IF (I<IPIO) THEN
          IREQ = I+1
        ELSE
          IREQ = I
        ENDIF            
        XTIME0 = MPI_WTIME()
        CALL MPI_ISEND(ZWORK3S(:,:,:,I+1),SIZE(ZWORK3)*KIND(ZWORK3)/4,&
                        MPI_REAL,I,IDX,NCOMM,NREQ(IREQ),INFOMPI)
      ELSE            
        CALL MPI_SEND(ZWORK3S(:,:,:,I+1),SIZE(ZWORK3)*KIND(ZWORK3)/4,&
                       MPI_REAL,I,IDX,NCOMM,INFOMPI)
      ENDIF
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif      
    ELSE
      ZWORK3(:,:,:) = ZWORK3S(:,:,:,I+1)     
    ENDIF
    !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_3',1,ZHOOK_HANDLE_OMP)
  ENDDO
!$OMP END PARALLEL DO 
  !  
ELSE
  !  
  IDX = IDX + 1
  !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_1',1,ZHOOK_HANDLE)
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_2',0,ZHOOK_HANDLE)  
#ifdef SFX_MPI 
  !
  XTIME0 = MPI_WTIME()  
  CALL MPI_RECV(ZWORK3,SIZE(ZWORK3)*KIND(ZWORK3)/4,MPI_REAL,IPIO,IDX,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_2',1,ZHOOK_HANDLE)
  !  
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_4',0,ZHOOK_HANDLE)
!
IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,ZWORK3(:,:,:),PWORK2)
ELSE
  PWORK2(:,:,:) = ZWORK3(1:SIZE(PWORK2,1),:,:)
ENDIF
!
IF (.NOT.PRESENT(KDX)) IDX_R = IDX_R + 1
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D_4',1,ZHOOK_HANDLE)
!
END SUBROUTINE READ_AND_SEND_MPI_X3D
