!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
SUBROUTINE PUT_IN_TIME(HNAME,HTYPE,NTIME1,NTIME2,PDATA)

USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB

USE MODI_ABOR1_SFX

IMPLICIT NONE

CHARACTER(LEN=*), INTENT(IN) :: HNAME
CHARACTER(LEN=3), INTENT(IN) :: HTYPE

INTEGER, INTENT(IN) :: NTIME1
INTEGER, INTENT(IN) :: NTIME2
REAL, DIMENSION(:,:,:), INTENT(INOUT) :: PDATA

CHARACTER(LEN=2) :: YTIME1, YTIME2
INTEGER :: I1, I2, JJ, JTIME
REAL, DIMENSION(SIZE(PDATA,1),NTIME1,SIZE(PDATA,3)) :: ZDATA
REAL(KIND=JPRB) :: ZHOOK_HANDLE


IF (LHOOK) CALL DR_HOOK('PUT_IN_TIME',0,ZHOOK_HANDLE)

IF (NTIME1.LE.0 .OR. NTIME1.GT.NTIME2) THEN
  CALL ABOR1_SFX("PUT_IN_TIME: NTIME1 MUST BE <= NTIME2 AND > 0")
ELSEIF (NTIME1==NTIME2) THEN
  IF (LHOOK) CALL DR_HOOK('PUT_IN_TIME',1,ZHOOK_HANDLE)
  RETURN
ELSEIF (NTIME1==1) THEN
  DO JJ=2,NTIME2
    PDATA(:,JJ,:)=PDATA(:,1,:)
  ENDDO
ELSEIF (NTIME1==2) THEN !2 values: winter and summer
  IF (NTIME2.EQ.36) THEN
    ZDATA=PDATA(:,1:2,:)
    DO JJ=1,8
      PDATA(:,JJ,:)=ZDATA(:,1,:)  !until 20 march
    ENDDO
    DO JJ=9,26
      PDATA(:,JJ,:)=ZDATA(:,2,:) !from 21 march to 20 september
    ENDDO
    DO JJ=27,36
      PDATA(:,JJ,:)=ZDATA(:,1,:) !from 21 september to 31 december
    ENDDO
  ELSEIF (NTIME2.EQ.12) THEN
    ZDATA=PDATA(:,1:2,:)
    DO JJ=1,3
      PDATA(:,JJ,:)=ZDATA(:,1,:)  !until 20 march
    ENDDO
    DO JJ=4,9
      PDATA(:,JJ,:)=ZDATA(:,2,:) !from 21 march to 20 september
    ENDDO
    DO JJ=10,12
      PDATA(:,JJ,:)=ZDATA(:,1,:) !from 21 september to 31 december
    ENDDO          
  ELSE
    CALL ABOR1_SFX('PUT_IN_TIME: WITH NTIME1=2, NTIME2 MUST BE =36 OR =12 (WINTER AND SUMMER VALUES) '//&
                   'PROBLEM VAR '//HNAME//''//HTYPE)          
  ENDIF
ELSE
  I1=NTIME2/NTIME1
  I2=NTIME2/I1  
  IF (I2.NE.NTIME1)THEN
     WRITE(YTIME1,'(I2.2)')NTIME1
     WRITE(YTIME2,'(I2.2)')NTIME2
     CALL ABOR1_SFX('PUT_INT_TIME: NTIME2 (='//YTIME2(1:LEN_TRIM(YTIME2))          // &
                    ') MUST BE A MULTIPLE OF NTIME1 (='//YTIME1(1:LEN_TRIM(YTIME1))// &
                    ') PROBLEM VAR '//HNAME//''//HTYPE)
  ENDIF
  ZDATA=PDATA(:,1:NTIME1,:)
  DO JTIME=1,NTIME1
    DO JJ=(JTIME-1)*I1+1,JTIME*I1
      PDATA(:,JJ,:)=ZDATA(:,JTIME,:)
    ENDDO
  ENDDO
ENDIF

IF (LHOOK) CALL DR_HOOK('PUT_IN_TIME',1,ZHOOK_HANDLE)

END SUBROUTINE PUT_IN_TIME
