!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     ##################
      MODULE MODN_WATFLUX_n
!     ##################
!
!!****  *MODN_WATFLUX_n* - declaration of namelist NAM_WATFLUXn
!!
!!    PURPOSE
!!    -------
!       The purpose of this module is to specify  the namelist NAM_WATFLUXn
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!       
!!    AUTHOR
!!    ------
!!      V. Masson    *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004                    
!!      Modified    08/2009 by B. Decharme : LSURF_BUDGETC for all tiles
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
!
         
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
 CHARACTER(LEN=4)  :: CWAT_ALB
REAL     :: XTSTEP
REAL     :: XOUT_TSTEP
REAL     :: XDIAG_TSTEP
INTEGER  :: N2M
LOGICAL  :: L2M_MIN_ZS
LOGICAL  :: LSURF_BUDGET
LOGICAL  :: LRAD_BUDGET
LOGICAL  :: LSURF_BUDGETC
LOGICAL  :: LRESET_BUDGETC
LOGICAL  :: LCOEF
LOGICAL  :: LSURF_VARS
 CHARACTER(LEN=6)  :: CCH_DRY_DEP
 CHARACTER(LEN=6)  :: CINTERPOL_TS
!
NAMELIST/NAM_WATFLUXn/CWAT_ALB,CINTERPOL_TS
NAMELIST/NAM_DIAG_SURFn/N2M,L2M_MIN_ZS,LSURF_BUDGET,LRAD_BUDGET, &
                          LSURF_BUDGETC,LRESET_BUDGETC,LCOEF,LSURF_VARS  
NAMELIST/NAM_CH_WATFLUXn/CCH_DRY_DEP
!
CONTAINS
!
SUBROUTINE INIT_NAM_WATFLUXn (W)
!
  USE MODD_WATFLUX_n, ONLY : WATFLUX_t
!
  IMPLICIT NONE

!
  TYPE(WATFLUX_t), INTENT(INOUT) :: W
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:INIT_NAM_WATFLUXN',0,ZHOOK_HANDLE)
  XTSTEP = W%XTSTEP
  XOUT_TSTEP = W%XOUT_TSTEP  
  CWAT_ALB = W%CWAT_ALB
  CINTERPOL_TS = W%CINTERPOL_TS
IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:INIT_NAM_WATFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_WATFLUXn
!
SUBROUTINE UPDATE_NAM_WATFLUXn (W)
!
  USE MODD_WATFLUX_n, ONLY : WATFLUX_t
!
  IMPLICIT NONE

!
  TYPE(WATFLUX_t), INTENT(INOUT) :: W
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:UPDATE_NAM_WATFLUXN',0,ZHOOK_HANDLE)
  W%XTSTEP = XTSTEP
  W%XOUT_TSTEP = XOUT_TSTEP    
  W%CWAT_ALB = CWAT_ALB
  W%CINTERPOL_TS = CINTERPOL_TS
IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:UPDATE_NAM_WATFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_WATFLUXn
!
SUBROUTINE INIT_NAM_DIAG_SURFn (DGO)
!
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:INIT_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  XDIAG_TSTEP = DGO%XDIAG_TSTEP  
  N2M = DGO%N2M
  L2M_MIN_ZS = DGO%L2M_MIN_ZS
  LSURF_BUDGET = DGO%LSURF_BUDGET
  LRAD_BUDGET = DGO%LRAD_BUDGET
  LSURF_BUDGETC = DGO%LSURF_BUDGETC
  LRESET_BUDGETC = DGO%LRESET_BUDGETC  
  LCOEF = DGO%LCOEF
  LSURF_VARS = DGO%LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:INIT_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_SURFn

SUBROUTINE UPDATE_NAM_DIAG_SURFn (DGO)
!
  USE MODD_DIAG_n, ONLY : DIAG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:UPDATE_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  DGO%XDIAG_TSTEP = XDIAG_TSTEP  
  DGO%N2M = N2M
  DGO%L2M_MIN_ZS = L2M_MIN_ZS
  DGO%LSURF_BUDGET = LSURF_BUDGET
  DGO%LRAD_BUDGET = LRAD_BUDGET 
  DGO%LSURF_BUDGETC = LSURF_BUDGETC
  DGO%LRESET_BUDGETC = LRESET_BUDGETC  
  DGO%LCOEF = LCOEF
  DGO%LSURF_VARS = LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:UPDATE_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_SURFn

SUBROUTINE INIT_NAM_CH_WATFLUXn (CHW)
!
  USE MODD_CH_WATFLUX_n, ONLY : CH_WATFLUX_t
!
  IMPLICIT NONE

!
  TYPE(CH_WATFLUX_t), INTENT(INOUT) :: CHW
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:INIT_NAM_CH_WATFLUXN',0,ZHOOK_HANDLE)
  CCH_DRY_DEP = CHW%CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:INIT_NAM_CH_WATFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_WATFLUXn

SUBROUTINE UPDATE_NAM_CH_WATFLUXn (CHW)
!
  USE MODD_CH_WATFLUX_n, ONLY : CH_WATFLUX_t
!
  IMPLICIT NONE

!
  TYPE(CH_WATFLUX_t), INTENT(INOUT) :: CHW
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:UPDATE_NAM_CH_WATFLUXN',0,ZHOOK_HANDLE)
  CHW%CCH_DRY_DEP = CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_WATFLUX_N:UPDATE_NAM_CH_WATFLUXN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_WATFLUXn


END MODULE MODN_WATFLUX_n
