!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!##################
MODULE MODN_TEB_VEG_n
!##################
!
!!****  *MODN_TEB_VEG_n* - declaration of namelist NAM_TEB_VEG_n
!!
!!    PURPOSE
!!    -------
!       The purpose of this module is to specify  the namelist NAM_TEB_VEG_n
!     which concern the surface configuration of one nested  model.
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!       
!!    AUTHOR
!!    ------
!!      V. Masson    *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004                    
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
LOGICAL           :: LPERTSURF
!
LOGICAL           :: LCH_BIO_FLUX
LOGICAL           :: LCH_NO_FLUX
LOGICAL           :: LGLACIER
LOGICAL           :: LVEGUPD
LOGICAL           :: LNITRO_DILU
LOGICAL           :: LCANOPY_DRAG
!
CHARACTER(LEN=4)  :: CC1DRY
CHARACTER(LEN=4)  :: CSCOND
CHARACTER(LEN=3)  :: CSOILFRZ
CHARACTER(LEN=4)  :: CDIFSFCOND
CHARACTER(LEN=3)  :: CSNOWRES
CHARACTER(LEN=3)  :: CCPSURF
CHARACTER(LEN=4)  :: CRUNOFF
CHARACTER(LEN=3)  :: CKSAT
LOGICAL           :: LSOC
CHARACTER(LEN=3)  :: CRAIN
CHARACTER(LEN=3)  :: CHORT         
CHARACTER(LEN=28) :: CCHEM_SURF_FILE
CHARACTER(LEN=6)  :: CCH_DRY_DEP
!
REAL              :: XCGMAX
REAL              :: XTSTEP
REAL              :: XCDRAG
!
NAMELIST/NAM_ISBAn/CC1DRY,CSCOND,CSOILFRZ,CDIFSFCOND,CSNOWRES,CCPSURF, &
                   XTSTEP,XCGMAX,XCDRAG,LGLACIER, LCANOPY_DRAG, LVEGUPD, LPERTSURF  
NAMELIST/NAM_ISBA_AGSn/LNITRO_DILU
NAMELIST/NAM_SGH_ISBAn/CRUNOFF,CKSAT,LSOC,CRAIN,CHORT
NAMELIST/NAM_CH_CONTROLn/CCHEM_SURF_FILE
NAMELIST/NAM_CH_ISBAn/LCH_BIO_FLUX,CCH_DRY_DEP,LCH_NO_FLUX
!
CONTAINS
!
SUBROUTINE INIT_NAM_TEB_VEGn (TGDO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: TGDO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_TEB_VEGN',0,ZHOOK_HANDLE)
  CC1DRY       = TGDO%CC1DRY
  CSCOND       = TGDO%CSCOND
  CSOILFRZ     = TGDO%CSOILFRZ
  CDIFSFCOND   = TGDO%CDIFSFCOND
  CSNOWRES     = TGDO%CSNOWRES
  CCPSURF      = TGDO%CCPSURF
  XTSTEP       = TGDO%XTSTEP
  XCGMAX       = TGDO%XCGMAX
  XCDRAG       = TGDO%XCDRAG
  LVEGUPD      = TGDO%LVEGUPD  
  LCANOPY_DRAG = TGDO%LCANOPY_DRAG
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_TEB_VEGn

SUBROUTINE INIT_NAM_TEB_VEG_AGSn (TGDO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: TGDO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_TEB_VEG_AGSN',0,ZHOOK_HANDLE)
  LNITRO_DILU = TGDO%LNITRO_DILU
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_TEB_VEG_AGSN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_TEB_VEG_AGSn

SUBROUTINE UPDATE_NAM_TEB_VEGn (TGDO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: TGDO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_TEB_VEGN',0,ZHOOK_HANDLE)
  TGDO%CC1DRY       = CC1DRY
  TGDO%CSCOND       = CSCOND
  TGDO%CSOILFRZ     = CSOILFRZ
  TGDO%CDIFSFCOND   = CDIFSFCOND
  TGDO%CSNOWRES     = CSNOWRES
  TGDO%CCPSURF      = CCPSURF
  TGDO%XTSTEP       = XTSTEP
  TGDO%XCGMAX       = XCGMAX
  TGDO%XCDRAG       = XCDRAG
  TGDO%LVEGUPD      = LVEGUPD
  TGDO%LCANOPY_DRAG = LCANOPY_DRAG
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_TEB_VEGn

SUBROUTINE UPDATE_NAM_TEB_VEG_AGSn (TGDO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: TGDO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_TEB_VEG_AGSN',0,ZHOOK_HANDLE)
  TGDO%LNITRO_DILU = LNITRO_DILU
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_TEB_VEG_AGSN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_TEB_VEG_AGSn


SUBROUTINE INIT_NAM_SGH_TEB_VEGn (TGDO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: TGDO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_TEB_VEG_N:INIT_NAM_SGH_TEB_VEGN',0,ZHOOK_HANDLE)
  CRUNOFF = TGDO%CRUNOFF
  CKSAT   = TGDO%CKSAT
  LSOC    = TGDO%LSOC
  CRAIN   = TGDO%CRAIN
  CHORT   = TGDO%CHORT
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_SGH_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_SGH_TEB_VEGn

SUBROUTINE UPDATE_NAM_SGH_TEB_VEGn (TGDO)
!
  USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: TGDO
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_SGH_TEB_VEGN',0,ZHOOK_HANDLE)
  TGDO%CRUNOFF  = CRUNOFF
  TGDO%CKSAT    = CKSAT
  TGDO%LSOC     = LSOC
  TGDO%CRAIN    = CRAIN
  TGDO%CHORT    = CHORT
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_SGH_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_SGH_TEB_VEGn

SUBROUTINE INIT_NAM_CH_CONTROLn (CHT)
!
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!
  IMPLICIT NONE

!
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_CH_CONTROLN',0,ZHOOK_HANDLE)
  CCHEM_SURF_FILE = CHT%CCHEM_SURF_FILE
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_CH_CONTROLN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_CONTROLn

SUBROUTINE UPDATE_NAM_CH_CONTROLn (CHT)
!
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!
  IMPLICIT NONE

!
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_CH_CONTROLN',0,ZHOOK_HANDLE)
  CHT%CCHEM_SURF_FILE = CCHEM_SURF_FILE
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_CH_CONTROLN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_CONTROLn

SUBROUTINE INIT_NAM_CH_TEB_VEGn (CHT)
!
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!
  IMPLICIT NONE

!
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_CH_TEB_VEGN',0,ZHOOK_HANDLE)
  LCH_BIO_FLUX = CHT%LCH_BIO_FLUX
  LCH_NO_FLUX  = CHT%LCH_NO_FLUX
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_CH_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_TEB_VEGn

SUBROUTINE UPDATE_NAM_CH_TEB_VEGn (CHT)
!
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!
  IMPLICIT NONE

!
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_CH_TEB_VEGN',0,ZHOOK_HANDLE)
  CHT%LCH_BIO_FLUX = LCH_BIO_FLUX
  CHT%LCH_NO_FLUX  = LCH_NO_FLUX
  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_CH_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_TEB_VEGn

END MODULE MODN_TEB_VEG_n
