!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      MODULE MODE_SOIL 
!     ################
!
!!****  *MODE_SOIL * - contains soil characteristics functions
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!    
!!    All clay and sand proportions are given in FRACTION!!!
!!    (not in percentages).
!!    
!!
!!    EXTERNAL
!!    --------
!!       
!!    IMPLICIT ARGUMENTS
!!    ------------------ 
!!
!!    REFERENCE
!!    ---------
!!      Book2 of the documentation (routine READ_GR_FIELD)
!!      
!!
!!    AUTHOR
!!    ------
!!      V. Masson       * Meteo France *
!!
!!    MODIFICATIONS
!!    -------------
!!      Original        3/12/98
!!
!!       02/2014       B. Decharme correction for W33 functions
!!                                 Add ANISO_FUNC
!-----------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
INTERFACE WSAT_FUNC
  MODULE PROCEDURE WSAT_FUNC_2D
  MODULE PROCEDURE WSAT_FUNC_1D
END INTERFACE
INTERFACE WWILT_FUNC
  MODULE PROCEDURE WWILT_FUNC_2D
  MODULE PROCEDURE WWILT_FUNC_1D
END INTERFACE
INTERFACE WFC_FUNC
  MODULE PROCEDURE WFC_FUNC_2D
  MODULE PROCEDURE WFC_FUNC_1D
END INTERFACE
INTERFACE W33_FUNC
  MODULE PROCEDURE W33_FUNC_2D
  MODULE PROCEDURE W33_FUNC_1D
END INTERFACE
INTERFACE BCOEF_FUNC
  MODULE PROCEDURE BCOEF_FUNC_2D
  MODULE PROCEDURE BCOEF_FUNC_1D
END INTERFACE
INTERFACE MATPOTSAT_FUNC
  MODULE PROCEDURE MATPOTSAT_FUNC_2D
  MODULE PROCEDURE MATPOTSAT_FUNC_1D
END INTERFACE
INTERFACE HYDCONDSAT_FUNC
  MODULE PROCEDURE HYDCONDSAT_FUNC_2D
  MODULE PROCEDURE HYDCONDSAT_FUNC_1D
END INTERFACE
INTERFACE CGSAT_FUNC
  MODULE PROCEDURE CGSAT_FUNC_2D
  MODULE PROCEDURE CGSAT_FUNC_1D
END INTERFACE
INTERFACE C1SAT_FUNC
  MODULE PROCEDURE C1SAT_FUNC_2D
  MODULE PROCEDURE C1SAT_FUNC_1D
END INTERFACE
INTERFACE C2REF_FUNC
  MODULE PROCEDURE C2REF_FUNC_2D
  MODULE PROCEDURE C2REF_FUNC_1D
END INTERFACE
INTERFACE C3_FUNC
  MODULE PROCEDURE C3_FUNC_2D
  MODULE PROCEDURE C3_FUNC_1D
END INTERFACE
INTERFACE C4B_FUNC
  MODULE PROCEDURE C4B_FUNC_2D
  MODULE PROCEDURE C4B_FUNC_1D
END INTERFACE
INTERFACE C4REF_FUNC
  MODULE PROCEDURE C4REF_FUNC_2D
  MODULE PROCEDURE C4REF_FUNC_1D
END INTERFACE
INTERFACE ACOEF_FUNC
  MODULE PROCEDURE ACOEF_FUNC_2D
  MODULE PROCEDURE ACOEF_FUNC_1D
END INTERFACE
INTERFACE PCOEF_FUNC
  MODULE PROCEDURE PCOEF_FUNC_2D
  MODULE PROCEDURE PCOEF_FUNC_1D
END INTERFACE
INTERFACE ANISO_FUNC
  MODULE PROCEDURE ANISO_FUNC_2D
  MODULE PROCEDURE ANISO_FUNC_1D
END INTERFACE
!
!-------------------------------------------------------------------------------
CONTAINS
!
   FUNCTION WSAT_FUNC_2D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY   
   REAL, DIMENSION(:,:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),     INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PSAND,1),SIZE(PSAND,2)) :: WSAT_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WSAT_FUNC_2D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PSAND/=XUNDEF) WSAT_FUNC_2D = 0.001 * (-108.*PSAND+494.305)
     CASE ('CO84')
       WHERE(PSAND/=XUNDEF) WSAT_FUNC_2D = 0.505-0.142*PSAND-0.037*PCLAY            
   END SELECT   
   !
   WHERE (PSAND==XUNDEF) WSAT_FUNC_2D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WSAT_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION WSAT_FUNC_2D
   !
   !
   !
   FUNCTION WWILT_FUNC_2D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:,:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),     INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: WWILT_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WWILT_FUNC_2D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PCLAY/=XUNDEF) WWILT_FUNC_2D = 37.1342E-3*(PCLAY*100.)**0.5
     CASE ('CO84')
       WHERE(PCLAY/=XUNDEF) &
       WWILT_FUNC_2D = 0.15333-0.147*PSAND+0.33*PCLAY-0.102*(PCLAY**2)
   END SELECT
   
   WHERE (PCLAY==XUNDEF) WWILT_FUNC_2D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WWILT_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION WWILT_FUNC_2D
   !
   !
   !
   FUNCTION WFC_FUNC_2D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:,:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),     INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: WFC_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WFC_FUNC_2D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PCLAY/=XUNDEF) WFC_FUNC_2D = 89.0467E-3*(PCLAY*100.)**0.3496
     CASE ('CO84')
       WHERE(PCLAY/=XUNDEF) &
         WFC_FUNC_2D = 0.1537-0.1233*PSAND+0.2685*PCLAY**(1./3.)
   END SELECT
   
   WHERE (PCLAY==XUNDEF) WFC_FUNC_2D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WFC_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION WFC_FUNC_2D
   !
   !
   !
   FUNCTION W33_FUNC_2D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:,:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),     INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: W33_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:W33_FUNC_2D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PCLAY/=XUNDEF) &
         W33_FUNC_2D = 0.2298915119-0.4062575773*PSAND+0.0874218705*PCLAY    &
                     + 0.2942558675*PSAND**(1./3.)+0.0413771051*PCLAY**(1./3.)
     CASE ('CO84')
       WHERE(PCLAY/=XUNDEF) &
         W33_FUNC_2D = 0.2016592588-0.5785747196*PSAND+0.1113006987*PCLAY    &
                     + 0.4305771483*PSAND**(1./3.)-0.0080618093*PCLAY**(1./3.) 
   END SELECT
   
   WHERE (PCLAY==XUNDEF) W33_FUNC_2D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:W33_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION W33_FUNC_2D
   !
   !
   !
   FUNCTION BCOEF_FUNC_2D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:,:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),     INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: BCOEF_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:BCOEF_FUNC_2D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE (PCLAY/=XUNDEF) BCOEF_FUNC_2D = 13.7*PCLAY + 3.501
     CASE ('CO84')
       WHERE (PCLAY/=XUNDEF) BCOEF_FUNC_2D = 3.10+15.7*PCLAY-0.3*PSAND
   END SELECT
   
   WHERE (PCLAY==XUNDEF) BCOEF_FUNC_2D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:BCOEF_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION BCOEF_FUNC_2D
   !
   !
   !
   FUNCTION MATPOTSAT_FUNC_2D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY   
   REAL, DIMENSION(:,:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),     INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PSAND,1),SIZE(PSAND,2)) :: MATPOTSAT_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:MATPOTSAT_FUNC_2D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PSAND/=XUNDEF) MATPOTSAT_FUNC_2D = -0.01*(10.**(1.85 - 0.88*PSAND))
     CASE ('CO84')
       WHERE(PSAND/=XUNDEF) &
         MATPOTSAT_FUNC_2D = -0.01*(10.0**(1.54-0.95*PSAND+0.63*(1.-PSAND-PCLAY)))
   END SELECT
   
   WHERE (PSAND==XUNDEF) MATPOTSAT_FUNC_2D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:MATPOTSAT_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION MATPOTSAT_FUNC_2D
   !
   !
   FUNCTION HYDCONDSAT_FUNC_2D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:,:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),     INTENT(IN)     :: HPEDOTF
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: HYDCONDSAT_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:HYDCONDSAT_FUNC_2D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PCLAY/=XUNDEF)
         HYDCONDSAT_FUNC_2D = 1.0e-6*(10.0**(0.161874E+01                               &
                            - 0.581989E+01*PCLAY(:,:)    - 0.907123E-01*PSAND(:,:)      &
                            + 0.529268E+01*PCLAY(:,:)**2 + 0.120332E+01*PSAND(:,:)**2))
       END WHERE
     CASE ('CO84')
       WHERE(PCLAY/=XUNDEF) &
         HYDCONDSAT_FUNC_2D = 0.0254*(10.0**(-0.6+1.26*PSAND-0.64*PCLAY))/3600.
   END SELECT
   !
   WHERE(PCLAY==XUNDEF) HYDCONDSAT_FUNC_2D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:HYDCONDSAT_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION HYDCONDSAT_FUNC_2D
   !
   !
   !
   FUNCTION CGSAT_FUNC_2D(PCLAY,PSAND)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:,:), INTENT(IN)     :: PSAND
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: CGSAT_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:CGSAT_FUNC_2D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     CGSAT_FUNC_2D = ( -1.5571*PSAND - 1.441*PCLAY + 4.70217 )*1.E-6
   ELSEWHERE
     CGSAT_FUNC_2D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:CGSAT_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION CGSAT_FUNC_2D
   !
   !
   !
   FUNCTION C1SAT_FUNC_2D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: C1SAT_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C1SAT_FUNC_2D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     C1SAT_FUNC_2D = 0.01*(558.*PCLAY+84.88)
   ELSEWHERE
     C1SAT_FUNC_2D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C1SAT_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION C1SAT_FUNC_2D
   !
   !
   !
   FUNCTION C2REF_FUNC_2D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: C2REF_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C2REF_FUNC_2D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     C2REF_FUNC_2D = 13.815*(PCLAY*100.)**(-0.954)
   ELSEWHERE
     C2REF_FUNC_2D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C2REF_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION C2REF_FUNC_2D
   !
   !
   !
   FUNCTION C3_FUNC_2D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: C3_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C3_FUNC_2D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     C3_FUNC_2D = 5.327*(PCLAY*100.)**(-1.043)
   ELSEWHERE
     C3_FUNC_2D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C3_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION C3_FUNC_2D
   !
   !
   !
   FUNCTION C4B_FUNC_2D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: C4B_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C4B_FUNC_2D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     C4B_FUNC_2D = 5.14+11.47*PCLAY
   ELSEWHERE
     C4B_FUNC_2D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C4B_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION C4B_FUNC_2D
   !
   !
   !
   FUNCTION C4REF_FUNC_2D(PCLAY,PSAND,PD2,PD3)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:,:), INTENT(IN)     :: PSAND
   REAL, DIMENSION(:,:), INTENT(IN)     :: PD2
   REAL, DIMENSION(:,:), INTENT(IN)     :: PD3
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: C4REF_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C4REF_FUNC_2D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF .AND. PD2/=XUNDEF .AND. PD3/=XUNDEF)
     C4REF_FUNC_2D = 10.0**(  4.421                                    &
                              + 0.4881  * PSAND     - 25.73  * PCLAY     &
                              + 5.927   *(PSAND**2) + 88.63  *(PCLAY**2) &
                              - 6.085   *(PSAND**3) - 81.33  *(PCLAY**3) )  
   !
   ! Scale the C4 coefficient as a function of grid geometry:
   ! NOTE that 2.0 represents the value for a coefficient which
   !      represents the baseline grid geometry with units of m**2
   !      so that the scaling is dimensionless.
   !
     C4REF_FUNC_2D = C4REF_FUNC_2D*2.0*(PD3-PD2)/(PD2*PD3*PD3)
   !
   ELSEWHERE
     C4REF_FUNC_2D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C4REF_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION C4REF_FUNC_2D
   !
   !
   !
   FUNCTION ACOEF_FUNC_2D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: ACOEF_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:ACOEF_FUNC_2D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     ACOEF_FUNC_2D = 732.42E-3*(PCLAY*100.)**(-0.539)
   ELSEWHERE
     ACOEF_FUNC_2D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:ACOEF_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION ACOEF_FUNC_2D
   !
   !
   !
   FUNCTION PCOEF_FUNC_2D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: PCOEF_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:PCOEF_FUNC_2D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     PCOEF_FUNC_2D = 13.4*PCLAY+3.4
   ELSEWHERE
     PCOEF_FUNC_2D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:PCOEF_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION PCOEF_FUNC_2D
   !
   !
   !
   FUNCTION ANISO_FUNC_2D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:,:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY,1),SIZE(PCLAY,2)) :: ANISO_FUNC_2D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:ANISO_FUNC_2D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     ANISO_FUNC_2D = 1.55+32.85*PCLAY(:,:)+65.637*PCLAY(:,:)**2
   ELSEWHERE
     ANISO_FUNC_2D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:ANISO_FUNC_2D',1,ZHOOK_HANDLE)
   !
   END FUNCTION ANISO_FUNC_2D
   
!                                                          
!
!-------------------------------------------------------------------------------
!
   FUNCTION WSAT_FUNC_1D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY   
   REAL, DIMENSION(:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),   INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PSAND))       :: WSAT_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WSAT_FUNC_1D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PSAND/=XUNDEF) WSAT_FUNC_1D = 0.001 * (-108.*PSAND+494.305)
     CASE ('CO84')
       WHERE(PSAND/=XUNDEF) WSAT_FUNC_1D = 0.505-0.142*PSAND-0.037*PCLAY            
   END SELECT   

   WHERE (PSAND==XUNDEF) WSAT_FUNC_1D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WSAT_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION WSAT_FUNC_1D
   !
   !
   !
   FUNCTION WWILT_FUNC_1D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),   INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PCLAY))       :: WWILT_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WWILT_FUNC_1D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PCLAY/=XUNDEF) WWILT_FUNC_1D = 37.1342E-3*(PCLAY*100.)**0.5
     CASE ('CO84')
       WHERE(PCLAY/=XUNDEF) &
       WWILT_FUNC_1D = 0.15333-0.147*PSAND+0.33*PCLAY-0.102*(PCLAY**2)
   END SELECT   
   !
   WHERE (PCLAY==XUNDEF) WWILT_FUNC_1D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WWILT_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION WWILT_FUNC_1D
   !
   !
   !
   FUNCTION WFC_FUNC_1D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),   INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PCLAY))       :: WFC_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WFC_FUNC_1D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PCLAY/=XUNDEF) WFC_FUNC_1D = 89.0467E-3*(PCLAY*100.)**0.3496
     CASE ('CO84')
       WHERE(PCLAY/=XUNDEF) &
         WFC_FUNC_1D = 0.1537-0.1233*PSAND+0.2685*PCLAY**(1./3.)
   END SELECT 
   !
   WHERE (PCLAY==XUNDEF) WFC_FUNC_1D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:WFC_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION WFC_FUNC_1D
   !
   !
   !
   FUNCTION W33_FUNC_1D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),   INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PCLAY))       :: W33_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:W33_FUNC_1D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PCLAY/=XUNDEF) &
         W33_FUNC_1D = 0.2298915119-0.4062575773*PSAND+0.0874218705*PCLAY    &
                     + 0.2942558675*PSAND**(1./3.)+0.0413771051*PCLAY**(1./3.)                     
     CASE ('CO84')
       WHERE(PCLAY/=XUNDEF) &
         W33_FUNC_1D = 0.2016592588-0.5785747196*PSAND+0.1113006987*PCLAY    &
                     + 0.4305771483*PSAND**(1./3.)-0.0080618093*PCLAY**(1./3.) 
   END SELECT
   
   WHERE (PCLAY==XUNDEF) W33_FUNC_1D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:W33_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION W33_FUNC_1D  
   !
   !
   !   
   FUNCTION BCOEF_FUNC_1D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),   INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PCLAY))       :: BCOEF_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:BCOEF_FUNC_1D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE (PCLAY/=XUNDEF) BCOEF_FUNC_1D = 13.7*PCLAY + 3.501
     CASE ('CO84')
       WHERE (PCLAY/=XUNDEF) BCOEF_FUNC_1D = 3.10+15.7*PCLAY-0.3*PSAND
   END SELECT   

   WHERE (PCLAY==XUNDEF) BCOEF_FUNC_1D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:BCOEF_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION BCOEF_FUNC_1D
   !
   !
   !
   FUNCTION MATPOTSAT_FUNC_1D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),   INTENT(IN)     :: HPEDOTF
   REAL, DIMENSION(SIZE(PSAND))       :: MATPOTSAT_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:MATPOTSAT_FUNC_1D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PSAND/=XUNDEF) MATPOTSAT_FUNC_1D = -0.01*(10.**(1.85 - 0.88*PSAND))
     CASE ('CO84')
       WHERE(PSAND/=XUNDEF) &
         MATPOTSAT_FUNC_1D = -0.01*(10.0**(1.54-0.95*PSAND+0.63*(1.-PSAND-PCLAY)))
   END SELECT   

   WHERE (PSAND==XUNDEF) MATPOTSAT_FUNC_1D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:MATPOTSAT_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION MATPOTSAT_FUNC_1D
   !
   !
   !
   FUNCTION HYDCONDSAT_FUNC_1D(PCLAY,PSAND,HPEDOTF)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:), INTENT(IN)     :: PSAND
   CHARACTER(LEN=4),   INTENT(IN)     :: HPEDOTF   
   REAL, DIMENSION(SIZE(PCLAY))       :: HYDCONDSAT_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:HYDCONDSAT_FUNC_1D',0,ZHOOK_HANDLE)
   SELECT CASE (HPEDOTF)
     CASE ('CH78')
       WHERE(PCLAY/=XUNDEF)
         HYDCONDSAT_FUNC_1D = 1.0e-6*(10.0**(0.161874E+01                   &
                            - 0.581989E+01*PCLAY    - 0.907123E-01*PSAND    &
                            + 0.529268E+01*PCLAY**2 + 0.120332E+01*PSAND**2))
       END WHERE
     CASE ('CO84')
       WHERE(PCLAY/=XUNDEF) &
         HYDCONDSAT_FUNC_1D = 0.0254*(10.0**(-0.6+1.26*PSAND-0.64*PCLAY))/3600.
   END SELECT   
   !
   WHERE(PCLAY==XUNDEF) HYDCONDSAT_FUNC_1D = XUNDEF
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:HYDCONDSAT_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION HYDCONDSAT_FUNC_1D
   !
   !
   !
   FUNCTION CGSAT_FUNC_1D(PCLAY,PSAND)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:), INTENT(IN)     :: PSAND
   REAL, DIMENSION(SIZE(PCLAY))       :: CGSAT_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:CGSAT_FUNC_1D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     CGSAT_FUNC_1D = ( -1.5571*PSAND - 1.441*PCLAY + 4.70217 )*1.E-6
   ELSEWHERE
     CGSAT_FUNC_1D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:CGSAT_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION CGSAT_FUNC_1D
   !
   !
   !
   FUNCTION C1SAT_FUNC_1D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY))       :: C1SAT_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C1SAT_FUNC_1D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     C1SAT_FUNC_1D = 0.01*(558.*PCLAY+84.88)
   ELSEWHERE
     C1SAT_FUNC_1D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C1SAT_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION C1SAT_FUNC_1D
   !
   !
   !
   FUNCTION C2REF_FUNC_1D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY))       :: C2REF_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C2REF_FUNC_1D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     C2REF_FUNC_1D = 13.815*(PCLAY*100.)**(-0.954)
   ELSEWHERE
     C2REF_FUNC_1D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C2REF_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION C2REF_FUNC_1D
   !
   !
   !
   FUNCTION C3_FUNC_1D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY))       :: C3_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C3_FUNC_1D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     C3_FUNC_1D = 5.327*(PCLAY*100.)**(-1.043)
   ELSEWHERE
     C3_FUNC_1D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C3_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION C3_FUNC_1D
   !
   !
   !
   FUNCTION C4B_FUNC_1D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY))       :: C4B_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C4B_FUNC_1D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     C4B_FUNC_1D = 5.14+11.47*PCLAY
   ELSEWHERE
     C4B_FUNC_1D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C4B_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION C4B_FUNC_1D
   !
   !
   !
   FUNCTION C4REF_FUNC_1D(PCLAY,PSAND,PD2,PD3)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(:), INTENT(IN)     :: PSAND
   REAL, DIMENSION(:), INTENT(IN)     :: PD2
   REAL, DIMENSION(:), INTENT(IN)     :: PD3
   REAL, DIMENSION(SIZE(PCLAY))       :: C4REF_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C4REF_FUNC_1D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF .AND. PD2/=XUNDEF .AND. PD3/=XUNDEF)
     C4REF_FUNC_1D = 10.0**(  4.421                                    &
                              + 0.4881  * PSAND     - 25.73  * PCLAY     &
                              + 5.927   *(PSAND**2) + 88.63  *(PCLAY**2) &
                              - 6.085   *(PSAND**3) - 81.33  *(PCLAY**3) )  
   !
   ! Scale the C4 coefficient as a function of grid geometry:
   ! NOTE that 2.0 represents the value for a coefficient which
   !      represents the baseline grid geometry with units of m**2
   !      so that the scaling is dimensionless.
   !
     C4REF_FUNC_1D = C4REF_FUNC_1D*2.0*(PD3-PD2)/(PD2*PD3*PD3)
   !
   ELSEWHERE
     C4REF_FUNC_1D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:C4REF_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION C4REF_FUNC_1D
   !
   !
   !
   FUNCTION ACOEF_FUNC_1D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY))       :: ACOEF_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:ACOEF_FUNC_1D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     ACOEF_FUNC_1D = 732.42E-3*(PCLAY*100.)**(-0.539)
   ELSEWHERE
     ACOEF_FUNC_1D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:ACOEF_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION ACOEF_FUNC_1D
   !
   !
   !
   FUNCTION PCOEF_FUNC_1D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY))       :: PCOEF_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:PCOEF_FUNC_1D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     PCOEF_FUNC_1D = 13.4*PCLAY+3.4
   ELSEWHERE
     PCOEF_FUNC_1D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:PCOEF_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION PCOEF_FUNC_1D
   !
   !
   !
   FUNCTION ANISO_FUNC_1D(PCLAY)
   USE MODD_SURF_PAR,   ONLY : XUNDEF
   IMPLICIT NONE
   REAL, DIMENSION(:), INTENT(IN)     :: PCLAY
   REAL, DIMENSION(SIZE(PCLAY))       :: ANISO_FUNC_1D
   REAL(KIND=JPRB) :: ZHOOK_HANDLE
   !
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:ANISO_FUNC_1D',0,ZHOOK_HANDLE)
   WHERE (PCLAY/=XUNDEF)
     ANISO_FUNC_1D = 1.55+32.85*PCLAY(:)+65.637*PCLAY(:)**2
   ELSEWHERE
     ANISO_FUNC_1D = XUNDEF
   END WHERE
   IF (LHOOK) CALL DR_HOOK('MODE_SOIL:ANISO_FUNC_1D',1,ZHOOK_HANDLE)
   !
   END FUNCTION ANISO_FUNC_1D
                                                          
!-------------------------------------------------------------------------------
!
END MODULE MODE_SOIL
