!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
MODULE MODE_GEO_GAUSS
  !!
  !!     AUTHOR
  !!     ------
  !!      J-D Gril
  !!
  !!     MODIFICATION
  !!     ------------
  !!       Original  10/2005
  !!
  !--------------------------------------------------------------------------- 
  USE EGGANGLES, ONLY : LOLA
  !
!
  USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
  USE PARKIND1  ,ONLY : JPRB
!
  IMPLICIT NONE
  !
  INTERFACE GAUSS_TR
     MODULE PROCEDURE GAUSS_TR_V, GAUSS_TR_S
  END INTERFACE
  !
  INTERFACE GAUSS_RT
     MODULE PROCEDURE GAUSS_RT_V, GAUSS_RT_S
  END INTERFACE
  !
  INTERFACE ETIR
     MODULE PROCEDURE ETIR_V, ETIR_S
  END INTERFACE
  !
  INTERFACE RETRE
     MODULE PROCEDURE RETRE_V, RETRE_S
  END INTERFACE
  !
  INTERFACE ROTATE_G
     MODULE PROCEDURE ROTATE_G_V, ROTATE_G_S
  END INTERFACE
  !
  INTERFACE ANTI_ROTATE_G
     MODULE PROCEDURE ANTI_ROTATE_G_V, ANTI_ROTATE_G_S
  END INTERFACE
  ! 
  INTERFACE MAP_FAC
     MODULE PROCEDURE MAP_FAC_V, MAP_FAC_S
  END INTERFACE
  !
CONTAINS
  !==========================GAUSS_TR=========================================
  TYPE(LOLA) FUNCTION GAUSS_TR_S (PT_REEL,PT_POLE,PCODIL) RESULT (PT_G)
    TYPE (LOLA), INTENT(IN)          :: PT_REEL
    TYPE (LOLA), INTENT(IN)          :: PT_POLE
    REAL, INTENT(IN)                 :: PCODIL
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:GAUSS_TR_S',0,ZHOOK_HANDLE)
    PT_G=ETIR(ANTI_ROTATE_G(PT_REEL,PT_POLE),PCODIL)
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:GAUSS_TR_S',1,ZHOOK_HANDLE)

  END FUNCTION GAUSS_TR_S

  FUNCTION GAUSS_TR_V (PT_REEL,PT_POLE,PCODIL) RESULT (PT_G)
    TYPE (LOLA), DIMENSION(:), INTENT(IN)          :: PT_REEL
    TYPE (LOLA), INTENT(IN)          :: PT_POLE
    REAL, INTENT(IN)                 :: PCODIL
    TYPE (LOLA), DIMENSION(SIZE(PT_REEL))       :: PT_G
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:GAUSS_TR_V',0,ZHOOK_HANDLE)
    PT_G=ETIR(ANTI_ROTATE_G(PT_REEL,PT_POLE),PCODIL)
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:GAUSS_TR_V',1,ZHOOK_HANDLE)

  END FUNCTION GAUSS_TR_V
  !==========================GAUSS_RT=========================================
  TYPE(LOLA) FUNCTION GAUSS_RT_S (PT_G,PT_POLE,PCODIL) RESULT (PT_REEL)
    TYPE (LOLA), INTENT(IN)          :: PT_G
    TYPE (LOLA), INTENT(IN)          :: PT_POLE
    REAL, INTENT(IN)                 :: PCODIL
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:GAUSS_RT_S',0,ZHOOK_HANDLE)
    PT_REEL=ROTATE_G(RETRE(PT_G,PCODIL),PT_POLE)
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:GAUSS_RT_S',1,ZHOOK_HANDLE)

  END FUNCTION GAUSS_RT_S

  FUNCTION GAUSS_RT_V (PT_G,PT_POLE,PCODIL) RESULT (PT_REEL)
    TYPE (LOLA), DIMENSION(:), INTENT(IN)          :: PT_G
    TYPE (LOLA), INTENT(IN)          :: PT_POLE
    REAL, INTENT(IN)                 :: PCODIL
    TYPE (LOLA), DIMENSION(SIZE(PT_G))     :: PT_REEL
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:GAUSS_RT_V',0,ZHOOK_HANDLE)
    PT_REEL=ROTATE_G(RETRE(PT_G,PCODIL),PT_POLE)
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:GAUSS_RT_V',1,ZHOOK_HANDLE)

  END FUNCTION GAUSS_RT_V
  !==========================ROTATE_G=========================================
  TYPE(LOLA) FUNCTION ROTATE_G_S (PT_TR,PT_POLE) RESULT (PT_REEL)
    USE EGGANGLES, ONLY : COSIN_TO_ANGLE, P_ASIN
    TYPE (LOLA), INTENT(IN)          :: PT_TR
    TYPE (LOLA), INTENT(IN)          :: PT_POLE

    REAL(KIND=JPRB)    :: ZSIN, ZCOS
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ROTATE_G_S',0,ZHOOK_HANDLE)
    PT_REEL%LAT = P_ASIN(SIN(PT_POLE%LAT)*SIN(PT_TR%LAT)+COS(PT_POLE%LAT)*COS(PT_TR%LAT)*COS(PT_TR%LON)) 
    
    IF (COS(PT_REEL%LAT) /= 0.0) THEN     
      ZSIN = -1.0*COS(PT_TR%LAT)*SIN(PT_TR%LON)/COS(PT_REEL%LAT)
      ZCOS = (COS(PT_POLE%LAT)*SIN(PT_TR%LAT)-SIN(PT_POLE%LAT)*COS(PT_TR%LAT)*COS(PT_TR%LON))/COS(PT_REEL%LAT)
      PT_REEL%LON = COSIN_TO_ANGLE(ZCOS,ZSIN) + PT_POLE%LON
    ELSE
      PT_REEL%LON = 0.0
    ENDIF
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ROTATE_G_S',1,ZHOOK_HANDLE)

  END FUNCTION ROTATE_G_S

  FUNCTION ROTATE_G_V (PT_TR,PT_POLE) RESULT (PT_REEL)
    USE EGGANGLES, ONLY : COSIN_TO_ANGLE, P_ASIN
    TYPE (LOLA), DIMENSION(:), INTENT(IN)          :: PT_TR
    TYPE (LOLA), INTENT(IN)                        :: PT_POLE
    TYPE (LOLA), DIMENSION(SIZE(PT_TR))            :: PT_REEL

    REAL(KIND=JPRB), DIMENSION(SIZE(PT_TR))                   :: ZSIN, ZCOS
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ROTATE_G_V',0,ZHOOK_HANDLE)
    PT_REEL%LAT = P_ASIN(SIN(PT_POLE%LAT)*SIN(PT_TR%LAT)+COS(PT_POLE%LAT)*COS(PT_TR%LAT)*COS(PT_TR%LON)) 
    
    PT_REEL%LON = 0.0
    WHERE (COS(PT_REEL%LAT) /= 0.0)
      ZSIN = -1.0*COS(PT_TR%LAT)*SIN(PT_TR%LON)/COS(PT_REEL%LAT)
      ZCOS = (COS(PT_POLE%LAT)*SIN(PT_TR%LAT)-SIN(PT_POLE%LAT)*COS(PT_TR%LAT)*COS(PT_TR%LON))/COS(PT_REEL%LAT)
      PT_REEL%LON = COSIN_TO_ANGLE(ZCOS,ZSIN) + PT_POLE%LON
    ENDWHERE
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ROTATE_G_V',1,ZHOOK_HANDLE)


!    DO I=1,SIZE(PT_TR)
!      PT_REEL(I) = ROTATE_G(PT_TR(I),PT_POLE)
!    END DO

  END FUNCTION ROTATE_G_V
  !==========================ANTI_ROTATE_G====================================
  TYPE(LOLA) FUNCTION ANTI_ROTATE_G_S (PT_REEL,PT_POLE) RESULT (PT_TR)
    USE EGGANGLES, ONLY : COSIN_TO_ANGLE, P_ASIN
    TYPE (LOLA), INTENT(IN)          :: PT_REEL
    TYPE (LOLA), INTENT(IN)          :: PT_POLE

    REAL(KIND=JPRB) :: ZSIN, ZCOS
    REAL(KIND=JPRB) :: ZHOOK_HANDLE
   
    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ANTI_ROTATE_G_S',0,ZHOOK_HANDLE)
    PT_TR%LAT = P_ASIN(SIN(PT_POLE%LAT)*SIN(PT_REEL%LAT)+COS(PT_POLE%LAT)*COS(PT_REEL%LAT)*COS(PT_REEL%LON-PT_POLE%LON))
 
   IF (COS(PT_TR%LAT) /= 0.0) THEN     
      ZSIN = -1.0*COS(PT_REEL%LAT)*SIN(PT_REEL%LON-PT_POLE%LON)/COS(PT_TR%LAT)
      ZCOS = (COS(PT_POLE%LAT)*SIN(PT_REEL%LAT)-SIN(PT_POLE%LAT)*COS(PT_REEL%LAT)*COS(PT_REEL%LON-PT_POLE%LON))/COS(PT_TR%LAT)
      PT_TR%LON = COSIN_TO_ANGLE(ZCOS,ZSIN)
    ELSE
      PT_TR%LON = 0.0
    ENDIF
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ANTI_ROTATE_G_S',1,ZHOOK_HANDLE)
  END FUNCTION ANTI_ROTATE_G_S

  FUNCTION ANTI_ROTATE_G_V (PT_REEL,PT_POLE) RESULT (PT_TR)
    USE EGGANGLES, ONLY : COSIN_TO_ANGLE, P_ASIN
    TYPE (LOLA), DIMENSION(:), INTENT(IN)          :: PT_REEL
    TYPE (LOLA), INTENT(IN)                        :: PT_POLE
    TYPE (LOLA), DIMENSION(SIZE(PT_REEL))          :: PT_TR  

    REAL(KIND=JPRB), DIMENSION(SIZE(PT_REEL)) :: ZSIN, ZCOS
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

   IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ANTI_ROTATE_G_V',0,ZHOOK_HANDLE)
   PT_TR%LAT = P_ASIN(SIN(PT_POLE%LAT)*SIN(PT_REEL%LAT)+COS(PT_POLE%LAT)*COS(PT_REEL%LAT)*COS(PT_REEL%LON-PT_POLE%LON))
 
    PT_TR%LON = 0.0
    WHERE (COS(PT_TR%LAT) /= 0.0)
      ZSIN = -1.0*COS(PT_REEL%LAT)*SIN(PT_REEL%LON-PT_POLE%LON)/COS(PT_TR%LAT)
      ZCOS = (COS(PT_POLE%LAT)*SIN(PT_REEL%LAT)-SIN(PT_POLE%LAT)*COS(PT_REEL%LAT)*COS(PT_REEL%LON-PT_POLE%LON))/COS(PT_TR%LAT)
      PT_TR%LON = COSIN_TO_ANGLE(ZCOS,ZSIN)
    ENDWHERE
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ANTI_ROTATE_G_V',1,ZHOOK_HANDLE)

!    DO I=1,SIZE(PT_REEL)
!      PT_TR(I) = ANTI_ROTATE_G(PT_REEL(I),PT_POLE)
!    END DO

  END FUNCTION ANTI_ROTATE_G_V
  !==========================ETIR=============================================
  TYPE(LOLA) FUNCTION ETIR_S (PT_COORD,PCODIL) RESULT (PT_ET)
    USE EGGANGLES, ONLY : COSIN_TO_ANGLE
    TYPE (LOLA), INTENT(IN)          :: PT_COORD
    REAL, INTENT(IN)                 :: PCODIL

    REAL(KIND=JPRB) :: ZPC2, ZSIN, ZCOS
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ETIR_S',0,ZHOOK_HANDLE)
    PT_ET%LON = PT_COORD%LON
    ZPC2  = PCODIL*PCODIL
    ZSIN = ((1.0-ZPC2)+(1.0+ZPC2)*SIN(PT_COORD%LAT))/((1.0+ZPC2)+(1.0-ZPC2)*SIN(PT_COORD%LAT))
    ZCOS = 2.0*PCODIL*COS(PT_COORD%LAT)/((1.0+ZPC2)+(1.0-ZPC2)*SIN(PT_COORD%LAT))

    PT_ET%LAT = COSIN_TO_ANGLE(ZCOS,ZSIN)
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ETIR_S',1,ZHOOK_HANDLE)

  END FUNCTION ETIR_S

  FUNCTION ETIR_V (PT_COORD,PCODIL) RESULT (PT_ET)
    USE EGGANGLES, ONLY : COSIN_TO_ANGLE
    TYPE (LOLA), DIMENSION(:), INTENT(IN)   :: PT_COORD
    REAL, INTENT(IN)                        :: PCODIL
    TYPE (LOLA), DIMENSION(SIZE(PT_COORD))  :: PT_ET

    REAL(KIND=JPRB), DIMENSION(SIZE(PT_COORD))         :: ZPC2, ZSIN, ZCOS
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ETIR_V',0,ZHOOK_HANDLE)
    PT_ET%LON = PT_COORD%LON
    ZPC2  = PCODIL*PCODIL
    ZSIN = ((1.0-ZPC2)+(1.0+ZPC2)*SIN(PT_COORD%LAT))/((1.0+ZPC2)+(1.0-ZPC2)*SIN(PT_COORD%LAT))
    ZCOS = 2.0*PCODIL*COS(PT_COORD%LAT)/((1.0+ZPC2)+(1.0-ZPC2)*SIN(PT_COORD%LAT))

    PT_ET%LAT = COSIN_TO_ANGLE(ZCOS,ZSIN)
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:ETIR_V',1,ZHOOK_HANDLE)

  END FUNCTION ETIR_V
  !==========================RETRE============================================
  TYPE(LOLA) FUNCTION RETRE_S (PT_COORD,PCODIL) RESULT (PT_RE)
    USE EGGANGLES, ONLY : COSIN_TO_ANGLE
    TYPE (LOLA), INTENT(IN)          :: PT_COORD
    REAL, INTENT(IN)                 :: PCODIL

    REAL(KIND=JPRB)     :: ZPC2, ZSIN, ZCOS
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:RETRE_S',0,ZHOOK_HANDLE)
    PT_RE%LON = PT_COORD%LON
    ZPC2  = PCODIL*PCODIL
    ZSIN = (-1.0*(1.0-ZPC2)+(1.0+ZPC2)*SIN(PT_COORD%LAT))/((1.0+ZPC2)-(1.0-ZPC2)*SIN(PT_COORD%LAT))
    ZCOS = 2.0*PCODIL*COS(PT_COORD%LAT)/((1.0+ZPC2)-(1.0-ZPC2)*SIN(PT_COORD%LAT))

    PT_RE%LAT = COSIN_TO_ANGLE(ZCOS,ZSIN)
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:RETRE_S',1,ZHOOK_HANDLE)

  END FUNCTION RETRE_S

  FUNCTION RETRE_V (PT_COORD,PCODIL) RESULT (PT_RE)
    USE EGGANGLES, ONLY : COSIN_TO_ANGLE
    TYPE (LOLA), DIMENSION(:), INTENT(IN)   :: PT_COORD
    REAL, INTENT(IN)                        :: PCODIL
    TYPE (LOLA), DIMENSION(SIZE(PT_COORD))  :: PT_RE

    REAL(KIND=JPRB), DIMENSION(SIZE(PT_COORD))         :: ZPC2, ZSIN, ZCOS
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:RETRE_V',0,ZHOOK_HANDLE)
    PT_RE%LON = PT_COORD%LON
    ZPC2  = PCODIL*PCODIL
    ZSIN = (-1.0*(1.0-ZPC2)+(1.0+ZPC2)*SIN(PT_COORD%LAT))/((1.0+ZPC2)-(1.0-ZPC2)*SIN(PT_COORD%LAT))
    ZCOS = 2.0*PCODIL*COS(PT_COORD%LAT)/((1.0+ZPC2)-(1.0-ZPC2)*SIN(PT_COORD%LAT))

    PT_RE%LAT = COSIN_TO_ANGLE(ZCOS,ZSIN)
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:RETRE_V',1,ZHOOK_HANDLE)

!    DO I=1,SIZE(PT_COORD)
!       PT_RE(I) = RETRE(PT_COORD(I),PCODIL)
!    END DO

  END FUNCTION RETRE_V
  !==========================MAP FACTOR=======================================
  REAL FUNCTION MAP_FAC_S (POLE,PCODIL,PT_COORD) RESULT (PMF)
    TYPE (LOLA), INTENT(IN)          :: POLE, PT_COORD
    REAL, INTENT(IN)                 :: PCODIL
    
    REAL(KIND=JPRB) :: ZPC2
    REAL(KIND=JPRB) :: ZHOOK_HANDLE
    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:MAP_FAC_S',0,ZHOOK_HANDLE)
    ZPC2  = PCODIL*PCODIL
    PMF = (2.0*PCODIL)/((1+ZPC2)+(1-ZPC2)* &
            (SIN(PT_COORD%LAT)*SIN(POLE%LAT)+COS(PT_COORD%LAT)*COS(POLE%LAT)*COS(PT_COORD%LON-POLE%LON)))      
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:MAP_FAC_S',1,ZHOOK_HANDLE)
   
  END FUNCTION MAP_FAC_S

  FUNCTION MAP_FAC_V (POLE,PCODIL,PT_COORD) RESULT (PMF)
    TYPE (LOLA), INTENT(IN)                 :: POLE
    TYPE (LOLA), DIMENSION(:), INTENT(IN)   :: PT_COORD
    REAL, INTENT(IN)                        :: PCODIL
    REAL, DIMENSION(SIZE(PT_COORD))         :: PMF

    REAL(KIND=JPRB), DIMENSION(SIZE(PT_COORD))         :: ZPC2
    REAL(KIND=JPRB) :: ZHOOK_HANDLE

    IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:MAP_FAC_V',0,ZHOOK_HANDLE)
    ZPC2  = PCODIL*PCODIL
    PMF = (2.0*PCODIL)/((1+ZPC2)+(1-ZPC2)* &
            (SIN(PT_COORD%LAT)*SIN(POLE%LAT)+COS(PT_COORD%LAT)*COS(POLE%LAT)*COS(PT_COORD%LON-POLE%LON)))      
  IF (LHOOK) CALL DR_HOOK('MODE_GEO_GAUSS:MAP_FAC_V',1,ZHOOK_HANDLE)

!    DO I=1,SIZE(PT_COORD)
!      PMF(I) = MAP_FAC(POLE,PCODIL,PT_COORD(I))
!    END DO    
    
  END FUNCTION MAP_FAC_V
END MODULE MODE_GEO_GAUSS
