!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
MODULE MODE_AV_PGD
!
USE MODD_SURF_PAR, ONLY : NUNDEF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
CONTAINS
!
SUBROUTINE DATE2DOY(TPDATA, OCOVER, KDOY)
USE MODD_TYPE_DATE_SURF
USE MODD_DATA_COVER_PAR, ONLY : NVEGTYPE
!
TYPE (DATE_TIME), DIMENSION(:,:), INTENT(IN) :: TPDATA
LOGICAL, DIMENSION(:), INTENT(IN) :: OCOVER
INTEGER, DIMENSION(:,:), INTENT(OUT) :: KDOY
INTEGER, DIMENSION(SIZE(OCOVER),NVEGTYPE) :: IMONTH, IDAY
INTEGER, PARAMETER, DIMENSION(12)     :: TAB=(/1,32,60,91,121,152,182,213,244,274,305,335/)
INTEGER :: JCOV, JJ, JVEG
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('MODE_AV_PGD:DATE2DOY',0,ZHOOK_HANDLE)
!
IMONTH(:,:) = TPDATA(:,:)%TDATE%MONTH
IDAY(:,:)   = TPDATA(:,:)%TDATE%DAY
!
KDOY(:,:)   = NUNDEF
!
JCOV = 0
DO JJ = 1, SIZE(OCOVER)
  IF (.NOT.OCOVER(JJ)) CYCLE
  JCOV = JCOV + 1
  DO JVEG = 1, NVEGTYPE
    IF (IMONTH(JJ,JVEG)/=NUNDEF .AND. IDAY(JJ,JVEG) /= NUNDEF) THEN
      KDOY(JCOV,JVEG) = TAB(IMONTH(JJ,JVEG)) + IDAY(JJ,JVEG) - 1
    ENDIF
  END DO
END DO
IF (LHOOK) CALL DR_HOOK('MODE_AV_PGD:DATE2DOY',1,ZHOOK_HANDLE)

END SUBROUTINE DATE2DOY
!
SUBROUTINE DOY2DATE(KDOY,KMONTH,KDAY)
!
INTEGER, INTENT(IN) :: KDOY
INTEGER, INTENT(OUT) :: KMONTH, KDAY
REAL    :: ZWORK(12)
INTEGER, PARAMETER, DIMENSION(12)     :: ZTAB=(/31.,59.,90.,120.,151.,181.,212.,243.,273.,304.,334.,365./)
INTEGER :: J
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('MODE_AV_PGD:DOY2DATE',0,ZHOOK_HANDLE)
!
KMONTH = NUNDEF
KDAY   = NUNDEF 
!
ZWORK(1) = REAL(KDOY) / ZTAB(1)
IF ( INT(ZWORK(1))==0  .AND. ZWORK(1)/=0.) THEN
  KMONTH = 1
  KDAY = KDOY
ENDIF
!
DO J = 2, 12
   ZWORK(J) = REAL(KDOY) / ZTAB(J)
   IF ( INT(ZWORK(J))==0 .AND. INT(ZWORK(J-1))==1 ) THEN
      KMONTH = J
      KDAY   = KDOY - INT(ZTAB(J-1))
   ENDIF
END DO 
IF (LHOOK) CALL DR_HOOK('MODE_AV_PGD:DOY2DATE',1,ZHOOK_HANDLE)

END SUBROUTINE DOY2DATE
!
SUBROUTINE GET_WEIGHT(DTCO,KCOVER,KMASK,HSFTYPE,PWEIGHT)
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
!
USE MODD_DATA_COVER,     ONLY : XDATA_BLD_HEIGHT
USE MODD_DATA_COVER_PAR, ONLY : NVT_TEBD, NVT_BONE, NVT_TRBE, NVT_TRBD, &
                                NVT_TEBE, NVT_TENE, NVT_BOBD, NVT_BOND, NVT_SHRB
!
USE MODI_ABOR1_SFX
!
IMPLICIT NONE
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
INTEGER, INTENT(IN) :: KCOVER
INTEGER, DIMENSION(:), INTENT(IN) :: KMASK
 CHARACTER(LEN=3),       INTENT(IN)  :: HSFTYPE 
REAL, DIMENSION(:), INTENT(OUT) :: PWEIGHT
!
INTEGER :: JCOV,JJ
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_AV_PGD:GET_WEIGHT',0,ZHOOK_HANDLE)
!
DO JCOV=1,KCOVER
  !
  JJ = KMASK(JCOV)
  !  
  !-------------------------------------------------------------------------------
  !
  !*    2.     Selection of the weighting function
  !            -----------------------------------
  !
  SELECT CASE (HSFTYPE)
    CASE('ALL')
      PWEIGHT(JCOV)=1.

    CASE('NAT')
      PWEIGHT(JCOV)=DTCO%XDATA_NATURE(JJ)

    CASE('GRD')
      PWEIGHT(JCOV)=DTCO%XDATA_TOWN (JJ) * DTCO%XDATA_GARDEN(JJ)

    CASE('TWN')
      PWEIGHT(JCOV)=DTCO%XDATA_TOWN  (JJ)

    CASE('WAT')
      PWEIGHT(JCOV)=DTCO%XDATA_WATER (JJ)

    CASE('SEA')
      PWEIGHT(JCOV)=DTCO%XDATA_SEA   (JJ)

    CASE('BLD')
      PWEIGHT(JCOV)=DTCO%XDATA_TOWN  (JJ) *        DTCO%XDATA_BLD(JJ)

    CASE('BLV')  !* building Volume
      PWEIGHT(JCOV)=DTCO%XDATA_TOWN  (JJ) *        DTCO%XDATA_BLD(JJ) &
                                      * XDATA_BLD_HEIGHT(JJ)

    CASE('STR')
      PWEIGHT(JCOV)=DTCO%XDATA_TOWN  (JJ) * ( 1. - DTCO%XDATA_BLD(JJ) )

    CASE('TRE')
      PWEIGHT(JCOV)=DTCO%XDATA_NATURE(JJ) * (  DTCO%XDATA_VEGTYPE(JJ,NVT_TEBD) &
                                       + DTCO%XDATA_VEGTYPE(JJ,NVT_TRBE) &
                                       + DTCO%XDATA_VEGTYPE(JJ,NVT_TRBD) &
                                       + DTCO%XDATA_VEGTYPE(JJ,NVT_TEBE) &
                                       + DTCO%XDATA_VEGTYPE(JJ,NVT_TENE) &
                                       + DTCO%XDATA_VEGTYPE(JJ,NVT_BOBD) &
                                       + DTCO%XDATA_VEGTYPE(JJ,NVT_BOND) &
                                       + DTCO%XDATA_VEGTYPE(JJ,NVT_SHRB) &
                                       + DTCO%XDATA_VEGTYPE(JJ,NVT_BONE) )  

    CASE('GRT')
      PWEIGHT(JCOV)=DTCO%XDATA_TOWN(JJ) * DTCO%XDATA_GARDEN(JJ) &
                         * (  DTCO%XDATA_VEGTYPE(JJ,NVT_TEBD) &
                            + DTCO%XDATA_VEGTYPE(JJ,NVT_TRBE) &
                            + DTCO%XDATA_VEGTYPE(JJ,NVT_TRBD) &
                            + DTCO%XDATA_VEGTYPE(JJ,NVT_TEBE) &
                            + DTCO%XDATA_VEGTYPE(JJ,NVT_TENE) &
                            + DTCO%XDATA_VEGTYPE(JJ,NVT_BOBD) &
                            + DTCO%XDATA_VEGTYPE(JJ,NVT_BOND) &
                            + DTCO%XDATA_VEGTYPE(JJ,NVT_SHRB) &
                            + DTCO%XDATA_VEGTYPE(JJ,NVT_BONE) )  

    CASE DEFAULT
      CALL ABOR1_SFX('AV_1PGD_1D: WEIGHTING FUNCTION NOT ALLOWED '//HSFTYPE)
  END SELECT
!
ENDDO
!
IF (LHOOK) CALL DR_HOOK('MODE_AV_PGD:GET_WEIGHT',1,ZHOOK_HANDLE)
!
END SUBROUTINE GET_WEIGHT
!
SUBROUTINE GET_WEIGHT_PATCH(DTCO,KCOVER,KMASK,KDECADE,HSFTYPE,PWEIGHT)
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
!
USE MODD_DATA_COVER,     ONLY : XDATA_VEG, XDATA_LAI
USE MODD_DATA_COVER_PAR, ONLY : NVT_TEBD, NVT_BONE, NVT_TRBE, NVT_TRBD, &
                                NVT_TEBE, NVT_TENE, NVT_BOBD, NVT_BOND, NVT_SHRB, &
                                NVEGTYPE
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_ABOR1_SFX
!
IMPLICIT NONE
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
INTEGER, INTENT(IN) :: KCOVER
INTEGER, DIMENSION(:), INTENT(IN) :: KMASK
INTEGER, INTEnt(IN) :: KDECADE
 CHARACTER(LEN=3),       INTENT(IN)  :: HSFTYPE 
REAL, DIMENSION(:,:), INTENT(OUT) :: PWEIGHT
!
INTEGER :: JCOV,JJ, JVEG
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODE_AV_PGD:GET_WEIGHT_PATCH',0,ZHOOK_HANDLE)
!
IF (.NOT.ASSOCIATED(DTCO%XDATA_WEIGHT)) THEN
  !
  ALLOCATE(DTCO%XDATA_WEIGHT(KCOVER,NVEGTYPE,12))
  DTCO%XDATA_WEIGHT(:,:,:) = 0.
  !
  DO JCOV=1,KCOVER
    !
    JJ = KMASK(JCOV)
    !
    DO JVEG=1,NVEGTYPE
      !  CASE('NAT')
      IF (DTCO%XDATA_VEGTYPE(JJ,JVEG)==0.) CYCLE
      !  
      DTCO%XDATA_WEIGHT(JCOV,JVEG,1)= DTCO%XDATA_NATURE(JJ) * DTCO%XDATA_VEGTYPE(JJ,JVEG)
      !CASE('GRD')
      DTCO%XDATA_WEIGHT(JCOV,JVEG,2)= DTCO%XDATA_TOWN(JJ)*DTCO%XDATA_GARDEN(JJ) * DTCO%XDATA_VEGTYPE(JJ,JVEG)
      !CASE('VEG')     
      DTCO%XDATA_WEIGHT(JCOV,JVEG,3)= DTCO%XDATA_WEIGHT(JCOV,JVEG,1) * XDATA_VEG(JJ,KDECADE,JVEG)
      !CASE('BAR')               
      DTCO%XDATA_WEIGHT(JCOV,JVEG,4)= DTCO%XDATA_WEIGHT(JCOV,JVEG,1) * (1.-XDATA_VEG(JJ,KDECADE,JVEG))
      !CASE('GRV')              
      DTCO%XDATA_WEIGHT(JCOV,JVEG,5)= DTCO%XDATA_WEIGHT(JCOV,JVEG,2) * XDATA_VEG(JJ,KDECADE,JVEG)
      !CASE('GRB')            
      DTCO%XDATA_WEIGHT(JCOV,JVEG,6)= DTCO%XDATA_WEIGHT(JCOV,JVEG,2) * (1.-XDATA_VEG(JJ,KDECADE,JVEG))
      IF ( SUM(XDATA_LAI(JJ,:,JVEG)) .GT. 0.0) THEN
        !CASE('DVG') ! for diffusion scheme only 
        DTCO%XDATA_WEIGHT(JCOV,JVEG,7)= DTCO%XDATA_WEIGHT(JCOV,JVEG,1)
        !CASE('GDV') ! for diffusion scheme only            
        DTCO%XDATA_WEIGHT(JCOV,JVEG,8)= DTCO%XDATA_WEIGHT(JCOV,JVEG,2)
      ENDIF       
      !CASE('LAI')           
      DTCO%XDATA_WEIGHT(JCOV,JVEG,9)= DTCO%XDATA_WEIGHT(JCOV,JVEG,1) * XDATA_LAI(JJ,KDECADE,JVEG)
      !CASE('GRL')           
      DTCO%XDATA_WEIGHT(JCOV,JVEG,10)= DTCO%XDATA_WEIGHT(JCOV,JVEG,2) * XDATA_LAI(JJ,KDECADE,JVEG)
      !
      !Tree vegtype
      !
      !CASE('TRE')  
      !CASE('GRT')
      IF (JVEG==NVT_TEBD) THEN
        DTCO%XDATA_WEIGHT(JCOV,NVT_TEBD,11)= DTCO%XDATA_WEIGHT(JCOV,NVT_TEBD,1)
        DTCO%XDATA_WEIGHT(JCOV,NVT_TEBD,12)= DTCO%XDATA_WEIGHT(JCOV,NVT_TEBD,2)
      ENDIF
      IF (JVEG==NVT_BONE) THEN
        DTCO%XDATA_WEIGHT(JCOV,NVT_BONE,11)= DTCO%XDATA_WEIGHT(JCOV,NVT_BONE,1)
        DTCO%XDATA_WEIGHT(JCOV,NVT_BONE,12)= DTCO%XDATA_WEIGHT(JCOV,NVT_BONE,2)
      ENDIF
      IF (JVEG==NVT_TRBE) THEN
        DTCO%XDATA_WEIGHT(JCOV,NVT_TRBE,11)= DTCO%XDATA_WEIGHT(JCOV,NVT_TRBE,1)
        DTCO%XDATA_WEIGHT(JCOV,NVT_TRBE,12)= DTCO%XDATA_WEIGHT(JCOV,NVT_TRBE,2)
      ENDIF
      IF (JVEG==NVT_TRBD) THEN
        DTCO%XDATA_WEIGHT(JCOV,NVT_TRBD,11)= DTCO%XDATA_WEIGHT(JCOV,NVT_TRBD,1)
        DTCO%XDATA_WEIGHT(JCOV,NVT_TRBD,12)= DTCO%XDATA_WEIGHT(JCOV,NVT_TRBD,2)
      ENDIF
      IF (JVEG==NVT_TEBE) THEN
        DTCO%XDATA_WEIGHT(JCOV,NVT_TEBE,11)= DTCO%XDATA_WEIGHT(JCOV,NVT_TEBE,1)
        DTCO%XDATA_WEIGHT(JCOV,NVT_TEBE,12)= DTCO%XDATA_WEIGHT(JCOV,NVT_TEBE,2)
      ENDIF
      IF (JVEG==NVT_TENE) THEN
        DTCO%XDATA_WEIGHT(JCOV,NVT_TENE,11)= DTCO%XDATA_WEIGHT(JCOV,NVT_TENE,1)
        DTCO%XDATA_WEIGHT(JCOV,NVT_TENE,12)= DTCO%XDATA_WEIGHT(JCOV,NVT_TENE,2)
      ENDIF
      IF (JVEG==NVT_BOBD) THEN
        DTCO%XDATA_WEIGHT(JCOV,NVT_BOBD,11)= DTCO%XDATA_WEIGHT(JCOV,NVT_BOBD,1)
        DTCO%XDATA_WEIGHT(JCOV,NVT_BOBD,12)= DTCO%XDATA_WEIGHT(JCOV,NVT_BOBD,2)
      ENDIF
      IF (JVEG==NVT_BOND) THEN
        DTCO%XDATA_WEIGHT(JCOV,NVT_BOND,11)= DTCO%XDATA_WEIGHT(JCOV,NVT_BOND,1)
        DTCO%XDATA_WEIGHT(JCOV,NVT_BOND,12)= DTCO%XDATA_WEIGHT(JCOV,NVT_BOND,2)
      ENDIF
      IF (JVEG==NVT_SHRB) THEN
        DTCO%XDATA_WEIGHT(JCOV,NVT_SHRB,11)= DTCO%XDATA_WEIGHT(JCOV,NVT_SHRB,1)
        DTCO%XDATA_WEIGHT(JCOV,NVT_SHRB,12)= DTCO%XDATA_WEIGHT(JCOV,NVT_SHRB,2)
      ENDIF   
      !
    ENDDO      
    !
  ENDDO
  !
ENDIF
!
SELECT CASE (HSFTYPE)
  CASE('NAT')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,1)
  CASE('GRD')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,2)
  CASE('VEG')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,3)
  CASE('BAR')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,4)
  CASE('GRV')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,5)
  CASE('GRB')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,6)
  CASE('DVG')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,7)   
  CASE('GDV')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,8)   
  CASE('LAI')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,9)
  CASE('GRL')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,10)  
  CASE('TRE')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,11) 
  CASE('GRT')
    PWEIGHT(:,:) = DTCO%XDATA_WEIGHT(:,:,12)    
  CASE DEFAULT
     CALL ABOR1_SFX('AV_1PATCH_PGD_1D: WEIGHTING FUNCTION FOR VEGTYPE NOT ALLOWED')
END SELECT
!
IF (LHOOK) CALL DR_HOOK('MODE_AV_PGD:GET_WEIGHT_PATCH',1,ZHOOK_HANDLE)
!
END SUBROUTINE GET_WEIGHT_PATCH
!
      END MODULE MODE_AV_PGD
