!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
MODULE MODI_GATHER_AND_WRITE_MPI_K4
!----------------------------------------------------
!!    MODIFICATIONS
!!    -------------
!!      Original       
!!      J.Escobar      10/06/2013: replace DOUBLE PRECISION by REAL to handle problem for promotion of real on IBM SP
!----------------------------------------------------
!
INTERFACE GATHER_AND_WRITE_MPI_K4
!
SUBROUTINE GATHER_AND_WRITE_MPI_X1D0(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL, DIMENSION(:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X1D0
!
SUBROUTINE GATHER_AND_WRITE_MPI_X2D0(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X2D0
!
SUBROUTINE GATHER_AND_WRITE_MPI_X3D0(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:,:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X3D0
!
END INTERFACE
!
END MODULE MODI_GATHER_AND_WRITE_MPI_K4
!
!**************************************************************************
!
SUBROUTINE GATHER_AND_WRITE_MPI_X1D0(PWORK,PWORK2,KMASK)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_COMM_WRITE, XTIME_CALC_WRITE, &
                            IDX_W, WLOG_MPI
!
USE MODD_SURF_PAR, ONLY : XUNDEF
!
USE MODI_UNPACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL, DIMENSION(:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
REAL, DIMENSION(NSIZE) :: ZINTER
REAL, DIMENSION(NSIZE) :: ZWORK
REAL   :: XTIME0
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: ICPT
INTEGER :: I,J, IP1, IS1
INTEGER :: INFOMPI
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE, ZHOOK_HANDLE_OMP
!
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X1D0',0,ZHOOK_HANDLE)
!
ZWORK(:) = XUNDEF
!
#ifdef SFX_MPI
XTIME0 = MPI_WTIME()
#endif
!
IF (SIZE(PWORK)>0) THEN
  IF (PRESENT(KMASK)) THEN
    CALL UNPACK_SAME_RANK(KMASK,PWORK,ZWORK(:))
  ELSE
    ZWORK(1:SIZE(PWORK)) = PWORK(:)
  ENDIF
ENDIF
!
#ifdef SFX_MPI
XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
!
XTIME0 = MPI_WTIME()
#endif
!
IF (NRANK/=NPIO) THEN
  !
  IDX_W = IDX_W + 1
  !
#ifdef SFX_MPI
  XTIME0 = MPI_WTIME()
  CALL MPI_SEND(ZWORK,SIZE(ZWORK)*KIND(ZWORK)/4,MPI_REAL,NPIO,IDX_W,NCOMM,INFOMPI)
  XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
#endif
  !
ELSE
  !
  PWORK2(:) = 0.
  !    
  IDX_W = IDX_W + 1
  !
  DO I=0,NPROC-1  
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    IF (I/=NPIO) THEN
#ifdef SFX_MPI
      CALL MPI_RECV(ZINTER,SIZE(ZINTER)*KIND(ZINTER)/4,MPI_REAL,I,IDX_W,NCOMM,ISTATUS,INFOMPI)
#endif
    ELSE
      ZINTER(:) = ZWORK(:)
    ENDIF
    !
#ifdef SFX_MPI
    XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
    !
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==I ) THEN
        ICPT = ICPT + 1
        PWORK2(J) = ZINTER(ICPT)
      ENDIF
      !
    ENDDO
    !
#ifdef SFX_MPI
    XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
#endif
    !
  ENDDO
  !
ENDIF
!

IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X1D0',1,ZHOOK_HANDLE)
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X1D0
!
!**************************************************************************
!
SUBROUTINE GATHER_AND_WRITE_MPI_X2D0(PWORK,PWORK2,KMASK)
!
USE MODD_SURF_PAR, ONLY : XUNDEF
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_COMM_WRITE,  &
                            XTIME_CALC_WRITE, IDX_W, WLOG_MPI
!
USE MODI_UNPACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
REAL, DIMENSION(NSIZE,SIZE(PWORK2,2)) :: ZINTER
REAL, DIMENSION(NSIZE,SIZE(PWORK,2)) :: ZWORK
REAL:: XTIME0
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: ICPT, IX2, IS1, IS2, IP1, IP2
INTEGER :: I,J
INTEGER :: INFOMPI
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE, ZHOOK_HANDLE_OMP
!
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X2D0',0,ZHOOK_HANDLE)
!
ZWORK(:,:) = XUNDEF
!
#ifdef SFX_MPI
XTIME0 = MPI_WTIME()
#endif
!
IF (SIZE(PWORK,1)>0) THEN
  IF (PRESENT(KMASK)) THEN
    CALL UNPACK_SAME_RANK(KMASK,PWORK,ZWORK(:,:))
  ELSE
    ZWORK(1:SIZE(PWORK,1),:) = PWORK(:,:)
  ENDIF
ENDIF
!
#ifdef SFX_MPI
XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
!
XTIME0 = MPI_WTIME()
#endif
!
IF (NRANK/=NPIO) THEN
  !
  IDX_W = IDX_W + 1
  !
#ifdef SFX_MPI
  XTIME0 = MPI_WTIME()
  CALL MPI_SEND(ZWORK(:,:),SIZE(ZWORK)*KIND(ZWORK)/4,MPI_REAL,NPIO,IDX_W,NCOMM,INFOMPI)
  XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
#endif
  !
ELSEIF (NPROC>1) THEN
  !
  PWORK2(:,:) = 0.
  !
  IDX_W = IDX_W + 1
  !  
!!$OMP PARALLEL DO PRIVATE(I,ZINTER,ICPT,J,ISTATUS,INFOMPI,ZHOOK_HANDLE_OMP)  
  DO I=0,NPROC-1
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    IF (I/=NPIO) THEN
#ifdef SFX_MPI
      CALL MPI_RECV(ZINTER,SIZE(ZINTER)*KIND(ZINTER)/4,MPI_REAL,I,IDX_W,NCOMM,ISTATUS,INFOMPI)
#endif
    ELSE
      ZINTER(:,:) = ZWORK(:,:)
    ENDIF
!    !
#ifdef SFX_MPI
    XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
    !
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==I ) THEN
        ICPT = ICPT + 1
        PWORK2(J,:) = ZINTER(ICPT,:)
      ENDIF
      !
    ENDDO
     !
#ifdef SFX_MPI
    XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
#endif
     !
  ENDDO
!!$OMP END PARALLEL DO
  !
ELSE
  !
  PWORK2(:,:) = ZWORK(:,:)
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X2D0',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X2D0
!
!**************************************************************************
!
SUBROUTINE GATHER_AND_WRITE_MPI_X3D0(PWORK,PWORK2,KMASK)
!
USE MODD_SURF_PAR, ONLY : XUNDEF
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_COMM_WRITE,  &
                            XTIME_CALC_WRITE, IDX_W, WLOG_MPI
!
USE MODI_UNPACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:,:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
REAL, DIMENSION(NSIZE,SIZE(PWORK2,2),SIZE(PWORK2,3)) :: ZINTER
REAL, DIMENSION(NSIZE,SIZE(PWORK,2),SIZE(PWORK,3)) :: ZWORK
DOUBLE PRECISION   :: XTIME0
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: ICPT, IX2, IS1, IS2, IP1, IP2
INTEGER :: I,J
INTEGER :: INFOMPI
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE, ZHOOK_HANDLE_OMP
!
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_1',0,ZHOOK_HANDLE)
!
ZWORK(:,:,:) = XUNDEF
!
#ifdef SFX_MPI
XTIME0 = MPI_WTIME()
#endif
!
IF (SIZE(PWORK,1)>0) THEN
  IF (PRESENT(KMASK)) THEN
    CALL UNPACK_SAME_RANK(KMASK,PWORK(:,:,:),ZWORK(:,:,:))
  ELSE
    ZWORK(1:SIZE(PWORK,1),:,:) = PWORK(:,:,:)
  ENDIF
ENDIF
!
#ifdef SFX_MPI
XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
!
XTIME0 = MPI_WTIME()
#endif
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_1',1,ZHOOK_HANDLE)
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_2',0,ZHOOK_HANDLE)

IF (NRANK/=NPIO) THEN
  !
  !  
  IDX_W = IDX_W + 1
  !
#ifdef SFX_MPI
  XTIME0 = MPI_WTIME()
  CALL MPI_SEND(ZWORK(:,:,:),SIZE(ZWORK)*KIND(ZWORK)/4,MPI_REAL,NPIO,IDX_W,NCOMM,INFOMPI)
  XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
#endif
  !
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_2',1,ZHOOK_HANDLE)
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_5',0,ZHOOK_HANDLE)
  !
ELSEIF (NPROC>1) THEN
  !
  PWORK2(:,:,:) = 0.
  !
  IDX_W = IDX_W + 1
  !
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_2',1,ZHOOK_HANDLE)

!!$OMP PARALLEL DO PRIVATE(I,ZINTER,ICPT,J,INFOMPI,ISTATUS,ZHOOK_HANDLE_OMP)
  DO I=0,NPROC-1
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_3',0,ZHOOK_HANDLE_OMP)
    !
#ifdef SFX_MPI   
    XTIME0 = MPI_WTIME()
#endif    
    !
    IF (I/=NPIO) THEN
#ifdef SFX_MPI
      CALL MPI_RECV(ZINTER,SIZE(ZINTER)*KIND(ZINTER)/4,MPI_REAL,I,IDX_W,NCOMM,ISTATUS,INFOMPI)
#endif
    ELSE
      ZINTER(:,:,:) = ZWORK(:,:,:)
    ENDIF
!    !
#ifdef SFX_MPI    
    XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
    !
    XTIME0 = MPI_WTIME()
#endif     
    !    
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_3',1,ZHOOK_HANDLE_OMP)
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_4',0,ZHOOK_HANDLE_OMP)

    ICPT = 0
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==I ) THEN
        ICPT = ICPT + 1
        PWORK2(J,:,:) = ZINTER(ICPT,:,:)
      ENDIF
      !
    ENDDO
     !
#ifdef SFX_MPI    
    XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
#endif      
     ! 
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_4',1,ZHOOK_HANDLE_OMP)
  ENDDO
!!$OMP END PARALLEL DO
  !
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_5',0,ZHOOK_HANDLE)
  !
ELSE
  PWORK2(:,:,:) = ZWORK(:,:,:)
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_2',1,ZHOOK_HANDLE)
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_5',0,ZHOOK_HANDLE)

ENDIF
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X3D0_5',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X3D0
!
!**************************************************************************
