!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
SUBROUTINE EXTRAPOL_FIELDS (DTCO, DTV, KDIM, IO, S, UG, U, HPROGRAM,KLUOUT)
!!
!!    PURPOSE
!!    -------
!!  parameters defined by cover need to be extrapolated if LDATA_ISBATYPE and NOT LDATA_"PARAM"
!!  all ten-day periods are calculated one time for all, then written in PGD.txt
!!
!!    METHOD
!!    ------ 
!!  these parameters are: LAI, HT, DG, ROOTFRAC, IRRIG, WATSUP
!!  Parameters are calculated as in ecoclimap, by vegtype, and then extrapolated
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    S. Faroux        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    16/11/10
!!    R. Alkama     04/12 : add 6 new tree vegtype (9 instead 3)
!!
!!    DECLARATIONS
!!
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
USE MODD_ISBA_n, ONLY : ISBA_S_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_TYPE_DATE_SURF
USE MODD_AGRI,        ONLY : LAGRIP
USE MODD_TREEDRAG,       ONLY : LTREEDRAG
!
USE MODD_SURF_PAR,       ONLY : XUNDEF
!
USE MODD_REPROD_OPER,    ONLY : CDGDIF, CDGAVG
!
USE MODD_DATA_COVER_PAR, ONLY : NVEGTYPE, NVT_NO, NVT_ROCK, NVT_SNOW, JPCOVER
!
USE MODD_DATA_COVER,     ONLY : XDATA_LAI, XDATA_H_TREE,                      &
                                XDATA_IRRIG, XDATA_WATSUP,                    &
                                XDATA_GARDEN, XDATA_NATURE,                   &
                                XDATA_ROOT_DEPTH,XDATA_GROUND_DEPTH,          &
                                XDATA_ROOT_EXTINCTION, XDATA_ROOT_LIN,        &
                                TDATA_SEED, TDATA_REAP, XDATA_ALB_VEG_NIR,    &
                                XDATA_ALB_VEG_VIS, XDATA_ALB_SOIL_NIR,        &
                                XDATA_ALB_SOIL_VIS                       
!
USE MODI_AV_PGD
USE MODI_INI_VAR_FROM_VEGTYPE_DATA
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTV
INTEGER, INTENT(IN) :: KDIM
TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
TYPE(ISBA_S_t), INTENT(INOUT) :: S
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!
 CHARACTER(LEN=6),       INTENT(IN)    :: HPROGRAM  ! host program
INTEGER,                INTENT(IN)    :: KLUOUT
!
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
TYPE(DATE_TIME), DIMENSION(:,:), ALLOCATABLE :: TPWORK
REAL, DIMENSION (SIZE(XDATA_GROUND_DEPTH,1),NVEGTYPE) :: ZDATA_GROUND_DEPTH
!
CHARACTER(LEN=3)  :: YTREE, YNAT, YVEG, YDIF, YROOT, YBAR
REAL, DIMENSION(KDIM,36,NVEGTYPE) :: ZWORK
REAL, DIMENSION(NVEGTYPE) :: ZDEF
REAL :: ZFRAC
INTEGER :: JTIME, JVEGTYPE, JCOVER
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!----------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('EXTRAPOL_FIELDS',0,ZHOOK_HANDLE)
!
YNAT ='NAT'
YTREE='TRE'
YVEG ='VEG'
YDIF ='DVG'
YBAR='BAR'
!
!            2. Extrapolations for land use or user
!            --------------------------------------
!
!   LAI
!   ---
IF (.NOT.ANY(DTV%LDATA_LAI).AND.IO%CPHOTO/='NIT'.AND.IO%CPHOTO/='NCB') THEN
!
  ALLOCATE(DTV%XPAR_LAI      (KDIM,DTV%NTIME,NVEGTYPE))
  DO JTIME=1,36
!    
!   ECOCLIMAP spatial distribution field
    IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)
    CALL AV_PGD(DTCO,ZWORK(:,JTIME,:),S%XCOVER,XDATA_LAI(:,JTIME,:),YVEG,'ARI',S%LCOVER,KDECADE=JTIME)
    DO JVEGTYPE=1,3
      WHERE (DTV%XPAR_VEGTYPE(:,JVEGTYPE)/=0.) ZWORK(:,JTIME,JVEGTYPE) = 0.
    ENDDO
    !
    ZDEF(:) = XUNDEF
    DO JVEGTYPE=1,NVEGTYPE
      IF (ANY(DTV%XPAR_VEGTYPE(:,JVEGTYPE)/=0.) .AND. ALL(ZWORK(:,JTIME,JVEGTYPE)==XUNDEF)) THEN
        ZFRAC = 0.
        DO JCOVER = 1,JPCOVER
          IF (DTCO%XDATA_VEGTYPE(JCOVER,JVEGTYPE)>ZFRAC) THEN
            ZDEF(JVEGTYPE) = XDATA_LAI(JCOVER,JTIME,JVEGTYPE)
            ZFRAC = DTCO%XDATA_VEGTYPE(JCOVER,JVEGTYPE)
            IF (ZFRAC==1.) EXIT
          ENDIF
        ENDDO
      ENDIF
    ENDDO
    !    
!   Extrapolation toward new vegtype distribution field from updated land-use map or user 
    CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                   HPROGRAM,KLUOUT,'LAI: leaf area index',ZWORK(:,JTIME,:),PDEF=ZDEF)
!    
  ENDDO
!
  CALL GOTO_NTIME(DTV%NTIME,ZWORK,DTV%XPAR_LAI)
!
  DTV%LDATA_LAI(:)=.TRUE.
!  
ENDIF
!
!   H_TREE
!   ------
IF (.NOT.ANY(DTV%LDATA_H_TREE) .AND. ((IO%CPHOTO/='NON'.OR.LTREEDRAG) .OR. .NOT.ANY(DTV%LDATA_Z0))) THEN
!
  ALLOCATE(DTV%XPAR_H_TREE      (KDIM,NVEGTYPE))
  ZDEF(:)=1.
  ZDEF(4:6)=10.
  ZDEF(13:17)=10.
  ZDEF(19)=1.
!
! ECOCLIMAP spatial distribution field  
  IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)
  CALL AV_PGD(DTCO,DTV%XPAR_H_TREE,S%XCOVER,XDATA_H_TREE,YTREE,'ARI',S%LCOVER,KDECADE=1)
!
! Extrapolation toward new vegtype distribution field from updated land-use map or user  
  CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                   HPROGRAM,KLUOUT,'H_TREE: height of trees',DTV%XPAR_H_TREE,PDEF=ZDEF)
!  
  DTV%LDATA_H_TREE(:)=.TRUE.
!  
ENDIF
!
!   DG
!   --
!
!ROOT_DEPTH is needed for DIF, 2-L, 3-L 
IF (.NOT.ANY(DTV%LDATA_DG) .AND. .NOT.ANY(DTV%LDATA_ROOT_DEPTH)) THEN
  YROOT=YNAT
  IF(IO%CISBA=='DIF')YROOT=YDIF
  ALLOCATE(DTV%XPAR_ROOT_DEPTH    (KDIM,NVEGTYPE))
  IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)        
  CALL AV_PGD(DTCO,DTV%XPAR_ROOT_DEPTH(:,:),S%XCOVER,XDATA_ROOT_DEPTH(:,:),YNAT,CDGAVG,S%LCOVER,KDECADE=1)

  ZDEF(:) = XUNDEF
  DO JVEGTYPE=1,NVEGTYPE
    IF (ANY(DTV%XPAR_VEGTYPE(:,JVEGTYPE)/=0.) .AND. ALL(DTV%XPAR_ROOT_DEPTH(:,JVEGTYPE)==XUNDEF)) THEN
      ZFRAC = 0.
      DO JCOVER = 1,JPCOVER
        IF (DTCO%XDATA_VEGTYPE(JCOVER,JVEGTYPE)>ZFRAC) THEN
          ZDEF(JVEGTYPE) = XDATA_ROOT_DEPTH(JCOVER,JVEGTYPE)
          ZFRAC = DTCO%XDATA_VEGTYPE(JCOVER,JVEGTYPE)
          IF (ZFRAC==1.) EXIT
        ENDIF
      ENDDO
    ENDIF
  ENDDO

  CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                   HPROGRAM,KLUOUT,'ROOTDEPTH', DTV%XPAR_ROOT_DEPTH(:,:),PDEF=ZDEF)
  DTV%LDATA_ROOT_DEPTH(:) = .TRUE.
ENDIF
!
!GROUND_DEPTH is needed for DIF and 3-L
IF (.NOT.ANY(DTV%LDATA_DG) .AND. IO%CISBA/='2-L' .AND. .NOT.ANY(DTV%LDATA_GROUND_DEPTH)) THEN
  ZDATA_GROUND_DEPTH(:,:)=XDATA_GROUND_DEPTH(:,:)
  IF(IO%CISBA=='DIF'.AND.CDGDIF=='ROOT')THEN
    DO JVEGTYPE=1,NVEGTYPE
       IF(JVEGTYPE==NVT_NO)THEN
          WHERE(XDATA_GROUND_DEPTH(:,JVEGTYPE)/=XUNDEF)
               ZDATA_GROUND_DEPTH(:,JVEGTYPE) = MIN(1.0,XDATA_GROUND_DEPTH(:,JVEGTYPE))
          ENDWHERE
       ELSEIF(JVEGTYPE/=NVT_ROCK.AND.JVEGTYPE/=NVT_SNOW)THEN
         ZDATA_GROUND_DEPTH(:,JVEGTYPE) = MAX(1.0,XDATA_ROOT_DEPTH(:,JVEGTYPE))
       ELSE
         ZDATA_GROUND_DEPTH(:,JVEGTYPE) = XDATA_ROOT_DEPTH(:,JVEGTYPE)
 ENDIF
     ENDDO
  ENDIF
  ALLOCATE(DTV%XPAR_GROUND_DEPTH    (KDIM,NVEGTYPE))
  IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)      
  CALL AV_PGD(DTCO,DTV%XPAR_GROUND_DEPTH(:,:),S%XCOVER,ZDATA_GROUND_DEPTH(:,:),YNAT,CDGAVG,S%LCOVER,KDECADE=1)

  ZDEF(:) = XUNDEF
  DO JVEGTYPE=1,NVEGTYPE
    IF (ANY(DTV%XPAR_VEGTYPE(:,JVEGTYPE)/=0.) .AND. ALL(DTV%XPAR_GROUND_DEPTH(:,JVEGTYPE)==XUNDEF)) THEN
      ZFRAC = 0.
      DO JCOVER = 1,JPCOVER
        IF (DTCO%XDATA_VEGTYPE(JCOVER,JVEGTYPE)>ZFRAC) THEN
          ZDEF(JVEGTYPE) = XDATA_GROUND_DEPTH(JCOVER,JVEGTYPE)
          ZFRAC = DTCO%XDATA_VEGTYPE(JCOVER,JVEGTYPE)
          IF (ZFRAC==1.) EXIT
        ENDIF
      ENDDO
    ENDIF
  ENDDO

  CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                   HPROGRAM,KLUOUT,'GROUNDDEPTH', DTV%XPAR_GROUND_DEPTH(:,:),PDEF=ZDEF)
  DTV%LDATA_GROUND_DEPTH(:) = .TRUE.
ENDIF
!
IF (IO%CALBEDO=='CM13') THEN
!
  IF (.NOT.ANY(DTV%LDATA_ALBNIR_VEG)) THEN
    ALLOCATE(DTV%XPAR_ALBNIR_VEG(KDIM,DTV%NTIME,NVEGTYPE))
    DO JTIME=1,36 
!     ECOCLIMAP spatial distribution field
      IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)
      CALL AV_PGD(DTCO,ZWORK(:,JTIME,:),S%XCOVER,XDATA_ALB_VEG_NIR(:,JTIME,:),YVEG,'ARI',S%LCOVER,KDECADE=JTIME)
 
!     Extrapolation toward new vegtype distribution field from updated land-use map or user 
      CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                     HPROGRAM,KLUOUT,'ALBNIR_VEG',ZWORK(:,JTIME,:),PDEF=ZDEF)
    ENDDO
    CALL GOTO_NTIME(DTV%NTIME,ZWORK,DTV%XPAR_ALBNIR_VEG)
    DTV%LDATA_ALBNIR_VEG(:)=.TRUE.
  ENDIF
!
  IF (.NOT.ANY(DTV%LDATA_ALBVIS_VEG)) THEN
    ALLOCATE(DTV%XPAR_ALBVIS_VEG(KDIM,DTV%NTIME,NVEGTYPE))
    DO JTIME=1,36 
!     ECOCLIMAP spatial distribution field
      IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)
      CALL AV_PGD(DTCO,ZWORK(:,JTIME,:),S%XCOVER,XDATA_ALB_VEG_VIS(:,JTIME,:),YVEG,'ARI',S%LCOVER,KDECADE=JTIME)
 
!     Extrapolation toward new vegtype distribution field from updated land-use map or user 
      CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                     HPROGRAM,KLUOUT,'ALBVIS_VEG',ZWORK(:,JTIME,:),PDEF=ZDEF)
    ENDDO
    CALL GOTO_NTIME(DTV%NTIME,ZWORK,DTV%XPAR_ALBVIS_VEG)
    DTV%LDATA_ALBVIS_VEG(:)=.TRUE.
  ENDIF
!
  IF (.NOT.ANY(DTV%LDATA_ALBNIR_SOIL)) THEN
    ALLOCATE(DTV%XPAR_ALBNIR_SOIL(KDIM,DTV%NTIME,NVEGTYPE))
    DO JTIME=1,36 
!     ECOCLIMAP spatial distribution field
      IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)
      CALL AV_PGD(DTCO,ZWORK(:,JTIME,:),S%XCOVER,XDATA_ALB_SOIL_NIR(:,JTIME,:),YBAR,'ARI',S%LCOVER,KDECADE=JTIME)
 
!     Extrapolation toward new vegtype distribution field from updated land-use map or user 
      CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                     HPROGRAM,KLUOUT,'ALBNIR_SOIL',ZWORK(:,JTIME,:),PDEF=ZDEF)
    ENDDO
    CALL GOTO_NTIME(DTV%NTIME,ZWORK,DTV%XPAR_ALBNIR_SOIL)
    DTV%LDATA_ALBNIR_SOIL(:)=.TRUE.
  ENDIF
!
  IF (.NOT.ANY(DTV%LDATA_ALBVIS_SOIL)) THEN
    ALLOCATE(DTV%XPAR_ALBVIS_SOIL(KDIM,DTV%NTIME,NVEGTYPE))
    DO JTIME=1,36 
!     ECOCLIMAP spatial distribution field
      IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)
      CALL AV_PGD(DTCO,ZWORK(:,JTIME,:),S%XCOVER,XDATA_ALB_SOIL_VIS(:,JTIME,:),YBAR,'ARI',S%LCOVER,KDECADE=JTIME)
 
!     Extrapolation toward new vegtype distribution field from updated land-use map or user 
      CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                     HPROGRAM,KLUOUT,'ALBVIS_SOIL',ZWORK(:,JTIME,:),PDEF=ZDEF)
    ENDDO
    CALL GOTO_NTIME(DTV%NTIME,ZWORK,DTV%XPAR_ALBVIS_SOIL)
    DTV%LDATA_ALBVIS_SOIL(:)=.TRUE.
  ENDIF
!
ENDIF
!
IF(IO%CPHOTO=='NIT' .OR. IO%CPHOTO=='NCB') THEN
  !      
  IF (LAGRIP) THEN
    !
    !  IRRIG
    !  -----
    IF (.NOT.ANY(DTV%LDATA_IRRIG)) THEN
      ZDEF(:)=0.
      ALLOCATE(DTV%XPAR_IRRIG       (KDIM,DTV%NTIME,NVEGTYPE))
      DO JTIME=1,36
        !   ECOCLIMAP spatial distribution field      
        IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)
        CALL AV_PGD(DTCO,ZWORK(:,JTIME,:),S%XCOVER,XDATA_IRRIG,YVEG,'ARI',S%LCOVER,KDECADE=JTIME)
        !   Extrapolation toward new vegtype distribution field from updated land-use map or user  
        CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                       HPROGRAM,KLUOUT,'IRRIG  ', ZWORK(:,JTIME,:), PDEF=ZDEF)
      ENDDO
      !
      CALL GOTO_NTIME(DTV%NTIME,ZWORK,DTV%XPAR_IRRIG)
      !
      DTV%LDATA_IRRIG(:)=.TRUE.
      !
    ENDIF
    !
    !   WATSUP
    !   ------
    IF (.NOT.ANY(DTV%LDATA_WATSUP)) THEN
      ZDEF(:)=0.
      ALLOCATE(DTV%XPAR_WATSUP      (KDIM,DTV%NTIME,NVEGTYPE))
      DO JTIME=1,36
        !   ECOCLIMAP spatial distribution field    
        IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)
        CALL AV_PGD(DTCO,ZWORK(:,JTIME,:),S%XCOVER,XDATA_WATSUP,YVEG,'ARI',S%LCOVER,KDECADE=JTIME)  
        !   Extrapolation toward new vegtype distribution field from updated land-use map or user  
        CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                       HPROGRAM,KLUOUT,'WATSUP  ', ZWORK(:,JTIME,:), PDEF=ZDEF)
      ENDDO
      !
      CALL GOTO_NTIME(DTV%NTIME,ZWORK,DTV%XPAR_WATSUP)
      !  
      DTV%LDATA_WATSUP(:)=.TRUE.
    ENDIF
    !
    ALLOCATE(TPWORK(KDIM,NVEGTYPE))
    !
    IF (.NOT.ANy(DTV%LDATA_SEED_M).OR..NOT.ANY(DTV%LDATA_SEED_D)) THEN
      ALLOCATE(DTV%XPAR_SEED_M(KDIM,NVEGTYPE))
      ALLOCATE(DTV%XPAR_SEED_D(KDIM,NVEGTYPE))
      IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)        
      CALL AV_PGD(TPWORK(:,:),S%XCOVER,TDATA_SEED(:,:),YVEG,'MAJ',S%LCOVER,KDECADE=1)
      DTV%XPAR_SEED_M(:,:) = FLOAT(TPWORK(:,:)%TDATE%MONTH)
      DTV%XPAR_SEED_D(:,:) = FLOAT(TPWORK(:,:)%TDATE%DAY)
      ZDEF(:)=5.
      CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                     HPROGRAM,KLUOUT,'SEED_M', DTV%XPAR_SEED_M(:,:), PDEF=ZDEF)
      ZDEF(:)=10.
      CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                     HPROGRAM,KLUOUT,'SEED_D', DTV%XPAR_SEED_D(:,:), PDEF=ZDEF)
    ENDIF
    !
    DTV%LDATA_SEED_M(:) = .TRUE.
    DTV%LDATA_SEED_D(:) = .TRUE.
    !    
    IF (.NOT.ANY(DTV%LDATA_REAP_M).OR..NOT.ANY(DTV%LDATA_REAP_D)) THEN
      ALLOCATE(DTV%XPAR_REAP_M(KDIM,NVEGTYPE))
      ALLOCATE(DTV%XPAR_REAP_D(KDIM,NVEGTYPE))
      IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)        
      CALL AV_PGD(TPWORK(:,:),S%XCOVER,TDATA_REAP(:,:),YVEG,'MAJ',S%LCOVER,KDECADE=1)
      DTV%XPAR_REAP_M(:,:) = FLOAT(TPWORK(:,:)%TDATE%MONTH)
      DTV%XPAR_REAP_D(:,:) = FLOAT(TPWORK(:,:)%TDATE%DAY)
      ZDEF(:)=8.
      CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                     HPROGRAM,KLUOUT,'REAP_M', DTV%XPAR_REAP_M(:,:), PDEF=ZDEF)
      ZDEF(:)=1.
      CALL INI_VAR_FROM_VEGTYPE_DATA(DTCO, DTV, UG, U, &
                                     HPROGRAM,KLUOUT,'REAP_D', DTV%XPAR_REAP_D(:,:), PDEF=ZDEF)
    ENDIF      
    !
    DTV%LDATA_REAP_M(:) = .TRUE.
    DTV%LDATA_REAP_D(:) = .TRUE.
    !    
    DEALLOCATE(TPWORK)
    !
  ENDIF
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('EXTRAPOL_FIELDS',1,ZHOOK_HANDLE)
!
CONTAINS 
!
SUBROUTINE GOTO_NTIME(KTIME,PWORK,PPAR_DATA)
!
INTEGER, INTENT(IN) :: KTIME
REAL, DIMENSION(:,:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:,:), INTENT(OUT) :: PPAR_DATA
!
IF (KTIME==1) THEN
  PPAR_DATA(:,1,:) = SUM(PWORK(:,:,:),2)/36.
ELSEIF (KTIME==2) THEN
  PPAR_DATA(:,1,:) = (SUM(PWORK(:,1:8,:),2) + SUM(PWORK(:,27:36,:),2))/18.
  PPAR_DATA(:,2,:) = SUM(PWORK(:,9:26,:),2)/18.
ELSEIF (KTIME==12) THEN
  DO JTIME=1,12
    PPAR_DATA(:,JTIME,:) = SUM(PWORK(:,(JTIME-1)*3+1:JTIME*3,:),2)/3.
  ENDDO
ELSEIF (KTIME==36) THEN
  PPAR_DATA(:,:,:) = PWORK(:,:,:)  
ENDIF
!
END SUBROUTINE GOTO_NTIME
!
!-------------------------------------------------------------------------------
END SUBROUTINE EXTRAPOL_FIELDS
