!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE CONVERT_PATCH_TEB (BDD, DTB, DTCO, DTT, TOP, &
                                   PDEF_ROAD_DIR, T, B, TPN )
!     ##############################################################
!
!!**** *CONVERT_PATCH_TEB* compilation of conver_cover_isba, pgd_isba_par and
!!      init_from_data_isba_parn
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    S. Faroux        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    16/11/10
!!    G. Pigeon     /09/12: add ROUGH_ROOF and ROUGH_WALL coef for outdoor conv. coef
!!    V. Masson      08/13  adds solar panels
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODD_TEB_n, ONLY : TEB_t
USE MODD_BEM_n, ONLY : BEM_t
USE MODD_TEB_PANEL_n, ONLY : TEB_PANEL_t
!
USE MODD_SURF_PAR,       ONLY : XUNDEF
!
USE MODD_DATA_COVER_PAR, ONLY : NDATA_ROAD_LAYER, NDATA_WALL_LAYER,               &
                                NDATA_ROOF_LAYER, NDATA_FLOOR_LAYER
USE MODD_DATA_COVER,     ONLY : XDATA_Z0_TOWN, XDATA_ALB_ROOF,                    &
                                XDATA_EMIS_ROOF, XDATA_HC_ROOF, XDATA_TC_ROOF,    &
                                XDATA_D_ROOF, XDATA_ALB_ROAD, XDATA_EMIS_ROAD,    &
                                XDATA_HC_ROAD, XDATA_TC_ROAD, XDATA_D_ROAD,       &
                                XDATA_ALB_WALL, XDATA_EMIS_WALL, XDATA_HC_WALL,   &
                                XDATA_TC_WALL, XDATA_D_WALL, XDATA_BLD_HEIGHT,    &
                                XDATA_H_TRAFFIC, XDATA_LE_TRAFFIC,                &
                                XDATA_H_INDUSTRY, XDATA_LE_INDUSTRY,              &
                                XDATA_HC_FLOOR, XDATA_TC_FLOOR, XDATA_D_FLOOR,    &
                                XDATA_TCOOL_TARGET, XDATA_THEAT_TARGET,           &
                                XDATA_F_WASTE_CAN, XDATA_EFF_HEAT, XDATA_QIN,     &
                                XDATA_QIN_FRAD, XDATA_SHGC, XDATA_U_WIN, XDATA_GR,&
                                XDATA_SHGC_SH, XDATA_FLOOR_HEIGHT, XDATA_INF,     &
                                XDATA_F_WATER_COND, XDATA_QIN_FLAT,               &   
                                XDATA_HR_TARGET, XDATA_V_VENT, XDATA_CAP_SYS_HEAT,&
                                XDATA_CAP_SYS_RAT, XDATA_T_ADP, XDATA_M_SYS_RAT,  &
                                XDATA_COP_RAT, XDATA_T_SIZE_MAX, XDATA_T_SIZE_MIN,&
                                XDATA_SHADE, XDATA_NATVENT, XDATA_ROUGH_ROOF,     &
                                XDATA_ROUGH_WALL, XDATA_RESIDENTIAL,XDATA_FRAC_GR,&
                                XDATA_EMIS_PANEL,XDATA_ALB_PANEL, XDATA_EFF_PANEL,&
                                XDATA_FRAC_PANEL
!
!
USE MODI_THERMAL_LAYERS_CONF
USE MODI_INI_DATA_PARAM_TEB
USE MODI_AV_PGD
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_ABOR1_SFX
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
REAL,                   INTENT(IN)    :: PDEF_ROAD_DIR ! default road direction
!
TYPE(TEB_t), INTENT(INOUT), OPTIONAL :: T
TYPE(BEM_t), INTENT(INOUT), OPTIONAL :: B
TYPE(TEB_PANEL_t), INTENT(INOUT), OPTIONAL :: TPN
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
REAL, DIMENSION(:,:), ALLOCATABLE :: ZTC, ZHC, ZD
INTEGER               :: JLAYER    ! loop counter on layers
INTEGER               :: IL        ! number of points
!
 CHARACTER(LEN=3)      :: YAVG      ! Type of averaging for buildings
 CHARACTER(LEN=4)      :: YAREA     ! Area where parameter is averaged
!
!*    0.3    Declaration of namelists
!            ------------------------
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*    1.      Initializations
!             ---------------
!
IF (LHOOK) CALL DR_HOOK('CONVERT_PATCH_TEB',0,ZHOOK_HANDLE)
!
IF (TOP%CBLD_ATYPE=='ARI') THEN
  YAVG=TOP%CBLD_ATYPE
  YAREA='BLD'
ELSE
  YAVG=TOP%CBLD_ATYPE
  YAREA='BLV'
END IF
!
IL = SIZE(TOP%XCOVER,1)
!-------------------------------------------------------------------------------
!
IF (PRESENT(T)) THEN
!       ROAD DIRECTION 
!       --------------
  IF (DTT%LDATA_ROAD_DIR) THEN
    T%XROAD_DIR=DTT%XPAR_ROAD_DIR
  ELSE
    T%XROAD_DIR=PDEF_ROAD_DIR
  ENDIF
!
!       GARDEN fraction
!       ---------------
  IF (DTT%LDATA_GARDEN) THEN
    T%XGARDEN=DTT%XPAR_GARDEN
  ELSE
    CALL AV_PGD(DTCO, T%XGARDEN, TOP%XCOVER, DTCO%XDATA_GARDEN(:),'TWN','ARI',TOP%LCOVER)
  ENDIF
!
!     GREENROOF FRACTION
!     ------------------
  IF (DTT%LDATA_GREENROOF) THEN
    T%XGREENROOF=DTT%XPAR_GREENROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PGREENROOF=T%XGREENROOF)
  ELSE
    CALL AV_PGD(DTCO, T%XGREENROOF,TOP%XCOVER ,XDATA_FRAC_GR(:),'BLD','ARI',TOP%LCOVER)
  ENDIF
!
!       BLD fraction
!       -------------
  IF (DTT%LDATA_BLD) THEN
    T%XBLD=DTT%XPAR_BLD  
  ELSE
    CALL AV_PGD(DTCO, T%XBLD, TOP%XCOVER, DTCO%XDATA_BLD(:),'TWN','ARI',TOP%LCOVER)
  ENDIF
!
!
!      Z0_TOWN
!      ----------
  IF (DTT%LDATA_Z0_TOWN) THEN
    T%XZ0_TOWN=DTT%XPAR_Z0_TOWN  
  ELSE
    CALL AV_PGD(DTCO, T%XZ0_TOWN ,TOP%XCOVER ,XDATA_Z0_TOWN (:),'TWN','CDN',TOP%LCOVER)  
  ENDIF  
!
!      BLD Height
!      ----------
  IF (DTT%LDATA_BLD_HEIGHT) THEN
    T%XBLD_HEIGHT=DTT%XPAR_BLD_HEIGHT
  ELSE
    CALL AV_PGD(DTCO, T%XBLD_HEIGHT ,TOP%XCOVER ,XDATA_BLD_HEIGHT (:),'BLD','ARI',TOP%LCOVER)  
  ENDIF  
!
!      WALL O HOR
!      ----------
  IF (DTT%LDATA_WALL_O_HOR) THEN
    T%XWALL_O_HOR=DTT%XPAR_WALL_O_HOR 
  ELSE
    CALL AV_PGD(DTCO, T%XWALL_O_HOR ,TOP%XCOVER ,DTCO%XDATA_WALL_O_HOR (:),'BLD','ARI',TOP%LCOVER)  
  ENDIF  
!
!      ALB_ROOF
!      ----------
  IF (DTT%LDATA_ALB_ROOF) THEN
    T%XALB_ROOF=DTT%XPAR_ALB_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PALB_ROOF=T%XALB_ROOF)
  ELSE
    CALL AV_PGD(DTCO, T%XALB_ROOF ,TOP%XCOVER ,XDATA_ALB_ROOF (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      EMIS_ROOF
!      ----------
  IF (DTT%LDATA_EMIS_ROOF) THEN
    T%XEMIS_ROOF=DTT%XPAR_EMIS_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PEMIS_ROOF=T%XEMIS_ROOF)
  ELSE
    CALL AV_PGD(DTCO, T%XEMIS_ROOF ,TOP%XCOVER ,XDATA_EMIS_ROOF (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      HC_ROOF, TC_ROOF, D_ROOF
!      ------------------------
!
  IF (DTT%LDATA_HC_ROOF) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_ROOF_LAYER)
    ZHC=DTT%XPAR_HC_ROOF
    ZTC=DTT%XPAR_TC_ROOF
    ZD =DTT%XPAR_D_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_ROOF_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PHC_ROOF=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PTC_ROOF=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PD_ROOF =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_ROOF_LAYER)
    DO JLAYER=1,NDATA_ROOF_LAYER
      CALL AV_PGD(DTCO, ZHC(:,JLAYER), TOP%XCOVER, XDATA_HC_ROOF (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZTC(:,JLAYER), TOP%XCOVER ,XDATA_TC_ROOF (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZD (:,JLAYER), TOP%XCOVER ,XDATA_D_ROOF  (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
    ENDDO
  ENDIF 
  CALL THERMAL_LAYERS_CONF('ROOF ',ZD,T%XD_ROOF,ZHC,T%XHC_ROOF,ZTC,T%XTC_ROOF) 
  CALL DEALLOCATE_THERMAL_WORK
!
!      ALB_ROAD
!      ----------
  IF (DTT%LDATA_ALB_ROAD) THEN
    T%XALB_ROAD=DTT%XPAR_ALB_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD,  DTT%NPAR_BLDCODE,PALB_ROAD=T%XALB_ROAD)
  ELSE
    CALL AV_PGD(DTCO, &
                 T%XALB_ROAD ,TOP%XCOVER ,XDATA_ALB_ROAD (:),'STR','ARI',TOP%LCOVER)  
  ENDIF  
!
!      EMIS_ROAD
!      ----------
  IF (DTT%LDATA_EMIS_ROAD) THEN
    T%XEMIS_ROAD=DTT%XPAR_EMIS_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PEMIS_ROAD=T%XEMIS_ROAD)
  ELSE
    CALL AV_PGD(DTCO, &
                 T%XEMIS_ROAD ,TOP%XCOVER ,XDATA_EMIS_ROAD (:),'STR','ARI',TOP%LCOVER)  
  ENDIF  
!
!      HC_ROAD, TC_ROAD, D_ROAD
!      ------------------------
!
  IF (DTT%LDATA_HC_ROAD) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_ROAD_LAYER)
    ZHC=DTT%XPAR_HC_ROAD
    ZTC=DTT%XPAR_TC_ROAD
    ZD =DTT%XPAR_D_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_ROAD_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PHC_ROAD=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PTC_ROAD=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PD_ROAD =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_ROAD_LAYER)
    DO JLAYER=1,NDATA_ROAD_LAYER
      CALL AV_PGD(DTCO, ZHC(:,JLAYER), TOP%XCOVER, XDATA_HC_ROAD (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZTC(:,JLAYER), TOP%XCOVER ,XDATA_TC_ROAD (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZD (:,JLAYER), TOP%XCOVER ,XDATA_D_ROAD  (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      !CALL AV_PGD (T%XHC_ROAD(:,JLAYER), TOP%XCOVER, XDATA_HC_ROAD (:,JLAYER),YAREA,YAVG)
      !CALL AV_PGD (T%XTC_ROAD(:,JLAYER), TOP%XCOVER ,XDATA_TC_ROAD (:,JLAYER),YAREA,YAVG)
      !CALL AV_PGD (T%XD_ROAD(:,JLAYER), TOP%XCOVER ,XDATA_D_ROAD  (:,JLAYER),YAREA,YAVG)
    ENDDO
  ENDIF 
  CALL THERMAL_LAYERS_CONF('ROAD ',ZD,T%XD_ROAD,ZHC,T%XHC_ROAD,ZTC,T%XTC_ROAD) 
  CALL DEALLOCATE_THERMAL_WORK
!
!      ALB_WALL
!      ----------
  IF (DTT%LDATA_ALB_WALL) THEN
    T%XALB_WALL=DTT%XPAR_ALB_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PALB_WALL=T%XALB_WALL)
  ELSE
    CALL AV_PGD(DTCO, T%XALB_WALL ,TOP%XCOVER ,XDATA_ALB_WALL (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      EMIS_WALL
!      ----------
  IF (DTT%LDATA_EMIS_WALL) THEN
    T%XEMIS_WALL=DTT%XPAR_EMIS_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PEMIS_WALL=T%XEMIS_WALL)
  ELSE
    CALL AV_PGD(DTCO, T%XEMIS_WALL ,TOP%XCOVER ,XDATA_EMIS_WALL (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      HC_WALL, TC_WALL, D_WALL
!      ------------------------
!
  IF (DTT%LDATA_HC_WALL) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_WALL_LAYER)
    ZHC=DTT%XPAR_HC_WALL
    ZTC=DTT%XPAR_TC_WALL
    ZD =DTT%XPAR_D_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_WALL_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PHC_WALL=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PTC_WALL=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PD_WALL =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_WALL_LAYER)
    DO JLAYER=1,NDATA_WALL_LAYER
      CALL AV_PGD(DTCO, ZHC(:,JLAYER), TOP%XCOVER, XDATA_HC_WALL (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZTC(:,JLAYER), TOP%XCOVER ,XDATA_TC_WALL (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZD (:,JLAYER), TOP%XCOVER ,XDATA_D_WALL  (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
    ENDDO
  ENDIF 
  CALL THERMAL_LAYERS_CONF('WALL ',ZD,T%XD_WALL,ZHC,T%XHC_WALL,ZTC,T%XTC_WALL) 
  CALL DEALLOCATE_THERMAL_WORK
!
!     H_TRAFFIC
!     ---------
  IF (DTT%LDATA_H_TRAFFIC) THEN
    T%XH_TRAFFIC=DTT%XPAR_H_TRAFFIC
  ELSE
    CALL AV_PGD(DTCO, T%XH_TRAFFIC ,TOP%XCOVER ,XDATA_H_TRAFFIC(:),'TWN','ARI',TOP%LCOVER)
  ENDIF 
!
!     LE_TRAFFIC
!     ----------
  IF (DTT%LDATA_LE_TRAFFIC) THEN
    T%XLE_TRAFFIC=DTT%XPAR_LE_TRAFFIC
  ELSE
    CALL AV_PGD(DTCO, T%XLE_TRAFFIC ,TOP%XCOVER ,XDATA_LE_TRAFFIC(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     H_INDUSTRY
!     ----------
  IF (DTT%LDATA_H_INDUSTRY) THEN
    T%XH_INDUSTRY=DTT%XPAR_H_INDUSTRY
  ELSE
    CALL AV_PGD(DTCO, T%XH_INDUSTRY ,TOP%XCOVER ,XDATA_H_INDUSTRY(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     LE_INDUSTRY
!     -----------
  IF (DTT%LDATA_LE_INDUSTRY) THEN
    T%XLE_INDUSTRY=DTT%XPAR_LE_INDUSTRY
  ELSE
    CALL AV_PGD(DTCO, T%XLE_INDUSTRY ,TOP%XCOVER ,XDATA_LE_INDUSTRY(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!
!      ROUGH_ROOF
!      ----------
  IF (DTT%LDATA_ROUGH_ROOF) THEN
    T%XROUGH_ROOF=DTT%XPAR_ROUGH_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PROUGH_ROOF=T%XROUGH_ROOF)
  ELSE
    CALL AV_PGD(DTCO, T%XROUGH_ROOF ,TOP%XCOVER ,XDATA_ROUGH_ROOF (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      ROUGH_WALL
!      ----------
  IF (DTT%LDATA_ROUGH_WALL) THEN
    T%XROUGH_WALL=DTT%XPAR_ROUGH_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PROUGH_WALL=T%XROUGH_WALL)
  ELSE
    CALL AV_PGD(DTCO, T%XROUGH_WALL ,TOP%XCOVER ,XDATA_ROUGH_WALL (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF  
!
!      RESIDENTIAL use fraction
!      ------------------------
  IF (DTT%LDATA_RESIDENTIAL) THEN
    T%XRESIDENTIAL=DTT%XPAR_RESIDENTIAL
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_USETYPE,PRESIDENTIAL=T%XRESIDENTIAL)
  ELSE
    CALL AV_PGD(DTCO, T%XRESIDENTIAL ,TOP%XCOVER ,XDATA_RESIDENTIAL (:),YAREA,YAVG,TOP%LCOVER)  
  ENDIF
!
ENDIF
!      HC_FLOOR, TC_FLOOR, D_FLOOR
!      ------------------------
!
IF (PRESENT(B)) THEN

  IF (DTB%LDATA_HC_FLOOR) THEN
    CALL ALLOCATE_THERMAL_WORK(DTB%NPAR_FLOOR_LAYER)
    ZHC=DTB%XPAR_HC_FLOOR
    ZTC=DTB%XPAR_TC_FLOOR
    ZD =DTB%XPAR_D_FLOOR
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_FLOOR_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PHC_FLOOR=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PTC_FLOOR=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PD_FLOOR =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_FLOOR_LAYER)
    DO JLAYER=1,NDATA_FLOOR_LAYER
      CALL AV_PGD(DTCO, ZHC(:,JLAYER), TOP%XCOVER, XDATA_HC_FLOOR (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZTC(:,JLAYER), TOP%XCOVER ,XDATA_TC_FLOOR (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
      CALL AV_PGD(DTCO, ZD (:,JLAYER), TOP%XCOVER ,XDATA_D_FLOOR  (:,JLAYER),YAREA,YAVG,TOP%LCOVER)
    ENDDO
  ENDIF 
  CALL THERMAL_LAYERS_CONF('FLOOR',ZD,B%XD_FLOOR,ZHC,B%XHC_FLOOR,ZTC,B%XTC_FLOOR) 
  CALL DEALLOCATE_THERMAL_WORK
!
!
!     TCOOL_TARGET
!     -----------
  IF (DTB%LDATA_TCOOL_TARGET) THEN
    B%XTCOOL_TARGET=DTB%XPAR_TCOOL_TARGET
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_USETYPE,PTCOOL_TARGET=B%XTCOOL_TARGET)
  ELSE
    CALL AV_PGD(DTCO, B%XTCOOL_TARGET ,TOP%XCOVER ,XDATA_TCOOL_TARGET(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     THEAT_TARGET
!     -----------
  IF (DTB%LDATA_THEAT_TARGET) THEN
    B%XTHEAT_TARGET=DTB%XPAR_THEAT_TARGET
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_USETYPE,PTHEAT_TARGET=B%XTHEAT_TARGET)
  ELSE
    CALL AV_PGD(DTCO, B%XTHEAT_TARGET ,TOP%XCOVER ,XDATA_THEAT_TARGET(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     -----------
  IF (DTB%LDATA_F_WASTE_CAN) THEN
    B%XF_WASTE_CAN=DTB%XPAR_F_WASTE_CAN
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PF_WASTE_CAN=B%XF_WASTE_CAN)
  ELSE
    CALL AV_PGD(DTCO, B%XF_WASTE_CAN ,TOP%XCOVER ,XDATA_F_WASTE_CAN(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     EFF_HEAT
!     -----------
  IF (DTB%LDATA_EFF_HEAT) THEN
    B%XEFF_HEAT=DTB%XPAR_EFF_HEAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PEFF_HEAT=B%XEFF_HEAT)
  ELSE
    CALL AV_PGD(DTCO, B%XEFF_HEAT ,TOP%XCOVER ,XDATA_EFF_HEAT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     QIN
!     -----------
  IF (DTB%LDATA_QIN) THEN
    B%XQIN=DTB%XPAR_QIN
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_USETYPE,PQIN=B%XQIN)
  ELSE
    CALL AV_PGD(DTCO, B%XQIN ,TOP%XCOVER ,XDATA_QIN(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     QIN_FRAD
!     -----------
  IF (DTB%LDATA_QIN_FRAD) THEN
    B%XQIN_FRAD=DTB%XPAR_QIN_FRAD
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_USETYPE,PQIN_FRAD=B%XQIN_FRAD)
  ELSE
    CALL AV_PGD(DTCO, B%XQIN_FRAD ,TOP%XCOVER ,XDATA_QIN_FRAD(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     SHGC
!     -----------
  IF (DTB%LDATA_SHGC) THEN
    B%XSHGC=DTB%XPAR_SHGC
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PSHGC=B%XSHGC)
  ELSE
    CALL AV_PGD(DTCO, B%XSHGC ,TOP%XCOVER ,XDATA_SHGC(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     U_WIN
!     -----------
  IF (DTB%LDATA_U_WIN) THEN
    B%XU_WIN=DTB%XPAR_U_WIN
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PU_WIN=B%XU_WIN)
  ELSE
    CALL AV_PGD(DTCO, B%XU_WIN ,TOP%XCOVER ,XDATA_U_WIN(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     GR
!     -----------
  IF (DTB%LDATA_GR) THEN
    B%XGR=DTB%XPAR_GR
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PGR=B%XGR)
  ELSE
    CALL AV_PGD(DTCO, B%XGR ,TOP%XCOVER ,XDATA_GR(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     SHGC_SH
!     -----------
  IF (DTB%LDATA_SHGC_SH) THEN
    B%XSHGC_SH=DTB%XPAR_SHGC_SH
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_USETYPE,PSHGC_SH=B%XSHGC_SH)
  ELSE
    CALL AV_PGD(DTCO, B%XSHGC_SH ,TOP%XCOVER ,XDATA_SHGC_SH(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     FLOOR_HEIGHT
!     -----------
  IF (DTB%LDATA_FLOOR_HEIGHT) THEN
    B%XFLOOR_HEIGHT=DTB%XPAR_FLOOR_HEIGHT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PFLOOR_HEIGHT=B%XFLOOR_HEIGHT)
  ELSE
    CALL AV_PGD(DTCO, B%XFLOOR_HEIGHT ,TOP%XCOVER ,XDATA_FLOOR_HEIGHT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     INF
!     -----------
  IF (DTB%LDATA_INF) THEN
    B%XINF=DTB%XPAR_INF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PINF=B%XINF)
  ELSE
    CALL AV_PGD(DTCO, B%XINF ,TOP%XCOVER ,XDATA_INF(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     F_WATER_COND
!     -----------
  IF (DTB%LDATA_F_WATER_COND) THEN
    B%XF_WATER_COND=DTB%XPAR_F_WATER_COND
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PF_WATER_COND=B%XF_WATER_COND)
  ELSE
    CALL AV_PGD(DTCO, B%XF_WATER_COND ,TOP%XCOVER ,XDATA_F_WATER_COND(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     QIN_FLAT
!     -----------
  IF (DTB%LDATA_QIN_FLAT) THEN
    B%XQIN_FLAT=DTB%XPAR_QIN_FLAT
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_USETYPE,PQIN_FLAT=B%XQIN_FLAT)
  ELSE
    CALL AV_PGD(DTCO, B%XQIN_FLAT ,TOP%XCOVER ,XDATA_QIN_FLAT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     HR_TARGET
!     -----------
  IF (DTB%LDATA_HR_TARGET) THEN
    B%XHR_TARGET=DTB%XPAR_HR_TARGET
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_USETYPE,PHR_TARGET=B%XHR_TARGET)
  ELSE
    CALL AV_PGD(DTCO, B%XHR_TARGET ,TOP%XCOVER ,XDATA_HR_TARGET(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     V_VENT
!     -----------
  IF (DTB%LDATA_V_VENT) THEN
    B%XV_VENT=DTB%XPAR_V_VENT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PV_VENT=B%XV_VENT)
  ELSE
    CALL AV_PGD(DTCO, B%XV_VENT ,TOP%XCOVER ,XDATA_V_VENT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     CAP_SYS_HEAT
!     -----------
  IF (DTB%LDATA_CAP_SYS_HEAT) THEN
    B%XCAP_SYS_HEAT=DTB%XPAR_CAP_SYS_HEAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PCAP_SYS_HEAT=B%XCAP_SYS_HEAT)
  ELSE
    CALL AV_PGD(DTCO, B%XCAP_SYS_HEAT ,TOP%XCOVER ,XDATA_CAP_SYS_HEAT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     CAP_SYS_RAT
!     -----------
  IF (DTB%LDATA_CAP_SYS_RAT) THEN
    B%XCAP_SYS_RAT=DTB%XPAR_CAP_SYS_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PCAP_SYS_RAT=B%XCAP_SYS_RAT)
  ELSE
    CALL AV_PGD(DTCO, B%XCAP_SYS_RAT ,TOP%XCOVER ,XDATA_CAP_SYS_RAT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     T_ADP
!     -----------
  IF (DTB%LDATA_T_ADP) THEN
    B%XT_ADP=DTB%XPAR_T_ADP
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PT_ADP=B%XT_ADP)
  ELSE
    CALL AV_PGD(DTCO, B%XT_ADP ,TOP%XCOVER ,XDATA_T_ADP(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     M_SYS_RAT
!     -----------
  IF (DTB%LDATA_M_SYS_RAT) THEN
    B%XM_SYS_RAT=DTB%XPAR_M_SYS_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PM_SYS_RAT=B%XM_SYS_RAT)
  ELSE
    CALL AV_PGD(DTCO, B%XM_SYS_RAT ,TOP%XCOVER ,XDATA_M_SYS_RAT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     COP_RAT
!     -----------
  IF (DTB%LDATA_COP_RAT) THEN
    B%XCOP_RAT=DTB%XPAR_COP_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PCOP_RAT=B%XCOP_RAT)
  ELSE
    CALL AV_PGD(DTCO, B%XCOP_RAT ,TOP%XCOVER ,XDATA_COP_RAT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF   
!
!     T_SIZE_MAX
!     -----------
  IF (DTB%LDATA_T_SIZE_MAX) THEN
    B%XT_SIZE_MAX=DTB%XPAR_T_SIZE_MAX
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PT_SIZE_MAX=B%XT_SIZE_MAX)
  ELSE
    CALL AV_PGD(DTCO, B%XT_SIZE_MAX ,TOP%XCOVER ,XDATA_T_SIZE_MAX(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     T_SIZE_MIN
!     -----------
  IF (DTB%LDATA_T_SIZE_MIN) THEN
    B%XT_SIZE_MIN=DTB%XPAR_T_SIZE_MIN
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PT_SIZE_MIN=B%XT_SIZE_MIN)
  ELSE
    CALL AV_PGD(DTCO, B%XT_SIZE_MIN ,TOP%XCOVER ,XDATA_T_SIZE_MIN(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     SHADE
!     -----
  IF (DTB%LDATA_SHADE) THEN
    B%XSHADE(:) = DTB%XPAR_SHADE(:)
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_USETYPE,PSHADE=B%XSHADE)
  ELSE
    CALL AV_PGD(DTCO, B%XSHADE,TOP%XCOVER ,XDATA_SHADE(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
!     NATVENT
!     -------
  IF (DTB%LDATA_NATVENT) THEN
    B%XNATVENT(:) = DTB%XPAR_NATVENT(:)
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_USETYPE,PNATVENT=B%XNATVENT)
  ELSE
    CALL AV_PGD(DTCO, B%XNATVENT,TOP%XCOVER,XDATA_NATVENT(:),'TWN','ARI',TOP%LCOVER)
  ENDIF  
!
ENDIF
!
IF (PRESENT(TPN)) THEN
!
!     SOLAR PANELS
!     ------------
  IF (DTT%LDATA_EMIS_PANEL) THEN
    TPN%XEMIS_PANEL=DTT%XPAR_EMIS_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PEMIS_PANEL=TPN%XEMIS_PANEL)
  ELSE
    CALL AV_PGD(DTCO, TPN%XEMIS_PANEL ,TOP%XCOVER ,XDATA_EMIS_PANEL(:),'BLD','ARI',TOP%LCOVER)
  ENDIF  
!
  IF (DTT%LDATA_ALB_PANEL) THEN
    TPN%XALB_PANEL=DTT%XPAR_ALB_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PALB_PANEL=TPN%XALB_PANEL)
  ELSE
    CALL AV_PGD(DTCO, TPN%XALB_PANEL ,TOP%XCOVER ,XDATA_ALB_PANEL(:),'BLD','ARI',TOP%LCOVER)
  ENDIF  
!
  IF (DTT%LDATA_EFF_PANEL) THEN
    TPN%XEFF_PANEL=DTT%XPAR_EFF_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PEFF_PANEL=TPN%XEFF_PANEL)
  ELSE
    CALL AV_PGD(DTCO, TPN%XEFF_PANEL ,TOP%XCOVER ,XDATA_EFF_PANEL(:),'BLD','ARI',TOP%LCOVER)
  ENDIF  
!
  IF (DTT%LDATA_FRAC_PANEL) THEN
    TPN%XFRAC_PANEL=DTT%XPAR_FRAC_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT%NPAR_BLDCODE,PFRAC_PANEL=TPN%XFRAC_PANEL)
  ELSE
    CALL AV_PGD(DTCO, TPN%XFRAC_PANEL ,TOP%XCOVER ,XDATA_FRAC_PANEL(:),'BLD','ARI',TOP%LCOVER)
  ENDIF  
!
ENDIF
!
IF (LHOOK) CALL DR_HOOK('CONVERT_PATCH_TEB',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
CONTAINS
!
SUBROUTINE ALLOCATE_THERMAL_WORK(KPAR)
INTEGER, INTENT(IN) :: KPAR
ALLOCATE(ZD(IL,KPAR))
ALLOCATE(ZHC(IL,KPAR))
ALLOCATE(ZTC(IL,KPAR))
END SUBROUTINE ALLOCATE_THERMAL_WORK
SUBROUTINE DEALLOCATE_THERMAL_WORK
DEALLOCATE(ZD)
DEALLOCATE(ZHC)
DEALLOCATE(ZTC)
END SUBROUTINE DEALLOCATE_THERMAL_WORK
!-------------------------------------------------------------------------------
!
END SUBROUTINE CONVERT_PATCH_TEB
