!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE CONVERT_COVER_ISBA (DTCO, HALBEDO, &
                                        HISBA,OTR_ML,KDECADE,PCOVER,OCOVER,HPHOTO,   &
                                         HSFTYPE,PVEG,                       &
                                         PLAI,PRSMIN,PGAMMA,PWRMAX_CF,       &
                                         PRGL,PCV,PSOILGRID,PPERM,           &
                                         PDG,KWG_LAYER,PDROOT,PDG2,          &
                                         PD_ICE,PZ0,PZ0_O_Z0H,               &
                                         PALBNIR_VEG,PALBVIS_VEG,PALBUV_VEG, &
                                         PEMIS_ECO,                          &
                                         PVEGTYPE,PROOTFRAC,                 &
                                         PGMES,PBSLAI,PLAIMIN,PSEFOLD,PGC,   &
                                         PDMAX, PF2I, OSTRESS, PH_TREE,PRE25,&
                                         PCE_NITRO, PCF_NITRO, PCNA_NITRO,   &
                                         TPSEED, TPREAP, PWATSUP, PIRRIG,    &
                                         PGNDLITTER, PZ0LITTER, PH_VEG,      &
                                         OWATER_TO_NATURE, OTOWN_TO_ROCK,    &
                                         OGARDEN     )  
!     ##############################################################
!
!!**** *CONVERT_COVER* convert surface cover classes into secondary 
!!                     physiographic variables for ISBA
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    V. Masson        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original   01/2004
!!    
!!      P Le Moigne 09/2005 AGS modifs of L. Jarlan
!!      B. Decharme 04/2013 Add CDGAVG (average depth)
!!                          Soil depth = Root depth with ISBA-DF
!!                          except for bare soil pft (but limited to 1m)
!!      P Samuelsson 10/2014 MEB
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t, DATA_COVER_INIT
!
USE MODD_DATA_COVER,     ONLY : XDATA_LAI, XDATA_H_TREE,                  &
                                  XDATA_VEG, XDATA_Z0, XDATA_Z0_O_Z0H,    &
                                  XDATA_EMIS_ECO, XDATA_GAMMA, XDATA_CV,  &
                                  XDATA_RGL, XDATA_RSMIN,                 &
                                  XDATA_ALBNIR_VEG, XDATA_ALBVIS_VEG,     &
                                  XDATA_ALBUV_VEG, XDATA_DICE,            &
                                  XDATA_ALB_VEG_NIR, XDATA_ALB_VEG_VIS,   &
                                  XDATA_ALB_SOIL_NIR, XDATA_ALB_SOIL_VIS, &                                  
                                  XDATA_GMES, XDATA_BSLAI, XDATA_LAIMIN,  &
                                  XDATA_SEFOLD, XDATA_GC, XDATA_WRMAX_CF, &
                                  XDATA_STRESS,                           &
                                  XDATA_DMAX, XDATA_F2I, XDATA_RE25,      &
                                  XDATA_CE_NITRO, XDATA_CF_NITRO,         &
                                  XDATA_CNA_NITRO,                        &
                                  XDATA_GMES_ST, XDATA_BSLAI_ST,          &
                                  XDATA_SEFOLD_ST, XDATA_GC_ST,           &
                                  XDATA_DMAX_ST, XDATA_WATSUP,            &
                                  TDATA_SEED, TDATA_REAP,XDATA_IRRIG,     &
                                  XDATA_ROOT_DEPTH, XDATA_GROUND_DEPTH,   &
                                  XDATA_ROOT_EXTINCTION, XDATA_ROOT_LIN,  &
                                  XDATA_GNDLITTER, XDATA_Z0LITTER,        &
                                  XDATA_H_VEG, XDATA_LAI_ALL_YEARS, XDATA_VEGTYPE
!


USE MODD_DATA_COVER_PAR, ONLY : NVEGTYPE, JPCOVER, NVT_NO, NVT_ROCK, NVT_SNOW,   &
                                NVT_TEBD, NVT_BONE, NVT_TRBE, NVT_C3,   &
                                NVT_C4, NVT_IRR, NVT_GRAS, NVT_TROG,    &
                                NVT_PARK, NVT_TRBD, NVT_TEBE, NVT_TENE, &
                                NVT_BOBD, NVT_BOND, NVT_BOGR, NVT_SHRB, &
                                NVT_C3W, NVT_C3S, NVT_FLTR, NVT_FLGR
USE MODD_TYPE_DATE_SURF
!
USE MODI_AV_PGD
USE MODI_DEFAULT_DATA_COVER
USE MODI_INI_DATA_PARAM
!
USE MODI_DEFAULT_LAI_ECO2_Y2002_01
USE MODI_DEFAULT_LAI_ECO2_Y2002_02
USE MODI_DEFAULT_LAI_ECO2_Y2002_03
USE MODI_DEFAULT_LAI_ECO2_Y2002_04
USE MODI_DEFAULT_LAI_ECO2_Y2002_05
USE MODI_DEFAULT_LAI_ECO2_Y2002_06
USE MODI_DEFAULT_LAI_ECO2_Y2002_07
USE MODI_DEFAULT_LAI_ECO2_Y2002_08
USE MODI_DEFAULT_LAI_ECO2_Y2002_09
USE MODI_DEFAULT_LAI_ECO2_Y2002_10
USE MODI_DEFAULT_LAI_ECO2_Y2002_11
USE MODI_DEFAULT_LAI_ECO2_Y2002_12
USE MODI_DEFAULT_LAI_ECO2_Y2002_13
USE MODI_DEFAULT_LAI_ECO2_Y2002_14
USE MODI_DEFAULT_LAI_ECO2_Y2002_15
USE MODI_DEFAULT_LAI_ECO2_Y2002_16
USE MODI_DEFAULT_LAI_ECO2_Y2002_17
USE MODI_DEFAULT_LAI_ECO2_Y2002_18
USE MODI_DEFAULT_LAI_ECO2_Y2002_19
!
USE MODI_DEFAULT_LAI_ECO2_Y2003_01
USE MODI_DEFAULT_LAI_ECO2_Y2003_02
USE MODI_DEFAULT_LAI_ECO2_Y2003_03
USE MODI_DEFAULT_LAI_ECO2_Y2003_04
USE MODI_DEFAULT_LAI_ECO2_Y2003_05
USE MODI_DEFAULT_LAI_ECO2_Y2003_06
USE MODI_DEFAULT_LAI_ECO2_Y2003_07
USE MODI_DEFAULT_LAI_ECO2_Y2003_08
USE MODI_DEFAULT_LAI_ECO2_Y2003_09
USE MODI_DEFAULT_LAI_ECO2_Y2003_10
USE MODI_DEFAULT_LAI_ECO2_Y2003_11
USE MODI_DEFAULT_LAI_ECO2_Y2003_12
USE MODI_DEFAULT_LAI_ECO2_Y2003_13
USE MODI_DEFAULT_LAI_ECO2_Y2003_14
USE MODI_DEFAULT_LAI_ECO2_Y2003_15
USE MODI_DEFAULT_LAI_ECO2_Y2003_16
USE MODI_DEFAULT_LAI_ECO2_Y2003_17
USE MODI_DEFAULT_LAI_ECO2_Y2003_18
USE MODI_DEFAULT_LAI_ECO2_Y2003_19
!
USE MODI_DEFAULT_LAI_ECO2_Y2004_01
USE MODI_DEFAULT_LAI_ECO2_Y2004_02
USE MODI_DEFAULT_LAI_ECO2_Y2004_03
USE MODI_DEFAULT_LAI_ECO2_Y2004_04
USE MODI_DEFAULT_LAI_ECO2_Y2004_05
USE MODI_DEFAULT_LAI_ECO2_Y2004_06
USE MODI_DEFAULT_LAI_ECO2_Y2004_07
USE MODI_DEFAULT_LAI_ECO2_Y2004_08
USE MODI_DEFAULT_LAI_ECO2_Y2004_09
USE MODI_DEFAULT_LAI_ECO2_Y2004_10
USE MODI_DEFAULT_LAI_ECO2_Y2004_11
USE MODI_DEFAULT_LAI_ECO2_Y2004_12
USE MODI_DEFAULT_LAI_ECO2_Y2004_13
USE MODI_DEFAULT_LAI_ECO2_Y2004_14
USE MODI_DEFAULT_LAI_ECO2_Y2004_15
USE MODI_DEFAULT_LAI_ECO2_Y2004_16
USE MODI_DEFAULT_LAI_ECO2_Y2004_17
USE MODI_DEFAULT_LAI_ECO2_Y2004_18
USE MODI_DEFAULT_LAI_ECO2_Y2004_19
!
USE MODI_DEFAULT_LAI_ECO2_Y2005_01
USE MODI_DEFAULT_LAI_ECO2_Y2005_02
USE MODI_DEFAULT_LAI_ECO2_Y2005_03
USE MODI_DEFAULT_LAI_ECO2_Y2005_04
USE MODI_DEFAULT_LAI_ECO2_Y2005_05
USE MODI_DEFAULT_LAI_ECO2_Y2005_06
USE MODI_DEFAULT_LAI_ECO2_Y2005_07
USE MODI_DEFAULT_LAI_ECO2_Y2005_08
USE MODI_DEFAULT_LAI_ECO2_Y2005_09
USE MODI_DEFAULT_LAI_ECO2_Y2005_10
USE MODI_DEFAULT_LAI_ECO2_Y2005_11
USE MODI_DEFAULT_LAI_ECO2_Y2005_12
USE MODI_DEFAULT_LAI_ECO2_Y2005_13
USE MODI_DEFAULT_LAI_ECO2_Y2005_14
USE MODI_DEFAULT_LAI_ECO2_Y2005_15
USE MODI_DEFAULT_LAI_ECO2_Y2005_16
USE MODI_DEFAULT_LAI_ECO2_Y2005_17
USE MODI_DEFAULT_LAI_ECO2_Y2005_18
USE MODI_DEFAULT_LAI_ECO2_Y2005_19
!
USE MODI_DEFAULT_LAI_ECO2_Y2006_01
USE MODI_DEFAULT_LAI_ECO2_Y2006_02
USE MODI_DEFAULT_LAI_ECO2_Y2006_03
USE MODI_DEFAULT_LAI_ECO2_Y2006_04
USE MODI_DEFAULT_LAI_ECO2_Y2006_05
USE MODI_DEFAULT_LAI_ECO2_Y2006_06
USE MODI_DEFAULT_LAI_ECO2_Y2006_07
USE MODI_DEFAULT_LAI_ECO2_Y2006_08
USE MODI_DEFAULT_LAI_ECO2_Y2006_09
USE MODI_DEFAULT_LAI_ECO2_Y2006_10
USE MODI_DEFAULT_LAI_ECO2_Y2006_11
USE MODI_DEFAULT_LAI_ECO2_Y2006_12
USE MODI_DEFAULT_LAI_ECO2_Y2006_13
USE MODI_DEFAULT_LAI_ECO2_Y2006_14
USE MODI_DEFAULT_LAI_ECO2_Y2006_15
USE MODI_DEFAULT_LAI_ECO2_Y2006_16
USE MODI_DEFAULT_LAI_ECO2_Y2006_17
USE MODI_DEFAULT_LAI_ECO2_Y2006_18
USE MODI_DEFAULT_LAI_ECO2_Y2006_19
!
USE MODI_DEFAULT_LAI_ECO1_01
USE MODI_DEFAULT_LAI_ECO1_02
USE MODI_DEFAULT_LAI_ECO1_03
USE MODI_DEFAULT_LAI_ECO1_04
USE MODI_DEFAULT_LAI_ECO1_05
USE MODI_DEFAULT_LAI_ECO1_06
USE MODI_DEFAULT_LAI_ECO1_07
USE MODI_DEFAULT_LAI_ECO1_08
USE MODI_DEFAULT_LAI_ECO1_09
USE MODI_DEFAULT_LAI_ECO1_10
USE MODI_DEFAULT_LAI_ECO1_11
USE MODI_DEFAULT_LAI_ECO1_12
USE MODI_DEFAULT_LAI_ECO1_13
USE MODI_DEFAULT_LAI_ECO1_14
USE MODI_DEFAULT_LAI_ECO1_15
USE MODI_DEFAULT_LAI_ECO1_16
USE MODI_DEFAULT_LAI_ECO1_17
USE MODI_DEFAULT_LAI_ECO1_18
USE MODI_DEFAULT_LAI_ECO1_19
!
USE MODI_ECOCLIMAP2_LAI
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
!
 CHARACTER(LEN=*), INTENT(IN) :: HALBEDO
 CHARACTER(LEN=*),       INTENT(IN)    :: HISBA   ! type of soil (Force-Restore OR Diffusion)
 LOGICAL, INTENT(IN) :: OTR_ML
INTEGER,                INTENT(IN)    :: KDECADE
REAL, DIMENSION(:,:),   INTENT(IN)    :: PCOVER
LOGICAL, DIMENSION(:), INTENT(IN)     :: OCOVER
 CHARACTER(LEN=*),       INTENT(IN)    :: HPHOTO  ! type of photosynthesis
 CHARACTER(LEN=*),       INTENT(IN)    :: HSFTYPE ! nature / garden
!
REAL, DIMENSION(:)  ,   OPTIONAL, INTENT(IN)    :: PSOILGRID
REAL, DIMENSION(:)  ,   OPTIONAL, INTENT(IN)    :: PPERM
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PVEG
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PLAI
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PRSMIN
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PGAMMA
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PWRMAX_CF
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PRGL
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PCV
REAL, DIMENSION(:,:,:), OPTIONAL, INTENT(OUT)   :: PDG
INTEGER, DIMENSION(:,:),OPTIONAL, INTENT(OUT)   :: KWG_LAYER
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PDROOT
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PDG2
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PD_ICE
REAL, DIMENSION(:,:,:), OPTIONAL, INTENT(OUT)   :: PROOTFRAC
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PZ0
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PZ0_O_Z0H
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PALBNIR_VEG
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PALBVIS_VEG
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PALBUV_VEG
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PEMIS_ECO
!
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PGNDLITTER
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PZ0LITTER
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PH_VEG
!
REAL, DIMENSION(:,:), OPTIONAL, INTENT(OUT)   :: PVEGTYPE
!
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PGMES
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PRE25
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PBSLAI
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PLAIMIN
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PSEFOLD
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PGC
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PDMAX
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PF2I
LOGICAL, DIMENSION(:,:),OPTIONAL, INTENT(OUT)   :: OSTRESS
!
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PH_TREE
!
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PCE_NITRO
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PCF_NITRO
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PCNA_NITRO
!
TYPE(DATE_TIME), DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: TPSEED
TYPE(DATE_TIME), DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: TPREAP
!
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PWATSUP
REAL, DIMENSION(:,:),   OPTIONAL, INTENT(OUT)   :: PIRRIG
!
LOGICAL, OPTIONAL, INTENT(IN) :: OWATER_TO_NATURE
LOGICAL, OPTIONAL, INTENT(IN) :: OTOWN_TO_ROCK
LOGICAL, OPTIONAL, INTENT(IN) :: OGARDEN
!
!*    0.2    Declaration of local variables
!            ------------------------------
! calculation of veg from lai in the pixel
!
TYPE(DATA_COVER_t) :: YDTCO
!
REAL, DIMENSION (:,:), ALLOCATABLE           :: ZWORK      ! work array
REAL, DIMENSION(:,:,:), ALLOCATABLE :: ZDATA_VEG, ZDATA_LAI, ZDATA_LAI_ALL_YEARS
REAL, DIMENSION(:,:), ALLOCATABLE :: ZDATA_VEGTYPE
!
REAL, DIMENSION (SIZE(OCOVER),NVEGTYPE) :: ZDATA_GROUND_DEPTH, ZDATA_ROOT_DEPTH,  &
                                           ZDATA_ROOT_LIN, ZDATA_ROOT_EXTINCTION
REAL, DIMENSION (SIZE(OCOVER),3,NVEGTYPE) :: ZDATA_DG
!
 CHARACTER(LEN=3)  :: YTREE, YNAT, YLAI, YVEG, YDIF
!
LOGICAL :: GWATER_TO_NATURE, GTOWN_TO_ROCK, GGARDEN
INTEGER :: JLAYER ! loop counter on surface layers
INTEGER :: JVEG, JP   ! loop counter on vegetation types
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
!*    2.      SECONDARY VARIABLES
!             -------------------
!
IF (LHOOK) CALL DR_HOOK('CONVERT_COVER_ISBA',0,ZHOOK_HANDLE)
!
GWATER_TO_NATURE = .FALSE.
GTOWN_TO_ROCK = .FALSE.
IF (PRESENT(OWATER_TO_NATURE)) GWATER_TO_NATURE = OWATER_TO_NATURE
IF (PRESENT(OTOWN_TO_ROCK)) GTOWN_TO_ROCK = OTOWN_TO_ROCK
IF (PRESENT(OGARDEN)) GGARDEN = OGARDEN
!
IF (ASSOCIATED(DTCO%XDATA_WEIGHT)) DEALLOCATE(DTCO%XDATA_WEIGHT)
!
IF (HSFTYPE=='NAT') THEN
  YNAT='NAT'
  YTREE='TRE'
  YLAI='LAI'
  YVEG='VEG'
  YDIF='DVG'
ELSEIF (HSFTYPE=='GRD'.OR.HSFTYPE=='GD'.OR.HSFTYPE=='GR') THEN
  YNAT='GRD'
  YTREE='GRT'
  YLAI='GRL'
  YVEG='GRV'
  YDIF='GDV'
ENDIF
!
 CALL DATA_COVER_INIT(YDTCO)
ALLOCATE(YDTCO%XDATA_VEGTYPE(SIZE(OCOVER),NVEGTYPE))
ALLOCATE(YDTCO%XDATA_NATURE(SIZE(OCOVER)))
ALLOCATE(YDTCO%XDATA_GARDEN(SIZE(OCOVER)))
ALLOCATE(YDTCO%XDATA_TOWN  (SIZE(OCOVER)))
!
! if we run with ECOSG, and the init file was done with ECOCLIMAP
IF (SIZE(OCOVER)/=SIZE(XDATA_GROUND_DEPTH,1)) THEN

  ALLOCATE(YDTCO%XDATA_WATER (SIZE(OCOVER)))
  CALL DEFAULT_DATA_COVER(PDATA_VEGTYPE=YDTCO%XDATA_VEGTYPE, &
                          PDATA_NATURE=YDTCO%XDATA_NATURE,PDATA_WATER=YDTCO%XDATA_WATER,&
                          PDATA_TOWN=YDTCO%XDATA_TOWN,PDATA_GARDEN=YDTCO%XDATA_GARDEN,&
                          PDATA_GROUND_DEPTH=ZDATA_GROUND_DEPTH,&
                          PDATA_ROOT_DEPTH=ZDATA_ROOT_DEPTH)

  IF (GWATER_TO_NATURE) THEN
    WHERE(YDTCO%XDATA_WATER(:)<1.) YDTCO%XDATA_NATURE(:) = YDTCO%XDATA_NATURE(:) + YDTCO%XDATA_WATER(:)
  ENDIF

  ! save current values for these arrays
  ALLOCATE(ZDATA_LAI_ALL_YEARS(SIZE(XDATA_LAI_ALL_YEARS,1),SIZE(XDATA_LAI_ALL_YEARS,2),SIZE(XDATA_LAI_ALL_YEARS,3)))
  ALLOCATE(ZDATA_VEGTYPE(SIZE(XDATA_VEGTYPE,1),SIZE(XDATA_VEGTYPE,2)))
  ALLOCATE(ZDATA_VEG(SIZE(XDATA_VEG,1),SIZE(XDATA_VEG,2),SIZE(XDATA_VEG,3)))
  ALLOCATE(ZDATA_LAI(SIZE(XDATA_LAI,1),SIZE(XDATA_LAI,2),SIZE(XDATA_LAI,3)))
  ZDATA_LAI_ALL_YEARS(:,:,:) = XDATA_LAI_ALL_YEARS(:,:,:)
  ZDATA_VEGTYPE(:,:) = XDATA_VEGTYPE(:,:)
  ZDATA_VEG(:,:,:) = XDATA_VEG(:,:,:)
  ZDATA_LAI(:,:,:) = XDATA_LAI(:,:,:)

  DEALLOCATE(XDATA_VEG,XDATA_LAI,XDATA_LAI_ALL_YEARS,XDATA_VEGTYPE)

  ! re-allocate official arrays
  ALLOCATE(XDATA_VEGTYPE(SIZE(YDTCO%XDATA_VEGTYPE,1),SIZE(YDTCO%XDATA_VEGTYPE,2)))
  ALLOCATE(XDATA_VEG(SIZE(OCOVER),36,NVEGTYPE))
  ALLOCATE(XDATA_LAI(SIZE(OCOVER),36,NVEGTYPE))
  ALLOCATE(XDATA_LAI_ALL_YEARS(SIZE(OCOVER),36*5,NVEGTYPE))
  ! xdata_vegtype is used by DEFAULT_LAI....
  XDATA_VEGTYPE(:,:) = YDTCO%XDATA_VEGTYPE
!
  CALL DEFAULT_LAI_ECO1_01
  CALL DEFAULT_LAI_ECO1_02
  CALL DEFAULT_LAI_ECO1_03
  CALL DEFAULT_LAI_ECO1_04
  CALL DEFAULT_LAI_ECO1_05
  CALL DEFAULT_LAI_ECO1_06
  CALL DEFAULT_LAI_ECO1_07
  CALL DEFAULT_LAI_ECO1_08
  CALL DEFAULT_LAI_ECO1_09
  CALL DEFAULT_LAI_ECO1_10
  CALL DEFAULT_LAI_ECO1_11
  CALL DEFAULT_LAI_ECO1_12
  CALL DEFAULT_LAI_ECO1_13
  CALL DEFAULT_LAI_ECO1_14
  CALL DEFAULT_LAI_ECO1_15
  CALL DEFAULT_LAI_ECO1_16
  CALL DEFAULT_LAI_ECO1_17
  CALL DEFAULT_LAI_ECO1_18
  CALL DEFAULT_LAI_ECO1_19

  CALL DEFAULT_LAI_ECO2_Y2002_01
  CALL DEFAULT_LAI_ECO2_Y2002_02
  CALL DEFAULT_LAI_ECO2_Y2002_03
  CALL DEFAULT_LAI_ECO2_Y2002_04
  CALL DEFAULT_LAI_ECO2_Y2002_05
  CALL DEFAULT_LAI_ECO2_Y2002_06
  CALL DEFAULT_LAI_ECO2_Y2002_07
  CALL DEFAULT_LAI_ECO2_Y2002_08
  CALL DEFAULT_LAI_ECO2_Y2002_09
  CALL DEFAULT_LAI_ECO2_Y2002_10
  CALL DEFAULT_LAI_ECO2_Y2002_11
  CALL DEFAULT_LAI_ECO2_Y2002_12
  CALL DEFAULT_LAI_ECO2_Y2002_13
  CALL DEFAULT_LAI_ECO2_Y2002_14
  CALL DEFAULT_LAI_ECO2_Y2002_15
  CALL DEFAULT_LAI_ECO2_Y2002_16
  CALL DEFAULT_LAI_ECO2_Y2002_17
  CALL DEFAULT_LAI_ECO2_Y2002_18
  CALL DEFAULT_LAI_ECO2_Y2002_19
!
  CALL DEFAULT_LAI_ECO2_Y2003_01
  CALL DEFAULT_LAI_ECO2_Y2003_02
  CALL DEFAULT_LAI_ECO2_Y2003_03
  CALL DEFAULT_LAI_ECO2_Y2003_04
  CALL DEFAULT_LAI_ECO2_Y2003_05
  CALL DEFAULT_LAI_ECO2_Y2003_06
  CALL DEFAULT_LAI_ECO2_Y2003_07
  CALL DEFAULT_LAI_ECO2_Y2003_08
  CALL DEFAULT_LAI_ECO2_Y2003_09
  CALL DEFAULT_LAI_ECO2_Y2003_10
  CALL DEFAULT_LAI_ECO2_Y2003_11
  CALL DEFAULT_LAI_ECO2_Y2003_12
  CALL DEFAULT_LAI_ECO2_Y2003_13
  CALL DEFAULT_LAI_ECO2_Y2003_14
  CALL DEFAULT_LAI_ECO2_Y2003_15
  CALL DEFAULT_LAI_ECO2_Y2003_16
  CALL DEFAULT_LAI_ECO2_Y2003_17
  CALL DEFAULT_LAI_ECO2_Y2003_18
  CALL DEFAULT_LAI_ECO2_Y2003_19
!
  CALL DEFAULT_LAI_ECO2_Y2004_01
  CALL DEFAULT_LAI_ECO2_Y2004_02
  CALL DEFAULT_LAI_ECO2_Y2004_03
  CALL DEFAULT_LAI_ECO2_Y2004_04
  CALL DEFAULT_LAI_ECO2_Y2004_05
  CALL DEFAULT_LAI_ECO2_Y2004_06
  CALL DEFAULT_LAI_ECO2_Y2004_07
  CALL DEFAULT_LAI_ECO2_Y2004_08
  CALL DEFAULT_LAI_ECO2_Y2004_09
  CALL DEFAULT_LAI_ECO2_Y2004_10
  CALL DEFAULT_LAI_ECO2_Y2004_11
  CALL DEFAULT_LAI_ECO2_Y2004_12
  CALL DEFAULT_LAI_ECO2_Y2004_13
  CALL DEFAULT_LAI_ECO2_Y2004_14
  CALL DEFAULT_LAI_ECO2_Y2004_15
  CALL DEFAULT_LAI_ECO2_Y2004_16
  CALL DEFAULT_LAI_ECO2_Y2004_17
  CALL DEFAULT_LAI_ECO2_Y2004_18
  CALL DEFAULT_LAI_ECO2_Y2004_19
!
  CALL DEFAULT_LAI_ECO2_Y2005_01
  CALL DEFAULT_LAI_ECO2_Y2005_02
  CALL DEFAULT_LAI_ECO2_Y2005_03
  CALL DEFAULT_LAI_ECO2_Y2005_04
  CALL DEFAULT_LAI_ECO2_Y2005_05
  CALL DEFAULT_LAI_ECO2_Y2005_06
  CALL DEFAULT_LAI_ECO2_Y2005_07
  CALL DEFAULT_LAI_ECO2_Y2005_08
  CALL DEFAULT_LAI_ECO2_Y2005_09
  CALL DEFAULT_LAI_ECO2_Y2005_10
  CALL DEFAULT_LAI_ECO2_Y2005_11
  CALL DEFAULT_LAI_ECO2_Y2005_12
  CALL DEFAULT_LAI_ECO2_Y2005_13
  CALL DEFAULT_LAI_ECO2_Y2005_14
  CALL DEFAULT_LAI_ECO2_Y2005_15
  CALL DEFAULT_LAI_ECO2_Y2005_16
  CALL DEFAULT_LAI_ECO2_Y2005_17
  CALL DEFAULT_LAI_ECO2_Y2005_18
  CALL DEFAULT_LAI_ECO2_Y2005_19
!
  CALL DEFAULT_LAI_ECO2_Y2006_01
  CALL DEFAULT_LAI_ECO2_Y2006_02
  CALL DEFAULT_LAI_ECO2_Y2006_03
  CALL DEFAULT_LAI_ECO2_Y2006_04
  CALL DEFAULT_LAI_ECO2_Y2006_05
  CALL DEFAULT_LAI_ECO2_Y2006_06
  CALL DEFAULT_LAI_ECO2_Y2006_07
  CALL DEFAULT_LAI_ECO2_Y2006_08
  CALL DEFAULT_LAI_ECO2_Y2006_09
  CALL DEFAULT_LAI_ECO2_Y2006_10
  CALL DEFAULT_LAI_ECO2_Y2006_11
  CALL DEFAULT_LAI_ECO2_Y2006_12
  CALL DEFAULT_LAI_ECO2_Y2006_13
  CALL DEFAULT_LAI_ECO2_Y2006_14
  CALL DEFAULT_LAI_ECO2_Y2006_15
  CALL DEFAULT_LAI_ECO2_Y2006_16
  CALL DEFAULT_LAI_ECO2_Y2006_17
  CALL DEFAULT_LAI_ECO2_Y2006_18
  CALL DEFAULT_LAI_ECO2_Y2006_19

  NVT_C3W  = 0
  NVT_C3S  = 0
  NVT_FLTR = 0
  NVT_FLGR = 0
  NVT_NO   = 1   ! 1  ! no vegetation (smooth)
  NVT_ROCK = 2   ! 2  ! no vegetation (rocks)
  NVT_SNOW = 3   ! 3  ! permanent snow and ice
  NVT_TEBD = 4   ! 4  ! temperate broadleaf cold-deciduous summergreen (TREE)
  NVT_BONE = 5   ! 5  ! boreal needleleaf evergreen  (CONI)
  NVT_TRBE = 6   ! 6  ! tropical broadleaf evergreen (EVER)
  NVT_C3   = 7   ! 7  ! C3 cultures types
  NVT_C4   = 8   ! 8  ! C4 cultures types
  NVT_IRR  = 9   ! 9  ! irrigated crops
  NVT_GRAS =10   !10  ! grassland
  NVT_TROG =11   !11  ! tropical grassland
  NVT_PARK =12   !12  ! peat bogs, parks and gardens (irrigated grass)
  NVT_TRBD =13   ! 4  ! tropical broadleaf deciduous (TREE)
  NVT_TEBE =14   ! 4  ! temperate broadleaf evergreen (TREE)
  NVT_TENE =15   ! 5  ! temperate needleleaf evergreen (CONI)
  NVT_BOBD =16   ! 4  ! boreal broadleaf cold-deciduous summergreen (TREE)
  NVT_BOND =17   ! 5  ! boreal needleleaf cold-deciduous summergreen (CONI)
  NVT_BOGR =18   !10  ! boreal grass (GRAS)
  NVT_SHRB =19   ! 4  ! shrub (TREE)

  ! calculate XDATA_LAI
  CALL ECOCLIMAP2_LAI(DTCO%NYEAR)

  ! no more needed
  DEALLOCATE(XDATA_LAI_ALL_YEARS,XDATA_VEGTYPE)
  ! we give back their values to data_lai_all_years dans data_vegtype
  ALLOCATE(XDATA_LAI_ALL_YEARS(SIZE(ZDATA_LAI_ALL_YEARS,1),SIZE(ZDATA_LAI_ALL_YEARS,2),SIZE(ZDATA_LAI_ALL_YEARS,3)))
  ALLOCATE(XDATA_VEGTYPE(SIZE(ZDATA_VEGTYPE,1),SIZE(ZDATA_VEGTYPE,2)))
  XDATA_LAI_ALL_YEARS(:,:,:) = ZDATA_LAI_ALL_YEARS(:,:,:)
  XDATA_VEGTYPE(:,:) = ZDATA_VEGTYPE(:,:)
  DEALLOCATE(ZDATA_LAI_ALL_YEARS,ZDATA_VEGTYPE)
  ! calculated XDATA_VEG
  CALL INI_DATA_PARAM(PROOT_LIN=ZDATA_ROOT_LIN,PROOT_EXTINCTION=ZDATA_ROOT_EXTINCTION, &
                      PLAI=XDATA_LAI,PVEG_OUT=XDATA_VEG)

ELSE
  YDTCO%XDATA_VEGTYPE(:,:) = DTCO%XDATA_VEGTYPE(:,:)
  YDTCO%XDATA_NATURE(:) = DTCO%XDATA_NATURE(:)
  YDTCO%XDATA_TOWN(:) = DTCO%XDATA_TOWN(:)
  YDTCO%XDATA_GARDEN(:) = DTCO%XDATA_GARDEN(:)
  ZDATA_GROUND_DEPTH(:,:) = XDATA_GROUND_DEPTH(:,:)
  ZDATA_ROOT_DEPTH  (:,:) = XDATA_ROOT_DEPTH  (:,:)
  ZDATA_ROOT_LIN    (:,:) = XDATA_ROOT_LIN    (:,:)
  ZDATA_ROOT_EXTINCTION(:,:) = XDATA_ROOT_EXTINCTION(:,:)
ENDIF
!
!*    2.1     fields on natural surfaces only, taking into account patches/ 
!             -------------------------------
!
!
! Leaf Aera Index
! ---------------
!
IF (PRESENT(PLAI)) THEN
  CALL AV_PGD(YDTCO, PLAI ,PCOVER ,XDATA_LAI (:,KDECADE,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)
ENDIF
!
!* 1/Rsmin
!
IF (PRESENT(PRSMIN)) THEN
  IF (SIZE(PRSMIN)>0) CALL AV_PGD(YDTCO, PRSMIN,PCOVER ,XDATA_RSMIN,YLAI,'INV',OCOVER,KDECADE=KDECADE)  
END IF
!
IF (PRESENT(PH_TREE)) CALL AV_PGD(YDTCO, PH_TREE ,PCOVER ,XDATA_H_TREE (:,:) ,YTREE,'ARI',OCOVER)  
!
DO JVEG=1,NVEGTYPE
  IF (PRESENT(PVEGTYPE)) CALL AV_PGD(YDTCO, PVEGTYPE(:,JVEG),PCOVER ,YDTCO%XDATA_VEGTYPE(:,JVEG),YNAT,'ARI',OCOVER)  
END DO
!
!
! vegetation fraction
! -------------------
!
IF (PRESENT(PVEG)) CALL AV_PGD(YDTCO, PVEG ,PCOVER ,XDATA_VEG (:,KDECADE,:),YNAT,'ARI',OCOVER)  
!
!
IF (PRESENT(PGNDLITTER)) CALL AV_PGD(YDTCO, PGNDLITTER ,PCOVER ,XDATA_GNDLITTER (:,KDECADE,:),YNAT,'ARI',OCOVER)
!
! roughness length
! ----------------
!
IF (PRESENT(PZ0)) CALL AV_PGD(YDTCO, PZ0 ,PCOVER ,XDATA_Z0 (:,KDECADE,:),YNAT,'CDN',OCOVER)  
!
IF (PRESENT(PZ0_O_Z0H)) CALL AV_PGD(YDTCO, PZ0_O_Z0H ,PCOVER ,XDATA_Z0_O_Z0H (:,:),YNAT,'ARI',OCOVER)  
!
IF (PRESENT(PZ0LITTER)) CALL AV_PGD(YDTCO, PZ0LITTER ,PCOVER ,XDATA_Z0LITTER (:,KDECADE,:),YNAT,'CDN',OCOVER) 
!
!emis-eco
!--------
!
IF (PRESENT(PEMIS_ECO)) CALL AV_PGD(YDTCO, PEMIS_ECO ,PCOVER ,XDATA_EMIS_ECO (:,KDECADE,:),YNAT,'ARI',OCOVER)  
! 
!---------------------------------------------------------------------------------
!
!* other vegetation parameters
!
IF (PRESENT(PGAMMA)) CALL AV_PGD(YDTCO, PGAMMA     ,PCOVER ,XDATA_GAMMA   (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
!
IF (PRESENT(PWRMAX_CF)) CALL AV_PGD(YDTCO, PWRMAX_CF  ,PCOVER ,XDATA_WRMAX_CF(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)
!
IF (PRESENT(PRGL)) CALL AV_PGD(YDTCO, PRGL       ,PCOVER ,XDATA_RGL   (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)        
IF (PRESENT(PCV)) CALL AV_PGD(YDTCO, PCV        ,PCOVER ,XDATA_CV    (:,:),YVEG,'INV',OCOVER,KDECADE=KDECADE)  
!
IF (PRESENT(PH_VEG)) THEN
 CALL AV_PGD(YDTCO, PH_VEG,PCOVER,XDATA_H_VEG(:,KDECADE,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE) 
ENDIF
!

!
!---------------------------------------------------------------------------------
!
!* soil layers
!  -----------
!
IF (PRESENT(PDG)) THEN
!
!* soil layers (and cumulative root fraction for DIF only)
!
  CALL SET_COVER_DG(SIZE(PDG,1),SIZE(PDG,2),SIZE(PDG,3),PRESENT(PPERM),&
                   PRESENT(PDG2),PRESENT(PDROOT),PRESENT(KWG_LAYER),   &
                   PRESENT(PROOTFRAC)          )
!
END IF
!
!---------------------------------------------------------------------------------
!
!* soil ice for runoff
!  -------------------
!
IF (PRESENT(PD_ICE)) CALL AV_PGD(YDTCO, PD_ICE,PCOVER ,XDATA_DICE(:,:),YNAT,'ARI',OCOVER)
!
!---------------------------------------------------------------------------------
!
IF (PRESENT(PALBNIR_VEG)) THEN
  IF (HALBEDO=='CM13') THEN
    CALL AV_PGD(YDTCO, PALBVIS_VEG,PCOVER,XDATA_ALB_VEG_NIR(:,KDECADE,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)      
  ELSE   
    CALL AV_PGD(YDTCO, PALBNIR_VEG,PCOVER ,XDATA_ALBNIR_VEG(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
  ENDIF
ENDIF
!
IF (PRESENT(PALBVIS_VEG)) THEN
  IF (HALBEDO=='CM13') THEN
    CALL AV_PGD(YDTCO, PALBVIS_VEG,PCOVER,XDATA_ALB_VEG_VIS(:,KDECADE,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)      
  ELSE     
    CALL AV_PGD(YDTCO, PALBVIS_VEG,PCOVER ,XDATA_ALBVIS_VEG(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
  ENDIF
ENDIF
!
IF (PRESENT(PALBUV_VEG)) THEN
  IF ((HALBEDO=='CM13'.OR.OTR_ML).AND.PRESENT(PALBVIS_VEG)) THEN
    PALBUV_VEG(:,:)=PALBVIS_VEG(:,:)
  ELSE
    CALL AV_PGD(YDTCO, PALBUV_VEG, PCOVER ,XDATA_ALBUV_VEG (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)
  ENDIF
ENDIF
!  
! parameters for "stress option"
IF (HPHOTO /='NON' )  THEN

   IF (PRESENT(PGMES)) THEN
     IF (SIZE(PGMES)>0) CALL AV_PGD(YDTCO, PGMES  ,PCOVER ,XDATA_GMES_ST  (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF

   IF (PRESENT(PBSLAI)) THEN
     IF (SIZE(PBSLAI)>0) CALL AV_PGD(YDTCO, PBSLAI ,PCOVER ,XDATA_BSLAI_ST (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF

   IF (PRESENT(PSEFOLD)) THEN
     IF (SIZE(PSEFOLD)>0) CALL AV_PGD(YDTCO, PSEFOLD,PCOVER ,XDATA_SEFOLD_ST(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF

   IF (PRESENT(PGC)) THEN
     IF (SIZE(PGC)>0) CALL AV_PGD(YDTCO, PGC    ,PCOVER ,XDATA_GC_ST    (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF

   IF (PRESENT(PDMAX)) THEN
     IF (SIZE(PDMAX)>0) CALL AV_PGD(YDTCO, PDMAX  ,PCOVER ,XDATA_DMAX_ST  (:,:),YTREE,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF

ELSE
   IF (PRESENT(PGMES)) THEN
     IF (SIZE(PGMES)>0) CALL AV_PGD(YDTCO, PGMES  ,PCOVER ,XDATA_GMES  (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF
   IF (PRESENT(PBSLAI)) THEN
     IF (SIZE(PBSLAI)>0) CALL AV_PGD(YDTCO, PBSLAI ,PCOVER ,XDATA_BSLAI (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF
   IF (PRESENT(PSEFOLD)) THEN
     IF (SIZE(PSEFOLD)>0) CALL AV_PGD(YDTCO, PSEFOLD,PCOVER ,XDATA_SEFOLD(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF
   IF (PRESENT(PGC)) THEN
     IF (SIZE(PGC)>0) CALL AV_PGD(YDTCO, PGC    ,PCOVER ,XDATA_GC    (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF
   IF (PRESENT(PDMAX)) THEN
     IF (SIZE(PDMAX)>0) CALL AV_PGD(YDTCO, PDMAX  ,PCOVER ,XDATA_DMAX  (:,:),YTREE,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF

ENDIF

IF (PRESENT(PRE25)) THEN
  IF (SIZE(PRE25)>0) CALL AV_PGD(YDTCO, PRE25  ,PCOVER ,XDATA_RE25  (:,:),YNAT,'ARI',OCOVER,KDECADE=KDECADE)  
END IF

IF (PRESENT(PLAIMIN)) THEN
  IF (SIZE(PLAIMIN)>0) CALL AV_PGD(YDTCO, PLAIMIN,PCOVER ,XDATA_LAIMIN(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
END IF
IF (PRESENT(PCE_NITRO)) THEN
  IF (SIZE(PCE_NITRO)>0) &
          CALL AV_PGD(YDTCO, PCE_NITRO  ,PCOVER ,XDATA_CE_NITRO  (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
END IF
IF (PRESENT(PCF_NITRO)) THEN
  IF (SIZE(PCF_NITRO)>0) CALL AV_PGD(YDTCO, PCF_NITRO  ,PCOVER ,XDATA_CF_NITRO  (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
END IF
IF (PRESENT(PCNA_NITRO)) THEN
  IF (SIZE(PCNA_NITRO)>0) CALL AV_PGD(YDTCO, PCNA_NITRO  ,PCOVER ,XDATA_CNA_NITRO(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
END IF
IF (PRESENT(PF2I)) THEN
  IF (SIZE(PF2I)>0) CALL AV_PGD(YDTCO, PF2I   ,PCOVER ,XDATA_F2I   (:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
END IF
!
IF (PRESENT(OSTRESS)) THEN
  IF (SIZE(OSTRESS)>0) THEN
    ALLOCATE(ZWORK(SIZE(OSTRESS,1),SIZE(OSTRESS,2)))
    CALL AV_PGD(YDTCO, ZWORK,PCOVER ,XDATA_STRESS(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)
    WHERE (ZWORK<0.5) 
      OSTRESS = .FALSE.
    ELSEWHERE
      OSTRESS = .TRUE.
    END WHERE
    DEALLOCATE(ZWORK)
  END IF
END IF
!
IF (HPHOTO == 'NIT' .OR. HPHOTO=='NCB')  THEN
   !
   ! date of seeding
   ! ---------------
   !
   IF (PRESENT(TPSEED)) THEN
     IF (SIZE(TPSEED)>0) &
       CALL AV_PGD (TPSEED ,PCOVER ,TDATA_SEED(:,:),YVEG,'MAJ',OCOVER,KDECADE=KDECADE)  
   END IF
   !
   ! date of reaping
   ! ---------------
   !
   IF (PRESENT(TPREAP)) THEN
     IF (SIZE(TPREAP)>0) &
       CALL AV_PGD (TPREAP ,PCOVER ,TDATA_REAP(:,:),YVEG,'MAJ',OCOVER,KDECADE=KDECADE)  
   END IF
   !
   ! fraction of irrigated surface
   ! ---------------------------
   !
   IF (PRESENT(PIRRIG)) THEN
     IF (SIZE(PIRRIG)>0) &
       CALL AV_PGD(YDTCO, PIRRIG ,PCOVER ,XDATA_IRRIG(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF
   !
   ! water supply for irrigation
   ! ---------------------------
   !
   IF (PRESENT(PWATSUP)) THEN
     IF (SIZE(PWATSUP)>0) &
       CALL AV_PGD(YDTCO, PWATSUP ,PCOVER ,XDATA_WATSUP(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE)  
   END IF
!
END IF
!
IF (ASSOCIATED(YDTCO%XDATA_WEIGHT)) DEALLOCATE(YDTCO%XDATA_WEIGHT)
!
! if we run with ECOSG, and the init file was done with ECOCLIMAP
IF (SIZE(OCOVER)/=SIZE(XDATA_GROUND_DEPTH,1)) THEN
  NVT_C3   = 0
  NVT_PARK = 0
  NVT_IRR  = 0
  NVT_NO   = 1   ! 1  ! no vegetation (smooth)
  NVT_ROCK = 2   ! 2  ! no vegetation (rocks)
  NVT_SNOW = 3   ! 3  ! permanent snow and ice
  NVT_BOBD = 4   ! 4  ! boreal broadleaf cold-deciduous summergreen (TREE)
  NVT_TEBD = 5   ! 4  ! temperate broadleaf cold-deciduous summergreen (TREE)
  NVT_TRBD = 6   ! 4  ! tropical broadleaf deciduous (TREE)  
  NVT_TEBE = 7   ! 4  ! temperate broadleaf evergreen (TREE)  
  NVT_TRBE = 8   ! 6  ! tropical broadleaf evergreen (EVER)
  NVT_BONE = 9   ! 5  ! boreal needleleaf evergreen  (CONI)  
  NVT_TENE =10   ! 5  ! temperate needleleaf evergreen (CONI)
  NVT_BOND =11   ! 5  ! boreal needleleaf cold-deciduous summergreen (CONI)  
  NVT_SHRB =12   ! 4  ! shrub (TREE)
  NVT_BOGR =13   !10  ! boreal grass (GRAS)
  NVT_GRAS =14   !10  ! grassland
  NVT_TROG =15   !11  ! tropical grassland 
  NVT_C3W  =16   ! 7  ! C3W cultures types
  NVT_C3S  =17   ! 7  ! C3S cultures types
  NVT_C4   =18   ! 8  ! C4 cultures types
  NVT_FLTR =19   !12  ! flooded trees
  NVT_FLGR =20   !12  ! flooded grassland

  DEALLOCATE(XDATA_VEG,XDATA_LAI)
  ALLOCATE(XDATA_VEG(SIZE(ZDATA_VEG,1),SIZE(ZDATA_VEG,2),SIZE(ZDATA_VEG,3)))
  ALLOCATE(XDATA_LAI(SIZE(ZDATA_LAI,1),SIZE(ZDATA_LAI,2),SIZE(ZDATA_LAI,3)))
  XDATA_VEG(:,:,:) = ZDATA_VEG(:,:,:)
  XDATA_LAI(:,:,:) = ZDATA_LAI(:,:,:)
  DEALLOCATE(ZDATA_LAI,ZDATA_VEG)

ENDIF
!
 CALL DATA_COVER_INIT(YDTCO)
!
IF (LHOOK) CALL DR_HOOK('CONVERT_COVER_ISBA',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
CONTAINS
!-------------------------------------------------------------------------------
!
SUBROUTINE SET_COVER_DG(KNI,KGROUND,KPATCH,LPERM,LDG2,LDROOT,LWG_LAYER,LROOTFRAC )
!
USE MODD_SURF_PAR,       ONLY : XUNDEF, NUNDEF
!
USE MODD_REPROD_OPER,    ONLY : CDGAVG, CDGDIF
!
USE MODI_INI_DATA_ROOTFRAC
USE MODI_INI_DATA_SOIL
USE MODI_PERMAFROST_DEPTH
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KNI
INTEGER, INTENT(IN) :: KGROUND
INTEGER, INTENT(IN) :: KPATCH
LOGICAL, INTENT(IN) :: LPERM
LOGICAL, INTENT(IN) :: LDG2
LOGICAL, INTENT(IN) :: LDROOT
LOGICAL, INTENT(IN) :: LWG_LAYER
LOGICAL, INTENT(IN) :: LROOTFRAC
!
INTEGER, DIMENSION (KNI,KPATCH) :: IWG_LAYER
REAL, DIMENSION (KNI,KPATCH) :: ZDTOT, ZDROOT      !  work array
REAL, DIMENSION (KNI,KPATCH) :: ZROOT_EXT  !        "
REAL, DIMENSION (KNI,KPATCH) :: ZROOT_LIN  !        "
!
INTEGER :: JPATCH, JJ, JVEGTYPE, JP
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('CONVERT_COVER_ISBA:SET_COVER_DG',0,ZHOOK_HANDLE)
!
ZDTOT    (:,:) = XUNDEF
ZDROOT   (:,:) = XUNDEF
ZROOT_EXT(:,:) = XUNDEF
ZROOT_LIN(:,:) = XUNDEF
IWG_LAYER(:,:) = NUNDEF
!
!####################################################################################
!
!CDGAVG : old for reprod = 'ARI' Arithmetic average for all depth 
!         recommended    = 'INV' Harmonic average for all depth (default)
!
!CDGDIF : old for reprod = 'SOIL' d3 soil depth from ecoclimap for isba-df
!         recommended    = 'ROOT' d2 soil depth from ecoclimap for isba-df (default)
!
!####################################################################################
!
IF(HISBA/='DIF')THEN
  !  
  DO JP = 1,SIZE(ZDATA_DG,3)
    CALL INI_DATA_SOIL(HISBA, ZDATA_DG(:,:,JP),                   &
                     PSURF      = YDTCO%XDATA_NATURE,             &
                     PSURF2     = YDTCO%XDATA_GARDEN,             &
                     PROOTDEPTH = ZDATA_ROOT_DEPTH(:,JP),         &
                     PSOILDEPTH = ZDATA_GROUND_DEPTH(:,JP)       )
  ENDDO
  !
  DO JLAYER=1,KGROUND
     CALL AV_PGD(YDTCO, PDG(:,JLAYER,:),PCOVER,ZDATA_DG(:,JLAYER,:),YNAT,CDGAVG,OCOVER,KDECADE=KDECADE)
  ENDDO
  !
ELSE
!
  IF(CDGDIF=='ROOT')THEN
    DO JVEGTYPE=1,NVEGTYPE
       IF(JVEGTYPE==NVT_NO)THEN
          WHERE(ZDATA_GROUND_DEPTH(:,JVEGTYPE)/=XUNDEF)
               ZDATA_GROUND_DEPTH(:,JVEGTYPE) = MIN(1.0,ZDATA_GROUND_DEPTH(:,JVEGTYPE))
          ENDWHERE
       ELSEIF(JVEGTYPE/=NVT_ROCK.AND.JVEGTYPE/=NVT_SNOW)THEN
         ZDATA_GROUND_DEPTH(:,JVEGTYPE) = MAX(1.0,ZDATA_ROOT_DEPTH(:,JVEGTYPE))          
       ELSE
         ZDATA_GROUND_DEPTH(:,JVEGTYPE) = ZDATA_ROOT_DEPTH(:,JVEGTYPE)
       ENDIF
    ENDDO
  ENDIF
!
  CALL AV_PGD(YDTCO, ZDTOT (:,:),PCOVER,ZDATA_GROUND_DEPTH,YNAT,CDGAVG,OCOVER,KDECADE=KDECADE)
!  
! CALCULATION OF GROUND_DEPTH over Permafrost area
  IF(LPERM)THEN
    CALL PERMAFROST_DEPTH(KNI,KPATCH,PPERM,ZDTOT)
  ENDIF
!  
  IF (LDG2) THEN
     IF(CDGDIF=='ROOT')THEN
       CALL AV_PGD(YDTCO, PDG2(:,:),PCOVER,ZDATA_GROUND_DEPTH,YNAT,CDGAVG,OCOVER)
     ELSE
       CALL AV_PGD(YDTCO, PDG2(:,:),PCOVER,ZDATA_ROOT_DEPTH,YNAT,CDGAVG,OCOVER)
     ENDIF
  ENDIF
  IF (LDROOT .OR. LROOTFRAC  .OR. (CDGDIF=='ROOT')) THEN
    CALL AV_PGD(YDTCO, ZDROOT(:,:),PCOVER,ZDATA_ROOT_DEPTH,YDIF,CDGAVG,OCOVER,KDECADE=KDECADE)
    IF (LDROOT) PDROOT(:,:) = ZDROOT(:,:)
    IF (CDGDIF=='ROOT') WHERE(ZDROOT(:,:).NE.XUNDEF) ZDTOT(:,:) = MAX(ZDROOT(:,:),ZDTOT(:,:))
  ENDIF
!
  DO JP = 1,SIZE(PDG,3)
    CALL INI_DATA_SOIL(HISBA, PDG(:,:,JP), PSOILDEPTH=ZDTOT(:,JP), PSOILGRID=PSOILGRID, &
                     KWG_LAYER=IWG_LAYER(:,JP))
  ENDDO
  IF (LWG_LAYER) KWG_LAYER(:,:) = IWG_LAYER(:,:)
!
  IF (LROOTFRAC) THEN
!      
    CALL AV_PGD(YDTCO, ZROOT_LIN(:,:),PCOVER,ZDATA_ROOT_LIN(:,:),YDIF,'ARI',OCOVER,KDECADE=KDECADE)
    IF (LROOTFRAC) THEN
      CALL AV_PGD(YDTCO, ZROOT_EXT(:,:),PCOVER,ZDATA_ROOT_EXTINCTION(:,:),YDIF,'ARI',OCOVER,KDECADE=KDECADE)
      DO JP = 1,SIZE(PDG,3)
        CALL INI_DATA_ROOTFRAC(PDG(:,:,JP),PDROOT(:,JP),ZROOT_EXT(:,JP),ZROOT_LIN(:,JP),PROOTFRAC(:,:,JP))
      ENDDO
    ENDIF
!
  ENDIF
!
ENDIF
!
IF (LHOOK) CALL DR_HOOK('CONVERT_COVER_ISBA:SET_COVER_DG',1,ZHOOK_HANDLE)
END SUBROUTINE SET_COVER_DG
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE CONVERT_COVER_ISBA
