!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     ######
      SUBROUTINE OPEN_FILEIN_OL
!     #######################################################
!!****  *OPEN_FILEIN_OL* - 

USE MODD_SURFEX_MPI, ONLY : NRANK, NPIO
!
USE MODD_OL_FILEID, ONLY : XNETCDF_FILENAME_IN, XID_IN, &
                            XVAR_TO_FILEIN, XID_VARIN 
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE NETCDF
!
IMPLICIT NONE

INTEGER, DIMENSION(:), ALLOCATABLE :: ITEMP
LOGICAL :: LLEXIST
INTEGER :: JFILE,IFILE_ID
INTEGER :: JRET, INB
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!******************************************

IF (LHOOK) CALL DR_HOOK('OPEN_FILEIN_OL',0,ZHOOK_HANDLE)
IF (NRANK==NPIO) THEN
  !
  INB=0
  ALLOCATE(ITEMP(SIZE(XNETCDF_FILENAME_IN)))
  ! 
  DO JFILE=1,SIZE(XNETCDF_FILENAME_IN)
    INQUIRE(FILE=XNETCDF_FILENAME_IN(JFILE),EXIST=LLEXIST)
    IF (LLEXIST) THEN
      JRET=NF90_OPEN(XNETCDF_FILENAME_IN(JFILE),NF90_NOWRITE,IFILE_ID)
      IF (JRET.EQ.NF90_NOERR) THEN
        INB=INB+1
        ITEMP(INB)=IFILE_ID
      ENDIF
    ENDIF
  ENDDO
  !
  ALLOCATE(XID_IN(INB))
  XID_IN=ITEMP(1:INB)
  !
  ALLOCATE(XVAR_TO_FILEIN(0))
  ALLOCATE(XID_VARIN(0))
  !
ENDIF
IF (LHOOK) CALL DR_HOOK('OPEN_FILEIN_OL',1,ZHOOK_HANDLE)

!******************************************

END SUBROUTINE OPEN_FILEIN_OL
