!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
SUBROUTINE OL_WRITE_COORD (HSELECT, HFILE, KFILE_ID, KDDIM, HATT_TITLE, HNAME_DIM, &
                          HUNIT1, HUNIT2, KDIM1, HDATE, PX, PY, PLON, PLAT)
!
USE MODD_DIAG_n, ONLY : DIAG_t
!
USE MODN_IO_OFFLINE,  ONLY : LWRITE_COORD
!
USE MODI_DEF_VAR_NETCDF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE NETCDF
!
IMPLICIT NONE
!
 CHARACTER(LEN=*), DIMENSION(:), INTENT(IN) :: HSELECT
!
 CHARACTER(LEN=50),     INTENT(IN) :: HFILE
INTEGER,               INTENT(IN) :: KFILE_ID
INTEGER, DIMENSION(:), INTENT(IN) :: KDDIM
 CHARACTER(LEN=100), DIMENSION(:), INTENT(IN) :: HATT_TITLE
 CHARACTER(LEN=100), DIMENSION(:), INTENT(IN) :: HNAME_DIM
 CHARACTER(LEN=13) , DIMENSION(:), INTENT(IN) :: HUNIT1, HUNIT2
INTEGER, INTENT(IN) :: KDIM1
 CHARACTER(LEN=40),DIMENSION(:), INTENT(IN) :: HDATE
REAL,DIMENSION(:), INTENT(IN)              :: PX, PY
REAL,DIMENSION(:), OPTIONAL, INTENT(IN)    :: PLON, PLAT
!
REAL, DIMENSION(:,:), ALLOCATABLE :: ZLAT, ZLON
 CHARACTER(LEN=100) :: YNAME1, YNAME2
INTEGER, DIMENSION(:), ALLOCATABLE :: ITEMP
INTEGER :: IVAR_ID, JRET, IDIM2, JJ
INTEGER :: INDIMS, ID1, ID2, ID3, ID4
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('OL_WRITE_COORD',0,ZHOOK_HANDLE)
!
YNAME1 = "longitude"
YNAME2 = "latitude"
IF (PRESENT(PLAT).AND.PRESENT(PLON)) THEN
  ALLOCATE(ZLAT(SIZE(PLAT),1),ZLON(SIZE(PLON),1))
  ZLAT(:,1) = PLAT(:)
  ZLON(:,1) = PLON(:)
ELSE
  ALLOCATE(ZLAT(0,0),ZLON(0,0))
ENDIF
!
ID1 = 0
ID2 = 0
IF ( LWRITE_COORD ) THEN
  !
  IF (SIZE(ZLAT)>0) THEN
    CALL DEF_VAR_NETCDF(HSELECT,KFILE_ID,TRIM(YNAME1),'',KDDIM(1:1),(/'units'/),(/'degree'/),KVAR_ID=ID3)
    CALL DEF_VAR_NETCDF(HSELECT,KFILE_ID,TRIM(YNAME2),'',KDDIM(1:1),(/'units'/),(/'degree'/),KVAR_ID=ID4)
  ELSE  
    CALL DEF_VAR_NETCDF(HSELECT,KFILE_ID,TRIM(HNAME_DIM(2)),'',KDDIM(1:1),HATT_TITLE,HUNIT1,KVAR_ID=ID1)
    CALL DEF_VAR_NETCDF(HSELECT,KFILE_ID,TRIM(HNAME_DIM(3)),'',KDDIM(1:1),HATT_TITLE,HUNIT2,KVAR_ID=ID2)
  ENDIF
  !
ELSEIF (KDIM1.NE.0) THEN
  !
  CALL DEF_VAR_NETCDF(HSELECT,KFILE_ID,TRIM(HNAME_DIM(1)),'',KDDIM(1:1),HATT_TITLE,HUNIT1,KVAR_ID=ID1)
  CALL DEF_VAR_NETCDF(HSELECT,KFILE_ID,TRIM(HNAME_DIM(2)),'',KDDIM(2:2),HATT_TITLE,HUNIT2,KVAR_ID=ID2)
  !
ELSEIF (SIZE(ZLAT)>0) THEN
  CALL DEF_VAR_NETCDF(HSELECT,KFILE_ID,TRIM(YNAME1),'',KDDIM(1:1),(/'units'/),(/'degree'/),KVAR_ID=ID3)
  CALL DEF_VAR_NETCDF(HSELECT,KFILE_ID,TRIM(YNAME2),'',KDDIM(1:1),(/'units'/),(/'degree'/),KVAR_ID=ID4)
ENDIF
!
INDIMS = SIZE(KDDIM)
IF (HNAME_DIM(INDIMS)=='time') CALL DEF_VAR_NETCDF(HSELECT,KFILE_ID,'time','',KDDIM(INDIMS:INDIMS),HATT_TITLE,HDATE)
!
JRET=NF90_ENDDEF(KFILE_ID)
!
IF (ID1/=0 .AND. ID2/=0) THEN
  JRET = NF90_PUT_VAR  (KFILE_ID, ID1, PX)
  JRET = NF90_PUT_VAR  (KFILE_ID, ID2, PY)
ENDIF
!
IF (SIZE(ZLAT)>0) THEN
  JRET = NF90_PUT_VAR  (KFILE_ID, ID3, ZLON)
  JRET = NF90_PUT_VAR  (KFILE_ID, ID4, ZLAT)
ENDIF
!
DEALLOCATE(ZLAT,ZLON)
!
IF (LHOOK) CALL DR_HOOK('OL_WRITE_COORD',1,ZHOOK_HANDLE)
!
END SUBROUTINE OL_WRITE_COORD
