!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
MODULE MODD_OFF_SURFEX_n
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODD_SURFEX_n, ONLY : SURFEX_t
!
USE MODE_MODELN_SURFEX_HANDLER 
!
TYPE(SURFEX_t), ALLOCATABLE, TARGET, SAVE :: YSURF_LIST(:)
TYPE(SURFEX_t), POINTER :: YSC => NULL()
!$OMP THREADPRIVATE(YSC)
!
CONTAINS
!
SUBROUTINE GOTO_MODEL(KMODEL)

INTEGER, INTENT(IN) :: KMODEL
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_OFF_SURFEX_n:GOTO_MODEL",0,ZHOOK_HANDLE)
!
YSC => YSURF_LIST(KMODEL)
ICURRENT_MODEL = KMODEL
!
IF (LHOOK) CALL DR_HOOK("MODD_OFF_SURFEX_n:GOTO_MODEL",1,ZHOOK_HANDLE)
!
END SUBROUTINE GOTO_MODEL
!
SUBROUTINE SURFEX_ALLOC_LIST(KMODEL)
!
USE MODI_SURFEX_ALLOC
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KMODEL
INTEGER :: J
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_OFF_SURFEX_n:SURFEX_ALLOC_LIST",0,ZHOOK_HANDLE)
!
CALL INIT_CURRENT_MODEL_INDEX_SURFEX()
!
ALLOCATE(YSURF_LIST(KMODEL))
!
DO J = 1,KMODEL
  CALL SURFEX_ALLOC(YSURF_LIST(J))
ENDDO
!
IF (LHOOK) CALL DR_HOOK("MODD_OFF_SURFEX_n:SURFEX_ALLOC_LIST",1,ZHOOK_HANDLE)
!
END SUBROUTINE SURFEX_ALLOC_LIST
!
SUBROUTINE SURFEX_DEALLO_LIST
!
USE MODI_SURFEX_DEALLO
!
INTEGER :: J
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_OFF_SURFEX_n:SURFEX_DEALLO_LIST",0,ZHOOK_HANDLE)
!
DO J=1,SIZE(YSURF_LIST)
  CALL SURFEX_DEALLO(YSURF_LIST(J))
ENDDO
!
IF (ASSOCIATED(YSC)) NULLIFY(YSC)
IF (ALLOCATED(YSURF_LIST)) DEALLOCATE(YSURF_LIST)
!
IF (LHOOK) CALL DR_HOOK("MODD_OFF_SURFEX_n:SURFEX_DEALLO_LIST",1,ZHOOK_HANDLE)
!
END SUBROUTINE SURFEX_DEALLO_LIST
!
END MODULE MODD_OFF_SURFEX_n
