!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
SUBROUTINE LOCAL_SLOPE_PARAM(JPINDX1,JPINDX2)

!!                03/14  : M Lafaysse, modifs for optimization and parallelization

USE MODD_SLOPE_EFFECT, ONLY: XZSL,XZS_XY,XSLOPANG,XSLOPAZI,XSURF_TRIANGLE,&
                  XZS_THREAD,XZS_XY_THREAD,XSLOPANG_THREAD,XSLOPAZI_THREAD,XSURF_TRIANGLE_THREAD,&
                  XXHAT,XYHAT,XXHAT_THREAD,XYHAT_THREAD,NNXLOC,NNYLOC,NIXLOC,NIYLOC,&
                  LREVERTGRID,NIX,NIY,NINDX1_X,NINDX2_X,NINDX1_Y,NINDX2_Y

USE MODD_SURFEX_MPI, ONLY : NRANK, NPIO, NPROC, NCOMM, NSIZE, NINDEX, NSIZE_TASK

IMPLICIT NONE

INTEGER,INTENT(IN)::JPINDX1,JPINDX2
INTEGER,SAVE::NINDX1_MPI_OMP,NINDX2_MPI_OMP,IMINMPI
INTEGER::JJ


! Il faut déterminer la position de début  du thread MPI par rapport au ZZS1D_FULL de init_slope_param :
IF (NPROC>1) THEN
  DO JJ=1,SIZE(NINDEX)
    IF(NINDEX(JJ)==NRANK) THEN
      IMINMPI=JJ
      EXIT
    ENDIF
  END DO
ELSE
  IMINMPI=1
END IF

NINDX1_MPI_OMP=IMINMPI+JPINDX1-1
NINDX2_MPI_OMP=IMINMPI+JPINDX2-1


IF (LREVERTGRID) THEN
  NINDX1_X=MOD(NINDX1_MPI_OMP-1,NIX)+1
  NINDX2_X=MOD(NINDX2_MPI_OMP-1,NIX)+3
  NINDX1_Y=NIY-(NINDX2_MPI_OMP-1)/NIX
  NINDX2_Y=NIY-(NINDX1_MPI_OMP-1)/NIX+2
ELSE
  NINDX1_X=MOD(NINDX1_MPI_OMP-1,NIX)+1
  NINDX2_X=MOD(NINDX2_MPI_OMP-1,NIX)+3
  NINDX1_Y=(NINDX1_MPI_OMP-1)/NIX+1
  NINDX2_Y=(NINDX2_MPI_OMP-1)/NIX+3
ENDIF

NNXLOC=NINDX2_X-NINDX1_X+1
NNYLOC=NINDX2_Y-NINDX1_Y+1
NIXLOC=NNXLOC-2
NIYLOC=NNYLOC-2

ALLOCATE(XZS_THREAD(NNXLOC,NNYLOC))
ALLOCATE(XZS_XY_THREAD(NNXLOC,NNYLOC))
ALLOCATE(XSLOPANG_THREAD(NNXLOC,NNYLOC,4))
ALLOCATE(XSLOPAZI_THREAD(NNXLOC,NNYLOC,4))
ALLOCATE(XSURF_TRIANGLE_THREAD(NNXLOC,NNYLOC,4))

ALLOCATE(XXHAT_THREAD(NNXLOC))
ALLOCATE(XYHAT_THREAD(NNYLOC))


XXHAT_THREAD(:)=XXHAT(NINDX1_X:NINDX2_X)
XYHAT_THREAD(:)=XYHAT(NINDX1_Y:NINDX2_Y)

XZS_THREAD=XZSL(NINDX1_X:NINDX2_X,NINDX1_Y:NINDX2_Y)
XZS_XY_THREAD=XZS_XY(NINDX1_X:NINDX2_X,NINDX1_Y:NINDX2_Y)
XSLOPANG_THREAD=XSLOPANG(NINDX1_X:NINDX2_X,NINDX1_Y:NINDX2_Y,:)
XSLOPAZI_THREAD=XSLOPAZI(NINDX1_X:NINDX2_X,NINDX1_Y:NINDX2_Y,:)
XSURF_TRIANGLE_THREAD=XSURF_TRIANGLE(NINDX1_X:NINDX2_X,NINDX1_Y:NINDX2_Y,:)


END SUBROUTINE LOCAL_SLOPE_PARAM
