!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
SUBROUTINE INIT_INDEX_MPI (DTCO, U, UG, GCP, HPROGRAM,HINIT,HALG,PIO_FRAC,OSHADOWS)
!
! 04-2014 : Modifs Matthieu Lafaysse for shadows :
!        * OSHADOWS logical to pass to get_sizes_parallel
!        * disactivate the treatments relative to PIO_FRAC in case of shadows
!        * MPI_BCAST of NIX and NIY
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_GRID_CONF_PROJ_n, ONLY : GRID_CONF_PROJ_t 
!
USE MODD_XIOS, ONLY : LXIOS
!
USE MODD_SFX_OASIS, ONLY : LOASIS
!
USE MODD_SURFEX_MPI, ONLY : NRANK, NPIO, NPROC, NCOMM, NINDEX, NSIZE_TASK, NSIZE, WLOG_MPI, &
                            NREQ, NNUM, NDIM_FULL_INIT
!
USE MODN_IO_OFFLINE, ONLY : LLAND_USE
!
USE MODD_SURF_CONF,       ONLY : CPROGNAME
USE MODD_MASK, ONLY : NMASK_FULL
!
USE MODD_SLOPE_EFFECT, ONLY : NIX,NIY
!
USE MODE_READ_SURF_COV, ONLY : READ_SURF_COV
!
USE MODI_INI_CSTS
USE MODI_PGD_GRID
USE MODI_GET_LUOUT
USE MODI_SET_SURFEX_FILEIN
USE MODI_INIT_IO_SURF_n
USE MODI_READ_SURF
USE MODI_MAKE_CHOICE_ARRAY
USE MODI_READ_GRIDTYPE
USE MODI_END_IO_SURF_n
USE MODI_ABOR1_SFX
USE MODI_GET_SIZES_PARALLEL
USE MODI_GET_ADJACENT_MESHES
USE MODI_INI_DATA_COVER
USE MODI_READ_ARRANGE_COVER
USE MODI_READ_COVER_GARDEN
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(GRID_CONF_PROJ_t),INTENT(INOUT) :: GCP
!
 CHARACTER(LEN=6), INTENT(IN) :: HPROGRAM
 CHARACTER(LEN=3), INTENT(IN) :: HINIT 
 CHARACTER(LEN=4), INTENT(INOUT) :: HALG
REAL, INTENT(IN) :: PIO_FRAC
LOGICAL, INTENT(IN), OPTIONAL :: OSHADOWS
!
INTEGER, DIMENSION(:), ALLOCATABLE :: ILEFT   ! index of left   grid mesh 
INTEGER, DIMENSION(:), ALLOCATABLE :: IRIGHT  ! index of right  grid mesh 
INTEGER, DIMENSION(:), ALLOCATABLE :: ITOP    ! index of top    grid mesh 
INTEGER, DIMENSION(:), ALLOCATABLE :: IBOTTOM ! index of bottom grid mesh
!
INTEGER, DIMENSION(0:NPROC-1) :: INB
LOGICAL :: GSHADOWS, GSPEC
INTEGER, DIMENSION(0:NPROC-1) :: INBPTS
INTEGER :: IRESTE, INRESTE, IRANK, IPROC
INTEGER :: JJ, CPT, ILUOUT, INBMIN, IP0
INTEGER :: IRESP, INFOMPI
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('INIT_INDEX_MPI',0,ZHOOK_HANDLE)
!
GSPEC = (HINIT=='PGD' .OR. (HINIT=='PRE' .AND. LOASIS) .OR. &
        (HINIT=='OFF' .AND. (LLAND_USE .OR. LXIOS .OR. LOASIS)))
!
ALLOCATE(NREQ((NPROC-1)*2))
!
IF (PRESENT(OSHADOWS)) THEN
  GSHADOWS = OSHADOWS
ELSE
  GSHADOWS = .FALSE.
ENDIF
!
IF ( NRANK==NPIO ) THEN
  !
  CALL GET_LUOUT(HPROGRAM,ILUOUT)
  !
  !*    1. Parameters of the grid
  !
  IF (HINIT=='PGD') THEN
    !
    CPROGNAME=HPROGRAM
    !
    CALL INI_CSTS
    !
    CALL PGD_GRID (UG, U, GCP, HPROGRAM,'                            ','      ',&
                   .FALSE.,'A')
    !
  ELSE
    !
    CALL SET_SURFEX_FILEIN(HPROGRAM,'PGD ')
    CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'FULL  ','SURF  ','READ ')
    !
    CALL READ_SURF(HPROGRAM, 'DIM_FULL  ', U%NDIM_FULL, IRESP, HDIR='A')
    !
    CALL READ_ARRANGE_COVER(HPROGRAM, U%LWATER_TO_NATURE, U%LTOWN_TO_ROCK,'A')
    CALL READ_COVER_GARDEN(HPROGRAM, U%LGARDEN,'A')
    !
    CALL END_IO_SURF_n(HPROGRAM)
    DEALLOCATE(NMASK_FULL)
    !
    CALL SET_SURFEX_FILEIN(HPROGRAM,'PGD ') ! change input file name to pgd name
    CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'FULL  ','SURF  ','READ ')
    !
    CALL READ_SURF(HPROGRAM, 'GRID_TYPE', UG%G%CGRID, IRESP, HDIR='A')
    !
    CALL READ_GRIDTYPE(HPROGRAM, UG%G%CGRID, UG%NGRID_FULL_PAR, U%NDIM_FULL, .FALSE., HDIR='A')
    !
    ALLOCATE(UG%XGRID_FULL_PAR(UG%NGRID_FULL_PAR))
    !
    CALL READ_GRIDTYPE(HPROGRAM, UG%G%CGRID, UG%NGRID_FULL_PAR, U%NDIM_FULL, .TRUE.,&
                       UG%XGRID_FULL_PAR, IRESP ,HDIR='A')
    !
    !
    CALL END_IO_SURF_n(HPROGRAM)
    !
  ENDIF
  ! 
  NSIZE = U%NDIM_FULL
  !
ELSE
  U%NDIM_FULL = 0
ENDIF
!
IF (NPROC>1) THEN
#ifdef SFX_MPI
  IF (GSPEC) THEN
    CALL MPI_BCAST(UG%NGRID_FULL_PAR,KIND(UG%NGRID_FULL_PAR)/4,MPI_INTEGER,NPIO,NCOMM,INFOMPI)
    IF (NRANK/=NPIO) ALLOCATE(UG%XGRID_FULL_PAR(UG%NGRID_FULL_PAR))
    CALL MPI_BCAST(UG%XGRID_FULL_PAR,SIZE(UG%XGRID_FULL_PAR)*KIND(UG%XGRID_FULL_PAR)/4,MPI_REAL,NPIO,NCOMM,INFOMPI)
  ENDIF
  CALL MPI_BCAST(U%NDIM_FULL,KIND(U%NDIM_FULL)/4,MPI_INTEGER,NPIO,NCOMM,INFOMPI)
#endif
ENDIF
!
NDIM_FULL_INIT = U%NDIM_FULL
!
!*     3. Points by task
!
IF (NRANK==NPIO .OR. GSPEC) THEN
  IF (.NOT.ALLOCATED(NINDEX)) ALLOCATE(NINDEX(U%NDIM_FULL))
  NINDEX(:) = -1
ELSEIF (.NOT.ALLOCATED(NINDEX)) THEN
  ALLOCATE(NINDEX(0))
ENDIF
!
IF (HINIT=='PGD' .AND. (HALG=='TILA' .OR. HALG=='TILL')) THEN
  HALG = 'LIN '
  IF (NRANK==NPIO) THEN
    WRITE(*,*) 'INIT_INDEX_MPI: for PGD, TILA and TILL are forbidden, forced to LIN'
    WRITE(ILUOUT,*) 'INIT_INDEX_MPI: for PGD, TILA and TILL are forbidden, forced to LIN'
  ENDIF
ENDIF
!
IF (HALG=='LIN ') THEN
  !
  IF (NRANK==NPIO) CALL SET_NB_POINTS_LIN(NPROC,NPROC-1,U%NDIM_FULL,NINDEX,OSHADOWS)
  !
ELSEIF (HALG=='ADJ ' .OR. HALG=='TILA' .OR. HALG=='TILL') THEN
  !
  IF (NRANK==NPIO .AND. (HALG=='ADJ ' .OR. HALG=='TILA')) THEN
    ALLOCATE(ILEFT  (U%NDIM_FULL))
    ALLOCATE(IRIGHT (U%NDIM_FULL))
    ALLOCATE(IBOTTOM(U%NDIM_FULL))
    ALLOCATE(ITOP   (U%NDIM_FULL))
    CALL GET_ADJACENT_MESHES(UG%G%CGRID,UG%NGRID_FULL_PAR,U%NDIM_FULL,&
                             UG%XGRID_FULL_PAR,ILEFT,IRIGHT,ITOP,IBOTTOM)
  ELSE
    ALLOCATE(ILEFT  (0))
    ALLOCATE(IRIGHT (0))
    ALLOCATE(IBOTTOM(0))
    ALLOCATE(ITOP   (0))
  ENDIF
  !
  IF (HALG=='ADJ ') THEN
    IF (NRANK==NPIO) CALL SET_NB_POINTS_ADJ(NPROC,U%NDIM_FULL,U%NDIM_FULL,&
                                            ILEFT,IRIGHT,ITOP,IBOTTOM,NINDEX,OSHADOWS)
  ELSEIF (HALG=='TILA' .OR. HALG=='TILL') THEN
    CALL SET_NB_POINTS_TIL(HPROGRAM,HALG,NPROC,U%NDIM_FULL,ILEFT,IRIGHT,ITOP,IBOTTOM,NINDEX,OSHADOWS)
  ENDIF
  !
ELSE
  !
  CALL ABOR1_SFX("INIT_INDEX_MPI: ALG="//HALG//" not defined for the moment")
  !
ENDIF
!
IF (GSPEC) THEN
  ALLOCATE(NNUM(U%NDIM_FULL))
  NNUM(:) = 0
ENDIF  
!
IF (NRANK==NPIO) THEN
  !
  IF (NPROC>1) THEN
    !
    INBPTS(:) = 0
    DO JJ=1,SIZE(NINDEX)
      INBPTS(NINDEX(JJ)) = INBPTS(NINDEX(JJ)) + 1
    ENDDO
    !   
    INBMIN = MINVAL(INBPTS)
    IP0 = MAXVAL(MINLOC(INBPTS)) - 1
    !   
    IF (.NOT. GSHADOWS) THEN
    ! Matthieu Lafaysse :
    ! With shadows we don't want the repartition of points to be modified by the following instructions
    
      DO WHILE( INBPTS(NPIO) > NINT(PIO_FRAC*INBMIN) )
        !
        DO JJ=1,SIZE(NINDEX)
          IF (NINDEX(JJ)==NPIO) THEN
            NINDEX(JJ) = IP0
            INBPTS(NPIO) = INBPTS(NPIO) - 1
            INBPTS(IP0) = INBPTS(IP0) + 1
            EXIT
          ENDIF
        ENDDO
      !
        INBMIN = MAXVAL(INBPTS)
        IP0 = 0
        DO JJ=0,NPROC-1
          IF (JJ/=NPIO .AND. INBPTS(JJ)<INBMIN) THEN
            INBMIN = INBPTS(JJ)
            IP0 = JJ
          ENDIF
        ENDDO
      !
      END DO
    
    END IF
    !
  ENDIF
  !
  IF (GSPEC) THEN
    INB(:) = 0
    DO JJ=1,U%NDIM_FULL
      INB(NINDEX(JJ)) = INB(NINDEX(JJ))+1
      NNUM(JJ) = INB(NINDEX(JJ))
    ENDDO
  ENDIF
  !  
ENDIF
!
IF (NPROC>1) THEN
#ifdef SFX_MPI
  IF (GSPEC) THEN
    CALL MPI_BCAST(NINDEX,SIZE(NINDEX)*KIND(NINDEX)/4,MPI_INTEGER,NPIO,NCOMM,INFOMPI) 
    CALL MPI_BCAST(NNUM,SIZE(NNUM)*KIND(NNUM)/4,MPI_INTEGER,NPIO,NCOMM,INFOMPI)
  ENDIF
  IF (GSHADOWS) THEN
  ! Matthieu Lafaysse :
  ! Each thread need to know NIX and NIY
    CALL MPI_BCAST(NIX,KIND(NIX)/4,MPI_INTEGER,NPIO,NCOMM,INFOMPI)
    CALL MPI_BCAST(NIY,KIND(NIY)/4,MPI_INTEGER,NPIO,NCOMM,INFOMPI)
  ENDIF
#endif
ENDIF
!
ALLOCATE(NSIZE_TASK(0:NPROC-1))
NSIZE_TASK(:) = 0
!
IF (NRANK==NPIO) THEN
  DO JJ=1,U%NDIM_FULL
    NSIZE_TASK(NINDEX(JJ)) = NSIZE_TASK(NINDEX(JJ)) + 1
  ENDDO
ENDIF
!
NSIZE = 0
IF (NPROC>1) THEN
#ifdef SFX_MPI
  CALL MPI_BCAST(NSIZE_TASK,SIZE(NSIZE_TASK)*KIND(NSIZE_TASK)/4,MPI_INTEGER,NPIO,NCOMM,INFOMPI)
#endif
  NSIZE = MAXVAL(NSIZE_TASK)
  DO JJ=0,NPROC-1
    CALL WLOG_MPI('SIZE_TASK ',KLOG=JJ,KLOG2=NSIZE_TASK(JJ))
  ENDDO
ELSE
  NSIZE = NSIZE_TASK(0)
ENDIF
!
IF (.NOT.GSPEC) UG%XGRID_FULL_PAR=>NULL()
!
IF (LHOOK) CALL DR_HOOK('INIT_INDEX_MPI',1,ZHOOK_HANDLE)
!
CONTAINS
!
!***************************************************************
!
SUBROUTINE SET_NB_POINTS_LIN(KPROC,KPROCMIN,KSIZE,KINDEX,OSHADOWS)
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KPROC
INTEGER, INTENT(IN) :: KPROCMIN
INTEGER, INTENT(IN) :: KSIZE
INTEGER, DIMENSION(:), INTENT(INOUT) :: KINDEX
LOGICAL, INTENT(IN) :: OSHADOWS
!
INTEGER, DIMENSION(0:KPROC-1) :: ISIZE_TASK
INTEGER :: JI, JJ, CPT, IPROC1
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('INIT_INDEX_MPI:SET_NB_POINTS_LIN',0,ZHOOK_HANDLE)
!
 CALL GET_SIZES_PARALLEL(DTCO, UG, U, &
                         KPROC,KSIZE,KPROCMIN,ISIZE_TASK,OSHADOWS)
!
IPROC1 = KPROCMIN
!
CPT   = 0
!
DO JJ=1,SIZE(KINDEX) ! boucle sur les points du domaine
  !
  IF (KINDEX(JJ)==-1) THEN ! si le point doit être affecté à cette itération
    CPT = CPT + 1 ! on augmente le nombre de points affectés de 1
    DO WHILE( CPT>ISIZE_TASK(IPROC1) ) ! si on est hors les bornes permises par le proc en cours
      IF ( IPROC1.GE.KPROCMIN ) THEN ! d'abord, on va de IPROCMIN à IPROC-1
        IPROC1 = IPROC1+1
        IF ( IPROC1==KPROC ) IPROC1 = KPROCMIN-1 ! une fois qu'on est à IPROC-1,
      ELSE                                       ! on redescend sous IPROC1
        IPROC1 = IPROC1-1
      ENDIF
      CPT = 1
    ENDDO
    KINDEX(JJ) = IPROC1
  ENDIF
  !
ENDDO
!

IF (LHOOK) CALL DR_HOOK('INIT_INDEX_MPI:SET_NB_POINTS_LIN',1,ZHOOK_HANDLE)
!
END SUBROUTINE SET_NB_POINTS_LIN
!
!**************************************************************************
!
SUBROUTINE SET_NB_POINTS_ADJ(KPROC,KSIZE,KDIM_FULL,KLEFT,KRIGHT,KTOP,KBOTTOM,KINDEX,OSHADOWS)
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KPROC
INTEGER, INTENT(IN) :: KSIZE
INTEGER, INTENT(IN) :: KDIM_FULL
INTEGER, DIMENSION(KDIM_FULL), INTENT(IN) :: KLEFT
INTEGER, DIMENSION(KDIM_FULL), INTENT(IN) :: KRIGHT
INTEGER, DIMENSION(KDIM_FULL), INTENT(IN) :: KTOP 
INTEGER, DIMENSION(KDIM_FULL), INTENT(IN) :: KBOTTOM
INTEGER, DIMENSION(KDIM_FULL), INTENT(INOUT) :: KINDEX
LOGICAL, INTENT(IN) :: OSHADOWS
!
INTEGER, DIMENSION(:), ALLOCATABLE :: IMASK
INTEGER, DIMENSION(KDIM_FULL) :: IPOINT
INTEGER, DIMENSION(0:KPROC-1) :: ISIZE_TASK
INTEGER, DIMENSION(4) :: INEAR
INTEGER :: ICOUNT,ICPT,IDEB
INTEGER :: CPT_TOT, CPT_LOC, CPT_INTER, JI, JJ, JK
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('INIT_INDEX_MPI:SET_NB_POINTS_ADJ',0,ZHOOK_HANDLE)
!
 CALL GET_SIZES_PARALLEL(DTCO, UG, U, &
                         KPROC,KSIZE,NPIO,ISIZE_TASK,OSHADOWS)
!
ICOUNT = COUNT(KINDEX(:)==-1)
ALLOCATE(IMASK(ICOUNT))
ICPT = 0
DO JJ=1,KDIM_FULL
  IF (KINDEX(JJ)==-1) THEN
    ICPT = ICPT + 1
    IMASK(ICPT) = JJ
  ENDIF
ENDDO
IDEB = 1
!
DO JI=1,KPROC-1
  !
  CPT_INTER = 0
  CPT_LOC   = 0
  CPT_TOT   = 0
  !
  DO WHILE ( CPT_TOT < ISIZE_TASK(JI) )
    !
    IF (CPT_LOC < 1 ) THEN ! if no free point has been found in neighbours
      !
      DO JJ=IDEB,ICOUNT
        IF ( KINDEX(IMASK(JJ))==-1 ) THEN
          CPT_TOT = CPT_TOT + 1
          CPT_LOC = 1
          IPOINT(1) = IMASK(JJ)
          KINDEX(IMASK(JJ)) = JI
          EXIT
        ENDIF
      ENDDO
      IDEB = JJ+1
      !
    ENDIF
    !
    IPOINT(1:CPT_LOC-CPT_INTER) = IPOINT(CPT_INTER+1:CPT_LOC)
    CPT_LOC   = CPT_LOC - CPT_INTER
    CPT_INTER = CPT_LOC
    !
    B1 : DO JJ=1,CPT_INTER
      !
      INEAR(1) = KBOTTOM(IPOINT(JJ))
      INEAR(2) = KLEFT  (IPOINT(JJ))
      INEAR(3) = KRIGHT (IPOINT(JJ)) 
      INEAR(4) = KTOP   (IPOINT(JJ))    
      !
      DO JK=1,4
        !
        IF ( INEAR(JK).NE.0 ) THEN
          IF( KINDEX(INEAR(JK)).EQ.-1 ) THEN
            CPT_TOT = CPT_TOT + 1
            CPT_LOC = CPT_LOC + 1
            IF (CPT_TOT.GT.ISIZE_TASK(JI)) EXIT B1
            KINDEX(INEAR(JK)) = JI
            IPOINT(CPT_LOC) = INEAR(JK)
          ENDIF
        ENDIF
        !
      ENDDO
      !
    ENDDO B1
    !
  ENDDO
  !
ENDDO
!
DEALLOCATE(IMASK)
!
WHERE (KINDEX(:)==-1) KINDEX(:) = 0
!
IF (LHOOK) CALL DR_HOOK('INIT_INDEX_MPI:SET_NB_POINTS_ADJ',1,ZHOOK_HANDLE)
!
END SUBROUTINE SET_NB_POINTS_ADJ
!
!*****************************************************************
!
SUBROUTINE SET_NB_POINTS_TIL(HPROGRAM,HALG,KPROC,KDIM_FULL,KLEFT,KRIGHT,KTOP,KBOTTOM,KINDEX,OSHADOWS)
!
! modif 
! 05/14 B. Decharme Partion done according to patch and not vegtype (vegtype can be > to patch grid)
!
USE MODN_IO_OFFLINE, ONLY : LWR_VEGTYPE
!
USE MODD_DATA_COVER_PAR, ONLY : NVEGTYPE, JPCOVER
!
USE MODD_SURF_PAR,       ONLY : XUNDEF
!
USE MODI_AV_PGD
!
IMPLICIT NONE
!
 CHARACTER(LEN=6), INTENT(IN) :: HPROGRAM
 CHARACTER(LEN=4), INTENT(IN) :: HALG
INTEGER, INTENT(IN) :: KPROC
INTEGER, INTENT(IN) :: KDIM_FULL
INTEGER, DIMENSION(KDIM_FULL), INTENT(IN) :: KLEFT
INTEGER, DIMENSION(KDIM_FULL), INTENT(IN) :: KRIGHT
INTEGER, DIMENSION(KDIM_FULL), INTENT(IN) :: KTOP 
INTEGER, DIMENSION(KDIM_FULL), INTENT(IN) :: KBOTTOM
INTEGER, DIMENSION(KDIM_FULL), INTENT(INOUT) :: KINDEX
LOGICAL, INTENT(IN) :: OSHADOWS
!
REAL, DIMENSION(KDIM_FULL) :: ZSEA
REAL, DIMENSION(KDIM_FULL) :: ZWATER
REAL, DIMENSION(KDIM_FULL) :: ZNATURE
REAL, DIMENSION(KDIM_FULL) :: ZTOWN
REAL, DIMENSION(:,:), ALLOCATABLE  :: ZCOVER
REAL, DIMENSION(:,:), ALLOCATABLE :: ZVEGTYPE
INTEGER, DIMENSION(KDIM_FULL,2) :: ITYPE 
INTEGER, DIMENSION(KDIM_FULL) :: IINDEX
INTEGER, DIMENSION(0:KPROC-1) :: ISIZE_TASK
INTEGER, DIMENSION(0:KPROC-1) :: INBPTS
INTEGER, DIMENSION(1) :: IPROCMIN
INTEGER :: IFULL, IRESP, JJ, JI, JK, JVEGTYPE, CPT, IN1, IN2
INTEGER :: IDIM_NATURE
CHARACTER(LEN=6) :: YNATURE
LOGICAL, DIMENSION(:), ALLOCATABLE :: GCOVER
LOGICAL :: GDATA_VEGTYPE, GDIM, GDIM2
!
CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
INTEGER           :: IVERSION, IBUGFIX
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE, ZHOOK_HANDLE_OMP
!
IF (LHOOK) CALL DR_HOOK('INIT_INDEX_MPI:SET_NB_POINTS_TIL',0,ZHOOK_HANDLE)
!
GDATA_VEGTYPE = .FALSE.
!
! Full read
!
 CALL SET_SURFEX_FILEIN(HPROGRAM,'PGD ')

 CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'FULL  ','SURF  ','READ ')
!
 CALL READ_SURF(HPROGRAM,'FRAC_SEA   ',ZSEA,   IRESP, HDIR='A')
 CALL READ_SURF(HPROGRAM,'FRAC_NATURE',ZNATURE,IRESP, HDIR='A')
 CALL READ_SURF(HPROGRAM,'FRAC_WATER ',ZWATER, IRESP, HDIR='A')
 CALL READ_SURF(HPROGRAM,'FRAC_TOWN  ',ZTOWN,  IRESP, HDIR='A')
 CALL READ_SURF(HPROGRAM,'NATURE     ',YNATURE,IRESP, HDIR='-')
 CALL READ_SURF(HPROGRAM,'VERSION    ',IVERSION,IRESP, HDIR='-')
 CALL READ_SURF(HPROGRAM,'BUG        ',IBUGFIX,IRESP, HDIR='-')
 CALL READ_SURF(HPROGRAM,'DIM_NATURE ',IDIM_NATURE,IRESP,HDIR='-')
!
GDIM = (IVERSION>8 .OR. (IVERSION==8 .AND. IBUGFIX>=1))
!
IF (GDIM) THEN
  CALL READ_SURF(HPROGRAM,'ECOSG',U%LECOSG,IRESP,HDIR='-')
ELSE
  U%LECOSG = .FALSE.
ENDIF
!
 CALL END_IO_SURF_n(HPROGRAM)
!
 CALL INI_DATA_COVER(DTCO, U)
!
! Algo
!
IF (NRANK==NPIO) THEN
  !
  ITYPE(:,:) = 0
  !
  DO JJ=1,KDIM_FULL
    !
    IF (ZSEA(JJ)/=0. .AND. ZNATURE(JJ)/=0. .AND. ZWATER(JJ)/=0. .AND. ZTOWN(JJ)/=0.) THEN ! 1 2 3 4
      ITYPE(JJ,1) = 1 
    ELSEIF (ZSEA(JJ)/=0. .AND. ZNATURE(JJ)/=0. .AND. ZWATER(JJ)/=0.) THEN ! 1 2 3
      ITYPE(JJ,1) = 2
    ELSEIF (ZSEA(JJ)/=0. .AND. ZNATURE(JJ)/=0. .AND. ZTOWN(JJ)/=0.) THEN ! 1 2 4
      ITYPE(JJ,1) = 3
    ELSEIF (ZSEA(JJ)/=0. .AND. ZWATER(JJ)/=0. .AND. ZTOWN(JJ)/=0.) THEN ! 1 3 4 
      ITYPE(JJ,1) = 4
    ELSEIF (ZNATURE(JJ)/=0. .AND. ZWATER(JJ)/=0. .AND. ZTOWN(JJ)/=0.) THEN ! 2 3 4
      ITYPE(JJ,1) = 5
    ELSEIF (ZSEA(JJ)/=0.) THEN 
      IF (ZNATURE(JJ)/=0.) THEN ! 1 2
        ITYPE(JJ,1) = 6
      ELSEIF (ZWATER(JJ)/=0.) THEN ! 1 3
        ITYPE(JJ,1) = 7
      ELSEIF (ZTOWN(JJ)/=0.) THEN ! 1 4
        ITYPE(JJ,1) = 8
      ELSE ! 1
        ITYPE(JJ,1) = 12
      ENDIF
    ELSEIF (ZNATURE(JJ)/=0.) THEN
      IF (ZWATER(JJ)/=0.) THEN ! 2 3
        ITYPE(JJ,1) = 9
      ELSEIF (ZTOWN(JJ)/=0.) THEN ! 2 4
        ITYPE(JJ,1) = 10
      ELSE ! 2
        ITYPE(JJ,1) = 13
      ENDIF
    ELSEIF (ZWATER(JJ)/=0.) THEN
      IF (ZTOWN(JJ)/=0.) THEN ! 3 4
        ITYPE(JJ,1) = 11
      ELSE ! 3
        ITYPE(JJ,1) = 14
      ENDIF
    ELSE ! 4
      ITYPE(JJ,1) = 15
    ENDIF
    !
  ENDDO
  !
ENDIF  
!
! Nature read
!
IF (YNATURE/='NONE' .AND. IDIM_NATURE>0) THEN
  !
  ALLOCATE(ZVEGTYPE(KDIM_FULL,NVEGTYPE))
  !
  CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'NATURE','SURF  ','READ ')
  CALL READ_SURF(HPROGRAM,'L_VEGTYPE',GDATA_VEGTYPE,IRESP,HDIR='-')
  CALL END_IO_SURF_n(HPROGRAM)
  !
  CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'FULL  ','SURF  ','READ ')
  !  
  IF (GDATA_VEGTYPE) THEN
    IF (GDIM) THEN
      YRECFM='D_VEGTY_'
    ELSE
      YRECFM='D_VEGTYPE'
    ENDIF        
    GDIM2 = GDIM 
    IF (GDIM) CALL READ_SURF(HPROGRAM,'SPLIT_PATCH',GDIM2,IRESP) 
    CALL MAKE_CHOICE_ARRAY(HPROGRAM, NVEGTYPE, GDIM2, YRECFM, ZVEGTYPE(:,:),HDIR='A')
  ELSE
    IF (LWR_VEGTYPE) THEN
      CALL READ_SURF(HPROGRAM,'VEGTYPE',ZVEGTYPE(:,:),IRESP,HDIR='E')
    ELSE
      ALLOCATE(GCOVER(JPCOVER))
      CALL READ_SURF(HPROGRAM,'COVER_LIST',GCOVER(:),IRESP,HDIR='-')
      IF (NRANK==NPIO) THEN
        ALLOCATE(ZCOVER(KDIM_FULL,COUNT(GCOVER)))
      ELSE
        ALLOCATE(ZCOVER(0,0))
      ENDIF
      CALL READ_SURF_COV(HPROGRAM,'COVER',ZCOVER(:,:),GCOVER,IRESP,HDIR='E')

      IF (NRANK==NPIO) THEN
        DO JVEGTYPE=1,NVEGTYPE
          CALL AV_PGD(DTCO,ZVEGTYPE(:,JVEGTYPE),ZCOVER,DTCO%XDATA_VEGTYPE(:,JVEGTYPE),'NAT','ARI',GCOVER)
        END DO
      ENDIF
      DEALLOCATE(ZCOVER)
      DEALLOCATE(GCOVER)

    ENDIF

  ENDIF
!
  CALL END_IO_SURF_n(HPROGRAM)
!
  IF (NRANK==NPIO) THEN
    !we give numbers to the 40 types of vegtypes
    DO JJ=1,KDIM_FULL
      IN1 = COUNT(ZVEGTYPE(JJ,1:3)/=0.)
      IN2 = COUNT(ZVEGTYPE(JJ,4:NVEGTYPE)/=0.)
      ITYPE(JJ,2) = IN2*4 + IN1 + 1
    ENDDO
  ENDIF
  !
ELSE
  !
  IF (NRANK==NPIO) ITYPE(:,2) = 1
  !
ENDIF
!
!
!we give numbers to the 40 types of vegtypes
!
IF (NRANK==NPIO) THEN
  !
  KINDEX(:) = -1
  !
  DO JI = 1,15
    !
    DO JJ = 1,MAXVAL(MAXVAL(ITYPE,2))
      !
      !count of the points in the couple of types
      IINDEX(:) = -2
      DO JK=1,KDIM_FULL
        IF (ITYPE(JK,1)==JI .AND. ITYPE(JK,2)==JJ) IINDEX(JK) = -1
      ENDDO
      !
      IFULL = COUNT(IINDEX(:)==-1)
      !
      IF (IFULL.NE.0) THEN
        !
        INBPTS(:) = 0
        DO JK=1,SIZE(KINDEX)
          IF (KINDEX(JK)>-1) INBPTS(KINDEX(JK)) = INBPTS(KINDEX(JK)) + 1
        ENDDO
        IF (KPROC>1) THEN
          IPROCMIN = MINLOC(INBPTS(0:KPROC-1))-1
         ELSE
          IPROCMIN(:) = 0
        ENDIF
        !
        IF (HALG=='TILL') THEN
          CALL SET_NB_POINTS_LIN(KPROC,IPROCMIN(1),IFULL,IINDEX(:),OSHADOWS)
        ELSEIF (HALG=='TILA') THEN
          CALL SET_NB_POINTS_ADJ(KPROC,IFULL,KDIM_FULL,KLEFT,KRIGHT,KTOP,KBOTTOM,IINDEX(:),OSHADOWS)
        ENDIF
        !
        DO JK=1,KDIM_FULL
          IF ( IINDEX(JK)> -1 ) KINDEX(JK) = IINDEX(JK)
        ENDDO
        !
      ENDIF
      !
    ENDDO
    !
  ENDDO
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('INIT_INDEX_MPI:SET_NB_POINTS_TIL',1,ZHOOK_HANDLE)
!
END SUBROUTINE SET_NB_POINTS_TIL
!
!
!
END SUBROUTINE INIT_INDEX_MPI
