!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
                   SUBROUTINE GET_DIMLEN_NETCDF(HFILE_NAME,HDIM_NAME,KDIM,KDIM_ID)
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_HANDLE_ERR
USE NETCDF
!
IMPLICIT NONE
 CHARACTER(LEN=*), INTENT(IN):: HFILE_NAME
 CHARACTER(LEN=*), INTENT(IN):: HDIM_NAME
INTEGER,          INTENT(OUT) :: KDIM
INTEGER, OPTIONAL,INTENT(OUT) :: KDIM_ID

!local variables
INTEGER ::  JRET,IFILE_ID,IDIM_ID
INTEGER,DIMENSION(2) :: IRET
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!----------------------------------
! 1.a Open file
IF (LHOOK) CALL DR_HOOK('GET_DIMLEN_NETCDF',0,ZHOOK_HANDLE)
JRET=NF90_OPEN(HFILE_NAME,NF90_NOWRITE,IFILE_ID)
!
! 1.b get dim info
IRET(1)=NF90_INQ_DIMID(IFILE_ID,HDIM_NAME,IDIM_ID)
IF (PRESENT(KDIM_ID)) KDIM_ID=IDIM_ID
IRET(2)=NF90_INQUIRE_DIMENSION(IFILE_ID,IDIM_ID,LEN=KDIM)

! 1.c close file
JRET=NF90_CLOSE(IFILE_ID)
!
! 2. check for error
DO JRET=1,2
   IF (IRET(JRET).NE.NF90_NOERR) CALL HANDLE_ERR(IRET(JRET),'GET_DIMLEN_NETCDF')
ENDDO
IF (LHOOK) CALL DR_HOOK('GET_DIMLEN_NETCDF',1,ZHOOK_HANDLE)
!
END SUBROUTINE GET_DIMLEN_NETCDF
