!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE DEF_VAR_NETCDF (HSELECT, &
                                 KFILE_ID, HNAME, HLONG_NAME, KDIM_ID, HATT_TITLE, HATT_TEXT,&
                                 KVAR_ID, KTYPE, KLEN, HATT_TITLE2, PATT_FLOAT,&
                                 HATT_TITLE3, PATT_FLOAT2D)
!
!!
!!    MODIFICATIONS
!!    -------------
!!      B. Decharme 07/2013 special case for time in netcdf output files
!-------------------------------------------------------------------------------
!
USE MODD_IO_SURF_NC, ONLY : CFILEOUT_NC, NID_NC
USE MODD_SURF_PAR,       ONLY : XUNDEF, NUNDEF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE NETCDF
!
IMPLICIT NONE

!
 CHARACTER(LEN=*), DIMENSION(:), INTENT(IN) :: HSELECT
!
INTEGER,               INTENT(IN) :: KFILE_ID
 CHARACTER(LEN=*),      INTENT(IN) :: HNAME
 CHARACTER(LEN=*),      INTENT(IN) :: HLONG_NAME
INTEGER, DIMENSION(:), INTENT(IN) :: KDIM_ID
 CHARACTER(LEN=*),DIMENSION(:),OPTIONAL, INTENT(IN) :: HATT_TITLE,HATT_TEXT
INTEGER, OPTIONAL, INTENT(OUT) :: KVAR_ID
INTEGER, OPTIONAL, INTENT(IN) :: KTYPE
INTEGER, OPTIONAL, INTENT(IN) :: KLEN
 CHARACTER(LEN=*),DIMENSION(:),OPTIONAL, INTENT(IN) :: HATT_TITLE2
REAL, DIMENSION(:), OPTIONAL, INTENT(IN) :: PATT_FLOAT
 CHARACTER(LEN=*),DIMENSION(:),OPTIONAL, INTENT(IN) :: HATT_TITLE3
REAL, DIMENSION(:,:), OPTIONAL, INTENT(IN) :: PATT_FLOAT2D
!
! ** local variables
!
 CHARACTER(LEN=100) :: YNAME
 CHARACTER(LEN=50) :: YPAS
INTEGER, DIMENSION(4) :: IRET
INTEGER :: JRET,IVAR_ID,IATT,JATT,ILEN,INDIM
INTEGER :: IFIELD,JFIELD,ISIZE
LOGICAL :: NOWRITE, GOPENED, GEXIST
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!--------------------------------------
!
IF (LHOOK) CALL DR_HOOK('DEF_VAR_NETCDF',0,ZHOOK_HANDLE)
!
! if output fields selection is active, test if this field is to be written
IF ( HNAME/='xx'  .AND. HNAME/='yy' .AND. HNAME/='lon' .AND. &
     HNAME/='lat' .AND. HNAME/='time' .AND. HNAME/='Projection_Type' .AND. &
     HNAME/='longitude' .AND. HNAME/='latitude' .AND. SIZE(HSELECT)>0 )  THEN
  IFIELD=COUNT(HSELECT /= '            ')
  NOWRITE=.TRUE.
  DO JFIELD=1,IFIELD
    IF ( TRIM(HSELECT(JFIELD))==TRIM(HNAME) ) THEN
      NOWRITE=.FALSE.
    ENDIF
  ENDDO
  IF ( NOWRITE  .AND. LHOOK) CALL DR_HOOK('DEF_VAR_NETCDF',1,ZHOOK_HANDLE)
  IF ( NOWRITE ) RETURN
ENDIF
!
!define variables in the netcdf file
INDIM=SIZE(KDIM_ID)
!
IF (PRESENT(KTYPE)) THEN
  IRET(1) = NF90_DEF_VAR(KFILE_ID,HNAME,KTYPE,KDIM_ID,IVAR_ID)
ELSE
  IRET(1) = NF90_DEF_VAR(KFILE_ID,HNAME,NF90_DOUBLE,KDIM_ID,IVAR_ID)
ENDIF
!
IF (INDIM/=0) THEN
  IF (PRESENT(KTYPE)) THEN
    IF (KTYPE==NF90_DOUBLE .OR. KTYPE==NF90_FLOAT) THEN
      IRET(2) = NF90_PUT_ATT (KFILE_ID,IVAR_ID,'_FillValue',XUNDEF)
    ELSEIF (KTYPE==NF90_INT .OR. KTYPE==NF90_SHORT) THEN
      IRET(2) = NF90_PUT_ATT (KFILE_ID,IVAR_ID,'_FillValue',NUNDEF)
    ELSEIF (KTYPE==NF90_CHAR) THEN
      IF (INDIM>1) IRET(2) = NF90_PUT_ATT (KFILE_ID,IVAR_ID,'_FillValue',"")
    ENDIF
  ELSE
    IRET(2) = NF90_PUT_ATT (KFILE_ID,IVAR_ID,'_FillValue',XUNDEF)
  ENDIF
ENDIF
!
IF (PRESENT(KTYPE)) THEN
  IF (KTYPE==NF90_CHAR) THEN
    IF (PRESENT(KLEN)) IRET(3) = NF90_PUT_ATT (KFILE_ID,IVAR_ID,'len',KLEN)
  ENDIF
ENDIF
!
IF (HLONG_NAME.NE.'') IRET(2) = NF90_PUT_ATT (KFILE_ID,IVAR_ID,'long_name',HLONG_NAME)
!
!Write optional attribute
IF (PRESENT(HATT_TITLE).AND.PRESENT(HATT_TEXT)) THEN  
  IATT=SIZE(HATT_TITLE)
  IF (IATT .EQ. SIZE(HATT_TEXT)) THEN
    DO JATT=1,IATT
      ILEN=LEN_TRIM(HATT_TEXT(JATT))
      YPAS=HATT_TEXT(JATT)
      JRET = NF90_PUT_ATT (KFILE_ID,IVAR_ID,HATT_TITLE(JATT),HATT_TEXT(JATT))
    ENDDO
  ENDIF
ENDIF
!
!Write optional attribute
IF (PRESENT(HATT_TITLE2).AND.PRESENT(PATT_FLOAT)) THEN  
  IATT=SIZE(HATT_TITLE2)
  IF (IATT .EQ. SIZE(PATT_FLOAT)) THEN
    DO JATT=1,IATT
      ILEN=LEN_TRIM(HATT_TITLE2(JATT))
      YPAS=HATT_TITLE2(JATT)
      JRET = NF90_PUT_ATT (KFILE_ID,IVAR_ID,HATT_TITLE2(JATT),PATT_FLOAT(JATT))
    ENDDO
  ENDIF
ENDIF
!
!Write optional attribute
IF (PRESENT(HATT_TITLE3).AND.PRESENT(PATT_FLOAT2D)) THEN  
  IATT=SIZE(HATT_TITLE3)
  IF (IATT .EQ. SIZE(PATT_FLOAT2D,1)) THEN
    DO JATT=1,IATT
      ILEN=LEN_TRIM(HATT_TITLE3(JATT))
      YPAS=HATT_TITLE3(JATT)
      JRET = NF90_PUT_ATT (KFILE_ID,IVAR_ID,HATT_TITLE3(JATT),PATT_FLOAT2D(JATT,:))
    ENDDO
  ENDIF
ENDIF
!
IF (PRESENT(KVAR_ID)) KVAR_ID = IVAR_ID
!
IF (LHOOK) CALL DR_HOOK('DEF_VAR_NETCDF',1,ZHOOK_HANDLE)
!
END SUBROUTINE DEF_VAR_NETCDF
