!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITESURF_PGD_TEB_PAR_n (BDD, DTB, DTGD, DTGR, DTT, DTH, HSELECT, &
                                          GDO, GRO, GRS, GRK, TIR, TOP, BOP, HPROGRAM)
!     ################################################
!
!!****  *WRITESURF_PGD_TEB_PAR_n* - reads ISBA physiographic fields
!!                        
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    05/2005
!!       V. Masson  08/2013 add solar panels
!!       M. Goret   02/2017 move BEM related variables in WRITESURF_PGD_BEM_PAR_n
!!       M. Goret   03/2017 add CO2 flux and TIME_OF_CHANGE
!!       M. Goret   04/2017 suppress EFF_HEAT
!!       M. Goret   04/2017 remove unity (m) for USETYPE
!!       M. Goret   08/2017 add RE25 in NAM_DATA_TEB_GARDEN namelist
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_DATA_TEB_HYDRO_n, ONLY : DATA_TEB_HYDRO_t
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
USE MODD_ISBA_n, ONLY : ISBA_S_t, ISBA_K_t
USE MODD_TEB_IRRIG_n, ONLY : TEB_IRRIG_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
USE MODD_BEM_OPTION_n, ONLY : BEM_OPTIONS_t
!
USE MODI_WRITE_SURF
USE MODI_WRITE_BLD_DESCRIPTION_n
USE MODI_WRITESURF_PGD_TEB_IRRIG_n
USE MODI_WRITESURF_PGD_BEM_PAR_n
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTGD
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTGR
TYPE(DATA_TEB_HYDRO_t), INTENT(INOUT) :: DTH
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
 CHARACTER(LEN=*), DIMENSION(:), INTENT(IN) :: HSELECT
TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: GDO
TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: GRO
TYPE(ISBA_S_t), INTENT(INOUT) :: GRS
TYPE(ISBA_K_t), INTENT(INOUT) :: GRK
TYPE(TEB_IRRIG_t), INTENT(INOUT) :: TIR
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
TYPE(BEM_OPTIONS_t), INTENT(INOUT) :: BOP
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
INTEGER           :: JL         ! loop index
INTEGER           :: JTIME          ! loop index
REAL, DIMENSION(:), ALLOCATABLE :: ZWORK
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_PGD_TEB_PAR_N',0,ZHOOK_HANDLE)
YRECFM='L_BLDTYPE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_BLDTYPE,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_BLDTYPE) THEN
  YRECFM='D_BLDTYPE'
  YCOMMENT='X_Y_'//YRECFM//' (1)'
  ALLOCATE(ZWORK(SIZE(DTT%NPAR_BLDTYPE)))
  ZWORK=FLOAT(DTT%NPAR_BLDTYPE(:))
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,ZWORK,IRESP,YCOMMENT)
  DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_P1TERR'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_P1TERRITORY,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_P1TERRITORY) THEN
   YRECFM='D_P1TERR'
   YCOMMENT='X_Y_'//YRECFM//'   '
   ALLOCATE(ZWORK(SIZE(DTT%NPAR_P1TERRITORY)))
   ZWORK=FLOAT(DTT%NPAR_P1TERRITORY(:))
   CALL WRITE_SURF(HSELECT, &
      HPROGRAM,YRECFM,ZWORK,IRESP,YCOMMENT)
   DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_PXTERR'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, &
   HPROGRAM,YRECFM,DTT%LDATA_PXTERRITORY,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_PXTERRITORY) THEN
   YRECFM='D_PXTERR'
   YCOMMENT='X_Y_'//YRECFM//'   '
   ALLOCATE(ZWORK(SIZE(DTT%NPAR_PXTERRITORY)))
   ZWORK=FLOAT(DTT%NPAR_PXTERRITORY(:))
   CALL WRITE_SURF(HSELECT, &
      HPROGRAM,YRECFM,ZWORK,IRESP,YCOMMENT)
   DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_IBLDAGE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_IND_BLD_AGE,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_IND_BLD_AGE) THEN
  YRECFM='D_IBLDAGE'
  YCOMMENT='X_Y_'//YRECFM//' ()'
  ALLOCATE(ZWORK(SIZE(DTT%NPAR_IND_BLD_AGE)))
  ZWORK=FLOAT(DTT%NPAR_IND_BLD_AGE(:))
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,ZWORK,IRESP,YCOMMENT)
  DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_CBLDAGE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_COL_BLD_AGE,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_COL_BLD_AGE) THEN
  YRECFM='D_CBLDAGE'
  YCOMMENT='X_Y_'//YRECFM//' ()'
  ALLOCATE(ZWORK(SIZE(DTT%NPAR_COL_BLD_AGE)))
  ZWORK=FLOAT(DTT%NPAR_COL_BLD_AGE(:))
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,ZWORK,IRESP,YCOMMENT)
  DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_USETYPE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_USETYPE,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_USETYPE) THEN
  YRECFM='D_USETYPE'
  YCOMMENT='X_Y_'//YRECFM//' (1)'
  ALLOCATE(ZWORK(SIZE(DTT%NPAR_USETYPE)))
  ZWORK=FLOAT(DTT%NPAR_USETYPE(:))
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,ZWORK,IRESP,YCOMMENT)
  DEALLOCATE(ZWORK)
ENDIF
!
IF (DTT%LDATA_BLDTYPE.OR.DTT%LDATA_IND_BLD_AGE.OR.DTT%LDATA_COL_BLD_AGE.OR.  &
    DTT%LDATA_USETYPE.OR.DTT%LDATA_P1TERRITORY.OR.DTT%LDATA_PXTERRITORY) THEN
   CALL WRITE_BLD_DESCRIPTION_n(HSELECT, BDD, HPROGRAM)
ENDIF
!
YRECFM='L_FRACIHS'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FRACIHS,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRACIHS) THEN
   YRECFM='D_FRACIHS'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FRACIHS,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRACCHS'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FRACCHS,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRACCHS) THEN
   YRECFM='D_FRACCHS'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
  CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FRACCHS,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRACCOM'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FRACCOM,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRACCOM) THEN
   YRECFM='D_FRACCOM'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FRACCOM,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRACTER'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FRACTER,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRACTER) THEN
   YRECFM='D_FRACTER'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FRACTER,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRACIND'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FRACIND,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRACIND) THEN
   YRECFM='D_FRACIND'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FRACIND,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRACNHE'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FRACNHE,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRACNHE) THEN
   YRECFM='D_FRACNHE'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FRACNHE,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRACPAV'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FRACPAV,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRACPAV) THEN
   YRECFM='D_FRACPAV'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FRACPAV,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRACMRI'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FRACMRI,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRACMRI) THEN
   YRECFM='D_FRACMRI'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FRACMRI,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRACHRI'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FRACHRI,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRACHRI) THEN
   YRECFM='D_FRACHRI'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FRACHRI,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRACATB'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FRACATB,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRACATB) THEN
   YRECFM='D_FRACATB'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FRACATB,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FOEQI_MAIS'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FOEQI_MAIS,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FOEQI_MAIS) THEN
   YRECFM='D_FOEQI_MAIS'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FOEQI_MAIS,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FOEQI_APPT'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FOEQI_APPT,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FOEQI_APPT) THEN
   YRECFM='D_FOEQI_APPT'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FOEQI_APPT,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FAEQI_MAIS'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FAEQI_MAIS,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FAEQI_MAIS) THEN
   YRECFM='D_FAEQI_MAIS'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FAEQI_MAIS,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FAEQI_APPT'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_FAEQI_APPT,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FAEQI_APPT) THEN
   YRECFM='D_FAEQI_APPT'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_FAEQI_APPT,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_CRE_MAIS'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_CRE_MAIS,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_CRE_MAIS) THEN
   YRECFM='D_CRE_MAIS'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_CRE_MAIS,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_CRE_APPT'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%LDATA_CRE_APPT,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_CRE_APPT) THEN
   YRECFM='D_CRE_APPT'
   YCOMMENT='X_Y_'//YRECFM//' (1)'
   CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DTT%XPAR_CRE_APPT,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_Z0_TOWN'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_Z0_TOWN,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_Z0_TOWN) THEN
  YRECFM='D_Z0_TOWN'
  YCOMMENT='X_Y_'//YRECFM//' (m)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_Z0_TOWN,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_BLD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_BLD,IRESP,HCOMMENT=YCOMMENT)
!
! Fraction of buildings
IF (DTT%LDATA_BLD) THEN
  YRECFM='D_BLDFRA'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_BLD,IRESP,YCOMMENT)
!
! Fraction of buildings
  YRECFM='D_RDFRA'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_ROAD,IRESP,YCOMMENT)
!
! Fraction of high vegetation
  YRECFM='D_FRAC_HVEG'
  YCOMMENT='X_Y_D_FRAC_HVEG'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_FRAC_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
!
! Fraction of low vegetation
  YRECFM='D_FRAC_LVEG'
  YCOMMENT='X_Y_D_FRAC_LVEG'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_FRAC_LVEG(:),IRESP,HCOMMENT=YCOMMENT)
!
! Fraction of no vegetation
  YRECFM='D_FRAC_NVEG'
  YCOMMENT='X_Y_D_FRAC_NVEG'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_FRAC_NVEG(:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_GREENROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_GREENROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_GREENROOF) THEN
  YRECFM='D_GREENROOF'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_GREENROOF,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_ROAD_DIR'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_ROAD_DIR,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ROAD_DIR) THEN
  YRECFM='D_ROAD_DIR'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_ROAD_DIR,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_ALB_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_ALB_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ALB_ROOF) THEN
  YRECFM='D_ALB_ROOF'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_ALB_ROOF,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_EMIS_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_EMIS_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_EMIS_ROOF) THEN
  YRECFM='D_EMI_ROOF'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_EMIS_ROOF,IRESP,YCOMMENT)
ENDIF
!
IF (DTT%LDATA_HC_ROOF) THEN
  YCOMMENT='Number of specified Roof thermal layers'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,'PAR_RF_LAYER',DTT%NPAR_ROOF_LAYER,IRESP,YCOMMENT)
END IF
!
YRECFM='L_HC_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_HC_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_HC_ROOF) THEN
  DO JL=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_ROOF',JL
    YCOMMENT='X_Y_'//YRECFM//' (J/K/m3)'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_HC_ROOF(:,JL),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_TC_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_TC_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_TC_ROOF) THEN
  DO JL=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_ROOF',JL
    YCOMMENT='X_Y_'//YRECFM//' (W/K/m)'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_TC_ROOF(:,JL),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_D_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_D_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_D_ROOF) THEN
  DO JL=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_ROOF',JL
    YCOMMENT='X_Y_'//YRECFM//' (m)'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_D_ROOF(:,JL),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_ALB_ROAD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_ALB_ROAD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ALB_ROAD) THEN
  YRECFM='D_ALB_ROAD'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_ALB_ROAD,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_EMIS_ROAD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_EMIS_ROAD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_EMIS_ROAD) THEN
  YRECFM='D_EMI_ROAD'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_EMIS_ROAD,IRESP,YCOMMENT)
ENDIF
!
IF (DTT%LDATA_HC_ROAD) THEN
  YCOMMENT='Number of specified Road thermal layers'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,'PAR_RD_LAYER',DTT%NPAR_ROAD_LAYER,IRESP,YCOMMENT)
END IF
!
YRECFM='L_HC_ROAD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_HC_ROAD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_HC_ROAD) THEN
  DO JL=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_ROAD',JL
    YCOMMENT='X_Y_'//YRECFM//' (J/K/m3)'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_HC_ROAD(:,JL),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_TC_ROAD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_TC_ROAD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_TC_ROAD) THEN
  DO JL=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_ROAD',JL
    YCOMMENT='X_Y_'//YRECFM//' (W/K/m)'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_TC_ROAD(:,JL),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_D_ROAD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_D_ROAD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_D_ROAD) THEN
  DO JL=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_ROAD',JL
    YCOMMENT='X_Y_'//YRECFM//' (m)'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_D_ROAD(:,JL),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_ALB_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_ALB_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ALB_WALL) THEN
  YRECFM='D_ALB_WALL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_ALB_WALL,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_EMIS_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_EMIS_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_EMIS_WALL) THEN
  YRECFM='D_EMI_WALL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_EMIS_WALL,IRESP,YCOMMENT)
ENDIF
!
!
IF (DTT%LDATA_HC_WALL) THEN
  YCOMMENT='Number of specified Wall thermal layers'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,'PAR_WL_LAYER',DTT%NPAR_WALL_LAYER,IRESP,YCOMMENT)
END IF
!
YRECFM='L_HC_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_HC_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_HC_WALL) THEN
  DO JL=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_WALL',JL
    YCOMMENT='X_Y_'//YRECFM//' (J/K/m3)'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_HC_WALL(:,JL),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_TC_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_TC_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_TC_WALL) THEN
  DO JL=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_WALL',JL
    YCOMMENT='X_Y_'//YRECFM//' (W/K/m)'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_TC_WALL(:,JL),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_D_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_D_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_D_WALL) THEN
  DO JL=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_WALL',JL
    YCOMMENT='X_Y_'//YRECFM//' (m)'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_D_WALL(:,JL),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_BLD_HEIGHT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_BLD_HEIGHT,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_BLD_HEIGHT) THEN
  YRECFM='D_BLD_HEIG'
  YCOMMENT='X_Y_'//YRECFM//' (m)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_BLD_HEIGHT,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_WALL_O_HOR'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_WALL_O_HOR,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_WALL_O_HOR) THEN
  YRECFM='D_WALL_O_H'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_WALL_O_HOR,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_H_TRAF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_H_TRAFFIC,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_H_TRAFFIC) THEN
  YRECFM='D_H_TRAF'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_H_TRAFFIC,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_LE_TRAF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_LE_TRAFFIC,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_LE_TRAFFIC) THEN
  YRECFM='D_LE_TRAF'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_LE_TRAFFIC,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_H_IND'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_H_INDUSTRY,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_H_INDUSTRY) THEN
  YRECFM='D_H_IND'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_H_INDUSTRY,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_LE_IND'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_LE_INDUSTRY,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_LE_INDUSTRY) THEN
  YRECFM='D_LE_IND'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_LE_INDUSTRY,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_ROUGH_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_ROUGH_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ROUGH_ROOF) THEN
  YRECFM='D_ROUGH_ROOF'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_ROUGH_ROOF,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_ROUGH_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_ROUGH_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ROUGH_WALL) THEN
  YRECFM='D_ROUGH_WALL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_ROUGH_WALL,IRESP,YCOMMENT)
ENDIF
!
!* solar panels
!
YRECFM='L_EMIS_PANEL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_EMIS_PANEL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_EMIS_PANEL) THEN
  YRECFM='D_EMIS_PANEL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_EMIS_PANEL,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_ALB_PANEL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_ALB_PANEL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ALB_PANEL) THEN
  YRECFM='D_ALB_PANEL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_ALB_PANEL,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_EFF_PANEL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_EFF_PANEL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_EFF_PANEL) THEN
  YRECFM='D_EFF_PANEL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_EFF_PANEL,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRAC_PANEL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%LDATA_FRAC_PANEL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRAC_PANEL) THEN
  YRECFM='D_FRAC_PANEL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTT%XPAR_FRAC_PANEL,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_NB_POP'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, &
                HPROGRAM,YRECFM,DTT%LDATA_NB_POP,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_NB_POP) THEN
  YRECFM='D_NB_POP'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTT%XPAR_NB_POP,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_SFCO2_RD'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, &
                HPROGRAM,YRECFM,DTT%LDATA_SFCO2_RD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_SFCO2_RD) THEN
  YRECFM='D_SFCO2_RD'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTT%XPAR_SFCO2_RD,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_DELTA_LEGAL_TIME'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, &
                HPROGRAM,YRECFM,DTT%LDATA_DELTA_LEGAL_TIME,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_DELTA_LEGAL_TIME) THEN
  YRECFM='D_DELTA_LEGAL_TIME'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTT%XPAR_DELTA_LEGAL_TIME,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_TIME_OF_CHANGE'
YCOMMENT=YRECFM
CALL WRITE_SURF(HSELECT, &
                HPROGRAM,YRECFM,DTT%LDATA_TIME_OF_CHANGE,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_TIME_OF_CHANGE) THEN
  YRECFM='D_TIME_OF_CHANGE'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTT%XPAR_TIME_OF_CHANGE,IRESP,YCOMMENT)
ENDIF
!
!* Building Energy Model
!
IF (TOP%CBEM .EQ. 'BEM') CALL WRITESURF_PGD_BEM_PAR_n(HSELECT, HPROGRAM, DTB, BOP)
!
! Flag for data for gardens
YRECFM='PAR_GARDEN'
YCOMMENT='FLAG FOR SPECIFIED GARDEN PARAMETERS'
 CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,GDO%LPAR,IRESP,HCOMMENT=YCOMMENT)
!
IF (TOP%LGARDEN ) THEN
!
  IF (GDO%LPAR) THEN

    YRECFM='GD_NTIME'
    YCOMMENT=YRECFM
    CALL WRITE_SURF(HSELECT, &
                   HPROGRAM,YRECFM,DTGD%NTIME,IRESP,HCOMMENT=YCOMMENT)
!
! Type of high vegetation
    YRECFM='D_TYPE_HVEG'
    YCOMMENT='X_Y_TYPE_HVEG'
    CALL WRITE_SURF(HSELECT, &
                   HPROGRAM,YRECFM,GDO%CTYPE_HVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Type of low vegetation
    YRECFM='D_TYPE_LVEG'
    YCOMMENT='X_Y_TYPE_LVEG'
    CALL WRITE_SURF(HSELECT, &
                   HPROGRAM,YRECFM,GDO%CTYPE_LVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Type of bare soil (no vegetation)
    YRECFM='D_TYPE_NVEG'
    YCOMMENT='X_Y_TYPE_NVEG'
    CALL WRITE_SURF(HSELECT, &
                   HPROGRAM,YRECFM,GDO%CTYPE_NVEG,IRESP,HCOMMENT=YCOMMENT)
!
! LAI of high vegetation
    DO JTIME=1,DTGD%NTIME
      WRITE(YRECFM,FMT='(A10,I2.2)') 'D_LAI_HVEG',JTIME
      YCOMMENT='X_Y_D_LAI_HVEG'
      CALL WRITE_SURF(HSELECT, &
                   HPROGRAM,YRECFM,DTGD%XPAR_LAI_HVEG(:,JTIME),IRESP,HCOMMENT=YCOMMENT)
    END DO
!
! LAI of low vegetation
    DO JTIME=1,DTGD%NTIME
      WRITE(YRECFM,FMT='(A10,I2.2)') 'D_LAI_LVEG',JTIME
      YCOMMENT='X_Y_D_LAI_LVEG'
      CALL WRITE_SURF(HSELECT, &
                   HPROGRAM,YRECFM,DTGD%XPAR_LAI_LVEG(:,JTIME),IRESP,HCOMMENT=YCOMMENT)
    END DO
!
  END IF
!
! Height of trees
  IF (TOP%CURBTREE=='TREE'.OR.TOP%CURBTREE=='GRWL') THEN
    YRECFM='L_GD_H_VEG'
    YCOMMENT=YRECFM
    CALL WRITE_SURF(HSELECT, &
                    HPROGRAM,YRECFM,DTGD%LDATA_H_VEG,IRESP,HCOMMENT=YCOMMENT)

    IF (DTGD%LDATA_H_VEG(1)) THEN
      YRECFM='D_GD_H_VEG'
      YCOMMENT='X_Y_DATA_GD_H_VEG'
      CALL WRITE_SURF(HSELECT, &
                     HPROGRAM,YRECFM,DTGD%XPAR_H_VEG(:,1,1),IRESP,HCOMMENT=YCOMMENT)
    END IF
  END IF
!
! respiration coefiicient
  YRECFM='L_GD_RE25'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTGD%LDATA_RE25,IRESP,HCOMMENT=YCOMMENT)
  !
  IF (DTGD%LDATA_RE25(1)) THEN
    YRECFM='D_GD_RE25'
    YCOMMENT='X_Y_'//YRECFM//' (kg.m-2.s-1)'
    CALL WRITE_SURF(HSELECT, &
                    HPROGRAM,YRECFM,DTGD%XPAR_RE25(:,1),IRESP,YCOMMENT)
  ENDIF
  !
ENDIF
!
IF (TOP%LGREENROOF .AND. GRO%LPAR) THEN
!
! Type of green roof
  YRECFM='D_TYPE_GR'
  YCOMMENT='X_Y_TYPE_GR'
  CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,GRO%CTYP_COV,IRESP,HCOMMENT=YCOMMENT)
!
! Fraction of OM in green roof layer
  DO JL=1,GRO%NGROUND_LAYER
    WRITE(YRECFM,FMT='(A7,I2.2)') 'D_OM_GR',JL
    YCOMMENT='X_Y_D_OM_GR'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,GRS%XSOC(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
!
! Fraction of CLAY in the non-OM part of the green roof layer
  DO JL=1,GRO%NGROUND_LAYER
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_CLAY_GR',JL
    YCOMMENT='X_Y_D_CLAY_GR'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,GRK%XCLAY(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
!
! Fraction of SAND in the non-OM part of the green roof layer
  DO JL=1,GRO%NGROUND_LAYER
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_SAND_GR',JL
    YCOMMENT='X_Y_D_SAND_GR'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,GRK%XSAND(:,JL),IRESP,HCOMMENT=YCOMMENT)
  END DO
!
! LAI of green roof vegetation
  DO JTIME=1,DTGR%NTIME
    WRITE(YRECFM,FMT='(A8,I2.2)') 'D_LAI_GR',JTIME
    YCOMMENT='X_Y_D_LAI_GR'
    CALL WRITE_SURF(HSELECT, &
                 HPROGRAM,YRECFM,DTGR%XPAR_LAI(:,JTIME,1),IRESP,HCOMMENT=YCOMMENT)
  END DO
! 
ENDIF
!
IF (TOP%CURBTREE .EQ. 'TREE') THEN
  !
  ! Height of trunk of urban trees
  !
  YRECFM='D_HTRUN_HVEG'
  YCOMMENT='X_Y_D_HTRUNK_HVEG'
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTGD%XPAR_HTRUNK_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
! Width of crown of urban trees
  YRECFM='D_WCROW_HVEG'
  YCOMMENT='X_Y_D_WCROWN_HVEG'
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTGD%XPAR_WCROWN_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
ENDIF 
!
IF (TOP%LURBHYDRO) THEN
! Waste water sewer length
  YRECFM='D_LSEWER'
  YCOMMENT='X_Y_LSEWER'
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTH%XPAR_LSEWER,IRESP,HCOMMENT=YCOMMENT)
! Storm water sewer length
  YRECFM='D_LSTORM'
  YCOMMENT='X_Y_LSTORM'
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTH%XPAR_LSTORM,IRESP,HCOMMENT=YCOMMENT)
! Waste water sewer depth
  YRECFM='D_DSEWER'
  YCOMMENT='X_Y_DSEWER'
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTH%XPAR_DSEWER,IRESP,HCOMMENT=YCOMMENT)
! Max. capacity of surface roof water storage
  YRECFM='D_WS_RF_MAX'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTH%XPAR_WS_ROOF_MAX,IRESP,HCOMMENT=YCOMMENT)
! Max. capacity of surface road water storage
  YRECFM='D_WS_RD_MAX'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTH%XPAR_WS_ROAD_MAX,IRESP,HCOMMENT=YCOMMENT)
! Parameter for parasite infiltrations into sewer
  YRECFM='D_IP_SEWER'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTH%XPAR_IP_SEWER,IRESP,HCOMMENT=YCOMMENT)
! Impervious surfaces connexion rate to the sewer
  YRECFM='D_CONNEX'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTH%XPAR_CONNEX,IRESP,HCOMMENT=YCOMMENT)
! Water infiltration through the roads
  YRECFM='D_INFIL_RD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTH%XPAR_INFIL_ROAD,IRESP,HCOMMENT=YCOMMENT)
! Limtation of drainage
  YRECFM='D_URBDRAIN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(HSELECT, &
                  HPROGRAM,YRECFM,DTH%XPAR_URBDRAIN,IRESP,HCOMMENT=YCOMMENT)       
ENDIF 
!
!-------------------------------------------------------------------------------
!
!*      Irrigation of gardens or greenroofs
!       -----------------------------------
!
CALL WRITESURF_PGD_TEB_IRRIG_n(HSELECT, TIR, HPROGRAM)
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_PGD_TEB_PAR_N',1,ZHOOK_HANDLE)
!
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE WRITESURF_PGD_TEB_PAR_n
