!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITE_DIAG_SEB_SURF_ATM_n (DTCO, DGO, D, DC, U, HGRID, HPROGRAM)
!     #################################
!
!!****  *WRITE_DIAG_SEB_SURF_ATM_n* - writes surface diagnostics
!!
!!    PURPOSE
!!    -------
!!
!!
!!**  METHOD
!!    ------
!!
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      Modified    01/2006 : sea flux parameterization.
!!      Modified    08/2009 : cumulated diag
!!      Juan        6/12/2011: parallel bug , remove local ANY(XAVG_ZON10M) test
!!      B. Decharme  06/13   Add QS, evap and sublimation diags
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DIAG_n, ONLY : DIAG_t, DIAG_OPTIONS_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_SURF_PAR, ONLY : XUNDEF
!
USE MODD_XIOS, ONLY : LALLOW_ADD_DIM, YSWBAND_DIM_NAME
!
USE MODI_INIT_IO_SURF_n
USE MODI_WRITE_SURF
USE MODI_END_IO_SURF_n
USE MODI_SUM_ON_ALL_PROCS
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DIAG_OPTIONS_t), INTENT(INOUT) :: DGO
TYPE(DIAG_t), INTENT(INOUT) :: D
TYPE(DIAG_t), INTENT(INOUT) :: DC
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
 CHARACTER(LEN=*), INTENT(IN) :: HGRID
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!

INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
 CHARACTER(LEN=2)  :: YNUM
!
INTEGER           :: JSW
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!         Initialisation for IO
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_SURF_ATM_N',0,ZHOOK_HANDLE)
 CALL INIT_IO_SURF_n(DTCO, U, HPROGRAM,'FULL  ','SURF  ','WRITE','SURF_ATM_DIAGNOSTICS.OUT.nc')
!
!*       1.     Richardson number :
!               -----------------
!
IF (DGO%N2M>=1) THEN
  !        
  YRECFM='RI'
  YCOMMENT='X_Y_'//YRECFM
  !
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XRI(:),IRESP,HCOMMENT=YCOMMENT)
  !
ENDIF
!
!*       2.     parameters at surface, 2 and 10 meters :
!               ----------------------------------------
!
IF (DGO%N2M>=1.OR.DGO%LSURF_BUDGET.OR.DGO%LSURF_BUDGETC) THEN
  !
  YRECFM='TS'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XTS(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='TSRAD'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XTRAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='EMIS'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XEMIS(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SFCO2'
  YCOMMENT='X_Y_'//YRECFM//' (M.kgCO2.S-1.kgAIR-1)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XSFCO2(:),IRESP,HCOMMENT=YCOMMENT)
  !
ENDIF
!
IF (DGO%N2M>=1) THEN
  !
  YRECFM='T2M'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XT2M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='T2MMIN'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XT2M_MIN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='T2MMAX'
  YCOMMENT='X_Y_'//YRECFM//' (K)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XT2M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='Q2M'
  YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XQ2M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='HU2M'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XHU2M(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='HU2MMIN'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XHU2M_MIN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='HU2MMAX'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XHU2M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF ( SUM_ON_ALL_PROCS(HPROGRAM,HGRID,D%XZON10M(:)/= XUNDEF) > 0. ) THEN
    !
    YRECFM='ZON10M'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XZON10M(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='MER10M'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XMER10M(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='W10M'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XWIND10M(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='W10MMAX'
    YCOMMENT='X_Y_'//YRECFM//' (M/S)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XWIND10M_MAX(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  IF (DGO%L2M_MIN_ZS) THEN
    !
    YRECFM='T2M_MIN_ZS'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XT2M_MIN_ZS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='Q2M_MIN_ZS'
    YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XQ2M_MIN_ZS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HU2M_MIN_ZS'
    YCOMMENT='X_Y_'//YRECFM//' (KG/KG)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XHU2M_MIN_ZS(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
  !
END IF
!
!*       3.     Energy fluxes :
!               -------------
!
IF (DGO%LSURF_BUDGET) THEN
  !
  YRECFM='RN'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XRN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XLE(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LEI'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XLEI(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='QF'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XQF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='EVAP'
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
  !
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XEVAP(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SUBL'
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2/s)'
  !
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XSUBL(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (DGO%LRAD_BUDGET) THEN
    !         
    YRECFM='SWD'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XSWD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWU'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XSWU(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWD'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XLWD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWU'
    YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XLWU(:),IRESP,HCOMMENT=YCOMMENT)
    !
    IF (LALLOW_ADD_DIM)  THEN 
      !
      YRECFM='SWD_'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
      CALL WRITE_SURF(DGO%CSELECT,&
           HPROGRAM,YRECFM,D%XSWBD(:,:),IRESP,HCOMMENT=YCOMMENT, HNAM_DIM=YSWBAND_DIM_NAME)
      !
      YRECFM='SWU_'
      YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
      CALL WRITE_SURF(DGO%CSELECT,&
           HPROGRAM,YRECFM,D%XSWBD(:,:),IRESP,HCOMMENT=YCOMMENT, HNAM_DIM=YSWBAND_DIM_NAME)
       !
    ELSE
      !    
      DO JSW=1, SIZE(D%XSWBD,2)
        YNUM=ACHAR(48+JSW)
        !
        YRECFM='SWD_'//YNUM
        YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
        CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XSWBD(:,JSW),IRESP,HCOMMENT=YCOMMENT)
        !
        YRECFM='SWU_'//YNUM
        YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
        CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XSWBU(:,JSW),IRESP,HCOMMENT=YCOMMENT)
        !
      ENDDO
      !
    ENDIF
    !
  ENDIF
  !
  YRECFM='FMUNOSSO'
  YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XFMU(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FMVNOSSO'
  YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XFMV(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FMU'
  YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XSSO_FMU(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FMV'
  YCOMMENT='X_Y_'//YRECFM//' (kg/ms2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XSSO_FMV(:),IRESP,HCOMMENT=YCOMMENT)
  !
END IF
!
! * Cumulated diag
!
IF (DGO%LSURF_BUDGETC) THEN
  !
  YRECFM='RNC'
  YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XRN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='HC'
  YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LEC'
  YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XLE(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LEIC'
  YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XLEI(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUXC'
  YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='EVAPC'
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2)'
  !
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XEVAP(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SUBLC'
  YCOMMENT='X_Y_'//YRECFM//' (kg/m2)'
  !
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XSUBL(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (DGO%LRAD_BUDGET .OR. (DGO%LSURF_BUDGETC .AND. .NOT.DGO%LRESET_BUDGETC)) THEN
    !        
    YRECFM='SWDC'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XSWD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWUC'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XSWU(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWDC'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XLWD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWUC'
    YCOMMENT='X_Y_'//YRECFM//' (J/m2)'
    CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XLWU(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  YRECFM='FMUC'
  YCOMMENT='X_Y_'//YRECFM//' (kg/ms)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XFMU(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FMVC'
  YCOMMENT='X_Y_'//YRECFM//' (kg/ms)'
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,DC%XFMV(:),IRESP,HCOMMENT=YCOMMENT)
  !
END IF
!
!
!*       4.     Transfer coefficients
!               ---------------------
!
IF (DGO%LCOEF) THEN
  !
  YRECFM='CD'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XCD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='CH'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XCH(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='CE'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XCE(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='Z0'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XZ0(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='Z0H'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XZ0H(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='UREF'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XUREF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='ZREF'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XZREF(:),IRESP,HCOMMENT=YCOMMENT)
  !
END IF
!
!
!*       5.     Surface humidity
!               ----------------
!
IF (DGO%LSURF_VARS) THEN
!
YRECFM='QS'
YCOMMENT='X_Y_'//YRECFM//' (kg/kg)'
!
 CALL WRITE_SURF(DGO%CSELECT,HPROGRAM,YRECFM,D%XQS(:),IRESP,HCOMMENT=YCOMMENT)
!
ENDIF
!
!-------------------------------------------------------------------------------
!
!         End of IO
!
 CALL END_IO_SURF_n(HPROGRAM)
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_SEB_SURF_ATM_N',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE WRITE_DIAG_SEB_SURF_ATM_n
