!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE WRITE_DIAG_MISC_TEB_n (DTCO, HSELECT, U, DMTC, DMT, DMTO, &
                                        GDD, GDDE, GDDEC, GRD, GRDE, GRDEC, &
                                        T, TOP, IO, HPROGRAM,KTEB_PATCH)
!     #################################
!
!!****  *WRITE_DIAG_MISC_TEB* - writes the TEB diagnostic fields
!!
!!    PURPOSE
!!    -------
!!
!!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      P. Le Moigne   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    10/2004
!!      
!!      E. Redon   06/2017 add diagnostic for urban trees
!!      M.Goret    07/2017  add new diagnostics for CO2 fluxes
!!      M.Goret    09/2017 add diagnostic of heat storage link to snow
!!      M.Goret    10/2017 add diagnostic fot hot water
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_DIAG_MISC_TEB_n, ONLY : DIAG_MISC_TEB_t
USE MODD_DIAG_MISC_TEB_OPTIONS_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
USE MODD_TEB_n, ONLY : TEB_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODD_DIAG_n, ONLY : DIAG_t
USE MODD_ISBA_OPTIONS_n, ONLY : ISBA_OPTIONS_t
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
!
USE MODI_INIT_IO_SURF_n
USE MODI_WRITE_SURF
USE MODD_SURF_PAR,       ONLY : XUNDEF
USE MODI_END_IO_SURF_n
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
 CHARACTER(LEN=*), DIMENSION(:), INTENT(IN) :: HSELECT
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DMTC
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DMT
TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DMTO
TYPE(TEB_t), INTENT(INOUT) :: T
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
TYPE(ISBA_OPTIONS_t), INTENT(INOUT) :: IO
!
TYPE(DIAG_t), INTENT(INOUT) :: GDD
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: GDDE
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: GDDEC
TYPE(DIAG_t), INTENT(INOUT) :: GRD
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: GRDE
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: GRDEC
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM   ! program calling
INTEGER,           INTENT(IN)  :: KTEB_PATCH ! patch number being written
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER            :: IRESP          ! IRESP  : return-code if a problem appears
INTEGER            :: JCOMP
 CHARACTER(LEN=3)  :: YPATCH         ! Prefix for current patch
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!           Initialisation for IO
!           ---------------------
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_MISC_TEB_N',0,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
IF (DMTO%LSURF_MISC_BUDGET) THEN
  !
  YPATCH = '   '
  IF (TOP%NTEB_PATCH>1) WRITE(YPATCH,FMT='(A,I1,A)') 'T',KTEB_PATCH,'_'
  !
  CALL INIT_IO_SURF_n(DTCO, U,    HPROGRAM,'TOWN  ','TEB   ','WRITE','TEB_DIAGNOSTICS.OUT.nc')
  !
  !*       Miscellaneous fields :
  !        ----------------------
  !
  YRECFM='D_RD'
  YCOMMENT='Road fraction'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='Z0_TOWN'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='town roughness length'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,T%XZ0_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='XQF_BLD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='domestic heating'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQF_BLD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='XQF_TOWN'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='total anthropogenic heat'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQF_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='XDQS_TOWN'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='heat storage inside building'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDQS_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFF_TW'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='aggregated runoff for town'//' (kg/m2/s)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRUNOFF_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RN_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT=' net radiation at road'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='road sensible heat flux'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='road latent heat flux'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net road conduction flux'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFF_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='road surface runoff'//' (kg/m2/s)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRUNOFF_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FSNOW_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Fraction of road covered by snow'//' (1)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDN_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FSNOW_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Fraction of roof covered by snow'//' (1)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDN_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FWATER_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Fraction of road covered by water'//' (1)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='FWATER_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Fraction of roof covered by water'//' (1)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (TOP%CWALL_OPT=='UNIF') THEN
    !
    YRECFM='RN_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for wall '//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall sensible heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall latent heat flux'//YRECFM//' (W/m2)'
    !
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net wall conduction flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ELSE
    !
    YRECFM='RN_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for wall A'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall A sensible heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall A latent heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net wall A conduction flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RN_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for wall B'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall B sensible heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall B latent heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
  !
    YRECFM='GFLUX_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net wall B conduction flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  YRECFM='RN_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net radiation for roof'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='roof sensible heat flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='roof latent heat flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net roof conduction flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFF_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='aggregated roof runoff'//' (kg/m2/s)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRUNOFF_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  !
  IF (TOP%LGARDEN) THEN
    !
    YRECFM='RN_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for GARDEN areas'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDD%XRN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GARDEN area sensible heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDD%XH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GARDEN area latent heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDD%XLE(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net GARDEN area conduction flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDD%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RUNOFF_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='garden surface runoff'//' (kg/m2/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDDE%XRUNOFF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    IF (TOP%CURBTREE/='NONE') THEN
      !
      YRECFM='H_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='High vegetation sensible heat flux'//YRECFM//' (W/m2)'
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='LE_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='High vegetation latent heat flux'//YRECFM//' (W/m2)'
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
!
  ENDIF
  !
  YRECFM='RN_BLT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='net radiation for built surfaces'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_BLT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_BLT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='built surface sensible heat flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_BLT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_BLT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='built surface latent heat flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_BLT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='GFLUX_BLT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='built surface conduction flux'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_BLT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_TRAACT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Traffic sensible heat flux'//YRECFM//' (W/m2(urb))'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_TRAFFIC_OUT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_TRAACT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Traffic latent heat flux'//YRECFM//' (W/m2(urb))'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_TRAFFIC_OUT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='H_INDACT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Industry sensible heat flux'//YRECFM//' (W/m2(urb))'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_INDUSTRY_OUT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_INDACT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Industry latent heat flux'//YRECFM//' (W/m2(urb))'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_INDUSTRY_OUT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='QF_BLT'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='built surface anthropogenic flux'//YRECFM//' (W/m2(urb))'
  !
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQF_BLT(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='QF_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='road surface anthropogenic flux'//YRECFM//' (W/m2(road))'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQF_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='QF_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='roof surface anthropogenic flux'//YRECFM//' (W/m2(roof))'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQF_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='QSNOW_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='heat storage link to snow-coverage on road'//YRECFM//' (W/m2(road))'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSNOW_HEAT_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='QSNOW_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='heat storage link to snow-coverage on roof'//YRECFM//' (W/m2(roof))'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSNOW_HEAT_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWA_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by roofs'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWA_SN_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by snow on roofs'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_SNOW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWU_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown reflected by roofs'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSW_UP_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWU_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown emitted by roofs'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLW_UP_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by roofs'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_SN_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by snow on roofs'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_SNOW_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='DIR_SW_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Direct Sdown received by roads'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDIR_SW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SCA_SW_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Scattered Sdown received by roads'//' (W/m2)'
  !
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSCA_SW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWA_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by roads'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWA_SN_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown absorbed by snow on roads'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_SNOW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by roads'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWA_SN_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown absorbed by snow on roads'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_SNOW_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (TOP%CWALL_OPT=='UNIF') THEN
    !
    YRECFM='QF_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall anthropogenic flux'//YRECFM//' (W/m2(façade))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQF_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DIR_SW_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Dir Sdown received by wall'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDIR_SW_WALL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SCA_SW_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Scattered Sdown received by wall'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSCA_SW_WALL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWA_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by wall'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by wall '//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ELSE
    YRECFM='QF_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall A anthropogenic flux'//YRECFM//' (W/m2(façade))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQF_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='QF_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='wall B anthropogenic flux'//YRECFM//' (W/m2(façade))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQF_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DIR_SW_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Dir Sdown received by wall A'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDIR_SW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DIR_SW_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Dir Sdown received by wall B'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDIR_SW_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SCA_SW_WL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Scattered Sdown received by wall'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSCA_SW_WALL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWA_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by wall A'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_WLA'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by wall A'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_WALL_A(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWA_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by wall B'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_WLB'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by wall B'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_WALL_B(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  IF (TOP%LGARDEN) THEN
    !
    YRECFM='DIR_SW_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Direct Sdown received by garden areas'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDIR_SW_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SCA_SW_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Scattered Sdown received by garden areas'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSCA_SW_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWA_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by GARDEN areas'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by GARDEN areas'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWR_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown received by urban green areas'//' (W/m2)'
    CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XREC_SW_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWR_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown received by urban green areas'//' (W/m2)'
    CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XREC_LW_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    IF (TOP%CURBTREE/='NONE') THEN
      !
      YRECFM='DIR_SW_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Direct Sdown received by urban high vegetation'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XDIR_SW_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='NTR_DIRSW_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Direct Sdown received by urban high vegetation corrected from transmission'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XNTR_DIR_SW_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='SCA_SW_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Scattered Sdown received by urban high vegetation'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XSCA_SW_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='SWA_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Sdown absorbed by urban high vegetation'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XABS_SW_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='LWA_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Ldown absorbed by urban high vegetation'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XABS_LW_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='SWR_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Sdown received by urban high vegetation'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XREC_SW_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='SWR_VEG'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Sdown received by urban vegetation'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XREC_SW_VEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='LWR_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Ldown received by urban high vegetation'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XREC_LW_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='LWR_VEG'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Ldown received by urban vegetation'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XREC_LW_VEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='NET_LW_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='IR rad absorbed by high vegetation'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XNET_LW_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='TS_HV'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Surface temperature of urban high vegetation s foliage'//' (K)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XTS_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='SWA_SK'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Sdown absorbed by the sky'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XABS_SW_SKY(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='LWA_SK'
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Ldown absorbed by the sky'//' (W/m2)'
      CALL WRITE_SURF(HSELECT, HPROGRAM,YRECFM,DMT%XABS_LW_SKY(:),IRESP,HCOMMENT=YCOMMENT)
      !
    ENDIF
  !
  ENDIF
  !
  YRECFM='REF_SW_GO'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Total solar rad reflected by ground '//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XREF_SW_GRND(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWE_GO'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='LW emitted by ground'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XEMIT_LW_GRND(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='REF_SW_FA'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Total solar rad reflected by facade '//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XREF_SW_FAC(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWE_FA'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='LW emitted by facade'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XEMIT_LW_FAC(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SWU_CAN'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Sdown reflected by the canyon'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSW_UP_CAN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LWU_CAN'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='Ldown emitted by the canyon'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLW_UP_CAN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  !
  YRECFM='H_WASTE_ROOF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='sensible waste heat at roof level'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_WASTE_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='LE_WASTE_ROOF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='latent waste heat at roof level'//' (W/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_WASTE_ROOF(:),IRESP,HCOMMENT=YCOMMENT)  
  !
  IF (TOP%CBEM=='BEM') THEN
    !
    YRECFM='XFLX_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heat flux from bld'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XFLX_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_BLD_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible cooling demand'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_BLD_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_BLD_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent cooling demand'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_BLD_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_WASTE_CANY'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible waste heat to canyon'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_WASTE_CANY(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_WASTE_CANY'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent waste heat to canyon'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_WASTE_CANY(:),IRESP,HCOMMENT=YCOMMENT)

    !
    YRECFM='HVAC_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cooling energy consumption'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHVAC_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    DO JCOMP=1,SIZE(DMT%XCOMP_HVAC_COOL,2)
       WRITE(YRECFM,'(A8,I1.1)') 'HVAC_CL_',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='cooling energy consumption'//' (W/m2)'
       CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XCOMP_HVAC_COOL(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    YRECFM='HVAC_HT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heating energy consumption'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHVAC_HEAT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    DO JCOMP=1,SIZE(DMT%XCOMP_HVAC_HEAT,2)
       WRITE(YRECFM,'(A8,I1.1)') 'HVAC_HT_',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='heating energy consumption'//' (W/m2)'
       CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XCOMP_HVAC_HEAT(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    YRECFM='QINACT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual internal energy release'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQINOUT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='QINHOTW'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Energy consumption, domestic warm water'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHOTWATOUT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVAC_HT_ELEC'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heating energy consumption'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHVAC_HEAT_ELEC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVAC_HT_GAS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heating energy consumption'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHVAC_HEAT_GAS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVAC_HT_FUEL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heating energy consumption'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHVAC_HEAT_FUEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVAC_HT_OTHER'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heating energy consumption'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHVAC_HEAT_OTHER(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HOTWAT_GAS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='gas hot water energy consumption'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHOTWAT_GAS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HOTWAT_ELEC'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='elec. hot water energy consumption'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHOTWAT_ELEC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    DO JCOMP=1,SIZE(DMT%XCOMP_HOTWAT,2)
       WRITE(YRECFM,'(A7,I1.1)') 'HOTWAT_',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='hot water energy consumption'//' (W/m2)'
       CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XCOMP_HOTWAT(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    DO JCOMP=1,SIZE(DMT%XCOMP_QINOUT,2)
       !
       WRITE(YRECFM,'(A7,I1.1)') 'QINACT_',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Actual internal energy release'//' (W/m2)'
       CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XCOMP_QINOUT(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
       !
    ENDDO
    !
    YRECFM='INFCALC'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Calculated infiltration rate'//' (Vol/h)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XINFCALC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    DO JCOMP=1,SIZE(DMT%XDIAGSHAD,2)
       WRITE(YRECFM,'(A8,I1.1)') 'DIAGSHAD',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Shading usage'//' (1)'
       CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDIAGSHAD(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
       !
    ENDDO
    !
    DO JCOMP=1,SIZE(DMT%XDIAGVENT,2)
       WRITE(YRECFM,'(A8,I1.1)') 'DIAGVENT',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Ventilation usage'//' (1)'
       CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDIAGVENT(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    DO JCOMP=1,SIZE(DMT%XDIAGVEFL,2)
       WRITE(YRECFM,'(A8,I1.1)') 'DIAGVEFL',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Ventilation echange rate'//' (1/h)'
       CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XDIAGVEFL(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    DO JCOMP=1,SIZE(DMT%XBLDOCC,2)
       WRITE(YRECFM,'(A6,I1.1)') 'BLDOCC',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Building occupation status'//' (1)'
       CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XBLDOCC(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    YRECFM='SENFABSTOR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sensible heat stored in urban fabric'//' (W m-2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSENFABSTOR(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LATFABSTOR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Latent heat stored on urban fabric'//' (W m-2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLATFABSTOR(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='ROOFTK'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Total roof thickness'//' (m)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XROOFTK(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='WALLTK'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Total wall thickness'//' (m)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XWALLTK(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='MASSTK'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Total mass thickness'//' (m)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XMASSTK(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='U_LOWCAN'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Wind speed at lowest level of canyon'//' (m/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XU_LOWCAN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='ROAD_SHADE'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Fraction of road shaded'//' (1)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XROAD_SHADE(:),IRESP,HCOMMENT=YCOMMENT)
    !    
    YRECFM='QIN_KWH'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Internal heat release'//' (kWh/m²(floor)/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQIN_KWH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVAC_HT_KWH'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Heating energy demand'//' (kWh/m²(floor)/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHVAC_HT_KWH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVAC_CL_KWH'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Cooling energy demand'//' (kWh/m²(floor)/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XHVAC_CL_KWH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='CAP_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual capacity of the cooling system'//' (W m-2(bld))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XCAP_SYS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    ! At the moment only first compartment
    !
    YRECFM='M_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual HVAC mass flow rate'//' (kg s-1 m-2(bld))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XM_SYS(:,1),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='COP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Actual COP of the cooling system'//' ()'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XCOP(:),IRESP,HCOMMENT=YCOMMENT)  
    !
    ! At the moment only first compartment
    !
    YRECFM='Q_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Supply air specific humidity'//' (kg kg-1)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XQ_SYS(:,1),IRESP,HCOMMENT=YCOMMENT)
    !
    ! At the moment only first compartment
    !
    YRECFM='T_SYS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Supply air temperature'//' (K)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XT_SYS(:,1),IRESP,HCOMMENT=YCOMMENT)  
    !
    DO JCOMP=1,SIZE(DMT%XTR_SW_WIN,2)
       WRITE(YRECFM,'(A9,I1.1)') 'TR_SW_WIN',JCOMP
      YRECFM=ADJUSTL(YPATCH//YRECFM)
      YCOMMENT='Solar radiation transmitted through windows'//' (W m-2(bld))'
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XTR_SW_WIN(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    END DO
    !
    DO JCOMP=1,SIZE(DMT%XT_RAD_IND,2)
       WRITE(YRECFM,'(A9,I1.1)') 'T_RAD_IND',JCOMP
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='Indoor mean radiant temperature'//' (K)'
       CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XT_RAD_IND(:,JCOMP),IRESP,HCOMMENT=YCOMMENT)
    ENDDO
    !
    YRECFM='SWA_WIN'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by windows'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_WIN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_WIN'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by windows'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_WIN(:),IRESP,HCOMMENT=YCOMMENT)    
    !
  ENDIF
  !
  IF (TOP%LGREENROOF) THEN
  !
    WHERE (T%XGREENROOF(:) == 0.)
      GRD%XRN    (:) = XUNDEF   
      GRD%XH     (:) = XUNDEF 
      GRD%XLE    (:) = XUNDEF 
      GRD%XGFLUX (:) = XUNDEF 
      !
      DMT%XABS_SW_GREENROOF(:) = XUNDEF 
      DMT%XABS_LW_GREENROOF(:) = XUNDEF 
      DMT%XG_GREENROOF_ROOF(:) = XUNDEF 
      !
      GRDE%XRUNOFF(:) = XUNDEF 
      GRDE%XDRAIN (:) = XUNDEF 
    END WHERE
    !
    YRECFM='RN_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net radiation for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRD%XRN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='sensible heat flux for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRD%XH(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='latent heat flux for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRD%XLE(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='net conduction flux for GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRD%XGFLUX(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='SWA_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sdown absorbed by GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Ldown absorbed by GREENROOFs'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='G_GR_ROOF'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='heat flux between GREENROOF and ROOF'//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XG_GREENROOF_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RUNOFF_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF soil surface runoff'//' (kg/m2/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRDE%XRUNOFF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DRAIN_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF total vertical drainage'//' (kg/m2/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRDE%XDRAIN(:),IRESP,HCOMMENT=YCOMMENT)
  !
    WHERE (T%XGREENROOF(:) == 1.)
      DMT%XRN_STRLROOF(:)     = XUNDEF   
      DMT%XH_STRLROOF(:)      = XUNDEF   
      DMT%XLE_STRLROOF(:)     = XUNDEF   
      DMT%XGFLUX_STRLROOF(:)  = XUNDEF   
      DMT%XRUNOFF_STRLROOF(:) = XUNDEF   
    END WHERE
    !
    YRECFM='RN_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof net radiation'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof sensible heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LE_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof latent heat flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XLE_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='GFLUX_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof conduction flux'//YRECFM//' (W/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XGFLUX_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RUNOFF_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='structural roof surface runoff'//' (kg/m2/s)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRUNOFF_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
  ENDIF
  !
  !* solar panels
  IF (TOP%LSOLAR_PANEL) THEN
    YRECFM='SWA_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Shortwave absorbed by solar panels on roofs'//' (W/m2 panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_SW_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='LWA_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Longwave  absorbed by solar panels on roofs'//' (W/m2 panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XABS_LW_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='RN_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Net radiation of solar panels on roofs'//' (W/m2 panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XRN_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='H_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Sensible Heat flux  from solar panels on roofs'//' (W/m2 panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XH_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='PHOT_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Photovolatic production '//' (W/m2 photovoltaic panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XPHOT_PROD_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='THER_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Hot Water production '//' (W/m2 thermal panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XTHER_PROD_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='PROD_SP'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Production by solar panels on roofs'//' (W/m2 panel)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XPROD_PANEL(:),IRESP,HCOMMENT=YCOMMENT)
        !
    YRECFM='PHOT_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Photovolatic production '//' (W/m2 bld)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XPHOT_PROD_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='THER_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Hot Water production '//' (W/m2 bld)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XTHER_PROD_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
  !
  !*
  !*       3. Cumulated fields
  !           ----------------
  !
  CALL END_IO_SURF_n(HPROGRAM)
  CALL INIT_IO_SURF_n(DTCO, U,HPROGRAM,'TOWN  ','TEB   ','WRITE','TEB_DIAG_CUMUL.OUT.nc')
  !  
  IF  (TOP%CBEM=='BEM') THEN
    !
    YRECFM='HVACC_CL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated cooling energy consumption'//' (J/m2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHVAC_COOL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVACC_HT'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated heating energy consumption'//' (J/m2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHVAC_HEAT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='QINACTCUM'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated internal energy release'//' (J/m2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XQINOUT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVACC_HT_ELEC'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated elec heating energy consumption'//' (J/m2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHVAC_HEAT_ELEC(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVACC_HT_GAS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated gas heating energy consumption'//' (J/m2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHVAC_HEAT_GAS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVACC_HT_FUEL'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated fuel heating energy consumption'//' (J/m2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHVAC_HEAT_FUEL(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HVACC_HT_OTHER'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated other heating energy consumption'//' (J/m2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHVAC_HEAT_OTHER(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HOTWATC'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated hot water energy consumption'//' (J/m2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHOTWATOUT(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HOTWATC_GAS'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated gas hot water energy consumption'//' (J/m2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHOTWAT_GAS(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='HOTWATC_ELEC'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated elec. hot water energy consumption'//' (J/m2 (urb))'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XHOTWAT_ELEC(:),IRESP,HCOMMENT=YCOMMENT)
  !
  END IF
  !
  YRECFM='RUNOFFC_TW'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated aggregated runoff for town'//' (kg/m2)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XRUNOFF_TOWN(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFFC_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated road surface runoff'//' (kg/m2 road)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XRUNOFF_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='RUNOFFC_RF'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated aggregated roof runoff'//' (kg/m2 roof)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XRUNOFF_ROOF(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='IRRIGC_RD'
  YRECFM=ADJUSTL(YPATCH//YRECFM)
  YCOMMENT='cumulated road irrigation'//' (kg/m2 road)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XIRRIG_ROAD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  IF (TOP%LGARDEN) THEN
    !
    YRECFM='RUNOFFC_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated garden surface runoff'//' (kg/m2 garden)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDDEC%XRUNOFF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DRAINC_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated garden surface drainage'//' (kg/m2 garden)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDDEC%XDRAIN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='IRRIGC_GD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated garden irrigation'//' (kg/m2 garden)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XIRRIG_GARDEN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    IF (TOP%LURBHYDRO) THEN
       YRECFM='RUNOFFC_SW'
       YRECFM=ADJUSTL(YPATCH//YRECFM)
       YCOMMENT='cumulated groundwater drainage to sewer pipes'//' (kg/m2)'
       CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XRUNOFF_SEWER(:),IRESP,HCOMMENT=YCOMMENT)
    ENDIF
    !
    !
    IF(IO%CPHOTO/='NON')THEN
      YRECFM='GPP_GD'
      YCOMMENT='X_Y_'//YRECFM//' (kgCO2/m2/s)'
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDDE%XGPP(:),IRESP,HCOMMENT=YCOMMENT)
      !
      YRECFM='R_ECO_GD'
      YCOMMENT='X_Y_'//YRECFM//' (kgCO2/m2/s)'
      CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GDDE%XRESP_ECO(:),IRESP,HCOMMENT=YCOMMENT)
      !
    END IF
  END IF
  !
  IF (TOP%LGREENROOF) THEN
    !
    WHERE (T%XGREENROOF(:) == 0.)
      GRDEC%XRUNOFF (:) = XUNDEF   
      GRDEC%XDRAIN  (:) = XUNDEF 
      DMTC%XIRRIG_GREENROOF  (:) = XUNDEF 
    END WHERE
    !  
    YRECFM='RUNOFFC_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF cumulated soil surface runoff'//' (kg/m2 greenroof)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRDEC%XRUNOFF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='DRAINC_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF cumulated total vertical drainage'//' (kg/m2 greenroof)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,GRDEC%XDRAIN(:),IRESP,HCOMMENT=YCOMMENT)
    !
    !
    YRECFM='IRRIGC_GR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='GREENROOF cumulated irrigation'//' (kg/m2 greenroof)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XIRRIG_GREENROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
    WHERE (T%XGREENROOF(:) == 1.)
      DMTC%XRUNOFF_STRLROOF  (:) = XUNDEF   
    END WHERE 
    !
    YRECFM='RUNOFFC_SR'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='cumulated structural roof surface runoff'//' (kg/m2)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XRUNOFF_STRLROOF(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
  !  
  !* solar panels
  IF (TOP%LSOLAR_PANEL) THEN
    !
    YRECFM='PHOTC_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Cumulated Photovolatic production '//' (J/m2 bld)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XPHOT_PROD_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
    YRECFM='THERC_BLD'
    YRECFM=ADJUSTL(YPATCH//YRECFM)
    YCOMMENT='Cumulated Hot water production '//' (J/m2 bld)'
    CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMTC%XTHER_PROD_BLD(:),IRESP,HCOMMENT=YCOMMENT)
    !
  END IF
  !
  !* CO2 fluxes
  !
  YRECFM='SFCO2_T'
  YCOMMENT='X_Y_'//YRECFM//' (kgCO2.M-2.S-1)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSFCO2(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SFCO2_T_VEG'
  YCOMMENT='X_Y_'//YRECFM//' (kgCO2.M-2.S-1)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSFCO2_VEG(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SFCO2_T_BLD'
  YCOMMENT='X_Y_'//YRECFM//' (kgCO2.M-2.S-1)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSFCO2_BLD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SFCO2_T_RD'
  YCOMMENT='X_Y_'//YRECFM//' (kgCO2.M-2.S-1)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSFCO2_RD(:),IRESP,HCOMMENT=YCOMMENT)
  !
  YRECFM='SFCO2_T_POP'
  YCOMMENT='X_Y_'//YRECFM//' (kgCO2.M-2.S-1)'
  CALL WRITE_SURF(HSELECT,HPROGRAM,YRECFM,DMT%XSFCO2_POP(:),IRESP,HCOMMENT=YCOMMENT)

  !
  !-------------------------------------------------------------------------------
  !
  !         End of IO
  !
  CALL END_IO_SURF_n(HPROGRAM)
  !
END IF
!
IF (LHOOK) CALL DR_HOOK('WRITE_DIAG_MISC_TEB_N',1,ZHOOK_HANDLE)
!
END SUBROUTINE WRITE_DIAG_MISC_TEB_n
