!     #########
    SUBROUTINE SEWER(PTSTEP,                                            &
                     PWG, PD,                                           &
                     PWSAT_ROAD, PWWILT_ROAD, PCONDSAT_ROAD,            &
                     PDENSITY_SEWER,  KLAYER_SEWER, PIP_SEWER,          &
                     PCOND_ROAD,                                        &
                     PRUNOFF                                            )
!   ##########################################################################
!
!!****  *SEWER*  
!!
!!    PURPOSE
!!    -------
!
!     Computes the evolution of infiltration in sewers from soil water in urbanized areas.
!         
!!**  METHOD
!     ------
!
!   (evacuation system, typical time scale: ???? day)
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!      
!!    REFERENCE
!!    ---------
!!      
!!    AUTHOR
!!    ------
!!
!!      JM Brun     04/12   ** IFSTTAR **
!!
!!    MODIFICATIONS
!!    -------------
!!
!!      Original    08/12 
!!      
!-------------------------------------------------------------------------------
!
!*       0.     DECLARATIONS
!               ------------
USE MODD_ISBA_PAR,     ONLY : XWGMIN
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!---------------------------------------------
!*      0.1    declarations of arguments
!---------------------------------------------
!
REAL,                    INTENT(IN)    :: PTSTEP          ! Time step
REAL,    DIMENSION(:,:), INTENT(INOUT) :: PWG             ! water reservoir (m3/m3)
REAL,    DIMENSION(:,:), INTENT(IN)    :: PD              ! soil layer thickness  (m)
REAL,    DIMENSION(:,:), INTENT(IN)    :: PWSAT_ROAD      ! water content at saturation
REAL,    DIMENSION(:,:), INTENT(IN)    :: PWWILT_ROAD     ! wilting point volumetric water content profile
REAL,    DIMENSION(:,:), INTENT(IN)    :: PCONDSAT_ROAD   ! hydraulic conductivity at saturation    (m/s)
REAL,    DIMENSION(:),   INTENT(IN)    :: PDENSITY_SEWER  ! Total sewer length density (-)
INTEGER, DIMENSION(:),   INTENT(IN)    :: KLAYER_SEWER    ! Ground layer where the sewer is located (-)
REAL,                    INTENT(IN)    :: PIP_SEWER       ! Max capacity of water storage on roads
REAL,    DIMENSION(:,:), INTENT(IN)    :: PCOND_ROAD      ! hydraulic conductivity (m/s)
REAL,    DIMENSION(:)  , INTENT(OUT)   :: PRUNOFF         ! sewer runoff (kg/m2/s)
!
!---------------------------------------------
!*      0.2    declarations of local variables
!---------------------------------------------
!*
INTEGER                        :: JLAYER          ! Loop local variables
INTEGER                        :: JWRK,JWRK2      ! loop counter
INTEGER                        :: LGD             ! Infiltration Calculation Method
REAL                           :: ZWG, ZINFIL_SEWER, ZCOND_ROAD

REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*      1.     Initialisation
!              --------------
!                                           
IF (LHOOK) CALL DR_HOOK('SEWER',0,ZHOOK_HANDLE)
!
! Initialization
!
PRUNOFF(:) = 0.0
!
! Option for calculation
!
!
ZWG = 0.
ZINFIL_SEWER = 0.
!
DO JWRK=1,SIZE(PD,1)
!
  IF (KLAYER_SEWER(JWRK).GT.0) THEN
!
!*      2.     Calculation of the soil water infiltration rate into the sewer
!              --------------------------------------------------------------
!
    ZCOND_ROAD   = MIN(PCOND_ROAD(JWRK,KLAYER_SEWER(JWRK)),PCONDSAT_ROAD(JWRK,KLAYER_SEWER(JWRK)))
    ZINFIL_SEWER = ZCOND_ROAD*PIP_SEWER*PDENSITY_SEWER(JWRK)
!
!*      3.     Calculation of the new soil water content
!              ----------------------------------------- 
!
!   New soil water content according to the water quantity that joins the sewer
    ZWG = PTSTEP * ZINFIL_SEWER / PD(JWRK,KLAYER_SEWER(JWRK))
    PWG(JWRK,KLAYER_SEWER(JWRK)) = PWG(JWRK,KLAYER_SEWER(JWRK)) - ZWG
!
    IF  (PWG(JWRK,KLAYER_SEWER(JWRK)) < XWGMIN) THEN
      PRUNOFF(JWRK) = (ZINFIL_SEWER -                           &
                      (XWGMIN-PWG(JWRK,KLAYER_SEWER(JWRK)))*    &
                      PD(JWRK,KLAYER_SEWER(JWRK))/PTSTEP)*1000.
      PWG(JWRK,KLAYER_SEWER(JWRK)) = XWGMIN
    ELSE
      PRUNOFF(JWRK) = ZINFIL_SEWER*1000.        ! (kg/m2/s)
    ENDIF
!
  ENDIF
!
ENDDO
!
!
IF (LHOOK) CALL DR_HOOK('SEWER',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE SEWER
